-- PirateSpeak by Blaquen - Black DragonFlight - lkraven@gmail.com
-- Updated to 2.0 compatability by Imyself <The Shadow Lords> - Lothar 
-- Thanks and acknowledgement to 
-- History:
-- 1.4  Fixed to make 2.0 compatable. 
-- 	Full credit goes to aboom @ Arthas of the German version for the "fixed code"
-- 1.3  Fixed 's pattern to only reflect active verbs and not possessive contractions.
---     Patched to the latest version of WOW
---     Toggle switch added
---     Readme.txt added to package, first general release.
---     Fixed Blizzard anti-link editing bug.  Shift-linking an item would force an exit from WoW if PirateSpeak tried to edit the link.
-- 1.2
-- *	Fixed "hey" pattern so it wouldn't trigger on "they".
-- *	Fixed "ng" pattern to only trigger on "ing" (was triggering on LONG)
-- *	Added "thanks", "gonna" patterns. 
-- 1.1
-- *	Added channel specific parsers independent of the global toggle.
-- 	    /ps, /psay, /pp, pg, etc.
-- *	Removed cheesy profanity filter.  Pirates should curse like a sailor, anyway, shouldn't they?
-- *	added a few more terms: haha, jk, brb 
-- 1.0 Release
-- (If you can call it that)

function pirate_speak_onload()
--	this:RegisterEvent("VARIABLES_LOADED");

	if (pirate_talk_on == nil ) then
		pirate_talk_on = 1;
	end
	
	SlashCmdList["PIRATESPEAKTOGGLE"] = pirate_toggle;
	SLASH_PIRATESPEAKTOGGLE1 = "/piratespeak";
	SLASH_PIRATESPEAKTOGGLE2 = "/pspeak";
	SlashCmdList["PSAY"] = pirate_say;
	SLASH_PSAY1 = "/ps";
	SLASH_PSAY2 = "/psay";
	SlashCmdList["PYELL"] = pirate_yell;
	SLASH_PYELL1 = "/py";
	SLASH_PYELL2 = "/pyell";
	SlashCmdList["PPARTY"] = pirate_party;
	SLASH_PPARTY1 = "/pp";
	SLASH_PPARTY2 = "/pparty";
	SlashCmdList["PGUILD"] = pirate_guild;
	SLASH_PGUILD1 = "/pg";
	SLASH_PGUILD2 = "/pguild";
	if( DEFAULT_CHAT_FRAME ) then
		DEFAULT_CHAT_FRAME:AddMessage("PirateSpeak loaded. Yaar, guildtalk like a pirate!")
	end
end


-- Blizzard function to be hooked

local PirateSpeak_OldSendChatMessage = SendChatMessage;

function SendChatMessage(msg, system, language, chatnumber) 
    if (pirate_talk_on == 1 and msg ~= "" and (string.find(msg, "%[") == nil)) then 
	if ( string.find(msg, "^%/") == nil ) then
	    msg = piratespeak(msg);
	end
    end
    PirateSpeak_OldSendChatMessage(msg, system, language, chatnumber)
end 


function prepend_pirate(inputString)
	local phrase_array = {
	"Arr! ",
	"Avast! ",
	"Shiver me timbers! ",
	"Ahoy! ",
	"Begad! ",
	"Yarr! ",
	"Blimey! ",
	"Me hearties! ",
	"No quarter! ",
	"Sail ho! ",
	"Sink me! ",
	}
	inputString = phrase_array[math.random(table.getn(phrase_array))]..inputString
	return inputString
end

function append_pirate(inputString)
	local phrase_array = {
		", ye scurvy dog",
		", matey",
		", or I not be a pirate.  Arrr",
		", by the briny deep",
		", arrrr",
		", landlubber",
		", arrr",
		", arr",
		", yarrr",
		", yarr",
		", thar she blows",
		", scurvy scum",
		", swabby",
		", ye old dog",
		", ye dog",
		", salty dog",
		", savvy"
	}
	
	inputString = string.gsub(inputString, '([%.%!%?])', phrase_array[math.random(table.getn(phrase_array))].."%1",1)
	return inputString
end

function sub_pirate(inputString)
	local sub_array = {
		{o={"hello","hiya","^hi there"}, r={"ahoy","avast","ahoy thar"}},
		{o={"^hi "}, r={"ahoy ","avast ","ahoy thar "}},
		{o={" hi "}, r={"ahoy ","avast ","ahoy thar "}}, 
		{o={"^hey[a]?"}, r={"ahoy","avast","ahoy thar"}},
		{o={"thanks", "thank you"}, r={"ye have me gratitude", "i be in yer debt", "thank ye kindly"}},
		{o={"([%A%s])[Hh]e"}, r={"%1%'e"}},
		{o={"^he"}, r={"'e"}},
		{o={" are "," is ", " am "}, r={" be "}},
		{o={"^is ", "^are ", "^am "}, r={"be "}},
		{o={"i'm"}, r={"i be"}},
		{o={"y[eu][sp]"}, r={"aye"}},
		{o={"idiotic","crazy","insane","stupid"}, r={"addled","boozled","bamboozled"}},
		{o={"rear"}, r={"aft"}},
		{o={"loot"}, r={"booty","swag","treasure"}},
		{o={"sea","ocean"}, r={"briny deep","wide blue"}},
		{o={"bosses"}, r={"cap'ns"}},
		{o={"sir","boss","leader"}, r={"cap%'n"}},
		{o={"fool","moron","jerk","dork","idiot"}, r={"blaggard","sea scum","addlepate","scurvy mutt","damn fool","landlubber"}},
		{o={"sword"}, r={"cutlass","blade"}}, 
		{o={"dagger"}, r={"kitchen blade", "dirk"}},
		{o={"mace"}, r={"bludgeon", "wooden leg"}},
		{o={"axe"}, r={"sharp broomstick", "cleaver"}},
		{o={"my "}, r={"me "}},
		{o={"your"}, r={"yar"}},
		{o={"you%'re"}, r={"yar"}},
		{o={"you"}, r={"ye"}},
		{o={"beer","wine","vodka","booze"}, r={"grog","mead","rum","ale"}},
		{o={" hit"}, r={" flog"," slug"}},
		{o={"quickly"}, r={"smartly"}},
		{o={"flagged"}, r={"black marked"}},
		{o={"^np","no problem"}, r={"it be nothin'", "it be no mattar"}},
		{o={"auction house"}, r={"swag exchange", "loot market"}},
		{o={"^ah$"}, r={"swag exchange", "loot market"}},
		{o={" ah$"}, r={" swag exchange", " loot market"}},
		{o={" ah "}, r={" swag exchange", " loot market" }},
		{o={"flag"}, r={"Jolly Roger"}},
		{o={"lady","girl","chick","woman"}, r={"lass","lassie","wench"}},
		{o={"boy"}, r={"laddy"}},
		{o={"guys"}, r={"hearties","merry crew"}},
		{o={"copper"}, r={"fool%'s gold"}},
		{o={"silver"}, r={"pieces o%' eight"}},
		{o={"attack"}, r={"pillage"}},
		{o={" of "}, r={" 'o "}},
		{o={"kill"}, r={"keelhaul","marder"}},
		{o={"omw"}, r={"i be comin'","still yer sails, I be comin'"}},
		{o={"jk","j%/k"}, r={"it war a joke.","i be keedin'","a joke, matey"}},
		{o={"lol","hehe","haha"}, r={"that tickles me wooden leg!", "har har!", "that war funny! har!", "me sides are splittin' in laughter!", "haaar!", "I be laughin'!"}},
		{o={"afk","brb"}, r={"I be steppin out far a sec", "i be right back", "man the wheel, I be returnin' in a blink"}},
		{o={"gp"}, r={"doubloons"}},
		{o={"where"}, r={"whar"}},
		{o={"let's"}, r={"let us"}},
		{o={"(%w+)'s (%w+)ing"}, r={"%1 be %2in'"}},
		{o={"(%d)s"}, r={"%1 pieces o%' eight"}},
		{o={"ing "}, r={"in' "}},
		{o={"(%d)g"}, r={"%1 doubloons"}},
		{o={"there"}, r={"thar"}},
		{o={"was"}, r={"war"}},
		{o={"gonna"}, r={"goin' ta"}},
		{o={"die"}, r={"go to Davy Jones's locker", "head to a watery grave", "be in Davy's grip"}},
		{o={"dead"}, r={"gone to Davy Jones's locker","headed to a watery grave", "be in Davy's grip"}}
	}

	local cur_sub = {}
	
	inputString = string.gsub(inputString, "(%s)", inject_pirate)
	
	for i = 1, table.getn( sub_array ) do
		cur_sub['o']=sub_array[i]['o']
		cur_sub['r']=sub_array[i]['r']
		for y = 1, table.getn(cur_sub.o) do
			local searchPtn = cur_sub.o[y]
			inputString = string.gsub(inputString, searchPtn, cur_sub.r[math.random(table.getn(cur_sub.r))])
			if ( string.find(searchPtn, "%%") == nil ) then 
				inputString = string.gsub(inputString, string.gsub(searchPtn, "%l", string.upper,1), string.gsub(cur_sub.r[math.random(table.getn(cur_sub.r))], "%l", string.upper,1))
			end
			if ( string.find(searchPtn, "%%") == nil ) then 
				inputString = string.gsub(inputString, string.gsub(searchPtn, "%l", string.upper), string.gsub(cur_sub.r[math.random(table.getn(cur_sub.r))], '%l', string.upper))
			end
		end
	end
	return inputString
end

function inject_pirate(inputString)
	if ( math.random(100) > 98 ) then
		inputString = ", yarrr, "
	end
	return inputString
end

function piratespeak(x)
	x = sub_pirate(x)
	if (math.random(100) > 75 ) then
		x = append_pirate(x)
	else
		if(math.random(100) > 50) then
			x = x .. " Arrr!"
		end
	end
	if ( math.random(100) > 75 ) then
		x = prepend_pirate(x)
	end
	return x;
end

function pirate_toggle(toggle)
	if ( toggle == "on" ) then
		pirate_talk_on = 1
		DEFAULT_CHAT_FRAME:AddMessage("Pirate talk in on. Arr!")
	elseif ( toggle == "off" ) then
			pirate_talk_on = 0
			DEFAULT_CHAT_FRAME:AddMessage("Pirate talk is off.  Arr. :(")
	else
		DEFAULT_CHAT_FRAME:AddMessage("/pspeak (on|off): toggle global pirate talk\n/ps,/psay: say something in pirate\n/py,/pyell: yell something in pirate\n/pp,/pparty: party talk something in pirate\n/pg, /pguild: guildtalk in pirate\n")
	end
end

function pirate_say(x)
	x = piratespeak(x)
	SendChatMessage(x);
end

function pirate_yell(x)
	x = piratespeak(x)
	SendChatMessage(x,"YELL");
end

function pirate_party(x)
	x = piratespeak(x)
	SendChatMessage(x,"PARTY");
end

function pirate_guild(x)
	x = piratespeak(x)
	SendChatMessage(x,"GUILD");
end
