--Startup variables

defaultDelay=15;
petInfoToggle="Off";
alertHungry="On";
alertHungrySound="On";
piTooltip="On";
piVersion="v1.06.";
elapsedTime = 0;

--SimpleFrame.Hide();

--Colour variables
MyfontGreen = "|cff00ff00";
MyfontRed = "|cfff60000";
MyfontGold = "|cffffcc00";
MyfontWhite = "|cffffffff";


--Slash commands
SLASH_TESTRANGECOMMAND1 = "/testrange";
SlashCmdList["TESTRANGECOMMAND"] = function(msg) testrange() end

SLASH_PETINFOCOMMAND1 = "/petinfo";
SLASH_PETINFOCOMMAND2 = "/pi";
SlashCmdList["PETINFOCOMMAND"] = function(msg) PetInfo() end


function PetInfo() --Shows/hides options panel 
	
	if (petInfoToggle=="Off") then
		petInfoToggle="On";
		SimpleFrame:Show();
	else
		petInfoToggle="Off";
		SimpleFrame:Hide();
	end
end


function Hungertext()--Toggles hunger text

	if (alertHungry=="Off") then
		alertHungry="On";
		DEFAULT_CHAT_FRAME:AddMessage(MyfontWhite.."Pet Info hunger text "..MyfontGreen.."enabled");
	else
		alertHungry="Off";
		DEFAULT_CHAT_FRAME:AddMessage(MyfontWhite.."Pet Info hunger text "..MyfontRed.."disabled");
	end
	
end


function Hungeraudio()--Toggles hunger audio

	if (alertHungrySound=="Off") then
		alertHungrySound="On";
		DEFAULT_CHAT_FRAME:AddMessage(MyfontWhite.."Pet Info hunger audio "..MyfontGreen.."enabled");
	else
		alertHungrySound="Off";
		DEFAULT_CHAT_FRAME:AddMessage(MyfontWhite.."Pet Info hunger audio "..MyfontRed.."disabled");
	end
	
end


function Tooltiptoggle() --Toggles tooltip

	if (piTooltip=="Off") then
		piTooltip="On";
		DEFAULT_CHAT_FRAME:AddMessage(MyfontWhite.."Pet Info tooltip "..MyfontGreen.."enabled");
	else
		piTooltip="Off";
		DEFAULT_CHAT_FRAME:AddMessage(MyfontWhite.."Pet Info tooltip "..MyfontRed.."disabled");
	end
	
end


function Petinfoframe_OnLoad() -- Register events
	this:RegisterEvent("VARIABLES_LOADED");		
end


function Petinfoframe_OnEvent(event)

	if (event == "VARIABLES_LOADED") then -- Startup message
		
			DEFAULT_CHAT_FRAME:AddMessage(MyfontGreen.."Pet Info "..piVersion.." Type /pi for options. Hold ALT while over pet for stats." );
			optionsTitle:SetText(MyfontGold.."Pet Info "..piVersion);
			
			if (piTooltip=="On") then
				tooltipCheckButton:SetChecked(true);	
			else
				tooltipCheckButton:SetChecked(false);
			end	
			
			if (alertHungry=="On") then
				textCheckButton:SetChecked(true);	
			else
				textCheckButton:SetChecked(false);
			end	
			
			if (alertHungrySound=="On") then
				audioCheckButton:SetChecked(true);	
			else
				audioCheckButton:SetChecked(false);
			end

			frequencySlider:SetValue(defaultDelay);
			piDelay=frequencySlider:GetValue();
			
	end	
end



function setSliderText()
	getglobal(frequencySlider:GetName().."Text"):SetText("Alert Frequency ("..frequencySlider:GetValue()..") secs");
	defaultValue=frequencySlider:GetValue();
end



function petinfoHunger(elapsed) -- timer to display hunger alerts

	elapsedTime = elapsedTime + elapsed;
	
	local playerClass, englishClass = UnitClass("player");
	if (playerClass == "Hunter") then
		if (elapsedTime >= piDelay) then
			elapsedTime = 0;
		
			if (HasPetUI()) then -- Check if player has pet

				if (GetPetHappiness() < 3) then -- Check if pet is hungry

					if (UnitIsDeadOrGhost("pet") ~= 1) then -- Don't tell me my dead pet is hungry...

						if (alertHungry=="On") then
								DEFAULT_CHAT_FRAME:AddMessage(MyfontRed..UnitName("pet").." is hungry!!!");
						end
						
						if (alertHungrySound=="On") then
								PlaySoundFile("Interface\\AddOns\\Petinfo\\food.mp3");
						end
					end
				end 
			end	
		end
	end
end
 


function petinfo_Tooltips() -- update tooltips with pet info when mouse is over pet
	

	local playerClass, englishClass = UnitClass("player");
	if (playerClass == "Hunter") then	
		if (HasPetUI()) then -- Check if player has pet

			if (UnitName("mouseover") == UnitName("pet") ) then -- Check if mouse is over pet
				
				if (piTooltip=="On") then
					
					if IsAltKeyDown() ~= 1 then
						
						--Set tooltip
						GameTooltip:SetText(MyfontGreen..UnitName("pet"));
						GameTooltip:AddLine(MyfontWhite..UnitName("player").."'s Pet");
						--GameTooltip:AddLine(MyfontWhite.."Time remaining = "..GetPetTimeRemaining()); --doesn't work, think this is no longer active
						GameTooltip:AddLine(MyfontWhite.."Level "..UnitLevel("pet"));
						GameTooltip:AddLine(MyfontGold.."Loyalty: "..MyfontWhite..GetPetLoyalty());
						--GameTooltip:AddLine(MyfontGold.."Happiness: "..MyfontWhite..GetPetHappiness()); --happiness level; not really needed.
						local currXP, nextXP = GetPetExperience(); 
						GameTooltip:AddLine(MyfontGold.."XP: "..MyfontWhite..currXP.."/"..nextXP);
						GameTooltip:AddLine(MyfontGold.."Eats: "..MyfontWhite..BuildListString(GetPetFoodTypes()));
						local totalPoints, pointsSpent = GetPetTrainingPoints();
						local remainingPoints = totalPoints-pointsSpent;
						GameTooltip:AddLine(MyfontGold.."Available training points: "..MyfontWhite..remainingPoints); 
						GameTooltip:Show();
					
				else -- Alt key is down: Show pet stats

						--Set tooltip			
						GameTooltip:SetText(MyfontGreen..UnitName("pet"));
						GameTooltip:AddLine(MyfontWhite..UnitName("player").."'s Pet");
						GameTooltip:AddLine(MyfontWhite.."Level "..UnitLevel("pet"));
						
						local base1, stat1, posBuff1, negBuff1 = UnitStat("pet", 1); -- str
						GameTooltip:AddLine(MyfontGold.."Strength: "..MyfontWhite..stat1);
						
						local base2, stat2, posBuff2, negBuff2 = UnitStat("pet", 2); -- agi
						GameTooltip:AddLine(MyfontGold.."Agility: "..MyfontWhite..stat2);
						
						local base3, stat3, posBuff3, negBuff3 = UnitStat("pet", 3); -- sta
						GameTooltip:AddLine(MyfontGold.."Stamina: "..MyfontWhite..stat3);
						
						local base4, stat4, posBuff4, negBuff4 = UnitStat("pet", 4); -- int
						GameTooltip:AddLine(MyfontGold.."Intellect: "..MyfontWhite..stat4);
						
						local base5, stat5, posBuff5, negBuff5 = UnitStat("pet", 5); -- spi
						GameTooltip:AddLine(MyfontGold.."Spirit: "..MyfontWhite..stat5);
						
						local base6, posBuff6, negBuff6 = UnitAttackPower("pet"); -- AP
						local actualAP = base6 + posBuff6 +negBuff6;
						GameTooltip:AddLine(MyfontGold.."Attack Power: "..MyfontWhite..actualAP);
						
						local lowDmg, hiDmg, offlowDmg, offhiDmg, posBuff7, negBuff7, percentmod = UnitDamage("pet"); -- damage
						local damageRange = (floor(lowDmg).." - "..ceil(hiDmg));
						GameTooltip:AddLine(MyfontGold.."Damage: "..MyfontWhite..damageRange);
						
						local base9, effectiveArmor, armor, posBuff9, negBuff9 = UnitArmor("pet"); -- armour
						GameTooltip:AddLine(MyfontGold.."Armor: "..MyfontWhite..effectiveArmor);
						GameTooltip:Show();	
						
					end
				end
			end 
		end
	end
end


function Simple_Close()
SimpleFrame:Hide();
petInfoToggle="Off";
end

function testrange(spell)
	
	inRange = IsSpellInRange(spell,"target")
	if (inRange == 1) then
		DEFAULT_CHAT_FRAME:AddMessage("In range!!");
	
	elseif (inRange == 0) then
		DEFAULT_CHAT_FRAME:AddMessage("Out of range!!");
	
	else
		DEFAULT_CHAT_FRAME:AddMessage("No target");
	end
end


