--------------------------------------------------------
--
-- Version 2.4.h
--
--  Coding prep for WotLK.  Cleaned up the variables
--  and made them more user friendly.
--
--------------------------------------------------------
--
-- Version 2.4.g
--
--  Grimnar and Keekyo of Icecrown pointed out a 
--  conflict with a variable name and a couple of 
--  his other addons.  Renamed the variable not to 
--  interfere with the calls.
--
--------------------------------------------------------
--
-- Version 2.4.f
--
-- Correct a small calculation error that happens once
-- every blue moon.
--
--------------------------------------------------------
--
-- Version 2.4.e
--
-- Attempt At optimizing memory usage to use even less memory
--
--------------------------------------------------------

PetExp2 = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0")
PetExp2:RegisterDB("PetExp2DB","PetExp2DBPerChar")
PetExp2:RegisterDefaults("profile", {
	frame = 1,
	} )
 
function PetExp2:OnInitialize()
end

local PetExpCurrent = 0
local PetExpMaxForNextLevel = 0
local PetExpOld = 0
local PetExpChange = 0
local PetExpPercentGain = 0
local PetExpPercentLeft = 0
local PetExpForNextLevel = 0
local PetFirstKill = "Yes"

local PetPetLevelCurrent = 0
local PetLevelNext = 0

local PetDispalyColor = {
	PetLightColor = "|cffffff78",
	PetMediumColor = "|cffffff1b",
	PetDarkColor = "|cffff9e05",
-- filler space
}


function PetExp2:OnEnable()
self:RegisterEvent("UNIT_PET_EXPERIENCE","DISPALY_EXPERIENCE")
--self:RegisterEvent("PLAYER_XP_UPDATE","DISPALY_EXPERIENCE")
self:ScanExperience()
end

function PetExp2:OnDisable()
end
local options = {
		type = "group",
		desc = "Displays experience gains.",
		args = {
			set = {
				type = "text",
				name = "set",
				desc = "Set the output chatframe.",
				get = "GetChatFrame",
				set = "SetChatFrame",
				usage = "ChatFrame#",
				},
			},
		}
function PetExp2:GetChatFrame()
	return self.db.profile.frame
end

PetExp2:RegisterChatCommand({"/PetExp2","/pe2"},options)
function PetExp2:SetChatFrame(frameNum)
	frameNum = tonumber(frameNum)
	if type(frameNum) == "number" then
		if getglobal("ChatFrame"..frameNum) then
			self:Print("Now using ChatFrame"..frameNum)
			getglobal("ChatFrame"..frameNum):AddMessage(PetDispalyColor.PetMediumColor.."PetExp2: "..PetDispalyColor.PetLightColor.."Using this chat frame for Experience messages now!")	
			self.db.profile.frame = frameNum;
		else
			self:Print("ChatFrame"..frameNum.." is not a valid ChatFrame!")
		end
	end
end

function PetExp2:DISPALY_EXPERIENCE()
	self:ScanExperience()
	if PetFirstKill ~= "Yes" then
  	if PetExpChange ~= 0 then
	   	getglobal("ChatFrame"..self.db.profile.frame):AddMessage(PetDispalyColor.PetDarkColor.."PetExp2: "..PetDispalyColor.PetDarkColor.."+"..PetExpChange..PetDispalyColor.PetMediumColor.." XP"..PetDispalyColor.PetLightColor.." - "..PetDispalyColor.PetDarkColor..PetExpCurrent..PetDispalyColor.PetLightColor.." of "..PetDispalyColor.PetDarkColor..PetExpMaxForNextLevel..PetDispalyColor.PetLightColor.." to "..PetDispalyColor.PetMediumColor.."lvl "..PetDispalyColor.PetDarkColor..PetLevelNext..PetDispalyColor.PetLightColor.." ("..PetDispalyColor.PetDarkColor..PetExpForNextLevel..PetDispalyColor.PetLightColor.." xp left)"..PetDispalyColor.PetLightColor.." ("..PetDispalyColor.PetDarkColor..RepsToNextLevel..PetDispalyColor.PetLightColor.." reps)")
  	end
  else
	   	getglobal("ChatFrame"..self.db.profile.frame):AddMessage(PetDispalyColor.PetDarkColor.."PetExp2: Pet Exp will be displayed on next kill")
	   	PetFirstKill = "No"
  end
end

function PetExp2:ScanExperience()
	PetExpCurrent, PetExpMaxForNextLevel = GetPetExperience();
	PetExpChange = PetExpCurrent - PetExpOld
  PetExpForNextLevel = PetExpMaxForNextLevel - PetExpCurrent
	PetExpPercentGain = (PetExpCurrent/PetExpMaxForNextLevel)*100
	PetExpPercentLeft = (PetExpForNextLevel/PetExpMaxForNextLevel)*100
	PetExpOld = PetExpCurrent
	
	PetLevelCurrent = UnitLevel("pet")
	PetLevelNext = PetLevelCurrent + 1

	if PetExpChange == 0 then
		RepsToNextLevel = 0
	else	
		RepsToNextLevel = (floor(PetExpForNextLevel/PetExpChange)) + 1
	end

end
