local L = AceLibrary("AceLocale-2.2"):new("PetBar")
local inCombat = false

L:RegisterTranslations("enUS", function() return {
	["PetBar"] = true,
	["Config"] = true,
	["Set Config"] = true,
	["Scale"] = true,
	["Set Scale"] = true,
	["Alpha"] = true,
	["Set Alpha"] = true,
	["Button"] = true,
	["Select button displayed"] = true,
	["Show %s button"] = true,
	["Bar Config"] = true,
	["Set Bar Appearnce"] = true,
	["Direct"] = true,
	["Set Direct"] = true,
	["Vertical"] = true,
	["Horizontal"] = true,
	["Order"] = true,
	["Set Order"] = true,
	["Normal"] = true,
	["Reverse"] = true,
	["Show"] = true,
	["Config %s Button"] = true,
	["Adjust button order"] = true,
	["Binding"] = true,
	["Set %s button binding key"] = true,
	["Help"] = true,
	["To move bar, Ctrl+Right Drag button\nTo change button order, use button show function."] = true,
} end)

L:RegisterTranslations("koKR", function() return {
	["PetBar"] = "펫바",
	["Config"] = "설정",
	["Set Config"] = "설정을 변경합니다",
	["Scale"] = "크기",
	["Set Scale"] = "크기를 조절합니다",
	["Alpha"] = "투명도",
	["Set Alpha"] = "투명도를 조절합니다",
	["Button"] = "버튼",
	["Select button displayed"] = "버튼의 표시 여부를 선택합니다",
	["Show %s button"] = "%s 버튼을 표시합니다",
	["Bar Config"] = "바 설정",
	["Set Bar Appearnce"] = "바의 외양을 설정합니다",
	["Direct"] = "방향",
	["Set Direct"] = "바의 방향을 설정합니다",
	["Vertical"] = "수직",
	["Horizontal"] = "수평",
	["Order"] = "순서",
	["Set Order"] = "버튼의 배열 순서를 설정합니다",
	["Normal"] = "정상",
	["Reverse"] = "역순",
	["Show"] = "표시",
	["Config %s Button"] = "%s 버튼에 대한 설정을 변경합니다",
	["Adjust button order"] = "버튼의 순서를 조정합니다",
	["Binding"] = "단축키",
	["Set %s button binding key"] = "%s 버튼에 대한 단축키를 설정합니다",
	["Help"] = "도움말",
	["To move bar, Ctrl+Right Drag button\nTo change button order, use button show function."] = "바를 이동하기 위해서는 버튼을 Ctrl 우클릭으로 드래그 하세요.\n버튼 순서를 조정하기 위해서는 버튼 표시 기능을 활용하세요.",
} end)

L:RegisterTranslations("zhTW", function() return {   --by 米奈希爾@馭雷
   ["PetBar"] = "PetBar寵物技能",
   ["Config"] = "設置",
   ["Set Config"] = "設定配置",
   ["Scale"] = "大小比例",
   ["Set Scale"] = "設定比例",
   ["Alpha"] = "透明度",
   ["Set Alpha"] = "設定透明度",
   ["Button"] = "按鈕",
   ["Select button displayed"] = "選擇按鈕顯示方式",
   ["Show %s button"] = "顯示 %s 按鈕",
   ["Bar Config"] = "長條棒配置",
   ["Set Bar Appearnce"] = "Set Bar Appearnce",
   ["Direct"] = "方向",
   ["Set Direct"] = "設定方向",
   ["Vertical"] = "垂直",
   ["Horizontal"] = "排列方向",
   ["Order"] = "順序",
   ["Set Order"] = "設定順序",
   ["Normal"] = "一般",
   ["Reverse"] = "反向排列",
   ["Show"] = "顯示",
   ["Config %s Button"] = "設置 %s 按鈕",
   ["Adjust button order"] = "調整按鈕順序",
   ["Binding"] = "快捷鍵",
   ["Set %s button binding key"] = "設定 %s 快捷鍵",
   ["Help"] = "説明",
   ["To move bar, Ctrl+Right Drag button\nTo change button order, use button show function."] = "To move bar, Ctrl+Right Drag button\nTo change button order, use button show function.",
} end)


L:RegisterTranslations("zhCN", function() return {  --by 米奈希爾@馭雷
   ["PetBar"] = "PetBar宠物技能",
   ["Config"] = "设置",
   ["Set Config"] = "设定配置",
   ["Scale"] = "大小比例",
   ["Set Scale"] = "设定比例",
   ["Alpha"] = "透明度",
   ["Set Alpha"] = "设定透明度",
   ["Button"] = "按钮",
   ["Select button displayed"] = "选择按钮显示方式",
   ["Show %s button"] = "显示 %s 按钮",
   ["Bar Config"] = "长条棒配置",
   ["Set Bar Appearnce"] = "Set Bar Appearnce",
   ["Direct"] = "方向",
   ["Set Direct"] = "设定方向",
   ["Vertical"] = "垂直",
   ["Horizontal"] = "排列方向",
   ["Order"] = "顺序",
   ["Set Order"] = "设定顺序",
   ["Normal"] = "一般",
   ["Reverse"] = "反向排列",
   ["Show"] = "显示",
   ["Config %s Button"] = "设置 %s 按钮",
   ["Adjust button order"] = "调整按钮顺序",
   ["Binding"] = "快捷键",
   ["Set %s button binding key"] = "设定 %s 快捷键",
   ["Help"] = "帮助",
   ["To move bar, Ctrl+Right Drag button\nTo change button order, use button show function."] = "To move bar, Ctrl+Right Drag button\nTo change button order, use button show function.",
} end)

local BS = AceLibrary("Babble-Spell-2.2")
PetBar = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0");


local PetBarOptionTable = {
	name = L["PetBar"],
	desc = L["PetBar"],
	type = "group",
	args = {
		Help = {
			name = L["Help"],
			desc = L["Help"],
			type = 'execute',
			func = function()
				PetBar:Print(L["To move bar, Ctrl+Right Drag button\nTo change button order, use button show function."])
			end,
		},
		Config = {
			name = L["Config"],
			desc = L["Set Config"],
			type = "group",
			args = {
				Scale = {
					name = L["Scale"],
					desc = L["Set Scale"],
					type = "range",
					min = 0.1,
					max = 2.5,
					step = 0.1,
					get = function() return PetBar.db.profile.Scale end,
					set = function(v)
						PetBar.db.profile.Scale = v
						PetBar:SetUp()
						PetBarFrame:Show();
					end,
				},
				Alpha = {
					name = L["Alpha"],
					desc = L["Set Alpha"],
					type = "range",
					min = 0.0,
					max = 1.0,
					step = 0.05,
					get = function() return PetBar.db.profile.Alpha end,
					set = function(v)
						PetBar.db.profile.Alpha = v
						PetBar:SetUp()
						PetBarFrame:Show();
					end,
				},
				Bar = {
					name = L["Bar Config"],
					desc = L["Set Bar Appearnce"],
					type = "group",
					args = {
						Direct = {
							name = L["Direct"],
							desc = L["Set Direct"],
							type = "text",
							get = function() return PetBar.db.profile.Direct end,
							set = function(v) 
								PetBar.db.profile.Direct = v
								PetBar:SetUp()
								PetBarFrame:Show();
							end,
							validate = {["Vertical"] = L["Vertical"], ["Horizontal"] = L["Horizontal"]}
						},
						Order = {
							name = L["Order"],
							desc = L["Set Order"],
							type = "text",
							get = function() return PetBar.db.profile.Reverse end,
							set = function(v) 
								PetBar.db.profile.Reverse = v
								PetBar:SetUp()
								PetBarFrame:Show();
							end,
							validate = {["Normal"] = L["Normal"], ["Reverse"] = L["Reverse"]}
						},
					},
				},
				Button = {
					name = L["Button"],
					desc = L["Select button displayed"],
					type = 'group',
					args = {
						Mend = {
							name = BS["Mend Pet"],
							desc = (L["Config %s Button"]):format( BS["Mend Pet"]),
							order = 1,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Mend Pet"]),
									disabled = function() return InCombatLockdown() end,
									type = 'toggle',
									get = function() return PetBar.db.profile.Mend.Show end,
									set = function()
										PetBar.db.profile.Mend.Show = not PetBar.db.profile.Mend.Show
										PetBar:SetButtonNum(PetBar.db.profile.Mend.Show, BS["Mend Pet"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Mend Pet"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Mend Pet"]) end,
									set = function(v)
										PetBar:SetBinding(BS["Mend Pet"], v)
									end,
								},
							},
						},
						Call = {
							name = BS["Call Pet"],
							desc = (L["Config %s Button"]):format( BS["Call Pet"]),
							order = 2,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Call Pet"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return PetBar.db.profile.Call.Show end,
									set = function()
										PetBar.db.profile.Call.Show = not PetBar.db.profile.Call.Show
										PetBar:SetButtonNum(PetBar.db.profile.Call.Show, BS["Call Pet"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Call Pet"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Call Pet"]) end,
									set = function(v)
										PetBar:SetBinding(BS["Call Pet"], v)
									end,
								},
							},
						},
						Dismiss = {
							name = BS["Dismiss Pet"],
							desc = (L["Config %s Button"]):format( BS["Dismiss Pet"]),
							order = 3,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Dismiss Pet"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return PetBar.db.profile.Dismiss.Show end,
									set = function()
										PetBar.db.profile.Dismiss.Show = not PetBar.db.profile.Dismiss.Show
										PetBar:SetButtonNum(PetBar.db.profile.Dismiss.Show, BS["Dismiss Pet"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Dismiss Pet"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Dismiss Pet"]) end,
									set = function(v)
										PetBar:SetBinding(BS["Dismiss Pet"], v)
									end,
								},
							},
						},
						Revive = {
							name = BS["Revive Pet"],
							desc = (L["Config %s Button"]):format( BS["Revive Pet"]),
							order = 4,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Revive Pet"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return PetBar.db.profile.Revive.Show end,
									set = function()
										PetBar.db.profile.Revive.Show = not PetBar.db.profile.Revive.Show
										PetBar:SetButtonNum(PetBar.db.profile.Revive.Show, BS["Revive Pet"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Revive Pet"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Revive Pet"]) end,
									set = function(v)
										PetBar:SetBinding(BS["Revive Pet"], v)
									end,
								},
							},
						},
						Feed = {
							name = BS["Feed Pet"],
							desc = (L["Config %s Button"]):format( BS["Feed Pet"]),
							order = 5,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Feed Pet"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return PetBar.db.profile.Feed.Show end,
									set = function()
										PetBar.db.profile.Feed.Show = not PetBar.db.profile.Feed.Show
										PetBar:SetButtonNum(PetBar.db.profile.Feed.Show, BS["Feed Pet"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Feed Pet"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Feed Pet"]) end,
									set = function(v)
										PetBar:SetBinding(BS["Feed Pet"], v)
									end,
								},
							},
						},
						Tame = {
							name = BS["Tame Beast"],
							desc = (L["Config %s Button"]):format( BS["Tame Beast"]),
							order = 6,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Tame Beast"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return PetBar.db.profile.Tame.Show end,
									set = function()
										PetBar.db.profile.Tame.Show = not PetBar.db.profile.Tame.Show
										PetBar:SetButtonNum(PetBar.db.profile.Tame.Show, BS["Tame Beast"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Tame Beast"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Tame Beast"]) end,
									set = function(v)
										PetBar:SetBinding(BS["Tame Beast"], v)
									end,
								},
							},
						},
						Eyes = {
							name = BS["Eyes of the Beast"],
							desc = (L["Config %s Button"]):format( BS["Eyes of the Beast"]),
							order = 7,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Eyes of the Beast"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return PetBar.db.profile.Eyes.Show end,
									set = function()
										PetBar.db.profile.Eyes.Show = not PetBar.db.profile.Eyes.Show
										PetBar:SetButtonNum(PetBar.db.profile.Eyes.Show, BS["Eyes of the Beast"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Eyes of the Beast"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Eyes of the Beast"]) end,
									set = function(v)
										PetBar:SetBinding(BS["Eyes of the Beast"], v)
									end,
								},
							},
						},
						Training = {
							name = BS["Beast Training"],
							desc = (L["Config %s Button"]):format( BS["Beast Training"]),
							order = 8,
							type = 'group',
							args = {
								Show = {
									name = L["Show"],
									desc = (L["Show %s button"]):format(BS["Beast Training"]),
									type = 'toggle',
									disabled = function() return InCombatLockdown() end,
									get = function() return PetBar.db.profile.Training.Show end,
									set = function()
										PetBar.db.profile.Training.Show = not PetBar.db.profile.Training.Show
										PetBar:SetButtonNum(PetBar.db.profile.Training.Show, BS["Beast Training"])
									end
								},
								Binding = {
									name = L["Binding"],
									desc = (L["Set %s button binding key"]):format(BS["Beast Training"]),
									type = 'text',
									validate = 'keybinding',
									disabled = function() return InCombatLockdown() end,
									get = function() return GetBindingKey("SPELL "..BS["Beast Training"]) end,
									set = function(v)
										PetBar:SetBinding(BS["Beast Training"], v)
									end,
								},
							},
						},
					},
				},
			},
		},
	}
}

function PetBar:OnInitialize()
	local defaults = {
		Scale = 1,
		Alpha = 1,
		Direct = "Horizontal",
		Reverse = "Normal",
		Mend = {Show = true, Order = 1},
		Call = {Show = true, Order = 2},
		Dismiss = {Show = true, Order = 3},
		Revive = {Show = true, Order = 4},
		Feed = {Show = true, Order = 5},
		Tame = {Show = true, Order = 6},
		Eyes = {Show = true, Order = 7},
		Training = {Show = true, Order = 8},
		Number = 8,
		PetList = {
			[1] = BS["Mend Pet"],
			[2] = BS["Call Pet"],
			[3] = BS["Dismiss Pet"],
			[4] = BS["Revive Pet"],
			[5] = BS["Feed Pet"],
			[6] = BS["Tame Beast"],
			[7] = BS["Eyes of the Beast"],
			[8] = BS["Beast Training"],
			[9] = nil,
		}
	}

	self:RegisterDB("PetBarDB")
	self:RegisterDefaults('profile', defaults)
	self:RegisterChatCommand('/Petbar', PetBarOptionTable)

	PetBar:SetUp()
end

function PetBar:SetTooltip()
	if (this:GetAttribute("id")) then
		GameTooltip_SetDefaultAnchor(GameTooltip, this);
		GameTooltip:SetSpell(this:GetAttribute("id"), SpellBookFrame.bookType);
		GameTooltip:Show();
	end
end

function PetBar:SetButtonNum(value, asp)
	if value == true then
		PetBar.db.profile.Number = PetBar.db.profile.Number  + 1
		if not PetBar.db.profile.PetList then
			PetBar.db.profile.PetList = { }
		end
		PetBar.db.profile.PetList[PetBar.db.profile.Number] = asp
--		tinsert(PetBar.db.profile.PetList, PetBar.db.profile.Number, asp)
		getglobal("PetBarButton"..PetBar.db.profile.Number):Show()
	else
		PetBar.db.profile.Number = PetBar.db.profile.Number  - 1
		getglobal("PetBarButton"..PetBar.db.profile.Number + 1):Hide()
		for k, v in pairs(PetBar.db.profile.PetList) do
			if v == asp then
--				tremove(PetBar.db.profile.PetList, k)
				for i = k, 8 do
					PetBar.db.profile.PetList[i] = PetBar.db.profile.PetList[i+1]
				end
			end
		end
	end
	PetBar:UPDATE()
end

function PetBar:SetBinding(asp, bind)
	local clear1, clear2 = GetBindingKey("SPELL "..asp)
	if clear1 then
		SetBinding(clear1)
	end
	if clear2 then
		SetBinding(clear2)
	end
	SetBinding(bind)
	SetBindingSpell(bind, asp)
	SaveBindings(GetCurrentBindingSet())
end

function PetBar:SetOrder(as, o)
	
end

function PetBar:GetSpellID(spell, rank)
	local i = 1;
	local spellID, highestRank;
	while true do
		local spellName, spellRank = GetSpellName(i, SpellBookFrame.bookType);
		if (not spellName) then
			break;
		end
		if (spellName == spell) then
			if (rank) then
				if (spellRank == rank) then
					return i;
				end
			else
				spellID = i;
				highestRank = spellRank;
			end
		end
		i = i + 1;
		if (i > 250) then
			break;
		end
	end			
	return spellID, highestRank;
end

function PetBar:OnEnable()
	self:RegisterEvent("SPELLS_CHANGED", "UPDATE")
	self:RegisterEvent("PLAYER_AURAS_CHANGED", "UPDATE")
	self:RegisterEvent("SPELL_UPDATE_COOLDOWN")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
end

function PetBar:PLAYER_REGEN_ENABLED()
	inCombat = false
end

function PetBar:PLAYER_REGEN_DISABLED()
	inCombat = true
end

function PetBar:SetUp()
	-- This function cannot be performed in combat.
        if (InCombatLockdown() == nil) then
		if (PetBar.db.profile) then
			if PetBar.db.profile.Number > 1 then
				if (PetBar.db.profile.Direct == "Vertical" and PetBar.db.profile.Reverse == "Normal") then
					for i = 2, PetBar.db.profile.Number do
						local button = getglobal("PetBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("TOP", "PetBarButton"..i - 1, "BOTTOM", 0, 1);
					end
				elseif (PetBar.db.profile.Direct == "Vertical" and PetBar.db.profile.Reverse == "Reverse") then
					for i = 2, PetBar.db.profile.Number do
						local button = getglobal("PetBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("BOTTOM", "PetBarButton"..i - 1, "TOP", 0, 1);
					end
				elseif (PetBar.db.profile.Direct == "Horizontal" and PetBar.db.profile.Reverse == "Normal") then
					for i = 2, PetBar.db.profile.Number do
						local button = getglobal("PetBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("LEFT", "PetBarButton"..i - 1, "RIGHT", 1, 0);
					end
				elseif (PetBar.db.profile.Direct == "Horizontal" and PetBar.db.profile.Reverse == "Reverse") then
					for i = 2, PetBar.db.profile.Number do
						local button = getglobal("PetBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("RIGHT", "PetBarButton"..i - 1, "LEFT", 1, 0);
					end
				else
					for i = 2, PetBar.db.profile.Number do
						local button = getglobal("PetBarButton"..i);
						button:ClearAllPoints();
						button:SetPoint("LEFT", "PetBarButton"..i - 1, "RIGHT", 1, 0);
					end
				end
			end
			if PetBar.db.profile.Scale then
				PetBarFrame:SetScale(PetBar.db.profile.Scale)
			else
				PetBarFrame:SetScale(1)
			end
			if PetBar.db.profile.Alpha then
				PetBarFrame:SetAlpha(PetBar.db.profile.Alpha)
			else
				PetBarFrame:SetAlpha(1)
			end

		end
	end
end

function PetBar:UPDATE()
	local i, button, p, l;
	if (PetBar.db.profile and not inCombat ) then
		i = 0;
		-- This function cannot be performed in combat.
		if (InCombatLockdown() == nil) then
			for key in pairs(PetBar.db.profile.PetList) do
				if getglobal("PetBarButton"..key) then
					getglobal("PetBarButton"..key):Hide();
				end
			end
			PetBar:SetUp()
			PetBarFrame:Show();
		end
		for key, value in pairs(PetBar.db.profile.PetList) do
			local id = PetBar:GetSpellID(value);
			if (id) then
				i = i + 1;
 				button = getglobal("PetBarButton"..i);
				-- This function cannot be performed in combat.
        			if (InCombatLockdown() == nil) then
					if button then
						button:SetAttribute("type", "spell");
						button:SetAttribute("spell", value);
					end
				end

  				local texture = GetSpellTexture(id, BOOKTYPE_SPELL);
				for z = 0, 7 do
					if (GetPlayerBuffTexture(z) == texture) then
						texture = "Interface\\Icons\\Spell_Nature_WispSplode";
					end
				end
				if button then
					getglobal("PetBarButton"..i.."Icon"):SetTexture(texture);
					button:SetAttribute("id",id);

					-- This function cannot be performed in combat.
					if (InCombatLockdown() == nil) then
						if ( i > PetBar.db.profile.Number ) then
							button:SetAlpha(0);
							button:Hide();
						else
							button:Show();
							button:SetAlpha(PetBar.db.profile.Alpha)
						end
					end
				end
			end
		end
		-- This function cannot be performed in combat.
		if ((i == 0) and (InCombatLockdown() == nil)) then
			PetBarFrame:Hide();
		end
	end
end

function PetBar:SPELL_UPDATE_COOLDOWN()
	for i = 1, PetBar.db.profile.Number do
		button = getglobal("PetBarButton"..i);
		if (button:GetAttribute("id")) then
			local cooldown = getglobal(button:GetName().."Cooldown");
			local start, duration, enable = GetSpellCooldown(button:GetAttribute("id"), SpellBookFrame.bookType);
			if (start > 0 and duration > 0) then
				cooldown:SetCooldown(start, duration);
			end
		end
	end
end