--[[-------------------------------------------------------------------------
  Copyright (c) 2008, Jim Whitehead II <cladhaire@gmail.com>
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above
        copyright notice, this list of conditions and the following
        disclaimer in the documentation and/or other materials provided
        with the distribution.
      * Neither the name of PerfectRaid nor the names of its contributors 
        may be used to endorse or promote products derived from this software
        without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
---------------------------------------------------------------------------]]

local Config = PerfectRaid:NewModule("PerfectRaid-Config")
local L = PerfectRaidLocals
local utils, frames

function Config:Initialize()
	self:RegisterMessage("DONGLE_PROFILE_CREATED")
	self:RegisterMessage("PERFECTRAID_TAB_CHANGED")
end

function Config:Enable()
	-- Toggle party visibility
	self:PartyVisibility()
end

local options
function Config:CreateOptions(opt)
	options = CreateFrame("Frame", "PROptions_Config", PROptions)

	local tab = opt:AddOptionsTab("Config", options)

	options.widgets = {}

	local check = CreateFrame("CheckButton", "PRConfig_HideParty", options, "PRCheckTemplate")
	check.Label:SetText(L["Hide Blizzard Party Frames"])
	table.insert(options.widgets, check)

	local check = CreateFrame("CheckButton", "PRConfig_ShowManaOnly", options, "PRCheckTemplate")
	check.Label:SetText(L["Only show mana bar for mana users"])
	table.insert(options.widgets, check)

	local check = CreateFrame("CheckButton", "PRConfig_ClickCast", options, "PRCheckTemplate")
	check.Label:SetText(L["Enable click-casting on frames"])
	table.insert(options.widgets, check)

	local check = CreateFrame("CheckButton", "PRConfig_Lock", options, "PRCheckTemplate")
	check.Label:SetText(L["Lock frames"])
	table.insert(options.widgets, check)

	local cancel = CreateFrame("Button", "PRConfig_Cancel", options, "PRButtonTemplate")
	cancel:SetText(L["Cancel"])
	cancel:SetPoint("BOTTOMRIGHT", 0, 5)
	cancel:SetScript("OnClick", function() options:CancelOptions() end)
	cancel:Show()
	
	local save = CreateFrame("Button", "PRConfig_Save", options, "PRButtonTemplate")
	save:SetText(L["Save"])
	save:SetPoint("BOTTOMRIGHT", cancel, "BOTTOMLEFT", -10, 0)
	save:SetScript("OnClick", function() options:SaveOptions() end)
	save:Show()

	function options:SaveOptions()
		local hideParty = PRConfig_HideParty:GetChecked() and true or false
		local showMana = PRConfig_ShowManaOnly:GetChecked() and true or false
		local clickCast = PRConfig_ClickCast:GetChecked() and true or false
		local locked = PRConfig_Lock:GetChecked() and true or false

		PerfectRaid.db.profile.hideparty = hideParty
		PerfectRaid.db.profile.showmanaonly = showMana
		PerfectRaid.db.profile.clickcast = clickCast
		PerfectRaid.db.profile.locked = locked

		Config:PartyVisibility()
	end

	function options:CancelOptions()
		PRConfig_HideParty:SetChecked(PerfectRaid.db.profile.hideparty)
		PRConfig_ShowManaOnly:SetChecked(PerfectRaid.db.profile.showmanaonly)
		PRConfig_ClickCast:SetChecked(PerfectRaid.db.profile.clickcast)
		PRConfig_Lock:SetChecked(PerfectRaid.db.profile.locked)
	end

	options:SetScript("OnShow", function() options:CancelOptions() end)
	options:Hide()

	for idx,widget in ipairs(options.widgets) do
		widget:Show()
		if idx == 1 then
			widget:SetPoint("TOPLEFT", 0, 0)
		else
			widget:SetPoint("TOPLEFT", options.widgets[idx - 1], "BOTTOMLEFT", 0, -15)
		end
	end
end

local old_ShowPartyFrame = ShowPartyFrame
function Config:PartyVisibility()
	local hideparty = PerfectRaid.db.profile.hideparty
	if hideparty then
		-- Disable the party frames
		self.hidingparty = true
		for i=1,4 do
			local f = getglobal("PartyMemberFrame"..i)
			f:UnregisterAllEvents()
		end
		if PartyMemberBackground and SHOW_PARTY_BACKGROUND == "1" then
			PartyMemberBackground:Hide()
		end
		
		ShowPartyFrame = function() end
		HidePartyFrame()
	elseif self.hidingparty then
		self.hidingparty = false
		for i=1,4 do
			local f = getglobal("PartyMemberFrame"..i)
			f:RegisterEvent("PLAYER_ENTERING_WORLD");
			f:RegisterEvent("PARTY_MEMBERS_CHANGED");
			f:RegisterEvent("PARTY_LEADER_CHANGED");
			f:RegisterEvent("PARTY_MEMBER_ENABLE");
			f:RegisterEvent("PARTY_MEMBER_DISABLE");
			f:RegisterEvent("PARTY_LOOT_METHOD_CHANGED");
			f:RegisterEvent("MUTELIST_UPDATE");
			f:RegisterEvent("IGNORELIST_UPDATE");
			f:RegisterEvent("UNIT_FACTION");
			f:RegisterEvent("UNIT_AURA");
			f:RegisterEvent("UNIT_PET");
			f:RegisterEvent("VOICE_START");
			f:RegisterEvent("VOICE_STOP");
			f:RegisterEvent("VARIABLES_LOADED");
			f:RegisterEvent("VOICE_STATUS_UPDATE");
			f:RegisterEvent("READY_CHECK");
			f:RegisterEvent("READY_CHECK_CONFIRM");
			f:RegisterEvent("READY_CHECK_FINISHED");
		end
		if PartyMemberBackground and SHOW_PARTY_BACKGROUND == "1" then
			PartyMemberBackground:Show()
		end
		ShowPartyFrame = old_ShowPartyFrame
		ShowPartyFrame()
	end
end
