-- Name:	PeonMaster
-- Version:	0.4
-- Author:	Frigo, Horde, Suramar (EU)

-- ########### Chargement Principal
function PeonMaster_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED");
end

-- ########### Chargement Frame Principale
function PeonMaster_Head_OnLoad()
	this:RegisterForDrag("LeftButton");
	SlashCmdList["PEONSLASH"] = PeonMaster_PMSlash;
	SLASH_PEONSLASH1 = "/PeonMaster";
	SLASH_PEONSLASH2 = "/peonmaster";
	MAXORDER = 0;
	TAB_ORDER = {};
	DEFAULT_CHAT_FRAME:AddMessage(LOADED_MSG);
	PeonMaster_HeadText:SetText("PM v"..PM_VERSION);
end


-- ########### Appels aux commandes "/"
function PeonMaster_PMSlash(cmd)
	local args = {};
	args = PeonMaster_GetWords(cmd);
	if (args[1] == "show") then
		PeonMaster_Head:Show();
	elseif (args[1] == "hide") then
		PeonMaster_Head:Hide();
	else
		DEFAULT_CHAT_FRAME:AddMessage(HELP_MSG);
	end
end

-- ########### Chargement des boutons d'icones de raid/party
function PeonMaster_LoadIcon()
	this:RegisterForClicks("LeftButtonDown","RightButtonDown","MiddleButtonDown");
	local iconNAME 	= getglobal(this:GetName());
	local iconID 	= ICONS_TAB[this:GetName()].ICON_ID;
end

-- ########### Gestion des Clics sur les boutons d'icones de raid/party
function PeonMaster_OnClick(arg1)
	local curICON = ICONS_TAB[this:GetName()];
	local iconID = ICONS_TAB[this:GetName()].ICON_ID;
	if (arg1 == "LeftButton") then
		-- Clic gauche sur une icone : positionne l'icone sur une cible
		targetIcon=GetRaidTargetIndex("target");
		if (targetIcon ~= iconID) then
			SetRaidTarget("target", iconID);
		else
			SetRaidTarget("target", 0);
		end
	elseif (arg1 == "RightButton") then
		-- Clic droit sur une icone : remplissage du texte correspondant à l'icone avec le nom de l'unité selectionnée
		local curPlayer = getglobal(curICON.ICON_PLAYER_TEXT); 
		if (UnitExists("target")) then
			if (curPlayer:GetText() == UnitName("target")) then
				curPlayer:SetText("");
			else
				curPlayer:SetText(UnitName("target"));
			end
		end		
	end
	if (arg1 == "MiddleButton") then
	-- Clic milieu sur une icone : Donne le numero suivant dans l'ordre de down des cibles
		local curOrder = getglobal(curICON.ICON_KILLORDER); 
		if ( curOrder:GetText() ~= nil ) then
			PeonMaster_makeOrders(curOrder,"del");
		else
			PeonMaster_makeOrders(curOrder,"add");
		end

	end
end

-- ########### Reorganisation des numeros d'ordre
function PeonMaster_makeOrders(curOrder, action)
	if (action == "del") then
		for k,v in pairs(TAB_ORDER) do
			if (v == curOrder:GetName()) then
				toremove=k;
			end
		end
		table.remove(TAB_ORDER, toremove);
	elseif (action == "add") then
		table.insert(TAB_ORDER, curOrder:GetName());
		curOrder:SetText(table.getn(TAB_ORDER));
	end
	PeonMaster_refreshOrders();
end

-- ########### Rafraichit les numeros d'ordres de kill
function PeonMaster_refreshOrders()
	for var = 1, 8, 1 do
		local curOrder = getglobal(ICONS_TAB["PM_ico"..var].ICON_KILLORDER);
		curOrder:SetText("");
	end
	nbOrdres = table.getn(TAB_ORDER);
	for var = 1, nbOrdres, 1 do
		getglobal(TAB_ORDER[var]):SetText(var);
	end	
end

-- ########### Dit dans le canal raid/party les attributions pour chaque signe et l'ordre de kill
function PeonMaster_SayAll()

	-- Affectations
	local PM_orders1 = "";
	local TAB_CC = {}
	for var = 1, 8, 1 do
		curTexte = getglobal(ICONS_TAB["PM_ico"..var].ICON_PLAYER_TEXT):GetText();
		if curTexte then
			if(TAB_CC[curTexte] ~= nil) then
				TAB_CC[curTexte]=TAB_CC[curTexte].." "..ICONS_TAB["PM_ico"..var].MSG;
			else
				TAB_CC[curTexte]=ICONS_TAB["PM_ico"..var].MSG;
			end
		end 
	end
	table.foreach (TAB_CC, function(k,v) PM_orders1 = " "..PM_orders1..k..AFFECTATION_MSG..v.."   "; end); 
	if (PM_orders1 ~= "") then
		PM_orders1 = CONTROLE_MSG.." "..PM_orders1;
	end

	-- Ordres de kill
	local nbOrdres = table.getn(TAB_ORDER);
	local PM_orders2 = "";
	for var = 1, nbOrdres, 1 do
		local num = string.sub(TAB_ORDER[var], 13, -1);
		if (PM_orders2 ~= "") then
			PM_orders2 = PM_orders2.." > "..ICONS_TAB["PM_ico"..num].MSG;
		else
			PM_orders2 = KILL_ORDER_MSG.." "..ICONS_TAB["PM_ico"..num].MSG;
		end		
	end
	
	-- Output chat
	if (PM_orders1 ~= "") then
		sg(PM_orders1);
	end
	if (PM_orders2 ~= "") then
		sg(PM_orders2);
	end
end
-- ########### Dit dans le canal raid/party l'ordre de kill
function PeonMaster_SayOrder()
	-- Ordres de kill
	local nbOrdres = table.getn(TAB_ORDER);
	local PM_orders2 = "";
	for var = 1, nbOrdres, 1 do
		local num = string.sub(TAB_ORDER[var], 13, -1);
		if (PM_orders2 ~= "") then
			PM_orders2 = PM_orders2.." > "..ICONS_TAB["PM_ico"..num].MSG;
		else
			PM_orders2 = KILL_ORDER_MSG.." "..ICONS_TAB["PM_ico"..num].MSG;
		end		
	end
	if (PM_orders2 ~= "") then
		sg(PM_orders2);
	end	
end
-- ########### Dit dans le canal raid/party les attributions pour chaque signe
function PeonMaster_SayRoles()
	-- Affectations
	local PM_orders1 = "";
	local TAB_CC = {}
	for var = 1, 8, 1 do
		curTexte = getglobal(ICONS_TAB["PM_ico"..var].ICON_PLAYER_TEXT):GetText();
		if curTexte then
			if(TAB_CC[curTexte] ~= nil) then
				TAB_CC[curTexte]=TAB_CC[curTexte].." "..ICONS_TAB["PM_ico"..var].MSG;
			else
				TAB_CC[curTexte]=ICONS_TAB["PM_ico"..var].MSG;
			end
		end 
	end
	table.foreach (TAB_CC, function(k,v) PM_orders1 = " "..PM_orders1..k..AFFECTATION_MSG..v.."   "; end); 
	if (PM_orders1 ~= "") then
		PM_orders1 = CONTROLE_MSG.." "..PM_orders1;
	end
	-- Output chat
	if (PM_orders1 ~= "") then
		sg(PM_orders1);
	end	
end
-- ########### Dit en /w les attributions pour chaque signe
function PeonMaster_SayRolesW()
	-- Affectations
	local PM_orders1 = "";
	local TAB_CC = {}
	for var = 1, 8, 1 do
		curTexte = getglobal(ICONS_TAB["PM_ico"..var].ICON_PLAYER_TEXT):GetText();
		if curTexte then
			if(TAB_CC[curTexte] ~= nil) then
				TAB_CC[curTexte]=TAB_CC[curTexte].." "..ICONS_TAB["PM_ico"..var].MSG;
			else
				TAB_CC[curTexte]=ICONS_TAB["PM_ico"..var].MSG;
			end
		end 
	end
	table.foreach (TAB_CC, function(k,v) if (UnitIsPlayer(k)) then unitlang=GetDefaultLanguage(k); SendChatMessage(" "..PM_orders1..k..AFFECTATION_MSG..v, "WHISPER", unitlang, k); end end); 
end


-- ########### Reinitialise tout
function PeonMaster_ResetAll()
	PeonMaster_ResetRoles();
	PeonMaster_ResetOrder();
end
-- ########### Reinitialise les roles
function PeonMaster_ResetRoles()
	for var = 1, 8, 1 do
		getglobal(ICONS_TAB["PM_ico"..var].ICON_PLAYER_TEXT):SetText("");
	end
end
-- ########### Reinitialise l'ordre de kill
function PeonMaster_ResetOrder()
	TAB_ORDER = {};
	PeonMaster_refreshOrders();
end


-- ########### Minimize l'addon
function PeonMaster_Minimize()
	if PeonMaster:IsShown() then
		PeonMaster:Hide();
	else
		PeonMaster:Show();
	end
end


-- ########### Fonction de parsing de chaine sur le caractere " "
function PeonMaster_GetWords(str)
	local ret = {};
	local pos=0;
	while(true) do
		local word;
		_,pos,word=string.find(str, "^ *([^%s]+) *", pos+1);
		if(not word) then
			return ret;
		end
		table.insert(ret, word);
	end
end


-- ****************************************************
-- * AUTO-DIRECT CHAT MESSAGES * 
-- ****************************************************
-- * Function to auto-direct chat messages to say|party|raid|raidwarning channel depending on your 
-- * group status (all thanks to Thorbjorn, author of SendGroup)
-- * To use, uncomment the function below and for your ingame macros, use some version of the 
-- * following (English client, use single quotes for others): 
-- * /script sg("PutYourMessageHere"); 
--
function sg(m)
	if (UnitName("raid1")) then
		SendChatMessage(m,"RAID");
--		if ( IsRaidOfficer() ) then
--			SendChatMessage(m,"RAID_WARNING");
--			SendChatMessage(m,"RAID");
--		else
--			SendChatMessage(m,"RAID");
--		end
	elseif (UnitName("party1")) then
		--SendChatMessage(m,"RAID_WARNING");
		SendChatMessage(m,"PARTY");
	else
		-- SendChatMessage(m,"SAY");
		DEFAULT_CHAT_FRAME:AddMessage(m);
	end
end
