﻿--PassLoot 3.3 by Odlaw
PassLoot = LibStub("AceAddon-3.0"):NewAddon("PassLoot", "AceConsole-3.0", "AceEvent-3.0");
local L = LibStub("AceLocale-3.0"):GetLocale("PassLoot");
local defaults = {
  ["profile"] = {
    ["Quiet"] = false,
    ["Rules"] = {},
    ["Modules"] = {},
  },
};

function PassLoot:OnInitialize()
  -- Called when the addon is loaded
  LibStub("AceConsole-3.0"):RegisterChatCommand(L["PASSLOOT_SLASH_COMMAND"], function() PassLoot_MainFrame:Show() end);
  self.db = LibStub("AceDB-3.0"):New("PassLootDB", defaults, L["Default"]);
  self.db.RegisterCallback(self, "OnProfileChanged", "OnProfileChanged");
  self.db.RegisterCallback(self, "OnProfileCopied", "OnProfileChanged");
  self.db.RegisterCallback(self, "OnProfileReset", "OnProfileChanged");
  self.db.RegisterCallback(self, "OnProfileDeleted", "OnProfileNewOrDelete");
  self.db.RegisterCallback(self, "OnNewProfile", "OnProfileNewOrDelete");

  PanelTemplates_SetNumTabs(PassLoot_TabbedMenuContainer, 3);  -- 3 because there are 3 tabs total.
  PanelTemplates_SetTab(PassLoot_TabbedMenuContainer, 1);      -- 1 because we want tab 1 selected.
  PanelTemplates_UpdateTabs(PassLoot_TabbedMenuContainer);
  PassLoot_Profiles_CurrentProfile.initialize = function(level) PassLoot:DropDown_CurrentProfile_Init(level) end;
  PassLoot_Profiles_CopyProfile.initialize = function(level) PassLoot:DropDown_CopyProfile_Init(level) end;
  PassLoot_Profiles_DeleteProfile.initialize = function(level) PassLoot:DropDown_DeleteProfile_Init(level) end;
end

function PassLoot:OnEnable()
  -- Called when the addon is enabled
  self:RegisterEvent("START_LOOT_ROLL");
  PassLoot_MainFrame_ModEnabled:SetChecked(true);
  self:UpgradeDatabase();
  -- self:VerifyStructures("Global");
  self:Modules_ScrollFrame_Setup(); -- Creates Module header frames and lays them out in the scroll frame
  self:OnProfileChanged();
end

function PassLoot:OnDisable()
  -- Called when the addon is disabled
  self:UnregisterEvent("START_LOOT_ROLL");
  PassLoot_MainFrame_ModEnabled:SetChecked(false);
end

function PassLoot:OnProfileChanged()
  -- this is called every time your profile changes (after the change)
  self.CurrentRule = 0;
  self.CurrentOptionFilter = { nil, 0 }; -- Frame, line #
  -- self:VerifyStructures("Profile");
  PassLoot_MainFrame_Quiet:SetChecked(self.db.profile.Quiet);
  self:LoadModules();
  self:SendMessage("PassLoot_OnProfileChanged");
  -- Now that the modules have loaded and added profile widgets, we can update our Modules selection list with any profile widgets.
  self:Modules_ScrollFrame_Update();
  -- Now we check our rules to see if all variables are set.
  -- We could check profile variables, but some modules need more than just setting defaults, they need to act on them.
  self:CheckRuleTables();
  self:Rules_RuleList_OnScroll();
  self:DisplayCurrentRule();
  self:OnProfileNewOrDelete();
end

function PassLoot:OnProfileNewOrDelete()
  UIDropDownMenu_SetText(self.db:GetCurrentProfile(), PassLoot_Profiles_CurrentProfile);
  UIDropDownMenu_SetText("", PassLoot_Profiles_CopyProfile);
  UIDropDownMenu_SetText("", PassLoot_Profiles_DeleteProfile);
  PassLoot_Profiles_CopyProfile.value = nil;
  PassLoot_Profiles_DeleteProfile.value = nil;
end

function PassLoot:LoadModules()
  local Module;
  for ModuleKey, ModuleValue in self:IterateModules() do
    Module = ModuleValue:GetName();
    self.db.profile.Modules[Module] = self.db.profile.Modules[Module] or {};
    if ( self.db.profile.Modules[Module].Status == nil ) then
      self.db.profile.Modules[Module].Status = true;
    end
    if ( self.db.profile.Modules[Module].Status ~= ModuleValue.enabledState ) then
      if ( self.db.profile.Modules[Module].Status ) then
        ModuleValue:Enable();
      else
        ModuleValue:Disable();
      end
    end
  end
end

function PassLoot:START_LOOT_ROLL()
  local MatchedRule, Filter, StatusMsg, NumFilters;
  local Name;
  if ( self.TestLink ) then
    ItemLink = self.TestLink;
  else
    ItemLink = GetLootRollItemLink(arg1);
    -- _, Name, _, _, _ = GetLootRollItemInfo(arg1);
  end
  Name = GetItemInfo(ItemLink);
  PassLootTooltip:SetOwner(UIParent, "ANCHOR_NONE");
  PassLootTooltip:SetHyperlink(ItemLink);
  for WidgetKey, WidgetValue in ipairs(self.RuleWidgets) do
    WidgetValue:SetMatch(ItemLink, PassLootTooltip);
  end
  for RuleKey, RuleValue in ipairs(self.db.profile.Rules) do
    self:Debug("Checking rule "..RuleKey.." "..RuleValue.Desc);
    MatchedRule = true;
    for WidgetKey, WidgetValue in ipairs(self.RuleWidgets) do
      NumFilters = WidgetValue:GetNumFilters(RuleKey) or 0;
      if ( NumFilters > 0 ) then
        self:Debug("Checking filter "..WidgetValue.Info[1].." ("..NumFilters.." NumFilters)");
        Filter = false;
        for Index = 1, NumFilters do
          if ( WidgetValue:GetMatch(RuleKey, Index) ) then
            Filter = true;
            self:Debug("Filter matched");
            break;
          else
            self:Debug("Filter did not match");
          end
        end
        if ( not Filter ) then
          MatchedRule = false;
          break;
        end
      end
    end
    if ( MatchedRule ) then
      self:Debug("Matched rule");
      if ( not self.TestLink ) then
        if ( RuleValue.Loot == "pass" ) then
          RollOnLoot(arg1, 0);
        elseif ( RuleValue.Loot == "greed" ) then
          RollOnLoot(arg1, 2);
        elseif ( RuleValue.Loot == "need" ) then
          RollOnLoot(arg1, 1);
        end
      end
      if ( self.db.profile.Quiet == false ) then
        if ( RuleValue.Loot ~= "disabled" ) then
          StatusMsg = string.gsub(L["Rolling %status% on %item% (%rule%)"], "%%item%%", ItemLink);
          StatusMsg = string.gsub(StatusMsg, "%%status%%", RuleValue.Loot);
          StatusMsg = string.gsub(StatusMsg, "%%rule%%", RuleValue.Desc);
        else
          StatusMsg = string.gsub(L["Ignoring %item% (%rule%)"], "%%item%%", ItemLink);
          StatusMsg = string.gsub(StatusMsg, "%%rule%%", RuleValue.Desc);
        end
        self:Print(StatusMsg);
      end
      --We found the item, and rolled on it, so go ahead and quit.
      self:SendMessage("PassLoot_OnRoll", ItemLink, RuleKey);
      self.TestLink = nil;
      return;
    end --MatchedRule
    self:Debug("Rule not matched, trying another");
  end --RuleKey, RuleValue
  self:Debug("Ran out of rules, ignoring");
  self.TestLink = nil;
end

-- We make sure each rule has a default value
function PassLoot:CheckRuleTables()
  self.db.profile.Rules = self.db.profile.Rules or {};
  for RuleKey, RuleValue in pairs(self.db.profile.Rules) do
    for DefaultKey, DefaultValue in ipairs(self.DefaultTemplate) do
      if ( not RuleValue[DefaultValue[1]] ) then
        self.db.profile.Rules[RuleKey][DefaultValue[1]] = self:CopyTable(DefaultValue[2]);
      end
    end
  end
end

function PassLoot:Debug(...)
  local DebugLine, Counter;
  if ( self.DebugVar == true ) then
    DebugLine = "";
    for Counter = 1, select("#", ...) do
      DebugLine = DebugLine..select(Counter, ...);
    end
    self:Print(DebugLine);
  end
end

function PassLoot:UpgradeDatabase()
  -- Function to only change internal database
  -- Rule database stuff should be handled by each individual module.
  if ( ( not self.db.global.DBVersion and not PassLootDB.DBVersion ) or self.db.global.DBVersion == 7 ) then
self:Debug("DB Version 7 Found");
    self.db.global.DBVersion = nil;
    PassLootDB.DBVersion = 8;
  end
  if ( PassLootDB and PassLootDB.DBVersion ) then
    if ( PassLootDB.DBVersion < 10 ) then
      self:Debug("DB Version Pre-9 Found");
      -- No longer used, as all rule variables are handled by modules now.
      -- self:CheckAllRuleTables();
      PassLootDB.DBVersion = 10;
    end
  end
end

-- function PassLoot:VerifyStructures(Structure)
  -- if ( Structure == "Global" ) then
    -- if ( not self.db.global or type(self.db.global) ~= "table" ) then
      -- self:Debug("global = {}");
      -- self.db.global = {};
    -- end
    -- for Key, Value in pairs(self.db.global) do
      -- if ( not ( Key == "Modules" ) ) then
        -- self:Debug("global["..Key.."] = nil");
        -- self.db.global[Key] = nil;
      -- end
    -- end
    -- if ( not self.db.global.Modules or type(self.db.global.Modules) ~= "table" ) then
      -- self:Debug("global.Modules = {}");
      -- PassLoot.db.global.Modules = {};
    -- end
    -- for Key, Value in pairs(self.db.global.Modules) do
      -- if ( not Value or type(Value) ~= "table" ) then
        -- self:Debug("global.Modules["..Key.."] = {}");
        -- self.db.global.Modules[Key] = {};
      -- end
    -- end
  -- elseif ( Structure == "Profile" ) then
    -- if ( not self.db.profile or type(self.db.profile) ~= "table" ) then
      -- self:Debug("profile = {}");
      -- self.db.profile = {};
    -- end
    -- for Key, Value in pairs(self.db.profile) do
      -- if ( not ( Key == "Quiet" or Key == "Rules" or Key == "Modules" ) ) then
        -- self:Debug("profile["..Key.."] = nil");
        -- self.db.profile[Key] = nil;
      -- end
    -- end
    -- if ( not ( self.db.profile.Quiet == false or self.db.profile.Quiet == true ) ) then
      -- self:Debug("profile.Quiet = false");
      -- self.db.profile.Quiet = false
    -- end
    -- if ( not self.db.profile.Modules or type(self.db.profile.Modules) ~= "table" ) then
      -- self:Debug("profile.Modules = {}");
      -- self.db.profile.Modules = {};
    -- end
    -- if ( not self.db.profile.Rules or type(self.db.profile.Rules) ~= "table" ) then
      -- self:Debug("profile.Rules = {}");
      -- self.db.profile.Rules = {};
    -- end
    -- for Key, Value in pairs(self.db.profile.Rules) do
      -- if ( not tonumber(Key) or type(Value) ~= "table" ) then
        -- self:Debug("profile.Rules["..Key.."] = nil");
        -- self.db.profile.Rules[Key] = nil;
      -- end
    -- end
    -- --Rule specific in CheckRuleTables()
  -- end
-- end

-- ####### Structures ########
-- ## Main PassLoot DB structure ##
-- DB Version 10 structure:
-- PassLoot Global = {
  -- ["Modules"] = {
    -- ["ModuleName"] = {
      -- ["Version"] = 1,
    -- },
  -- },
-- }
-- PassLoot Profile = {
  -- ["Quiet"] = false,
  -- ["Rules"] = {
    -- {
      -- ["Desc"] = "Description",
      -- ["ModuleVar"] = ModuleValue,
      -- ["ModuleVar"] = ModuleValue,
    -- },
  -- },
  -- ["Modules"] = {
    -- ["ModuleName"] = {
      -- ["Status"] = true/false,
      -- ["ProfileVars"] = {},
    -- },
  -- },
-- };

-- ## Table format of Default Template when creating a new rule ##
-- # Also the format for registering the variables
-- PassLoot.DefaultTemplate = {
  -- { VariableName, Default },
  -- { VariableName, Default },
-- };

-- ## Plugin Lookup Table ##
-- This is a lookup only table, we do not delete entries from this table generated
-- # RuleVariables are created when a module uses RegisterDefaultVariables()
    -- Used as verification, as the only variables our module can access with GetConfigOption() and SetConfigOption()
    -- Also used in CheckDBVersion, as a list of variables to upgrade with the Callback function.
-- # RuleWidgets are created when a module uses AddWidget()
    -- Used as a list of widgets to remove from the PassLoot.RuleWidgets table.
    -- (PassLoot.RuleWidgets is a sorted table of all widgets to display)
-- # ProfileWidgets are created when a module uses AddProfileWidget()
    -- Used as the main table of profile widgets in Modules_ScrollFrame_Update().
    -- If the module is active and we have widgets, we show them, otherwise we HIDE them, do not delete them.
    -- WE DO NOT DELETE FROM THIS TABLE - We check for dupes in AddProfileWidget()
-- # ProfileHeader is created when PassLoot calls Modules_ScrollFrame_Setup() (when main addon is enabled)
    -- Used as the main table of module profile headers used in Modules_ScrollFrame_Update()
    -- Modules_ScrollFrame_Setup() also creates PassLoot.ModuleHeaders, which is used to display modules in the modules tab
-- PassLoot.PluginInfo = {
  -- [ModuleName] = {
    -- ["RuleVariables"] = {
      -- VariableName = true,
      -- VariableName = true,
    -- },
    -- ["RuleWidgets"] = {
      -- [1] = WidgetA,
      -- [2] = WidgetB,
    -- },
    -- ["ProfileWidgets"] = {
      -- [1] = WidgetA,
    -- },
    -- ["ProfileHeader"] = Frame,
  -- },
-- };

-- ## Main table of SORTED rule widgets to display ##
-- PassLoot.RuleWidgets = {
  -- WidgetA,
  -- WidgetB,
-- };

-- ## Module List in a SORTED order.  Actual headers in self.PluginInfo.ProfileHeader ##
-- PassLoot.ModuleHeaders = {
  -- "ModuleA",
  -- "ModuleB",
-- };

-- ## EnabledModuleList is a sorted list of enabled modules ##
-- PassLoot.EnabledModuleList = {
  -- "ModuleA",
  -- "ModuleC",
-- };