﻿local PassLoot = LibStub("AceAddon-3.0"):GetAddon("PassLoot");
-- Not using AceGUI until I decide to make my own multi-tier drop down menu widget.
-- local AceGUI = LibStub("AceGUI-3.0");

PassLoot.Prototypes = {};
PassLoot.PluginInfo = {};

-- Unused.  We can let the module unregister variables, and remove widgets from the filter list.
-- function PassLoot.Prototypes:OnDisable()
  -- ChatFrame1:AddMessage("OnDisable() Called for "..self:GetName());
  -- self:UnregisterDefaultVariables();
  -- self:RemoveWidgets();
-- end

-- Registers the default variables
-- RuleVariables = {
  -- { VariableName, Default},
  -- { VariableName, Default},
-- };
function PassLoot.Prototypes:RegisterDefaultVariables(RuleVariables)
  local Module = self:GetName();
  PassLoot.PluginInfo[Module] = PassLoot.PluginInfo[Module] or {};
  if ( type(RuleVariables) ~= "table" ) then
    return;
  end
  for NewKey, NewValue in pairs(RuleVariables) do
    if ( type(NewValue) ~= "table" ) then
      return;
    end
    for VariableKey, VariableValue in pairs(PassLoot.DefaultTemplate) do
      if ( NewValue[1] == VariableValue[1] ) then
        return;
      end
    end
  end
  PassLoot.PluginInfo[Module].RuleVariables = PassLoot.PluginInfo[Module].RuleVariables or {};
  for Key, Value in pairs(RuleVariables) do
    -- table.insert(PassLoot.PluginInfo[self:GetName()].RuleVariables, { Value[1], PassLoot:CopyTable(Value[2]) });
    PassLoot.PluginInfo[self:GetName()].RuleVariables[Value[1]] = true;
    -- table.sort(PassLoot.PluginInfo[self:GetName()].RuleVariables, function(A, B) if ( A[1] < B[1] ) then return true end end);
    table.insert(PassLoot.DefaultTemplate, { Value[1], PassLoot:CopyTable(Value[2]) });
  end
end

function PassLoot.Prototypes:UnregisterDefaultVariables()
  local Module = self:GetName();
  PassLoot.PluginInfo[Module] = PassLoot.PluginInfo[Module] or {};
  PassLoot.PluginInfo[Module].RuleVariables = PassLoot.PluginInfo[Module].RuleVariables or {};
  for RuleKey, RuleValue in ipairs(PassLoot.PluginInfo[Module].RuleVariables) do
    for DefaultKey, DefaultValue in ipairs(PassLoot.DefaultTemplate) do
      if ( DefaultValue[1] == RuleKey ) then
        table.remove(PassLoot.DefaultTemplate, DefaultKey);
        break;
      end
    end
  end
end

-- Each Widget is a filter for PassLoot.
-- Each Filter must have: (Index refers to the index of multiple filters for the same rule)
-- GetNumFilters(RuleNum) -- Returns the number of filters for the rule
-- AddNewFilter() -- Creates a new filter for the currently selected rule
-- RemoveFilter(Index) -- Removes a filter from the currently selected rule at Index
-- DisplayWidget(Index) -- Called when the Filter is selected from the active filters list.  (Needs to prepare/update the widget's display, does not need to do Widget:Show())
-- GetFilterText(Index) -- Gets text to be displayed for the active filter scroll frame for the Filter's Index
-- SetMatch(ItemLink, Tooltip) -- Called when a loot window is popped up with the itemlink and tooltip frame of the item.
-- GetMatch(RuleNum, Index) -- Needs to return true/false if the loot matches this filter's index.
function PassLoot.Prototypes:AddWidget(Widget)
  if ( type(Widget) ~= "table"
  or not Widget.GetNumFilters
  or not Widget.AddNewFilter
  or not Widget.RemoveFilter
  or not Widget.DisplayWidget
  or not Widget.GetFilterText
  or not Widget.SetMatch
  or not Widget.GetMatch
  or type(Widget.Info) ~= "table" ) then
    return;
  end
  PassLoot.RuleWidgets = PassLoot.RuleWidgets or {};
  for Key, Value in pairs(PassLoot.RuleWidgets) do
    if ( Value == Widget ) then
      return;
    end
  end
  local Module = self:GetName();
  Widget.PreferredPriority = Widget.PreferredPriority or 100;
  -- Widget.ModuleOwner = self:GetName();
  table.insert(PassLoot.RuleWidgets, Widget);
  -- PassLoot:Settings_ScrollFrame_Update();
  table.sort(PassLoot.RuleWidgets, function(a, b) if ( a.PreferredPriority < b.PreferredPriority ) then return true end end);
  Widget:ClearAllPoints();
  Widget:SetPoint("TOP", PassLoot_Rules_Settings, "BOTTOM", ((Widget.XPaddingLeft or 0) - (Widget.XPaddingRight or 0)) / 2, 65 + (Widget.YPaddingTop or 0));
  Widget:SetParent(PassLoot_Rules_Settings);
  Widget:Hide();
  PassLoot.PluginInfo[Module] = PassLoot.PluginInfo[Module] or {};
  PassLoot.PluginInfo[Module].RuleWidgets = PassLoot.PluginInfo[Module].RuleWidgets or {};
  for Key, Value in pairs(PassLoot.PluginInfo[Module].RuleWidgets) do
    if ( Value == Widget ) then
      return;
    end
  end
  table.insert(PassLoot.PluginInfo[Module].RuleWidgets, Widget);
end

function PassLoot.Prototypes:RemoveWidgets()
  local Module = self:GetName();
  PassLoot.PluginInfo[Module] = PassLoot.PluginInfo[Module] or {};
  PassLoot.PluginInfo[Module].RuleWidgets = PassLoot.PluginInfo[Module].RuleWidgets or {};
  for PluginKey, PluginValue in pairs(PassLoot.PluginInfo[Module].RuleWidgets) do
    for RuleKey, RuleValue in pairs(PassLoot.RuleWidgets) do
      if ( RuleValue == PluginValue ) then
        PluginValue:Hide();
        PluginValue:SetParent(nil);
        table.remove(PassLoot.RuleWidgets, RuleKey);
        break;
      end
    end
  end
end

function PassLoot.Prototypes:AddProfileWidget(Widget)
  local Module = self:GetName();
  PassLoot.PluginInfo[Module] = PassLoot.PluginInfo[Module] or {};
  PassLoot.PluginInfo[Module].ProfileWidgets = PassLoot.PluginInfo[Module].ProfileWidgets or {};
  for Key, Value in pairs(PassLoot.PluginInfo[Module].ProfileWidgets) do
    if ( Value == Widget ) then
      return;
    end
  end
  table.insert(PassLoot.PluginInfo[Module].ProfileWidgets, Widget);
  -- Call Update from either OnProfileChanged() or After enabling a module.
  -- PassLoot:Modules_ScrollFrame_Update();
  -- I don't need to remove profile widgets either, as we just hide them.  All PluginInfo[Module] is a list we lookup, do not delete from.
end

-- Sets a variable in the rule.  This function verifies that the variable being set is registered to the module.
function PassLoot.Prototypes:SetConfigOption(Variable, Value, RuleNum)
  local Module = self:GetName();
  RuleNum = RuleNum or PassLoot.CurrentRule
  if ( RuleNum > 0
  and Module
  and PassLoot.PluginInfo[Module]
  and PassLoot.PluginInfo[Module].RuleVariables ) then
    if ( PassLoot.PluginInfo[Module].RuleVariables[Variable] ) then
      PassLoot.db.profile.Rules[RuleNum][Variable] = Value;
      PassLoot:Rules_Settings_Filters_OnScroll();
      return;
    end
  end
end

-- Gets a variable from a rule.  This function does not verify that the variable belongs to the module.
function PassLoot.Prototypes:GetConfigOption(Variable, RuleNum)
  RuleNum = RuleNum or PassLoot.CurrentRule;
  if ( RuleNum > 0 ) then
    return PassLoot.db.profile.Rules[RuleNum][Variable];
  end
end

function PassLoot.Prototypes:SetProfileVariable(Variable, Value)
  local Module = self:GetName();
  if ( Module
  and PassLoot.db.profile.Modules
  and PassLoot.db.profile.Modules[Module] ) then
    PassLoot.db.profile.Modules[Module].ProfileVars = PassLoot.db.profile.Modules[Module].ProfileVars or {};
    PassLoot.db.profile.Modules[Module].ProfileVars[Variable] = Value;
  end
end

function PassLoot.Prototypes:GetProfileVariable(Variable)
  local Module = self:GetName();
  if ( Module
  and PassLoot.db.profile.Modules
  and PassLoot.db.profile.Modules[Module]
  and PassLoot.db.profile.Modules[Module].ProfileVars ) then
    return PassLoot.db.profile.Modules[Module].ProfileVars[Variable];
  end
end

PassLoot.Prototypes.ShowTooltip = PassLoot.ShowTooltip;

-- I am going to use this function to scroll text boxes to the left instead of SetCursorPosition()
-- SetCursorPosition(0) requires I ClearFocus(), which will create a loop that I don't really like.
PassLoot.Prototypes.ScrollLeft = PassLoot.ScrollLeft;

function PassLoot.Prototypes:Debug(...)
  local DebugLine, Counter;
  if ( PassLoot.DebugVar == true ) then
    DebugLine = "";
    for Counter = 1, select("#", ...) do
      DebugLine = DebugLine..select(Counter, ...);
    end
    PassLoot:Print(DebugLine);
  end
end

-- CheckDBVersion()
-- ModuleVersion - The version of the module calling this function.
-- CallbackFunc - Function to call to get a new value.
-- If the ModuleVersion is newer, then we will iterate over every rule.  We will call the callback function with the entire rule.
-- This will allow the update to get any variable data it wants from the rule to make decisions on.
-- ReturnData = {
  -- { VariableToBeSet, ValueToBeSet },
  -- { VariableToBeSet, ValueToBeSet },
-- }
-- All variables to be set will be verified that they are variables allowed to be set.
function PassLoot.Prototypes:CheckDBVersion(ModuleVersion, CallbackFunc)
  local Module = self:GetName();
  if ( Module
  and PassLoot.PluginInfo[Module]
  and PassLoot.PluginInfo[Module].RuleVariables
  and ModuleVersion
  and ( type(CallbackFunc) == "string" or type(CallbackFunc) == "function" ) ) then
    local Version, ReturnData, VariableList
    PassLoot.db.global.Modules = PassLoot.db.global.Modules or {};
    PassLoot.db.global.Modules[Module] = PassLoot.db.global.Modules[Module] or {};
    PassLoot.db.global.Modules[Module].Version = PassLoot.db.global.Modules[Module].Version or 1;
    Version = PassLoot.db.global.Modules[Module].Version;
    if ( Version >= ModuleVersion ) then
      return;
    end
    PassLoot:Debug("Upgrading: "..Module.." from "..Version.." to "..ModuleVersion);
    VariableList = PassLoot.PluginInfo[Module].RuleVariables;  -- Use only the variables that were defined.
    if ( PassLootDB and PassLootDB.profiles ) then
      for ProfileKey, ProfileValue in pairs(PassLootDB.profiles) do
        if ( ProfileValue.Rules ) then
          for RuleKey, RuleValue in ipairs(ProfileValue.Rules) do
            if ( type(CallbackFunc) == "string" ) then
              ReturnData = self[CallbackFunc](self, Version, RuleValue);
            elseif ( type(CallbackFunc) == "function" ) then
              ReturnData = CallbackFunc(Version, RuleValue);
            end
            if ( ReturnData and type(ReturnData) == "table" ) then
              for ReturnKey, ReturnValue in pairs(ReturnData) do
                if ( type(ReturnValue) == "table" and ReturnValue[1] and VariableList[ReturnValue[1]] ) then
                  PassLootDB.profiles[ProfileKey].Rules[RuleKey][ReturnValue[1]] = ReturnValue[2];
                end
              end -- ReturnKey, ReturnValue
            end
          end -- RuleKey, RuleValue
        end -- if ProfileValue.Rules
      end -- ProfileKey, ProfileValue
    elseif ( self.db and self.db.profile and self.db.profile.Rules ) then
      for RuleKey, RuleValue in ipairs(self.db.profile.Rules) do
        if ( type(CallbackFunc) == "string" ) then
          ReturnData = self[CallbackFunc](self, Version, RuleValue);
        elseif ( type(CallbackFunc) == "function" ) then
          ReturnData = CallbackFunc(Version, RuleValue);
        end
        if ( ReturnData and type(ReturnData) == "table" ) then
          for ReturnKey, ReturnValue in pairs(ReturnData) do
            if ( type(ReturnValue) == "table" and ReturnValue[1] and VariableList[ReturnValue[1]] ) then
              self.db.profile.Rules[RuleKey][ReturnValue[1]] = ReturnValue[2];
            end
          end -- ReturnKey, ReturnValue
        end
      end -- RuleKey, RuleValue
    end
    PassLoot.db.global.Modules[Module].Version = ModuleVersion;
  end
end

PassLoot:SetDefaultModulePrototype(PassLoot.Prototypes);
PassLoot:SetDefaultModuleState(false);

-- Function to place widgets on a content frame.
function PassLoot:PlaceWidgets(Frame, Widgets, TopBottomPadding, ColSpacing, RowSpacing)
  local FrameWidth = Frame:GetWidth();
  local CurrentHeight = TopBottomPadding;
  local RowSpaceLeft = FrameWidth - ColSpacing;
  local NumWidgetsInRow = 0;
  local MaxWidgetHeightForRow = 0;
  local WidgetHeight, WidgetWidth;
  for Key, Value in ipairs(Widgets) do
    Value:ClearAllPoints();
    WidgetHeight = Value.Height or Value:GetHeight() or 0;
    WidgetWidth = Value.Width or Value:GetWidth() or 0;
    if ( NumWidgetsInRow == 0 or (RowSpaceLeft - WidgetWidth) > ColSpacing ) then
      -- We have enough space for this widget we can place it.
      MaxWidgetHeightForRow = math.max(MaxWidgetHeightForRow, WidgetHeight);
      NumWidgetsInRow = NumWidgetsInRow + 1;
    else
      -- We don't have enough space, we need to increment the row, and add it
      CurrentHeight = CurrentHeight + MaxWidgetHeightForRow + RowSpacing;
      MaxWidgetHeightForRow = WidgetHeight;
      RowSpaceLeft = FrameWidth - ColSpacing;
      NumWidgetsInRow = 1;
    end
    Value:SetParent(Frame);
    Value:SetPoint("TOPLEFT", Frame, "TOPLEFT", FrameWidth - RowSpaceLeft, CurrentHeight * -1);
    RowSpaceLeft = RowSpaceLeft - WidgetWidth - ColSpacing;
    Value:Show();
  end
  CurrentHeight = CurrentHeight + MaxWidgetHeightForRow + TopBottomPadding;
  return CurrentHeight;
end

-- Function to create the Frame to contain the module's checkbox to enable/disable the module.
-- The frame will also house any profile widgets.
function PassLoot:Modules_CreateHeader()
  local Frame = CreateFrame("Frame");
  local Box = CreateFrame("Frame", nil, Frame);
  Box:SetPoint("TOPLEFT", Frame, "TOPLEFT", 0, 0);
  Box:SetPoint("BOTTOMRIGHT", Frame, "BOTTOMRIGHT", 0, 0);
  Box:SetBackdrop({
    ["edgeFile"] = "Interface\\Tooltips\\UI-Tooltip-Border",
    ["tile"] = false,
    ["edgeSize"] = 16, 
  });
  Frame.Box = Box;
  local Checkbox = CreateFrame("CheckButton", nil, Frame);
  Checkbox:SetHeight(24);
  Checkbox:SetWidth(24);
  Checkbox:SetPoint("TOPLEFT", Frame, "TOPLEFT", 5, 0);
  Checkbox:SetNormalTexture("Interface\\Buttons\\UI-CheckBox-Up");
  Checkbox:SetPushedTexture("Interface\\Buttons\\UI-CheckBox-Down");
  Checkbox:SetHighlightTexture("Interface\\Buttons\\UI-CheckBox-Highlight");
  -- Checkbox:SetDisabledCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check-Disabled");
  Checkbox:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check");
  Checkbox:SetScript("OnLeave", function() GameTooltip:Hide() end);
  Checkbox:SetScript("OnClick", function() self:Modules_OnClick() end);
  Checkbox:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Modules_Checkbox") end);
  Frame.Checkbox = Checkbox;
  local Text = Checkbox:CreateFontString(nil, "ARTWORK", "GameFontNormalSmall");
  Text:SetPoint("LEFT", Checkbox, "RIGHT", -2, 0);
  Checkbox.Text = Text;
  local Settings = CreateFrame("Frame", nil, Frame);
  Settings:SetPoint("TOPLEFT", Frame, "TOPLEFT", 0, Checkbox:GetHeight() * -1);
  Settings:SetPoint("BOTTOMRIGHT", Frame, "BOTTOMRIGHT", 0, 0);
  Settings:SetHeight(0);
  Settings:Hide();
  Frame.Settings = Settings;
  Frame:SetHeight(Checkbox:GetHeight() + Settings:GetHeight());
  Frame:SetParent(nil);
  return Frame;
end

-- Function to iterate through each module and create a header frame.
-- The frame is referenced from PassLoot.PluginInfo[Module].ProfileHeader
-- We layout the frames on our Scrolling frame's content frame.
local Modules_ScrollFrame_RowSpacing = 3;
local Modules_ScrollFrame_InitialHeight = 10;
function PassLoot:Modules_ScrollFrame_Setup()
  local Module;
  self.ModuleHeaders = {};
  for Key, Value in self:IterateModules() do
    Module = Value:GetName();
    table.insert(self.ModuleHeaders, Module);
    self.PluginInfo[Module] = self.PluginInfo[Module] or {};
    self.PluginInfo[Module].ProfileHeader = self.PluginInfo[Module].ProfileHeader or self:Modules_CreateHeader();
    self.PluginInfo[Module].ProfileHeader:ClearAllPoints();
    self.PluginInfo[Module].ProfileHeader.Checkbox.Value = Module;
    self.PluginInfo[Module].ProfileHeader.Checkbox.Text:SetText(Module);
  end
  table.sort(self.ModuleHeaders, function(a, b) if ( a < b ) then return true end end);
  local Content = PassLoot_Modules_ScrollFrame_Content;
  local RowSpacing = Modules_ScrollFrame_RowSpacing;
  local CurrentHeight = Modules_ScrollFrame_InitialHeight;
  local LastHeader;
  for Key, Value in ipairs(self.ModuleHeaders) do
    self.PluginInfo[Value].ProfileHeader:SetParent(Content);
    if ( not LastHeader ) then
      self.PluginInfo[Value].ProfileHeader:SetPoint("TOPLEFT", Content, "TOPLEFT", 5, CurrentHeight * -1);
      self.PluginInfo[Value].ProfileHeader:SetPoint("TOPRIGHT", Content, "TOPRIGHT", -5, CurrentHeight * -1);
    else
      self.PluginInfo[Value].ProfileHeader:SetPoint("TOPLEFT", LastHeader, "BOTTOMLEFT", 0, RowSpacing * -1);
      self.PluginInfo[Value].ProfileHeader:SetPoint("TOPRIGHT", LastHeader, "BOTTOMRIGHT", 0, RowSpacing * -1);
    end
    CurrentHeight = CurrentHeight + self.PluginInfo[Value].ProfileHeader:GetHeight() + RowSpacing;
    self.PluginInfo[Value].ProfileHeader:Show();
    self.PluginInfo[Value].ProfileHeader.Box:Hide();
    LastHeader = self.PluginInfo[Value].ProfileHeader;
  end
  CurrentHeight = CurrentHeight + Modules_ScrollFrame_InitialHeight;
  Content:SetHeight(CurrentHeight);
end

-- Iterate through each module, set the checkbox as to if it's enabled/disabled
-- Check if it has profile widgets and display them if module is enabled.
-- Update size of the profile scrollframe's content frame.
function PassLoot:Modules_ScrollFrame_Update()
  local RowSpacing, CurrentHeight, SettingsHeight;
  RowSpacing = Modules_ScrollFrame_RowSpacing;
  CurrentHeight = Modules_ScrollFrame_InitialHeight;
  for Key, Value in ipairs(self.ModuleHeaders) do
    if ( self.db.profile.Modules[Value].Status ) then
      -- Enabled module
      self.PluginInfo[Value].ProfileHeader.Checkbox:SetChecked(true);
      if ( self.PluginInfo[Value].ProfileWidgets ) then
        self.PluginInfo[Value].ProfileHeader.Box:Show();
        SettingsHeight = self:PlaceWidgets(self.PluginInfo[Value].ProfileHeader.Settings, self.PluginInfo[Value].ProfileWidgets, 10, 10, 5);
        self.PluginInfo[Value].ProfileHeader.Settings:SetHeight(SettingsHeight);
        self.PluginInfo[Value].ProfileHeader:SetHeight(SettingsHeight + self.PluginInfo[Value].ProfileHeader.Checkbox:GetHeight());
        self.PluginInfo[Value].ProfileHeader.Settings:Show();
      else
        self.PluginInfo[Value].ProfileHeader.Box:Hide();
        self.PluginInfo[Value].ProfileHeader.Settings:Hide();
      end
    else
      -- Disabled module
      self.PluginInfo[Value].ProfileHeader.Checkbox:SetChecked(false);
      self.PluginInfo[Value].ProfileHeader.Box:Hide();
      -- Hide all profile widgets if it has any.
      if ( self.PluginInfo[Value].ProfileWidgets ) then
        for WidgetKey, WidgetValue in pairs(self.PluginInfo[Value].ProfileWidgets) do
          WidgetValue:Hide();
          WidgetValue:SetParent(nil);
        end
      end
      self.PluginInfo[Value].ProfileHeader.Settings:SetHeight(0);
      self.PluginInfo[Value].ProfileHeader.Settings:Hide();
      self.PluginInfo[Value].ProfileHeader:SetHeight(self.PluginInfo[Value].ProfileHeader.Checkbox:GetHeight());
    end
    CurrentHeight = CurrentHeight + self.PluginInfo[Value].ProfileHeader:GetHeight() + RowSpacing;
  end
  CurrentHeight = CurrentHeight + Modules_ScrollFrame_InitialHeight;
  PassLoot_Modules_ScrollFrame_Content:SetHeight(CurrentHeight);
end

-- Enable/disable modules, verify rule tables, update current rule.
function PassLoot:Modules_OnClick()
  local Module = this.Value;
  local Status;
  if ( this:GetChecked() ) then
    Status = true;
  else
    Status = false;
  end
  self.db.profile.Modules[Module] = self.db.profile.Modules[Module] or {};
  self.db.profile.Modules[Module].Status = Status;
  if ( Status ~= self.modules[Module].enabledState ) then
    if ( Status ) then
      self:EnableModule(Module);
      self:CheckRuleTables();
      self:Rules_RuleList_OnScroll();
      self:DisplayCurrentRule();
    else
      self:DisableModule(Module);
    end
    -- self:CountEnabledModules();
    self:Modules_ScrollFrame_Update();
  end
end
