﻿local PassLoot = LibStub("AceAddon-3.0"):GetAddon("PassLoot");
local L = LibStub("AceLocale-3.0"):GetLocale("PassLoot");
local module = PassLoot:NewModule(L["PassLoot_ModuleName_ZoneType"])

module.Choices = {
  {
    ["Name"] = L["Any"],
    ["Group"] = {},
    ["Value"] = 1,
  },
  {
    ["Name"] = L["Outside"],
    ["Group"] = {},
    ["Value"] = 2,
  },
  {
    ["Name"] = L["Group"],
    ["Group"] = {
      {
        ["Name"] = L["Any"],
        ["Value"] = 3,
      },
      {
        ["Name"] = L["Normal"],
        ["Value"] = 4,
      },
      {
        ["Name"] = L["Heroic"],
        ["Value"] = 5,
      },
    },
  },
  {
    ["Name"] = L["Raid"],
    ["Group"] = {},
    ["Value"] = 6,
  },
}
module.ConfigOptions_RuleDefaults = {
  -- { VariableName, Default },
  { "ZoneType", {} },
};
module.NewFilterValue = 1;

function module:OnEnable()
  self:RegisterDefaultVariables(self.ConfigOptions_RuleDefaults);
  self:AddWidget(self.Widget);
  self:CheckDBVersion(2, "UpgradeDatabase");
end

function module:OnDisable()
  self:UnregisterDefaultVariables();
  self:RemoveWidgets();
end

function module:UpgradeDatabase(FromVersion, Rule)
  if ( FromVersion == 1 ) then
    local Table = {
      { "ZoneType", { Rule.ZoneType } }
    };
    return Table;
  end
  return;
end

function module:CreateWidget()
  local Widget = CreateFrame("Frame", "PassLoot_Frames_Widgets_ZoneType", nil, "UIDropDownMenuTemplate");
  Widget:EnableMouse(true);
  Widget:SetHitRectInsets(15, 15, 0 ,0);
  getglobal(Widget:GetName().."Text"):SetJustifyH("CENTER");
  UIDropDownMenu_SetWidth(140, Widget);
  Widget:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_ZoneType") end);
  Widget:SetScript("OnLeave", function() GameTooltip:Hide() end);
  local Button = getglobal(Widget:GetName().."Button");
  Button:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_ZoneType") end);
  Button:SetScript("OnLeave", function() GameTooltip:Hide() end);
  local Title = Widget:CreateFontString(Widget:GetName().."Title", "BACKGROUND", "GameFontNormalSmall");
  Title:SetParent(Widget);
  Title:SetPoint("BOTTOMLEFT", Widget, "TOPLEFT", 20, 0);
  Title:SetText(L["PassLoot_Settings_ZoneType"]);
  Widget:SetParent(nil);
  Widget:Hide();
  Widget.initialize = function(level) self:DropDown_Init(level) end;
  Widget.YPaddingTop = Title:GetHeight();
  Widget.Height = Widget:GetHeight() + Widget.YPaddingTop;
  Widget.XPaddingLeft = -15;
  Widget.XPaddingRight = -15;
  Widget.Width = Widget:GetWidth() + Widget.XPaddingLeft + Widget.XPaddingRight;
  Widget.PreferredPriority = 2;
  Widget.Info = {
    L["PassLoot_Settings_ZoneType"],
    L["PassLoot_Settings_ZoneTypeDesc"],
  };
  return Widget;
end
module.Widget = module:CreateWidget();

-- Local function to get the data and make sure it's valid data
function module.Widget:GetData(RuleNum)
  local Data = module:GetConfigOption("ZoneType", RuleNum);
  if ( not Data or type(Data) ~= "table" ) then
    Data = {};
  end
  for Key, Value in ipairs(Data) do
    if ( not tonumber(Value) ) then
      Data[Key] = module.NewFilterValue;
    end
  end
  return Data;
end

function module.Widget:GetNumFilters(RuleNum)
  local Value = self:GetData(RuleNum);
  return #Value;
end

function module.Widget:AddNewFilter()
  local Value = self:GetData();
  table.insert(Value, module.NewFilterValue);
  module:SetConfigOption("ZoneType", Value);
end

function module.Widget:RemoveFilter(Index)
  local Value = self:GetData();
  table.remove(Value, Index);
  module:SetConfigOption("ZoneType", Value);
end

function module.Widget:DisplayWidget(Index)
  if ( Index ) then
    module.FilterIndex = Index;
  end
  local Value = self:GetData();
  UIDropDownMenu_SetText(module:GetZoneTypeText(Value[module.FilterIndex]), module.Widget);
end

function module.Widget:GetFilterText(Index)
  local Value = self:GetData();
  return module:GetZoneTypeText(Value[Index]);
end

function module.Widget:SetMatch(ItemLink, Tooltip)
end

function module.Widget:GetMatch(RuleNum, Index)
  local RuleValue = self:GetData(RuleNum);
  -- 1 = Any
  -- 2 = Outside
  -- 3 = Group - Any
  -- 4 = Group - Normal
  -- 5 = Group - Heroic
  -- 6 = Raid
  local InInstance, InstanceType = IsInInstance();
  -- InInstance is either nil or 1
  -- InstanceType is none, pvp, arena, party, raid
  local Difficulty = GetInstanceDifficulty();
  -- Difficulty is 1, 2, 3
  local LookupTable = {
    -- RuleValue = { InInstance, InstanceType, Difficulty }
    [1] = { "ANY", "ANY", "ANY" },
    [2] = { nil, "none", "ANY" },
    [3] = { 1, "party", "ANY" },
    [4] = { 1, "party", 1 },
    [5] = { 1, "party", 2 },
    [6] = { 1, "raid", "ANY" },    
  };
  if ( LookupTable[RuleValue[Index]][1] == "ANY" or LookupTable[RuleValue[Index]][1] == InInstance ) then
    if ( LookupTable[RuleValue[Index]][2] == "ANY" or LookupTable[RuleValue[Index]][2] == InstanceType ) then
      if ( LookupTable[RuleValue[Index]][3] == "ANY" or LookupTable[RuleValue[Index]][3] == Difficulty ) then
        return true;
      end
    end
  end
  module:Debug("ZoneType doesn't match");
  return false;
end

function module:DropDown_Init(level)
  level = level or 1;
  local info = {};
  info.checked = false;
  info.func = self.DropDown_OnClick;
  info.arg1 = self;
  info.owner = self.Widget;
  if ( level == 1 ) then
    for Key, Value in ipairs(self.Choices) do
      info.text = Value.Name;
      if ( #Value.Group > 0 ) then
        info.hasArrow = true;
        info.notClickable = false;
        info.value = {
          ["Key"] = Key,
          ["Value"] = self.Choices[Key].Group[1].Value,
        };
      else
        info.hasArrow = false;
        info.notClickable = false;
        info.value = {
          ["Key"] = Key,
          ["Value"] = Value.Value,
        };
      end
      UIDropDownMenu_AddButton(info, level);
    end
  else
    local button = this;
    local parent = button:GetParent();
    local valueinfo;
    if (parent:GetName() == "DropDownList1") then
      self.Widget.selectedLevel1Button = button;
      valueinfo = button.value;
    else
      self.Widget.selectedLevel1Button = parent;
      valueinfo = parent.value;
    end
    for Key, Value in ipairs(self.Choices[valueinfo.Key].Group) do
      info.text = Value.Name;
      info.hasArrow = false;
      info.notClickable = false;
      info.value = {
        ["Key"] = valueinfo.Key,
        ["Value"] = Value.Value,
      };
      UIDropDownMenu_AddButton(info, level);
    end
  end
end

function module:DropDown_OnClick()
  local Value = self.Widget:GetData();
  Value[self.FilterIndex] = this.value.Value;
  self:SetConfigOption("ZoneType", Value);
  UIDropDownMenu_SetText(self:GetZoneTypeText(this.value.Value), this.owner);
  DropDownList1:Hide(); -- Nested dropdown buttons don't hide their parent menus on click.
end

function module:GetZoneTypeText(ZoneID)
  for Key, Value in ipairs(self.Choices) do
    if ( #Value.Group > 0 ) then
      for GroupKey, GroupValue in ipairs(Value.Group) do
        if ( GroupValue.Value == ZoneID ) then
          local ReturnValue = string.gsub(L["ZoneType Text"], "%%zonetype%%", Value.Name);
          ReturnValue = string.gsub(ReturnValue, "%%instancedifficulty%%", GroupValue.Name);
          return ReturnValue;
        end
      end
    else
      if ( Value.Value == ZoneID ) then
        return Value.Name;
      end
    end
  end
  return "";
end
