﻿local PassLoot = LibStub("AceAddon-3.0"):GetAddon("PassLoot");
local L = LibStub("AceLocale-3.0"):GetLocale("PassLoot");
local module = PassLoot:NewModule(L["PassLoot_ModuleName_Zone"])

module.ConfigOptions_RuleDefaults = {
  -- { VariableName, Default },
  { "Zone", {} },
};
module.NewFilterValue = L["Temp Zone Name"];

function module:OnEnable()
  self:RegisterDefaultVariables(self.ConfigOptions_RuleDefaults);
  self:AddWidget(self.Widget);
  self:CheckDBVersion(2, "UpgradeDatabase");
end

function module:OnDisable()
  self:UnregisterDefaultVariables();
  self:RemoveWidgets();
end

function module:UpgradeDatabase(FromVersion, Rule)
  if ( FromVersion == 1 ) then
    local Table = {
      { "Zone", { Rule.Zone } }
    };
    return Table;
  end
  return;
end

function module:CreateWidget()
  local Widget = CreateFrame("EditBox", "PassLoot_Frames_Widgets_Zone");
  Widget:SetBackdrop({
    ["bgFile"] = "Interface\\Tooltips\\UI-Tooltip-Background",
    ["edgeFile"] = "Interface\\Tooltips\\UI-Tooltip-Border",
    ["tile"] = true,
    ["insets"] = {
      ["top"] = 5,
      ["bottom"] = 5,
      ["left"] = 5,
      ["right"] = 5,
    },
    ["tileSize"] = 32,
    ["edgeSize"] = 16,
  });
  Widget:SetBackdropColor(0, 0, 0, 0.95);
  Widget:SetFontObject(ChatFontNormal);
  Widget:SetTextInsets(6, 6, 6, 6);
  Widget:SetHeight(26);
  Widget:SetWidth(160);
  Widget:SetMaxLetters(200);
  -- Widget:SetHistoryLines(0);
  Widget:SetAutoFocus(false);
  Widget:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_Zone") end);
  Widget:SetScript("OnLeave", function() GameTooltip:Hide() end);
  Widget:SetScript("OnEscapePressed", function() this:ClearFocus() end);
  Widget:SetScript("OnEditFocusGained", function() this:HighlightText() end);
  Widget:SetScript("OnEditfocusLost", function()
    this:HighlightText(0, 0);
    -- self:DisplayCurrentText();
    self.Widget:DisplayWidget();
  end);
  Widget:SetScript("OnEnterPressed", function()
    self:SetRuleZone();
    this:ClearFocus();
  end);
  Widget:SetScript("OnMouseUp", function() self:SetRuleZone(arg1) end);
  local Title = Widget:CreateFontString(Widget:GetName().."Title", "BACKGROUND", "GameFontNormalSmall");
  Title:SetParent(Widget);
  Title:SetPoint("BOTTOMLEFT", Widget, "TOPLEFT", 3, 0);
  Title:SetText(L["PassLoot_Settings_Zone"]);
  Widget:SetParent(nil);
  Widget:Hide();
  Widget.YPaddingTop = Title:GetHeight() + 1;
  Widget.YPaddingBottom = 4;
  Widget.Height = Widget:GetHeight() + Widget.YPaddingTop + Widget.YPaddingBottom;
  Widget.PreferredPriority = 1;
  Widget.Info = {
    L["PassLoot_Settings_Zone"],
    L["PassLoot_Settings_ZoneDesc"],
  };
  return Widget;
end
module.Widget = module:CreateWidget();

-- Local function to get the data and make sure it's valid data
function module.Widget:GetData(RuleNum)
  local Data = module:GetConfigOption("Zone", RuleNum);
  if ( not Data or type(Data) ~= "table" ) then
    Data = {};
  end
  for Key, Value in ipairs(Data) do
    if ( type(Value) ~= "string" ) then
      Data[Key] = module.NewFilterValue;
    end
  end
  return Data;
end

function module.Widget:GetNumFilters(RuleNum)
  local Value = self:GetData(RuleNum);
  return #Value;
end

function module.Widget:AddNewFilter()
  local Value = self:GetData();
  table.insert(Value, module.NewFilterValue);
  module:SetConfigOption("Zone", Value);
end

function module.Widget:RemoveFilter(Index)
  local Value = self:GetData();
  table.remove(Value, Index);
  module:SetConfigOption("Zone", Value);
end

function module.Widget:DisplayWidget(Index)
  if ( Index ) then
    module.FilterIndex = Index;
  end
  local Value = self:GetData();
  if ( not Value or not Value[module.FilterIndex] ) then
    return;
  end
  module.Widget:SetText(Value[module.FilterIndex]);
  module.Widget:SetScript("OnUpdate", module.ScrollLeft);
end

function module.Widget:GetFilterText(Index)
  local Value = self:GetData();
  return Value[Index];
end

function module.Widget:SetMatch(ItemLink, Tooltip)
  module.CurrentMatch = string.lower(GetRealZoneText());
  module:Debug("Zone: "..(module.CurrentMatch or ""));
end

function module.Widget:GetMatch(RuleNum, Index)
  local RuleValue = self:GetData(RuleNum);
  if ( RuleValue[Index] ~= "" ) then
    if ( string.lower(RuleValue[Index]) ~= module.CurrentMatch ) then
      module:Debug("Zone does not match");
      return false;
    end
  end
  return true;
end

function module:SetRuleZone(Button)
  local Value = self.Widget:GetData();
  if ( Button ) then
    if ( Button == "RightButton" and IsShiftKeyDown() and GetRealZoneText() ) then
      Value[self.FilterIndex] = GetRealZoneText();
      self:SetConfigOption("Zone", Value);
      this:SetText(GetRealZoneText());
      this:ClearFocus();
    end
    return;
  else
    Value[self.FilterIndex] = this:GetText();
    self:SetConfigOption("Zone", Value);
  end
end
