﻿local PassLoot = LibStub("AceAddon-3.0"):GetAddon("PassLoot");
local L = LibStub("AceLocale-3.0"):GetLocale("PassLoot");
local module = PassLoot:NewModule(L["PassLoot_ModuleName_Quality"])

module.Choices = {
  L["Any"],
  --ITEM_QUALITY_COLORS[0].hex..ITEM_QUALITY0_DESC.."|r", --Poor     --Can't be rolled on
  --ITEM_QUALITY_COLORS[1].hex..ITEM_QUALITY1_DESC.."|r", --Common --Can't be rolled on
  ITEM_QUALITY_COLORS[2].hex..ITEM_QUALITY2_DESC.."|r", --Uncommon
  ITEM_QUALITY_COLORS[3].hex..ITEM_QUALITY3_DESC.."|r", --Rare
  ITEM_QUALITY_COLORS[4].hex..ITEM_QUALITY4_DESC.."|r", --Epic
  ITEM_QUALITY_COLORS[5].hex..ITEM_QUALITY5_DESC.."|r", --Legendary
  ITEM_QUALITY_COLORS[6].hex..ITEM_QUALITY6_DESC.."|r", --Artifact
};
module.ConfigOptions_RuleDefaults = {
  -- { VariableName, Default },
  { "Quality", {} },
};
module.NewFilterValue = 1;

function module:OnEnable()
  self:RegisterDefaultVariables(self.ConfigOptions_RuleDefaults);
  self:AddWidget(self.Widget);
  self:CheckDBVersion(2, "UpgradeDatabase");
end

function module:OnDisable()
  self:UnregisterDefaultVariables();
  self:RemoveWidgets();
end

function module:UpgradeDatabase(FromVersion, Rule)
  if ( FromVersion == 1 ) then
    local Table = {
      { "Quality", { Rule.Quality } }
    };
    return Table;
  end
  return;
end

function module:CreateWidget()
  local Widget = CreateFrame("Frame", "PassLoot_Frames_Widgets_Quality", nil, "UIDropDownMenuTemplate");
  Widget:EnableMouse(true);
  Widget:SetHitRectInsets(15, 15, 0 ,0);
  getglobal(Widget:GetName().."Text"):SetJustifyH("CENTER");
  UIDropDownMenu_SetWidth(120, Widget);
  Widget:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_Quality") end);
  Widget:SetScript("OnLeave", function() GameTooltip:Hide() end);
  local Button = getglobal(Widget:GetName().."Button");
  Button:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_Quality") end);
  Button:SetScript("OnLeave", function() GameTooltip:Hide() end);
  local Title = Widget:CreateFontString(Widget:GetName().."Title", "BACKGROUND", "GameFontNormalSmall");
  Title:SetParent(Widget);
  Title:SetPoint("BOTTOMLEFT", Widget, "TOPLEFT", 20, 0);
  Title:SetText(L["PassLoot_Settings_Quality"]);
  Widget:SetParent(nil);
  Widget:Hide();
  Widget.initialize = function(level) self:DropDown_Init(level) end;
  Widget.YPaddingTop = Title:GetHeight();
  Widget.Height = Widget:GetHeight() + Widget.YPaddingTop;
  Widget.XPaddingLeft = -15;
  Widget.XPaddingRight = -15;
  Widget.Width = Widget:GetWidth() + Widget.XPaddingLeft + Widget.XPaddingRight;
  Widget.PreferredPriority = 3;
  Widget.Info = {
    L["PassLoot_Settings_Quality"],
    L["PassLoot_Settings_QualityDesc"],
  };
  return Widget;
end
module.Widget = module:CreateWidget();

-- Local function to get the data and make sure it's valid data
function module.Widget:GetData(RuleNum)
  local Data = module:GetConfigOption("Quality", RuleNum);
  if ( not Data or type(Data) ~= "table" ) then
    Data = {};
  end
  for Key, Value in ipairs(Data) do
    if ( not tonumber(Value) ) then
      Data[Key] = module.NewFilterValue;
    end
  end
  return Data;
end

function module.Widget:GetNumFilters(RuleNum)
  local Value = self:GetData(RuleNum);
  return #Value;
end

function module.Widget:AddNewFilter()
  local Value = self:GetData();
  table.insert(Value, module.NewFilterValue);
  module:SetConfigOption("Quality", Value);
end

function module.Widget:RemoveFilter(Index)
  local Value = self:GetData();
  table.remove(Value, Index);
  module:SetConfigOption("Quality", Value);
end

function module.Widget:DisplayWidget(Index)
  if ( Index ) then
    module.FilterIndex = Index;
  end
  local Value = self:GetData();
  UIDropDownMenu_SetText(module.Choices[Value[module.FilterIndex]], module.Widget);
end

function module.Widget:GetFilterText(Index)
  local Value = self:GetData();
  return module.Choices[Value[Index]];
end

function module.Widget:SetMatch(ItemLink, Tooltip)
  local _, _, Quality, _, _, _, _, _, _, _ = GetItemInfo(ItemLink);
  module.CurrentMatch = Quality;
  module:Debug("Quality Type: "..Quality);
end

function module.Widget:GetMatch(RuleNum, Index)
  local RuleValue = self:GetData(RuleNum);
  if ( RuleValue[Index] > 1 ) then
    if ( RuleValue[Index] ~= tonumber(module.CurrentMatch) ) then
      return false;
    end
  end
  return true;
end

function module:DropDown_Init(level)
  level = level or 1;
  local info = {};
  info.checked = false;
  info.func = self.DropDown_OnClick;
  info.arg1 = self;
  info.owner = self.Widget;
  for Key, Value in ipairs(self.Choices) do
    info.text = Value;
    info.value = Key;
    UIDropDownMenu_AddButton(info, level);
  end
end

function module:DropDown_OnClick()
  local Value = self.Widget:GetData();
  Value[self.FilterIndex] = this.value;
  self:SetConfigOption("Quality", Value);
  UIDropDownMenu_SetText(this:GetText(), this.owner);
end
