﻿local PassLoot = LibStub("AceAddon-3.0"):GetAddon("PassLoot");
local L = LibStub("AceLocale-3.0"):GetLocale("PassLoot");
local module = PassLoot:NewModule(L["PassLoot_ModuleName_LootWon"], "AceEvent-3.0")

module.Choices = {
  {
    ["Name"] = L["Any"],
    ["Text"] = L["Any"],
    ["Value"] = 1,
  },
  {
    ["Name"] = L["Equal to"],
    ["Text"] = L["Equal to %num%"],
    ["Value"] = 2,
  },
  {
    ["Name"] = L["Not Equal to"],
    ["Text"] = L["Not Equal to %num%"],
    ["Value"] = 3,
  },
  {
    ["Name"] = L["Less than"],
    ["Text"] = L["Less than %num%"],
    ["Value"] = 4,
  },
  -- Can't increment something if we have to have a number greater than this..
  -- {
    -- ["Name"] = L["Greater than"],
    -- ["Text"] = L["Greater than %num%"],
    -- ["Value"] = 5,
  -- },
};
module.ConfigOptions_RuleDefaults = {
  -- { VariableName, Default },
  { "LootWonLogicalOperator", nil },  -- No longer used
  { "LootWonComparison", {} },
  { "LootWonCounter", nil },
};
module.NewFilterValue_LogicalOperator = 1;
module.NewFilterValue_Comparison = 0;
module.NewFilterValue_Counter = 0;

function module:OnEnable()
  self:RegisterDefaultVariables(self.ConfigOptions_RuleDefaults);
  self:AddWidget(self.WidgetComparison);
  self:AddWidget(self.WidgetCounter);
  self:AddProfileWidget(self.ResetCheckbox);
  self:RegisterEvent("CHAT_MSG_LOOT");
  self:RegisterEvent("RAID_ROSTER_UPDATE");
  self:RegisterEvent("PARTY_MEMBERS_CHANGED", "RAID_ROSTER_UPDATE");
  self:RegisterMessage("PassLoot_OnRoll");
  self:RegisterMessage("PassLoot_OnProfileChanged");
  self.ItemsBeingRolledOn = {};
  self.InRaid = false;
  self:CheckDBVersion(2, "UpgradeDatabase");
  self:PassLoot_OnProfileChanged();
  self:RAID_ROSTER_UPDATE();
end

function module:OnDisable()
  self:UnregisterEvent("CHAT_MSG_LOOT");
  self:UnregisterEvent("RAID_ROSTER_UPDATE");
  self:UnregisterEvent("PARTY_MEMBERS_CHANGED");
  self:UnregisterMessage("PassLoot_OnRoll");
  self:UnregisterMessage("PassLoot_OnProfileChanged");
  self:UnregisterDefaultVariables();
  self:RemoveWidgets();
end

function module:UpgradeDatabase(FromVersion, Rule)
  if ( FromVersion == 1 ) then
    local Table = {
      { "LootWonLogicalOperator", nil },
      { "LootWonComparison", {} },
    };
    if ( Rule.LootWonLogicalOperator and Rule.LootWonComparison ) then
      Table[2][2][1] = {
        Rule.LootWonLogicalOperator,
        Rule.LootWonComparison,
      };
    end
    return Table;
  end
  return;
end

function module:CHAT_MSG_LOOT()
  -- needbeforegreed is round robin + rolling on some items.
  -- if ( GetLootMethod() == "group" or #self.ItemsBeingRolledOn == 0 ) then
  if ( #self.ItemsBeingRolledOn == 0 ) then
    return;
  end
  local CurrentCounter;
  local Pattern = string.gsub(LOOT_ROLL_WON, "%%s", "(.+)");
  local Start, End, Who, Item = string.find(arg1, Pattern);
  if ( Start and Who and Item ) then
    self:Debug("Someone won "..Item);
    for Key, Value in pairs(self.ItemsBeingRolledOn) do
      if ( Value[1] == Item and PassLoot.db.profile.Rules[Value[2]] ) then
        if ( Who == YOU or Who == UnitName("player") ) then
          self:Debug("We won "..Item);
          local Counter = self.WidgetCounter:GetData(Value[2]);
          if ( Counter ) then
            Counter = Counter + 1;
            self:SetConfigOption("LootWonCounter", Counter, Value[2]);
          end
          -- self:CurrentText();
          PassLoot:DisplayCurrentOptionFilter();
          PassLoot:Rules_Settings_Filters_OnScroll();
        else
          self:Debug("Someone else won "..Item);
        end
        self:Debug("Removing "..Item.." from ItemsBeingRolledOn");
        table.remove(self.ItemsBeingRolledOn, Key);
        return;
      end
    end
  end
  Pattern = string.gsub(LOOT_ROLL_ALL_PASSED, "%%s", "(.+)");
  Start, End, Item = string.find(arg1, Pattern);
  if ( Start and Item ) then
    self:Debug("Everyone passed on "..Item);
    for Key, Value in pairs(self.ItemsBeingRolledOn) do
      if ( Value[1] == Item ) then
        self:Debug("Removing "..Item.." from ItemsBeingRolledOn");
        table.remove(self.ItemsBeingRolledOn, Key);
        return;
      end
    end
  end
end

function module:RAID_ROSTER_UPDATE()
  if ( UnitInRaid("player") or GetNumPartyMembers() > 0 ) then
    if ( not self.InRaid and self:GetProfileVariable("ResetLootCounter") ) then
      self:ResetProfileLootWonCounters();
    end
    self.InRaid = true;
  else
    self.InRaid = false;
  end
end

function module:PassLoot_OnRoll(Event, ItemLink, RuleNum)
  table.insert(self.ItemsBeingRolledOn, { ItemLink, RuleNum } );
end

function module:PassLoot_OnProfileChanged()
  local ResetLootCounter = self:GetProfileVariable("ResetLootCounter");
  if ( ResetLootCounter == nil ) then
    ResetLootCounter = true;
    self:SetProfileVariable("ResetLootCounter", ResetLootCounter);
  end
  self.ResetCheckbox:SetChecked(ResetLootCounter);
end

function module:ResetProfileLootWonCounters()
  local Counter;
  for Key, Value in pairs(PassLoot.db.profile.Rules) do
    Counter = self.WidgetCounter:GetData(Key);
    if ( Counter ) then
      Counter = 0
      self:SetConfigOption("LootWonCounter", Counter, Key);
    end
  end
  self.WidgetCounter:DisplayWidget();
  PassLoot:Rules_Settings_Filters_OnScroll();
end

function module:CreateWidget_LootWonCounter()
  local EditBox = CreateFrame("EditBox", "PassLoot_Frames_Widgets_LootWonCounter");
  EditBox:SetBackdrop({
    ["bgFile"] = "Interface\\Tooltips\\UI-Tooltip-Background",
    ["edgeFile"] = "Interface\\Tooltips\\UI-Tooltip-Border",
    ["tile"] = true,
    ["insets"] = {
      ["top"] = 5,
      ["bottom"] = 5,
      ["left"] = 5,
      ["right"] = 5,
    },
    ["tileSize"] = 32,
    ["edgeSize"] = 16,
  });
  EditBox:SetBackdropColor(0, 0, 0, 0.95);
  EditBox:SetFontObject(ChatFontNormal);
  EditBox:SetTextInsets(6, 6, 6, 6);
  EditBox:SetHeight(26);
  EditBox:SetWidth(80);
  EditBox:SetMaxLetters(8);
  -- EditBox:SetHistoryLines(0);
  EditBox:SetAutoFocus(false);
  EditBox:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_LootWonCounter") end);
  EditBox:SetScript("OnLeave", function() GameTooltip:Hide() end);
  EditBox:SetScript("OnEscapePressed", function() this:ClearFocus() end);
  EditBox:SetScript("OnEditFocusGained", function() this:HighlightText() end);
  EditBox:SetScript("OnEditfocusLost", function()
    this:HighlightText(0, 0);
    self.WidgetCounter:DisplayWidget();
  end);
  EditBox:SetScript("OnEnterPressed", function()
    self:SetCounter();
    this:ClearFocus();
  end);
  local EditBoxTitle = EditBox:CreateFontString(EditBox:GetName().."Title", "BACKGROUND", "GameFontNormalSmall");
  EditBoxTitle:SetParent(EditBox);
  EditBoxTitle:SetPoint("BOTTOMLEFT", EditBox, "TOPLEFT", 3, 0);
  EditBoxTitle:SetText(L["PassLoot_Settings_LootWonCounter"]);
  EditBox:SetParent(nil);
  EditBox:Hide();
  EditBox.YPaddingTop = EditBoxTitle:GetHeight() + 1;
  EditBox.YPaddingBottom = 4;
  EditBox.Height = EditBox:GetHeight() + EditBox.YPaddingTop + EditBox.YPaddingBottom;
  EditBox.PreferredPriority = 10;
  EditBox.Info = {
    L["PassLoot_Settings_LootWonCounter"],
    L["PassLoot_Settings_LootWonCounterDesc"],
  };
  return EditBox;
end
module.WidgetCounter = module:CreateWidget_LootWonCounter();

-- Local function to get the data and make sure it's valid data
function module.WidgetCounter:GetData(RuleNum)
  local Data = module:GetConfigOption("LootWonCounter", RuleNum);
  if ( Data and not tonumber(Data) ) then
    Data = module.NewFilterValue_Counter;
  end
  return Data;
end

function module.WidgetCounter:GetNumFilters(RuleNum)
  local Value = self:GetData(RuleNum);
  if ( Value ) then
    return 1;
  else
    return 0;
  end
end

function module.WidgetCounter:AddNewFilter()
  module:SetConfigOption("LootWonCounter", { module.NewFilterValue_Counter });
end

function module.WidgetCounter:RemoveFilter(Index)
  module:SetConfigOption("LootWonCounter", nil);
  module:SetConfigOption("LootWonComparison", {});
  -- module:SetConfigOption("LootWonLogicalOperator", {});
end

function module.WidgetCounter:DisplayWidget(Index)
  local Value = self:GetData();
  if ( Value ) then
    module.WidgetCounter:SetText(Value);
    module.WidgetCounter:SetScript("OnUpdate", module.ScrollLeft);
  end
end

function module.WidgetCounter:GetFilterText(Index)
  local Value = self:GetData();
  if ( Value ) then
    return Value;
  end
end

function module.WidgetCounter:SetMatch(ItemLink, Tooltip)
end

function module.WidgetCounter:GetMatch(RuleNum, Index)
  return true;
end

function module:SetCounter()
  local Value = tonumber(this:GetText()) or 0;
  if ( Value < 0 ) then
    Value = 0;
  end
  Value = math.floor(Value + 0.5);
  self:SetConfigOption("LootWonCounter", Value );
end

function module:CreateWidget_LootWonComparison()
  local DropDown = CreateFrame("Frame", "PassLoot_Frames_Widgets_LootWonComparison", nil, "UIDropDownMenuTemplate");
  DropDown:EnableMouse(true);
  DropDown:SetHitRectInsets(15, 15, 0 ,0);
  getglobal(DropDown:GetName().."Text"):SetJustifyH("CENTER");
  UIDropDownMenu_SetWidth(150, DropDown);
  DropDown:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_LootWon") end);
  DropDown:SetScript("OnLeave", function() GameTooltip:Hide() end);
  local DropDownButton = getglobal(DropDown:GetName().."Button");
  DropDownButton:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_LootWon") end);
  DropDownButton:SetScript("OnLeave", function() GameTooltip:Hide() end);
  local DropDownTitle = DropDown:CreateFontString(DropDown:GetName().."Title", "BACKGROUND", "GameFontNormalSmall");
  DropDownTitle:SetParent(DropDown);
  DropDownTitle:SetPoint("BOTTOMLEFT", DropDown, "TOPLEFT", 20, 0);
  DropDownTitle:SetText(L["PassLoot_Settings_LootWon"]);
  DropDown:SetParent(nil);
  DropDown:Hide();
  DropDown.initialize = function(level) self:DropDown_Init(level) end;
  DropDown.YPaddingTop = DropDownTitle:GetHeight();
  DropDown.Height = DropDown:GetHeight() + DropDown.YPaddingTop;
  DropDown.XPaddingLeft = -15;
  DropDown.XPaddingRight = -15;
  DropDown.Width = DropDown:GetWidth() + DropDown.XPaddingLeft + DropDown.XPaddingRight;
  DropDown.PreferredPriority = 9;
  DropDown.Info = {
    L["PassLoot_Settings_LootWon"],
    L["PassLoot_Settings_LootWonDesc"],
  };

  local DropDownEditBox = CreateFrame("EditBox", "PassLoot_Frames_Widgets_LootWonDropDownEditBox");
  DropDownEditBox:SetFontObject(ChatFontNormal);
  DropDownEditBox:SetMaxLetters(8);
  DropDownEditBox:SetAutoFocus(true);
  DropDownEditBox:SetScript("OnEnter", function()
    CloseDropDownMenus(this:GetParent():GetParent():GetID() + 1);
    UIDropDownMenu_StopCounting(this:GetParent():GetParent());
  end);
  DropDownEditBox:SetScript("OnEnterPressed", function()
    self:DropDown_OnClick();
    this:Hide();
    -- CloseMenus() only hides the DropDownList2, not this object, and even tho i will set parent to nil, i might as well cover bases
    CloseMenus();
  end);
  DropDownEditBox:SetScript("OnEscapePressed", function()
    this:Hide();
    CloseMenus();
  end);
  DropDownEditBox:SetScript("OnEditFocusGained", function() UIDropDownMenu_StopCounting(this:GetParent():GetParent()) end);
  DropDownEditBox:SetScript("OnHide", function() this:SetParent(nil) end);
  DropDownEditBox:SetParent(nil);
  DropDownEditBox:Hide();
  return DropDown, DropDownEditBox;
end
module.WidgetComparison, module.DropDownEditBox = module:CreateWidget_LootWonComparison();

-- Local function to get the data and make sure it's valid data
function module.WidgetComparison:GetData(RuleNum)
  local Data = module:GetConfigOption("LootWonComparison", RuleNum);
  if ( not Data or type(Data) ~= "table" ) then
    Data = {};
  end
  for Key, Value in ipairs(Data) do
    if ( not Value[1] or not tonumber(Value[1]) or not Value[2] or not tonumber(Value[2]) ) then
      Data[Key] = {
        module.NewFilterValue_LogicalOperator,
        module.NewFilterValue_Comparison,
      };
    end
  end
  return Data;
end

function module.WidgetComparison:GetNumFilters(RuleNum)
  local Value = self:GetData(RuleNum);
  return #Value;
end

function module.WidgetComparison:AddNewFilter()
  local Value = self:GetData();
  local NewTable = {
    module.NewFilterValue_LogicalOperator,
    module.NewFilterValue_Comparison
  };
  table.insert(Value, NewTable);
  module:SetConfigOption("LootWonComparison", Value);
  local Value = module.WidgetCounter:GetData();
  if ( not Value ) then
    module:SetConfigOption("LootWonCounter", module.NewFilterValue_Counter);
  end
end

function module.WidgetComparison:RemoveFilter(Index)
  local Value = self:GetData();
  table.remove(Value, Index);
  module:SetConfigOption("LootWonComparison", Value);
end

function module.WidgetComparison:DisplayWidget(Index)
  if ( Index ) then
    module.FilterIndex = Index;
  end
  local Value = self:GetData();
  local Value_LogicalOperator = Value[module.FilterIndex][1]
  local Value_Comparison = Value[module.FilterIndex][2]
  UIDropDownMenu_SetText(module:GetLootWonText(Value_LogicalOperator, Value_Comparison), module.WidgetComparison);
end

function module.WidgetComparison:GetFilterText(Index)
  local Value = self:GetData();
  local LogicalOperator = Value[Index][1];
  local Comparison = Value[Index][2];
  local Text = module:GetLootWonText(LogicalOperator, Comparison);
  return Text;
end

function module.WidgetComparison:SetMatch(ItemLink, Tooltip)
end

function module.WidgetComparison:GetMatch(RuleNum, Index)
  local Value = self:GetData(RuleNum);
  local LogicalOperator = Value[Index][1];
  local Comparison = Value[Index][2];
  local Counter = module.WidgetCounter:GetData(RuleNum);
  if ( LogicalOperator > 1 ) then
    if ( LogicalOperator == 2 ) then -- Equal To
      if ( Counter ~= Comparison ) then
        module:Debug("LootWonCounter ~= LootWonComparison");
        return false;
      end
    elseif ( LogicalOperator == 3 ) then -- Not Equal To
      if ( Counter == Comparison ) then
        module:Debug("LootWonCounter == LootWonComparison");
        return false;
      end
    elseif ( LogicalOperator == 4 ) then -- Less than
      if ( Counter >= Comparison ) then
        module:Debug("LootWonCounter >= LootWonComparison");
        return false;
      end
    -- elseif ( LogicalOperator== 5 ) then -- Greater than
      -- if ( Counter<= Comparison ) then
        -- module:Debug("LootWonCounter <= LootWonComparison");
        -- return false;
      -- end
    end
  end
  return true;
end

function module:DropDown_Init(level)
  level = level or 1;
  local info = {};
  info.checked = false;
  info.func = self.DropDown_OnClick;
  info.arg1 = self;
  info.owner = self.WidgetComparison;
  if ( level == 1 ) then
    for Key, Value in ipairs(self.Choices) do
      info.text = Value.Name;
      info.value = Value.Value;
      if ( Key == 1 ) then
        info.hasArrow = false;
      else
        info.hasArrow = true;
      end
      info.notClickable = false;
      UIDropDownMenu_AddButton(info, level);
    end
  else
    local button = this;
    local parent = button:GetParent();
    if (parent:GetName() == "DropDownList1") then
      info.owner.selectedLevel1Button = button;
      self.DropDownEditBox.value = button.value;
    else
      info.owner.selectedLevel1Button = parent;
      self.DropDownEditBox.value = parent.value;
    end
    info.text = "";
    info.notClickable = false;
    UIDropDownMenu_AddButton(info, level);
    DropDownList2.maxWidth = 80;
    DropDownList2:SetWidth(80);
    self.DropDownEditBox.owner = info.owner;
    self.DropDownEditBox:ClearAllPoints();
    self.DropDownEditBox:SetParent(DropDownList2Button1);
    self.DropDownEditBox:SetPoint("TOPLEFT", DropDownList2Button1, "TOPLEFT");
    self.DropDownEditBox:SetPoint("BOTTOMRIGHT", DropDownList2Button1, "BOTTOMRIGHT");
    local Value = self.WidgetComparison:GetData();
    self.DropDownEditBox:SetText(Value[self.FilterIndex][2]);
    self.DropDownEditBox:Show();
    self.DropDownEditBox:HighlightText();
  end
end

function module:DropDown_OnClick()
  local Value = self.WidgetComparison:GetData();
  local LogicalOperator = this.value;
  local Comparison = Value[self.FilterIndex][2];
  if ( this:GetName() == self.DropDownEditBox:GetName() ) then
    Comparison = tonumber(this:GetText()) or 0;
    if ( Comparison < 0 ) then
      Comparison = 0;
    end
    Comparison = math.floor(Comparison + 0.5);
  end
  Value[self.FilterIndex][1] = LogicalOperator;
  Value[self.FilterIndex][2] = Comparison;
  self:SetConfigOption("LootWonComparison", Value);
  UIDropDownMenu_SetText(self:GetLootWonText(LogicalOperator, Comparison), this.owner);
end

function module:CreateWidget_ResetCheckBox()
  local Checkbox = CreateFrame("CheckButton", "PassLoot_Frames_Widgets_LootWonResetCheckBox", nil, "UICheckButtonTemplate");
  Checkbox:SetHeight(24);
  Checkbox:SetWidth(24);
  Checkbox:SetHitRectInsets(0, -60, 0, 0);
  Checkbox:SetScript("OnLeave", function() GameTooltip:Hide() end);
  Checkbox:SetScript("OnClick", function() self:Checkbox_OnClick() end);
  Checkbox:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_LootWonResetCounter") end);
  getglobal(Checkbox:GetName().."Text"):SetText(L["PassLoot_Settings_LootWonResetCounter"]);
  return Checkbox;
end
module.ResetCheckbox = module:CreateWidget_ResetCheckBox();

function module:Checkbox_OnClick()
  local ResetLootCounter = self:GetProfileVariable("ResetLootCounter");
  if ( IsShiftKeyDown() ) then
    this:SetChecked(ResetLootCounter);
    self:ResetProfileLootWonCounters();
  else
    self:SetProfileVariable("ResetLootCounter", not ResetLootCounter);
  end
end

function module:GetLootWonText(LogicalOperator, Comparison)
  for Key, Value in ipairs(self.Choices) do
    if ( Value.Value == LogicalOperator ) then
      return string.gsub(Value.Text, "%%num%%", Comparison);
    end
  end
end
