﻿local PassLoot = LibStub("AceAddon-3.0"):GetAddon("PassLoot");
local L = LibStub("AceLocale-3.0"):GetLocale("PassLoot");
local module = PassLoot:NewModule(L["PassLoot_ModuleName_ItemName"])

module.ConfigOptions_RuleDefaults = {
  -- { VariableName, Default },
  { "Items", {} },
};
module.NewFilterValue = {
  ["Name"] = L["Temp Item Name"],
  ["Type"] = "Exact",
};

function module:OnEnable()
  self:RegisterDefaultVariables(self.ConfigOptions_RuleDefaults);
  self:AddWidget(self.Widget);
  self:CheckDBVersion(1, "UpgradeDatabase");
end

function module:OnDisable()
  self:UnregisterDefaultVariables();
  self:RemoveWidgets();
end

function module:UpgradeDatabase(FromVersion, Rule)
  return;
end

function module:CreateWidget()
  local Widget = CreateFrame("Frame", "PassLoot_Frames_Widgets_ItemName");
  
  local TextBox = CreateFrame("EditBox", "PassLoot_Frames_Widgets_ItemNameTextBox");
  TextBox:SetBackdrop({
    ["bgFile"] = "Interface\\Tooltips\\UI-Tooltip-Background",
    ["edgeFile"] = "Interface\\Tooltips\\UI-Tooltip-Border",
    ["tile"] = true,
    ["insets"] = {
      ["top"] = 5,
      ["bottom"] = 5,
      ["left"] = 5,
      ["right"] = 5,
    },
    ["tileSize"] = 32,
    ["edgeSize"] = 16,
  });
  TextBox:SetBackdropColor(0, 0, 0, 0.95);
  TextBox:SetFontObject(ChatFontNormal);
  TextBox:SetTextInsets(6, 6, 6, 6);
  TextBox:SetHeight(26);
  TextBox:SetWidth(160);
  TextBox:SetMaxLetters(200);
  -- TextBox:SetHistoryLines(0);
  TextBox:SetAutoFocus(false);
  TextBox:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_ItemName") end);
  TextBox:SetScript("OnLeave", function() GameTooltip:Hide() end);
  TextBox:SetScript("OnEscapePressed", function() this:ClearFocus() end);
  TextBox:SetScript("OnEditFocusGained", function() this:HighlightText() end);
  TextBox:SetScript("OnEditfocusLost", function()
    this:HighlightText(0, 0);
    self.Widget:DisplayWidget();
  end);
  TextBox:SetScript("OnEnterPressed", function()
    self:SetItemName();
    this:ClearFocus();
  end);
  local Title = TextBox:CreateFontString(TextBox:GetName().."Title", "BACKGROUND", "GameFontNormalSmall");
  Title:SetParent(TextBox);
  Title:SetPoint("BOTTOMLEFT", TextBox, "TOPLEFT", 3, 0);
  Title:SetText(L["PassLoot_Settings_ItemName"]);
  TextBox:SetParent(Widget);
  TextBox:SetPoint("BOTTOMLEFT", Widget, "BOTTOMLEFT", 0, 0);
  Widget.TextBox = TextBox;
  
  local CheckBox = CreateFrame("CheckButton", "PassLoot_Frames_Widgets_ItemNameCheckBox", Widget, "UICheckButtonTemplate");
  CheckBox:SetHeight(24);
  CheckBox:SetWidth(24);
  CheckBox:SetHitRectInsets(0, -60, 0, 0);
  CheckBox:SetScript("OnLeave", function() GameTooltip:Hide() end);
  CheckBox:SetScript("OnClick", function() self:Exact_OnClick() end);
  CheckBox:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_ItemName_Exact") end);
  getglobal(CheckBox:GetName().."Text"):SetText(L["PassLoot_Settings_ItemName_Exact"]);
  CheckBox:SetPoint("BOTTOMLEFT", TextBox, "BOTTOMRIGHT", 5, 0);
  Widget.CheckBox = CheckBox

  Widget:Hide();
  Widget:SetHeight(TextBox:GetHeight());
  Widget.YPaddingTop = Title:GetHeight() + 1;
  Widget.YPaddingBottom = 4;
  Widget.Height = Widget:GetHeight() + Widget.YPaddingTop + Widget.YPaddingBottom;
  Widget:SetWidth(TextBox:GetWidth() + 5 + CheckBox:GetWidth() + 30);
  Widget.PreferredPriority = 11;
  Widget.Info = {
    L["PassLoot_Settings_ItemName"],
    L["PassLoot_Settings_ItemNameDesc"],
  };
  return Widget;
end
module.Widget = module:CreateWidget();

-- Local function to get the data and make sure it's valid data
function module.Widget:GetData(RuleNum)
  local Data = module:GetConfigOption("Items", RuleNum);
  if ( not Data or type(Data) ~= "table" ) then
    Data = {};
  end
  for Key, Value in ipairs(Data) do
    if ( not Value.Name or type(Value.Name) ~= "string" or not Value.Type or not ( Value.Type == "Exact" or Value.Type == "Partial" ) ) then
      Data[Key] = PassLoot:CopyTable(module.NewFilterValue);
    end
  end
  return Data;
end

function module.Widget:GetNumFilters(RuleNum)
  local Value = self:GetData(RuleNum);
  return #Value;
end

function module.Widget:AddNewFilter()
  local Value = self:GetData();
  local NewTable = {};
  for Key, Value in pairs(module.NewFilterValue) do
    NewTable[Key] = Value;
  end
  table.insert(Value, NewTable);
  module:SetConfigOption("Items", Value);
end

function module.Widget:RemoveFilter(Index)
  local Value = self:GetData();
  table.remove(Value, Index);
  module:SetConfigOption("Items", Value);
end

function module.Widget:DisplayWidget(Index)
  if ( Index ) then
    module.FilterIndex = Index;
  end
  local Value = self:GetData();
  if ( not Value or not Value[module.FilterIndex] ) then
    return;
  end
  module.Widget.TextBox:SetText(Value[module.FilterIndex].Name);
  module.Widget.TextBox:SetScript("OnUpdate", module.ScrollLeft);
  if ( Value[module.FilterIndex].Type == "Exact" ) then
    module.Widget.CheckBox:SetChecked(true);
  else
    module.Widget.CheckBox:SetChecked(false);
  end
end

function module.Widget:GetFilterText(Index)
  local Value = self:GetData();
  return Value[Index].Name;
end

function module.Widget:SetMatch(ItemLink, Tooltip)
  module.CurrentMatch, _, _, _, _, _, _, _, _, _ = GetItemInfo(ItemLink);
  module:Debug("Item name: "..(module.CurrentMatch or ""));
end

function module.Widget:GetMatch(RuleNum, Index)
  local RuleValue = self:GetData(RuleNum);
  local Name, Type = RuleValue[Index].Name, RuleValue[Index].Type;
  if ( Type == "Exact" ) then
    if ( string.lower(module.CurrentMatch) == string.lower(Name) ) then
      module:Debug("Found item name (exact)");
      return true;
    end
  else
    if ( string.find(string.lower(module.CurrentMatch), string.lower(Name)) ) then
      module:Debug("Found item name (partial)");
      return true;
    end
  end
  return false;
end

function module:SetItemName(Button)
  local Value = self.Widget:GetData();
  Value[self.FilterIndex].Name = this:GetText();
  self:SetConfigOption("Items", Value);
end

function module:Exact_OnClick()
  local Value = self.Widget:GetData();
  if ( this:GetChecked() ) then
    Value[self.FilterIndex].Type = "Exact";
  else
    Value[self.FilterIndex].Type = "Partial";
  end
  self:SetConfigOption("Items", Value);
end
