﻿local PassLoot = LibStub("AceAddon-3.0"):GetAddon("PassLoot");
local L = LibStub("AceLocale-3.0"):GetLocale("PassLoot");
local module = PassLoot:NewModule(L["PassLoot_ModuleName_Bind"])

module.Choices = {
  {
    ["Name"] = L["Any"],
    ["Type"] = "",
    ["Value"] = 1,
  },
  {
    ["Name"] = L["None"],
    ["Type"] = "",
    ["Value"] = 2,
  },
  {
    ["Name"] = L["Equip"],
    ["Type"] = ITEM_BIND_ON_EQUIP,
    ["Value"] = 3,
  },
  {
    ["Name"] = L["Pickup"],
    ["Type"] = ITEM_BIND_ON_PICKUP,
    ["Value"] = 4,
  },
  {
    ["Name"] = L["Use"],
    ["Type"] = ITEM_BIND_ON_USE,
    ["Value"] = 5,
  },
  {
    ["Name"] = ITEM_BIND_QUEST,
    ["Type"] = ITEM_BIND_QUEST,
    ["Value"] = 6,
  },
};
module.ConfigOptions_RuleDefaults = {
  -- { VariableName, Default },
  { "Bind", {} },
};
module.NewFilterValue = 1;

function module:OnEnable()
  self:RegisterDefaultVariables(self.ConfigOptions_RuleDefaults);
  self:AddWidget(self.Widget);
  -- self:AddProfileWidget(self.Widget);
  self:CheckDBVersion(2, "UpgradeDatabase");
end

function module:OnDisable()
  self:UnregisterDefaultVariables();
  self:RemoveWidgets();
end

function module:UpgradeDatabase(FromVersion, Rule)
  if ( FromVersion == 1 ) then
    local Table = {
      { "Bind", { Rule.Bind } }
    };
    return Table;
  end
  return;
end

function module:CreateWidget()
  local Widget = CreateFrame("Frame", "PassLoot_Frames_Widgets_Bind", nil, "UIDropDownMenuTemplate");
  Widget:EnableMouse(true);
  Widget:SetHitRectInsets(15, 15, 0 ,0);
  getglobal(Widget:GetName().."Text"):SetJustifyH("CENTER");
  UIDropDownMenu_SetWidth(120, Widget);
  Widget:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_Bind") end);
  Widget:SetScript("OnLeave", function() GameTooltip:Hide() end);
  local Button = getglobal(Widget:GetName().."Button");
  Button:SetScript("OnEnter", function() self:ShowTooltip("PassLoot_Settings_Bind") end);
  Button:SetScript("OnLeave", function() GameTooltip:Hide() end);
  local Title = Widget:CreateFontString(Widget:GetName().."Title", "BACKGROUND", "GameFontNormalSmall");
  Title:SetParent(Widget);
  Title:SetPoint("BOTTOMLEFT", Widget, "TOPLEFT", 20, 0);
  Title:SetText(L["PassLoot_Settings_Bind"]);
  Widget:SetParent(nil);
  Widget:Hide();
  Widget.initialize = function(level) self:DropDown_Init(level) end;
  Widget.YPaddingTop = Title:GetHeight();
  Widget.Height = Widget:GetHeight() + Widget.YPaddingTop;
  Widget.XPaddingLeft = -15;
  Widget.XPaddingRight = -15;
  Widget.Width = Widget:GetWidth() + Widget.XPaddingLeft + Widget.XPaddingRight;
  Widget.PreferredPriority = 4;
  Widget.Info = {
    L["PassLoot_Settings_Bind"],
    L["PassLoot_Settings_BindDesc"],
  };
  return Widget;
end
module.Widget = module:CreateWidget();

-- Local function to get the data and make sure it's valid data
function module.Widget:GetData(RuleNum)
  local Data = module:GetConfigOption("Bind", RuleNum);
  if ( not Data or type(Data) ~= "table" ) then
    Data = {};
  end
  for Key, Value in ipairs(Data) do
    if ( not tonumber(Value) ) then
      Data[Key] = module.NewFilterValue;
    end
  end
  return Data;
end

function module.Widget:GetNumFilters(RuleNum)
  local Value = self:GetData(RuleNum);
  return #Value;
end

function module.Widget:AddNewFilter()
  local Value = self:GetData();
  table.insert(Value, module.NewFilterValue);
  module:SetConfigOption("Bind", Value);
end

function module.Widget:RemoveFilter(Index)
  local Value = self:GetData();
  table.remove(Value, Index);
  module:SetConfigOption("Bind", Value);
end

function module.Widget:DisplayWidget(Index)
  if ( Index ) then
    module.FilterIndex = Index;
  end
  local Value = self:GetData();
  UIDropDownMenu_SetText(module:GetBindSlotText(Value[module.FilterIndex]), module.Widget);
end

function module.Widget:GetFilterText(Index)
  local Value = self:GetData();
  return module:GetBindSlotText(Value[Index]);
end

function module.Widget:SetMatch(ItemLink, Tooltip)
  local TextLeft2;
  local Bind;
  TextLeft2 = getglobal(Tooltip:GetName().."TextLeft2"):GetText();
  Bind = 2; -- module.Bind[2] = "None"
  if ( TextLeft2 ) then
    for Key = 3, #module.Choices do --Don't check for Key 1 (Any) or 2 (None)
      if ( TextLeft2 == module.Choices[Key].Type ) then
        Bind = Key;
        break;
      end
    end
  end
  module.CurrentMatch = Bind;
  module:Debug("Bind Type: "..Bind.." ("..module.Choices[Bind].Name..")");
end

function module.Widget:GetMatch(RuleNum, Index)
  local RuleValue = self:GetData(RuleNum);
  if ( RuleValue[Index] > 1 ) then
    if ( RuleValue[Index] ~= module.CurrentMatch ) then
      return false;
    end
  end
  return true;
end

function module:DropDown_Init(level)
  level = level or 1;
  local info = {};
  info.checked = false;
  info.func = self.DropDown_OnClick;
  info.arg1 = self;
  info.owner = self.Widget;
  for Key, Value in ipairs(self.Choices) do
    info.text = Value.Name;
    info.value = Value.Value;
    UIDropDownMenu_AddButton(info, level);
  end
end

function module:DropDown_OnClick()
  local Value = self.Widget:GetData();
  Value[self.FilterIndex] = this.value;
  self:SetConfigOption("Bind", Value);
  UIDropDownMenu_SetText(this:GetText(), this.owner);
end

function module:GetBindSlotText(BindID)
  for Key, Value in ipairs(self.Choices) do
    if ( Value.Value == BindID ) then
      return Value.Name;
    end
  end
  return "";
end

