﻿--PassLoot 3.1 by Odlaw
local PassLoot = LibStub("AceAddon-3.0"):GetAddon("PassLoot");
local L = LibStub("AceLocale-3.0"):GetLocale("PassLoot");

function PassLoot:ShowTooltip(frame)
  GameTooltip:SetOwner(PassLoot_MainFrame, "ANCHOR_TOPLEFT");
  if ( not frame ) then
    frame = this:GetName();
  end
  GameTooltip:SetText(PassLoot.FontWhite..L[frame]);
  GameTooltip:AddLine(PassLoot.FontGold..L[frame.."Desc"]);
  GameTooltip:Show();
end

--Function to copy tables, since passing tables is always by reference.
function PassLoot:CopyTable(OldDB)
  if ( not OldDB or type(OldDB) ~= "table" ) then
    return OldDB;
  end
  local NewDB;
  NewDB = {};
  for Key, Value in pairs(OldDB) do
    if ( type(Value) ~= "table" ) then
      NewDB[Key] = Value;
    else
      NewDB[Key] = self:CopyTable(Value);
    end
  end
  return NewDB;
end

-- I am going to use this function to scroll text boxes to the left instead of SetCursorPosition()
-- SetCursorPosition(0) requires I ClearFocus(), which will create a loop that I don't really like.
function PassLoot:ScrollLeft()
  this:HighlightText(0,1);
  this:Insert(" "..strsub(this:GetText(),1,1));
  this:HighlightText(0,1);
  this:Insert("");
  this:SetScript("OnUpdate", nil);
end

function PassLoot:DisplayCurrentRule()
  if ( not self.CurrentRule ) then
    self.CurrentRule = 0;
  end
  self.CurrentOptionFilter = { nil, 0 }; -- Frame, line #
  self:DisplayCurrentOptionFilter();
  if ( self.CurrentRule > 0 ) then
    PassLoot_Rules_Settings_Desc:Show();
    PassLoot_Rules_Settings_Options:Show();
    PassLoot_Rules_Settings_Filters:Show();
    self:Rules_Settings_Options_OnScroll();
    self:Rules_Settings_Filters_OnScroll();
    PassLoot_Rules_Settings_Desc:SetText(self.db.profile.Rules[self.CurrentRule].Desc);
    PassLoot_Rules_Settings_Desc:SetScript("OnUpdate", self.ScrollLeft);
  else
    PassLoot_Rules_Settings_Desc:Hide();
    PassLoot_Rules_Settings_Options:Hide();
    PassLoot_Rules_Settings_Filters:Hide();
  end
end

-- Show the widget that is selected
function PassLoot:DisplayCurrentOptionFilter()
  local Widget;
  if ( self.OldOptionFilter ) then
    self.OldOptionFilter:Hide();
  end
  if ( self.CurrentOptionFilter[1] == "Options" ) then
    PassLoot_Rules_Settings_Add:Show();
    PassLoot_Rules_Settings_Remove:Hide();
  elseif ( self.CurrentOptionFilter[1] == "Filters" ) then
    local WidgetKey, Offset = self:GetWidgetFromLineNum(self.CurrentOptionFilter[2]);
    PassLoot_Rules_Settings_Add:Hide();
    PassLoot_Rules_Settings_Remove:Show();
    if ( Offset ) then
      Widget = self.RuleWidgets[WidgetKey];
      Widget:DisplayWidget(Offset);
      Widget:Show();
    end
  else
    PassLoot_Rules_Settings_Add:Hide();
    PassLoot_Rules_Settings_Remove:Hide();
  end
  self.OldOptionFilter = Widget;
end

function PassLoot:SetLootMethod()
  local _, _, LineNum = string.find(this:GetName(), "Line(%d+)");
  local RuleNum = tonumber(LineNum) + FauxScrollFrame_GetOffset(PassLoot_Rules_RuleList_Scroll);
  if ( string.find(this:GetName(), "_Pass$") ) then
    if ( self.db.profile.Rules[RuleNum].Loot == "pass" ) then
      self.db.profile.Rules[RuleNum].Loot = "disabled";
    else
      self.db.profile.Rules[RuleNum].Loot = "pass";
    end
    getglobal("PassLoot_Rules_RuleList_ScrollLine"..LineNum.."_Greed"):SetChecked(false);
    getglobal("PassLoot_Rules_RuleList_ScrollLine"..LineNum.."_Need"):SetChecked(false);
  elseif ( string.find(this:GetName(), "_Greed$") ) then
    if ( self.db.profile.Rules[RuleNum].Loot == "greed" ) then
      self.db.profile.Rules[RuleNum].Loot = "disabled";
    else
      self.db.profile.Rules[RuleNum].Loot = "greed";
    end
    getglobal("PassLoot_Rules_RuleList_ScrollLine"..LineNum.."_Pass"):SetChecked(false);
    getglobal("PassLoot_Rules_RuleList_ScrollLine"..LineNum.."_Need"):SetChecked(false);
  elseif ( string.find(this:GetName(), "_Need$") ) then
    if ( self.db.profile.Rules[RuleNum].Loot == "need" ) then
      self.db.profile.Rules[RuleNum].Loot = "disabled";
    else
      self.db.profile.Rules[RuleNum].Loot = "need";
    end
    getglobal("PassLoot_Rules_RuleList_ScrollLine"..LineNum.."_Pass"):SetChecked(false);
    getglobal("PassLoot_Rules_RuleList_ScrollLine"..LineNum.."_Greed"):SetChecked(false);
  end
end

function PassLoot:SetDesc()
  if ( self.CurrentRule > 0 ) then
    self.db.profile.Rules[self.CurrentRule].Desc = this:GetText();
  end
  this:ClearFocus();
  PassLoot:Rules_RuleList_OnScroll();
end

function PassLoot:SetCurrentRule()
  local Counter;
  local _, _, LineNum = string.find(this:GetName(), "Line(%d+)");
  LineNum = tonumber(LineNum);
  self.CurrentRule = LineNum + FauxScrollFrame_GetOffset(PassLoot_Rules_RuleList_Scroll);
  for Counter = 1, self.NumRuleListLines do
    if ( Counter == LineNum ) then
      getglobal("PassLoot_Rules_RuleList_ScrollLine"..Counter.."Highlight"):Show();
    else
      getglobal("PassLoot_Rules_RuleList_ScrollLine"..Counter.."Highlight"):Hide();
    end
  end
  self:DisplayCurrentRule();
end

function PassLoot:SetCurrentOptionFilter(Button)
  local Counter;
  local _, _, Frame, LineNum = string.find(this:GetName(), "_(%a+)_ScrollLine(%d+)");
  LineNum = tonumber(LineNum);
  self.CurrentOptionFilter = {
    Frame,
    LineNum + FauxScrollFrame_GetOffset(getglobal("PassLoot_Rules_Settings_"..Frame.."_Scroll")),
  };
  if ( Button == "RightButton" and IsShiftKeyDown() and Frame == "Filters" ) then
    self:RemoveFilter();
  else
    for Counter = 1, self.NumOptionFilterLines do
      if ( LineNum == Counter ) then
        if ( Frame == "Options" ) then
          getglobal("PassLoot_Rules_Settings_Options_ScrollLine"..Counter.."Highlight"):Show();
          getglobal("PassLoot_Rules_Settings_Filters_ScrollLine"..Counter.."Highlight"):Hide();
        else
          getglobal("PassLoot_Rules_Settings_Options_ScrollLine"..Counter.."Highlight"):Hide();
          getglobal("PassLoot_Rules_Settings_Filters_ScrollLine"..Counter.."Highlight"):Show();
        end
      else
        getglobal("PassLoot_Rules_Settings_Options_ScrollLine"..Counter.."Highlight"):Hide();
        getglobal("PassLoot_Rules_Settings_Filters_ScrollLine"..Counter.."Highlight"):Hide();
      end
    end
  end
  self:DisplayCurrentOptionFilter();
end

function PassLoot:RemoveFilter()
  if ( self.CurrentRule > 0 and self.CurrentOptionFilter[1] == "Filters" and self.CurrentOptionFilter[2] > 0 ) then
    local WidgetKey, Offset = self:GetWidgetFromLineNum(self.CurrentOptionFilter[2]);
    if ( Offset ) then
      self.RuleWidgets[WidgetKey]:RemoveFilter(Offset);
    else
      for Index = self.RuleWidgets[WidgetKey]:GetNumFilters(), 1, -1 do
        self.RuleWidgets[WidgetKey]:RemoveFilter(Index);
      end
    end
    for Key, Value in pairs(self.RuleWidgets) do
      Value:Hide();
    end
    self.CurrentOptionFilter = { nil, 0 }; -- Frame, line #
    -- self:DisplayCurrentOptionFilter();
    self:Rules_Settings_Options_OnScroll();
    self:Rules_Settings_Filters_OnScroll();
  end
end

function PassLoot:ButtonClick()
  if ( not self.CurrentRule or not tonumber(self.CurrentRule) ) then
    self.CurrentRule = 0;
  end
  local NumRules, TempDB;
  if ( this:GetName() == "PassLoot_Rules_RuleList_Add" ) then
    TempDB = {}
    for Key, Value in ipairs(self.DefaultTemplate) do
      TempDB[Value[1]] = self:CopyTable(Value[2]);
    end
    table.insert(self.db.profile.Rules, TempDB);
    self:Rules_RuleList_OnScroll();
  elseif ( this:GetName() == "PassLoot_Rules_RuleList_Remove" ) then
    if ( self.CurrentRule > 0 ) then
      table.remove(self.db.profile.Rules, self.CurrentRule);
      self.CurrentRule = 0;
      self:Rules_RuleList_OnScroll();
      self:DisplayCurrentRule();
    end
  elseif ( this:GetName() == "PassLoot_Rules_RuleList_Up" ) then
    if ( self.CurrentRule > 1 ) then
      TempDB = self.db.profile.Rules[self.CurrentRule];
      self.db.profile.Rules[self.CurrentRule] = self.db.profile.Rules[self.CurrentRule - 1];
      self.db.profile.Rules[self.CurrentRule - 1] = TempDB;
      self.CurrentRule = self.CurrentRule - 1;
      self:Rules_RuleList_OnScroll();
      self:DisplayCurrentRule();
    end
  elseif ( this:GetName() == "PassLoot_Rules_RuleList_Down" ) then
    if ( self.CurrentRule > 0 and self.CurrentRule < #self.db.profile.Rules ) then
      TempDB = self.db.profile.Rules[self.CurrentRule];
      self.db.profile.Rules[self.CurrentRule] = self.db.profile.Rules[self.CurrentRule + 1];
      self.db.profile.Rules[self.CurrentRule + 1] = TempDB;
      self.CurrentRule = self.CurrentRule + 1;
      self:Rules_RuleList_OnScroll();
      self:DisplayCurrentRule();
    end
  elseif ( this:GetName() == "PassLoot_Rules_Settings_Add" ) then
    if ( self.CurrentRule > 0 and self.CurrentOptionFilter[1] == "Options" and self.CurrentOptionFilter[2] > 0 ) then
      self.RuleWidgets[self.CurrentOptionFilter[2]]:AddNewFilter();
      self:Rules_Settings_Filters_OnScroll();
    end
  elseif ( this:GetName() == "PassLoot_Rules_Settings_Remove" ) then
    self:RemoveFilter();
  elseif ( this:GetName() == "PassLoot_MainFrame_ModEnabled" ) then
    if ( self:IsEnabled() ) then
      self:Disable();
    else
      self:Enable();
    end
  elseif ( this:GetName() == "PassLoot_MainFrame_Quiet" ) then
    self.db.profile.Quiet = not self.db.profile.Quiet;
  elseif ( this:GetName() == "PassLoot_Profiles_Copy" ) then
    if ( PassLoot_Profiles_CopyProfile.value ) then
      self.db:CopyProfile(PassLoot_Profiles_CopyProfile.value);
    end
  elseif ( this:GetName() == "PassLoot_Profiles_Delete" ) then
    if ( PassLoot_Profiles_DeleteProfile.value ) then
      self.db:DeleteProfile(PassLoot_Profiles_DeleteProfile.value);
    end
  elseif ( this:GetName() == "PassLoot_Profiles_Create" ) then
    if ( PassLoot_Profiles_NewProfileName:GetText() and PassLoot_Profiles_NewProfileName:GetText() ~= "" ) then
      self.db:SetProfile(PassLoot_Profiles_NewProfileName:GetText());
    end
  elseif ( this:GetName() == "PassLoot_Profiles_Reset" ) then
    self:ResetProfile();
  elseif ( this:GetName() == "PassLoot_MainFrame_Done" ) then
    PassLoot_MainFrame:Hide();
  end
end

function PassLoot:Rules_RuleList_OnScroll()
  local Line, LineNum;
  local NumRules = #self.db.profile.Rules;
  FauxScrollFrame_Update(PassLoot_Rules_RuleList_Scroll, NumRules, self.NumRuleListLines, self.RuleListLineHeight);
  for Line=1, self.NumRuleListLines do
    LineNum = Line + FauxScrollFrame_GetOffset(PassLoot_Rules_RuleList_Scroll);
    if ( LineNum <= NumRules ) then
      getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."_Text"):SetText(self.db.profile.Rules[LineNum].Desc);
      getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."_Pass"):SetChecked(false);
      getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."_Greed"):SetChecked(false);
      getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."_Need"):SetChecked(false);
      if ( self.db.profile.Rules[LineNum].Loot == "pass" ) then
        getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."_Pass"):SetChecked(true);
      elseif ( self.db.profile.Rules[LineNum].Loot == "greed" ) then
        getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."_Greed"):SetChecked(true);
      elseif ( self.db.profile.Rules[LineNum].Loot == "need" ) then
        getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."_Need"):SetChecked(true);
      end
      getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line):Show();
      if ( LineNum == self.CurrentRule ) then
        getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."Highlight"):Show();
      else
        getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."Highlight"):Hide();
      end
    else
      getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line.."Highlight"):Hide();
      getglobal("PassLoot_Rules_RuleList_ScrollLine"..Line):Hide();
    end
  end
end

function PassLoot:Rules_Settings_Options_OnScroll()
  local Line, LineNum;
  local NumOptions = #self.RuleWidgets;
  FauxScrollFrame_Update(PassLoot_Rules_Settings_Options_Scroll, NumOptions, self.NumOptionFilterLines, self.OptionFilterLineHeight);
  for Line=1, self.NumOptionFilterLines do
    LineNum = Line + FauxScrollFrame_GetOffset(PassLoot_Rules_Settings_Options_Scroll);
    if ( LineNum <= NumOptions ) then
      getglobal("PassLoot_Rules_Settings_Options_ScrollLine"..Line.."_Text"):SetText(self.RuleWidgets[LineNum].Info[1] or "");
      getglobal("PassLoot_Rules_Settings_Options_ScrollLine"..Line):Show();
      if ( self.CurrentOptionFilter[1] == "Options" and self.CurrentOptionFilter[2] == LineNum ) then
        getglobal("PassLoot_Rules_Settings_Options_ScrollLine"..Line.."Highlight"):Show();
      else
        getglobal("PassLoot_Rules_Settings_Options_ScrollLine"..Line.."Highlight"):Hide();
      end
    else
      getglobal("PassLoot_Rules_Settings_Options_ScrollLine"..Line.."Highlight"):Hide();
      getglobal("PassLoot_Rules_Settings_Options_ScrollLine"..Line):Hide();
    end
  end
end

function PassLoot:Rules_Settings_Filters_OnScroll()
  if ( self.CurrentRule < 1 ) then
    return;
  end
  local Line, LineNum;
  local NumLines = 0;
  local WidgetKey, Offset, Text, NumFilters;
  for WidgetKey, WidgetValue in ipairs(self.RuleWidgets) do
    NumFilters = (WidgetValue:GetNumFilters() or 0);
    if ( NumFilters > 0 ) then
      NumLines = NumLines + NumFilters + 1;
    end
  end
  FauxScrollFrame_Update(PassLoot_Rules_Settings_Filters_Scroll, NumLines, self.NumOptionFilterLines, self.OptionFilterLineHeight);
  for Line=1, self.NumOptionFilterLines do
    LineNum = Line + FauxScrollFrame_GetOffset(PassLoot_Rules_Settings_Filters_Scroll);
    if ( LineNum <= NumLines ) then
      WidgetKey, Offset = self:GetWidgetFromLineNum(LineNum);
      if ( Offset ) then
        Text = self.RuleWidgets[WidgetKey]:GetFilterText(Offset) or "Value Error";
      else
        Text = PassLoot.FontGold..(self.RuleWidgets[WidgetKey].Info[1] or "Name Error");
      end
      getglobal("PassLoot_Rules_Settings_Filters_ScrollLine"..Line.."_Text"):SetText(Text);
      getglobal("PassLoot_Rules_Settings_Filters_ScrollLine"..Line):Show();
      if ( self.CurrentOptionFilter[1] == "Filters" and self.CurrentOptionFilter[2] == LineNum ) then
        getglobal("PassLoot_Rules_Settings_Filters_ScrollLine"..Line.."Highlight"):Show();
      else
        getglobal("PassLoot_Rules_Settings_Filters_ScrollLine"..Line.."Highlight"):Hide();
      end
    else
      getglobal("PassLoot_Rules_Settings_Filters_ScrollLine"..Line.."Highlight"):Hide();
      getglobal("PassLoot_Rules_Settings_Filters_ScrollLine"..Line):Hide();
    end
  end
end

function PassLoot:GetWidgetFromLineNum(Offset)
  local VariableList, NumFilters;
  for WidgetKey, WidgetValue in ipairs(self.RuleWidgets) do
    NumFilters = WidgetValue:GetNumFilters() or 0;
    if ( NumFilters > 0 ) then
      Offset = Offset - 1;
      if ( Offset == 0 ) then
        return WidgetKey, nil;
      end
    end
    if ( Offset <= NumFilters ) then
      return WidgetKey, Offset;
    else
      Offset = Offset - NumFilters;
    end
  end
end

function PassLoot:CurrentProfile_OnClick()
  self.db:SetProfile(this.value);
end

function PassLoot:CopyProfile_OnClick()
  UIDropDownMenu_SetText(this:GetText(), this.owner);
  getglobal(this.owner:GetName()).value = this.value;
end

function PassLoot:DeleteProfile_OnClick()
  UIDropDownMenu_SetText(this:GetText(), this.owner);
  getglobal(this.owner:GetName()).value = this.value;
end

function PassLoot:DropDown_CurrentProfile_Init(level)
  level = level or 1;
  local info = {};
  info.checked = false;
  info.func = self.CurrentProfile_OnClick;
  info.arg1 = self;
  info.owner = PassLoot_Profiles_CurrentProfile;
  for Key, Value in pairs(self.db:GetProfiles()) do
    info.text = Value;
    info.value = Value;
    UIDropDownMenu_AddButton(info);
  end
end

function PassLoot:DropDown_CopyProfile_Init(level)
  level = level or 1;
  local info = {};
  info.checked = false;
  info.func = self.CopyProfile_OnClick;
  info.arg1 = self;
  info.owner = PassLoot_Profiles_CopyProfile;
  for Key, Value in pairs(self.db:GetProfiles()) do
    info.text = Value;
    info.value = Value;
    if ( Value ~= self.db:GetCurrentProfile() ) then
      UIDropDownMenu_AddButton(info);
    end
  end
end

function PassLoot:DropDown_DeleteProfile_Init(level)
  level = level or 1;
  local info = {};
  info.checked = false;
  info.func = self.DeleteProfile_OnClick;
  info.arg1 = self;
  info.owner = PassLoot_Profiles_DeleteProfile;
  for Key, Value in pairs(self.db:GetProfiles()) do
    info.text = Value;
    info.value = Value;
    if ( Value ~= self.db:GetCurrentProfile() ) then
      UIDropDownMenu_AddButton(info);
    end
  end
end

function PassLoot:TabButtonClick()
  PanelTemplates_Tab_OnClick(PassLoot_TabbedMenuContainer);
  PassLoot_Rules:Hide();
  PassLoot_Modules:Hide();
  PassLoot_Profiles:Hide();
  if ( PassLoot_TabbedMenuContainer.selectedTab == 1 ) then
    PassLoot_Rules:Show();
  elseif ( PassLoot_TabbedMenuContainer.selectedTab == 2 ) then
    PassLoot_Modules:Show();
  elseif ( PassLoot_TabbedMenuContainer.selectedTab == 3 ) then
    PassLoot_Profiles:Show();
  end
end

