﻿--[[    
    Paranoia Enemy Player Alert
    Copyright (C) 2008 Victor Barrancos
  
    This file is part of Paranoia Enemy Player Alert.

    Paranoia Enemy Player Alert is free software: you can redistribute it 
    and/or modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation, either version 3 of the 
    License, or (at your option) any later version.

    Paranoia Enemy Player Alert is distributed in the hope that it will 
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Paranoia Enemy Player Alert.  If not, see 
    <http://www.gnu.org/licenses/>.
]]--

-- Paranoia Enemy Player Alert 1.11
-- zhCN localization

-- Paranoia中文汉化：WoWUI.Cn

-- Simplified Chinese translation by www.wowui.cn.


--Please note that the word Paranoia should not be translated anywhere it appears.
--Enemy Player Alert may be translated, although I don't think it's really important.

if GetLocale() == "zhCN" then

PARANOIA_SHORTNAME  = "Paranoia"
PARANOIA_LONGNAME   = "Paranoia敌对玩家警报插件"


-- ==========Slash commands==========
-- These are the slash commands that will be registered.
PARANOIA_SLASH1     = "/paranoia"
PARANOIA_SLASH2     = "/para"     --works the same as /paranoia, just shorter
PARANOIA_SLACONFIG  = "config"    --/paranoia config
PARANOIA_SLAENABLE  = "enable"    --/paranoia enable
PARANOIA_SLADISABLE = "disable"   --/paranoia disable
PARANOIA_SLADEBUG   = "debug"     --/paranoia debug
--"debug" should not be translated, because if a user has a problem
--and asks me about it, I'm going to tell them to type /paranoia debug.


-- ==========Prompt box text==========
-- These are the messageboxes that appear when reseting or installing Paranoia.
PARANOIA_RELOADPROMPTTEXT   = "Paranoia: 本次操作将重新加载插件，是否继续？"
PARANOIA_DEFAULTPROMPTTEXT  = "Paranoia: 本次操作将清除所有设置并重新加载插件，是否继续？"
PARANOIA_FIRSTRUNPROMPTTEXT = "感谢您下载使用Paranoia! 本插件当前被隐藏因为您在 %s. 您是否愿意现在打开配置窗口?" --zone name
PARANOIA_YESPROMPT          = "是"
PARANOIA_NOPROMPT           = "否"
PARANOIA_OKPROMPT           = "Ok"    --should be some sort of affirmative


-- ==========Faction names==========
-- Just need the names of the two factions here, I don't know if they're different in other languages.
PARANOIA_ALLIANCE   = "联盟"
PARANOIA_HORDE      = "部落"


-- ==========Miscellaneous text==========
-- Miscellaneous text used in various places throughout the addon.
PARANOIA_UNKNOWN      = "未知"
PARANOIA_INCOMBAT     = "战斗状态"
PARANOIA_SLASHTARGET  = "/target"
PARANOIA_LOCALDEFCHAN = "本地防务"
--This is the name of the LocalDefense channel, where the "Orgrimmar is under attack!" messages appear.
--The LocalDefense channel is always (in enUS) "LocalDefense - Current Zone". We need only the first part, "LocalDefense".
--It must be EXACTLY how it appears in-game, with exact capitalization too, otherwise Paranoia won't detect the LocalDefense channel.
--For example, in French, we'd use: "D閒enseLocale"
PARANOIA_NODETECTL1   = "非 %s" -- faction name
PARANOIA_NODETECTL2   = "玩家已被检测到."
--PARANOIA_NODETECTL1 and PARANOIA_NODETECTL2 are two separate lines.
--This shows up when Paranoia hasn't detected anyone nearby. Shows up as:
--No Alliance
--players detected.
PARANOIA_DEFAULTMSG   = "%f 玩家检测: %n (Lvl %l %c) - 最后一次见到在区域 %z (%x,%y)"
--This appears as "Alliance Player Detected: Playername (Lvl 70 Warrior) - Last seen near Thrallmar (12,12)"
--                 %f(action)                %n              %l %c                        %z         %x %y 
--The user can change this message, but what is listed above is the DEFAULT message, so it should be helpful
--and include all variables.
PARANOIA_MMTOOLTIP   = "左键点击开启Paranoia.\n右键点击打开配置选项.\n点击移动改变按钮位置."

-- ==========Interface Options Tab Names==========
PARANOIA_TABGENERAL       = "Paranoia一般选项"
PARANOIA_TABAPPEARANCE    = "Paranoia环境选项"
PARANOIA_TABALERTPOPUP    = "Paranoia警报选项"
PARANOIA_TABANNOUNCE      = "Paranoia通报选项"
PARANOIA_TABCOMM          = "Paranoia交互功能"

-- ==========Chat messages==========
PARANOIA_CHATFIRSTRUNHIDDEN   = "Paranoia已被禁用，因为你在 %s, 主城，战场，竞技场或者中立区域. 请输入 /paranoia config 打开配置窗口." --zone name
PARANOIA_CHATFIRSTRUN         = "鼠标点击并移动框体来改变位置. 右键点击或者输入 /paranoia config 进入配置模式."
--remember, the chat command might not be /paranoia config.
PARANOIA_CHATPARALOADED       = "|cFF9482CALifetapt|r|cFFFF7D0A's Paranoia敌对玩家警报 %s 已加载. 使用 /paranoia 或者 /para 命令."
--first %s = Paranoia's version number, second %s = Lifetapt in purple letters
PARANOIA_CHATLOCALIZEDBY      = "Paranoia中文汉化：WoWUI.Cn"
-- This message appears right after CHATPARALOADED when the user is using a non-english localization file.
-- Place your name and the language you are translating to here (if you want, or you can leave it blank and Paranoia will skip the message).
PARANOIA_CHATTARGETDISABLED   = "当你在战斗状态选中的目标被禁用."
PARANOIA_CHATENABLED          = "Paranoia已启用."
PARANOIA_CHATDISABLED         = "Paranoia已禁用."
PARANOIA_CHATDEBUGENABLED     = "调试模式启用." 
PARANOIA_CHATDEBUGDISABLED    = "调试模式禁用."
PARANOIA_CHATSLASHLIST        = "命令行列表" 
-- Slash commands need to match the ones listed above in the slash commands section.
PARANOIA_CHATSLASHLISTCONFIG  = "/paranoia config|r\n打开图形配置窗口." 
PARANOIA_CHATSLASHLISTENABLE  = "/paranoia enable|r\n启用插件." 
PARANOIA_CHATSLASHLISTDISABLE = "/paranoia disable|r\n禁用插件." 
PARANOIA_CHATSLASHLISTDEBUG   = "/paranoia debug|r\n启用调试模式 (可能导致聊天窗口刷屏)." 
PARANOIA_CHATSLASHLISTDEBUGL  = "/paranoia debuglist|r\n显示调试模式命令行." 
PARANOIA_CHATIGNORED          = "%s 将被忽略3个小时 (或者直到你下线)."
-- player name
PARANOIA_CHATTESTANNOUNCE     = "这是你的自定义信息样式. (本信息并没有真实发送.)"
PARANOIA_CHATFAKEANNOUNCE     = "[%s] 说: [Paranoia] %s"
-- player name, custom message
-- Appears as "[Jimmy] says: [Paranoia] Hostile player detected! blah blah blah"
PARANOIA_CHATINSTANCE         = "Paranoia已被禁用."
PARANOIA_CHATUNRECOGNIZED     = "无效的命令. [%s]\n使用 /paranoia 或者 /para 获取命令行列表."

-- ==========Alert Popup Message==========
PARANOIA_ALERTNOCLASS     = "%s 玩家被检测到! (%s)" 
-- faction, player name  "Alliance player detected! (Pally)"
PARANOIA_ALERTCLASSKNOWN  = "%s %s 被检测到! (%s)" 
-- faction, class, player name  "Alliance Paladin detected! (Pally)"
PARANOIA_GUILDALERTNOCLASS       = "%s (公会) 检测到敌对目标! (%s, %i,%i)"
-- guild member name, hostile player name, coords. Appears as Johnny (guild) detected a hostile! (Pally, 12,13)
PARANOIA_GUILDALERTCLASS         = "%s (公会) 检测到敌对目标 %s! (%s, %i,%i)"
-- guild member name, class, hostile player name, coords. Appears as Johnny (guild) detected a hostile Paladin! (Pally, 12,13)
PARANOIA_PARTYALERTNOCLASS       = "%s (小队) 检测到敌对目标! (%s, %i,%i)"
-- party memeber name, hostile player name, coords
PARANOIA_PARTYALERTCLASS         = "%s (小队) 检测到敌对目标 %s! (%s, %i,%i)"
-- party memeber name, class, hostile player name, coords
PARANOIA_ALERTMOVEABLE    = "鼠标点击并移动框体来改变位置."
PARANOIA_ALERTTEST        = "%s 玩家被检测到! (wowui.cn)"
-- faction. Replace Testplayer with an equivalent if possible.


-- ==========Classes==========
--For the SHORT version of a class name, use the first four letters.

PARANOIA_DRUID_SHORT              = "德鲁伊"
PARANOIA_HUNTER_SHORT             = "猎人"
PARANOIA_ROGUE_SHORT              = "潜行者"
PARANOIA_PRIEST_SHORT             = "牧师"
PARANOIA_PALADIN_SHORT            = "圣骑士"
PARANOIA_SHAMAN_SHORT             = "萨满祭司"
PARANOIA_MAGE_SHORT               = "法师"
PARANOIA_WARRIOR_SHORT            = "战士"
PARANOIA_WARLOCK_SHORT            = "术士"
PARANOIA_DEATHKNIGHT_SHORT        = "死亡骑士"

--Use the male versions of classnames for languages that distinguish between genders.
PARANOIA_DRUID                    = "德鲁伊"
PARANOIA_HUNTER                   = "猎人"
PARANOIA_ROGUE                    = "潜行者"
PARANOIA_PRIEST                   = "牧师"
PARANOIA_PALADIN                  = "圣骑士"
PARANOIA_SHAMAN                   = "萨满祭司"
PARANOIA_MAGE                     = "法师"
PARANOIA_WARRIOR                  = "战士"
PARANOIA_WARLOCK                  = "术士"
PARANOIA_DEATHKNIGHT              = "死亡骑士"


-- ==========Announcement Dropdown==========
--Use the same color codes.
PARANOIA_ANNOUNCESAY        = "通报到 /说"
PARANOIA_ANNOUNCEYELL       = "通报到 |cFFFF3F3F/大喊|r"
PARANOIA_ANNOUNCEPARTY      = "通报到 |cFFAAAAFF/小队|r"
PARANOIA_ANNOUNCERAID       = "通报到 |cFFFF7F00/团队|r"
PARANOIA_ANNOUNCEGUILD      = "通报到 |cFF3FFF3F/公会|r"
PARANOIA_ANNOUNCEBG         = "通报到 |cFFFF7F00/战场|r"
PARANOIA_ANNOUNCELOCALDEF   = "通报到 |cFFFFD1BF/%i (本地防务)|r"
-- channel number, appears as:
-- "Announce to /3 (LocalDefense)"
PARANOIA_ANNOUNCEIGNORE     = "忽略 %s "
-- player name
PARANOIA_ANNOUNCECONFIG     = "打开Paranoia选项"


-- ====================Paranoia Options====================

PARANOIA_RESETPOSITIONS               = "重置位置"
-- resets the positions of windows
PARANOIA_TESTBUTTON                   = "测试"
-- tests either the custom message or the alert popup

-- ==========Paranoia General Tab==========
PARANOIA_GENERAL_ENABLE              = "启用Paranoia"
PARANOIA_GENERAL_ENABLESOUND         = "启用警报声音"
PARANOIA_GENERAL_DISABLEBG           = "战场里禁用"
PARANOIA_GENERAL_DISABLEARENA        = "竞技场里禁用"
PARANOIA_GENERAL_DISABLESANCT        = "主城里禁用 (如：沙塔斯城)"
PARANOIA_GENERAL_DISABLEFFA          = "中立区域禁用"
PARANOIA_GENERAL_HIDELIST            = "隐藏敌对玩家列表"
PARANOIA_GENERAL_LOCKLIST            = "锁定Paranoia窗口 (可以穿过窗体点击)"

-- sliders have three strings, the title, the highest value, and the lowest value

PARANOIA_GENERALSLI_LISTTIMEOUT       = "敌对玩家列表超时 (%i 秒)"
-- number of seconds
PARANOIA_GENERALSLI_LISTTIMEOUTHIGH   = "300 (5 分钟)"
PARANOIA_GENERALSLI_LISTTIMEOUTLOW    = "10 秒"

PARANOIA_GENERALSLI_WARNTIMEOUT       = "警报超时 (%i 秒)"
-- number of seconds
PARANOIA_GENERALSLI_WARNTIMEOUTHIGH   = "300 (5 分钟)"
PARANOIA_GENERALSLI_WARNTIMEOUTLOW    = "10 秒"

-- ==========Paranoia Alert Popup Tab==========
PARANOIA_ALERTPOP_ENABLE                  = "启用敌对玩家弹出警报"

PARANOIA_ALERTPOPSLI_FADE                 = "渐隐持续时间 (%.1f 秒)"
-- number of seconds, appears as "Fade Duration (3.5 seconds)"
PARANOIA_ALERTPOPSLI_FADEHIGH             = "6 (很长)"
PARANOIA_ALERTPOPSLI_FADELOW              = "0 (立即)"

PARANOIA_ALERTPOPSLI_DISP                 = "禁用渐隐持续时间 (%.1f 秒)"
-- number of seconds
PARANOIA_ALERTPOPSLI_DISPHIGH             = "6 (很长)"
PARANOIA_ALERTPOPSLI_DISPLOW              = "0.5 (很短)"

PARANOIA_ALERTPOPSLI_ALPHA                 = "文字透明度 (%.0f 百分比)"
-- percent
PARANOIA_ALERTPOPSLI_ALPHAHIGH             = "100 (最大)"
PARANOIA_ALERTPOPSLI_ALPHALOW              = "20 (最少)"

-- =========Paranoia Appearance Tab==========
PARANOIA_APPEARANCE_FADEOUT               = "渐隐无活动的敌对目标"
PARANOIA_APPEARANCE_MINIMAPBUTTON         = "隐藏小地图图标"

PARANOIA_APPEARANCESLI_BOPACITY           = "边框透明度 (%.0f 百分比)"
-- percentage, appears as "Border Opacity (50%)"
PARANOIA_APPEARANCESLI_BOPACITYHIGH       = "100 (最大)"
PARANOIA_APPEARANCESLI_BOPACITYLOW        = "0 (不可见)"

PARANOIA_APPEARANCESLI_POPACITY           = "面板透明度 (%.0f 百分比)"
-- percentage, appears as "Panel Opacity (50%)"
PARANOIA_APPEARANCESLI_POPACITYHIGH       = "100 (最大)"
PARANOIA_APPEARANCESLI_POPACITYLOW        = "20 (最少)"

PARANOIA_APPEARANCESLI_MAXHOSTILE         = "敌对目标最多数量 (%i 敌对玩家)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_MAXHOSTILEHIGH     = "15 敌对目标"
PARANOIA_APPEARANCESLI_MAXHOSTILELOW      = "4 敌对目标"

PARANOIA_APPEARANCESLI_SCALE         = "敌对目标列表缩放 (%.0f percent)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_SCALEHIGH     = "180% (巨大)"
PARANOIA_APPEARANCESLI_SCALELOW      = "60% (最小)"

-- =========Paranoia Announce Tab==========
PARANOIA_ANNOUNCE_HEADER                  = "|cFFFFFFFF在下面表格输入你的自定义信息.|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_HITENTER                = "按回车保存你的自定义信息."

--This is a multiline message explaining to the user how to use formating.
--The %x variables will not actually be changed, they will be displayed to the user.
--For example:
--"%l -- Replaced with the enemy's level."
--Please note that the interface options frame isn't very wide, so these messages must be fairly short,
--while also helpful.
PARANOIA_ANNOUNCE_PATTERNHELP1            = "|cFFFFFFFF使用以下参数建立你的信息.|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_PATTERNHELP2            = "%f - 替换为敌对阵营."
PARANOIA_ANNOUNCE_PATTERNHELP3            = "%n - 替换为敌对目标名字."
PARANOIA_ANNOUNCE_PATTERNHELP4            = "%l - 替换为敌对目标等级."
PARANOIA_ANNOUNCE_PATTERNHELP5            = "%c - 替换为敌对目标职业."
PARANOIA_ANNOUNCE_PATTERNHELP6            = "%z - 替换为敌对目标最后一次被发现的区域."
PARANOIA_ANNOUNCE_PATTERNHELP7            = "%x 和 %y - 替换为敌对目标最后一次被发现的坐标."
PARANOIA_ANNOUNCE_PATTERNHELP8            = " "
-- PATTERNHELP8 is an extra line in case one line is too long and needs to be split into two lines.
-- PATTERNHELP1 is the header, and therefore CANNOT be split into two lines.
PARANOIA_ANNOUNCE_TESTNAME                = "Lifetapt"
-- This is the name used for the test message (they'll appear as a Mage, i.e. Jimmy the Mage). 
-- It can be changed to a common name in a different language.

-- =========Paranoia Communication Tab==========
PARANOIA_COMM_ENABLECOMM            = "启用交互功能"
PARANOIA_COMM_GROUPWARN             = "小队成员检测到敌对目标警告我"
PARANOIA_COMM_GUILDWARN             = "附近的公会成员检测到敌对目标警告我"
end