﻿--[[    
    Paranoia Enemy Player Alert
    Copyright (C) 2008 Victor Barrancos
  
    This file is part of Paranoia Enemy Player Alert.

    Paranoia Enemy Player Alert is free software: you can redistribute it 
    and/or modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation, either version 3 of the 
    License, or (at your option) any later version.

    Paranoia Enemy Player Alert is distributed in the hope that it will 
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Paranoia Enemy Player Alert.  If not, see 
    <http://www.gnu.org/licenses/>.
]]--

-- Paranoia Enemy Player Alert 1.11
-- ruRU localization by Swix

if GetLocale() == "ruRU" then

PARANOIA_SHORTNAME  = "Paranoia"
PARANOIA_LONGNAME   = "Paranoia Enemy Player Alert"


-- ==========Slash commands==========
-- These are the slash commands that will be registered.
PARANOIA_SLASH1     = "/paranoia"
PARANOIA_SLASH2     = "/para"     --works the same as /paranoia, just shorter
PARANOIA_SLACONFIG  = "config"    --/paranoia config
PARANOIA_SLAENABLE  = "enable"    --/paranoia enable
PARANOIA_SLADISABLE = "disable"   --/paranoia disable
PARANOIA_SLADEBUG   = "debug"     --/paranoia debug
--"debug" should not be translated, because if a user has a problem
--and asks me about it, I'm going to tell them to type /paranoia debug.


-- ==========Prompt box text==========
-- These are the messageboxes that appear when reseting or installing Paranoia.
PARANOIA_RELOADPROMPTTEXT   = "Paranoia: Это действие приведёт к перезагрузке интерфейса. Вы хотите продолжить?"
PARANOIA_DEFAULTPROMPTTEXT  = "Paranoia: Это действие приведёт к сбросу всех настроек и перезагрузке интерфейса. Вы хотите продолжить?"
PARANOIA_FIRSTRUNPROMPTTEXT = "Спасибо за установку Paranoia. В данный момент аддон скрыт, так как вы в %s. Хотите открыть окно настроек?" --zone name
PARANOIA_YESPROMPT          = "Да"
PARANOIA_NOPROMPT           = "Нет"
PARANOIA_OKPROMPT           = "Ок"    --should be some sort of affirmative


-- ==========Faction names==========
-- Just need the names of the two factions here, I don't know if they're different in other languages.
PARANOIA_ALLIANCE   = "Альянс"
PARANOIA_HORDE      = "Орда"


-- ==========Miscellaneous text==========
-- Miscellaneous text used in various places throughout the addon.
PARANOIA_UNKNOWN      = "Неизвестен"
PARANOIA_INCOMBAT     = "В бою"
PARANOIA_SLASHTARGET  = "/target"
PARANOIA_LOCALDEFCHAN = "Оборона: локальный"
--This is the name of the LocalDefense channel, where the "Orgrimmar is under attack!" messages appear.
--It must be EXACTLY how it appears in-game, with exact capitalization too, otherwise Paranoia won't detect the LocalDefense channel.
--For example, in French, we'd use: "DéfenseLocale". (Note the absence of a space, DéfenseLocale not Défense Locale.)
PARANOIA_NODETECTL1   = "Игроков фракции %s" -- faction name
PARANOIA_NODETECTL2   = "не обнаружено."
--PARANOIA_NODETECTL1 and PARANOIA_NODETECTL2 are two separate lines.
--This shows up when Paranoia hasn't detected anyone nearby. Shows up as:
--No Alliance
--players detected.
--Please note that the faction name doesn't have to be in the first line. You can also do
--There are no
--Alliance nearby.
PARANOIA_DEFAULTMSG   = "Обнаружен игрок фракции %f: %n (Ур. %l %c). Местоположение: %z (%x,%y)"
--This appears as "Alliance Player Detected: Playername (Lvl 70 Warrior) - Last seen near Thrallmar (12,12)"
--                 %f(action)                %n              %l %c                        %z         %x %y 
--The user can change this message, but what is listed above is the DEFAULT message, so it should be helpful
--and include all variables.
PARANOIA_MMTOOLTIP   = "Левый клик включает/отключает Paranoia.\nПравый клик вызывает окно настроет.\nЗажмите левую кнопку, чтобы переместить эту иконку."


-- ==========Interface Options Tab Names==========
PARANOIA_TABGENERAL       = "Общие"
PARANOIA_TABAPPEARANCE    = "Отображение"
PARANOIA_TABALERTPOPUP    = "Предупреждения"
PARANOIA_TABANNOUNCE      = "Announce"
PARANOIA_TABCOMM          = "Коммуникация"


-- ==========Chat messages==========
PARANOIA_CHATFIRSTRUNHIDDEN   = "Аддон Paranoia отключен, т.к. вы в %s. Чтобы открыть окно настроек, введите /paranoia config." --zone name
PARANOIA_CHATFIRSTRUN         = "Вы можете свободно перемещать окно Paranoia по всему экрану. Чтобы открыть настройки, кликните правой кнопкой мыши по окну или введите /paranoia config."
--remember, the chat command might not be /paranoia config.
PARANOIA_CHATPARALOADED       = "Paranoia Enemy Player Alert v%s от %s успешно загружен.\nДля получения списка команд введите /paranoia или /para."
--first %s = version number, second %s = Lifetapt in purple letters. Appears as Paranoia Enemy Player Alert v1.11
PARANOIA_CHATLOCALIZEDBY      = "Русификация Paranoia выполнена Swix'ом..."
-- This message appears right after CHATPARALOADED when the user is using a non-english localization file.
-- Place your name and the language you are translating to here (if you want, or you can leave it blank and Paranoia will skip the message).
PARANOIA_CHATTARGETDISABLED   = "Выделение цели отключено, пока вы в бою."
PARANOIA_CHATENABLED          = "Активирован."
PARANOIA_CHATDISABLED         = "Отключен."
PARANOIA_CHATDEBUGENABLED     = "Режим отладки активирован." 
PARANOIA_CHATDEBUGDISABLED    = "Режим отладки отключен."
PARANOIA_CHATSLASHLIST        = "Список слэш-команд" 
-- Slash commands need to match the ones listed above in the slash commands section.
PARANOIA_CHATSLASHLISTCONFIG  = "/paranoia config|r\nОткрывает окно настроек Paranoia." 
PARANOIA_CHATSLASHLISTENABLE  = "/paranoia enable|r\nВключение аддона Paranoia." 
PARANOIA_CHATSLASHLISTDISABLE = "/paranoia disable|r\nВыключение аддона Paranoia." 
PARANOIA_CHATSLASHLISTDEBUG   = "/paranoia debug|r\nПереключает режим отладки Paranoia (приведёт к множественному спаму в чате)." 
PARANOIA_CHATSLASHLISTDEBUGL  = "/paranoia debuglist|r\nОтображает список команд для отладки." 
PARANOIA_CHATIGNORED          = "%s будет игнорироваться в течении 3 часов (или до выхода из игры)."
-- player name
PARANOIA_CHATTESTANNOUNCE     = "This is what your custom message will look like. (The message wasn't actually sent.)"
PARANOIA_CHATFAKEANNOUNCE     = "[%s] говорит: [Paranoia] %s"
-- player name, custom message
-- Appears as "[Jimmy] says: [Paranoia] Hostile player detected! blah blah blah"
PARANOIA_CHATINSTANCE         = "Аддон Paranoia был отключен, т.к. вы вошли в инстанс."
PARANOIA_CHATUNRECOGNIZED     = "Нераспознанная команда. [%s]\nВведите /paranoia или /para для отображения списка команд."

-- ==========Alert Popup Message==========
PARANOIA_ALERTNOCLASS     = "Обнаружен игрок фракции %s! (%s)" 
-- faction, player name  "Alliance player detected! (Pally)"
PARANOIA_ALERTCLASSKNOWN  = "Обнаружен %s %s! (%s)" 
-- faction, class, player name  "Alliance Paladin detected! (Pally)"
PARANOIA_GUILDALERTNOCLASS       = "Согильдиец %s обнаружил вражеского игрока! (%s, %i,%i)" 
-- guild member name, hostile player name, coords
PARANOIA_GUILDALERTCLASS         = "Согильдиец %s обнаружил вражеского игрока (класс - %s)! (%s, %i,%i)" 
-- guild member name, class, hostile player name, coords
PARANOIA_PARTYALERTNOCLASS       = "Сопартиец %s обнаружил вражеского игрока! (%s, %i,%i)" 
-- party member name, hostile player name, coords
PARANOIA_PARTYALERTCLASS         = "Сопартиец %s обнаружил вражеского игрока (класс - %s)! (%s, %i,%i)" 
-- party member name, class, hostile player name, coords
PARANOIA_ALERTMOVEABLE    = "Переместите это окно в любое удобное для вас место"
PARANOIA_ALERTTEST        = "Обнаружен игрок фракции %s! (Testplayer)"
-- faction. Replace Testplayer with an equivalent if possible.


-- ==========Classes==========
--Class names.

--The short names should be the first 4 characters of a class name. If a class name is shorter than 4 characters
PARANOIA_DRUID_SHORT              = "Друи"
PARANOIA_HUNTER_SHORT             = "Охот"
PARANOIA_ROGUE_SHORT              = "Разб"
PARANOIA_PRIEST_SHORT             = "Жрец"
PARANOIA_PALADIN_SHORT            = "Пала"
PARANOIA_SHAMAN_SHORT             = "Шама"
PARANOIA_MAGE_SHORT               = "Маг"
PARANOIA_WARRIOR_SHORT            = "Воин"
PARANOIA_WARLOCK_SHORT            = "Черн"
PARANOIA_DEATHKNIGHT_SHORT        = "Deat"

--Use the male versions of classnames for languages that distinguish between genders.
PARANOIA_DRUID                    = "Друид"
PARANOIA_HUNTER                   = "Охотник"
PARANOIA_ROGUE                    = "Разбойник"
PARANOIA_PRIEST                   = "Жрец"
PARANOIA_PALADIN                  = "Паладин"
PARANOIA_SHAMAN                   = "Шаман"
PARANOIA_MAGE                     = "Маг"
PARANOIA_WARRIOR                  = "Воин"
PARANOIA_WARLOCK                  = "Чернокнижник"
PARANOIA_DEATHKNIGHT              = "Death Knight"
--NEED THE DEATHKNIGHT TRANSLATION!


-- ==========Announcement Dropdown==========
--Use the same color codes.
PARANOIA_ANNOUNCESAY        = "Сообщить в /say"
PARANOIA_ANNOUNCEYELL       = "Сообщить в |cFFFF3F3F/yell|r"
PARANOIA_ANNOUNCEPARTY      = "Сообщить в |cFFAAAAFF/party|r"
PARANOIA_ANNOUNCERAID       = "Сообщить в |cFFFF7F00/raid|r"
PARANOIA_ANNOUNCEGUILD      = "Сообщить в |cFF3FFF3F/guild|r"
PARANOIA_ANNOUNCEBG         = "Сообщить в |cFFFF7F00/battleground|r"
PARANOIA_ANNOUNCELOCALDEF   = "Сообщить в |cFFFFD1BF/%i (LocalDefense)|r"
-- channel number, appears as:
-- "Announce to /3 (LocalDefense)"
PARANOIA_ANNOUNCEIGNORE     = "Игнорировать %s в этой сессии"
-- player name
PARANOIA_ANNOUNCECONFIG     = "Открыть настройки Paranoia"


-- ====================Paranoia Options====================

PARANOIA_RESETPOSITIONS               = "Сбросить позицию"
-- resets the positions of windows
PARANOIA_TESTBUTTON                   = "Тест"
-- tests either the custom message or the alert popup

-- ==========Paranoia General Tab==========
PARANOIA_GENERAL_ENABLE              = "Активировать Paranoia"
PARANOIA_GENERAL_ENABLESOUND         = "Включить предупреждающий звук"
PARANOIA_GENERAL_DISABLEBG           = "Отключить на бг"
PARANOIA_GENERAL_DISABLEARENA        = "Отключить на арене"
PARANOIA_GENERAL_DISABLESANCT        = "Отключить в священных местах"
PARANOIA_GENERAL_DISABLEFFA          = "Отключить в free-for-all зонах"
PARANOIA_GENERAL_HIDELIST            = "Скрыть список вражеских игроков"
PARANOIA_GENERAL_LOCKLIST            = "Закрепить окно Paranoia"

-- sliders have three strings, the title, the highest value, and the lowest value

PARANOIA_GENERALSLI_LISTTIMEOUT       = "Таймаут вражеского списка (%i секунд)"
-- number of seconds
PARANOIA_GENERALSLI_LISTTIMEOUTHIGH   = "300 (5 минут)"
PARANOIA_GENERALSLI_LISTTIMEOUTLOW    = "10 секунд"

PARANOIA_GENERALSLI_WARNTIMEOUT       = "Таймаут предупреждения (%i секунд)"
-- number of seconds
PARANOIA_GENERALSLI_WARNTIMEOUTHIGH   = "300 (5 минут)"
PARANOIA_GENERALSLI_WARNTIMEOUTLOW    = "10 секунд"

-- ==========Paranoia Alert Popup Tab==========
PARANOIA_ALERTPOP_ENABLE                  = "Включить всплывающее окно-предупреждение"

PARANOIA_ALERTPOPSLI_FADE                 = "Время скрытия окна (%.1f секунд)"
-- number of seconds, appears as "Fade Duration (3.5 seconds)"
PARANOIA_ALERTPOPSLI_FADEHIGH             = "6 (долго)"
PARANOIA_ALERTPOPSLI_FADELOW              = "0 (мгновенно)"

PARANOIA_ALERTPOPSLI_DISP                 = "Время отображения (%.1f секунд)"
-- number of seconds
PARANOIA_ALERTPOPSLI_DISPHIGH             = "6 (долго)"
PARANOIA_ALERTPOPSLI_DISPLOW              = "0.5 (очень быстро)"

PARANOIA_ALERTPOPSLI_ALPHA                 = "Прозрачность текста (%.0f процентов)"
-- percent
PARANOIA_ALERTPOPSLI_ALPHAHIGH             = "100 (непрозрачный)"
PARANOIA_ALERTPOPSLI_ALPHALOW              = "20 (очень светлый)"

-- =========Paranoia Appearance Tab==========
PARANOIA_APPEARANCE_FADEOUT               = "Постепенно скрыть неактивные позиции"
PARANOIA_APPEARANCE_MINIMAPBUTTON         = "Скрыть кнопку на миникарте"

PARANOIA_APPEARANCESLI_BOPACITY           = "Прозрачность границ (%.0f процентов)"
-- percentage, appears as "Border Opacity (50%)"
PARANOIA_APPEARANCESLI_BOPACITYHIGH       = "100 (непрозрачные)"
PARANOIA_APPEARANCESLI_BOPACITYLOW        = "0 (невидимые)"

PARANOIA_APPEARANCESLI_POPACITY           = "Прозрачность списка (%.0f процентов)"
-- percentage, appears as "Panel Opacity (50%)"
PARANOIA_APPEARANCESLI_POPACITYHIGH       = "100 (непрозрачный)"
PARANOIA_APPEARANCESLI_POPACITYLOW        = "20 (очень светлый)"

PARANOIA_APPEARANCESLI_MAXHOSTILE         = "Максимальное число врагов (%i игроков)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_MAXHOSTILEHIGH     = "15 врагов"
PARANOIA_APPEARANCESLI_MAXHOSTILELOW      = "4 врага"

PARANOIA_APPEARANCESLI_SCALE         = "Масштаб списка (%.0f процентов)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_SCALEHIGH     = "180% (большой)"
PARANOIA_APPEARANCESLI_SCALELOW      = "60% (маленький)"


-- =========Paranoia Announce Tab==========
PARANOIA_ANNOUNCE_HEADER                  = "|cFFFFFFFFВведите ваше сообщение в окно ввода ниже.|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_HITENTER                = "Нажмите Enter, чтобы сохранить ваше сообщение."

--This is a multiline message explaining to the user how to use formating.
--The %x variables will not actually be changed, they will be displayed to the user.
--For example:
--"%l -- Replaced with the enemy's level."
--Please note that the interface options frame isn't very wide, so these messages must be fairly short,
--while also helpful.
PARANOIA_ANNOUNCE_PATTERNHELP1            = "|cFFFFFFFFИспользуйте следующие шаблоны, чтобы создать ваше сообщение.|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_PATTERNHELP2            = "%f - вражеская фракция."
PARANOIA_ANNOUNCE_PATTERNHELP3            = "%n - имя вражеского игрока."
PARANOIA_ANNOUNCE_PATTERNHELP4            = "%l - уровень вражеского игрока."
PARANOIA_ANNOUNCE_PATTERNHELP5            = "%c - класс вражеского игрока."
PARANOIA_ANNOUNCE_PATTERNHELP6            = "%z - зона, где был замечен вражеский игрок."
PARANOIA_ANNOUNCE_PATTERNHELP7            = "%x и %y - координаты, где был замечен вражеский игрок."
PARANOIA_ANNOUNCE_PATTERNHELP8            = " "
-- PATTERNHELP8 is an extra line in case one line is too long and needs to be split into two lines.
-- PATTERNHELP1 is the header, and therefore CANNOT be split into two lines.
PARANOIA_ANNOUNCE_TESTNAME                = "Ускарегот"
-- This is the name used for the test message (they'll appear as a Mage, i.e. Jimmy the Mage). 
-- It can be changed to a common name in a different language.

-- =========Paranoia Communication Tab==========
PARANOIA_COMM_ENABLECOMM            = "Активировать коммуникацию"
PARANOIA_COMM_GROUPWARN             = "Предупреждать, если сопартиец обнаружил врага"
PARANOIA_COMM_GUILDWARN             = "Предупреждать, если согильдиец обнаружил врага"

end
