﻿--[[    
    Paranoia Enemy Player Alert
    Copyright (C) 2008 Victor Barrancos
  
    This file is part of Paranoia Enemy Player Alert.

    Paranoia Enemy Player Alert is free software: you can redistribute it 
    and/or modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation, either version 3 of the 
    License, or (at your option) any later version.

    Paranoia Enemy Player Alert is distributed in the hope that it will 
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Paranoia Enemy Player Alert.  If not, see 
    <http://www.gnu.org/licenses/>.
]]--

-- Paranoia Enemy Player Alert 1.11
-- frFR localization

-- Traduction française de Paranoia par Minihunt EU@Ner'zhul.
-- NOTE: Certains textes ont été traduits machine.

-- French translation by Minihunt EU@Ner'zhul.
-- NOTE: Some text was machine translated.


if GetLocale() == "frFR" then

--Please note that the word Paranoia should not be translated anywhere it appears.
--Enemy Player Alert may be translated, although I don't think it's really important.


PARANOIA_SHORTNAME  = "Paranoia"
PARANOIA_LONGNAME   = "Paranoia Enemy Player Alert"


-- ==========Slash commands==========
-- These are the slash commands that will be registered.
PARANOIA_SLASH1     = "/paranoia"
PARANOIA_SLASH2     = "/para"     --works the same as /paranoia, just shorter
PARANOIA_SLACONFIG  = "config"    --/paranoia config
PARANOIA_SLAENABLE  = "activé"    --/paranoia enable
PARANOIA_SLADISABLE = "désactivé"   --/paranoia disable
PARANOIA_SLADEBUG   = "debug"     --/paranoia debug
--"debug" should not be translated, because if a user has a problem
--and asks me about it, I'm going to tell them to type /paranoia debug.


-- ==========Prompt box text==========
-- These are the messageboxes that appear when reseting or installing Paranoia.
PARANOIA_RELOADPROMPTTEXT   = "Paranoia: Cette action doit recharger l'interface. Souhaitez-vous continuer?"
PARANOIA_DEFAULTPROMPTTEXT  = "Paranoia: Cette action doit effacer tous vos réglage et recharger l'interface. Souhaitez-vous continuer?"
PARANOIA_FIRSTRUNPROMPTTEXT = "Merci d'avoir télécharger Paranoia! Cette addon est actuellement caché car vous êtes dans %s. Souhaitez-vous ouvrir la fenêtre d'options?" --zone name
PARANOIA_YESPROMPT          = "Oui"
PARANOIA_NOPROMPT           = "Non"
PARANOIA_OKPROMPT           = "D'accord"    --should be some sort of affirmative


-- ==========Faction names==========
-- Just need the names of the two factions here, I don't know if they're different in other languages.
PARANOIA_ALLIANCE   = "Alliance"
PARANOIA_HORDE      = "Horde"


-- ==========Miscellaneous text==========
-- Miscellaneous text used in various places throughout the addon.
PARANOIA_UNKNOWN      = "Inconnu"
PARANOIA_INCOMBAT     = "En combat"
PARANOIA_SLASHTARGET  = "/target"
PARANOIA_LOCALDEFCHAN = "DéfenseLocale"
--This is the name of the LocalDefense channel, where the "Orgrimmar is under attack!" messages appear.
--The LocalDefense channel is always (in enUS) "LocalDefense - Current Zone". We need only the first part, "LocalDefense".
--It must be EXACTLY how it appears in-game, with exact capitalization too, otherwise Paranoia won't detect the LocalDefense channel.
--For example, in French, we'd use: "DéfenseLocale"
PARANOIA_NODETECTL1   = "Aucun joueur %s" -- faction name
PARANOIA_NODETECTL2   = "détecté."
--PARANOIA_NODETECTL1 and PARANOIA_NODETECTL2 are two separate lines.
--This shows up when Paranoia hasn't detected anyone nearby. Shows up as:
--No Alliance
--players detected.
--Please note that the faction name doesn't have to be in the first line. You can also do
--There are no
--Alliance nearby.
PARANOIA_DEFAULTMSG   = "Joueur de l'%f détecté: %n (Niv %l %c) - Vu pour la dernière fois vers %z (%x,%y)"
--This appears as "Alliance Player Detected: Playername (Lvl 70 Warrior) - Last seen near Thrallmar (12,12)"
--                 %f(action)                %n              %l %c                        %z         %x %y 
--The user can change this message, but what is listed above is the DEFAULT message, so it should be helpful
--and include all variables.
PARANOIA_MMTOOLTIP   = "Left-click to toggle Paranoia.\nRight-click to open Paranoia's options frame.\nClick and drag to move this button."           --**********NOT TRANSLATED**********


-- ==========Interface Options Tab Names==========
PARANOIA_TABGENERAL       = "Général"
PARANOIA_TABAPPEARANCE    = "Apparance"
PARANOIA_TABALERTPOPUP    = "Popup d'Alerte"
PARANOIA_TABANNOUNCE      = "Annonce"
PARANOIA_TABCOMM          = "Communication"


-- ==========Chat messages==========
PARANOIA_CHATFIRSTRUNHIDDEN   = "Paranoia est désactivé car vous êtes dans %s, qui est un sanctuaire, champs de bataille, arène, ou une zone libre pour tous. Tapez /paranoia config pour accéder à la fenêtre d'options." --zone name
PARANOIA_CHATFIRSTRUN         = "Cliquez et déplacez la fenêtre de Paranoia pour la positionner. Fait un clique droit ou tapez /paranoia config pour accéder à la fenêtre d'options."
--remember, the chat command might not be /paranoia config.
PARANOIA_CHATPARALOADED       = "Paranoia Enemy Player Alert v%s par %s est chargé.\nTapez /paranoia ou /para pour la liste des commandes."
--%s = Lifetapt in purple letters. Appears as Lifetapt's Paranoia Enemy Player Alert
PARANOIA_CHATLOCALIZEDBY      = "Traduction française de Paranoia par Minihunt EU@Ner'zhul.\nNOTE: Certains textes ont été traduits machine."
-- This message appears right after CHATPARALOADED when the user is using a non-english localization file.
-- Place your name and the language you are translating to here (if you want, or you can leave it blank and Paranoia will skip the message).
PARANOIA_CHATTARGETDISABLED   = "Le ciblage est désactivé quand vous êtes en combat."
PARANOIA_CHATENABLED          = "Paranoia a été activé."
PARANOIA_CHATDISABLED         = "Paranoia a été désactivé."
PARANOIA_CHATDEBUGENABLED     = "Mode de débogage activé." 
PARANOIA_CHATDEBUGDISABLED    = "Mode de débogage désactivé."
PARANOIA_CHATSLASHLIST        = "Liste des commande slash" 
-- Slash commands need to match the ones listed above in the slash commands section.
PARANOIA_CHATSLASHLISTCONFIG  = "/paranoia config|r\nOuvre la fenêtre d'option." 
PARANOIA_CHATSLASHLISTENABLE  = "/paranoia activé|r\nActive le addon Paranoia." 
PARANOIA_CHATSLASHLISTDISABLE = "/paranoia désactivé|r\nDésactive le addon Paranoia." 
PARANOIA_CHATSLASHLISTDEBUG   = "/paranoia debug|r\nBascule Paranoia en mode débogage (peut provoquer de nombres messages)." 
PARANOIA_CHATSLASHLISTDEBUGL  = "/paranoia debuglist|r\nAffiche une liste des commandes de débogage." 
PARANOIA_CHATIGNORED          = "%s doit être ignoré pendant trois heures (ou jusqu'à la déconnexion)."
-- player name
PARANOIA_CHATTESTANNOUNCE     = "C'est ce à quoi ressemble votre message personnalisé. (Le message n'est actuellement pas envoyé.)"
PARANOIA_CHATFAKEANNOUNCE     = "[%s] dit: [Paranoia] %s"
-- player name, custom message
-- Appears as "[Jimmy] says: [Paranoia] Hostile player detected! blah blah blah"
PARANOIA_CHATINSTANCE         = "Paranoia a été désactivé parce que vous avez entré un donjon instances."
PARANOIA_CHATUNRECOGNIZED     = "Commande non reconnue. [%s]\nTapez /paranoia ou /para pour la liste des commandes."

-- ==========Alert Popup Message==========
PARANOIA_ALERTNOCLASS     = "Joueur de %s détecté! (%s)" 
-- faction, player name  "Alliance player detected! (Pally)"
PARANOIA_ALERTCLASSKNOWN  = "%s %s détecté! (%s)" 
-- faction, class, player name  "Alliance Paladin detected! (Pally)"
PARANOIA_GUILDALERTNOCLASS       = "%s (guilde) détecté une hostiles! (%s, %i,%i)" 
-- guild member name, hostile player name, coords
PARANOIA_GUILDALERTCLASS         = "%s (guilde) détecté un %s hostiles! (%s, %i,%i)" 
-- guild member name, class, hostile player name, coords
PARANOIA_PARTYALERTNOCLASS       = "%s (parti) détecté une hostiles! (%s, %i,%i)" 
-- party memeber name, hostile player name, coords
PARANOIA_PARTYALERTCLASS         = "%s (parti) détecté un %s hostiles! (%s, %i,%i)" 
-- party memeber name, class, hostile player name, coords
PARANOIA_ALERTMOVEABLE    = "Cliquez et déplacez pour la positionner."
PARANOIA_ALERTTEST        = "Joueur de %s détecté! (Testejoueur)"
-- faction. Replace Testplayer with an equivalent if possible.


-- ==========Classes==========
--For the SHORT version of a class name, use the first four letters.

PARANOIA_DRUID_SHORT              = "Drui"
PARANOIA_HUNTER_SHORT             = "Chas"
PARANOIA_ROGUE_SHORT              = "Vole"
PARANOIA_PRIEST_SHORT             = "Prêt"
PARANOIA_PALADIN_SHORT            = "Pala"
PARANOIA_SHAMAN_SHORT             = "Cham"
PARANOIA_MAGE_SHORT               = "Mage"
PARANOIA_WARRIOR_SHORT            = "Guer"
PARANOIA_WARLOCK_SHORT            = "Démo"
PARANOIA_DEATHKNIGHT_SHORT        = "Chev"

--Use the male versions of classnames for languages that distinguish between genders.
PARANOIA_DRUID                    = "Druide"
PARANOIA_HUNTER                   = "Chasseur"
PARANOIA_ROGUE                    = "Voleur"
PARANOIA_PRIEST                   = "Prêtre"
PARANOIA_PALADIN                  = "Paladin"
PARANOIA_SHAMAN                   = "Chaman"
PARANOIA_MAGE                     = "Mage"
PARANOIA_WARRIOR                  = "Guerrier"
PARANOIA_WARLOCK                  = "Démoniste"
PARANOIA_DEATHKNIGHT              = "Chevalier de la Mort"


-- ==========Announcement Dropdown==========
--Use the same color codes.
PARANOIA_ANNOUNCESAY        = "Announcer dans /dire"
PARANOIA_ANNOUNCEYELL       = "Announcer dans |cFFFF3F3F/crier|r"
PARANOIA_ANNOUNCEPARTY      = "Announcer dans |cFFAAAAFF/groupe |r"
PARANOIA_ANNOUNCERAID       = "Announcer dans |cFFFF7F00/raid|r"
PARANOIA_ANNOUNCEGUILD      = "Announcer dans |cFF3FFF3F/guilde|r"
PARANOIA_ANNOUNCEBG         = "Announcer dans |cFFFF7F00/battleground|r"
PARANOIA_ANNOUNCELOCALDEF   = "Announcer dans |cFFFFD1BF/%i (DéfenseLocale)|r"
-- channel number, appears as:
-- "Announce to /3 (LocalDefense)"
PARANOIA_ANNOUNCEIGNORE     = "Ignorer %s pour cette session"
-- player name
PARANOIA_ANNOUNCECONFIG     = "Ouvrir les options de Paranoia"


-- ====================Paranoia Options====================

PARANOIA_RESETPOSITIONS               = "Réinitialiser les positions"
-- resets the positions of windows
PARANOIA_TESTBUTTON                   = "Teste"
-- tests either the custom message or the alert popup

-- ==========Paranoia General Tab==========
PARANOIA_GENERAL_ENABLE              = "Activer Paranoia"
PARANOIA_GENERAL_ENABLESOUND         = "Activer les alertes sonores"
PARANOIA_GENERAL_DISABLEBG           = "Désactiver dans les champs de bataille"
PARANOIA_GENERAL_DISABLEARENA        = "Désactiver dans les arènes"
PARANOIA_GENERAL_DISABLESANCT        = "Désactiver dans les sanctuaires (ie. Shattrath)"
PARANOIA_GENERAL_DISABLEFFA          = "Désactiver dans les zones libre pour tous"
PARANOIA_GENERAL_HIDELIST            = "Cacher la listes des ennemis (garde l'addon activé)"
PARANOIA_GENERAL_LOCKLIST            = "Verrouiller la position de la fenêtre de Paranoia"

-- sliders have three strings, the title, the highest value, and the lowest value

PARANOIA_GENERALSLI_LISTTIMEOUT       = "Echéance de la liste des ennemis (%i seconds)"
-- number of seconds
PARANOIA_GENERALSLI_LISTTIMEOUTHIGH   = "300 (5 minutes)"
PARANOIA_GENERALSLI_LISTTIMEOUTLOW    = "10 seconds"

PARANOIA_GENERALSLI_WARNTIMEOUT       = "Echéance des alertes (%i seconds)"
-- number of seconds
PARANOIA_GENERALSLI_WARNTIMEOUTHIGH   = "300 (5 minutes)"
PARANOIA_GENERALSLI_WARNTIMEOUTLOW    = "10 seconds"

-- ==========Paranoia Alert Popup Tab==========
PARANOIA_ALERTPOP_ENABLE                  = "Activer les popups d'alerte ennemis"

PARANOIA_ALERTPOPSLI_FADE                 = "Durée du dégradé (%.1f seconds)"
-- number of seconds, appears as "Fade Duration (3.5 seconds)"
PARANOIA_ALERTPOPSLI_FADEHIGH             = "6 (long)"
PARANOIA_ALERTPOPSLI_FADELOW              = "0 (instantané)"

PARANOIA_ALERTPOPSLI_DISP                 = "Durée d'affichage (%.1f seconds)"
-- number of seconds
PARANOIA_ALERTPOPSLI_DISPHIGH             = "6 (long)"
PARANOIA_ALERTPOPSLI_DISPLOW              = "0.5 (vraiment court)"

PARANOIA_ALERTPOPSLI_ALPHA                 = "Texte opacité (%.0f pourcent)"
-- percent
PARANOIA_ALERTPOPSLI_ALPHAHIGH             = "100 (opaque)"
PARANOIA_ALERTPOPSLI_ALPHALOW              = "20 (vraiment clair)"


-- =========Paranoia Appearance Tab==========
PARANOIA_APPEARANCE_FADEOUT               = "Dégradé progressif des unités ennemis inactives"
PARANOIA_APPEARANCE_MINIMAPBUTTON         = "Cacher la minimap bouton"

PARANOIA_APPEARANCESLI_BOPACITY           = "Opacité des bordures (%.0f pourcent)"
-- percentage, appears as "Border Opacity (50%)"
PARANOIA_APPEARANCESLI_BOPACITYHIGH       = "100 (opaque)"
PARANOIA_APPEARANCESLI_BOPACITYLOW        = "0 (invisible)"

PARANOIA_APPEARANCESLI_POPACITY           = "Opacité du panneau (%.0f pourcent)"
-- percentage, appears as "Panel Opacity (50%)"
PARANOIA_APPEARANCESLI_POPACITYHIGH       = "100 (opaque)"
PARANOIA_APPEARANCESLI_POPACITYLOW        = "20 (vraiment clair)"

PARANOIA_APPEARANCESLI_MAXHOSTILE         = "Nombre maximum d'unités hostiles (%i hostiles)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_MAXHOSTILEHIGH     = "15 hostiles"
PARANOIA_APPEARANCESLI_MAXHOSTILELOW      = "4 hostiles"

PARANOIA_APPEARANCESLI_SCALE         = "Echelle de la liste d'ennemi (%.0f pourcent)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_SCALEHIGH     = "180% (grosse)"
PARANOIA_APPEARANCESLI_SCALELOW      = "60% (petite)"


-- =========Paranoia Announce Tab==========
PARANOIA_ANNOUNCE_HEADER                  = "|cFFFFFFFFTapez votre message personnalisé dans la boîte ci-dessous|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_HITENTER                = "Tapez Entrée pour mémoriser votre message personnalisé."

--This is a multiline message explaining to the user how to use formating.
--The %x variables will not actually be changed, they will be displayed to the user.
--For example:
--"%l -- Replaced with the enemy's level."
--Please note that the interface options frame isn't very wide, so these messages must be fairly short,
--while also helpful.
PARANOIA_ANNOUNCE_PATTERNHELP1            = "|cFFFFFFFFUtiliser ces codes pour créer votre message.|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_PATTERNHELP2            = "%f - Affiche la faction opposée."
PARANOIA_ANNOUNCE_PATTERNHELP3            = "%n - Affiche le nom de l'ennemi."
PARANOIA_ANNOUNCE_PATTERNHELP4            = "%l - Affiche le niveau de l'ennemi."
PARANOIA_ANNOUNCE_PATTERNHELP5            = "%c - Affiche la classe de l'ennemi."
PARANOIA_ANNOUNCE_PATTERNHELP6            = "%z - Affiche le dernier endroit où a été vu l'ennemi."
PARANOIA_ANNOUNCE_PATTERNHELP7            = "%x et %y - Affiche les dernières positions de l'ennemi."
PARANOIA_ANNOUNCE_PATTERNHELP8            = " "
-- PATTERNHELP8 is an extra line in case one line is too long and needs to be split into two lines.
-- PATTERNHELP1 is the header, and therefore CANNOT be split into two lines.
PARANOIA_ANNOUNCE_TESTNAME                = "Jimmy"
-- This is the name used for the test message (they'll appear as a Mage, i.e. Jimmy the Mage). 
-- It can be changed to a common name in a different language.

-- =========Paranoia Communication Tab==========
PARANOIA_COMM_ENABLECOMM            = "Activer communication"
PARANOIA_COMM_GROUPWARN             = "Avertir si un membre du parti détecte une hostiles"
PARANOIA_COMM_GUILDWARN             = "Avertir si un membre du guilde à proximité détecte un membre hostiles"

end