﻿--[[    
    Paranoia Enemy Player Alert
    Copyright (C) 2008 Victor Barrancos
  
    This file is part of Paranoia Enemy Player Alert.

    Paranoia Enemy Player Alert is free software: you can redistribute it 
    and/or modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation, either version 3 of the 
    License, or (at your option) any later version.

    Paranoia Enemy Player Alert is distributed in the hope that it will 
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Paranoia Enemy Player Alert.  If not, see 
    <http://www.gnu.org/licenses/>.
]]--

-- Paranoia Enemy Player Alert 1.11
-- esES/esMX localization

-- Traduccion al CASTELLANO de Paranoia por Miros.

-- Spanish translation by Miros.

if GetLocale() == "esES" or GetLocale() == "esMX" then
-- If I missed any locale codes please tell me.

PARANOIA_SHORTNAME  = "Paranoia"
PARANOIA_LONGNAME   = "Paranoia Enemy Player Alert"


-- ==========Slash commands==========
-- These are the slash commands that will be registered.
PARANOIA_SLASH1     = "/paranoia"
PARANOIA_SLASH2     = "/para"     --works the same as /paranoia, just shorter
PARANOIA_SLACONFIG  = "config"    --/paranoia config
PARANOIA_SLAENABLE  = "activar"    --/paranoia enable
PARANOIA_SLADISABLE = "desactivar"   --/paranoia disable
PARANOIA_SLADEBUG   = "debug"     --/paranoia debug
--"debug" should not be translated, because if a user has a problem
--and asks me about it, I'm going to tell them to type /paranoia debug.


-- ==========Prompt box text==========
-- These are the messageboxes that appear when reseting or installing Paranoia.
PARANOIA_RELOADPROMPTTEXT   = "Paranoia: Esta accion volvera a cargar la interfaz. Deseas continuar?"
PARANOIA_DEFAULTPROMPTTEXT  = "Paranoia: Esta accion borrara tu configuracion y recargara la interfaz. Deseas continuar?"
PARANOIA_FIRSTRUNPROMPTTEXT = "Gracias por descargar Paranoia! El addon esta actualmente oculto porque estas en %s. Deseas abrir la ventana de opciones?" --zone name
PARANOIA_YESPROMPT          = "Sí"
PARANOIA_NOPROMPT           = "No"
PARANOIA_OKPROMPT           = "Ok"    --should be some sort of affirmative


-- ==========Faction names==========
-- Just need the names of the two factions here, I don't know if they're different in other languages.
PARANOIA_ALLIANCE   = "Alianza"
PARANOIA_HORDE      = "Horda"


-- ==========Miscellaneous text==========
-- Miscellaneous text used in various places throughout the addon.
PARANOIA_UNKNOWN      = "Desconocido"
PARANOIA_INCOMBAT     = "En Combate"
PARANOIA_SLASHTARGET  = "/target"
PARANOIA_LOCALDEFCHAN = "DefensaLocal"
--This is the name of the LocalDefense channel, where the "Orgrimmar is under attack!" messages appear.
--The LocalDefense channel is always (in enUS) "LocalDefense - Current Zone". We need only the first part, "LocalDefense".
--It must be EXACTLY how it appears in-game, with exact capitalization too, otherwise Paranoia won't detect the LocalDefense channel.
--For example, in French, we'd use: "DéfenseLocale"
PARANOIA_NODETECTL1   = "Ningun jugador de" -- faction name
PARANOIA_NODETECTL2   = "la %s detectado."
--PARANOIA_NODETECTL1 and PARANOIA_NODETECTL2 are two separate lines.
--This shows up when Paranoia hasn't detected anyone nearby. Shows up as:
--No Alliance
--players detected.
PARANOIA_DEFAULTMSG   = "Jugador de la %f detectado: %n (Nv %l %c) - Visto por ultima vez en %z (%x,%y)"
--This appears as "Alliance Player Detected: Playername (Lvl 70 Warrior) - Last seen near Thrallmar (12,12)"
--                 %f(action)                %n              %l %c                        %z         %x %y 
--The user can change this message, but what is listed above is the DEFAULT message, so it should be helpful
--and include all variables.
PARANOIA_MMTOOLTIP   = "Click izquierdo: activar/desactivar\nClick derecho: abre la ventana de opciones"


-- ==========Interface Options Tab Names==========
PARANOIA_TABGENERAL       = "General"
PARANOIA_TABAPPEARANCE    = "Apariencia"
PARANOIA_TABALERTPOPUP    = "Ventana de Alerta"
PARANOIA_TABANNOUNCE      = "Mensaje Personalizado"
PARANOIA_TABCOMM          = "Comunicación"


-- ==========Chat messages==========
PARANOIA_CHATFIRSTRUNHIDDEN   = "Paranoia está deshabilitado porque te encuentras en %s, que es un santuario, campo de batalla, arena, o un espacio abierto a todos. Escribe /paranoia config para acceder a la ventana de opciones." --zone name
PARANOIA_CHATFIRSTRUN         = "Arrastra la ventana de Paranoia para moverla donde quieras. Usa el botón derecho o escribe /paranoia config para acceder a la ventana de opciones."
--remember, the chat command might not be /paranoia config.
PARANOIA_CHATPARALOADED       = "Paranoia Enemy Player Alert v%s de %s cargado.\nUsa /para o /paranoia para la lista de comandos."
--%s = Lifetapt in purple letters. Appears as Lifetapt's Paranoia Enemy Player Alert
PARANOIA_CHATLOCALIZEDBY      = "Traduccion al CASTELLANO de Paranoia por Miros."
-- This message appears right after CHATPARALOADED when the user is using a non-english localization file.
-- Place your name and the language you are translating to here (if you want, or you can leave it blank and Paranoia will skip the message).
PARANOIA_CHATTARGETDISABLED   = "No puedes seleccionar cuando esas en combate."
PARANOIA_CHATENABLED          = "Paranoia se ha activado."
PARANOIA_CHATDISABLED         = "Paranoia se ha desactivado."
PARANOIA_CHATDEBUGENABLED     = "Activado el modo Debug." 
PARANOIA_CHATDEBUGDISABLED    = "Desactivado el modo Debug."
PARANOIA_CHATSLASHLIST        = "Lista de Comandos " 
-- Slash commands need to match the ones listed above in the slash commands section.
PARANOIA_CHATSLASHLISTCONFIG  = "/paranoia config|r\nAbre la ventana de Opciones de Paranoia." 
PARANOIA_CHATSLASHLISTENABLE  = "/paranoia activar|r\nActiva Paranoia." 
PARANOIA_CHATSLASHLISTDISABLE = "/paranoia desactivar|r\nDesactiva Paranoia." 
PARANOIA_CHATSLASHLISTDEBUG   = "/paranoia debug|r\nPone Paranoia en modo Debug (puede provocar la aparicion de multiples mensajes de chat)." 
PARANOIA_CHATSLASHLISTDEBUGL  = "/paranoia debuglist|r\nAbre una lista de comandos." 
PARANOIA_CHATIGNORED          = "%s sera ignorado durante tres horas (o hasta que te desconectes)."
-- player name
PARANOIA_CHATTESTANNOUNCE     = "Asi es como se vera tu mensaje personalizado. (El mensaje no se ha especificado aun)."
PARANOIA_CHATFAKEANNOUNCE     = "[%s] dice: [Paranoia] %s"
-- player name, custom message
-- Appears as "[Jimmy] says: [Paranoia] Hostile player detected! blah blah blah"
PARANOIA_CHATINSTANCE         = "Paranoia está desactivado debido a que está en una instancia."
PARANOIA_CHATUNRECOGNIZED     = "Comando no reconocido. [%s]\nUsa /para o /paranoia para la lista de comandos."

-- ==========Alert Popup Message==========
PARANOIA_ALERTNOCLASS     = "¡jugador de la %s detectado! (%s)" 
-- faction, player name  "Alliance player detected! (Pally)"
PARANOIA_ALERTCLASSKNOWN  = "%s detectado! Clase: %s (%s)" 
-- faction, class, player name  "Alliance Paladin detected! (Pally)"
PARANOIA_GUILDALERTNOCLASS       = "%s (hermandad) detectó un enemigo! (%s, %i,%i)" 
-- guild member name, hostile player name, coords
PARANOIA_GUILDALERTCLASS         = "%s (hermandad) detectó un %s enemigo! (%s, %i,%i)" 
-- guild member name, class, hostile player name, coords
PARANOIA_PARTYALERTNOCLASS       = "%s (grupo) detectó un enemigo! (%s, %i,%i)" 
-- party memeber name, hostile player name, coords
PARANOIA_PARTYALERTCLASS         = "%s (grupo) detectó un %s enemigo! (%s, %i,%i)" 
-- party memeber name, class, hostile player name, coords
PARANOIA_ALERTMOVEABLE    = "Arrastra esta ventana para moverla donde quieras."
PARANOIA_ALERTTEST        = "¡jugador de la %s detectado! (JugadorDePrueba)"
-- faction. Replace Testplayer with an equivalent if possible.


-- ==========Classes==========
--For the SHORT version of a class name, use the first four letters.

PARANOIA_DRUID_SHORT              = "Drui"
PARANOIA_HUNTER_SHORT             = "Caza"
PARANOIA_ROGUE_SHORT              = "Pica"
PARANOIA_PRIEST_SHORT             = "Sace"
PARANOIA_PALADIN_SHORT            = "Pala"
PARANOIA_SHAMAN_SHORT             = "Cham"
PARANOIA_MAGE_SHORT               = "Mago"
PARANOIA_WARRIOR_SHORT            = "Guer"
PARANOIA_WARLOCK_SHORT            = "Bruj"
PARANOIA_DEATHKNIGHT_SHORT        = "Caba"

--Use the male versions of classnames for languages that distinguish between genders.
PARANOIA_DRUID                    = "Druida"
PARANOIA_HUNTER                   = "Cazador"
PARANOIA_ROGUE                    = "Picaro"
PARANOIA_PRIEST                   = "Sacerdote"
PARANOIA_PALADIN                  = "Paladin"
PARANOIA_SHAMAN                   = "Chaman"
PARANOIA_MAGE                     = "Mago"
PARANOIA_WARRIOR                  = "Guerrero"
PARANOIA_WARLOCK                  = "Brujo"
PARANOIA_DEATHKNIGHT              = "Caballero de la Muerte"


-- ==========Announcement Dropdown==========
--Use the same color codes.
PARANOIA_ANNOUNCESAY        = "Anunciar en /decir"
PARANOIA_ANNOUNCEYELL       = "Anunciar en |cFFFF3F3F/gritar|r"
PARANOIA_ANNOUNCEPARTY      = "Anunciar en |cFFAAAAFF/grupo|r"
PARANOIA_ANNOUNCERAID       = "Anunciar en |cFFFF7F00/raid|r"
PARANOIA_ANNOUNCEGUILD      = "Anunciar en |cFF3FFF3F/hermandad|r"
PARANOIA_ANNOUNCEBG         = "Anunciar en |cFFFF7F00/battleground|r"
PARANOIA_ANNOUNCELOCALDEF   = "Anunciar en |cFFFFD1BF/%i (DefensaLocal)|r"
-- channel number, appears as:
-- "Announce to /3 (LocalDefense)"
PARANOIA_ANNOUNCEIGNORE     = "Ignorar a %s durante esta sesion"
-- player name
PARANOIA_ANNOUNCECONFIG     = "Abre las Opciones de Paranoia"


-- ====================Paranoia Options====================

PARANOIA_RESETPOSITIONS               = "Restaurar Posiciones"
-- resets the positions of windows
PARANOIA_TESTBUTTON                   = "Probar"
-- tests either the custom message or the alert popup

-- ==========Paranoia General Tab==========
PARANOIA_GENERAL_ENABLE              = "Activar Paranoia"
PARANOIA_GENERAL_ENABLESOUND         = "Activar Sonido de Alerta"
PARANOIA_GENERAL_DISABLEBG           = "Desactivar en Campos de Batalla"
PARANOIA_GENERAL_DISABLEARENA        = "Desactivar en arenas"
PARANOIA_GENERAL_DISABLESANCT        = "Desactivar en santuarios (pe. Shattrath)"
PARANOIA_GENERAL_DISABLEFFA          = "Desactivar en zonas libres"
PARANOIA_GENERAL_HIDELIST            = "Ocultar Lista de Enemigos (el addon permanecera activado)"
PARANOIA_GENERAL_LOCKLIST            = "Bloquear la ventana de Paranoia"

-- sliders have three strings, the title, the highest value, and the lowest value

PARANOIA_GENERALSLI_LISTTIMEOUT       = "Contador de la Lista de Enemigos (%i segundos)"
-- number of seconds
PARANOIA_GENERALSLI_LISTTIMEOUTHIGH   = "300 (5 minutos)"
PARANOIA_GENERALSLI_LISTTIMEOUTLOW    = "10 segundos"

PARANOIA_GENERALSLI_WARNTIMEOUT       = "Contador de Alarma (%i segundos)"
-- number of seconds
PARANOIA_GENERALSLI_WARNTIMEOUTHIGH   = "300 (5 minutos)"
PARANOIA_GENERALSLI_WARNTIMEOUTLOW    = "10 segundos"

-- ==========Paranoia Alert Popup Tab==========
PARANOIA_ALERTPOP_ENABLE                  = "Activar Ventana de Alerta de Jugador Hostil"

PARANOIA_ALERTPOPSLI_FADE                 = "Duracion de Desvanecimiento (%.1f segundos)"
-- number of seconds, appears as "Fade Duration (3.5 seconds)"
PARANOIA_ALERTPOPSLI_FADEHIGH             = "6 (largo)"
PARANOIA_ALERTPOPSLI_FADELOW              = "0 (instantáneo)"

PARANOIA_ALERTPOPSLI_DISP                 = "Tiempo de Visibilidad (%.1f segundos)"
-- number of seconds
PARANOIA_ALERTPOPSLI_DISPHIGH             = "6 (largo)"
PARANOIA_ALERTPOPSLI_DISPLOW              = "0.5 (muy corto)"

PARANOIA_ALERTPOPSLI_ALPHA                 = "Opacidad del Texto (%.0f percent)"
-- percent
PARANOIA_ALERTPOPSLI_ALPHAHIGH             = "100 (opaco)"
PARANOIA_ALERTPOPSLI_ALPHALOW              = "20 (transparente)"

-- =========Paranoia Appearance Tab==========
PARANOIA_APPEARANCE_FADEOUT               = "Desvanecer Gradualmente Unidades Enemigas Inactivas"
PARANOIA_APPEARANCE_MINIMAPBUTTON         = "Ocultar el botón de minimapa"

PARANOIA_APPEARANCESLI_BOPACITY           = "Opacidad del Borde (%.0f percent)"
-- percentage, appears as "Border Opacity (50%)"
PARANOIA_APPEARANCESLI_BOPACITYHIGH       = "100 (opaco)"
PARANOIA_APPEARANCESLI_BOPACITYLOW        = "0 (invisible)"

PARANOIA_APPEARANCESLI_POPACITY           = "Opacidad del Panel (%.0f percent)"
-- percentage, appears as "Panel Opacity (50%)"
PARANOIA_APPEARANCESLI_POPACITYHIGH       = "100 (opaco)"
PARANOIA_APPEARANCESLI_POPACITYLOW        = "20 (transparente)"

PARANOIA_APPEARANCESLI_MAXHOSTILE         = "Numero Maximo de Unidades Hostiles (%i hostiles)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_MAXHOSTILEHIGH     = "15 hostiles"
PARANOIA_APPEARANCESLI_MAXHOSTILELOW      = "4 hostiles"

PARANOIA_APPEARANCESLI_SCALE         = "Escala de la Lista de Enemigos (%.0f percent)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_SCALEHIGH     = "180% (enorme)"
PARANOIA_APPEARANCESLI_SCALELOW      = "60% (muy pequeña)"


-- =========Paranoia Announce Tab==========
PARANOIA_ANNOUNCE_HEADER                  = "|cFFFFFFFFEscribe tu mensaje personalizado aqui.|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_HITENTER                = "Pulsa Enter para guardar tu mensaje personalizado."

--This is a multiline message explaining to the user how to use formating.
--The %x variables will not actually be changed, they will be displayed to the user.
--For example:
--"%l -- Replaced with the enemy's level."
--Please note that the interface options frame isn't very wide, so these messages must be fairly short,
--while also helpful.
PARANOIA_ANNOUNCE_PATTERNHELP1            = "|cFFFFFFFFUsa los siguientes comandos para crear tu mensaje.|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_PATTERNHELP2            = "%f - Faccion opuesta."
PARANOIA_ANNOUNCE_PATTERNHELP3            = "%n - Nombre del enemigo."
PARANOIA_ANNOUNCE_PATTERNHELP4            = "%l - Nivel del enemigo."
PARANOIA_ANNOUNCE_PATTERNHELP5            = "%c - Clase del enemigo."
PARANOIA_ANNOUNCE_PATTERNHELP6            = "%z - Zona donde fue visto por ultima vez."
PARANOIA_ANNOUNCE_PATTERNHELP7            = "%x, %y - Ultimas coordenadas del enemigo."
PARANOIA_ANNOUNCE_PATTERNHELP8            = " "
-- PATTERNHELP8 is an extra line in case one line is too long and needs to be split into two lines.
-- PATTERNHELP1 is the header, and therefore CANNOT be split into two lines.
PARANOIA_ANNOUNCE_TESTNAME                = "Chop-Suei"
-- This is the name used for the test message (they'll appear as a Mage, i.e. Jimmy the Mage). 
-- It can be changed to a common name in a different language.

-- =========Paranoia Communication Tab==========
PARANOIA_COMM_ENABLECOMM            = "Activar Comunicación"
PARANOIA_COMM_GROUPWARN             = "Avisarme si un miembro del grupo detecta un enemigo"
PARANOIA_COMM_GUILDWARN             = "Avisarme si un miembro del hermandad cerca detecta un enemigo"

end