﻿--[[    
    Paranoia Enemy Player Alert
    Copyright (C) 2008 Victor Barrancos
  
    This file is part of Paranoia Enemy Player Alert.

    Paranoia Enemy Player Alert is free software: you can redistribute it 
    and/or modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation, either version 3 of the 
    License, or (at your option) any later version.

    Paranoia Enemy Player Alert is distributed in the hope that it will 
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Paranoia Enemy Player Alert.  If not, see 
    <http://www.gnu.org/licenses/>.
]]--

-- Paranoia Enemy Player Alert 1.11
-- enUS/enGB localization

-- Paranoia currently needs a German (deDE) and Traditional Chinese (zhTW) translation.
-- Please help out by translating this file into one of the above languages and sending
-- the translated file to lifetapt@gmail.com.

--Please note that the word Paranoia should not be translated anywhere it appears.



PARANOIA_SHORTNAME  = "Paranoia"
PARANOIA_LONGNAME   = "Paranoia Enemy Player Alert"


-- ==========Slash commands==========
-- These are the slash commands that will be registered.
PARANOIA_SLASH1     = "/paranoia"
PARANOIA_SLASH2     = "/para"     --works the same as /paranoia, just shorter
PARANOIA_SLACONFIG  = "config"    --/paranoia config
PARANOIA_SLAENABLE  = "enable"    --/paranoia enable
PARANOIA_SLADISABLE = "disable"   --/paranoia disable
PARANOIA_SLADEBUG   = "debug"     --/paranoia debug
--"debug" should not be translated, because if a user has a problem
--and asks me about it, I'm going to tell them to type /paranoia debug.


-- ==========Prompt box text==========
-- These are the messageboxes that appear when reseting or installing Paranoia.
PARANOIA_RELOADPROMPTTEXT   = "Paranoia: This action will reload the UI. Do you wish to continue?"
PARANOIA_DEFAULTPROMPTTEXT  = "Paranoia: This action will clear all settings and reload the UI. Do you wish to continue?"
PARANOIA_FIRSTRUNPROMPTTEXT = "Thanks for downloading Paranoia! The addon is currently hidden because you are in %s. Would you like to open the options frame?" --zone name
PARANOIA_YESPROMPT          = "Yes"
PARANOIA_NOPROMPT           = "No"
PARANOIA_OKPROMPT           = "Okay"    --should be some sort of affirmative


-- ==========Faction names==========
-- Just need the names of the two factions here, I don't know if they're different in other languages.
PARANOIA_ALLIANCE   = "Alliance"
PARANOIA_HORDE      = "Horde"


-- ==========Miscellaneous text==========
-- Miscellaneous text used in various places throughout the addon.
PARANOIA_UNKNOWN      = "Unknown"
PARANOIA_INCOMBAT     = "In Combat"
PARANOIA_SLASHTARGET  = "/target"
PARANOIA_LOCALDEFCHAN = "LocalDefense"
--This is the name of the LocalDefense channel, where the "Orgrimmar is under attack!" messages appear.
--It must be EXACTLY how it appears in-game, with exact capitalization too, otherwise Paranoia won't detect the LocalDefense channel.
--For example, in French, we'd use: "DéfenseLocale". (Note the absence of a space, DéfenseLocale not Défense Locale.)
PARANOIA_NODETECTL1   = "No %s" -- faction name
PARANOIA_NODETECTL2   = "players detected."
--PARANOIA_NODETECTL1 and PARANOIA_NODETECTL2 are two separate lines.
--This shows up when Paranoia hasn't detected anyone nearby. Shows up as:
--No Alliance
--players detected.
--Please note that the faction name doesn't have to be in the first line. You can also do
--There are no
--Alliance nearby.
PARANOIA_DEFAULTMSG   = "Enemy Player Alert: %n, level %l %c - Last spotted near %z (%x,%y)"
--This appears as "Enemy Player Alert: Playername, level 70 Warrior - Last spotted near Thrallmar (12,12)"
--                 %f(action)                %n              %l %c                        %z         %x %y 
--The user can change this message, but what is listed above is the DEFAULT message, so it should be helpful
--and include all variables.
PARANOIA_MMTOOLTIP   = "Left-click to toggle Paranoia.\nRight-click to open Paranoia's options frame.\nClick and drag to move this button."


-- ==========Interface Options Tab Names==========
PARANOIA_TABGENERAL       = "General"
PARANOIA_TABAPPEARANCE    = "Appearance"
PARANOIA_TABALERTPOPUP    = "Alert Popup"
PARANOIA_TABANNOUNCE      = "Announce"
PARANOIA_TABCOMM          = "Communication"


-- ==========Chat messages==========
PARANOIA_CHATFIRSTRUNHIDDEN   = "Paranoia is disabled because you are in %s, which is a sanctuary, battleground, arena, or free-for-all zone. Please type /paranoia config to access options frame." --zone name
PARANOIA_CHATFIRSTRUN         = "Click and drag the Paranoia frame to move it around. Please right click the frame or type /paranoia config to access options frame."
--remember, the chat command might not be /paranoia config.
PARANOIA_CHATPARALOADED       = "Paranoia Enemy Player Alert v%s by %s loaded.\nUse /paranoia or /para for command list."
--first %s = version number, second %s = Lifetapt in purple letters. Appears as Paranoia Enemy Player Alert v1.11
PARANOIA_CHATLOCALIZEDBY      = "Paranoia's English translation by..."
-- This message appears right after CHATPARALOADED when the user is using a non-english localization file.
-- Place your name and the language you are translating to here (if you want, or you can leave it blank and Paranoia will skip the message).
PARANOIA_CHATTARGETDISABLED   = "Targeting is disabled while you are in combat."
PARANOIA_CHATENABLED          = "Paranoia has been enabled."
PARANOIA_CHATDISABLED         = "Paranoia has been disabled."
PARANOIA_CHATDEBUGENABLED     = "Debug mode enabled." 
PARANOIA_CHATDEBUGDISABLED    = "Debug mode disabled."
PARANOIA_CHATSLASHLIST        = "Slash Command List" 
-- Slash commands need to match the ones listed above in the slash commands section.
PARANOIA_CHATSLASHLISTCONFIG  = "/paranoia config|r\nOpens the Paranoia options frame." 
PARANOIA_CHATSLASHLISTENABLE  = "/paranoia enable|r\nEnables the Paranoia addon." 
PARANOIA_CHATSLASHLISTDISABLE = "/paranoia disable|r\nDisables the Paranoia addon." 
PARANOIA_CHATSLASHLISTDEBUG   = "/paranoia debug|r\nToggles Paranoia debug mode (may cause chat frame spam)." 
PARANOIA_CHATSLASHLISTDEBUGL  = "/paranoia debuglist|r\nDisplays a list of debug commands." 
PARANOIA_CHATIGNORED          = "%s will be ignored for three hours (or until you logout)."
-- player name
PARANOIA_CHATTESTANNOUNCE     = "This is what your custom message will look like. (The message wasn't actually sent.)"
PARANOIA_CHATFAKEANNOUNCE     = "[%s] says: [Paranoia] %s"
-- player name, custom message
-- Appears as "[Jimmy] says: [Paranoia] Hostile player detected! blah blah blah"
PARANOIA_CHATINSTANCE         = "Paranoia has been disabled because you have entered an instance."
PARANOIA_CHATUNRECOGNIZED     = "Unrecognized command. [%s]\nUse /paranoia or /para for command list."

-- ==========Alert Popup Message==========
PARANOIA_ALERTNOCLASS     = "%s player detected! (%s)" 
-- faction, player name  "Alliance player detected! (Pally)"
PARANOIA_ALERTCLASSKNOWN  = "%s %s detected! (%s)" 
-- faction, class, player name  "Alliance Paladin detected! (Pally)"
PARANOIA_GUILDALERTNOCLASS       = "%s (guild) detected a hostile! (%s, %i,%i)" 
-- guild member name, hostile player name, coords
PARANOIA_GUILDALERTCLASS         = "%s (guild) detected a hostile %s! (%s, %i,%i)" 
-- guild member name, class, hostile player name, coords
PARANOIA_PARTYALERTNOCLASS       = "%s (party) detected a hostile! (%s, %i,%i)" 
-- party memeber name, hostile player name, coords
PARANOIA_PARTYALERTCLASS         = "%s (party) detected a hostile %s! (%s, %i,%i)" 
-- party memeber name, class, hostile player name, coords
PARANOIA_ALERTMOVEABLE    = "Click and drag this frame to move it around."
PARANOIA_ALERTTEST        = "%s player detected! (Testplayer)"
-- faction. Replace Testplayer with an equivalent if possible.


-- ==========Classes==========
--Class names.

--The short names should be the first 4 characters of a class name. If a class name is shorter than 4 characters
PARANOIA_DRUID_SHORT              = "Drui"
PARANOIA_HUNTER_SHORT             = "Hunt"
PARANOIA_ROGUE_SHORT              = "Rogu"
PARANOIA_PRIEST_SHORT             = "Prie"
PARANOIA_PALADIN_SHORT            = "Pala"
PARANOIA_SHAMAN_SHORT             = "Sham"
PARANOIA_MAGE_SHORT               = "Mage"
PARANOIA_WARRIOR_SHORT            = "Warr"
PARANOIA_WARLOCK_SHORT            = "Warl"
PARANOIA_DEATHKNIGHT_SHORT        = "Deat"

--Use the male versions of classnames for languages that distinguish between genders.
PARANOIA_DRUID                    = "Druid"
PARANOIA_HUNTER                   = "Hunter"
PARANOIA_ROGUE                    = "Rogue"
PARANOIA_PRIEST                   = "Priest"
PARANOIA_PALADIN                  = "Paladin"
PARANOIA_SHAMAN                   = "Shaman"
PARANOIA_MAGE                     = "Mage"
PARANOIA_WARRIOR                  = "Warrior"
PARANOIA_WARLOCK                  = "Warlock"
PARANOIA_DEATHKNIGHT              = "Death Knight"


-- ==========Announcement Dropdown==========
--Use the same color codes.
PARANOIA_ANNOUNCESAY        = "Announce to /say"
PARANOIA_ANNOUNCEYELL       = "Announce to |cFFFF3F3F/yell|r"
PARANOIA_ANNOUNCEPARTY      = "Announce to |cFFAAAAFF/party|r"
PARANOIA_ANNOUNCERAID       = "Announce to |cFFFF7F00/raid|r"
PARANOIA_ANNOUNCEGUILD      = "Announce to |cFF3FFF3F/guild|r"
PARANOIA_ANNOUNCEBG         = "Announce to |cFFFF7F00/battleground|r"
PARANOIA_ANNOUNCELOCALDEF   = "Announce to |cFFFFD1BF/%i (LocalDefense)|r"
-- channel number, appears as:
-- "Announce to /3 (LocalDefense)"
PARANOIA_ANNOUNCEIGNORE     = "Ignore %s for this session"
-- player name
PARANOIA_ANNOUNCECONFIG     = "Open Paranoia Options"


-- ====================Paranoia Options====================

PARANOIA_RESETPOSITIONS               = "Reset Positions"
-- resets the positions of windows
PARANOIA_TESTBUTTON                   = "Test"
-- tests either the custom message or the alert popup

-- ==========Paranoia General Tab==========
PARANOIA_GENERAL_ENABLE              = "Enable Paranoia"
PARANOIA_GENERAL_ENABLESOUND         = "Enable Warning Sound"
PARANOIA_GENERAL_DISABLEBG           = "Disable in battlegrounds"
PARANOIA_GENERAL_DISABLEARENA        = "Disable in arenas"
PARANOIA_GENERAL_DISABLESANCT        = "Disable in sanctuaries (ie. Shattrath City)"
PARANOIA_GENERAL_DISABLEFFA          = "Disable in free-for-all areas"
PARANOIA_GENERAL_HIDELIST            = "Hide Enemy List (leave addon enabled)"
PARANOIA_GENERAL_LOCKLIST            = "Lock Paranoia Frame"

-- sliders have three strings, the title, the highest value, and the lowest value

PARANOIA_GENERALSLI_LISTTIMEOUT       = "Enemy List Timeout (%i seconds)"
-- number of seconds
PARANOIA_GENERALSLI_LISTTIMEOUTHIGH   = "300 (5 minutes)"
PARANOIA_GENERALSLI_LISTTIMEOUTLOW    = "10 seconds"

PARANOIA_GENERALSLI_WARNTIMEOUT       = "Warning Timeout (%i seconds)"
-- number of seconds
PARANOIA_GENERALSLI_WARNTIMEOUTHIGH   = "300 (5 minutes)"
PARANOIA_GENERALSLI_WARNTIMEOUTLOW    = "10 seconds"

-- ==========Paranoia Alert Popup Tab==========
PARANOIA_ALERTPOP_ENABLE                  = "Enable Hostile Player Alert Popup"

PARANOIA_ALERTPOPSLI_FADE                 = "Fade Duration (%.1f seconds)"
-- number of seconds, appears as "Fade Duration (3.5 seconds)"
PARANOIA_ALERTPOPSLI_FADEHIGH             = "6 (long)"
PARANOIA_ALERTPOPSLI_FADELOW              = "0 (instant)"

PARANOIA_ALERTPOPSLI_DISP                 = "Display Duration (%.1f seconds)"
-- number of seconds
PARANOIA_ALERTPOPSLI_DISPHIGH             = "6 (long)"
PARANOIA_ALERTPOPSLI_DISPLOW              = "0.5 (very short)"

PARANOIA_ALERTPOPSLI_ALPHA                 = "Text Opacity (%.0f percent)"
-- percent
PARANOIA_ALERTPOPSLI_ALPHAHIGH             = "100 (opaque)"
PARANOIA_ALERTPOPSLI_ALPHALOW              = "20 (very light)"

-- =========Paranoia Appearance Tab==========
PARANOIA_APPEARANCE_FADEOUT               = "Gradually Fadeout Inactive Enemy Units"
PARANOIA_APPEARANCE_MINIMAPBUTTON         = "Hide the minimap button"

PARANOIA_APPEARANCESLI_BOPACITY           = "Border Opacity (%.0f percent)"
-- percentage, appears as "Border Opacity (50%)"
PARANOIA_APPEARANCESLI_BOPACITYHIGH       = "100 (opaque)"
PARANOIA_APPEARANCESLI_BOPACITYLOW        = "0 (invisible)"

PARANOIA_APPEARANCESLI_POPACITY           = "Panel Opacity (%.0f percent)"
-- percentage, appears as "Panel Opacity (50%)"
PARANOIA_APPEARANCESLI_POPACITYHIGH       = "100 (opaque)"
PARANOIA_APPEARANCESLI_POPACITYLOW        = "20 (very light)"

PARANOIA_APPEARANCESLI_MAXHOSTILE         = "Max Number of Hostiles (%i hostiles)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_MAXHOSTILEHIGH     = "15 hostiles"
PARANOIA_APPEARANCESLI_MAXHOSTILELOW      = "4 hostiles"

PARANOIA_APPEARANCESLI_SCALE         = "Enemy List Scale (%.0f percent)"
-- maximum number of hostiles to show
PARANOIA_APPEARANCESLI_SCALEHIGH     = "180% (huge)"
PARANOIA_APPEARANCESLI_SCALELOW      = "60% (tiny)"


-- =========Paranoia Announce Tab==========
PARANOIA_ANNOUNCE_HEADER                  = "|cFFFFFFFFType your custom message in the box below.|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_HITENTER                = "Hit Enter to save your custom message."

--This is a multiline message explaining to the user how to use formating.
--The %x variables will not actually be changed, they will be displayed to the user.
--For example:
--"%l -- Replaced with the enemy's level."
--Please note that the interface options frame isn't very wide, so these messages must be fairly short,
--while also helpful.
PARANOIA_ANNOUNCE_PATTERNHELP1            = "|cFFFFFFFFUse the following patterns to create your message.|r"
--This is the header, it appears in White.
PARANOIA_ANNOUNCE_PATTERNHELP2            = "%f - Replaced with the opposite faction."
PARANOIA_ANNOUNCE_PATTERNHELP3            = "%n - Replaced with the hostile's name."
PARANOIA_ANNOUNCE_PATTERNHELP4            = "%l - Replaced with hostile's level."
PARANOIA_ANNOUNCE_PATTERNHELP5            = "%c - Replaced with the hostile's class."
PARANOIA_ANNOUNCE_PATTERNHELP6            = "%z - Replaced with the hostile's last seen subzone."
PARANOIA_ANNOUNCE_PATTERNHELP7            = "%x and %y - Replaced with the hostile's last seen coords."
PARANOIA_ANNOUNCE_PATTERNHELP8            = " "
-- PATTERNHELP8 is an extra line in case one line is too long and needs to be split into two lines.
-- PATTERNHELP1 is the header, and therefore CANNOT be split into two lines.
PARANOIA_ANNOUNCE_TESTNAME                = "Jimmy"
-- This is the name used for the test message (they'll appear as a Mage, i.e. Jimmy the Mage). 
-- It can be changed to a common name in a different language.

-- =========Paranoia Communication Tab==========
PARANOIA_COMM_ENABLECOMM            = "Enable communication"
PARANOIA_COMM_GROUPWARN             = "Warn me if a party member detects a hostile"
PARANOIA_COMM_GUILDWARN             = "Warn me if a nearby guild member detects a hostile"