--===================================================================================================================--
-- Name:        Paranoia Revived
-- Version:     1.04.20400
-- Description: Paranoia is a WoW addon that attempts to detect enemy players/pets near the player. The addon detects
--              enemies by registering to COMBAT_LOG_EVENT_UNFILTERED and scanning for any events that are triggered
--              by enemy players, including hits, misses, dodges, spell casts, tradeskills, buffs, DoTs, etc.
--              The intent of this addon is to alert the player to nearby enemy players, not to hunt down enemies
--              or to use in a PvP Raid (in the latter situation it may even cause unwanted noise.
--              Paranoia was originally written by rmet0815 (http://www.xs4all.nl/~rmetzger/paranoia). This version
--              is a fan update that includes fixes made by Lifetapt to make the addon compatabile with the new patch 
--              2.4 combat log system.
--              All of the annoying debug messages mixed in with the coding were added by me (Lifetapt), since I'm
--              still a beginner to LUA and it's hard for me to work without them, sorry. Shouldn't be hard to
--              find/replace them all out.
-- Author:      Original: rmet0815      2.4 Update: Lifetapt @ Alterac Mountains
--===================================================================================================================--

local MAX_LINES = 5;

      Paranoia_Config = { enabled = true,
                          disableInBattlefield = true,
                          disableInSanctuaries = true,
                          debugMessages = false,
                          verboseDebug = false,
                          enableSound = true
                        };

local gLastWarnHostilePlayer = 0;

local gHostileList = {};
local gMaxHostiles = 50;
local gCurHostiles = 0;

local gNotHostileList = {};
local gMaxNotHostiles = 100;
local gCurNotHostiles = 0;

local gLastLookup = 0;

local unitflag_hostilepc =  0x00000548;
local unitflag_neutralpc =  0x00000528;

local mainStartTime = 0;
local configStartTime = 0;

--===================================================================================================================--
--  Events
--===================================================================================================================--
function Paranoia_OnLoad()

  this:RegisterForDrag("LeftButton");
  
  SLASH_PARANOIACONF1 = "/paranoia";
  SLASH_PARANOIACONF2 = "/pconf";
  SlashCmdList["PARANOIACONF"] = Paranoia_SlashHandler;

  this:RegisterEvent( "VARIABLES_LOADED" );

  this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

  this:RegisterEvent( "PARTY_MEMBERS_CHANGED" );
  
  this:RegisterEvent( "ZONE_CHANGED" );
  this:RegisterEvent( "ZONE_CHANGED_NEW_AREA" );

  Paranoia_Frame_Status1:ClearAllPoints();
  Paranoia_Frame_Status1:SetPoint( "TOPLEFT", "Paranoia_Frame_Main", "TOPLEFT", 8, -8 );
  
  Paranoia_Frame_Status2:ClearAllPoints();
  Paranoia_Frame_Status2:SetPoint( "TOPLEFT", "Paranoia_Frame_Status1", "BOTTOMLEFT", 0, 0 );
  Paranoia_Frame_Status3:ClearAllPoints();
  Paranoia_Frame_Status3:SetPoint( "TOPLEFT", "Paranoia_Frame_Status2", "BOTTOMLEFT", 0, 0 );
  Paranoia_Frame_Status4:ClearAllPoints();
  Paranoia_Frame_Status4:SetPoint( "TOPLEFT", "Paranoia_Frame_Status3", "BOTTOMLEFT", 0, 0 );
  Paranoia_Frame_Status5:ClearAllPoints();
  Paranoia_Frame_Status5:SetPoint( "TOPLEFT", "Paranoia_Frame_Status4", "BOTTOMLEFT", 0, 0 );

  DEFAULT_CHAT_FRAME:AddMessage( "Lifetapt's Paranoia v1.04 loaded. Use /paranoia or /pconf for options." )
end

function Paranoia_LoadVariables()
  -- set initial settings if this is first run
  if ( Paranoia_Config.enabled == nil ) then Paranoia_Config.enabled = true; 
    DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Initial configuration applied... thanks for downloading Paranoia!" )
  end
  if ( Paranoia_Config.disableInBattlefield == nil ) then Paranoia_Config.disableInBattlefield = true; end
  if ( Paranoia_Config.disableInSanctuaries == nil ) then Paranoia_Config.disableInSanctuaries = true; end
  if ( Paranoia_Config.debugMessages == nil ) then Paranoia_Config.debugMessages = false; end
  if ( Paranoia_Config.verboseDebug == nil ) then Paranoia_Config.verboseDebug = false; end
  if ( Paranoia_Config.enableSound == nil ) then Paranoia_Config.enableSound = true; end


  if ( Paranoia_Config.enabled ) then
    ShowUIPanel( Paranoia_Frame_Main );
  else
    HideUIPanel( Paranoia_Frame_Main );
  end
  
  if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia debug mode is enabled! Type /paranoia debug to disable debug mode." ); end
  
end

-- 1352 is the unitflag we want, (hexadecimal 548)
-- we want to search in arg5 and arg8 (sourceFlags and destFlags)
-- 4424 = hostile pet
-- 
-- I apologize for all the debug messages polluting the code, I know it makes it kind of hard to read
-- for you but when working with this addon I was (and still am I guess) a beginner to LUA, so I really
-- needed those messages... debugging without breakpoints is kinda difficult for me xD

function Paranoia_OnEvent( event )
  local hostileAction = false;
  
  if ( event == "VARIABLES_LOADED" ) then
    Paranoia_LoadVariables();
    Paranoia_PartyMembersChanged();
  elseif ( event == "COMBAT_LOG_EVENT_UNFILTERED" ) then
    local copyArg4 = "";
    local copyArg7 = "";
    if (not arg4) then copyArg4 = "nil"; else copyArg4 = arg4; end
    if (not arg7) then copyArg7 = "nil"; else copyArg7 = arg7; end
    if ( Paranoia_Config.debugMessages and Paranoia_Config.verboseDebug ) then  DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: event: "..arg2.." | sName: "..copyArg4.." | sFlags "..arg5.." | dName: "..copyArg7.." | dFlags "..arg8 ); end
    if ( arg5 == unitflag_hostilepc or arg5 == unitflag_neutralpc ) then
      hostileAction = true;
    end
    if ( arg8 == unitflag_hostilepc or arg8 == unitflag_neutralpc ) then
      hostileAction = true;
    end
    if ( hostileAction == true ) then
      if (not arg4) then
        Paranoia_WarnHostilePlayer( event, arg7 );
      end
      if (not arg7) then
        Paranoia_WarnHostilePlayer( event, arg4 );
      end
    end
  elseif ( event == "PARTY_MEMBERS_CHANGED" ) then
    Paranoia_PartyMembersChanged();
  elseif ( event == "ZONE_CHANGED" or event =="ZONE_CHANGED_NEW_AREA" ) then
    if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: "..event.." event fired!" ); end
    if ( Paranoia_Config.enabled and ((not Paranoia_Config.disableInBattlefield) or (not Paranoia_IsPlayerInBattlefield())) ) then
      if ( Paranoia_Config.debugMessages ) then  DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Paranoia is enabled and we are not in a BG/Arena!" ); end
      if ( Paranoia_IsPlayerInSanctuary() == false ) then
        if ( Paranoia_Config.debugMessages ) then  DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: We are not in a sanctuary zone!" ); end
        if ( not (  Paranoia_Frame_Main:GetAlpha() == 1 ) ) then
          if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Main UI panel is hidden... showing main panel!" ); end
          ShowUIPanel( Paranoia_Frame_Main );
          UIFrameFadeIn(Paranoia_Frame_Main, 0.4, 0, 1);
        end
        Paranoia_UpdateHostileList();
      else
        if ( Paranoia_Config.debugMessages ) then  DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: We are in a sanctuary!" ); end
        if ( Paranoia_Config.disableInSanctuaries == true and Paranoia_Frame_Main:IsVisible() ) then
          if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Main UI panel is visible and we just zoned into a sanctuary... hiding main panel!" ); end
          local startTime = GetTime()
          local endTime = GetTime()
          local resultTime = GetTime()
          gHostileList = {};
          gCurHostiles = 0;
          gNotHostileList = {};
          gCurNotHostiles = 0;
          gLastWarnHostilePlayer = 0;
          mainStartTime = GetTime();
          UIFrameFadeOut(Paranoia_Frame_Main, 0.4, 1, 0);
        else 
            if ( not (  Paranoia_Frame_Main:GetAlpha() == 1 ) ) then
              DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Showing window. "..Paranoia_Frame_Main:GetAlpha() );
              ShowUIPanel( Paranoia_Frame_Main );
              UIFrameFadeIn(Paranoia_Frame_Main, 0.4, 0, 1);
            end
        end
      end
    else if ( Paranoia_Config.debugMessages ) then  DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Paranoia is disabled or we are in a BG/Arena!" ); end
    end
  end
end

function Paranoia_OnDragStart()

  Paranoia_Frame_Main:StartMoving();

end

function Paranoia_OnDragStop()

  Paranoia_Frame_Main:StopMovingOrSizing();

end

function Paranoia_OnUpdate()

  if ( Paranoia_Config.enabled and ((not Paranoia_Config.disableInBattlefield) or (not Paranoia_IsPlayerInBattlefield())) ) then
    if ( Paranoia_IsPlayerInSanctuary() == false ) then
      if ( Paranoia_Frame_Main:GetAlpha() == 0 ) then
        if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Main UI panel is hidden... showing main panel!" ); end
        ShowUIPanel( Paranoia_Frame_Main );
        UIFrameFadeIn(Paranoia_Frame_Main, 0.4, 0, 1)
      end
      Paranoia_UpdateHostileList();
    else
      if ( Paranoia_Config.disableInSanctuaries == true) then
        if ( Paranoia_Frame_Main:GetAlpha() == 1 ) then
          if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Main UI panel is visible and we just zoned into a sanctuary... hiding main panel!" ); end
          gHostileList = {};
          gCurHostiles = 0;
          gNotHostileList = {};
          gCurNotHostiles = 0;
          gLastWarnHostilePlayer = 0;
          mainStartTime = GetTime();
          UIFrameFadeOut(Paranoia_Frame_Main, 0.4, 1, 0);
        end
      else
        if ( Paranoia_Frame_Main:GetAlpha() == 0 ) then
          ShowUIPanel( Paranoia_Frame_Main );
          UIFrameFadeIn(Paranoia_Frame_Main, 0.4, 0, 1)
        end
        Paranoia_UpdateHostileList();
      end
    end
  else
    gHostileList = {};
    gCurHostiles = 0;
    gNotHostileList = {};
    gCurNotHostiles = 0;
    gLastWarnHostilePlayer = 0;
    if ( Paranoia_Frame_Main:GetAlpha() == 1 ) then
    if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Hiding main window." ); end
        mainStartTime = GetTime();
        UIFrameFadeOut(Paranoia_Frame_Main, 0.4, 1, 0);
    end
    
  end
  if ( not ( configStartTime == 0 ) ) then
    local cResultTime = 0;
    cResultTime = GetTime() - configStartTime;
    if ( cResultTime > 0.21 ) then
      if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Closing config frame." ); end
      configStartTime = 0;
      if ( ParanoiaConf_Frame:IsVisible() ) then ParanoiaConf_Frame:Hide(); end
    end
  end
  if ( not ( mainStartTime == 0 ) ) then
    local mResultTime = 0;
    mResultTime = GetTime() - mainStartTime;
    if ( mResultTime > 0.41 ) then
      if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Closing main frame." ); end
      mainStartTime = 0;
      if ( Paranoia_Frame_Main:IsVisible() ) then Paranoia_Frame_Main:Hide(); end
    end
  end
end

--===================================================================================================================--
--  Helper functions
--===================================================================================================================--

function Paranoia_IsPlayerInBattlefield()

  if ( IsActiveBattlefieldArena() ) then
    return( true );
  elseif ( GetBattlefieldInstanceRunTime() > 0 ) then
    return( true );
  end

  return( false );

end

function Paranoia_IsPlayerInSanctuary()

    local pvpType, isFFA, faction = GetZonePVPInfo();
    isFFA = nil;
    faction = nil;
    if (pvpType == "sanctuary") then
        return( true );
    else
        return( false );
    end
end

function Paranoia_ToBoolean( value )

  if ( value == nil ) then
    return( false );
  end

  if ( type(value) == 'boolean' ) then
    return( value );
  end

  return( true );

end

function Paranoia_Msg( msg )

  ChatFrame1:AddMessage( "<P>"..msg );

end

function Paranoia_SlashHandler( arg )
  if ( arg ) then
    arg = string.lower( arg );
  end
  if ( arg == "config" ) then
    Paranoia_ShowConfig();
  elseif ( arg == "enable" ) then
    Paranoia_Config.enabled = true;
    Paranoia_OnUpdate();
    DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Paranoia has been enabled." );
  elseif ( arg == "disable" ) then
    Paranoia_Config.enabled = false;
    DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Paranoia has been disabled." );
  elseif ( arg == "debug" ) then 
    if ( Paranoia_ToBoolean( Paranoia_Config.debugMessages )) then 
      Paranoia_Config.debugMessages = false;
      DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Debug mode disabled." );
    else
      Paranoia_Config.debugMessages = true;
      DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Debug mode enabled." );
    end
  elseif ( arg == "verbose" ) then
    if ( Paranoia_ToBoolean( Paranoia_Config.verboseDebug )) then 
      Paranoia_Config.verboseDebug = false;
      DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Verbose debug mode disabled." );
    else
      Paranoia_Config.verboseDebug = true;
      Paranoia_Config.debugMessages = true;
      DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Verbose debug mode enabled." );
    end
  else
    DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Slash Command List" );
    DEFAULT_CHAT_FRAME:AddMessage( "/paranoia config      -  Opens the Paranoia configuration window. " );
    DEFAULT_CHAT_FRAME:AddMessage( "/paranoia enable      -  Enables the Paranoia addon. " );
    DEFAULT_CHAT_FRAME:AddMessage( "/paranoia disable     -  Disables the Paranoia addon. " );
    DEFAULT_CHAT_FRAME:AddMessage( "/paranoia debug       -  Toggles Paranoia debug mode (will cause chat window spam). " );
    DEFAULT_CHAT_FRAME:AddMessage( "/paranoia verbose     -  Toggles Paranoia verbose debug mode (will cause a lot chat window spam). " );
  end
  
end

--===================================================================================================================--
-- HOSTILE HANDLING
--===================================================================================================================--

function Paranoia_AddNotHostile( name )

  if ( gNotHostileList[name] ) then
    gNotHostileList[name].time = GetTime();
  elseif ( gCurNotHostiles < gMaxNotHostiles ) then
    gNotHostileList[name] = { time = GetTime() };
    gCurNotHostiles = gCurNotHostiles + 1;
  end

end

function Paranoia_PartyMembersChanged()

  local i;

  Paranoia_AddNotHostile( UnitName('player') );
  if ( UnitExists('pet') ) then
    Paranoia_AddNotHostile( UnitName('pet') );
  end

  for i = 1, GetNumPartyMembers() do
    if ( UnitExists('party'..i) ) then
      Paranoia_AddNotHostile( UnitName('party'..i) );
    end
    if ( UnitExists('partypet'..i) ) then
      Paranoia_AddNotHostile( UnitName('partypet'..i) );
    end
  end

end

-- this function is no longer used due to the new patch 2.4 combat system
--[[function Paranoia_HostileExtractName( msg )

  local name = nil;

  local pos = string.find( msg, '%s' );			-- %s = space
  if ( pos ) then
    name = strsub( msg, 1, pos-1 );
    pos = string.find( name, "'" );			-- ' (Gror's fireball ...)
    if ( pos ) then
      name = strsub( msg, 1, pos-1 );
    end
  end

  return( name );

end]]--

function Paranoia_WarnHostilePlayer( event, name )

  local isHostile = false;

  if ( not (Paranoia_Config.enabled and name) ) then
    return;
  end
if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Entering WarnHostilePlayer... event: "..event.." | name: "..name ); end
  if ( name ) then
    if ( gHostileList[name] ) then
      gHostileList[name].time = GetTime();
      isHostile = true;
    elseif ( gNotHostileList[name] ) then
      gNotHostileList[name].time = GetTime();
      isHostile = false;
    else
      Paranoia_AddUntargetedHostile( name );
      isHostile = true;
    end
  end

  if ( isHostile and GetTime() - gLastWarnHostilePlayer > 60 ) then
    if ( not ( (Paranoia_Frame_Main:GetAlpha() == 0)) and Paranoia_Config.enableSound ) then
        
        if ( Paranoia_Config.debugMessages ) then DEFAULT_CHAT_FRAME:AddMessage( "Paranoia: Playing warning sound...  | alpha: "..Paranoia_Frame_Main:GetAlpha() ); end
        PlaySoundFile( "Interface\\AddOns\\ParanoiaRevived\\ganker.wav" );
        gLastWarnHostilePlayer = GetTime();
    end
  end

end

function Paranoia_UnitIsHostile( unit, name )

  return( UnitExists(unit) and UnitName(unit) == name and UnitIsPlayer(unit) and UnitIsEnemy("player",unit) );

end

function Paranoia_AddUntargetedHostile( name )

  gHostileList[name] = { time = GetTime() };
  gCurHostiles = gCurHostiles + 1;

  gHostileList[name].class = '???';
  gHostileList[name].level = 0;
  if ( gHostileList[name].level ~= nil and gHostileList[name].level > 0 ) then
    gHostileList[name].levelDiff = gHostileList[name].level - UnitLevel("player");
  else
    gHostileList[name].levelDiff = '?';
  end

end

function Paranoia_LookupHostile( name )

  if ( not gHostileList[name] ) then
    return;
  end

  gLastLookup = GetTime();

  if ( (not gHostileList[name].class or gHostileList[name].class == '???') and UnitExists('target') and UnitName('target')==name ) then
    gHostileList[name].class = UnitClass("target");
    gHostileList[name].level = UnitLevel("target");
    if ( gHostileList[name].level ~= nil and gHostileList[name].level > 0 ) then
      gHostileList[name].levelDiff = gHostileList[name].level - UnitLevel("player");
    else
      gHostileList[name].levelDiff = '?';
    end
  end

end

function Paranoia_UpdateHostileList()

  local buttonText, i, displayed;
  local dispName, class;

  displayed = 0;
  i = 1;
  for name,_ in pairs(gHostileList) do
    if ( gHostileList[name].time < GetTime() - 60 ) then
      gHostileList[name] = nil;
      gCurHostiles = gCurHostiles - 1;
    elseif ( i <= MAX_LINES ) then
      button = getglobal( "Paranoia_Frame_Status"..i );
      buttonText = getglobal( "Paranoia_Frame_Status"..i.."Text" );

      Paranoia_LookupHostile( name );

      dispName = name;

      class = gHostileList[name].class;
      if ( class == 'Warlock' ) then
        class = 'Wlk';
      else
        class = strsub(class,1,3);
      end

--      button:Show();
      button.nickname = name;
      button.id = name;
      buttonText:SetText( dispName.." ("..class.."/"..gHostileList[name].levelDiff..")" );
      buttonText:SetTextColor( 1, 1, 0 );

      displayed = displayed + 1;
      i = i + 1;
    end
  end

  while ( i <= MAX_LINES ) do
    button = getglobal( "Paranoia_Frame_Status"..i );
    buttonText = getglobal( "Paranoia_Frame_Status"..i.."Text" );

--    button:Hide();
    button.nickname = "empty"..i;
    button.id = "emptyid"..i;
    buttonText:SetText( "" );
    buttonText:SetTextColor( 0.5, 0.5, 0.5 );

    i = i + 1;
  end

  for name,_ in pairs(gNotHostileList) do
    if ( gNotHostileList[name].time < GetTime() - 60*60*3 ) then		-- 3 hours
      gNotHostileList[name] = nil;
      gCurNotHostiles = gCurNotHostiles - 1;
    end
  end

  --change the window height according to max on list
--  if ( displayed < 1 ) then
--    displayed = 1;
--  end
--  Paranoia_Frame_Main:SetHeight( 10 + displayed*18 );
--
  Paranoia_Frame_Main:SetHeight( 10 + MAX_LINES*18 );

end

--===================================================================================================================--
-- Config GUI
--===================================================================================================================--

function Paranoia_OptionCheckBoxClicked( option )

  Paranoia_Config[option] = Paranoia_ToBoolean( this:GetChecked() );

end

function Paranoia_OptionCheckBoxInit( option )

  this:SetChecked( Paranoia_ToBoolean(Paranoia_Config[option]) );

end

function Paranoia_ShowConfig()

  ParanoiaConf_Frame:Show();
  UIFrameFadeIn(ParanoiaConf_Frame, 0.2, 0, 1);
end

function ParanoiaConf_CloseClicked()

  ParanoiaConf_Frame:Hide();
  UIFrameFadeOut(ParanoiaConf_Frame, 0.2, 1, 0);
  configStartTime = GetTime()
end
