-- Version & Date
local MAJOR_VERSION = "3.0"
local MINOR_VERSION = tonumber((string.gsub("$Revision: 24807 $", "^.-(%d+).-$", "%1")))

-- Libs
local metro = AceLibrary("Metrognome-2.0")
local deformat = AceLibrary("Deformat-2.0")
local BB = AceLibrary("Babble-Boss-2.2")

local L = AceLibrary("AceLocale-2.2"):new("Paparazzi")
Paparazzi = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")

-- Keybindings
BINDING_HEADER_PAPARAZZI = "Paparazzi"
BINDING_NAME_AUTO_SHOTS = "Paparazzi Auto-Shots"
BINDING_NAME_CLEAN_SCREENSHOT = L["Smart Shot"]

-- About
local Paparazzi = Paparazzi
Paparazzi.title = "Paparazzi"
Paparazzi.version = MAJOR_VERSION .. "." .. MINOR_VERSION
Paparazzi.date = string.gsub("$Date: 2008-01-23 11:24:06 -0500 (Wed, 23 Jan 2008) $", "^.-(%d%d%d%d%-%d%d%-%d%d).-$", "%1")

local sformat = string.format
local tonumber = tonumber
local WatchList = {}
local TakeShots = false

local function get(key)
	return Paparazzi.db.profile[key]
end

local function set(key, val)
	Paparazzi.db.profile[key] = val
end

-- Inititalize
function Paparazzi:OnInitialize()
		self:RegisterDB("PaparazziDB")
		self:RegisterDefaults('profile', {
			dly = 0.8,
			qnt = 5,
			qual = GetCVar("screenshotQuality"), 
			format = "true", 
			MemberLimit = 20,
			bosskill = false,
			critscreenpt = false,
			critscreenpl = false,
			active = 0,
	    minlevel = 1,
	    maxlevel = 70,
	    cwind = 1,
		})

		local args = {
				
			type="group",
			args = {
			PaPScreens = {
	     order = 5,
			 type = 'group',
			 name = "UI Elements",
			 desc = "Turn Off Certain UI Elements From Your Screen Shot",
			 args = {
			  pc = {
					name = 	L["PC"],
					order = 10,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["PC"]),
					get = 	function() return self.db.profile.PC end,
					set = 	function(v)
								self.db.profile.PC = v
							end,
				},
				own = {
					name = 	L["Own"],
					order = 9,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["Own"]),
					get = 	function() return self.db.profile.Own end,
					set = 	function(v)
								self.db.profile.Own = v
							end,
				},
				pvp = {
					name = 	L["PvP"], 
					order = 11,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["PvP"]),
					get = 	function() return self.db.profile.PvP end,
					set = 	function(v)
								self.db.profile.PvP = v
							end,
				},
				guild = {
					name = 	L["Guild"], 
					order = 6,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["Guild"]),
					get = 	function() return self.db.profile.Guild end,
					set = 	function(v)
								self.db.profile.Guild = v
							end,
				},
				npc = {
					name = 	L["NPC"], 
					order = 7,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["NPC"]),
					get = 	function() return self.db.profile.NPC end,
					set = 	function(v)
								self.db.profile.NPC = v
							end,
				},
				cb = {
					name = 	L["CB"], 
					order = 1,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["CB"]),
					get = 	function() return self.db.profile.CB end,
					set = 	function(v)
								self.db.profile.CB = v
							end,
				},				
				cbp = {
					name = 	L["CBP"], 
					order = 2,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["CBP"]),
					get = 	function() return self.db.profile.CBP end,
					set = 	function(v)
								self.db.profile.CBP = v
							end,
				},				
				cd = {
					name = 	L["CD"], 
					order = 3,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["CD"]),
					get = 	function() return self.db.profile.CD end,
					set = 	function(v)
								self.db.profile.CD = v
							end,
				},
				osc = {
					name = 	L["OSC"], 
					order = 8,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["OSC"]),
					get = 	function() return self.db.profile.OSC end,
					set = 	function(v)
								self.db.profile.OSC = v
							end,
				},
					ui = {
					name = 	L["UI"], 
					order = 11,
					type = 	"toggle",
					desc = 	string.format(L["Screen"],L["UI"]),
					get = 	function() return self.db.profile.UI end,
					set = 	function(v)
								self.db.profile.UI = v
							end,
				},							                
		  },
		},	
		 PaFScreens = {
	    order = 4,
			type = 'group',
			name = "ScreenShot Options",
			desc = "Configure Format and Quality of Your Screen Shot",
			args = {
			  quality = {
					type = "range",
					order = 2,
					name = "ScreenShot Quality",
					desc = "Set the Quality of your ScreenShots",
					max = 10,
					min = 1,
					step = 1,					
					get = "GetQuality",
					set = "SetQuality",
				},		    
				format = {
			    type = 'text',
			    name = "Format",
			    desc = "Change ScreenShot Format",
			    get = function()
				     return self.db.profile.format
			      end,
			    set = function(v)
				     self.db.profile.format = v
				     self:ScreenFormat()				     
			    end,
			    validate = {L["jpeg"], L["tga"], L["png"]},
			    order = 1,
		    },	     
		  },
		},	
		 PaASScreens = {
	    order = 2,
			type = 'group',
			name = "Auto ScreenShot Options",
			desc = "Configure Options for Auto Shots",
			args = {
			  	delay = {
					name = 	L["Delay"], 
					order = 2,
					type = 	"range",
					desc = 	L["Delay_Dsc"],
					get = 	function()
								return self.db.profile.dly
							end,
					set = 	function(v)
								self.db.profile.dly = v
								self.d = v
								metro:ChangeRate("Screen",self.d,"Show",self.d)
								metro:ChangeRate("Show2",((self.d *1.5) * self.q))
							end,
					min = 0.5,
					max = 60,
					step = 0.1
				},
				amount = {
					name = 	L["Amount"], 
					order = 1,
					type = "range",
					desc = L["Amount_Dsc"],
					get = function()
								return self.db.profile.qnt
							end,
					set = function(v)
								self.db.profile.qnt = v
								self.q = v
								metro:ChangeRate("Show2",((self.d *1.5) * self.q))
							end,
					min = 1,
					max = 100,
					step = 1,
				},			     
		  },
		},							
		 PaASBScreens = {
	     order = 1,
		 	 type = 'group',
			 name = "Auto Boss Kill Shots",
			 desc = "Configure Your Boss Kill ScreenShots",
			 args = {
			  memberlimit = {
			    type = "range",
			    order = 2,
			    name = "Member limit",
			    desc = "How many members should be in a raid in order for a screenshot to be taken.",
			    min = 1,
			    max = 40,
			    step = 1,
			    get = get,
			    set = set,
			    passValue = "MemberLimit",
		    },
		    PaASTOG = {
				 order = 1,
				 type = "toggle",
				 name = "Boss Shots",
				 desc = "Toggles Boss Shots Support. In this mode, you will take ScreenShots of Killed Bosses AutoMatically",
				 get = function() return self.db.profile.bosskill end,
				 set = function(c)
				 self.db.profile.bosskill = c
			  end
		    },		
		  },
		},	
		  PaCSBScreens = {
	     order = 3,
		 	 type = 'group',
			 name = "Event Shots",
			 desc = "Configure ScreenShots For Special Events",
			 args = {			
			  PaCSLScreens = {
	         order = 2,
		 	     type = 'group',
			     name = "LevelUP Shots",
			     desc = "Configure ScreenShots For LevelUP Events",
			   args = {
			   PaCSLTOG1 = {
				   order = 2,
				   type = "toggle",
				   name = "LevelSnap",
				   desc = "Toggles ScreenShot Support For Your Toons When they LevelUP.",
				   get = function() return self.db.profile.active end,
				   set = function(c)
				    self.db.profile.active = c
			     end
		     },
		     PaCSLTOG2 = {
				   order = 4,
				   type = "range",
				   name = "Min Player Level",
				   desc = "Adjust Player Level Support.",
				   min = 1,
			     max = 70,
			     step = 1,
			     get = get,
			     set = set,
			     passValue = "minlevel",
		     },
		     PaCSLTOG3 = {
				   order = 3,
				   type = "range",
				   name = "Max Player Level",
				   desc = "Adjust Player Level Support.",
				   min = 1,
			     max = 70,
			     step = 1,
			     get = get,
			     set = set,
			     passValue = "maxlevel",
		     },
		     PaCSLTOG4 = {
				   order = 1,
				   type = "toggle",
				   name = "Close Windows",
				   desc = "Automatically close all windows.",				   
				   get = function() return self.db.profile.cwind end,
				   set = function(c)
				    self.db.profile.cwind = c
			     end
		     },
		    },
		   },				  
		  },
	   },					    			    					
				reset = {
					name = L["Reset"], 
					order = 6,
					type = "execute",
					desc = L["Reset_Dsc"],
					func = function()
							self:ResetDB("profile")
								self.d = self.db.profile.dly
								self.q = self.db.profile.qnt
								metro:ChangeRate("Screen",self.d,"Show",self.d)
								metro:ChangeRate("Show2",((self.d *1.5) * self.q))
							end							
				}				
			}
		}
		self:RegisterChatCommand({ "/pap", "/paparazzi" }, args)
	end

function Paparazzi:OnLoad(self)	
end

-- OnEnable	
	function Paparazzi:OnEnable()
		self.d = self.db.profile.dly
		self.q = self.db.profile.qnt
		metro:Register("Show",self.Show,self.d,self)
		metro:Register("Show2",self.Show,((self.d *1.5) * self.q),self)
		metro:Register("Screen",self.Screen,self.d,self)		
	  self:RegisterEvent("UPDATE_MOUSEOVER_UNIT")	  
	  self:RegisterEvent("PLAYER_REGEN_ENABLED")
	  self:RegisterEvent("PLAYER_LEVEL_UP")
	  self:RegisterEvent("PLAYER_LOGOUT")
	  self:RegisterEvent("PLAYER_TARGET_CHANGED")
	  self:RegisterEvent("SCREENSHOT_SUCCEEDED")
    self:RegisterEvent("SCREENSHOT_FAILED")   
    self:RegisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH")
	end

-- OnDisable	
	function Paparazzi:OnDisable()
		metro:Unregister("Show","Show2","Screen")
	end

-- Screenshot functions	
	function Paparazzi:DoScreenie()		
		self:CheckRunning()
		if show or show2 or scr then return end
		self:CheckToggles()
		self:CheckFrames()
		metro:Start("Show")
		Screenshot()
	end
		
	function Paparazzi:DoAuto()		
		self:CheckRunning()
		if show or show2 or scr then return end
		self:CheckToggles()
		HideUIPanel(UIParent)
		metro:Start("Show2")
		metro:Start("Screen", self.q)
	end
  
	function Paparazzi:Show()		
		ShowUIPanel(UIParent)
		metro:Stop("Show")
		metro:Stop("Show2")
		self:ToggleBack()
	end
	
	function Paparazzi:Screen()		
		Screenshot()
	end
	
 function Paparazzi:CheckFrames()
	  if not InCombatLockdown() then
	   if self.db.profile.UI then	    
       UIParent:Hide()
     else
       UIParent:Show()
     end
    end
 end
	
	function Paparazzi:CheckRunning()		
		local _,_,show = metro:Status("Show")
		local _,_,show2 = metro:Status("Show2")
		local _,_,scr = metro:Status("Screen")
	end

	function Paparazzi:CheckToggles()
		self.PC	= GetCVar("UnitNameFriendlyPlayerName")
		self.PCP	= GetCVar("UnitNameFriendlyPetName")
		self.PCC	= GetCVar("UnitNameFriendlyCreationName")
		self.NPC = GetCVar("UnitNameNPC")
		self.NPCC = GetCVar("UnitNameCompanionName")
		self.Guild = GetCVar("UnitNamePlayerGuild")
		self.Own = GetCVar("UnitNameOwn")
		self.PvP = GetCVar("UnitNamePlayerPVPTitle")		
		self.CB = GetCVar("ChatBubbles")
		self.CBP = GetCVar("ChatBubblesParty")
		self.CD = GetCVar("CombatDamage")
		self.OSC = GetCVar("ObjectSelectionCircle")
											
		if self.db.profile.PC and self.PC == "1" then SetCVar("UnitNameFriendlyPlayerName", 0) self.hidePC = true end
		if self.db.profile.PCP and self.PCP == "1" then SetCVar("UnitNameFriendlyPetName", 0) self.hidePCP = true end
		if self.db.profile.PCC and self.PCC == "1" then SetCVar("UnitNameFriendlyCreationName", 0) self.hidePCC = true end
		if self.db.profile.Own and self.Own == "1" then SetCVar("UnitNameOwn", 0) self.hideOwn = true end
		if self.db.profile.NPC and self.NPC == "1" then SetCVar("UnitNameNPC", 0) self.hideNPC = true end
		if self.db.profile.NPCC and self.NPCC == "1" then SetCVar("UnitNameCompanionName", 0) self.hideNPCC = true end
		if self.db.profile.Guild and self.Guild == "1" then SetCVar("UnitNamePlayerGuild", 0) self.hideGuild = true end
		if self.db.profile.PvP and self.PvP == "1" then SetCVar("UnitNamePlayerPVPTitle", 0) self.hidePvP = true end
	  if self.db.profile.CB and self.CB == "1" then SetCVar("ChatBubbles", 0) self.hideCB = true end
	  if self.db.profile.CBP and self.CBP == "1" then SetCVar("ChatBubblesParty", 0) self.hideCBP = true end
	  if self.db.profile.CD and self.CD == "1" then SetCVar("CombatDamage", 0) self.hideCD = true end
	  if self.db.profile.OSC and self.OSC == "1" then SetCVar("ObjectSelectionCircle", 0) self.hideOSC = true end
	end
	
	function Paparazzi:ToggleBack()
		if self.hidePC then SetCVar("UnitNameFriendlyPlayerName", self.PC) end
		if self.hidePCP then SetCVar("UnitNameFriendlyPetName", self.PCP) end
		if self.hidePCC then SetCVar("UnitNameFriendlyCreationName", self.PCC) end
		if self.hideOwn then SetCVar("UnitNameOwn", self.Own) end	
		if self.hideNPC then SetCVar("UnitNameNPC", self.NPC) end
		if self.hideNPCC then SetCVar("UnitNameCompanionName", self.NPCC) end
		if self.hideGuild then SetCVar("UnitNamePlayerGuild", self.Guild) end
		if self.hidePvP then SetCVar("UnitNamePlayerPVPTitle", self.PvP) end
		if self.hideCB then SetCVar("ChatBubbles", self.CB) end
		if self.hideCBP then SetCVar("ChatBubblesParty", self.CBP) end
		if self.hideCD then SetCVar("CombatDamage", self.CD) end
		if self.hideOSC then SetCVar("ObjectSelectionCircle", self.OSC) end		
		self.hidePC, self.hidePCC, self.hidePCP, self.hideNPC, self.hideNPCC, self.hideGuild, self.hidePvP, self.hideOwn, self.hideCB, self.hideCBP, self.hideCD, self.hideOSC = nil, nil, nil, nil, nil, nil, nil, nil, nil
	end

-- Set format and quality
function Paparazzi:ScreenFormat()	
	if Paparazzi.db.profile.format==L["jpeg"] then
	  	SetCVar("screenshotFormat", "jpeg")	
	elseif Paparazzi.db.profile.format==L["png"] then	
	    if IsMacClient() then    
	      SetCVar("screenshotFormat", "png")
	    else
	      SetCVar("screenshotFormat", "jpeg")
	      Paparazzi.db.profile.format = L["jpeg"]
	    end	
	elseif Paparazzi.db.profile.format==L["tga"] then
	    SetCVar("screenshotFormat", "tga")
	end
end

--Fubar Tablet Function for switching formats
function ChangeScreenshotFormat(ssFormat)
	-- Possible formats: tga, jpeg, png
	-- PNG is currently Mac only.
	-- Cycle order: tga -> jpeg -> png
	local newFormat		
	if ssFormat == "tga" then
		newFormat = "jpeg"
	end

	if ssFormat == "jpeg" then
		if IsMacClient() then
			newFormat = "png"
		else
			newFormat = "tga"
		end
	end

	if ssFormat == "png" then
		newFormat = "tga"
	end

	if newFormat then
		SetCVar("screenshotFormat", newFormat)
	end
end

-- Quality Screenshot Control
function Paparazzi:GetQuality()
	return self:GetQualityLevel("screenshotQuality")
end

function Paparazzi:SetQuality(value)
	self:SetQualityLevel("screenshotQuality", value)	
end

function Paparazzi:GetQualityLevel(var)
	return GetCVar(var)
end

function Paparazzi:SetQualityLevel(var, value)
	SetCVar(var, value)
	if var == "screenshotQuality" then		
		Paparazzi.db.profile.qual = value		
	end
end

--Fubar Tablet Function for switching quality
function ChangeScreenshotQuality(ssQuality)
	ssQuality = tonumber(ssQuality)	
		-- Holt down Alt key to decrease quality
	if IsAltKeyDown() then
		if ssQuality > 0 then
			ssQuality = ssQuality - 1
			SetCVar("screenshotQuality", ssQuality)
		end
	else -- Increase quality
		if ssQuality < 10 then
			ssQuality = ssQuality + 1
			SetCVar("screenshotQuality", ssQuality)
		end
	end
end

--BossKill Screenshot Control
function Paparazzi:TScreenshot()
	if self.db.profile.bosskill then
	 if GetNumRaidMembers() >= get("MemberLimit") then
		Screenshot()
		TakeShots = false
	 end
	end
end

function Paparazzi:CheckTarget(unit)
	local type = UnitClassification(unit)
	if type ~= "worldboss" then 
		return
	end
	
	local name = UnitName(unit)
	if WatchList[name] or not BB:HasTranslation(name) or UnitIsDead(unit) then
		return
	end
	
	self:Print(("Boss found: %s"):format(name))
	WatchList[name] = true
end

--event handelers
function Paparazzi:PLAYER_LEVEL_UP()
   if self.db.profile.active then
    if (arg1 >= self.db.profile.minlevel and arg1 <= self.db.profile.maxlevel) then
				if (self.db.profile.cwind) then
					CloseAllWindows()
					RequestTimePlayed()
					Screenshot()
				else
					RequestTimePlayed()
					Screenshot()
				end
		end
	end
end


function Paparazzi:PLAYER_LOGOUT()		   
end

function Paparazzi:SCREENSHOT_SUCCEEDED()
   Paparazzi:UnregisterEvent("SCREENSHOT_SUCCEEDED")
   Paparazzi:UnregisterEvent("SCREENSHOT_FAILED")
   Paparazzi:ToggleBack()
end

function Paparazzi:SCREENSHOT_FAILED()
   Paparazzi:UnregisterEvent("SCREENSHOT_SUCCEEDED")
   Paparazzi:UnregisterEvent("SCREENSHOT_FAILED")
   Paparazzi:ToggleBack()
end

function Paparazzi:UPDATE_MOUSEOVER_UNIT()
	self:CheckTarget("mouseover")
end

function Paparazzi:PLAYER_TARGET_CHANGED()
	self:CheckTarget("target")
end

function Paparazzi:PLAYER_REGEN_ENABLED()
	if TakeShots then
		self:TScreenshot()
	end
end

function Paparazzi:CHAT_MSG_COMBAT_HOSTILE_DEATH(msg)
 if self.db.profile.bosskill then
	local mob = deformat(msg, UNITDIESOTHER)
	if mob and WatchList[mob] then
		TakeShots = true
		WatchList[mob] = nil
		if not InCombatLockdown() then
			self:TScreenshot()
		end
	end
 end
end
