function Palatank_Menu_Toggle()
	if ( Palatank_Menu_Frame:IsShown() ) then
		Palatank_Menu_Frame:Hide();
	else
		Palatank_Menu_Frame:Show();
	end
end

function Palatank_Menu_SetupSlider(self, text, myMin, myMax, step)
	getglobal(self:GetName().."Text"):SetText(text);
	getglobal(self:GetName().."Low"):SetText(myMin);
	getglobal(self:GetName().."High"):SetText(myMax);
	self:SetMinMaxValues(myMin, myMax);
	self:SetValueStep(step);
end

function Palatank_OpenColorPicker(button)
	local colors = getglobal(button.."NormalTexture"):GetVertexColor();
	local button_name = "";
	if (button == "Palatank_Menu_Frame_BGColor") then
		button_name = "BGColor";
		button_r = Palatank_Options.BGColor[1];
		button_g = Palatank_Options.BGColor[2];
		button_b = Palatank_Options.BGColor[3];
		button_a = Palatank_Options.BGColor[4];
	elseif (button == "Palatank_Menu_Frame_FrameColor") then
		button_name = "FrameColor";
		button_r = Palatank_Options.FrameColor[1];
		button_g = Palatank_Options.FrameColor[2];
		button_b = Palatank_Options.FrameColor[3];
		button_a = Palatank_Options.FrameColor[4];
	elseif (button == "Palatank_Menu_Frame_TextColor") then
		button_name = "TextColor";
		button_r = Palatank_Options.TextColor[1];
		button_g = Palatank_Options.TextColor[2];
		button_b = Palatank_Options.TextColor[3];
		button_a = Palatank_Options.TextColor[4];
	end
	Palatank_CurrentSwatch = button;
	ColorPickerFrame.hasOpacity = true;
	ColorPickerFrame.opacityFunc = function() Palatank_ColorPickerChanged(); end;
	ColorPickerFrame.func = function() Palatank_ColorPickerChanged(); end;
	ColorPickerFrame.opacity = button_a;
	ColorPickerFrame:SetColorRGB(button_r, button_g, button_b);
	ColorPickerFrame.previousValues = {button_r, button_g, button_b,button_a};
	ColorPickerFrame.cancelFunc = Palatank_ColorPickerCanceled({button_r, button_g, button_b,button_a});
	ColorPickerFrame:ClearAllPoints();
	if (Palatank_Menu_Frame:GetRight() < UIParent:GetWidth() / 2) then
		ColorPickerFrame:SetPoint("LEFT", "Palatank_Menu_Frame", "RIGHT", 10, 0);
	else
		ColorPickerFrame:SetPoint("RIGHT", "Palatank_Menu_Frame", "LEFT", -10, 0);
	end
	ColorPickerFrame:Show();
end

function Palatank_ColorPickerChanged()
	local r,g,b = ColorPickerFrame:GetColorRGB();
	local a = OpacitySliderFrame:GetValue();
	Palatank_UpdateSwatchColor(r,g,b,a);
end

function Palatank_ColorPickerCanceled(prevvals)
	local r,g,b,a = unpack(prevvals)
	Palatank_UpdateSwatchColor(r,g,b,a);
end


function Palatank_UpdateSwatchColor(r,g,b,a)
	if(Palatank_CurrentSwatch == "Palatank_Menu_Frame_BGColor") then
		Palatank_Options.BGColor[1] = r;
		Palatank_Options.BGColor[2] = g;
		Palatank_Options.BGColor[3] = b;
		Palatank_Options.BGColor[4] = a;
	elseif(Palatank_CurrentSwatch == "Palatank_Menu_Frame_FrameColor") then
		Palatank_Options.FrameColor[1] = r;
		Palatank_Options.FrameColor[2] = g;
		Palatank_Options.FrameColor[3] = b;
		Palatank_Options.FrameColor[4] = a;
	elseif(Palatank_CurrentSwatch == "Palatank_Menu_Frame_TextColor") then
		Palatank_Options.TextColor[1] = r;
		Palatank_Options.TextColor[2] = g;
		Palatank_Options.TextColor[3] = b;
		Palatank_Options.TextColor[4] = a;

	end


	getglobal(Palatank_CurrentSwatch.."NormalTexture"):SetVertexColor(r,g,b);
	Palatank_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_AD_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_AD_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_Info_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_Info_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_RF_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_RF_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_UpdateTextColors();
	
Palatank_Aura_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_Aura_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_UpdateTextColors();

Palatank_PP_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_PP_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_UpdateTextColors();
	
Palatank_Spell_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_Spell_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_UpdateTextColors();
end

function Palatank_UpdateTextColors()
	Palatank_Frame_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);
	Palatank_AD_Frame_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);
	Palatank_Info_Frame_Name_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);
	Palatank_Info_Frame_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);

Palatank_Spell_Frame_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);
end

function Palatank_Menu_Init()
	Palatank_Menu_Frame_ShowBox:SetChecked(Palatank_Options.Show);
	Palatank_Menu_Frame_MiniBox:SetChecked(Palatank_Options.Mini);
	Palatank_Menu_Frame_SoundBox:SetChecked(Palatank_Options.WarningRFSound);
	Palatank_Menu_Frame_LockBox:SetChecked(Palatank_Options.Lock);
	Palatank_Menu_Frame_ADResetBox:SetChecked(Palatank_Options.ADReset);
	Palatank_Menu_Frame_AlphaSlider:SetValue(Palatank_Options.Alpha);
	Palatank_Menu_Frame_ScaleSlider:SetValue(Palatank_Options.Scale);
	Palatank_Menu_Frame_BGColorNormalTexture:SetVertexColor(Palatank_Options.BGColor[1], Palatank_Options.BGColor[2], Palatank_Options.BGColor[3]);
	Palatank_Menu_Frame_FrameColorNormalTexture:SetVertexColor(Palatank_Options.FrameColor[1], Palatank_Options.FrameColor[2], Palatank_Options.FrameColor[3]);
	Palatank_Menu_Frame_TextColorNormalTexture:SetVertexColor(Palatank_Options.TextColor[1], Palatank_Options.TextColor[2], Palatank_Options.TextColor[3]);
end