--Palatank - A mod of Tankadin by Fauks--
--Tankadin code by _Chloe--
--Inspired by Afraithe and its ArdentFu--
--Localisation deDE - by Farook--

Palatank = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0","AceDB-2.0","AceEvent-2.0","AceDebug-2.0", "AceComm-2.0")

local L = AceLibrary("AceLocale-2.2"):new("Palatank")


--Global--
Palatank_Options = {
	WarningRDStatus = true,
	WarningASStatus = true,
	WarningRFStatus = true,
	WarningADStatus = true,
	WarningRFSound = true,
	ShowFrames = true,
	ShowRFFrames = true,
	ShowADFrames = true,
	ShowINFOFrames = true,
	ShowAURAFrames = true,
	ShowPPFrames = true,
	ShowSPELLFrames = true,
	Lock = false,
	Split = true,
	Alpha = 1,
	Scale = 1,
	FrameColor = {1, 0.8, 0, 0.8},
	BGColor = {0, 0, 0, 0.4},
	TextColor = {1, 0.82, 0, 1},
	ADReset = true,
	ADCheck,
}

function Palatank_OnLoad(self)
	SLASH_PALATANK1 = "/Palatank";
	SlashCmdList["PALATANK"] = Palatank_SlashCommand;
	--CrushTable Info
	self:RegisterEvent("UNIT_INVENTORY_CHANGED");
	self:RegisterEvent("UNIT_AURA");
	self:RegisterEvent("ADDON_LOADED");
	-- catch the real "enter combat" message to start logging.
	self:RegisterEvent("PLAYER_REGEN_DISABLED");
	-- catch the real "leave combat" message to stop logging.
	self:RegisterEvent("PLAYER_REGEN_ENABLED");
	-- catch us being hurt or healed.
	self:RegisterEvent("COMBAT_TEXT_UPDATE");
	-- catch taunt
	-- RF Warning
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	--Initailize the display
	self:RegisterEvent("VARIABLES_LOADED");
end

function Palatank_ADCheck()

	local numTabs = GetNumTalentTabs();
	for t=1, numTabs do
		local numTalents = GetNumTalents(t);
		for i=1, numTalents do
			spell, icon, tier, column, currRank, maxRank= GetTalentInfo(2,20);  -- Tree 3 (protection), tier 19
		end
	end
	  if (spell == PALATANK_AD and maxRank) then
		 Palatank_Options.ADCheck = true;
	  else
	  	 Palatank_Options.ADCheck = false;
	 end

end


function Palatank_WarningsRD()
	if ( Palatank_Options.WarningRDStatus == false ) then
		Palatank_PP_FrameAWRDButtonMainTexture:SetVertexColor(1, 1, 1);
		Palatank_Options.WarningRDStatus = true;
		DEFAULT_CHAT_FRAME:AddMessage(PALATANK_RD.." Warnings : ON");
	elseif ( Palatank_Options.WarningRDStatus == true ) then
		Palatank_PP_FrameAWRDButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
		Palatank_Options.WarningRDStatus = false;
		DEFAULT_CHAT_FRAME:AddMessage(PALATANK_RD.." Warnings : OFF");
	end
end
function Palatank_WarningsAS()
	if ( Palatank_Options.WarningASStatus == false ) then
		Palatank_PP_FrameAWASButtonMainTexture:SetVertexColor(1, 1, 1);
		Palatank_Options.WarningASStatus = true;
		DEFAULT_CHAT_FRAME:AddMessage(PALATANK_AS.." Warnings : ON");
	elseif ( Palatank_Options.WarningASStatus == true ) then
		Palatank_PP_FrameAWASButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
		Palatank_Options.WarningASStatus = false;
		DEFAULT_CHAT_FRAME:AddMessage(PALATANK_AS.." Warnings : OFF");
	end
end
function Palatank_WarningsRF()
	if ( Palatank_Options.WarningRFStatus == false ) then
		Palatank_PP_FrameAWRFButtonMainTexture:SetVertexColor(1, 1, 1);
		Palatank_Options.WarningRFStatus = true;
		DEFAULT_CHAT_FRAME:AddMessage(PALATANK_RF.." Warnings : ON");
	elseif ( Palatank_Options.WarningRFStatus == true ) then
		Palatank_PP_FrameAWRFButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
		Palatank_Options.WarningRFStatus = false;
		DEFAULT_CHAT_FRAME:AddMessage(PALATANK_RF.." Warnings : OFF");
	end
end
function Palatank_WarningsAD()
	if ( Palatank_Options.WarningADStatus == false ) then
		Palatank_PP_FrameAWADButtonMainTexture:SetVertexColor(1, 1, 1);
		Palatank_Options.WarningADStatus = true;
		DEFAULT_CHAT_FRAME:AddMessage(PALATANK_AD.." Warnings : ON");
	elseif ( Palatank_Options.WarningADStatus == true ) then
		Palatank_PP_FrameAWADButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
		Palatank_Options.WarningADStatus = false;
		DEFAULT_CHAT_FRAME:AddMessage(PALATANK_AD.." Warnings : OFF");
	end
end

function Palatank_SlashCommand(msg)
	Palatank_Menu_Toggle();
end


function Palatank_Toggle()
	if ( Palatank_Frame:IsShown() ) then
		Palatank_Frame:Hide();
		DEFAULT_CHAT_FRAME:AddMessage("Palatank Mode : Off");
	else 
		Palatank_Frame:Show();
		DEFAULT_CHAT_FRAME:AddMessage("Palatank Mode : On");
	end
end

function Palatank_Info_Toggle()
	if ( Palatank_RF_Frame:IsShown() ) then
		Palatank_RF_Frame:Hide();
		Palatank_AD_Frame:Hide();
		Palatank_Info_Frame:Hide();
		Palatank_Aura_Frame:Hide();
		Palatank_PP_Frame:Hide();
		Palatank_Spell_Frame:Hide();
		Palatank_Options.ShowFrames = false;
		Palatank_Options.ShowRFFrames = false;
		Palatank_Options.ShowADFrames = false;
		Palatank_Options.ShowINFOFrames = false;
		Palatank_Options.ShowAURAFrames = false;
		Palatank_Options.ShowPPFrames = false;
		Palatank_Options.ShowSPELLFrames = false;
	else
		Palatank_RF_Frame:Show();
		Palatank_AD_Frame:Show();
		Palatank_Info_Frame:Show();
		Palatank_Aura_Frame:Show();
		Palatank_PP_Frame:Show();
		Palatank_Spell_Frame:Show();
		Palatank_Options.ShowFrames = true;
		Palatank_Options.ShowFrames = true;
		Palatank_Options.ShowRFFrames = true;
		Palatank_Options.ShowADFrames = true;
		Palatank_Options.ShowINFOFrames = true;
		Palatank_Options.ShowAURAFrames = true;
		Palatank_Options.ShowPPFrames = true;
		Palatank_Options.ShowSPELLFrames = true;
	end
end

function Palatank_RFShow_Toggle()
	if ( Palatank_RF_Frame:IsShown() ) then
		Palatank_RF_Frame:Show();
		Palatank_Options.ShowRFFrames = true;
	end
end

function Palatank_RFHide_Toggle()
	if ( Palatank_RF_Frame:IsShown() ) then
		Palatank_RF_Frame:Hide();
		Palatank_Options.ShowRFFrames = false;
	end
end

function Palatank_PPShow_Toggle()
	if ( Palatank_PP_Frame:IsShown() ) then
		Palatank_PP_Frame:Show();
		Palatank_Options.ShowPPFrames = true;
	end
end

function Palatank_PPHide_Toggle()
	if ( Palatank_PP_Frame:IsShown() ) then
		Palatank_PP_Frame:Hide();
		Palatank_Options.ShowPPFrames = false;
	end
end

function Palatank_ADShow_Toggle()
	if ( Palatank_AD_Frame:IsShown() ) then
		Palatank_AD_Frame:Show();
		Palatank_Options.ShowADFrames = true;
	end
end

function Palatank_ADHide_Toggle()
	if ( Palatank_AD_Frame:IsShown() ) then
		Palatank_AD_Frame:Hide();
		Palatank_Options.ShowADFrames = false;
	end
end

function Palatank_AuraShow_Toggle()
	if ( Palatank_Aura_Frame:IsShown() ) then
		Palatank_Aura_Frame:Show();
		Palatank_Options.ShowAURAFrames = true;
	end
end

function Palatank_AuraHide_Toggle()
	if ( Palatank_Aura_Frame:IsShown() ) then
		Palatank_Aura_Frame:Hide();
		Palatank_Options.ShowAURAFrames = false;
	end
end

function Palatank_InfoShow_Toggle()
	if ( Palatank_Info_Frame:IsShown() ) then
		Palatank_Info_Frame:Show();
		Palatank_Options.ShowINFOFrames = true;
	end
end

function Palatank_InfoHide_Toggle()
	if ( Palatank_Info_Frame:IsShown() ) then
		Palatank_Info_Frame:Hide();
		Palatank_Options.ShowINFOFrames = false;
	end
end

function Palatank_SpellShow_Toggle()
	if ( Palatank_Spell_Frame:IsShown() ) then
		Palatank_Spell_Frame:Show();
		Palatank_Options.ShowSPELLFrames = true;
	end
end

function Palatank_SpellHide_Toggle()
	if ( Palatank_Spell_Frame:IsShown() ) then
		Palatank_Spell_Frame:Hide();
		Palatank_Options.ShowSPELLFrames = false;
	end
end

local function round(num, idp)
	local mult = 10 ^ (idp or 0);
	return math.floor(num * mult + 0.5) / mult;
end

function PalatankUnitHasBuff(spellname, unit)
	for i=0, 31 do
		local buffName, rank, iconTexture, count, duration, timeLeft = UnitBuff(unit, i);
		if (spellname == buffName) then
			return timeLeft;
		end
	end

	return 0;
end

function PalatankUnitHasAura(spellname, unit)
	for i=0, 31 do
		local buffName = UnitBuff(unit, i);
		if (spellname == buffName) then
			return true;
		end
	end

	return false;
end

function Palatank_Toggle_Init()
if ( Palatank_Options.ShowFrames == false ) then
		Palatank_RF_Frame:Hide();
		Palatank_AD_Frame:Hide();
		Palatank_Info_Frame:Hide();
		Palatank_Aura_Frame:Hide();
		Palatank_PP_Frame:Hide();
		Palatank_Spell_Frame:Hide();
end
if ( Palatank_Options.ShowRFFrames == false ) then
		Palatank_RF_Frame:Hide();
end
if ( Palatank_Options.ShowADFrames == false ) then
		Palatank_AD_Frame:Hide();
end
if ( Palatank_Options.ShowINFOFrames == false ) then
		Palatank_Info_Frame:Hide();
end
if ( Palatank_Options.ShowAURAFrames == false ) then
		Palatank_Aura_Frame:Hide();
end
if ( Palatank_Options.ShowPPFrames == false ) then
		Palatank_PP_Frame:Hide();
end
if ( Palatank_Options.ShowSPELLFrames == false ) then
		Palatank_Spell_Frame:Hide();
end
end

function Palatank_Color_Init()	Palatank_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_AD_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_AD_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_Info_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_Info_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_RF_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_RF_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	
Palatank_Aura_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_Aura_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	
Palatank_PP_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_PP_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	
Palatank_Spell_Frame:SetBackdropColor(Palatank_Options.BGColor[1],Palatank_Options.BGColor[2],Palatank_Options.BGColor[3],Palatank_Options.BGColor[4]);
	Palatank_Spell_Frame:SetBackdropBorderColor(Palatank_Options.FrameColor[1],Palatank_Options.FrameColor[2],Palatank_Options.FrameColor[3],Palatank_Options.FrameColor[4]);
	Palatank_Frame_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);
	Palatank_AD_Frame_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);
	Palatank_Info_Frame_Name_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);
	Palatank_Info_Frame_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);
	Palatank_Spell_Frame_Text:SetTextColor(Palatank_Options.TextColor[1],Palatank_Options.TextColor[2],Palatank_Options.TextColor[3],Palatank_Options.TextColor[4]);
end

function Palatank_OnEvent(self, event,...)

if ( Palatank_Options.WarningRDStatus == false ) then
	Palatank_PP_FrameAWRDButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end
if ( Palatank_Options.WarningASStatus == false ) then
	Palatank_PP_FrameAWASButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end
if ( Palatank_Options.WarningRFStatus == false ) then
	Palatank_PP_FrameAWRFButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end
if ( Palatank_Options.WarningADStatus == false ) then
	Palatank_PP_FrameAWADButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end

if (event == "COMBAT_LOG_EVENT_UNFILTERED" )then
		local timestamp, eventType, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, prefix1, prefix2, prefix3, suffix1, suffix2, suffix3, suffix4, suffix5, suffix6, suffix7, suffix8 = ...;

if(eventType == "SPELL_MISSED" and sourceName == UnitName("player") and prefix1 == 31789 and suffix1 == "IMMUNE" and Palatank_Options.WarningRDStatus) then
	local playerName = UnitName("player");
	local playerTarget = UnitName("target");
	local playerLanguage = GetDefaultLanguage("player")
	local playerTargetTarget = UnitName("playertargettarget");
	SendChatMessage(playerName.." "..PALATANK_RDR_RESIST.." "..playerTarget..", "..PALATANK_RDR_INS, "SAY", playerLanguage);
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(playerName.." "..PALATANK_RDR_RESIST.." "..playerTarget..", "..PALATANK_RDR_INS, "RAID", playerLanguage);
		elseif (GetNumPartyMembers() > 0) then
			SendChatMessage(playerName.." "..PALATANK_RDR_RESIST.." "..playerTarget..", "..PALATANK_RDR_INS, "PARTY", playerLanguage);
		end
	
	SendChatMessage(playerName.." "..PALATANK_RDRW_RESIST..", "..PALATANK_RDR_INS, "WHISPER", playerLanguage, playerTargetTarget);
end

if(eventType == "SPELL_MISSED" and sourceName == UnitName("player") and prefix1 == 31789 and suffix1 == "RESIST" and Palatank_Options.WarningRDStatus) then
	local playerName = UnitName("player");
	local playerTarget = UnitName("target");
	local playerLanguage = GetDefaultLanguage("player")
	local playerTargetTarget = UnitName("playertargettarget");
	SendChatMessage(playerName.." "..PALATANK_RDR_RESIST.." "..playerTarget, "SAY", playerLanguage);
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(playerName.." "..PALATANK_RDR_RESIST.." "..playerTarget, "RAID", playerLanguage);
		elseif (GetNumPartyMembers() > 0) then
			SendChatMessage(playerName.." "..PALATANK_RDR_RESIST.." "..playerTarget, "PARTY", playerLanguage);
		end
	
	SendChatMessage(playerName.." "..PALATANK_RDRW_RESIST, "WHISPER", playerLanguage, playerTargetTarget);
end

if(eventType == "SPELL_MISSED" and sourceName == UnitName("player") and prefix1 == 32700 and Palatank_Options.WarningASStatus and suffix1 == "IMMUNE") then
	local playerTarget = UnitName("target");
	local playerLanguage = GetDefaultLanguage("player")
	SendChatMessage(PALATANK_AS.." "..PALATANK_ASR_RESIST.." "..playerTarget..", "..PALATANK_ASR_INS, "SAY", playerLanguage);
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(PALATANK_AS.." "..PALATANK_ASR_RESIST.." "..playerTarget..", "..PALATANK_ASR_INS, "RAID", playerLanguage);
		elseif (GetNumPartyMembers() > 0) then
			SendChatMessage(PALATANK_AS.." "..PALATANK_ASR_RESIST.." "..playerTarget..", "..PALATANK_ASR_INS, "PARTY", playerLanguage);
		end
end

if(eventType == "SPELL_MISSED" and sourceName == UnitName("player") and prefix1 == 32700 and Palatank_Options.WarningASStatus and suffix1 == "RESIST") then
	local playerTarget = UnitName("target");
	local playerLanguage = GetDefaultLanguage("player")
	SendChatMessage(PALATANK_AS.." "..PALATANK_ASR_RESIST.." "..playerTarget, "SAY", playerLanguage);
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(PALATANK_AS.." "..PALATANK_ASR_RESIST.." "..playerTarget, "RAID", playerLanguage);
		elseif (GetNumPartyMembers() > 0) then
			SendChatMessage(PALATANK_AS.." "..PALATANK_ASR_RESIST.." "..playerTarget, "PARTY", playerLanguage);
		end
end

if (PalatankUnitHasAura(PALATANK_RF, "player")) then
	Palatank_RF_FrameRFuryButtonMainTexture:SetVertexColor(1, 1, 1);
else
	Palatank_RF_FrameRFuryButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end

if( eventType == "SPELL_AURA_REMOVED" and destName == UnitName("player") and prefix1 == 25780 and Palatank_Options.WarningRFStatus) then
	Palatank_RF_Warn_Frame_Texture:SetVertexColor(1, 1, 0, 0.8);
	UIFrameFlash(Palatank_RF_Warn_Frame, 1, 1, 8, false, 1, 0.5);
	if (Palatank_Options.WarningRFSound) then
	PlaySoundFile("Interface\\AddOns\\Palatank\\Sounds\\RF.mp3");
	end
end
end

if event == "VARIABLES_LOADED" then
   if (Palatank == nil) then
	Palatank = PalatankConfig;
	end
	
	local class = select(2,UnitClass("player"))
	if (class ~= "PALADIN") then
		DisableAddOn("Palatank");
		Palatank_Frame:Hide();
	return
	end	
			
	Palatank_Menu_Init();
	Palatank_Color_Init();
	Palatank_Toggle_Init();
end


if (PalatankUnitHasAura(PALATANK_DEVOTION, "player")) then
	Palatank_Aura_FrameADevotionButtonMainTexture:SetVertexColor(1, 1, 1);
else
	Palatank_Aura_FrameADevotionButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end

if (PalatankUnitHasAura(PALATANK_VINDICTE, "player")) then
	Palatank_Aura_FrameAVindicteButtonMainTexture:SetVertexColor(1, 1, 1);
else
	Palatank_Aura_FrameAVindicteButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end

if (PalatankUnitHasAura(PALATANK_CONCENTRATION, "player")) then
	Palatank_Aura_FrameAConcentrationButtonMainTexture:SetVertexColor(1, 1, 1);
else
	Palatank_Aura_FrameAConcentrationButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end

if (PalatankUnitHasAura(PALATANK_ARO, "player")) then
	Palatank_Aura_FrameAAroButtonMainTexture:SetVertexColor(1, 1, 1);
else
	Palatank_Aura_FrameAAroButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end

if (PalatankUnitHasAura(PALATANK_ARG, "player")) then
	Palatank_Aura_FrameAArgButtonMainTexture:SetVertexColor(1, 1, 1);
else
	Palatank_Aura_FrameAArgButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end

if (PalatankUnitHasAura(PALATANK_ARF, "player")) then
	Palatank_Aura_FrameAArfButtonMainTexture:SetVertexColor(1, 1, 1);
else
	Palatank_Aura_FrameAArfButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end

if (PalatankUnitHasAura(PALATANK_CROISE, "player")) then
	Palatank_Aura_FrameACroiseButtonMainTexture:SetVertexColor(1, 1, 1);
else
	Palatank_Aura_FrameACroiseButtonMainTexture:SetVertexColor(0.2, 0.2, 0.2);
end

if (event == "UNIT_INVENTORY_CHANGED" or event == "UNIT_AURA" or event == "ADDON_LOADED") then
	local miss = round(GetDodgeBlockParryChanceFromDefense() + 5, 2);
	local dodge = round(GetDodgeChance(), 2);
	local parry = round(GetParryChance(), 2);
	local block = round(GetBlockChance(), 2);
	local blockValue = round(GetShieldBlock(), 2);
	local total = round((dodge + parry + block), 2);
	local updown = round((total + miss - 102.4), 2);
	local hplimit = round(UnitHealthMax("player") * 0.35, 0);
	
	local baseDefense, armorDefense = UnitDefense("player");
	local defense = armorDefense + baseDefense;
	
	local hdamage = GetSpellBonusDamage(2);
	local hcrit = round(GetSpellCritChance(2), 2);
	
	local palatank_info = "";

	palatank_info = palatank_info..miss.."%\n";
	palatank_info = palatank_info..dodge.."%\n";
	palatank_info = palatank_info..parry.."%\n";
	palatank_info = palatank_info..block.."%\n";
	palatank_info = palatank_info..total.."%\n";
	
	local palatank_spell = "";
	
	palatank_spell = palatank_spell..PALATANK_SD.." : "..hdamage.." ";
	palatank_spell = palatank_spell..PALATANK_SC.." : "..hcrit.."% ";
	
	local updownColor = "";

	updownColor = "|cffff0000"..updown.."%|r\n";

	if defense >= 490 then
		updownColor = "|cffff8000"..updown.."%|r\n";
	end
	
	if total + miss >= 102.4 then
		updownColor = "|cff00ff00"..updown.."%|r\n";
	end
	
	palatank_info = palatank_info..updownColor;
	
	palatank_info = palatank_info..blockValue.."\n";
	
	palatank_info = palatank_info..hplimit.."\n";
						
	Palatank_Info_Frame_Text:SetText(palatank_info);
	Palatank_Spell_Frame_Text:SetText(palatank_spell);
	
	function Palatank_Report()
	SendChatMessage(PALATANK_REPORT_HIT.." "..miss.."%", "EMOTE");
	SendChatMessage(PALATANK_REPORT_DODGE.." "..dodge.."%", "EMOTE");
	SendChatMessage(PALATANK_REPORT_PARRY.." "..parry.."%", "EMOTE");
	SendChatMessage(PALATANK_REPORT_BLOCK.." "..block.."%", "EMOTE");
	SendChatMessage(PALATANK_REPORT_BLOCKV.." "..blockValue.." ", "EMOTE");
	SendChatMessage(PALATANK_REPORT_TOTAL.." "..total.."%", "EMOTE");
	SendChatMessage(PALATANK_REPORT_LIM.." "..hplimit.." "..PALATANK_REPORT_PV, "EMOTE");
	SendChatMessage(PALATANK_REPORT_HDAMAGE.." "..hdamage, "EMOTE");
	SendChatMessage(PALATANK_REPORT_HCRIT.." "..hcrit.."%", "EMOTE");
	end
	
end
if (event == "PLAYER_REGEN_DISABLED" or event == "PLAYER_REGEN_ENABLED" or event == "COMBAT_TEXT_UPDATE" or event == "ADDON_LOADED") then
	if (event == "PLAYER_REGEN_DISABLED" or event == "ADDON_LOADED") then
		if (DamageTaken == nill) then
		DamageTaken = 0;
		DamageADMitigated = 0;
		DeathsAverted = 0;
		end
	elseif (event == "PLAYER_REGEN_ENABLED") then
		if (Palatank_Options.ADReset) then
			DamageTaken = 0;
			DamageADMitigated = 0;
			DeathsAverted = 0;
		end
		if (DamageTaken ~= 0) then
			percentageReduced = round(DamageADMitigated*100/DamageTaken);
		else
			percentageReduced = 0;
		end
		AdString = PALATANK_SUM;
		if (Palatank_Options.WarningADStatus and Palatank_Options.ADCheck) then
		DEFAULT_CHAT_FRAME:AddMessage(format(AdString, DamageADMitigated, DamageTaken, (percentageReduced), DeathsAverted));
		end
	elseif (event == "COMBAT_TEXT_UPDATE") then
		-- we just got hurt or healed
		if (arg1 == "DAMAGE" or arg1 == "SPELL_DAMAGE" or arg1 == "DAMAGE_CRIT") then
            if (UnitHealth("player") / UnitHealthMax("player") <= 0.35) then
                -- we're in AD range
                OriginalDamage = 100 / 70 * arg2;
                DamageTaken = DamageTaken + OriginalDamage;
                DamageADMitigated = DamageADMitigated + (OriginalDamage - arg2);
                if ((UnitHealth("player") - OriginalDamage) <= 0) then
                    DeathsAverted = DeathsAverted + 1;
                end
            else
                DamageTaken = DamageTaken + arg2;
            end
        elseif (arg1 == "BLOCK" or arg1 == "ABSORB" or arg1 == "SPELL_ABSORBED") then
            if (arg3 ~= nil) then
                if (UnitHealth("player") / UnitHealthMax("player") <= 0.35) then
                    -- we're in AD range
                    OriginalDamage = 100 / 70 * arg2;
                    DamageTaken = DamageTaken + OriginalDamage;
                    DamageADMitigated = DamageADMitigated + (OriginalDamage - arg2);
                    if ((UnitHealth("player") - OriginalDamage) <= 0) then
                        DeathsAverted = DeathsAverted + 1;
                    end
                else
                    DamageTaken = DamageTaken + arg2;
                end
            end
		end
	end
	
	if (DamageTaken ~= 0) then
		percentageReduced = round((DamageADMitigated*100/DamageTaken), 2);
	else
		percentageReduced = 0;
	end
	AD_Data = "";
	AD_Data = AD_Data..PALATANK_DATA_DM..": "..round(DamageADMitigated, 0).."\n";
	AD_Data = AD_Data..PALATANK_DATA_DT..": "..round(DamageTaken, 0).."\n";
	AD_Data = AD_Data.."%: "..percentageReduced.."\n";
	AD_Data = AD_Data..PALATANK_DATA_DA..": "..DeathsAverted.."\n";
	Palatank_AD_Frame_Text:SetText(AD_Data);
	
	local namingStructure = "";
	namingStructure = namingStructure..PALATANK_MISS..": \n";
	namingStructure = namingStructure..PALATANK_DODGE..": \n";
	namingStructure = namingStructure..PALATANK_PARRY..": \n";
	namingStructure = namingStructure..PALATANK_BLOCK..": \n";
	namingStructure = namingStructure..PALATANK_TOTAL..": \n";
	namingStructure = namingStructure..PALATANK_CRUSHING..": \n";
	namingStructure = namingStructure..PALATANK_BVALUE..": \n";
	namingStructure = namingStructure..PALATANK_DATA_HP..": \n";
	Palatank_Info_Frame_Name_Text:SetText(namingStructure);
end	
end