OZ_Windows	= {};

OZ_Config	= {
				["nWindows"] = 1,
				["minimapAngle"] = 26,
				["minimapDist"]  = 80,
				["minimapShow"]  = 1,
			};
OZ_Bars		= {};
OZ_Input	= {};

local function gg(text)
	local ret = getglobal(text)
	if(not ret) then
		DEFAULT_CHAT_FRAME:AddMessage("|c00FF8800".."OzRaid: Failed to find: "..text);
	end
	return ret
end
local function print(text)
	DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF"..text);
end

OZ_MAX_BARS = 80
OZ_MAX_BUFFS = 6
OZ_NWINDOWS	= 1
OZ_CURRENT_VERSION = 1.68

function OZ_AddWindow()
	local c
	OZ_NWINDOWS = OZ_NWINDOWS + 1
	OZ_SetupConfig(OZ_NWINDOWS)
	OZ_InitWindow(OZ_NWINDOWS)
	OZ_Config.nWindows = OZ_NWINDOWS;
end

function OZ_RemoveWindow(n)
	local h, frame, c
	h = OZ_Windows[OZ_NWINDOWS].frame:GetHeight()
	OZ_Windows[OZ_NWINDOWS].frame:Hide()

	if n<OZ_NWINDOWS then
		-- Copy the last window into the place of the one we are removing...
		OZ_Config[n] = OZ_Config[OZ_NWINDOWS]
		OZ_InitWindow(n)
	end

	-- Now delete the config for the last window
	OZ_Config[OZ_NWINDOWS] = nil
	OZ_NWINDOWS = OZ_NWINDOWS - 1
	OZ_Config.nWindows = OZ_NWINDOWS;
end

function OZ_GetWindowTop(frame,growup)
	local anchor,_,rel,ox,oy = frame:GetPoint(1)
	local w = frame:GetWidth()
	local h = frame:GetHeight()
	local hw = w * 0.5
	local hh = h * 0.5
	if anchor=="TOP" then
		ox = ox
		oy = oy
	elseif anchor=="TOPLEFT" then
		ox = ox+hw
		oy = oy
	elseif anchor=="TOPRIGHT" then
		ox = ox - hw
		oy = oy
	elseif anchor=="LEFT" then
		ox = ox + hw
		oy = oy + hh
	elseif anchor=="CENTER" then
		ox = ox
		oy = oy + hh
	elseif anchor=="RIGHT" then
		ox = ox - hw
		oy = oy + hh
	elseif anchor=="BOTTOMRIGHT" then
		ox = ox - hw
		oy = oy + h
	elseif anchor=="BOTTOMLEFT" then
		ox = ox + hw
		oy = oy + h
	elseif anchor=="BOTTOM" then
		ox = ox
		oy = oy + h
	else
		print("ERROR: Anchor point is not recognised: "..anchor);
	end
	if(growup) then
		return "BOTTOM",nil,rel,ox,oy - h
	end
	return "TOP",nil,rel,ox,oy
end

function OZ_DragStart()
	if (not this.moving and not OZ_Config[ this:GetID() ].locked) then
		this:StartMoving();
		this.moving = true;
	end
end

function OZ_DragStop()
	local i,_
	if (this.moving) then
		this:StopMovingOrSizing();
		this.moving = false;
	end
	-- Now record new position in config
	i = this:GetID()
	local config = OZ_Config[i]
	config.Anchor,_,config.Relative,config.ax,config.ay = OZ_GetWindowTop(this,config.growup)
end

function OZ_SetupWindowPointers(n)
	local name,frame,c;
	name = "OzRaid_Frame"..n
	frame = getglobal(name)
	c = OZ_Config[n]
	if( not frame ) then
		-- Dynamically create a new window
		frame = CreateFrame( "Frame", name, nil, "OZ_WindowTemplate" )
		frame.tNext = 0;
		frame:ClearAllPoints()
		frame:SetPoint(c.Anchor,nil,c.Relative,c.ax,c.ay)
		frame:SetID(n)

		OZ_Windows[n] = {
			-- Shortcuts to various UI elements
			["frame"]		= frame,
			["titleFrame"]	= gg(name.."Title"),
			["name"]		= gg(name.."TitleName"),
			["nameText"]	= gg(name.."TitleNameText"),
			["background"]	= gg(name.."TitleBackground"),
			["marker"]		= gg(name.."TableMarker"),

			["close"]		= gg(name.."TitleClose"),
			["options"]		= gg(name.."TitleOptions"),

			["table"]		= gg(name.."Table"),
			["n"]	= n,
		};
		if not OZ_Windows[n].bar then
			OZ_Windows[n].bar = {}
		end
	end
	OZ_Windows[n].config = c;
	if not OZ_Bars[n] then
		OZ_Bars[n]	= {
			["nBars"] = 0,
			["bar"] = {},
		};
	end
end

function OzDropDown_OnLoad()
	UIDropDownMenu_Initialize(this, OzDropDown_Initialize, "MENU");
end

local Oz_MenuUnit = nil
function OZ_showmenu()
--print("Menu up, this frame is: "..this:GetName())
	Oz_MenuUnit = this.unit;
	ToggleDropDownMenu(1, nil, OzDropDown, "cursor", 0, 0);
end

function OzDropDown_Initialize()
	local menu;
	local name;
	local id = nil;
	local unit = "mouseover"
	if(Oz_MenuUnit) then
		unit = Oz_MenuUnit
	end

	if ( UnitIsUnit(unit, "player") ) then
		menu = "SELF";
		unit = "player"
	elseif ( UnitIsUnit(unit, "pet") ) then
		menu = "PET";
		unit = "pet"
	elseif ( UnitIsPlayer(unit) ) then
		id = UnitInRaid(unit);
		if ( id ) then
			menu = "RAID_PLAYER";
		elseif ( UnitInParty(unit) ) then
			menu = "PARTY";
		else
			menu = "PLAYER";
			unit = "player"
		end
	else
		menu = "RAID_TARGET_ICON";
		name = RAID_TARGET_ICON;
	end
	if ( menu ) then
--print("Menu: "..menu..", Unit = "..unit)
		UnitPopup_ShowMenu(OzDropDown, menu, unit, UnitName(unit), id);
	end

end

function OZ_GetBar( window, x )
	if not window.bar[x] then
		local n = window.n
		local name = "OzRaid_Frame"..n.."TableRow"..x
		local bar

		if not ClickCastFrames then ClickCastFrames = {} end
		if not window.moveable then
			bar = CreateFrame( "Frame", name, window.table, "OZ_RowTemplate" )
--print("Added clickable bar")
		else
			bar = CreateFrame( "Frame", name, window.table, "OZ_RowTemplateINFO" )
--print("Added moveable bar")
		end
		
		local data = {
			["frame"]		= bar,
			["header"]		= gg(name.."Header"),
			["headerText"]	= gg(name.."HeaderText"),
			["barFrame"]	= gg(name.."BarFrame"),
			["bar"]			= gg(name.."BarFrameBar"),
			["glow"]		= gg(name.."BarFrameBarGlow"),
			["icon"]		= gg(name.."BarFrameIcon"),
			["iconTex"]		= gg(name.."BarFrameIconIcon"),
			["name"]		= gg(name.."BarFrameName"),
			["nameText"]	= gg(name.."BarFrameNameText"),
			["value"]		= gg(name.."BarFrameValue"),
			["valueText"]	= gg(name.."BarFrameValueText"),
			["bValue"]		= gg(name.."BarFrameBigValue"),
			["bValueN"]		= gg(name.."BarFrameBigValueHundreds"),
			["bValueK"]		= gg(name.."BarFrameBigValueThousands"),
			["buff"]		= { gg(name.."BarFrameBuff1"),
								gg(name.."BarFrameBuff2"),
								gg(name.."BarFrameBuff3"),
								gg(name.."BarFrameBuff4"),
								gg(name.."BarFrameBuff5"),
								gg(name.."BarFrameBuff6") },
			["buffTex"]		= { gg(name.."BarFrameBuff1Icon"),
								gg(name.."BarFrameBuff2Icon"),
								gg(name.."BarFrameBuff3Icon"),
								gg(name.."BarFrameBuff4Icon"),
								gg(name.."BarFrameBuff5Icon"),
								gg(name.."BarFrameBuff6Icon") },
			["buffCool"]	= { gg(name.."BarFrameBuff1Cooldown"),
								gg(name.."BarFrameBuff2Cooldown"),
								gg(name.."BarFrameBuff3Cooldown"),
								gg(name.."BarFrameBuff4Cooldown"),
								gg(name.."BarFrameBuff5Cooldown"),
								gg(name.."BarFrameBuff6Cooldown") },
			["buffVal"]		= {},
		};
		window.bar[x] = data

		bar:SetID(x)
		if not window.moveable then
			SecureUnitButton_OnLoad( data.barFrame, "player", OZ_showmenu )
			ClickCastFrames[gg(name.."BarFrame")] = true
		end


		local config = OZ_Config[n]

		-- reset all the text sizes
		bw = config.textSize

		data.headerText:SetFont(STANDARD_TEXT_FONT,bw)
		local textEffect;
		if config.outlineNames then
			textEffect = "OUTLINE"
		end
		data.nameText:SetFont(STANDARD_TEXT_FONT,config.nameSize,textEffect)
		data.valueText:SetFont(STANDARD_TEXT_FONT,config.numSize,textEffect)
		data.bValueN:SetFont(STANDARD_TEXT_FONT,config.numSize*0.5,textEffect)
		data.bValueK:SetFont(STANDARD_TEXT_FONT,config.numSize,textEffect)
		data.bValN = nil
		data.bValK = nil

		OZ_FormatRow( n, x )

		if x == 1 then
			bar:SetPoint("TOP", window.table, "TOP")
		else
			bar:SetPoint("TOP", window.bar[x-1].frame, "BOTTOM")
		end
	end
	return window.bar[x]
end

function OZ_SetupConfig(n)
	OZ_Config[n] = {
		["width"] = 120,

		["Anchor"]		= "TOP",
		["Relative"]	= "LEFT",
		["ax"]			= 350,
		["ay"]			= 0,
					
		["text"]		= "OzRaid "..n,
		["topCol"]		= {["r"]=0.0, ["g"]=1.0, ["b"]=1.0, ["a"]=0.5},
		["bottomCol"]	= {["r"]=0.0, ["g"]=0.0, ["b"]=0.6, ["a"]=0.5},
		["titleHeight"]		= 20,
		["barHeight"]		= 16,
		["maxBars"]			= 40,
		["minBars"]			= 2,
		["buttonSize"]		= 16,

		["active"]			= 1,
		["textSize"]		= 10,
		["refresh"]			= 1,

		-- Functions to use
		input			= 1,
		filter			= {
								injuredVal			= 0.8,
								class = { DRUID		= 1,
										  HUNTER	= 1,
										  MAGE		= 1,
										  PALADIN	= 1,
										  PRIEST	= 1,
										  ROGUE		= 1,
										  SHAMAN	= 1,
										  WARLOCK	= 1,
										  WARRIOR	= 1,
										  PET		= 1,

										  TARGET	= 1, },
								group = { 1,1,1,1,1,1,1,1,1 },
								status=	{ healthy	 = 1,
										  injured	 = 1,
										  curable	 = 1,
										  notcurable = 1,
										  buffed	 = 1,
										  notbuffed	 = 1,
										  close = 1,
										  inrange = 1,
										  outofrange = 1,
										  dead = 1,
										  offline = 1,
										  online = 1,
										},
							  },
		sort1			= 3,
		sort2			= 0,
		sort3			= 0,

		heading			= {3,0,0},

		colour			= 2,
		icon			= 1,

		namePos			= 4,
		buffPos			= 2,
		buffSize		= 1,

		buffsPlayer		= {},
		buffsMob		= {},

		active			= 1,

		classNames		= 1,	-- Colour names by the class
		outlineNames	= 1,

		valuePos		= 4,	-- nil=off, 1=left, 2=bar middle, 3=bar right, 4=right
		valueType		= 2,	-- 1=number, 2=percent, 3=deficit

		nameOnStatus	= 1,	-- Change name colours given status
		barDebuffCol	= 1,	-- Colour bar if curable
		showDebuffIcon	= 1,	-- Icon if curable
        
        fadeAlpha       = 0.4,

        barGap          = 0,
		nameSize		= 12,
		numSize			= 14,
	};

	-- Init buff arays with the class defaults
	local class,fileName = UnitClass("player")
	local i = 1
	for key,value in ipairs(OZ_BUFF_DEFAULT[fileName].Player) do
		local bName = "Interface\\Icons\\"..value[3]
		OZ_Config[n].buffsPlayer[key] = { value[1], value[2], bName }
	end

	for key,value in ipairs(OZ_BUFF_DEFAULT[fileName].Mob) do
		local bName = "Interface\\Icons\\"..value[3]
		OZ_Config[n].buffsMob[key] = { value[1], value[2], bName }
	end

end


function OZ_SetupSortBuffer()
	OZ_Input	= {
		["nBars"] = 0,
		["bar"] = {},
	};

	for x = 1 , OZ_MAX_BARS do
		OZ_Input.bar[x]= {
			-- Position of data in the raid roster
			["roster"]		= 0,
			["target"]		= 0,

			-- Bar values (min,max,fraction)
			["max"]			= 1000,
			["current"]		= 500,
			["value"]		= 0.5,

			-- Buffs
			["buffs"]		= {},
			["buffNames"]	= {},
			["buffTimes"]	= {},
			["buffDur"]		= {},
			["debuffs"]		= nil,
		};
	end
end

function OZ_ConfigTitleBar(n)
	local window = OZ_GetWindowArray(n)
    local config = OZ_Config[n]
    
	if(config.hideTitle)then
		window.titleFrame:SetHeight(0.1)
		window.titleFrame:Hide()
	else
		window.titleFrame:SetHeight(config.titleHeight)
		window.titleFrame:Show()

		window.background:SetHeight(42)
		window.background:SetGradientAlpha("VERTICAL",
				config.bottomCol.r,
				config.bottomCol.g,
				config.bottomCol.b,
				config.bottomCol.a,
				config.topCol.r,
				config.topCol.g,
				config.topCol.b,
				config.topCol.a);

		local tw, th, bw;
		if(config.hideButtons)then
			tw = config.width - 6
			window.nameText:SetJustifyH("CENTER")
		else
			tw = config.width - (config.buttonSize*2) - 6
			window.nameText:SetJustifyH("LEFT")
		end
		th = config.titleHeight
		bw = config.buttonSize

		window.name:SetWidth(tw)
		window.name:SetHeight(th)

		window.nameText:SetText(config.text)
		window.nameText:SetWidth(tw)
		window.nameText:SetHeight(th)
		window.nameText:Show()
		
		window.close:SetWidth( bw )
		window.options:SetWidth( bw )
		window.close:SetHeight( bw)
		window.options:SetHeight( bw )

		if(config.hideButtons)then
			window.close:Hide()
			window.options:Hide()
		else
			window.close:Show()
			window.options:Show()
		end

	end

	if(config.hideBG)then
		window.frame:SetBackdrop(nil)
	else
		window.frame:SetBackdrop({	bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
                                            edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                                            tile = true, tileSize = 16, edgeSize = 16, 
                                            insets = { left = 4, right = 4, top = 4, bottom = 4 }});
		window.frame:SetBackdropColor(0.09, 0.09, 0.19)
		window.frame:SetBackdropBorderColor(1, 1, 1)
	end
end

function OZ_InitDefaultConfig()
	OZ_Config = {}
	OZ_SetupConfig(1)
--	for i=1,OZ_NWINDOWS do
--		OZ_SetupConfig(i)
--	end
--
--	-- Temporarily disable the other windows till defaults are woring
--	OZ_Config[2].active = nil
---	OZ_Config[3].active = nil
--	OZ_Config[4].active = nil
--	OZ_Config[5].active = nil
--	OZ_Config[6].active = nil
--	OZ_Config[7].active = nil
--	OZ_Config[8].active = nil

	OZ_Config.minimapAngle = 26
	OZ_Config.minimapDist  = 80
	OZ_Config.minimapShow  = 1

	OZ_Config.nWindows = 1
	OZ_Config.version = OZ_CURRENT_VERSION
end

function OzRaid_OnLoad()
--local alloc1 = gcinfo()
	local i
	this:RegisterForDrag("LeftButton");
	OZ_SetupEvents()

	OZ_InitDefaultConfig()
	OZ_SetupRaidRoster()
	OZ_SetupSortBuffer()
	DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."OzRaid Loaded!");
--if(alloc1)then
--	local alloc2 = gcinfo()
--	DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."Load 1 = "..alloc2 - alloc1.."kB");
--end
end

function OzRaidLoadSavedVariables()
--local alloc1 = gcinfo()
	OZ_SetupAfterLoad()
--if(alloc1)then
--	local alloc2 = gcinfo()
--	DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."Load 2 = "..alloc2 - alloc1.."kB");
--end
end

function OZ_InitWindow(n)
	local i,window

	OZ_SetupWindowPointers(n)
	window = OZ_Windows[n]

--	window.frame:RegisterForDrag("LeftButton") 
	window.frame:SetMovable(true)
	window.frame:SetUserPlaced(true)

	window.frame:SetWidth(OZ_Config[n].width)
	window.frame:SetHeight(60)
	window.frame.lastUpdate = 0

	window.marker:SetWidth( 60 )
	window.marker:SetHeight( 60 )

	OZ_ConfigTitleBar(n)

	OZ_SetFromConfig(n)
	-- reset all the text sizes
	OZ_CheckVisibility(n)
end

function OZ_SetFromConfig(n)
	local config = OZ_Config[n]
	-- reset all the text sizes
	bw = config.textSize
	local window = OZ_GetWindowArray(n)

	-- New - check if we are a moveable one or not...
	local status = config.filter.status
	local oldState = window.moveable
	if  (config.sort1==0 or config.sort1==3 or config.sort1==4) and
		(config.sort2==0 or config.sort2==3 or config.sort2==4) and
		status.healthy == 1 and
		status.injured == 1 and
		status.curable == 1 and
		status.notcurable == 1 and
		status.buffed == 1 and
		status.notbuffed == 1 and
		status.outofrange == 1 and
		status.dead == 1 and
		status.offline == 1 and
		status.online == 1 then
		-- Ok, this window has NO dynamic changes
		window.moveable = nil
--print("NEW: "..config.text.." is CLICKABLE")
	else
		-- Ok, we are a dynamically changing frame
		window.moveable = 1
--print("NEW: "..config.text.." is DYNAMIC (info only)")
	end
	-- We MUST check to see if we used to be protected
	if window.bar[1] and window.moveable ~= oldState then
		-- Ok, we have been initialised before, and so these bars are WRONG
		print("WARNING: "..config.text.." window needs to change security state. Please RELOAD UI!");
	end

	window.nameText:SetFont(STANDARD_TEXT_FONT,bw)
	local textEffect;
	if config.outlineNames then
		textEffect = "OUTLINE"
	end
	for i=1,config.maxBars do
		local bar = window.bar[i]
		if bar then
			bar.headerText:SetFont(STANDARD_TEXT_FONT,bw)
			bar.nameText:SetFont(STANDARD_TEXT_FONT,config.nameSize,textEffect)
			bar.valueText:SetFont(STANDARD_TEXT_FONT,config.numSize,textEffect)
			bar.bValueN:SetFont(STANDARD_TEXT_FONT,config.numSize*0.5,textEffect)
			bar.bValueK:SetFont(STANDARD_TEXT_FONT,config.numSize,textEffect)
			OZ_FormatRow(n,i)
		else
			break
		end
	end

	if not window.frame.moving then
		window.frame:ClearAllPoints()
		window.frame:SetPoint(config.Anchor,nil,config.Relative,config.ax,config.ay)
	end

	OZ_ConfigTitleBar(n)
	OZ_SetMinimapPos()
	OZ_SetBars(n)
	OZ_CheckVisibility(n)
end


local healSpells = {
	DRUID = "Healing Touch",
	SHAMAN = "Healing Wave",
	PRIEST = "Lesser Heal",
	PALADIN = "Holy Light",
	MAGE = "Remove Lesser Curse"
};

OzPlayerHealSpell = nil


function OZ_SetupAfterLoad()

	local i,key,val
	-- Read the current players class
	key,val = UnitClass("player")
	if val then
		OzPlayerHealSpell = healSpells[val]
	end

--local test = SpellHasRange("Immolate")
--if(test)
--	print("Immolate range = "..test);
--else
--	print("Immolate range = "..nil);
--end


	local version = 0
	if(	OZ_Config.version ) then
		version = OZ_Config.version
	end
	if(OZ_Config.nWindows) then
		OZ_NWINDOWS = OZ_Config.nWindows
	else
		OZ_NWINDOWS = 8
	end

	-- Update config with any new variables that have been added
	-- OLD version of the setting...
	if(version < 1.0)then
		-- Pre-relase version, reset all settings
		print("New user - setting up default configuration")
		for i=1,6 do
			OZ_SetupConfig(i)
		end
	end
	if(version < 1.1)then
		for i=1,6 do
			OZ_Config[i].valuePos		= nil
			OZ_Config[i].valueType		= 2
			OZ_Config[i].nameOnStatus	= 1
			OZ_Config[i].barDebuffCol	= 1
			OZ_Config[i].showDebuffIcon	= nil
		end
	end
	if(version < 1.2)then
		OZ_Config.minimapAngle = 26
		OZ_Config.minimapDist  = 80
		OZ_Config.minimapShow  = 1

		OZ_SetupConfig(7)
		OZ_Config[7].active = nil
		OZ_SetupConfig(8)
		OZ_Config[8].active = nil
	end

	if(version < 1.4)then
		-- "Mark of the Wild/Gift of the Wild" ->"Mark of the Wild"
		for i=1,8 do
			if(OZ_Config[i])then
				for key,val in ipairs(OZ_Config[i].buffsPlayer) do
					if( val[2] == "Mark of the Wild/Gift of the Wild" )then
						val[2] = "Mark of the Wild"
					end
					if( val[2] == "Prayer Of Fortitude" )then
						val[2] = "Prayer of Fortitude"
					end
				end
				-- Fill in icon base state
				if(not OZ_Config[i].showDebuffIcon)then
					OZ_Config[i].hideIcon = 1
				end
			end
		end
		OZ_Config[1].hideIcon = nil
	end

	if version<1.5 then
		-- Build a new style buff array

		local newArray
		for i=1,8 do
			if(OZ_Config[i])then
				newArray = {}
				for key,val in ipairs(OZ_Config[i].buffsPlayer) do
					newArray[ val[3] ] = { val[1], val[2] }
				end
				OZ_Config[i].buffsPlayer = newArray

				newArray = {}
				for key,val in ipairs(OZ_Config[i].buffsMob) do
					newArray[ val[3] ] = { val[1], val[2] }
				end
				OZ_Config[i].buffsMob = newArray
			end
		end		
	end

	-- After releasing 1.59, I realised that people who were using the continued version
	-- would not have got these updates to their configs as the version no. was 1.60
	-- So.. Im jumping that number to go to 1.61, and so only people coming from that branch
	-- will have the number 1.60, making it easy to fix - yay!
	if version<1.58 or version==1.60 then
		OZ_Config.nWindows = 8
		-- Add new positioning data
		for i=1,8 do
			if not OZ_Config[i].Anchor then
				OZ_Config[i].Anchor		= "TOPLEFT"
				OZ_Config[i].Relative	= "LEFT"
				OZ_Config[i].ax			= 100 + i*80
				OZ_Config[i].ay			= 0
			end
		end
		print("OzRaid WARNING! Due to new positioning code ALL OzRaid window positions are reset!");
	end
	if version<1.59 or version==1.60 then
		for i=1,OZ_Config.nWindows do
			local g = OZ_Config[i].filter.group
			if( g[1] and g[2] and g[3] and g[4] and g[5] and g[6] and g[7] and g[8] ) then
				OZ_Config[i].filter.group[9] = 1
			end
		end
	end
	if version < 1.61 then
		for i=1,OZ_Config.nWindows do
			OZ_Config[i].nameStyle = 1
			OZ_Config[i].fadeAlpha = 0.4
		end
	end

    -- Whatever version you have, you kinda need this value to be there
--	if version < 1.62 then
		for i=1,OZ_Config.nWindows do
			if not OZ_Config[i].fadeAlpha then
				OZ_Config[i].fadeAlpha = 0.4
			end
		end
--	end
	if version < 1.63 then
        -- Last version had the wrong texture for this, so update it (Blizz spelling mistakes FTW!)
		for i=1,OZ_Config.nWindows do
            local k,v
            for k,v in pairs(OZ_Config[i].buffsPlayer) do
                if k=="Interface\\Icons\\Spell_Holy_PrayerOfMending" then
                    OZ_Config[i].buffsPlayer["Interface\\Icons\\Spell_Holy_PrayerOfMendingtga"] = v
                    OZ_Config[i].buffsPlayer[k] = nil
                elseif type(k)=="number" then
                    -- Clean up old buff code
                    OZ_Config[i].buffsPlayer[k] = nil                
                end
            end
		end    
    end
	if version < 1.64 then
		if OZ_Config[1].hideparty then
			OZ_Config.pFramesRaid = 2
			OZ_Config.pFramesParty = 2
		else
			OZ_Config.pFramesRaid = 1
			OZ_Config.pFramesParty = 1
		end
	end
	if version < 1.67 then
		for i=1,OZ_Config.nWindows do
			local c = OZ_Config[i]
			if not c.nameSize then
				c.nameSize = c.textSize
			end
			if not c.numSize then
				c.numSize = c.textSize
			end
			if not c.barGap then
				c.barGap = 0
			end
		end		
	end
	OZ_Config.version = OZ_CURRENT_VERSION

	OZ_UpdateRoster()
--	for i=1,OZ_NWINDOWS do
--		OZ_InitWindow(i)
--	end
	OZ_SetMinimapPos()

	OZ_Initialised = 1

	for i=1,OZ_NWINDOWS do
		if( not OZ_Config[i] or not OZ_Config[i].bottomCol )then
			print(" Config error in Window "..i)
			OZ_SetupConfig(i)
		end
	end
end

function OZ_GetWindowArray( n )
	if(not OZ_Windows[n])then
		OZ_InitWindow(n)
	end
	return OZ_Windows[n]
end