local function print(text)
	DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF"..text);
end

local function gg(text)
	local ret = getglobal(text)
	if(not ret) then
		DEFAULT_CHAT_FRAME:AddMessage("|c00FF8800".."OzRaid: Failed to find: "..text);
	end
	return ret
end

OZ_BarTextures = {
					{"<none>",nil},
					{"Normal","Interface\\Addons\\OzRaid\\bar1"},
					{"Toplight","Interface\\Addons\\OzRaid\\bar2"},
					{"Glass","Interface\\Addons\\OzRaid\\bar3"},
					{"Textured Glass","Interface\\Addons\\OzRaid\\bar4"},
					{"Bubble Glass","Interface\\Addons\\OzRaid\\bar5"},
					{"Electro","Interface\\Addons\\OzRaid\\bar6"},
					{"Cross Texture","Interface\\Addons\\OzRaid\\bar7"},
					{"Ribbed","Interface\\Addons\\OzRaid\\bar8"},
					{"Narrow","Interface\\Addons\\OzRaid\\bar9"},
					{"Edged Fade","Interface\\Addons\\OzRaid\\bar10"},
					{"Edged Fade2","Interface\\Addons\\OzRaid\\bar11"},
				}

OZ_OptionsCurrentWindow = 1

OZ_OptionsCheckboxes={
						{ widget="OzRaidOptionsPresetsIsActive", text="Show Window", get=function()return OZ_Config[OZ_OptionsCurrentWindow].active;end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].active=i;end },
						{ widget="OzRaidOptionsPresetsToolTips", text="Show ToolTips", get=function()return OZ_Config[OZ_OptionsCurrentWindow].tooltips;end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].tooltips=i;end },
						{ widget="OzRaidOptionsPresetsLock",	 text="Lock Window", get=function()return OZ_Config[OZ_OptionsCurrentWindow].locked;end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].locked=i;end },
						{ widget="OzRaidOptionsPresetsMiniIcon", text="Minimap Icon", get=function()return OZ_Config.minimapShow;end, set=function(i) OZ_Config.minimapShow=i;end },
						{ widget="OzRaidOptionsPresetsRadio11", text="Show" },
						{ widget="OzRaidOptionsPresetsRadio12", text="Hide" },
						{ widget="OzRaidOptionsPresetsRadio13", text="Don't change" },
						{ widget="OzRaidOptionsPresetsRadio21", text="Show" },
						{ widget="OzRaidOptionsPresetsRadio22", text="Hide" },
						{ widget="OzRaidOptionsPresetsRadio23", text="Don't change" },

						{ widget="OzRaidOptionsInputsCheck1", text="Show Mana", get=function()return OZ_Config[OZ_OptionsCurrentWindow].showMana;end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].showMana=i;end },
						{ widget="OzRaidOptionsInputsCheck2", text="Fade Name too", get=function()return OZ_Config[OZ_OptionsCurrentWindow].fadeName;end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].fadeName=i;end },

						{ widget="OzRaidOptionsFiltersCheck1", text="Group 1", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[1];end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[1]=i;end },
						{ widget="OzRaidOptionsFiltersCheck2", text="Group 2", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[2];end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[2]=i;end },
						{ widget="OzRaidOptionsFiltersCheck3", text="Group 3", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[3];end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[3]=i;end },
						{ widget="OzRaidOptionsFiltersCheck4", text="Group 4", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[4];end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[4]=i;end },
						{ widget="OzRaidOptionsFiltersCheck5", text="Group 5", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[5];end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[5]=i;end },
						{ widget="OzRaidOptionsFiltersCheck6", text="Group 6", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[6];end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[6]=i;end },
						{ widget="OzRaidOptionsFiltersCheck7", text="Group 7", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[7];end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[7]=i;end },
						{ widget="OzRaidOptionsFiltersCheck8", text="Group 8", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[8];end, set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[8]=i;end },
						{ widget="OzRaidOptionsFiltersCheckParty", text="Show", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[9];end,
							set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[9]=i; if i and OZ_Config[OZ_OptionsCurrentWindow].filter.group[10] then OZ_Config[OZ_OptionsCurrentWindow].filter.group[10]=nil; OzRaidOptionsFiltersCheckHidePartyButton:SetChecked(nil);  end; end },
						{ widget="OzRaidOptionsFiltersCheckHideParty", text="Hide My Group", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.group[10];end,
							set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.group[10]=i; if i and OZ_Config[OZ_OptionsCurrentWindow].filter.group[9] then OZ_Config[OZ_OptionsCurrentWindow].filter.group[9]=nil;  OzRaidOptionsFiltersCheckPartyButton:SetChecked(nil); end; end },

						{ widget="OzRaidOptionsFiltersCheck9",	text="Druid",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.DRUID;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.DRUID=i;end },
						{ widget="OzRaidOptionsFiltersCheck10", text="Hunter",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.HUNTER;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.HUNTER=i;end },
						{ widget="OzRaidOptionsFiltersCheck11", text="Mage",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.MAGE;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.MAGE=i;end },
						{ widget="OzRaidOptionsFiltersCheck12", text="Priest",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.PRIEST;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.PRIEST=i;end },
						{ widget="OzRaidOptionsFiltersCheck13", text="Paladin",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.PALADIN;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.PALADIN=i;end },
						{ widget="OzRaidOptionsFiltersCheck14", text="Rogue",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.ROGUE;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.ROGUE=i;end },
						{ widget="OzRaidOptionsFiltersCheck15", text="Shaman",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.SHAMAN;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.SHAMAN=i;end },
						{ widget="OzRaidOptionsFiltersCheck16", text="Warlock", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.WARLOCK;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.WARLOCK=i;end },
						{ widget="OzRaidOptionsFiltersCheck17", text="Warrior", get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.WARRIOR;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.WARRIOR=i;end },
						{ widget="OzRaidOptionsFiltersCheckPet", text="Pet",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.PET;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.PET=i;end },
						{ widget="OzRaidOptionsFiltersCheckTarget", text="Target",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.class.TARGET;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.class.TARGET=i;end },

						{ widget="OzRaidOptionsFiltersCheck18", text="Healthy",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.healthy;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.healthy=i;end },
						{ widget="OzRaidOptionsFiltersCheck19", text="Injured",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.injured;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.injured=i;end },
						{ widget="OzRaidOptionsFiltersCheck20", text="Buffed",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.buffed;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.buffed=i;end },
						{ widget="OzRaidOptionsFiltersCheck21", text="Not Buffed",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.notbuffed;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.notbuffed=i;end },
						{ widget="OzRaidOptionsFiltersCheck22", text="Curable",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.curable;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.curable=i;end },
						{ widget="OzRaidOptionsFiltersCheck23", text="Not Curable",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.notcurable;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.notcurable=i;end },
						{ widget="OzRaidOptionsFiltersCheck24", text="<11 yards",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.close;end,		set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.close=i;end },
						{ widget="OzRaidOptionsFiltersCheck25", text="11-30 yards",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.inrange;end,		set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.inrange=i;end },
						{ widget="OzRaidOptionsFiltersCheck26", text=">30 yards",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.outofrange;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.outofrange=i;end },

						{ widget="OzRaidOptionsFiltersCheck27", text="Dead",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.dead;end,			set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.dead=i;end },
						{ widget="OzRaidOptionsFiltersCheck28", text="Offline",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.offline;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.offline=i;end },
						{ widget="OzRaidOptionsFiltersCheck29", text="Online",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].filter.status.online;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].filter.status.online=i;end },


						{ widget="OzRaidOptionsSortsCheck1", text="Show Headings",},
						{ widget="OzRaidOptionsSortsCheck2", text="Show Headings",},
						{ widget="OzRaidOptionsSortsCheck3", text="Hide Aggro Glow",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].hideGlow;	end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].hideGlow=i;end },

						{ widget="OzRaidOptionsDisplayCheck1", text="Left",},
						{ widget="OzRaidOptionsDisplayCheck2", text="On Bar",},
						{ widget="OzRaidOptionsDisplayCheck3", text="Right",},
						{ widget="OzRaidOptionsDisplayCheck4", text="Left",},
						{ widget="OzRaidOptionsDisplayCheck5", text="On Bar",},
						{ widget="OzRaidOptionsDisplayCheck6", text="Right",},
						{ widget="OzRaidOptionsDisplayCheck7", text="Big Icons",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].buffSize;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].buffSize=i;end },
						{ widget="OzRaidOptionsDisplayCheck8", text="Colour Name",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].classNames;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].classNames=i;end },
						{ widget="OzRaidOptionsDisplayCheck9", text="Outline",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].outlineNames;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].outlineNames=i;end },
						{ widget="OzRaidOptionsDisplayCheck10", text="Fade on Range", get=function()return OZ_Config[OZ_OptionsCurrentWindow].rangeFade;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].rangeFade=i;end },
						{ widget="OzRaidOptionsDisplayCheck11", text="Off",},
						{ widget="OzRaidOptionsDisplayCheck12", text="Left",},
						{ widget="OzRaidOptionsDisplayCheck13", text="Centre",},
						{ widget="OzRaidOptionsDisplayCheck14", text="Right1",},
						{ widget="OzRaidOptionsDisplayCheck15", text="Right2",},
						{ widget="OzRaidOptionsDisplayCheck16", text="Value",},
						{ widget="OzRaidOptionsDisplayCheck17", text="Percent",},
						{ widget="OzRaidOptionsDisplayCheck18", text="Deficit",},
						{ widget="OzRaidOptionsDisplayCheck19", text="Red on Dead",			get=function()return OZ_Config[OZ_OptionsCurrentWindow].nameOnStatus;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].nameOnStatus=i;end },
						{ widget="OzRaidOptionsDisplayCheck20", text="Debuff Colour",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].barDebuffCol;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].barDebuffCol=i;end },
						{ widget="OzRaidOptionsDisplayCheck21", text="Show Debuff Icon",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].showDebuffIcon;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].showDebuffIcon=i;end },
						{ widget="OzRaidOptionsDisplayCheck22", text="Centre",},
						{ widget="OzRaidOptionsDisplayCheck23", text="Hide Icon",			get=function()return OZ_Config[OZ_OptionsCurrentWindow].hideIcon;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].hideIcon=i;end },
						{ widget="OzRaidOptionsDisplayCheck24", text="All Debuffs",			get=function()return OZ_Config[OZ_OptionsCurrentWindow].allDebuffs;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].allDebuffs=i;end },
						{ widget="OzRaidOptionsDisplayCheckBigVal", text="Big K numbers",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].bigVals;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].bigVals=i;end },
	
						{ widget="OzRaidOptionsBuffsHideTimer", text="Hide Buff Timers",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].hideTimers;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].hideTimers=i;end },

						{ widget="OzRaidOptionsGeneralHideTitle", text="Hide title bar",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].hideTitle;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].hideTitle=i;end },
						{ widget="OzRaidOptionsGeneralHideBG", text="Hide Background",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].hideBG;end,		set=function(i) OZ_Config[OZ_OptionsCurrentWindow].hideBG=i;end },
						{ widget="OzRaidOptionsGeneralHideEmpty", text="Hide when empty",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].hideEmpty;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].hideEmpty=i;end },
						{ widget="OzRaidOptionsGeneralHideSolo", text="Hide when solo",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].hideSolo;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].hideSolo=i;end },
						{ widget="OzRaidOptionsGeneralHideParty", text="Hide in party",		get=function()return OZ_Config[OZ_OptionsCurrentWindow].hideParty;end,	set=function(i) OZ_Config[OZ_OptionsCurrentWindow].hideParty=i;end },
						{ widget="OzRaidOptionsGeneralHideButtons", text="Hide buttons",	get=function()return OZ_Config[OZ_OptionsCurrentWindow].hideButtons;end,set=function(i) OZ_Config[OZ_OptionsCurrentWindow].hideButtons=i;end },
						{ widget="OzRaidOptionsGeneralGrowUp", text="Grow Upwards",			get=function()return OZ_Config[OZ_OptionsCurrentWindow].growup;end,		set=function(i) OZ_Config[OZ_OptionsCurrentWindow].growup=i;end },
					};

OZ_SLIDERS = {
	{
		widget = "OzRaidOptionsPresetsMiniAngle",
		get = function()return OZ_Config.minimapAngle;end,
		set = function(i)OZ_Config.minimapAngle = i;end,
		text = "Minimap Ang. (%d):",
	},
	{
		widget = "OzRaidOptionsPresetsMiniDist",
		get = function()return OZ_Config.minimapDist;end,
		set = function(i)OZ_Config.minimapDist = i;end,
		text = "Minimap Dist. (%d):",
	},
	{
		widget = "OzRaidOptionsInputsSlider",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].filter.injuredVal;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].filter.injuredVal = i;end,
		text = "Healthy/Injured Cutoff (%d%%):",
		textScale = 100,
	},
	{
		widget = "OzRaidOptionsInputsFadeAlpha",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].fadeAlpha;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].fadeAlpha = i;end,
		text = "Distance Fade Alpha (%d%%):",
		textScale = 100,
	},
	{
		widget = "OzRaidOptionsGeneralButtonSize",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].buttonSize;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].buttonSize = i;end,
		text = "Icon Size (%d px):",
	},
	{
		widget = "OzRaidOptionsGeneralTitleSize",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].titleHeight;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].titleHeight = i;end,
		text = "Title Height (%d px):",
	},
	{
		widget = "OzRaidOptionsGeneralBarWidth",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].width;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].width = i;end,
		text = "Bar Width (%d px):",
	},
	{
		widget = "OzRaidOptionsGeneralBarHeight",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].barHeight;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].barHeight = i;end,
		text = "Bar Height (%d px):",
	},
	{
		widget = "OzRaidOptionsGeneralTextSize",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].textSize;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].textSize = i;end,
		text = "Text Size (%d px):",
	},
	{
		widget = "OzRaidOptionsGeneralMinBars",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].minBars;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].minBars = i;end,
		text = "Min. Bars (%d):",
	},
	{
		widget = "OzRaidOptionsGeneralMaxBars",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].maxBars;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].maxBars = i;end,
		text = "Max. Bars (%d):",
	},
	{
		widget = "OzRaidOptionsGeneralRefresh",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].refresh;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].refresh = i;end,
		text = "Refresh (%1.1fs):",
	},
	{
		widget = "OzRaidOptionsGeneralNameSize",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].nameSize;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].nameSize = i;end,
		text = "Name Size (%d):",
	},
	{
		widget = "OzRaidOptionsGeneralNumSize",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].numSize;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].numSize = i;end,
		text = "Number Size (%d):",
	},
	{
		widget = "OzRaidOptionsGeneralSpacing",
		get = function()return OZ_Config[OZ_OptionsCurrentWindow].barGap;end,
		set = function(i)OZ_Config[OZ_OptionsCurrentWindow].barGap = i;end,
		text = "Bar Spacing (%d):",
	},
};


local function UglyScrollLeft()
  this:HighlightText(0,1);
  this:Insert(" "..strsub(this:GetText(),1,1));
  this:HighlightText(0,1);
  this:Insert("");
  this:SetScript("OnUpdate", nil);
end
 
function OZ_OptionsInit()
	OzRaidOptionsTitleString:SetText( string.format("OzRaid v%1.2f",OZ_CURRENT_VERSION) );

	PanelTemplates_SetNumTabs(OzRaidOptions, table.getn(OZ_OptionsPanes) );
	OzRaidOptions.selectedTab=1;
	PanelTemplates_UpdateTabs(OzRaidOptions);

	-- Setup Presets
	OzRaidOptionsPresetsTitleHeadingText:SetText("Window title:")
	OzRaidOptionsPresetsPartyHeadingText:SetText("Default party frames:")
	OzRaidOptionsPresetsInPartyHeadingText:SetText("In Party:")
	OzRaidOptionsPresetsInRaidHeadingText:SetText("In Raid:")
--	OzRaidOptionsPresetsApply:Disable()

	OzRaidOptionsInputsHeadingText:SetText("Select Input:")

	for key,value in ipairs(OZ_OptionsCheckboxes) do
		gg( value.widget.."ButtonText" ):SetJustifyH("LEFT")
		gg( value.widget.."ButtonText" ):SetText( value.text )
	end

	OzRaidOptionsSortsHeading1Text:SetText("Select Sorts:")
	OzRaidOptionsSortsHeading2Text:SetText("Bar Display Options:")
	OzRaidOptionsSortsHeading3Text:SetText("Texture")
	OzRaidOptionsSortsHeading4Text:SetText("Name Format")

	OzRaidOptionsDisplayCheck1HeadingText:SetText("Name position:")
	OzRaidOptionsDisplayCheck4HeadingText:SetText("Buff position:")
	OzRaidOptionsDisplayCheck11HeadingText:SetText("Number position:")

	local _, value, widget, n
	for _,value in ipairs(OZ_SLIDERS) do
		local widget = gg(value.widget)
		if(widget)then
			gg(value.widget.."Low"):SetText(nil)
			gg(value.widget.."High"):SetText(nil)
		end
	end	
end

local OZ_CurrentWindowText = ""


function OZ_ReadSliders()
	local _, value, widget, n
	for _,value in ipairs(OZ_SLIDERS) do
		local widget = gg(value.widget)
		if(widget)then
			n = widget:GetValue()
			value.set(n)
			if(value.textScale)then
				n = n * value.textScale
			end
			gg(value.widget.."Text"):SetText( string.format( value.text, n ) )
		end
	end
end
function OZ_SetSliders()
	local _, value, widget, n
	for _,value in ipairs(OZ_SLIDERS) do
		local widget = gg(value.widget)
		if(widget)then
			widget:SetValue(value.get())
		end
	end
end



function OZ_OptionsSetConfigFromOptions()
	local a,b,i
	local config = OZ_Config[OZ_OptionsCurrentWindow]
	local window = OZ_GetWindowArray(OZ_OptionsCurrentWindow)
	if(not config)then
		DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."Error - no config data for window "..OZ_OptionsCurrentWindow)	
		return
	end
	config.text = OzRaidOptionsPresetsTitleName:GetText();
	if(OZ_CurrentWindowText ~= config.text) then
		OZ_OptionsWindow:Hide()
		OZ_OptionsWindow:Show()
		OZ_CurrentWindowText = config.text
	end

	OZ_ReadSliders()

	-- Inputs
	a = UIDropDownMenu_GetSelectedValue(OZ_InputsCombo1)
	config.input = a

	-- Filters
	for key,value in ipairs(OZ_OptionsCheckboxes) do
		if(value.set) then
			value.set(gg(value.widget.."Button"):GetChecked())
		end
	end

	-- Sorts
	config.heading[1] = 0
	config.heading[2] = 0
	config.heading[3] = 0

	b = 1
	a = UIDropDownMenu_GetSelectedValue(OZ_SortCombo1)
	config.sort1 = a
	if( OzRaidOptionsSortsCheck1Button:GetChecked() )then
		config.heading[b] = a
		b = b + 1
	end
	a = UIDropDownMenu_GetSelectedValue(OZ_SortCombo2)
	config.sort2 = a
	if( OzRaidOptionsSortsCheck2Button:GetChecked() )then
		config.heading[b] = a
		b = b + 1
	end

	-- read Party frame settings
	if( OzRaidOptionsPresetsRadio11Button:GetChecked() ) then
		OZ_Config.pFramesParty = 1
	elseif( OzRaidOptionsPresetsRadio12Button:GetChecked() ) then
		OZ_Config.pFramesParty = 2
	elseif( OzRaidOptionsPresetsRadio13Button:GetChecked() ) then
		OZ_Config.pFramesParty = nil
	end
	if( OzRaidOptionsPresetsRadio21Button:GetChecked() ) then
		OZ_Config.pFramesRaid = 1
	elseif( OzRaidOptionsPresetsRadio22Button:GetChecked() ) then
		OZ_Config.pFramesRaid = 2
	elseif( OzRaidOptionsPresetsRadio23Button:GetChecked() ) then
		OZ_Config.pFramesRaid = nil
	end

	
	-- Setup headings functions
	if( OzRaidOptionsDisplayCheck1Button:GetChecked() )then
		config.namePos = 2
	elseif( OzRaidOptionsDisplayCheck2Button:GetChecked() )then
		config.namePos = 1
	elseif( OzRaidOptionsDisplayCheck3Button:GetChecked() )then
		config.namePos = 3
	else
		config.namePos = 4
	end

	-- Setup buff functions
	if( OzRaidOptionsDisplayCheck4Button:GetChecked() )then
		config.buffPos = 2
	elseif( OzRaidOptionsDisplayCheck5Button:GetChecked() )then
		config.buffPos = 1
	else
		config.buffPos = 3
	end

	-- Setup number functions
	if( OzRaidOptionsDisplayCheck11Button:GetChecked() )then
		config.valuePos = nil
	elseif( OzRaidOptionsDisplayCheck12Button:GetChecked() )then
		config.valuePos = 1
	elseif( OzRaidOptionsDisplayCheck13Button:GetChecked() )then
		config.valuePos = 2
	elseif( OzRaidOptionsDisplayCheck14Button:GetChecked() )then
		config.valuePos = 3
	else
		config.valuePos = 4
	end
	if( OzRaidOptionsDisplayCheck16Button:GetChecked() )then
		config.valueType = 1
	elseif( OzRaidOptionsDisplayCheck17Button:GetChecked() )then
		config.valueType = 2
	else
		config.valueType = 3
	end

	config.Anchor,_,config.Relative,config.ax,config.ay = OZ_GetWindowTop(window.frame,config.growup)

	OZ_SetFromConfig(OZ_OptionsCurrentWindow)
	-- Force an update
	OZ_EventRoster()
	OZ_Windows[OZ_OptionsCurrentWindow].frame.tNext = 0
	OzRaid_Update(OZ_OptionsCurrentWindow)
end


function OZ_OptionsSetOptionsFromConfig(n)
	local a,b
	local config = OZ_Config[n]
	OZ_OptionsCurrentWindow = n
	if(not config)then
		DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."Error - no config data for window "..OZ_OptionsCurrentWindow)	
		return
	end

	OzRaidOptionsPresetsTitleName:SetText(config.text);
	OzRaidOptionsPresetsTitleName:SetScript("OnUpdate", UglyScrollLeft);

	-- Inputs
	UIDropDownMenu_SetSelectedValue(OZ_InputsCombo1, config.input)

	-- Filters
	for key,value in ipairs(OZ_OptionsCheckboxes) do
		if(value.get)then
			gg(value.widget.."Button"):SetChecked(value.get())
		end
	end
	
	-- Sorts
	UIDropDownMenu_SetSelectedValue(OZ_SortCombo1, config.sort1)
	b = 1
	if( config.heading[b] == config.sort1)then
		b = b + 1
		OzRaidOptionsSortsCheck1Button:SetChecked(1)
	else
		OzRaidOptionsSortsCheck1Button:SetChecked(nil)
	end

	UIDropDownMenu_SetSelectedValue(OZ_SortCombo2, config.sort2)
	if( config.heading[b] == config.sort2)then
		b = b + 1
		OzRaidOptionsSortsCheck2Button:SetChecked(1)
	else
		OzRaidOptionsSortsCheck2Button:SetChecked(nil)
	end
	
	local found
	for key,value in ipairs(OZ_BarTextures) do
		if(value[2] == config.barTexture)then
			UIDropDownMenu_SetSelectedValue(OZ_TextureCombo,key)
			found = 1
			break
		end
	end
	if(not found) then
		UIDropDownMenu_SetSelectedValue(OZ_TextureCombo,1)
	end

	-- read Party frame settings
	OzRaidOptionsPresetsRadio11Button:SetChecked(nil)
	OzRaidOptionsPresetsRadio12Button:SetChecked(nil)
	OzRaidOptionsPresetsRadio13Button:SetChecked(nil)
	if OZ_Config.pFramesParty == 1 then
		OzRaidOptionsPresetsRadio11Button:SetChecked(1)
	elseif OZ_Config.pFramesParty == 2 then
		OzRaidOptionsPresetsRadio12Button:SetChecked(1)
	else
		OzRaidOptionsPresetsRadio13Button:SetChecked(1)
	end

	OzRaidOptionsPresetsRadio21Button:SetChecked(nil)
	OzRaidOptionsPresetsRadio22Button:SetChecked(nil)
	OzRaidOptionsPresetsRadio23Button:SetChecked(nil)
	if OZ_Config.pFramesRaid == 1 then
		OzRaidOptionsPresetsRadio21Button:SetChecked(1)
	elseif OZ_Config.pFramesRaid == 2 then
		OzRaidOptionsPresetsRadio22Button:SetChecked(1)
	else
		OzRaidOptionsPresetsRadio23Button:SetChecked(1)
	end

	-- Setup headings functions
	OzRaidOptionsDisplayCheck1Button:SetChecked(nil)
	OzRaidOptionsDisplayCheck2Button:SetChecked(nil)
	OzRaidOptionsDisplayCheck3Button:SetChecked(nil)
	OzRaidOptionsDisplayCheck22Button:SetChecked(nil)
	if(config.namePos == 2)then
		OzRaidOptionsDisplayCheck1Button:SetChecked(1)
	elseif(config.namePos == 1)then
		OzRaidOptionsDisplayCheck2Button:SetChecked(1)
	elseif(config.namePos == 3)then
		OzRaidOptionsDisplayCheck3Button:SetChecked(1)
	else
		OzRaidOptionsDisplayCheck22Button:SetChecked(1)
	end

	-- Setup buff functions
	OzRaidOptionsDisplayCheck4Button:SetChecked(nil)
	OzRaidOptionsDisplayCheck5Button:SetChecked(nil)
	OzRaidOptionsDisplayCheck6Button:SetChecked(nil)
	if(config.buffPos == 2)then
		OzRaidOptionsDisplayCheck4Button:SetChecked(1)
	elseif(config.buffPos == 1)then
		OzRaidOptionsDisplayCheck5Button:SetChecked(1)
	else
		OzRaidOptionsDisplayCheck6Button:SetChecked(1)
	end
	
	if(config.valuePos)then
		Oz_RaidDisplayCheckClick( 11 + config.valuePos )
	else
		Oz_RaidDisplayCheckClick( 11 )
	end
	Oz_RaidDisplayCheckClick( 15 + config.valueType )

	-- General options
	OZ_SetSliders()

	OZ_SetMinimapPos()
end

function OZ_OptionsReset()
	OZ_SetupConfig(OZ_OptionsCurrentWindow)
	OZ_OptionsSetOptionsFromConfig(OZ_OptionsCurrentWindow)
end


		




---------------------------------------------------------
--
--  PRESETS PANEL - DROPDOWN SETUP
--
---------------------------------------------------------
OZ_Presets1_Val = "GENERAL"
OZ_Presets2_Val = "Raid View"

function OZ_PresetsCombo1_OnLoad()
	UIDropDownMenu_Initialize(this, OZ_PresetsCombo1_Initialize); 
	UIDropDownMenu_SetWidth(120,this)
	UIDropDownMenu_SetSelectedValue(this, OZ_Presets1_Val);
end

function OZ_PresetsCombo1_Initialize()
	OZ_Presets1_Val = nil
	for key,val in pairs(OZ_PRESETS) do
		if( not OZ_Presets1_Val )then
			OZ_Presets1_Val = key
		end
		UIDropDownMenu_AddButton{value = key , text = key, func = OZ_PresetsCombo1_Pressed}
	end
end 

function OZ_PresetsCombo1_Pressed() 
	UIDropDownMenu_SetSelectedValue(OZ_PresetsCombo1,this.value)
	OZ_Presets1_Val = this.value
	OZ_PresetsCombo2:Hide()
	OZ_PresetsCombo2:Show()
end 


function OZ_PresetsCombo2_OnLoad() 
	UIDropDownMenu_Initialize(this, OZ_PresetsCombo2_Initialize2); 
	UIDropDownMenu_SetWidth(120,this)
	UIDropDownMenu_SetSelectedValue(this, OZ_Presets2_Val);
end

function OZ_PresetsCombo2_Initialize2() 
	OZ_Presets2_Val = nil
	for key,val in pairs(OZ_PRESETS[OZ_Presets1_Val]) do
		if( not OZ_Presets2_Val )then
			OZ_Presets2_Val = key
		end
		UIDropDownMenu_AddButton{value = key , text = key , func = OZ_PresetsCombo2_Pressed}
	end
end 

function OZ_PresetsCombo2_Pressed() 
	UIDropDownMenu_SetSelectedValue(OZ_PresetsCombo2,this.value)
	OZ_Presets2_Val = this.value
--DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."OzRaid: Table2="..OZ_Presets2_Val);
end

function OZ_DuplicateTable( src )
	local t,ret,key,val
	ret = {}

	for key,val in pairs(src) do
		local t = type(val)
		if(t=="table") then
			ret[key] = OZ_DuplicateTable(val)
		else
			ret[key] = val
		end
	end
	return ret
end

function OZ_UpdateTable( src, dest )
	local t,key,val
	for key,val in pairs(src) do
		t = type(val)
		if(t=="table") then
            if not dest[key] then
				dest[key] = {}
			end
			OZ_UpdateTable(val, dest[key])
		else
			dest[key] = val
		end
	end
end


function OZ_PresetApply()
	-- copy current anchoring
	local c = OZ_Config[OZ_OptionsCurrentWindow]
	local a,r,x,y = c.Anchor, c.Relative, c.ax, c.ay
    local key,val
	-- Duplicate from preset
--	OZ_Config[OZ_OptionsCurrentWindow] = OZ_DuplicateTable( OZ_PRESETS[OZ_Presets1_Val][OZ_Presets2_Val] )
    OZ_Config[OZ_OptionsCurrentWindow] = {}
    for key,val in ipairs(OZ_PRESETS[OZ_Presets1_Val][OZ_Presets2_Val].templates) do
        OZ_UpdateTable( val, OZ_Config[OZ_OptionsCurrentWindow] )
    end
    OZ_UpdateTable( OZ_PRESETS[OZ_Presets1_Val][OZ_Presets2_Val].custom, OZ_Config[OZ_OptionsCurrentWindow] )

	-- reset positions
	OZ_Config[OZ_OptionsCurrentWindow].Anchor = a;
	OZ_Config[OZ_OptionsCurrentWindow].Relative = r;
	OZ_Config[OZ_OptionsCurrentWindow].ax = x;
	OZ_Config[OZ_OptionsCurrentWindow].ay = y;

--DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."Setting preset to: "..OZ_Presets1_Val.."-"..OZ_Presets2_Val);
--DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."name = "..OZ_Config[OZ_OptionsCurrentWindow].text);

	OZ_OptionsSetOptionsFromConfig(OZ_OptionsCurrentWindow);
	OZ_OptionsSetConfigFromOptions();
end

---------------------------------------------------------
--
--  OPTIONS SCREEN - TABS SET UP
--
---------------------------------------------------------
function OZ_HideOptions()
	OzRaidOptions:Hide()
end

OZ_OptionsPanes =	{
						"OzRaidOptionsPresets",
						"OzRaidOptionsInputs",
						"OzRaidOptionsFilters",
						"OzRaidOptionsSorts",
						"OzRaidOptionsDisplay",
						"OzRaidOptionsBuffs",
						"OzRaidOptionsGeneral",
					};


function OZ_OptionsTabOnClick(tab)
	local n = tab:GetID()
	OzRaidOptions.selectedTab = n;
	PanelTemplates_UpdateTabs(OzRaidOptions);

	-- Now hide/show panes...
	local i
	for i,value in ipairs(OZ_OptionsPanes) do
		if( i == n ) then
--DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."OzRaid: Showing "..value);
			getglobal(value):Show()
		else
--DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."OzRaid: Hiding "..value);
			getglobal(value):Hide()
		end
	end
end

---------------------------------------------------------
--
--  SORT PANEL - DROPDOWN SETUP
--
---------------------------------------------------------
function OZ_SortCombo1_OnLoad() 
	UIDropDownMenu_Initialize(this, OZ_SortCombo1_Initialize); 
	UIDropDownMenu_SetWidth(120,this)
	if(OZ_Initialised) then
		UIDropDownMenu_SetSelectedValue(this, OZ_Config[OZ_OptionsCurrentWindow].sort1);
	else
		UIDropDownMenu_SetSelectedValue(this, 1);
	end

--DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."OzRaid: Sort1 Initialised");
end

function OZ_SortCombo1_Initialize()
	UIDropDownMenu_AddButton({value = 0 , text = "<None>" , func = OZ_SortCombo1_Pressed})
	local i
	for i = 1,8 do
		if(OZ_SortFunctions[i]) then
			UIDropDownMenu_AddButton{value = i , text = OZ_SortFunctions[i].text , func = OZ_SortCombo1_Pressed}
		end
	end
end 

function OZ_SortCombo1_Pressed() 
	UIDropDownMenu_SetSelectedValue(OZ_SortCombo1,this.value)
	OZ_Config[OZ_OptionsCurrentWindow].sort1 = this.value

	OZ_SortCombo2:Enable()
	OZ_SortCombo2:Hide()
	OZ_SortCombo2:Show()
end 


function OZ_SortCombo2_OnLoad() 
	UIDropDownMenu_Initialize(this, OZ_SortCombo2_Initialize2); 
	UIDropDownMenu_SetWidth(120,this)

	if(OZ_Config[OZ_OptionsCurrentWindow]) then
		UIDropDownMenu_SetSelectedValue(this, OZ_Config[OZ_OptionsCurrentWindow].sort2);
	else
		UIDropDownMenu_SetSelectedValue(this, 0);
	end
--DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."OzRaid: Sort2 Initialised");
end

function OZ_SortCombo2_Initialize2()
	UIDropDownMenu_AddButton{value = 0 , text = "<None>" , func = OZ_SortCombo2_Pressed}
	local i
	for i = 1,8 do
		if(OZ_SortFunctions[i]) then
			UIDropDownMenu_AddButton{value = i , text = OZ_SortFunctions[i].text , func = OZ_SortCombo2_Pressed}
		end
	end
end 

function OZ_SortCombo2_Pressed() 
	UIDropDownMenu_SetSelectedValue(OZ_SortCombo2,this.value)
	OZ_Config[OZ_OptionsCurrentWindow].sort2 = this.value
--DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."OzRaid: Table2="..OZ_Sort2_Val);
end 


function OZ_TextureCombo_OnLoad()
	UIDropDownMenu_Initialize(this, OZ_TextureCombo_Initialise);

	local found
	if(OZ_Config[OZ_OptionsCurrentWindow]) then
		for key,value in ipairs(OZ_BarTextures) do
			if(value[2] == OZ_Config[OZ_OptionsCurrentWindow].barTexture)then
				UIDropDownMenu_SetSelectedValue(this,key)
				found = 1
				break
			end
		end
	end

	if(not found) then
		UIDropDownMenu_SetSelectedValue(this, 1);
	end
end

function OZ_TextureCombo_Initialise()
	local key,value
	local w = OZ_OptionsCurrentWindow
	for key,value in ipairs(OZ_BarTextures) do
		UIDropDownMenu_AddButton{value = key , text = value[1], func = OZ_TextureCombo_Pressed}
	end
end
function OZ_TextureCombo_Pressed()
	UIDropDownMenu_SetSelectedValue(OZ_TextureCombo,this.value)
	OZ_Config[OZ_OptionsCurrentWindow].barTexture = OZ_BarTextures[this.value][2]
end



function OZ_NameCombo_OnLoad() 
	UIDropDownMenu_Initialize(this, OZ_NameCombo_Initialize); 
	UIDropDownMenu_SetWidth(120,this)
	if(OZ_Initialised) then
		UIDropDownMenu_SetSelectedValue(this, OZ_Config[OZ_OptionsCurrentWindow].nameStyle);
	else
		UIDropDownMenu_SetSelectedValue(this, 1);
	end
end

function OZ_NameCombo_Initialize()
	local i,t
	for i,t in ipairs(OZ_NAME_FORMATS) do
		UIDropDownMenu_AddButton{value = i , text = t.name , func = OZ_NameCombo_Pressed}
	end
end 

function OZ_NameCombo_Pressed() 
	UIDropDownMenu_SetSelectedValue(OZ_NameCombo,this.value)
	OZ_Config[OZ_OptionsCurrentWindow].nameStyle = this.value

	OZ_NameCombo:Enable()
	OZ_NameCombo:Hide()
	OZ_NameCombo:Show()
end 

---------------------------------------------------------
--
--  INPUTS PANEL - DROPDOWN SETUP
--
---------------------------------------------------------
function OZ_InputsCombo1_OnLoad() 
	UIDropDownMenu_Initialize(this, OZ_InputsCombo1_Initialize); 
	UIDropDownMenu_SetWidth(120,this)
	if(OZ_Initialised) then
		UIDropDownMenu_SetSelectedValue(this, OZ_Config[OZ_OptionsCurrentWindow].input);
	else
		UIDropDownMenu_SetSelectedValue(this, 1);
	end
end

function OZ_InputsCombo1_Initialize()
	for key,value in ipairs(OZ_InputFunctions) do
		UIDropDownMenu_AddButton{value = key , text = value.text , func = OZ_InputsCombo1_Pressed}
	end
end 

function OZ_InputsCombo1_Pressed() 
	UIDropDownMenu_SetSelectedValue(OZ_InputsCombo1,this.value)
	OZ_Config[OZ_OptionsCurrentWindow].input = this.value
end 

---------------------------------------------------------
--
--  DISPLAY PANEL - DROPDOWN SETUP
--
---------------------------------------------------------
function OZ_DisplayCombo1_OnLoad() 
	UIDropDownMenu_Initialize(this, OZ_DisplayCombo1_Initialize); 
	UIDropDownMenu_SetWidth(120,this)
	if(OZ_Initialised) then
		UIDropDownMenu_SetSelectedValue(this, OZ_Config[OZ_OptionsCurrentWindow].colour);
	else
		UIDropDownMenu_SetSelectedValue(this, 1);
	end
end

function OZ_DisplayCombo1_Initialize()
	for key,value in ipairs(OZ_ColourFunctions) do
		UIDropDownMenu_AddButton{value = key , text = value.text , func = OZ_DisplayCombo1_Pressed}
	end
end 

function OZ_DisplayCombo1_Pressed() 
	UIDropDownMenu_SetSelectedValue(OZ_DisplayCombo1,this.value)
	OZ_Config[OZ_OptionsCurrentWindow].colour = this.value
end 

function Oz_RaidDisplayCheckClick(id)
--DEFAULT_CHAT_FRAME:AddMessage("|c0033CCFF".."OzRaid: PRESSED "..id);
	if(id < 4)then
		OzRaidOptionsDisplayCheck1Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck2Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck3Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck22Button:SetChecked(nil)
		if(id == 1)then
			OzRaidOptionsDisplayCheck1Button:SetChecked(1)
		elseif(id == 2)then
			OzRaidOptionsDisplayCheck2Button:SetChecked(1)
		elseif(id == 3)then
			OzRaidOptionsDisplayCheck3Button:SetChecked(1)
		else
			OzRaidOptionsDisplayCheck22Button:SetChecked(1)
		end
	elseif(id < 7)then
		OzRaidOptionsDisplayCheck4Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck5Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck6Button:SetChecked(nil)
		if(id == 4)then
			OzRaidOptionsDisplayCheck4Button:SetChecked(1)
		elseif(id == 5)then
			OzRaidOptionsDisplayCheck5Button:SetChecked(1)
		elseif(id == 6)then
			OzRaidOptionsDisplayCheck6Button:SetChecked(1)
		end
	elseif(id<16)then
		OzRaidOptionsDisplayCheck11Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck12Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck13Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck14Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck15Button:SetChecked(nil)
		if(id == 11)then
			OzRaidOptionsDisplayCheck11Button:SetChecked(1)
		elseif(id == 12)then
			OzRaidOptionsDisplayCheck12Button:SetChecked(1)
		elseif(id == 13)then
			OzRaidOptionsDisplayCheck13Button:SetChecked(1)
		elseif(id == 14)then
			OzRaidOptionsDisplayCheck14Button:SetChecked(1)
		elseif(id == 15)then
			OzRaidOptionsDisplayCheck15Button:SetChecked(1)
		end
	elseif(id<19)then
		OzRaidOptionsDisplayCheck16Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck17Button:SetChecked(nil)
		OzRaidOptionsDisplayCheck18Button:SetChecked(nil)
		if(id == 16)then
			OzRaidOptionsDisplayCheck16Button:SetChecked(1)
		elseif(id == 17)then
			OzRaidOptionsDisplayCheck17Button:SetChecked(1)
		elseif(id == 18)then
			OzRaidOptionsDisplayCheck18Button:SetChecked(1)
		end
	elseif (id>=101) and (id<=103) then
		OzRaidOptionsPresetsRadio11Button:SetChecked(nil)
		OzRaidOptionsPresetsRadio12Button:SetChecked(nil)
		OzRaidOptionsPresetsRadio13Button:SetChecked(nil)
		if id == 101 then
			OzRaidOptionsPresetsRadio11Button:SetChecked(1)
		elseif id == 102 then
			OzRaidOptionsPresetsRadio12Button:SetChecked(1)
		else
			OzRaidOptionsPresetsRadio13Button:SetChecked(1)
		end
	elseif (id>=201) and (id<=203) then
		OzRaidOptionsPresetsRadio21Button:SetChecked(nil)
		OzRaidOptionsPresetsRadio22Button:SetChecked(nil)
		OzRaidOptionsPresetsRadio23Button:SetChecked(nil)
		if id == 201 then
			OzRaidOptionsPresetsRadio21Button:SetChecked(1)
		elseif id == 202 then
			OzRaidOptionsPresetsRadio22Button:SetChecked(1)
		else
			OzRaidOptionsPresetsRadio23Button:SetChecked(1)
		end
	end
end

function OZ_OptionsWindow_OnLoad()
	UIDropDownMenu_Initialize(this, OZ_OptionsWindow_Initialize); 
	UIDropDownMenu_SetWidth(120,this)
	UIDropDownMenu_SetSelectedValue(this, OZ_OptionsCurrentWindow);
end

function OZ_OptionsWindow_Initialize()
	if(OZ_Initialised == 1)then
		local i
		for i=1,OZ_NWINDOWS do
			UIDropDownMenu_AddButton{value = i , text = OZ_Config[i].text , func = OZ_OptionsWindow_Pressed}
		end
	end
end 

function OZ_OptionsWindow_Pressed() 
	UIDropDownMenu_SetSelectedValue(OZ_OptionsWindow,this.value)

	OZ_OptionsSetOptionsFromConfig(this.value)
	OzRaidOptions:Hide()
	OzRaidOptions:Show()
end 

function OZ_OptionsCentre()
	local window = OZ_Windows[OZ_OptionsCurrentWindow]
	window.frame:ClearAllPoints()
	window.frame:SetPoint("CENTER",nil)
	OZ_OptionsSetConfigFromOptions()
end

function OZ_AddWindowPressed()
	OZ_AddWindow()
	OZ_OptionsCurrentWindow = OZ_NWINDOWS
	UIDropDownMenu_SetSelectedValue(OZ_OptionsWindow,OZ_OptionsCurrentWindow)
	OZ_OptionsSetOptionsFromConfig(OZ_OptionsCurrentWindow)
end
function OZ_DeleteWindowPressed()
	if OZ_NWINDOWS>1 then
		OZ_RemoveWindow(OZ_OptionsCurrentWindow)
		OZ_OptionsCurrentWindow = 1
		UIDropDownMenu_SetSelectedValue(OZ_OptionsWindow,1)
		OZ_OptionsSetOptionsFromConfig(OZ_OptionsCurrentWindow)
	else
		OZ_Config[1].active = nil;
	end
end

--------------------------------------------------------------------------------
--- Functions for the scrolly window
--------------------------------------------------------------------------------
-- List format: {'text', depth, 'maxKey', 'texture name', 'priority', 'debuff', 'index'}
--					1		2		3			 4				5		  6			7
-- Headings have 'nil' for a texturename
OZ_BuffSelectList = {}

OZ_BuffSelectMaximised = {}


function OZ_BuildSelectList()
	local i = 1
	local key, key2, key3, key4, value, value2, value3, value4
	local config = OZ_Config[OZ_OptionsCurrentWindow]
	OZ_BuffSelectList = {}
	local maxKey
--DEFAULT_CHAT_FRAME:AddMessage( "Building list" )
	for key,value in pairs(OZ_BUFF_TABLE) do
		if( OZ_BuffSelectMaximised[key] )then
--DEFAULT_CHAT_FRAME:AddMessage( "- "..key )
			-- This category is expanded
			OZ_BuffSelectList[i] = {key, 0, key}
			i = i+1
			for key2,value2 in pairs(value) do
				if( OZ_BuffSelectMaximised[key..key2] )then
--DEFAULT_CHAT_FRAME:AddMessage( "  - "..key2 )
					OZ_BuffSelectList[i] = {key2, 1, key..key2}
					i = i+1
					for key3,value3 in pairs(value2) do
--DEFAULT_CHAT_FRAME:AddMessage( "      "..key3 )
						local priority = -1
						local index = nil
						
						local array
						local tex = "Interface\\Icons\\"..value3[3]
						if value3[4] == 1 then
							array = config.buffsMob
						else
							array = config.buffsPlayer
						end
						local a = array[tex]
						if a then
							priority = a[1]
							index = 1
						end

						OZ_BuffSelectList[i] = {value3[2], 2, key..key2..i, tex, priority, value3[4], index}
						i = i+1
					end
				else
--DEFAULT_CHAT_FRAME:AddMessage( "  + "..key2 )
					OZ_BuffSelectList[i] = {key2, 1, key..key2}
					i = i+1
				end
			end
		else
--DEFAULT_CHAT_FRAME:AddMessage( "+ "..key )
			OZ_BuffSelectList[i] = {key, 0, key}
			i = i+1
		end
	end
end


OZ_BUFF_PRIORITYTEXT = {
		[-1]	= { col={0.4, 0.4, 0.4}, text="none" },
		[0]		= { col={1.0, 0.2, 0.2}, text="lowest" },
		[1]		= { col={0.8, 0.4, 0.1}, text="low" },
		[2]		= { col={0.6, 0.6, 0.0}, text="medium" },
		[3]		= { col={0.4, 0.8, 0.1}, text="high" },
		[4]		= { col={0.2, 1.0, 0.2}, text="highest" },
	};

function OZ_BuffSetPriority(i, p)
	
end

function OZ_BuffPanelClick()
	local index
	local name = this:GetName()
	-- Name will be 'OzRaidBuffsScrollEntry<n>Maximise'
	index = string.byte(name,23) - 48
--DEFAULT_CHAT_FRAME:AddMessage( "index = "..index )
	lineplusoffset = index + FauxScrollFrame_GetOffset(OzRaidBuffsScrollBar);
	local entry = OZ_BuffSelectList[lineplusoffset]

	local config = OZ_Config[OZ_OptionsCurrentWindow]
	local texture = entry[4]
	if texture then
		-- Clicked on a leaf node - inc priority
		local dest
		if(entry[6] == 1)then
			dest = config.buffsMob
		else
			dest = config.buffsPlayer
		end
		
		if dest[texture] then
			-- Known buff
			local a = dest[texture][1] + 1
			if a>4 then
				dest[texture] = nil
			else
				dest[texture][1] = a
			end
		else
			dest[texture] = {0,entry[1]}
		end
	elseif(OZ_BuffSelectMaximised[ entry[3] ])then
		OZ_BuffSelectMaximised[ entry[3] ] = nil
	else
		OZ_BuffSelectMaximised[ entry[3] ] = 1
	end

	OZ_BuildSelectList()
	OZ_BuffPanelUpdate()
end


function OZ_BuffPanelUpdate()
	local line;
	local lineplusoffset; -- an index into our data calculated from the scroll offset
	local barCount = 8

	local inputs = table.getn(OZ_BuffSelectList)
	if(inputs < barCount) then
		barCount = inputs
	end

	FauxScrollFrame_Update(OzRaidBuffsScrollBar,inputs,barCount,16);
	for line=1,8 do
		lineplusoffset = line + FauxScrollFrame_GetOffset(OzRaidBuffsScrollBar);
		if (lineplusoffset <= inputs) then
			-- Setup this line
			local text
			local entry = gg("OzRaidBuffsScrollEntry"..line)
			local entryText = gg("OzRaidBuffsScrollEntry"..line.."Text")
			local entryMax = gg("OzRaidBuffsScrollEntry"..line.."Maximise")
			local entryPri = gg("OzRaidBuffsScrollEntry"..line.."Priority")

			-- Check for 'expanded' status
			local line = OZ_BuffSelectList[lineplusoffset]
			local indent = line[2]*16
			if OZ_BuffSelectMaximised[ line[3] ] then

				-- We are expanded!
				entryMax:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-UP")
				entryMax:SetPushedTexture("Interface\\Buttons\\UI-MinusButton-DOWN")
				entryMax:SetPoint("LEFT",entry,"LEFT", indent, 0)
				entryMax:Show()

				entryText:SetPoint("LEFT",entry,"LEFT", 16+indent, 0)
				entryText:SetTextColor(1.0, 0.82, 0)

				entryPri:Hide()
			elseif(line[2] < 2)then
				entryMax:SetNormalTexture("Interface\\Buttons\\UI-PlusButton-UP")
				entryMax:SetPushedTexture("Interface\\Buttons\\UI-PlusButton-DOWN")
				entryMax:SetPoint("LEFT",entry,"LEFT", indent, 0)
				entryMax:Show()

				entryText:SetPoint("LEFT",entry,"LEFT", 16+indent, 0)
				entryText:SetTextColor(1.0, 0.82, 0)

				entryPri:Hide()
			else
				-- We are a 'leaf' entry
				entryMax:Hide()

				entryText:SetPoint("LEFT",entry,"LEFT", indent, 0)
				entryText:SetTextColor(1, 1, 1)

				entryPri:Show()
				entryPri:SetText( OZ_BUFF_PRIORITYTEXT[ line[5] ].text )
				entryPri:SetTextColor(	OZ_BUFF_PRIORITYTEXT[ line[5] ].col[1],
										OZ_BUFF_PRIORITYTEXT[ line[5] ].col[2],
										OZ_BUFF_PRIORITYTEXT[ line[5] ].col[3] )
			end
			entryText:SetText( line[1] )
		else
			gg("OzRaidBuffsScrollEntry"..line):Hide();
		end
	end
end

function OZ_BuffsReset()
	OZ_Config[OZ_OptionsCurrentWindow].buffsPlayer = {}
	OZ_Config[OZ_OptionsCurrentWindow].buffsMob = {}
	OZ_BuildSelectList()
	OZ_BuffPanelUpdate()
end

function OZ_BuffsDefault()
	OZ_BuffsReset()
	-- Init buff arays with the class defaults
	local class,fileName = UnitClass("player")
	local i = 1
	for key,value in ipairs(OZ_BUFF_DEFAULT[fileName].Player) do
		local bName = "Interface\\Icons\\"..value[3]
		OZ_Config[OZ_OptionsCurrentWindow].buffsPlayer[bName] = { value[1], value[2] }
	end

	for key,value in ipairs(OZ_BUFF_DEFAULT[fileName].Mob) do
		local bName = "Interface\\Icons\\"..value[3]
		OZ_Config[OZ_OptionsCurrentWindow].buffsMob[bName] = { value[1], value[2] }
	end
	OZ_BuildSelectList()
	OZ_BuffPanelUpdate()
end

--[[
------------------------------------------------------
-- New Options panel builder
------------------------------------------------------

OZ_RADIOBUTTON = {	build = OzBuildRadio,
					show = nil };
OZ_SLIDER = {		build = OzBuildSlider,
					show = nil };
OZ_HEADING = {		build = OzBuildHeading,
					show = nil };
OZ_CHECKBOX = {		build = OzBuildCheckBox,
					show = nil };

OZ_Options_Panel_Test = {
	name = "OzPanel1",
	width = 300,
	{
		type	= {OZ_HEADING,"OZ_FontYellowLeft"},
		text	= "First set of options:",
	},
	{
		type	= {OZ_SLIDER,0,100,1,"%"},
		text	= "Colour Name",
		get		= function() return OZ_Config[OZ_OptionsCurrentWindow].classNames; end,
		set		= function(i) OZ_Config[OZ_OptionsCurrentWindow].classNames = i; end,
		-- Say whether you can edit this value during lockdown
		combat_edit = 1,
		-- Say if this setting is safe on clickable bars (may depend in current setting)
		clickSafe = function() return 1; end,
		width	=	300,
	},
	{
		type	= {OZ_RADIOBUTTON,{"Left","Middle","Right"},{0,1,2}},
		text	= "Position",
		get		= function() return OZ_Config[OZ_OptionsCurrentWindow].classNames; end,
		set		= function(i) OZ_Config[OZ_OptionsCurrentWindow].classNames = i; end,
		combat_edit = 1,
		clickSafe = function() return 1; end,
		width	=	256,
	},
};

function OzFrameLayoutStart(frame,maxW)
	frame.w,frame.h,frame.lw,frame.lh = 0,0,0,0
	frame.width = maxW
end

function OzFrameLayoutAdd(parent,frame)
	-- Format each item & position it
	if parent.w+frame.width > parent.width then
		parent.w = 0
		parent.h += parent.lh
		parent.lh = 0
	end
	frame:SetPoint("TOPLEFT", parent.frame, "TOPLEFT", parent.w, parent.h)
	frame:SetWidth(frame.width)
	frame:SetHeight(frame.height)
	parent.w = parent.w + frame.width
	if parent.w > parent.lw then parent.lw = parent.w end
	if frame.height > parent.lh then parent.lh = frame.height	end
end

function OzFrameLayoutEnd(frame)
	frame.width = frame.w
	frame.height = frame.h + frame.lh
end

function OzBuildRadio(desc, parent, name)
	if not desc.frame then
		desc.frame = CreateFrame( "Frame", name, parent.frame )
		desc.options = {}
	end

	local i,option
	local dest = desc.options
	OzFrameLayoutStart(desc.frame,desc.width)
	for i,option in ipairs(desc.type[2]) do
		local frame
		if not dest[i] then
			local fName = string.format("%sRadio%d",i)
			frame = CreateFrame( "CheckButton", fName, desc.frame, "SendMailRadioButtonTemplate" )
			frame.control = desc
			frame.SetScript("OnClick", function() OzRadioClick( this ); end )
			frame.value = desc.type[3][i]

			frame.text = getglobal( fName.."Buttontext" )
			frame.text:SetJustifyH("LEFT")
			frame.text:SetText( option )
			frame.width = 32 + strlen(option) * 10
			frame.height = 32
			dest[i] = frame
		else
			frame = dest[i]
		end
		-- Set the current state
		local v = desc.get()
		if v == frame.value then
			frame:SetChecked(1)
		else
			frame:SetChecked(nil)
		end

		-- Format each item & position it
		OzFrameLayoutAdd(desc.frame, frame)
	end
	OzFrameLayoutEnd(desc.frame)
end

function OzRadioClick(self)
	-- Check if we can be edited in combat
	local control = self.control
	if InCombatLockdown() and not control.combat_edit then
		return
	end

	self:SetChecked(1)

	local i,button
	local val = self.value
	for i,button in ipairs(control.options) do
		if button.value ~= val then
			button:SetChecked(nil)
		end
	end
	if control.get() ~= val then
		control.set(val)
	end
end

function OzBuildHeading(desc, parent, name)
	local frame = desc.frame
	if not frame then
		frame = CreateFrame( "FontString", desc.name, parent , desc.type[2])
		frame.width = desc.width
		frame.height = 32
		frame:SetJustifyH("LEFT")
		frame:SetText( desc.text )
		desc.frame = frame
	end	
end

function OzBuildOptionPanel(desc, parent)
	local i,panel

	if not desc.frame then
		desc.frame = CreateFrame( "Frame", desc.name, parent )
	end

	OzFrameLayoutStart(desc.frame,desc.width)
	for i,panel in ipairs(desc) do
		local j,widget
			for j,widget in ipairs(panel) do
			if not widget.frame then
				if widget.type[1].build then
					widget.type[1].build(widget,desc,string.format("%sp%d%d",desc.name,i,j))
				end
			end
			if widget.frame then
				OzFrameLayoutAdd(desc.frame,widget.frame)
			end
		end		
	end
	OzFrameLayoutEnd(desc.frame)
end
--]]