local lasttab, niagara_present
local options = InterfaceOptionsFrame
local ldb_obj = LibStub("LibDataBroker-1.1"):NewDataObject("Opticon", {
	icon = "Interface\\Icons\\INV_Gizmo_02.png",
	label = "Opticon"
})

if Niagara and Niagara.OnClick then niagara_present = true end

function ldb_obj.OnTooltipShow(tip)
	tip:AddLine("Opticon: A DataBroker Plugin")
	tip:AddLine(" ")
	tip:AddLine("|cff69b950Left-Click:|r |cffeeeeeeToggles the Blizzard Addon options frame.|r")
	tip:AddLine("|cff69b950Right-Click:|r |cffeeeeeeToggles the Blizzard Game options frame.|r")

	if niagara_present then
		tip:AddLine("|cff69b950Alt + Click:|r |cffeeeeeeOpens the Niagara options frame.|r")
	end

	tip:AddLine("|cff69b950Shift + Click:|r |cffeeeeeeRestarts the graphics renderer.|r")
	tip:AddLine("|cff69b950Control + Click:|r |cffeeeeeeReloads the User Interface.|r")
end

function ldb_obj.OnClick(_, tab)
	if IsAltKeyDown() and niagara_present then
		Niagara:OnClick()

	elseif IsShiftKeyDown() then
		RestartGx()

	elseif IsControlKeyDown() then
		ReloadUI()

	else
		tab = tab == "LeftButton" and 2 or 1
	
		if lasttab == tab and options:IsVisible() then
			options:Hide()
			lasttab = nil
			return
		end
	
		options.selectedTab = tab
		PanelTemplates_UpdateTabs(options)
		InterfaceOptionsFrame_TabOnClick()
		options:Show()
	
		lasttab = tab
	end
end