local MINOR_VERSION = tonumber(("$Revision: 72099 $"):match("%d+"))

local tablet = AceLibrary("Tablet-2.0")
local L = AceLibrary("AceLocale-2.2"):new("OptiTaunt")
OptiTaunt = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0")

OptiTaunt.TOCversion = GetAddOnMetadata("OptiTaunt", "Version")
OptiTaunt.version = OptiTaunt.TOCversion.." - Build "..MINOR_VERSION
OptiTaunt.revision = MINOR_VERSION


function OptiTaunt:OnInitialize()
	self:RegisterDB("OptiTauntDB", "OptiTauntDBPC")
	self:RegisterDefaults("profile", {
				
		--messages
		resistmessage=L["resistmessage"],
		immunemessage=L["immunemessage"],
		abilitymessage=L["abilitymessage"],
				
		-- ouput
		outputsettings = {
			["Growl"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
			["Frenzied Regeneration"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
			["Challenging Roar"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
			["Taunt"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
			["Mocking Blow"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
			["Shield Wall"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
			["Last Stand"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
			["Challenging Shout"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
			["Righteous Defense"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
			["Avenger's Shield"] = {
						raid = true,
						say = false,
						whisper = true,
						raidwarning = false,
						channel = {},
			},
		},
			
		--options
		announceresist = true,
		announceimmune = true,
		announceability = true,
		
		giveAudioWarning = true,
		aggroCheck = true,
		whisperWarriors = false,
		pvpCheck = true,
	} )
	
	self:RegisterChatCommand(L["Slash-Commands"], self.options)
	self.opt = self.db.profile
	self.OnMenuRequest = self.options
	
	self.tauntsoundfile = "Interface\\AddOns\\OptiTaunt\\Sounds\\combo.ogg"
	self.tauntcount = 0
	self.tauntresistcount = 0
	self.tauntresistpercent = 0
	
	-- Only show class dependent abilities and do some other class depending stuff
	_, self.playerclass	= UnitClass("player")
	if (self.playerclass == "DRUID") then
		self.ability_list = { L["Growl"], L["Challenging Roar"], L["Frenzied Regeneration"]}
	elseif (self.playerclass == "WARRIOR") then 
		self.ability_list = { L["Taunt"], L["Mocking Blow"], L["Shield Wall"], L["Last Stand"], L["Challenging Shout"] }
		
		--check for talent: improved shieldwall
		_, _, _, _, self.impshieldwallrank, _, _, _ = GetTalentInfo(3, 13);
		if (self.impshieldwallrank == 0) then
			self.shieldwallduration = "10"
		elseif (self.impshieldwallrank == 1) then
			self.shieldwallduration = "13"
		elseif (self.impshieldwallrank == 2) then
			self.shieldwallduration = "15"
		end
	
	elseif (self.playerclass == "PALADIN") then
		self.ability_list = { L["Righteous Defense"], L["Avenger's Shield"] }
	
	else
		self.ability_list = { }
	end
	
	-- Add custom channels
	OptiTaunt:CreateOutputSettings(self.ability_list)
	
	-- set to true for debugging messages
	self.isDebug = false
end


function OptiTaunt:OnProfileEnable()
	self.opt = self.db.profile
end


function OptiTaunt:OnEnable()
    self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")	
	self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	self:RegisterEvent("CHANNEL_UI_UPDATE")
end


function OptiTaunt:dbg(msg)
	if ( self.isDebug ) then
		OptiTaunt:Print("OptiTaunt: "..msg)
	end
end


function OptiTaunt:CreateOutputSettings(ability_list)

	--something might have changed, so rebuild ability menu from scratch to be safe
	local ability, activate
	self.channels = {GetChannelList()}
	self.options.args.ability_options.args = {}
				
	--rebuild abilites
	for ability=1,table.getn(ability_list) do
		self.options.args.ability_options.args[ability] = {}
		self.options.args.ability_options.args[ability] = {
			type  = 'group',
			name  = ability_list[ability],
			desc  = ability_list[ability],
			args  = {},
		}
	end
		
	--rebuild ability options
	for ability=1,table.getn(ability_list) do
		
		--raid/group
		self.options.args.ability_options.args[ability].args[1] = {
		type = 'toggle',
		order = 2,
		name = L["opt_name_raidparty"],
		desc = L["opt_desc_raidparty"],
		get = function()
				return self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].raid
			  end,
		set = function()
			    self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].raid = 
				not self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].raid
		      end,
		}
		
		--say
		self.options.args.ability_options.args[ability].args[2] = {
		type = 'toggle',
		order = 1,
		name = L["opt_name_say"],
		desc = L["opt_desc_say"],
		get = function()
				return self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].say
			  end,
		set = function()
			    self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].say = 
				not self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].say
		      end,
		}
		
		--whisper (disabled for activation announcements)
		if (L:GetReverseTranslation(ability_list[ability]) ~= "Challenging Roar") and 
		   (L:GetReverseTranslation(ability_list[ability]) ~= "Frenzied Regeneration") and 
		   (L:GetReverseTranslation(ability_list[ability]) ~= "Shield Wall") and 
		   (L:GetReverseTranslation(ability_list[ability]) ~= "Last Stand") and 
		   (L:GetReverseTranslation(ability_list[ability]) ~= "Challenging Shout") then
			OptiTaunt.options.args.ability_options.args[ability].args[3] = {
				type = 'toggle',
				order = 4,
				name = L["opt_name_autowhisper"],
				desc = L["opt_desc_autowhisper"],
				get = function()
						return self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].whisper
					  end,
				set = function()
						self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].whisper = 
						not self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].whisper
					  end,
				}
		else
			self.options.args.ability_options.args[ability].args[3] = nil
		end
		
		--Raidwarning
		self.options.args.ability_options.args[ability].args[4] = {
		type = 'toggle',
		order = 3,
		name = L["opt_name_raidwarning"],
		desc = L["opt_desc_raidwarning"],
		get = function()
				return self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].raidwarning
			  end,
		set = function()
			    self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].raidwarning = 
				not self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].raidwarning
		      end,
		}
		
		--custom channels
		for i=5,table.getn(self.channels)/2+4 do
			self.options.args.ability_options.args[ability].args[i] = {
				type = 'toggle',
				name = self.channels[(i-4)*2],
				desc = self.channels[(i-4)*2],
			
				get = 	function()
							local rc = false
							for j=1,table.getn(self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].channel) do
								if self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].channel[j] == self.channels[(i-4)*2] then 
									rc = true 
								end
							end
							return rc
						end,
				set = 	function()
							local deletion = false
							for j=1,table.getn(self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].channel) do
								if self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].channel[j] == self.channels[(i-4)*2] then
									table.remove(self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].channel, j)
									deletion=true
								end
							end
							if not deletion then
								table.insert(self.db.profile.outputsettings[L:GetReverseTranslation(ability_list[ability])].channel, self.channels[(i-4)*2])
							end
						end,
				}
		end
	end
end


function OptiTaunt:OnTooltipUpdate()
	
	if (self.tauntresistcount == 0) then
		self.tauntresistpercent = 0
	else
		self.tauntresistpercent = math.floor((self.tauntresistcount / self.tauntcount) * 10000)/100
	end
		
	tablet:SetHint(L["Tooltip"])
	
	local cat = tablet:AddCategory(
       'text', L["Statistics"],
       'columns', 2,
       'child_textR', 1,
       'child_textG', 1,
       'child_textB', 0,
       'child_textR2', 1,
       'child_textG2', 1,
       'child_textB2', 1
   )
   
   cat:AddLine(
       'text', L["Taunts"],
       'text2', self.tauntcount
   )
   
   cat:AddLine(
       'text', L["Resisted"],
       'text2', self.tauntresistcount.." ("..self.tauntresistpercent.."%)"
   ) 
    
end


function OptiTaunt:CHANNEL_UI_UPDATE()
	
	OptiTaunt:dbg("---Entering OptiTaunt:CHANNEL_UI_UPDATE---")
	
	OptiTaunt:CreateOutputSettings(self.ability_list)
end


function OptiTaunt:COMBAT_LOG_EVENT_UNFILTERED(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, ...)
	
	--[[local message = format("%s> %s, %s, %s, %s, %s, %s, %s",
	                       timestamp, eventtype, srcGUID, srcName or "nil", srcFlags or "nil", dstGUID, dstName or "nil", dstFlags or "nil");
	for i = 9, select("#", ...) do
		message = message..", "..(select(i, ...) or "nil");
	end
	OptiTaunt:dbg(message)]]
	
	if (eventtype == "SPELL_MISSED") and (srcGUID == UnitGUID("player")) then
		OptiTaunt:Spell_Missed(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags,...)
	end

end

--this is were we actually check for resisted/immune taunts and decide wether to report them or not
function OptiTaunt:Spell_Missed(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellId, spellName, spellSchool, missType)
	
	OptiTaunt:dbg("---Entering OptiTaunt:Spell_Missed---")
	
	if (missType == "RESIST") or (missType == "IMMUNE") then
	
	OptiTaunt:dbg("missType: "..missType)
	OptiTaunt:dbg("spellName: "..spellName)
	
		--check if a spell resisted we are looking for
		if (spellName == L["Taunt"])
		or (spellName == L["Growl"])
		--or (spellName == "Zorn")
		or (spellName == L["Mocking Blow"])
		or (spellName == L["Righteous Defense"])
		or (spellName == L["Avenger's Shield"]) then
			
			local doAlert=true
			
			--when aggrocheck is enabled we have to check if we already have aggro
			if (self.db.profile.aggroCheck) and (UnitIsUnit("player","targettarget")) then
				doAlert=false
			end
			
			--when pvpcheck is enabled we check if our target is another player
			if (doAlert) and (self.db.profile.pvpCheck) and (UnitPlayerControlled("target")) then
				doAlert=false
			end
			
			--if all checks were successful we give an alert
			if (doAlert) then
				if (missType == "RESIST") then
					self.tauntresistcount = self.tauntresistcount + 1
					if self.db.profile.announceresist then 
						OptiTaunt:giveAlert(spellName, dstName, missType)
						OptiTaunt:giveAudioAlert()
					end
				elseif (missType == "IMMUNE" and self.db.profile.announceimmune) then
					OptiTaunt:giveAlert(spellName, dstName, missType)
					OptiTaunt:giveAudioAlert()
				end
			end
		end
	end
	OptiTaunt:dbg("---Leaving OptiTaunt:Spell_Missed---")
end


--this checks for additional abilities being activated
function OptiTaunt:UNIT_SPELLCAST_SUCCEEDED(unit, ability, rank)
	if (ability == L["Taunt"]) then
		self.tauntcount = self.tauntcount + 1
	end
	
	if (ability == L["Growl"]) then
		self.tauntcount = self.tauntcount + 1
	end
	
	if (ability == L["Mocking Blow"]) then
		self.tauntcount = self.tauntcount + 1
	end
	
	if (ability == L["Avenger's Shield"]) then
		self.tauntcount = self.tauntcount + 1
	end
	
	if (ability == L["Righteous Defense"]) then
		self.tauntcount = self.tauntcount + 1
	end	
		
	--- this is for announcements
	if (ability == L["Shield Wall"]) then
		self.abilityduration=self.shieldwallduration
		if (self.db.profile.announceability) then
			OptiTaunt:giveAlert(ability, _, "ABILITY")
		end
	end
	
	if (ability == L["Last Stand"]) then
		self.abilityduration="20"
		if (self.db.profile.announceability) then
			OptiTaunt:giveAlert(ability, _, "ABILITY")
		end
	end
	
	if (ability == L["Frenzied Regeneration"]) then
		self.abilityduration="10"
		if (self.db.profile.announceability) then
			OptiTaunt:giveAlert(ability, _, "ABILITY")
		end
	end
	
	if (ability == L["Challenging Shout"]) then
		self.abilityduration="6"
		if (self.db.profile.announceability) then
			OptiTaunt:giveAlert(ability, _, "ABILITY")
		end
	end
	
	if (ability == L["Challenging Roar"]) then
		self.abilityduration="6"
		if (self.db.profile.announceability) then
			OptiTaunt:giveAlert(ability, _, "ABILITY")
		end
	end
end	


function OptiTaunt:giveAlert(ability,mob,msgtype)
	
	-- parse warningmessage
	if (msgtype == "RESIST") then
		self.warningmessage = string.gsub(string.gsub(self.db.profile.resistmessage, "{t}", mob), "{a}", ability)
	elseif (msgtype == "IMMUNE") then
		self.warningmessage = string.gsub(string.gsub(self.db.profile.immunemessage, "{t}", mob), "{a}", ability)
	elseif (msgtype == "ABILITY") then
		self.warningmessage = string.gsub(string.gsub(self.db.profile.abilitymessage, "{a}", ability), "{d}", self.abilityduration)
	end
	
	-- Say
	if self.db.profile.outputsettings[L:GetReverseTranslation(ability)].say then
		SendChatMessage(self.warningmessage, "SAY")
	end
	
	-- Party- or Raidchat warning
	if self.db.profile.outputsettings[L:GetReverseTranslation(ability)].raid then
		if (GetNumRaidMembers() > 0) then
			SendChatMessage(self.warningmessage, "RAID")
		elseif (GetNumPartyMembers() > 0) then
			SendChatMessage(self.warningmessage, "PARTY")
		end
	end
	
	-- Raidwarning
	if self.db.profile.outputsettings[L:GetReverseTranslation(ability)].raidwarning then
		if (GetNumRaidMembers() > 0) and IsRaidOfficer() then
			SendChatMessage(self.warningmessage, "RAID_WARNING")
		end
	end
	
	-- custom channel warning
	for j=1,table.getn(self.db.profile.outputsettings[L:GetReverseTranslation(ability)].channel) do
		if (self.db.profile.outputsettings[L:GetReverseTranslation(ability)].channel[j] ~= nil) then 
			local index = GetChannelName(self.db.profile.outputsettings[L:GetReverseTranslation(ability)].channel[j])
			if (index~=nil) then 
				SendChatMessage(self.warningmessage, "CHANNEL", nil, index); 
			end
		end
	end
	
	if (msgtype ~= "ABILITY") then
			
		-- Autowhisper
		if self.db.profile.outputsettings[L:GetReverseTranslation(ability)].whisper and (UnitName("targettarget") ~= nil) and (UnitPlayerControlled("targettarget")) then
			_, englishClass = UnitClass("targettarget");
		
			if (not self.db.profile.whisperWarriors and englishClass == "WARRIOR") then
			-- This (below) is planned but so far we are not sure if a we are talking to a tankadin or a feral druid...
			--if (not self.db.profile.whisperWarriors and englishClass == "WARRIOR" or "PALADIN" or "DRUID") then
				--
			else
				-- we will do class dependent warnings, just for fun
				if (englishClass == "WARRIOR") then
					self.ResistWhisperMessage = L["Resist-Whisper-Message-Warrior"]
				elseif (englishClass == "DRUID") then
					self.ResistWhisperMessage = L["Resist-Whisper-Message-Druid"]
				elseif (englishClass == "MAGE") then
					self.ResistWhisperMessage = L["Resist-Whisper-Message-Mage"]
				elseif (englishClass == "WARLOCK") then
					self.ResistWhisperMessage = L["Resist-Whisper-Message-Warlock"]
				elseif (englishClass == "PALADIN") then
					self.ResistWhisperMessage = L["Resist-Whisper-Message-Paladin"]
				elseif (englishClass == "PRIEST") then
					self.ResistWhisperMessage = L["Resist-Whisper-Message-Priest"]
				elseif (englishClass == "HUNTER") then
					self.ResistWhisperMessage = L["Resist-Whisper-Message-Hunter"]
				elseif (englishClass == "ROGUE") then
					self.ResistWhisperMessage = L["Resist-Whisper-Message-Rogue"]
				else
					self.ResistWhisperMessage = L["Resist-Whisper-Message-Shaman"]
				end
				
				SendChatMessage(self.warningmessage.." "..self.ResistWhisperMessage, "WHISPER", nil, UnitName("targettarget"));
			end
		end
	end
end

function OptiTaunt:giveAudioAlert()
	if (self.db.profile.giveAudioWarning) then
			PlaySound("GAMEHIGHLIGHTFRIENDLYUNIT"); --workaround from wowace-forums for buggy soundsystem
			PlaySoundFile(self.tauntsoundfile);
	end
end

--Toggle Options
function OptiTaunt:IsShowInRaidAnnouncement()
    return self.db.profile.showInRaidAnnouncement
end

function OptiTaunt:ToggleShowInRaidAnnouncement()
    self.db.profile.showInRaidAnnouncement = not self.db.profile.showInRaidAnnouncement
end

function OptiTaunt:IsShowInRaidPartyChat()
    return self.db.profile.showInRaidPartyChat
end

function OptiTaunt:ToggleShowInRaidPartyChat()
    self.db.profile.showInRaidPartyChat = not self.db.profile.showInRaidPartyChat
end

function OptiTaunt:IsAutoWhisper()
    return self.db.profile.autoWhisper
end

function OptiTaunt:ToggleAutoWhisper()
    self.db.profile.autoWhisper = not self.db.profile.autoWhisper
end

function OptiTaunt:IsGiveAudioWarning()
    return self.db.profile.giveAudioWarning
end

function OptiTaunt:ToggleGiveAudioWarning()
    self.db.profile.giveAudioWarning = not self.db.profile.giveAudioWarning
end

function OptiTaunt:IsAggroCheck()
    return self.db.profile.aggroCheck
end

function OptiTaunt:ToggleAggroCheck()
    self.db.profile.aggroCheck = not self.db.profile.aggroCheck
end

function OptiTaunt:IsWhisperWarriors()
    return self.db.profile.whisperWarriors
end

function OptiTaunt:ToggleWhisperWarriors()
    self.db.profile.whisperWarriors = not self.db.profile.whisperWarriors
end

function OptiTaunt:IsPvPCheck()
    return self.db.profile.pvpCheck
end

function OptiTaunt:TogglePvPCheck()
    self.db.profile.pvpCheck = not self.db.profile.pvpCheck
end

function OptiTaunt:IsTaunt()
    return self.db.profile.taunt
end

function OptiTaunt:ToggleTaunt()
    self.db.profile.taunt = not self.db.profile.taunt
end

function OptiTaunt:IsGrowl()
    return self.db.profile.growl
end

function OptiTaunt:ToggleGrowl()
    self.db.profile.growl = not self.db.profile.growl
end

function OptiTaunt:IsMockingblow()
    return self.db.profile.mockingblow
end

function OptiTaunt:ToggleMockingblow()
    self.db.profile.mockingblow = not self.db.profile.mockingblow
end

function OptiTaunt:IsRighteousdefense()
    return self.db.profile.righteousdefense
end

function OptiTaunt:ToggleRighteousdefense()
    self.db.profile.righteousdefense = not self.db.profile.righteousdefense
end

function OptiTaunt:IsAvengersshield()
    return self.db.profile.avengersshield
end

function OptiTaunt:ToggleAvengersshield()
    self.db.profile.avengersshield = not self.db.profile.avengersshield
end

function OptiTaunt:IsShieldwall()
    return self.db.profile.shieldwall
end

function OptiTaunt:ToggleShieldwall()
    self.db.profile.shieldwall = not self.db.profile.shieldwall
end

function OptiTaunt:IsLaststand()
    return self.db.profile.laststand
end

function OptiTaunt:ToggleLaststand()
    self.db.profile.laststand = not self.db.profile.laststand
end

function OptiTaunt:IsFrenziedregeneration()
    return self.db.profile.frenziedregeneration
end

function OptiTaunt:ToggleFrenziedregeneration()
    self.db.profile.frenziedregeneration = not self.db.profile.frenziedregeneration
end

function OptiTaunt:IsChallengingshout()
    return self.db.profile.challengingshout
end

function OptiTaunt:ToggleChallengingshout()
    self.db.profile.challengingshout = not self.db.profile.challengingshout
end

function OptiTaunt:IsChallengingroar()
    return self.db.profile.challengingroar
end

function OptiTaunt:ToggleChallengingroar()
    self.db.profile.challengingroar = not self.db.profile.challengingroar
end

function OptiTaunt:GetResistMessage()
	return self.db.profile.resistmessage
end
	
function OptiTaunt:SetResistMessage(arg1)
	self.db.profile.resistmessage = arg1
end

function OptiTaunt:GetImmuneMessage()
	return self.db.profile.immunemessage
end
	
function OptiTaunt:SetImmuneMessage(arg1)
	self.db.profile.immunemessage = arg1
end
                   
function OptiTaunt:GetAbilityMessage()
	return self.db.profile.abilitymessage
end
	
function OptiTaunt:SetAbilityMessage(arg1)
	self.db.profile.abilitymessage = arg1
end

function OptiTaunt:ResetCounters()
	self.tauntcount = 0
	self.tauntresistcount = 0
	self.tauntresistpercent = 0
end

function OptiTaunt:IsAnnounceResist()
	return self.db.profile.announceresist
end

function OptiTaunt:ToggleAnnounceResist()
	self.db.profile.announceresist = not self.db.profile.announceresist
end

function OptiTaunt:IsAnnounceImmune()
	return self.db.profile.announceimmune
end

function OptiTaunt:ToggleAnnounceImmune()
	self.db.profile.announceimmune = not self.db.profile.announceimmune
end

function OptiTaunt:IsAnnounceAbility()
	return self.db.profile.announceability
end

function OptiTaunt:ToggleAnnounceAbility()
	self.db.profile.announceability = not self.db.profile.announceability
end
