
OPENSTUFF_STUFF  = {
	[5523] = true,  -- Small Barnacled Clam
	[5524] = true,  -- Thick-shelled Clam
	[7973] = true,  -- Big-mouth Clam
	[15874] = true,  -- Soft-shelled Clam
	[32724] = true,  -- Sludge-covered Object 
	[24476] = true,  -- Jaggal Clam
	[33857] = true, -- Crate of Meat
	[33844] = true, -- Barrel of Fish
	[9276] = true, --  Pirate's Footlocker
	[35313] = true, -- Bloated Barbed Gill Trout
	[35232] = true, -- Shattered Sun Supplies
	[34863] = true, -- Bag of Fishing Treasures
	[37586] = true, --ǹ
	
}

local function ForbiddenFrame()
	local auctionframe = false
	if (AuctionFrame and AuctionFrame:IsVisible()) then
		auctionframe = true
	end
	if (LootFrame:IsVisible() or
		TradeFrame:IsVisible() or
		BankFrame:IsVisible() or
		MailFrame:IsVisible() or
		auctionframe or
		MerchantFrame:IsVisible()) then
		return true
	else
		return false
	end
end
	
local function ExtractID(link)
	local _,_, _, id = string.find(link, "|c(%x+)|Hitem:(%d+):%d+:%d+:%d+:%d+:%d+:%-?%d+:%-?%d+|h%[(.-)%]|h|r")
	return tonumber(id)
end
	
local function OnEvent()
	if not ForbiddenFrame() then
		OpenStuff()
	end
end


local frame = CreateFrame("Frame")
frame:Hide()
frame:SetScript("OnEvent", OnEvent)
frame:RegisterEvent("BAG_UPDATE")
frame:RegisterEvent("PLAYER_MONEY")


function OpenStuff()
	for bag = 0, 4 do
		for slot = 1, GetContainerNumSlots(bag) do
			local link = GetContainerItemLink(bag, slot)
			if link then
				local id = ExtractID(link)
				if OPENSTUFF_STUFF[id] then
					UseContainerItem(bag, slot)
				end
			end
		end
	end
end
