-- English/Default localisation

-- Shaman weaponbuff names (e.g. Rockbiter Weapon) 
-- do NOT match ENCHANT_APPLIED event spellnames (e.g. Rockbiter 2)
-- We need a function to turn the buffname the spellname
function OW_tenchtospell(buff)
  return string.gsub(buff," [0-9]"," Weapon")
end

-- Rogue
-- Common part of every Rogue Poisons name (as appears in the combat log when you apply it)
OW_poison = "POISON"; 

-- Temporary Enchants
-- These are purely for the reminder - e.g. Fred needs Deadly Poison VII "Mainhand"
-- Note: They're used in string.gsub so no ()s or[]s etc.
OW_mh = " Mainhand";
OW_oh = " Offhand";

-- Buff reminders
-- Format player and spell into the reminder (English: (player needs spell")
function OW_needs(player,spell)
  return player .. " needs " .. spell;
end

-- Deferring Buffs
-- Part of the errrmessage which appears in the ErrorFrame when a more powerful spell already exists on the target
OW_morepowerful = "MORE POWERFUL SPELL";
