--Savedvariables
OW_spell1 = ""; -- Aspects and Auras
OW_spell2 = ""; -- Blessings, Armors and Shields
OW_tench1 = ""; -- MH Temp Enchant
OW_tench2 = ""; -- OH Temp Enchant

OW_buffspell = "";  -- spell to cast 
OW_bufftarget = ""; -- target to cast on

OW_lasttime = 0; -- tracks GCD
OW_lastcheck = 0; -- tracks last buffreminder
OW_checkduration = 5; -- time between buffreminders - varied in the code...
OW_lastreminder = "";

OW_combatspell = ""; -- default/in-combat mousewheelup
OW_combatspell2 = ""; -- default/in-combat mousewheeldown

-- Initialise list of targets - TARGET, RAID1-40, PARTY1-5
OW_targetlist = {"TARGET"}
for x=1,40 do
  table.insert(OW_targetlist,"RAID" .. x)
end
for x=1,5 do
  table.insert(OW_targetlist,"PARTY" .. x)
end
OW_tpos = 1; -- where in the targetlist we're upto

_,OW_class = UnitClass("PLAYER"); -- Store player class (English so no localisation needed)

-- Talent inspection - player name and talent table
OW_inspectname = "";
OW_inspecttime = 0;
OW_inspectDB = {};

OW_defertench = "";
OW_MHExp = 0;
OW_OHExp = 0;

OW_situbuffs = {OW_thorns,OW_lshield, OW_wshield, OW_ubreath, OW_dinvis, OW_amplify, OW_dampen, OW_bosa}
OW_situbuffdb = {}; 

OW_failed = {}; -- table of players/buffs which failed
OW_lastbuffspell = "";  -- last spell 
OW_lastbufftarget = ""; -- last target

OW_plugged = false;

-- ON_ENTER_WORLD event
function OW_OnEnterWorld()
  DEFAULT_CHAT_FRAME:AddMessage("OWheely! 0.8 Pre-Release Loaded.");
  -- Handle 0.7 and earlier savedvariables
  if OW_lastaas then 
    OW_spell1 = OW_lastaas
  end
  if OW_lastbb then 
    OW_spell2 = OW_lastbb
  end
  -- Initialise 'in-combat' spells/targets
  if (OW_class == "PRIEST") and (IsUsableSpell(OW_dispelmagic)) then
    OW_combatspell = "/stopcasting\n/cast [target=mouseover,exists] [ ] " .. OW_dispelmagic;
    OW_combatspell2 = OW_combatspell;
  elseif (OW_class == "MAGE") then
    if (IsUsableSpell(OW_counterspell)) then 
      OW_combatspell = "/stopcasting [combat]\n/cast [target=mouseover,exists,harm,combat] [harm,combat] " .. OW_counterspell; 
    end; 
    if (IsUsableSpell(OW_spellsteal)) then 
      OW_combatspell2 = "/stopcasting [combat]\n/cast [target=mouseover,exists,harm,combat] [harm,combat] " .. OW_spellsteal; 
    end; 
  elseif (OW_class == "SHAMAN") then
    if (IsUsableSpell(OW_earthshock)) then
      OW_combatspell = "/stopcasting [combat]\n/cast [form:0,target=mouseover,exists,harm,combat] [form:0,harm,combat] " .. OW_earthshock;
    end; 
    if (IsUsableSpell(OW_purge)) then
      OW_combatspell2 = "/stopcasting [combat]\n/cast [form:0,target=mouseover,exists,harm,combat] [form:0,harm,combat] " .. OW_purge;
    end; 
  elseif (OW_class == "DRUID") then
    if (IsUsableSpell(OW_curepoison)) then
      OW_combatspell = "/stopcasting\n/cast [form:0,target=mouseover,exists,help] [form:0,help] " .. OW_curepoison; 
    end; 
    if (IsUsableSpell(OW_removecurse)) then
      OW_combatspell2 = "/stopcasting\n/cast [form:0,target=mouseover,exists,help] [form:0,help] " .. OW_removecurse;
    end;
  elseif (OW_class == "PALADIN") then
    if (IsUsableSpell(OW_cleanse)) then
      OW_combatspell = "/stopcasting\n/cast [target=mouseover,exists,help] [help] " .. OW_cleanse;
    elseif (IsUsableSpell(OW_purify)) then 
      OW_combatspell = "/stopcasting\n/cast [target=mouseover,exists,help] [help] " .. OW_purify;
    end;
  end; 
  OW_BuffFrame:Click(); -- ensures defaults are setup correctly...
  
  -- Keybindings GO
  SetBindingClick("MOUSEWHEELUP", "OW_BuffFrame","MWUP");
  SetBindingClick("MOUSEWHEELDOWN", "OW_BuffFrame","MWDN");
end

-- COMBAT_LOG_EVENT_UNFILTERED event 
function OW_Combat()
  if (arg2) and (arg2 == "SPELL_CAST_SUCCESS") and (arg4) and (arg4 == UnitName("PLAYER")) and arg9 then 
    if (not arg7) then
      arg7 = arg4; -- no target (arg7) means us (arg4)!
    end;
    local spellname = GetSpellInfo(arg9);
    if (spellname) and (spellname ~= "") then -- valid spell?
      if (arg7 == arg4) then -- casting on ourselves 
        if (spellname == OW_bok) or (spellname == OW_bow) or (spellname == OW_bom) or (spellname == OW_bos) or
           (spellname == OW_icearmor) or (spellname == OW_frostarmor) or (spellname == OW_magearmor) or (spellname == OW_moltenarmor) or
           (spellname == OW_demonskin) or (spellname == OW_demonarmor) or (spellname == OW_felarmor) or
           (spellname == OW_lshield) or (spellname == OW_wshield) or  (spellname == OW_eshield) then 
              OW_spell2 = spellname;
        end;
        if (OW_IsAspect(spellname) and (spellname ~= OW_aotc) and (spellname ~= OW_aotp)) or
           (OW_IsAura(spellname) and (spellname ~= OW_crusaura)) then
              OW_spell1 = spellname;
        end;
      end;
      -- because we're using NAMES we need to check they're valid units
      -- only members of our party/raid will return true - if they leave party/raid we can't rebuff em
      if UnitExists(arg7) then 
      for i,sn in pairs(OW_situbuffs) do
        if spellname == sn then
          if not OW_situbuffdb[arg7] then
            OW_situbuffdb[arg7] = {}
          end
          OW_situbuffdb[arg7][spellname]  = GetTime();
        end
      end
      end
    end;
  elseif (arg2) and (arg2 == "ENCHANT_APPLIED") and (arg4) and (arg4 == UnitName("PLAYER")) and (arg9) then  
    local spellname = OW_tenchtospell(arg9); -- translate the tenchname (no SpellId available) to the spellname 
    if spellname and 
       ((OW_class == "ROGUE" and strfind(strupper(spellname),strupper(OW_poison))) or
        (OW_class == "SHAMAN" and spellname == OW_rockbiter or spellname == OW_flametongue or 
         spellname == OW_frostbrand or spellname == OW_windfury)) then
      local mhw = GetInventoryItemLink("PLAYER",16);
      local ohw = GetInventoryItemLink("PLAYER",17);
      if mhw and (strfind(mhw,arg11)) and ohw and (strfind(ohw,arg11)) then -- identical weapons
        -- GetWeaponEnchantInfo() will show which weapon was enchanted (longest time remaining) 
        -- BUT - it's not been updated yet - the server is slow about this...
        -- so we store the poisonname and expiry times and check them later (in OW_Update)
        OW_defertench = spellname;
        _,OW_MHExp,_,_,OW_OHExp = GetWeaponEnchantInfo();
        if not OW_MHExp then OW_MHExp = 0; end;
        if not OW_OHExp then OW_OHExp = 0; end;
      elseif mhw and (strfind(mhw,arg11)) then
        OW_tench1 = spellname;
      elseif ohw and (strfind(ohw,arg11)) then
        OW_tench2 = spellname;
      end;
    end;
  elseif (arg2) and (arg2 == "SPELL_CAST_FAILED") and (arg4) and (arg4 == UnitName("PLAYER")) and (arg10) then
    -- "A more powerful spell" failures do NOT have a 'target' so we can't tell WHO they failed ON
    -- We check if it's the last buffspell cast and if it is, assume the target was our last bufftarget
    if OW_lastbuffspell and OW_lastbufftarget and arg10 == OW_lastbuffspell and strfind(strupper(arg12),strupper(OW_morepowerful)) then 
      OW_failed[arg10 .. UnitName(OW_lastbufftarget)] = GetTime();
    end;
  end; 
end;

-- ON_UPDATE event
function OW_Update()
  -- we deferred a temp. enchant application as we're using identical weapons
  -- check to see if the temp. enchant expiry has updated (showing which weapon was enchanted)
  if (OW_defertench ~= "") then
    local _,mhexp,_,_,ohexp = GetWeaponEnchantInfo();
    if not mhexp then mhexp = 0; end;
    if not ohexp then ohexp = 0; end;
    if mhexp > OW_MHExp then -- shows we applied it to MH
      OW_tench1 = OW_defertench
      OW_defertench = "";
    elseif ohexp and OW_OHExp and ohexp > OW_OHExp then -- shows we applied it to OH
      OW_tench2 = OW_defertench
      OW_defertench = "";
    end;
  end;
  -- Out of combat - every 5 secs - check for buffs needed
  -- NOT when resting and NOT when in raid/not in a BG
  if (GetTime() - OW_lastcheck > OW_checkduration) and
     (not IsResting()) and
     ((GetNumRaidMembers() == 0) or (OW_inbg)) then
    OW_lastcheck = GetTime();
    OW_SetSpellCast();
    -- ignore Hunter and Paladin 'speed' aspect/auras
    if (OW_buffspell ~= "") and (OW_buffspell ~= OW_aotp) and (OW_buffspell ~= OW_aotc) then
      if ((not UnitAffectingCombat("PLAYER")) and (not OW_IsAspect(OW_buffspell))) or 
         ((UnitAffectingCombat("PLAYER")) and (OW_class == "PALADIN") and OW_IsAura(OW_buffspell)) or
         ((UnitAffectingCombat("PLAYER")) and (OW_class == "HUNTER") and OW_IsAspect(OW_buffspell)) then
          OW_buffreminder(OW_needs(UnitName(OW_bufftarget),OW_buffspell));
      end;
    end;
  end;
end;

-- INSPECT_TALENT_READY event
-- Inspected Player's name in OW_inspectname
function OW_CheckTalent()
  OW_inspectDB[OW_inspectname] = {}
  local tn1,_,t1 = GetTalentTabInfo(1,1); 
  local tn2,_,t2 = GetTalentTabInfo(2,1); 
  local tn3,_,t3 = GetTalentTabInfo(3,1); 
  OW_inspectDB[OW_inspectname][1] = tn1
  OW_inspectDB[OW_inspectname][2] = tn2
  OW_inspectDB[OW_inspectname][3] = tn3
  OW_inspectname = "";
end;

-- This finds and displays any mousewheel-related bindings -
function OW_checkbindings()
  for x = 1,GetNumBindings() do
    local action = select(1,GetBinding(x));
    for y = 2,select("#",GetBinding(x)) do
       local keyb = select(y,GetBinding(x));
       if strfind(strupper(keyb),"MOUSEWHEEL") then
         DEFAULT_CHAT_FRAME:AddMessage("O-Wheely!: Function " .. action .. " is bound to " .. keyb,1,0,0);
       end;
    end;
  end;
end;

function OW_buffreminder(reminder)
  if reminder == OW_lastreminder then 
    if OW_checkduration < 30 then -- actually maxes at about 38 seconds
      OW_checkduration = OW_checkduration + (OW_checkduration / 2);
    end;
  end;
  UIErrorsFrame:AddMessage(reminder,255,0,0);
  OW_lastreminder = reminder;
end

-- Checks for "buffname" on "target" (partial matches e.g. "Blessing" will find "Blessing of Auchindoun" 
-- If mybuff = "1" it must be YOUR buff
-- Returns name of buff found
function OW_CheckBuff(buffname,target,mybuff)
  local ft = OW_failed[buffname .. UnitName(target)];
  if ft then
    if GetTime() - ft > 300 then -- ignored buff/player for 5 mins
      OW_failed[buffname .. UnitName(target)] = nil;
    else
      return buffname; -- pretend we've found it
    end;
  end;
	local i=1;
	local testname,_,_,_,duration,timeleft=UnitBuff(target,1); 	-- * buffs
	while (testname) do
		if (strfind(strupper(testname),strupper(buffname))) then
      if (mybuff == 0) or (duration) then
			  return testname;
			end;
		end
		i=i+1;
		testname,_,_,_,duration,timeleft=UnitBuff(target,i);
	end
	return "";
end

-- Checks "target" for "buffname"
-- Returns true if not found - and readies buff for casting.
function OW_NeedBuff(buffname,target)
 if IsUsableSpell(buffname) then -- not every Paladin has BOK etc.
  if (OW_CheckBuff(buffname,target,0) ~= "") then
    return false;
  else
    OW_buffspell = buffname;
    OW_bufftarget = target;
    return true;
  end;
 end;
end

-- Checks spells against known aspect list (to avoid boss buff/debuffs with similar names)
function OW_IsAspect(spell)
  if (spell == OW_aoth) or (spell == OW_aotc) or (spell == OW_aotp) or
     (spell == OW_aotv) or (spell == OW_aotb) or (spell == OW_aotw) or
     (spell == OW_aotm) then
    return true; 
  else
    return false;
  end;
end;

-- Checks spells against known aura list (to avoid boss buff/debuffs with similar names)
function OW_IsAura(spell)
  if (spell == OW_crusaura) or (spell == OW_devaura) or (spell == OW_concaura) or
     (spell == OW_fireaura) or (spell == OW_frostaura) or (spell == OW_shadowaura) or
     (spell == OW_retaura) or (spell == OW_sancaura) then
    return true; 
  else
    return false;
  end;
end;

-- Checks for Blessings (to avoid things like "Blessing of Auchindoun")
function OW_HasMyBlessing(target)
  if (OW_CheckBuff(OW_bol,target,1) ~= "") or (OW_CheckBuff(OW_bow,target,1) ~= "") or
     (OW_CheckBuff(OW_bok,target,1) ~= "") or (OW_CheckBuff(OW_bos,target,1) ~= "") or
     (OW_CheckBuff(OW_bosa,target,1) ~= "") or (OW_CheckBuff(OW_bosc,target,1) ~= "") or
     (OW_CheckBuff(OW_bol,target,1) ~= "") or (OW_CheckBuff(OW_bop,target,1) ~= "") or
     (OW_CheckBuff(OW_bof,target,1) ~= "") then
    return true;
  else
    return false;
  end;
end;

-- Checks to see if you're in the Preparation zone of a BG
function OW_InRaidPrep()
  if (OW_CheckBuff("Preparation","PLAYER",0) ~= "") then
    return true;
  else
    return false;
  end;
end;

-- Checks to see if you're in a BG
function OW_inbg()
  if select(2, IsInInstance()) == "pvp" then
    return true;
  else
    return false;
  end;
end;

-- Will, one day, advertise O-Wheely! to the world!!
function OW_plug()
  if ((OW_plugged == true) and (OW_inbg)) then
     OW_plugged = false;
  elseif ((OW_plugged == false) and OW_InRaidPrep()) then
     OW_plugged = true;
     SendChatMessage(" buffs using O-Wheely! - Empower YOUR mousewheel at Curse or WoWInterface today!","EMOTE");
  end;
end;

-- Returns either the OWUp/OWDown macro content - or preset combatspell1,2...
function OW_GetMWDefaults()
  local mt = GetMacroBody("OWUp");
  if (not mt) then
    mt = OW_combatspell;
  end;
  st,en,var = strfind(mt,"(OW_[a-z]*)");
  if st and getglobal(var) then
     mt = string.gsub(mt,var,getglobal(var));
  end;
  local mt2 = GetMacroBody("OWDown");
  if (not mt2) then -- or (OW_class == "PALADIN") or (OW_class == "HUNTER") then
    mt2 = OW_combatspell2;
  end;
  st,en,var = strfind(mt2,"(OW_[a-z]*)");
  if st and getglobal(var) then
     mt2 = string.gsub(mt2,var,getglobal(var));
  end;
  return mt,mt2;
end;

-- Checks raidgroup players of class "class" to see if they need "gblessing" 
-- if more then 3 do, returns true and readies spells for casting
function OW_CheckGB(gblessing,blessing,class)
  if (IsUsableSpell(gblessing) == 1) then
    local tc = 0;
    local tr = 0;
    local targetname = "";
    for x = 1, 40 do
      local target = "RAID" .. x;
      if UnitExists(target) then
        local _,cl = UnitClass(target);
        if (cl == class) then
          tc = tc + 1;
          if (not UnitIsDeadOrGhost(target)) and (IsSpellInRange(gblessing,target) == 1) and (OW_CheckBuff(blessing,target,0) == "") then
            targetname = target;
            tr = tr + 1;
          end;
        end;
      end;
    end;
    -- We have 4-or-more buffable - and we're not missing more than 3 (e.g. we won't cast the greater buff twice!)
    if tr > 3 then
      OW_buffspell =  gblessing;
      OW_bufftarget = targetname;
      return true;
    end;
  end;
  return false;
end;

-- Checks members of party "partyno" to see if they need have "buff" or "buff2" 
-- if more then 2 don't, returns true and readies buff for casting
function OW_CheckParty(partyno,classes,buff,buff2)
  if (IsUsableSpell(buff) == 1) then
    local tr = 0;
    local targetname = "";
    if (GetNumRaidMembers() == 0) then
      if (partyno == 1) then -- not in raid, only handle Party1 
        for x = 1,5 do
          local target = "PARTY" .. x;
          if UnitExists(target) then
            local _,cl = UnitClass(target); -- non-localised classname
            if (classes == "") or (strfind(classes,cl)) then
              if (not UnitIsDeadOrGhost(target)) and (IsSpellInRange(buff,target) == 1) and (OW_CheckBuff(buff,target,0) == "") and (not buff2 or OW_CheckBuff(buff2,target,0) == "") and (not buff2 or OW_CheckBuff(buff2,target,0) == "") then
                targetname = UnitName(target);
                tr = tr + 1;
              end;
            end;
          end;      
        end;
      end;
    else
      for x = 1,GetNumRaidMembers() do
        local name,_,subg = GetRaidRosterInfo(x);
        if subg == partyno then
          local target = name;
          if UnitExists(target) then
            local _,cl = UnitClass(target); -- non-localised classname
            if (classes == "") or (strfind(classes,cl)) then
              if (not UnitIsDeadOrGhost(target)) and (IsSpellInRange(buff,target) == 1) and (OW_CheckBuff(buff,target,0) == "") and (not buff2 or OW_CheckBuff(buff2,target,0) == "") and (not buff3 or OW_CheckBuff(buff3,target,0) == "") then
                targetname = name;
                tr = tr + 1;
              end;
            end;
          end;
        end;
      end;
    end;
    if tr > 2 then
      OW_buffspell =  buff;
      OW_bufftarget = targetname;
      return true;
    end;
  end;
  return false;
end;

-- handles camera zooming 
function OW_camera(mwd)
  if IsMouseButtonDown("RightButton") then
    if mwd == "MWUP" then
      CameraZoomIn(1);
    elseif mwd == "MWDN" then
      CameraZoomOut(1);
    end;
  end;
end;

-- This function will set OW_buffspell and OW_bufftarget to the next buff required
-- It's used by the reminder AND casting functions
function OW_SetSpellCast()
  OW_buffspell = "";
  OW_bufftarget = "";
  -- If GCD not passed since last spell cast - do nothing
  if (GetTime() - OW_lasttime > 1.6) then

    -- Group Buffs first so we avoid self-buffing and THEN group buffing  
    -- Start Priest/Druid/Mage Group Buffs
    if (not IsMouseButtonDown("LeftButton")) then
      if (GetNumPartyMembers() == 0) then
        ng = 0;
      elseif (GetNumRaidMembers() == 0) then
        ng = 1;
      else
        ng = 8; -- even in a 2-man raid people can be in Group 8
      end;
      for gn = 1,ng do
        if OW_class == "PRIEST" then
          if OW_CheckParty(gn,"",OW_pof,OW_pwf) then return true; end;
          if OW_CheckParty(gn,"MAGE;PRIEST;SHAMAN;DRUID;PALADIN",OW_prayerspirit,OW_divinespirit) then return true; end;
        elseif OW_class == "DRUID" then
          if OW_CheckParty(gn,"",OW_gotw,OW_motw) then return true; end;
        elseif OW_class == "MAGE" then
          if OW_CheckParty(gn,"MAGE;PRIEST;SHAMAN;DRUID;PALADIN;HUNTER;WARLOCK",OW_ab,OW_ai) then return true; end;
        end;
      end;
    end;
    -- End Priest/Druid/Mage Group Buffs

    -- Paladin Self-buffs
    if OW_class == "PALADIN" then
      if (IsMounted("PLAYER")) then
        -- Apply Crusader
        if (OW_NeedBuff(OW_crusaura,"PLAYER") == true) then
          OW_combatspell2 = "/stopcasting\n/cast [target=PLAYER] " .. OW_spell1;
          return true; 
        else 
          return false; 
        end; 
      else
        -- Reapply last aura saved when mounted (and then clear it)
        if (OW_spell1) and (OW_spell1 ~= "") then
          if (OW_NeedBuff(OW_spell1,"PLAYER") == true) then
            OW_combatspell2 = "";
            return true; 
          end;
        end;    
        -- Righteous Fury
        if (OW_NeedBuff(OW_righteous,"PLAYER") == true) then return true; end
        -- Blessings
        if (OW_HasMyBlessing("PLAYER") == false) then  -- if we don't have one...
          if (OW_spell2 ~= "") then -- what was our last blessing?
            if (OW_NeedBuff(OW_spell2,"PLAYER") == true) then return true; end;  -- cast it again
          else
            if IsEquippedItemType("Two-Hand") then -- 2H = Might
              if (OW_NeedBuff(OW_bom,"PLAYER") == true) then return true; end;
            --  Blessing of Kings
            elseif (OW_NeedBuff(OW_bok,"PLAYER") == true) then return true;
            --  still no Blessing? - Blessing of Wisdom then!
            elseif (OW_HasMyBlessing("PLAYER") == false) then -- No self-Blessing
              if (OW_NeedBuff(OW_bow,"PLAYER") == true) then return true; end;
            end;
          end;
        end;

      end; -- mounted/non-mounted
    end; 
    -- End Paladin Self-buffs

    -- Priest Self-buffs
    if OW_class == "PRIEST" then
      if (not IsMounted("PLAYER")) then
        -- Power Word: Fortitude
        if (OW_CheckBuff(OW_pof,"PLAYER",0) == "") and (OW_NeedBuff(OW_pwf,"PLAYER") == true) then return true; end
        -- Inner Fire
        if (OW_NeedBuff(OW_innerfire,"PLAYER") == true) then return true; end
        -- Divine Spirit
        if ((OW_CheckBuff(OW_prayerspirit,"PLAYER",0) == "") and (OW_NeedBuff(OW_divinespirit,"PLAYER") == true)) then return true; end
      end;
    end; 
    -- End Priest Self-buffs

    -- Mage Self-buffs
    if OW_class == "MAGE" then
      if (not IsMounted("PLAYER")) then
        -- Arcane Intellect
        if (OW_CheckBuff(OW_ab,"PLAYER",0) == "") and (OW_NeedBuff(OW_ai,"PLAYER") == true) then return true; end
        if (OW_CheckBuff(OW_icearmor,"PLAYER",1) == "") and (OW_CheckBuff(OW_magearmor,"PLAYER",1) == "") and 
           (OW_CheckBuff(OW_frostarmor,"PLAYER",1) == "") and (OW_CheckBuff(OW_moltenarmor,"PLAYER",1) == "") then 
          if (OW_spell2 ~= "") then -- what was our last armor?
            if (OW_NeedBuff(OW_spell2,"PLAYER") == true) then return true; end;  -- cast it again
          end;
        end;
      end;
    end; 
    -- End Mage Self-buffs

    -- Hunter Self-buffs
    if OW_class == "HUNTER" then
      if (not IsMounted("PLAYER")) then
        -- Trueshot Aura
        if (OW_NeedBuff(OW_tsa,"PLAYER") == true) then return true; end;
        -- If out-of-combat and no runspeed aspect...
        if (OW_CheckBuff(OW_aotc,"PLAYER",1) == "") and (OW_CheckBuff(OW_aotp,"PLAYER",1) == "") and (not UnitAffectingCombat("PLAYER")) then
          OW_combatspell2 = "/stopcasting\n/cast [target=PLAYER] " .. OW_spell1;
          -- Pack if in party and NOT Battleground - Cheetah otherwise
          if (GetNumPartyMembers() > 0 or GetNumRaidMembers() > 0) and (not OW_inbg) then
            if (OW_NeedBuff(OW_aotp,"PLAYER") == true) then return true; end;
          else
            if (OW_NeedBuff(OW_aotc,"PLAYER") == true) then return true; end;
          end;
        else
          OW_combatspell2 = "";
          if (OW_spell1) and (OW_spell1 ~= "") then
            -- Switch to last non-runspeed Aspect
            if (OW_NeedBuff(OW_spell1,"PLAYER") == true) then
              return true; 
            end;
          end;
        end;
      end;
    end; 
    -- End Hunter Self-buffs

    -- Warlock Self-buffs
    if OW_class == "WARLOCK" then
      if (not IsMounted("PLAYER")) then
        -- If armor active
        if (OW_CheckBuff(OW_demonskin,"PLAYER",1) ~= "") or (OW_CheckBuff(OW_demonarmor,"PLAYER",1) ~= "") or (OW_CheckBuff(OW_felarmor,"PLAYER",1) ~= "") then
        elseif (OW_spell2) and (OW_spell2 ~= "") then
          -- cast last armour
          if (OW_NeedBuff(OW_spell2,"PLAYER") == true) then return true; end;
        end;
      end;
    end; 
    -- End Warlock Self-buffs

    -- Druid Self-buffs
    if OW_class == "DRUID" then
      if (not IsMounted("PLAYER")) then 
        -- Mark of the Wild
        if ((OW_CheckBuff(OW_gotw,"PLAYER",0) == "") and (OW_NeedBuff(OW_motw,"PLAYER") == true)) then return true; end;
        -- Omen of Clarity
        if (IsUsableSpell(OW_omen)) then
          if (OW_NeedBuff(OW_omen,"PLAYER") == true) then return true; end;
        end;
      end;
    end; 
    -- End Druid Self-buffs

    -- Shaman/Rogue Self-buffs (identical in terms of MH/OH buffing)
    if OW_class == "ROGUE" or OW_class == "SHAMAN" then
      if (not IsMounted("PLAYER")) then 
        local mh,_,_,oh = GetWeaponEnchantInfo();
        if (not mh) and (OW_tench1 ~= "") then
          OW_buffspell = OW_tench1 .. OW_mh;
          OW_bufftarget = "PLAYER"
          return true; 
        elseif (not oh) and (OW_tench2 ~= "") then
          OW_buffspell = OW_tench2 .. OW_oh;
          OW_bufftarget = "PLAYER"
          return true; 
        end;
      end;
    end; 
    -- End Shaman/Rogue Self-buffs

    -- Situational Buffs
    for target in pairs(OW_situbuffdb) do
      for spell,ct in pairs(OW_situbuffdb[target]) do
        -- this will fail if someone left party/raid so no need for UnitExists
        if IsSpellInRange(spell,target) == 1 then
          if (OW_NeedBuff(spell,target) == true) then return true; end
        end
      end
    end;
    
    -- After self-buffs because we never buff ourselves here...
    -- Start Paladin Group Buffs
    if (not IsMouseButtonDown("LeftButton")) then
      if OW_class == "PALADIN" then
        if OW_CheckGB(OW_gbom,OW_bom,"WARRIOR") then return true; end;
        if OW_CheckGB(OW_gbom,OW_bom,"ROGUE") then return true; end;
        if OW_CheckGB(OW_gbom,OW_bom,"HUNTER") then return true; end;
        if OW_CheckGB(OW_gbow,OW_bow,"MAGE") then return true; end;
        if OW_CheckGB(OW_gbow,OW_bow,"PRIEST") then return true; end;
        if OW_CheckGB(OW_gbok,OW_bok,"WARLOCK") then return true; end;
      end;
    end;
    -- End Paladin Group Buffs
  
    -- Now we go through the targetlist from where we last left it (to avoid getting stuck on people out of line-of-sight)
    local stpos = OW_tpos;
    while 1 == 1 do -- yes, loop endlessly - breakout once we've been through the entire list (see end of loop) 
      local target = OW_targetlist[OW_tpos];
      OW_tpos = OW_tpos + 1;
      if (OW_tpos > # OW_targetlist) then 
        OW_tpos = 1;
      end;
      
      -- Check our chosen target exists, is a player, is friendly, is alive, and is not disconnected
      if (UnitExists(target)) and (UnitIsPlayer(target)) and (UnitIsFriend("PLAYER",target)) and (not UnitIsDeadOrGhost(target)) and (UnitIsConnected(target)) then
        class,eclass = UnitClass(target); -- ENGLISH classname so no localisation needed
              
        -- Handle Paladin buffs for players in range of Blessings...
        if (OW_class == "PALADIN") and (IsSpellInRange(OW_bom,target) == 1) then
          if (not IsMounted("PLAYER")) then
            if (UnitIsUnit(target,"PLAYER")) then
              -- ignore self 
            elseif (OW_HasMyBlessing(target)) then
              -- player already has our blessing
              -- if it's a hunter, we check pet
              if (UnitExists(target .. "PET")) then  
                 if (OW_HasMyBlessing(target .. "PET")) then
                    --pet already has our blessing
                 elseif (eclass == "HUNTER") then
                    if (OW_NeedBuff(OW_bom,target .. "PET") == true) then return true; end;
                 elseif (eclass == "WARLOCK") then
                    if (OW_NeedBuff(OW_bok,target .. "PET") == true) then return true; end;
                 end;
              end;
            else
              -- Shamans and Druids we fire an Inspect request to check talents...
              if (eclass == "SHAMAN") or (eclass == "DRUID") then
                local unitname = UnitName(target); 
                if ((OW_inspectname ~= "") and (GetTime() - OW_inspecttime < 5)) then 
                    -- already awaiting inspect data - skip player for now
                elseif (not OW_inspectDB[unitname]) then -- player not in talent table
                   -- send inspect request
                   OW_inspectname = unitname;
                   OW_inspecttime = GetTime();
                   NotifyInspect(target);
                else
                   local spec = OW_inspectDB[unitname];
                   -- Resto Shamans/Druids - Blessing of Wisdom
                   if ((eclass == "DRUID") and (spec[3] > 30)) or
                      ((eclass == "SHAMAN") and (spec[3] > 30)) then 
                        if (OW_NeedBuff(OW_bow,target) == true) then return true; end;
                   end;
                   -- Feral Druids/Enhancement Shamans - Blessing of Might
                   if ((eclass == "DRUID") and (spec[2] > 30)) or
                      ((eclass == "SHAMAN") and (spec[2] > 30)) then 
                        if (OW_NeedBuff(OW_bom,target) == true) then return true; end;
                   end;
                   -- All Druids/Shamans we've not managed to buff so far - try Kings, Wisdom, Might
                   if (OW_NeedBuff(OW_bok,target) == true) then return true; end;
                   if (OW_NeedBuff(OW_bow,target) == true) then return true; end;
                   if (OW_NeedBuff(OW_bom,target) == true) then return true; end;
                end;                
              else                
                -- Hunters, Rogues, Warriors - Blessing of Might
                if ((eclass == "WARRIOR") or (eclass == "ROGUE") or (eclass == "HUNTER")) then
                  if (OW_NeedBuff(OW_bom,target) == true) then return true; end;
                end;
                -- Mages, Priests - Blessing of Wisdom
                if (eclass == "MAGE") or (eclass == "PRIEST") then
                  if (OW_NeedBuff(OW_bow,target) == true) then return true; end;
                end;
                -- Everyone we've not managed to buff so far - Blessing of Kings
                if (OW_NeedBuff(OW_bok,target) == true) then return true; end;
                -- Hunters not blessed so far - Blessing of Wisdom
                if ((eclass == "HUNTER")) then
                  if (OW_NeedBuff(OW_bow,target) == true) then return true; end;
                end;
                -- Paladins not blessed so far - Blessing of Might
                if (eclass == "PALADIN") then
                  if (OW_NeedBuff(OW_bom,target) == true) then return true; end;
                end;
              end;
            end;
          end;
        end;
        -- End Paladin Buffs  

        -- Handle Priest buffs for players in range of PWF...
        if (OW_class == "PRIEST") and (IsSpellInRange(OW_pwf,target) == 1) then
          if (not IsMounted("PLAYER")) then
            if (UnitIsUnit(target,"PLAYER")) then
              -- ignore self
            -- Power Word: Fortitude
            elseif (OW_CheckBuff(OW_pof,target,0) == "") and (OW_NeedBuff(OW_pwf,target) == true) then return true; 
            -- Power Word: Fortitude on Pets
            elseif (UnitExists(target .."PET")) then
              if (OW_CheckBuff(OW_pof,target .. "PET",0) == "") and (OW_NeedBuff(OW_pwf,target .. "PET") == true) then return true; end; 
            -- Divine Spirit on Healers/Mages (seems excessive to check for 'resto' shamans/druids here)
            elseif (eclass == "PRIEST") or (eclass == "MAGE") or (eclass == "DRUID") or (eclass == "SHAMAN") or (eclass == "PALADIN") then
              if ((OW_CheckBuff(OW_prayerspirit,target,0) == "") and (OW_NeedBuff(OW_divinespirit,target) == true)) then return true; end; 
            end;
          end;
        end;
        -- End Priest Buffs  

        -- Handle Mage buffs for players in range of AI...
        if (OW_class == "MAGE") and (IsSpellInRange(OW_ai,target) == 1) then
          if (not IsMounted("PLAYER")) then
            if (UnitIsUnit(target,"PLAYER")) then
              -- ignore self
            -- Arcane Intellect
            elseif (eclass ~= "WARRIOR") and (eclass ~= "ROGUE") then -- non-mana classes 
              if (OW_CheckBuff(OW_ab,target,0) == "") and (OW_NeedBuff(OW_ai,target) == true) then return true; end; 
            end;
          end;
        end;
        -- End Mage Buffs  

        -- Handle Druid buffs for players in range of MOTW...
        if (OW_class == "DRUID") and (IsSpellInRange(OW_motw,target) == 1) then 
          if (not IsMounted("PLAYER")) then  
            if (UnitIsUnit(target,"PLAYER")) then
              -- ignore self
            -- Mark of the Wild
            elseif ((OW_CheckBuff(OW_gotw,target,0) == "") and (OW_NeedBuff(OW_motw,target) == true)) then return true; 
            -- Mark of the Wild on Hunter Pets
            elseif (eclass == "HUNTER") and (UnitExists(target .."PET")) then
              if ((OW_CheckBuff(OW_gotw,target .. "PET",0) == "") and (OW_NeedBuff(OW_motw,target .. "PET") == true)) then return true; end; 
            end;
          end;
        end;
        -- End Druid Buffs  
  
      end; -- unitexists etc.
      
      if (OW_tpos == stpos) then -- we've been through the whole list so breakout!
        if (IsMounted("PLAYER")) then
          return false;
        else
          return true;
        end;
      end;
  
    end; -- endless loop
  
  else -- in GCD
    return false;
  end
end
