
--local waterfall = AceLibrary("Waterfall-1.0")
local db = AceLibrary("AceDB-2.0")
local L = AceLibrary("AceLocale-2.2"):new("Orlic")
local scheduler = AceLibrary("AceEvent-2.0")



local removeChoice = { }
removeChoice = nil;


						
Orlic.waterfallOptions = 
{
		type = "group",
		args = 
		{ 
		
			raidleader = {	
				type = "group",  
				name = L["Raid Leader"],  
				desc = L["Options Effective for Raid Leader"],
				order = 2,
 				args = {		
					lootmode = 
					{
							type = "group",
							name = L["Loot Mode"],
							desc = L["For toggling the loot mode"],
							order = 2,
							args = {
								secondarytoggle = {
											type = "toggle",
											name = L["Secondary Loot Mode"], 
											desc = L["Enables the ability to communicate and see a secondary interest"]..".  "..L["Only Raid Leader's setting is effective"],
											get = function()
												return Orlic.db.profile.defaults.useSecondary;
											end,
											set = function(v)
													 Orlic.db.profile.defaults.useSecondary = v
											end,
											map = { [false] = "Disabled", [true] = "Enabled" }					
									},
									
								voyeurismtoggle = {
										type = "toggle",
										name = L["Loot Transparency"],
										desc = L["Check if you want to allow raid members to peek at the whispers you received."],
										get = function()  return Orlic.db.profile.defaults.permitTransparency;  end,
										set = function(v)   Orlic.db.profile.defaults.permitTransparency = v;  end,
										map = { [false] = "Disabled", [true] = "Enabled" }
								
								},
							},
	
					},
				
					lootdistros = 
					{
							type = "group",
							name = L["Loot Distributors"], 
							desc = L["Add/Remove Trusted Distributors"],
							order = 2,
							args = {
								 adduser = {
											type = "text",
											name = L["Add User:"],
											desc = L["Add User:"],
											order = 99,
											get = function()
												  return L["Name + <Enter>"];
											end,
											set = function(v)
														local x;
														x = 0;
												  	for k, person in ipairs(Orlic.db.profile.defaults.lootDistros) do
												  		x = k;
												  	end
												  	x = x + 1;
														Orlic.db.profile.defaults.lootDistros[x] = v;
											      scheduler:ScheduleEvent(function() Orlic:RefreshWaterfall() end, 0.1)													
											end,										
									},
								
									removeuser = {
											type = "text",
											name = L["Remove User:"],
											desc = L["Select a user to remove"],
											order = 100,
											get = function()
															if not (removeChoice == nil) then
																return removeChoice;
															end
															
															for k, person in ipairs	(Orlic.db.profile.defaults.lootDistros) do
																removeChoice = person;
																return removeChoice;
															end
															return "";
														end,
											set = function(v)
													  	removeChoice = v; 
														end,
											validate =  "code will change this =-)",
														--[[		  function()
																		local t;
																		t = { };
																		for k, person in ipairs(Orlic.db.profile.defaults.lootDistros) do
																			t[k] = person;
																		end
																		return t;
																	end,  ]]
											-- usage = "<name>";										
																 
									},
									
									remove = {
											type = "execute",
											name = L["Remove"],
											desc = L["Remove User"],
											order = 110,
											func = function()
															local x = { };
															local offset = 0;
															
																if not (removeChoice == nil) then
											       			for k, person in ipairs (Orlic.db.profile.defaults.lootDistros) do
											       				if not (person == removeChoice) then
											       					x[k-offset] = person;
											       				else 
											       					offset = offset + 1;
											       				end
											       			end
											       			
										  	     			Orlic.db.profile.defaults.lootDistros = x;
											       			removeChoice = nil;
											       			scheduler:ScheduleEvent(function() Orlic:RefreshWaterfall() end, 0.1)
											       		end
											       end,
									
									},
							},								
					
					},
					
					defaultLootTime = 
					{
							type = "group",
							name = L["Default Loot Time"],
							desc = L["Loot choice expiration time"],
							order = 4,
							args = {
								lootTimeExpire = {
											type = "range",
											name = L["Default Loot Time"], 
											desc = L["Loot choice expiration time"],
											min = 10,
											max = 300,
											step = 10,
											get = function()
												return Orlic.db.profile.defaults.defaultLootTime;
											end,
											set = function(v)
													 Orlic.db.profile.defaults.defaultLootTime = v
											end,
									},
							},
	
					},  -- end defaultLootTime
					
					
					keywordSettings = 
					{
							type = "group",
							name = L["Keyword Settings"],
							desc = L["Preferred keywords to use for primary & secondary whispers"],
							order = 5,
							args = {
								priKeyword = {
									type = "text",
									name = L["Keyword to use for primary"],
									desc = L["The keyword preceding a loot link for accepting a whisper.  Note:  Secondary Loot Mode must be on for this to be 'observed.'  Remember to hit enter to save changes, and no spaces."] ,
									order = 1,
									get = function()  return Orlic.db.profile.defaults.primaryKeyword;  end,
									set = function(v)  
										if v == nil then
											Orlic.db.profile.defaults.primaryKeyword = "nil";
										elseif v == Orlic.db.profile.defaults.secondaryKeyword then
											Orlic.db.profile.defaults.primaryKeyword = v.."*";
										elseif not (string.find(v, " ") == nil) then
											Orlic.db.profile.defaults.primaryKeyword = "invalid";
										else
											Orlic.db.profile.defaults.primaryKeyword = v; 
										end
									
									end,
								
								},
								secKeyword = {								
									type = "text",
									name = L["Keyword to use for secondary"],
									desc = L["The keyword preceding a loot link for accepting a whisper.  Note:  Secondary Loot Mode must be on for this to be 'observed.'  Remember to hit enter to save changes, and no spaces."] ,
									order = 2,
									get = function()   return Orlic.db.profile.defaults.secondaryKeyword; end,
									set = function(v)   
										if v == nil then 
											Orlic.db.profile.defaults.secondaryKeyword = "nil";
										elseif v == Orlic.db.profile.defaults.primaryKeyword then
											Orlic.db.profile.defaults.secondaryKeyword = v.."*";
										elseif not (string.find(v, " ") == nil) then
											Orlic.db.profile.defaults.secondaryKeyword = "invalid";											
										else
											Orlic.db.profile.defaults.secondaryKeyword = v; 
										end
									end,
								
								},
							
							},
					
					
					},  -- end keywordSettings
					
				}, 
			},    -- end raid leader
			
			windowscales = 
			{
				type = "group",
				name = L["User Prefs"],
				desc = L["Options effective for everyone"],
				order = 2,
				args = {
						bidscale = {
							type = "range",
							name = L["Bid Choice Window"],
							desc = L["The need/greed style window."],
							min = 50,
							max = 150,
							step = 2,
							get = function()
											return Orlic.db.profile.defaults.bidWindowScale;
										end,
							set = function(v)
											Orlic.db.profile.defaults.bidWindowScale = v;
										end,
						},
						
						stickybid = {
							type = "toggle",
							name = L["Sticky bid"], 
							desc = L["If secondary loot mode is enabled by the raid leader, do not close the interest window when an option other than pass is selected."],
							get = function()
								return Orlic.db.profile.defaults.stickyBid;
							end,
							set = function(v)
								Orlic.db.profile.defaults.stickyBid = v;
							end,
							map = { [false] = "Disabled", [true] = "Enabled" }	
						
						}
					},
			}, -- end windowscales
				
		},


};



