local L = AceLibrary("AceLocale-2.2"):new("Orlic")
Framework = AceLibrary("AceOO-2.0").Class()
local tablet = AceLibrary("Tablet-2.0")
local scheduler = AceLibrary("AceEvent-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
rosterlib = AceLibrary("Roster-2.1")


local SOLO_CODING = 0;

local PRIMARY = 1;
local SECONDARY = 2;
local PRIMARY_ONLY = -1;


local resetLock = false;
local confirmLock = false;

    				
local priKeyword = "UhOh, broke!"; 
local secKeyword = "UhOh, broke!"; 

function Framework.prototype:SetKeywords(priWord, secWord)

	priKeyword = priWord;
	secKeyword = secWord;
end


function Framework.prototype:Disable()
		if tablet:IsRegistered("NLWO") then
				tablet:Unregister("NLWO")
		end
		
		if tablet:IsRegistered("LAEM") then
				tablet:Unregister("LAEM")
		end
		
		if tablet:IsRegistered("IDEM") then
				tablet:Unregister("IDEM")
		end


		if dewdrop:IsRegistered("DivvyPane") then		
				dewdrop:Unregister("DivvyPane")
		end
		

		if tablet:IsRegistered("DivvyPane") then
				tablet:Unregister("DivvyPane")
		end

		if tablet:IsRegistered("OrlicDistroTells") then
				tablet:Unregister("OrlicDistroTells")
		end
		
		if tablet:IsRegistered("OrlicConfirmDialog") then
				tablet:Unregister("OrlicConfirmDialog")
		end

		if tablet:IsRegistered("OrlicConfirmWinDialog") then
				tablet:Unregister("OrlicConfirmWinDialog")
		end
		


end


function Framework.prototype:Enable()


end	



function CleanUpNLWO()
	 
	 scheduler:ScheduleEvent(function() tablet:Close("NLWO") end, 0.1)
--	 tablet:Unregister("NLWO")
end

function SetupNLWO()

		local cat = tablet:AddCategory("columns", 1)
					tablet:SetHint(L["Open the corpse and run 'Start Loot' again."])        	
					tablet:SetTitle(L["How to Divvy Loot"])
					tablet:SetTitleColor(0.3, 0.5, 0.7)		
        	cat:AddLine('text', L["You need to have the loot-window of the corpse open when you click 'Start Loot'"])
        	cat:AddLine('text', "   ")        	
        	cat:AddLine('text', "   ")        	        	
        		cat:AddLine(
							"text", L["OK"],
							"size", 24, 
							"textR", 0.2,
							"textG", 1.0,
							"textB", 0.4,
							"justify", "CENTER",
							"wrap", true, 
							"func",  CleanUpNLWO
							        
		-- "arg1", self
					)        	

end


function Framework.prototype:NeedLootWindowOpenMsg()

		if tablet:IsRegistered("NLWO") then
			tablet:Open("NLWO")
			tablet:Refresh("NLWO")

			return
		end
		

		tablet:Register("NLWO", -- WorldFrame, 
		'parent', WorldFrame,
		'strata', "dialog",
		'data', { }, 
		'detachedData', { }, 
		'minWidth', 300,
		'maxHeight', 500,
		'clickable', true,
		'hideWhenEmpty', false,
		'showHintWhenDetached', true ,
		'showTitleWhenDetached', true	, 
	  'point', function()        return "TOPRIGHT", "TOPLEFT"    end,
    'cantAttach', true,
    'children', SetupNLWO
 )   
    

		--tablet:SetColor(WorldFrame, 0.3, 0.5, 0.7)
		
		tablet:SetFontSizePercent("NLWO", 1.3)
		

		tablet:Open("NLWO")    

		tablet:Close("NLWO")
		tablet:Open("NLWO")
--		tablet:Refresh("NLWO")

end  

----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------

local divvyLootList = { };
local divvyCheckedList = { };
local divvyAssignments = { };    -- Saved for Later not included.  Indexed link name, returns the distros name.
local divvyDistroList = { };     -- Keep track of our distributors so don't lose indexes to loot.

function CleanUpDivvyPane(arg)

	scheduler:ScheduleEvent(function() tablet:Close("DivvyPane") end, 0.1)
	
	if arg == 1 then
		DoLootPressed()
	else
		Orlic:ToggleLootInProgress()
	end
	
end

function UnregisterDivvyPane()


		tablet:Unregister("DivvyPane")	
end


function SetupDivvyPane()

		local cat = tablet:AddCategory("columns", 3)
					tablet:SetTitle("Loot Divvy")
					-- tablet:SetTitleColor(0.7, 0.7, 0.1)		
        	cat:AddLine('text', L["Save For Later"],
        							"justify", "CENTER",
        							'text2', L["Item"],
        							'text3', L["Distributor"],
        							"justify2", "CENTER",
        							"justify3", "CENTER"
        	)
        	
	--"Interface\\Buttons\\UI-CheckBox-Up")
	--f:SetPushedTexture("Interface\\Buttons\\UI-CheckBox-Down")
	--f:SetHighlightTexture("Interface\\Buttons\\UI-CheckBox-Highlight")
	--f:SetCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check")
	--f:SetDisabledCheckedTexture("Interface\\Buttons\\UI-CheckBox-Check-Disable")
	        	
        	for i, itemLink in ipairs(divvyLootList) do
        			local line = { };
        			if divvyCheckedList[i] then
        				line["text"] = "[X]";
        			else
        				line["text"] = "[  ]";
        			end
        			line["text2"] = itemLink;
        			
        			-- or no loot guy to do it =-)
        			if divvyCheckedList[i] or (divvyDistroList[i] == nil) then
        				line["text3"] = "----";
        			else 
        				line["text3"] = divvyDistroList[i];
        			end
        			
        			
--        			line["onEnterFunc"] = function() Orlic:Print("Woooo!") end
        			line["justify"] = "CENTER";
        			line["justify2"] = "CENTER";
        			line["justify3"] = "CENTER";
        			line["hasCheck"] = false; -- true;
        			line["isRadio"] = false;
--        			line["checked"] =  true;   
        			line["func"] =  function()
	 															-- scheduler:ScheduleEvent(function() tablet:Refresh("DivvyPane") end, 0.5)	
        												-- divvyCheckedList[i] = not divvyCheckedList[i]
        												-- Args remain persistant after function close?  Hmm, guess so.  Crazy Lua. :P
        												ShowDelegationDewDrop(itemLink, i) 
        											end
--        			if divvyCheckedList[i] then
--        				line["checkIcon"] = "Interface\\Buttons\\UI-CheckBox-Check";
--        			else
--        				line["checkIcon"] = "Interface\\Buttons\\UI-CheckBox-Up";
--        			end
        			
        			cat:AddLine(line);
        	
        	end
        	
        	cat:AddLine("text", " ", "text2", " ", "text3", " ");
        	
        	cat:AddLine(
        			"text", " ",
							"text2", L["Do Loot!"],
							"text3", " ",
							"size", 24, 
							"text2R", 0.2,
							"text2G", 1.0,
							"text2B", 0.4,
							"justify", "CENTER",
							"wrap", true, 
							"func",  CleanUpDivvyPane,
						  "arg1", 1
					)  
					
					cat:AddLine("text", " ", "text2", " ", "text3", " " );
					
        	cat:AddLine(
        			"text", " ",
							"text2", L["Cancel"],
							"text3", " ",
							"size", 24, 
							"text2R", 1.0, 
							"text2G", 0.4,
							"text2B", 0.2,
							"justify", "CENTER",
							"wrap", true, 
							"func",  CleanUpDivvyPane,
						  "arg1", 2
					)  



end


function Framework.prototype:DivvyPane(lootlist)

		divvyLootList = lootlist;
		for i, itemLink in ipairs(divvyLootList) do		
			divvyCheckedList[i] = false
		end

		if tablet:IsRegistered("DivvyPane") then
			tablet:Open("DivvyPane")

			return
		end
		

		tablet:Register("DivvyPane", -- WorldFrame, 
		'parent', WorldFrame,
		'strata', "dialog",
		'data', { }, 
		'detachedData', { }, 
		'minWidth', 300,
		'maxHeight', 500,
		'clickable', true,
		'hideWhenEmpty', false,
		'showHintWhenDetached', false ,
		'showTitleWhenDetached', true	, 
	  'point', function()        return "TOPRIGHT", "TOPLEFT"    end,
    'cantAttach', true,
    'children', SetupDivvyPane
 )   
 
 

    

		tablet:SetColor("DivvyPane", 0, 0, 0.1)
		
		tablet:SetFontSizePercent("DivvyPane", 1.2)
		

		tablet:Open("DivvyPane")    

		tablet:Close("DivvyPane")
		tablet:Open("DivvyPane")
		

end		

-- Be sure on "DO LOOT" to unregister this.
function ShowDelegationDewDrop(link, index)

		if dewdrop:IsRegistered("DivvyPane") then
			dewdrop:Unregister("DivvyPane")
		end

 		dewdrop:Register("DivvyPane", 
 			  						 -- "point", function()        return "TOPRIGHT", "BOTTOMLEFT"    end,
 			  						 -- "point", "TOPRIGHT", "relativePoint", "BOTTOMRIGHT", 
 			  						 "cursorX", true,
 			  						 "cursorY", true,
 		                 "children",  function()   
 		                 
 		                 
	 		                 							dewdrop:AddLine("text", L["Choose Distributor For:"],
	 		                 														"textHeight", 16,
	 		                 													  "isTitle", true, 
 		                 							                "closeWhenClicked", false
 		                 							                ) 		                 							                
 		                 							  
 		                 							  dewdrop:AddLine("text", link, "textHeight", 18, "notClickable", true);  
																		dewdrop:AddSeparator();
 		                 							  dewdrop:FeedTable( 
 		                 							  	{
 		                 							  		Wait = {
 		                 							  	    type = "execute",
 		                 							  	    text = L["Toggle Save For Later"],
 		                 							  	    textHeight = 14,
 		                 							  	    closeWhenClicked = true,
    																			-- desc = "unused AceOptions string",
    																			func = function()
    																						-- scheduler:ScheduleEvent(function() tablet:Refresh("DivvyPane") end, 0.5)	    																						
    																						divvyCheckedList[index] = not divvyCheckedList[index];
    																						divvyDistroList[index] = nil;
    																						tablet:Refresh("DivvyPane")
    																						end
 		                 							  		}
 		                 							  	}
 		                 							  )
 		                 							  
 		                 							  dewdrop:AddSeparator();
 		                 							  
 		                 							   		                 							                
 		                 							  for k, distro in ipairs(Orlic.db.profile.defaults.lootDistros) do
 		                 							  	dewdrop:AddLine("text", distro, "textHeight", 14, 
 		                 							  					"closeWhenClicked", true,
 		                 							  					"func", function()
        																								divvyAssignments[link] = distro;
        																								
        																								-- Remember!  INDEX is a number 1..n in the 
        																								-- LOOT list :)   So selected distribs might be 
        																								-- like 3, 5, 8.   Don't assume its continuous!
        																								
        																								divvyDistroList[index] = distro;	
        																								divvyCheckedList[index] = false;			 
        																								tablet:Refresh("DivvyPane")
																											  -- scheduler:ScheduleEvent(function() dewdrop:Close(1) end, 0.1) 		                 							  					
 		                 							  					
 		                 							  									end
 		                 							  	);
 		                 							  end
 		                 							  
																		dewdrop:AddSeparator(); 		                 							   		                 							  
 		                 							  
 			                              dewdrop:AddLine("text", L["Enter Choice"], 
 			                                              "textHeight", 14,
 		                                                "hasEditBox", true,
 		                                                "closeWhenClicked", true,
 		                                                "hasArrow", true,
 		                                                "editBoxFunc", function(text)
        																														
        																													 if text == "" then 
        																													 		scheduler:ScheduleEvent(function() dewdrop:Close(1) end, 0.1)
        																													 	return;
        																													 end
        																													 Orlic:AssignDistro(text)
        																													 divvyAssignments[link] = text;
        																													 -- Remember!  INDEX is a number 1..n in the 
        																													 -- LOOT list :)   So selected distribs might be 
        																													 -- like 3, 5, 8.   Don't assume its continuous!
        																													 divvyDistroList[index] = text;
        																													 divvyCheckedList[index] = false;			         																													 
        																													 
        																													 tablet:Refresh("DivvyPane")
																																	 scheduler:ScheduleEvent(function() dewdrop:Close(1) end, 0.1)
    																															 end
 		                                                )
 		                              end
 		                 )

 		dewdrop:Open("DivvyPane") 		                 		



end
		


-------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------

function CleanUpLAEM()

	 scheduler:ScheduleEvent(function() tablet:Close("LAEM") end, 0.1)
	tablet:Open("DivvyPane")	 

end

function SetupLootAccountErrMsg()

		local cat = tablet:AddCategory("columns", 1)
					tablet:SetHint(L["Click OK and then decide your loot."])        	
					tablet:SetTitle(L["Not all loot accounted for"])
					tablet:SetTitleColor(0.3, 0.5, 0.7)		
        	cat:AddLine('text', L["You still have loot that needs deciding.  You must decide it all to proceed."])
        	cat:AddLine('text', L["Make sure each piece is marked as either ''Save For Later'' or has a distributor."])        	
        	cat:AddLine('text', "   ")        	
					cat:AddLine('text', "   ")        	        	        	
        		cat:AddLine(
							"text", L["OK"],
							"size", 24, 
							"textR", 0.2,
							"textG", 1.0,
							"textB", 0.4,
							"justify", "CENTER",
							"wrap", true, 
							"func",  CleanUpLAEM
							        
		-- "arg1", self
					)        	

end


function LootAccountErrMsg()

		if tablet:IsRegistered("LAEM") then
			tablet:Open("LAEM")
			tablet:Refresh("LAEM")

			return
		end
		

		tablet:Register("LAEM", 
		'parent', WorldFrame,
		'strata', "dialog",
		'data', { }, 
		'detachedData', { }, 
		'minWidth', 300,
		'maxHeight', 500,
		'clickable', true,
		'hideWhenEmpty', false,
		'showHintWhenDetached', true ,
		'showTitleWhenDetached', true	, 
	  'point', function()        return "TOPRIGHT", "TOPLEFT"    end,
    'cantAttach', true,
    'children', SetupLootAccountErrMsg
 )   
    

		--tablet:SetColor(WorldFrame, 0.3, 0.5, 0.7)
		
		tablet:SetFontSizePercent("LAEM", 1.2)
		

		tablet:Open("LAEM")    

		tablet:Close("LAEM")
		tablet:Open("LAEM")

end  



function CleanUpIDEM()

	 scheduler:ScheduleEvent(function() tablet:Close("IDEM") end, 0.1)
	 tablet:Open("DivvyPane")

end


local invalidDistroChoice = { };
local invalidDistroMsgNum = 0;
function SetupInvalidDistroErrMsg()

		local cat = tablet:AddCategory("columns", 1)
					
					tablet:SetHint(L["Pick an existent person in the raid"]) 		
					tablet:SetTitleColor(0.3, 0.5, 0.7)		
										
					cat:AddLine('text', L["Choice:  "]..invalidDistroChoice);			
					if invalidDistroMsgNum == 1 then
							tablet:SetTitle(L["Invalid Distro Choice"])
							cat:AddLine('text', L["Your choice is not in the raid"])        								
					elseif invalidDistroMsgNum == 2 then
							tablet:SetTitle(L["You picked a pet, or something else...?"])
        			cat:AddLine('text', L["Apparently your choice is in the raid, but it isn't a person."])							
					end



        	
        	cat:AddLine('text', "   ")        	
					cat:AddLine('text', "   ")        	        	        	
        		cat:AddLine(
							"text", L["OK"],
							"size", 24, 
							"textR", 0.2,
							"textG", 1.0,
							"textB", 0.4,
							"justify", "CENTER",
							"wrap", true, 
							"func",  CleanUpIDEM
							        
		-- "arg1", self
					)        	

end



function InvalidDistroErrMsg()

		if tablet:IsRegistered("IDEM") then
			tablet:Open("IDEM")
			tablet:Refresh("IDEM")

			return
		end
		

		tablet:Register("IDEM", 
		'parent', WorldFrame,
		'strata', "dialog",
		'data', { }, 
		'detachedData', { }, 
		'minWidth', 300,
		'maxHeight', 500,
		'clickable', true,
		'hideWhenEmpty', false,
		'showHintWhenDetached', true ,
		'showTitleWhenDetached', true	, 
	  'point', function()        return "TOPRIGHT", "TOPLEFT"    end,
    'cantAttach', true,
    'children', SetupInvalidDistroErrMsg
 )   
    

		--tablet:SetColor(WorldFrame, 0.3, 0.5, 0.7)
		
		tablet:SetFontSizePercent("IDEM", 1.2)
		

		tablet:Open("IDEM")  

		tablet:Close("IDEM")
		tablet:Open("IDEM")

end  


-- Jobs needed to be done by Do Loot, and the order.
-- 1.  Make sure all loot is accounted for.  If not, show them the fail tablet.
-- 2.  Make sure all distros are valid persons.  If not, show them the fail tablet.
-- 3.  Unregister dewdrop and any remaining tablets, frames, or other things.
-- 4.  Convert and COPY all your distro/links/lootlist stuff into a well organized data structure, not a wild 
--     pairing of indices.  Do not include "Save For Later" items.
-- 5.  Kick off the need/greed sequence with global comm et. al.

		
function DoLootPressed()
	local raidMember = { };
	local filteredLootList = { };
	local offset = 0;



	for i, item in ipairs(divvyLootList) do
		if not divvyCheckedList[i] then
			-- Its not checked, so lets see if it is assigned?
			if divvyDistroList[i] == nil then
				LootAccountErrMsg()
				return;
			end
		
		end
	
	end


	-- Ok, all the loot is accounted for now.
	-- Are all the distros valid?
	for i, itemL in ipairs(divvyLootList) do
		 	local distro = { };
		 	local firstchar = { };
		 
		 	distro = divvyDistroList[i]
			if not (distro == nil) then
				-- capitalize the first character freely.
				firstchar = string.sub(distro:upper(), 1, 1);
				distro = firstchar..string.sub(distro, 2);
		 
			 -- Orlic:Print("distro-accountant: "..distro);
			 raidMember = rosterlib:GetUnitIDFromName(distro)
			 if  (raidMember == nil) then
			 		invalidDistroChoice = distro;
					invalidDistroMsgNum = 1;
					if SOLO_CODING == 0 then
						InvalidDistroErrMsg()
						return
					end
			elseif not UnitIsPlayer(distro) then
			 		invalidDistroChoice = distro;
					invalidDistroMsgNum = 2;
					if SOLO_CODING == 0 then
						InvalidDistroErrMsg()
						return;
				  end
			else 
					-- Orlic:Print("It's in the raid and its a player: "..raidMember);
			end
		end
	end


		if tablet:IsRegistered("NLWO") then
				tablet:Unregister("NLWO")
		end	
		
		if tablet:IsRegistered("LAEM") then
				tablet:Unregister("LAEM")
		end
		
		if tablet:IsRegistered("IDEM") then
				tablet:Unregister("IDEM")
		end


		if dewdrop:IsRegistered("DivvyPane") then		
				dewdrop:Unregister("DivvyPane")
		end
		
		if tablet:IsRegistered("DivvyPane") then		
				scheduler:ScheduleEvent(function()  UnregisterDivvyPane()  end, 1.0)		
		end
		
		

		for k, itemlink in ipairs(divvyLootList) do
			if divvyCheckedList[k] == false then
					filteredLootList[k-offset] = itemlink;
			else
					offset = offset + 1;
			end
		
		end
		
		
		
		-- lootlist w/ number index, and assignments w/ lootlink index for distro person.
		Orlic:BeginLootBroadcast(filteredLootList, divvyAssignments)
		
		divvyLootList = { };
		divvyCheckedList = { };
		divvyAssignments = { };   
		divvyDistroList = { };    
		
		

end		

-----------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------


local windowIDRecordIndex = 0;
local windowIDRecord = { };
local clfTickStarted = 0;

local CLFQueue = { };


function KillLIW(arg)
		local x = 0;
--		local offset = 0;
		local newset = { };
		
		tablet:Close(arg); 	   
		tablet:Unregister(arg);
		
		
		for i, id in ipairs(windowIDRecord) do
			if id == arg then
				x = i;
				windowIDRecord[i] = nil;
			end
		end
		
		
		for i, id in ipairs(windowIDRecord) do
				newset[i] = id;
				windowIDRecordIndex = i;
			
--			if not (id == nil) then
--				newset[i-offset] = id;
--				windowIDRecordIndex = i-offset;
--			else 
--				Orlic:Print("So ipairs won't get a nil key, will it?");
--				offset = offset + 1;
--			end
		end
	
	
		windowIDRecord = newset;			
		
end

function CleanUpLIW(arg)

	 scheduler:ScheduleEvent(function() 
	 													KillLIW(arg)
	                          end, 0.1)
	                          


end




function Framework.prototype:ShowLootInterestWindow(itemLink, distro, secondaryMode, time)

		local windowID;
		local baseID;
		local wNum;
		
		
		baseID = "OrlicLootChoiceFrame";
		wNum = 1;
		
		for i, id in ipairs(windowIDRecord) do
			windowID = baseID.."_"..wNum;
			if windowID == id then
				 wNum = wNum + 1;
			end
			windowIDRecordIndex = i;					
		end
		
		windowIDRecordIndex = windowIDRecordIndex + 1;
		windowIDRecord[windowIDRecordIndex] = baseID.."_"..wNum;

		BuildCustomLootFrame(windowIDRecord[windowIDRecordIndex], itemLink, distro, secondaryMode, wNum, time);
		scheduler:ScheduleEvent(StartTickCLF, 1.0)
		return;

end		
		


		
--  Inspired by oRA2. Actually, blatantly and shamelessly copied from.  I did modify it.  Well, a little.
--  Maybe more.  Or less.  But it's such good code!!!!!!
--  Really, someone should use oRA2's work as the basis of a frames widget library.....  Would be VERY cool.
function BuildCustomLootFrame(id, link, distro, mode, level, time)

		local font = GameFontNormal:GetFont()
		local f = CreateFrame("Frame", id, WorldFrame) -- UIParent)
		
		local width = 400 * (Orlic.db.profile.defaults.bidWindowScale / 100);
		local height = 100 * (Orlic.db.profile.defaults.bidWindowScale / 100);
		local bidWindowScale =  Orlic.db.profile.defaults.bidWindowScale / 100;
		
		local frameCenterY = -220;
		local frameCenterX = 1;
		
		local butSize = 32;
		
		frameCenterY = frameCenterY + ((level-1)*height);



		f:SetFrameStrata("DIALOG")		
		f:SetWidth(width)  -- Set These to whatever height/width is needed 
		f:SetHeight(height) 
		f:SetPoint("CENTER", frameCenterX, frameCenterY)

		--f:SetPoint("TOPLEFT",  MainMenuBar, "TOPLEFT", -10, 10)
		--f:SetPoint("TOPRIGHT", 220, 0)
		--f:SetPoint("BOTTOMLEFT", 200, 50)
		--f:SetPoint("BOTTOMRIGHT", 220, 50)		
		
		--f:SetAllPoints(Minimap);
		

		
		f:SetBackdrop({
			bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16,
			edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 32,
			insets = {left = 1, right = 1, top = 1, bottom = 1},
		})
		
		f:SetBackdropColor(0, 0, 0)
		f:SetBackdropBorderColor( 0.3, 0.5, 0.7 )
		f:EnableMouse(true)
		f:SetMovable(true)
		f:RegisterForDrag("LeftButton")
		f:SetScript("OnDragStart", function() this:StartMoving() end )
		f:SetScript("OnDragStop", function() this:StopMovingOrSizing() end )
		
		
			
		f.header = f:CreateFontString(nil,"OVERLAY")
		f.header:SetFont(font, math.floor(14 * bidWindowScale))
		f.header:SetWidth(width)
		f.header:SetText(link)
		f.header:SetShadowOffset(.8, -.8)
		f.header:SetShadowColor(0, 0, 0, 1)
		f.header:ClearAllPoints()
		f.header:SetPoint("TOP", f, "TOP", 0, -8)   
		
		f.fakeTTbutton = CreateFrame("Button", nil, f)
		f.fakeTTbutton:SetWidth(f.header:GetStringWidth())
		f.fakeTTbutton:SetHeight(16)
		f.fakeTTbutton:ClearAllPoints()		
		f.fakeTTbutton:SetPoint("TOP", f, "TOP", 0, -8)
		f.fakeTTbutton:SetScript( "OnEnter", function() 

		                                      GameTooltip:ClearAllPoints()
																					GameTooltip:SetOwner(f.fakeTTbutton, "TOPLEFT", 
																					                     -((width - f.header:GetStringWidth() + 16)/2), 
																					                     -((height/2) + 10));
																					GameTooltip:ClearLines()
																					GameTooltip:SetHyperlink(link);
																					GameTooltip:Show();
																					--[[
																					
																					GTT:ClearAllPoints()
																					GTT:SetOwner(f.fakeTTbutton, "TOPLEFT", 
																					                     -((width - f.header:GetStringWidth() + 16)/2), 
																					                     -((height/2) + 10));
																					GTT:ClearLines()
																					GTT:SetHyperlink(link);
																					GTT:Show();																					
																					]]
																					
		                                     end );
		f.fakeTTbutton:SetScript( "OnLeave", function() GameTooltip:Hide(); end );
		f.fakeTTbutton:SetScript( "OnClick", function() 
																						-- GameTooltip:SetHyperlink(link);
		                                     	end );
		


		f.closebutton = CreateFrame("Button", nil, f, 'UIPanelCloseButton')
		f.closebutton:SetWidth(butSize)
		f.closebutton:SetHeight(butSize)
		f.closebutton:SetPoint("TOPRIGHT", f, "TOPRIGHT", 0, 0)
		f.closebutton:SetScript( "OnClick", function() 
		                                    f:Hide();
		                                    DequeueCLF(id);
		                                    end )


	
--[[
		f.close = f:CreateTexture()  -- f:CreateTexture(nil, "ARTWORK")
		f.close:SetPoint("CENTER", f.closebutton, "CENTER")
		---fclose:
		-- f.close:SetTexture("-----------")
		f.close:SetTexture("Interface\\Buttons\\UI-DialogBox-Button-Up")
		f.close:SetWidth(butSize)
		f.close:SetHeight(butSize)
		f.close:SetBlendMode("ADD")
		]]



-- local close = CreateFrame('Button', name .. 'Close', frame, 'UIPanelCloseButton')			
-- "Interface\\Buttons\\ButtonHilight-Square"
--"Interface\\Buttons\\UI-Quickslot2"
-- "Interface\\Buttons\\Button-Backpack-Up")
-- "Interface\\Buttons\\UI-Quickslot-Depress"
-- 'Interface\\Buttons\\UI-ActionButton-Border'
-- "Interface\\Buttons\\UI-DialogBox-Button-Up"
-- "UI-GroupLoot-Pass-Down.blp" "UI-GroupLoot-Pass-Highlight.blp" "UI-GroupLoot-Pass-Up.blp" "UI-GroupLoot-Coin-Down.blp" "UI-GroupLoot-Coin-Highlight.blp" "UI-GroupLoot-Coin-Up.blp" "UI-GroupLoot-Dice-Down.blp" "UI-GroupLoot-Dice-Highlight.blp" "UI-GroupLoot-Dice-Up.blp" 
-- "Interface\\Buttons\\UI-DialogBox-Button-Highlight"

-- "Interface\\Icons\\Ability_Seal"
-- "Interface\\Icons\\INV_Misc_EngGizmos_18"
-- "Interface\\Icons\\INV_Misc_OrnateBox"
-- "Interface\\Icons\\INV_Enchant_VoidCrystal"
-- "Interface\\Icons\\Spell_ChargePositive"
-- "Interface\\Icons\\Spell_ChargeNegative"
-- "Interface\\Icons\\INV_Gizmo_SuperSapperCharge"
-- "Interface\\Icons\\INV_Misc_Bomb_09"
-- "Interface\\Icons\\INV_Box_01"

-- [crappy] INV_Sword_06
-- [awesome] INV_Sword_87  , 51
		
		f.pributton = CreateFrame("Button", nil, f)
		f.pributton:SetWidth(butSize)
		f.pributton:SetHeight(butSize)
		f.pributton:SetPoint("CENTER", f, "CENTER", butSize + 24 -(width)/2, 0)
		f.pributton:SetScript( "OnClick", function() 
		                                    if mode then
															SendChatMessage(priKeyword.." "..link,
		                                                    "WHISPER", nil, distro);
		                                    else
															SendChatMessage(link,
		                                                    "WHISPER", nil, distro);		                                    
		                                    end
		                                    f:Hide();
		                                    DequeueCLF(id);
																			end )
		
		f.pri = f:CreateTexture(nil, "ARTWORK")
		f.pri:SetPoint("CENTER", f.pributton, "CENTER")
		-- f.pri:SetTexture("Interface\\AddOns\\ORLIC\\Textures\\globelarge")
		f.pri:SetTexture("Interface\\Icons\\INV_Gizmo_SuperSapperCharge")
		f.pri:SetWidth(butSize)
		f.pri:SetHeight(butSize)
		f.pri:SetBlendMode("ADD")		
		
		
		f.pricapt = f:CreateFontString(nil,"OVERLAY")
		f.pricapt:SetFont(font, math.floor(10 * bidWindowScale))
		f.pricapt:SetWidth(90)
		f.pricapt:SetText(priKeyword)
		f.pricapt:SetShadowOffset(.8, -.8)
		f.pricapt:SetShadowColor(0, 0, 0, 1)
		f.pricapt:ClearAllPoints()
		f.pricapt:SetPoint("BOTTOMLEFT", f.pributton, "BOTTOMLEFT", math.floor(-28 * bidWindowScale), math.floor(-20 * bidWindowScale))
		

		if mode then
			f.secbutton = CreateFrame("Button", nil, f)
			f.secbutton:SetWidth(butSize)
			f.secbutton:SetHeight(butSize)
			f.secbutton:SetPoint("CENTER", f, "CENTER", 0, 0)
			f.secbutton:SetScript( "OnClick", function() 	                                  	
			                                  	SendChatMessage(secKeyword.." "..link,
		                                                       "WHISPER", nil, distro);
		                                    f:Hide();
		                                    DequeueCLF(id);		                                                       
			                                  end )

			f.sec = f:CreateTexture(nil, "ARTWORK")
			f.sec:SetPoint("CENTER", f.secbutton, "CENTER")
			f.sec:SetTexture("Interface\\Icons\\INV_Misc_Bomb_09")			
			f.sec:SetWidth(butSize)
			f.sec:SetHeight(butSize)
			f.sec:SetBlendMode("ADD")		
			
			
			f.seccapt = f:CreateFontString(nil,"OVERLAY")
			f.seccapt:SetFont(font, math.floor(10 *  bidWindowScale))
			f.seccapt:SetWidth(110)
			f.seccapt:SetText(secKeyword)
			f.seccapt:SetShadowOffset(.8, -.8)
			f.seccapt:SetShadowColor(0, 0, 0, 1)
			f.seccapt:ClearAllPoints()
			f.seccapt:SetPoint("BOTTOMLEFT", f.secbutton, "BOTTOMLEFT", math.floor(-40*bidWindowScale), math.floor(-20*bidWindowScale))
			
			
		end
		

		f.passbutton = CreateFrame("Button", nil, f)
		f.passbutton:SetWidth(butSize)
		f.passbutton:SetHeight(butSize)
		f.passbutton:SetPoint("CENTER", f, "CENTER", width/2 - butSize - 24, 0)
		f.passbutton:SetScript( "OnClick", function() 
		                                   	f:Hide();
		                                   	DequeueCLF(id);
		                                   end )

		f.pass = f:CreateTexture(nil, "ARTWORK")
		f.pass:SetPoint("CENTER", f.passbutton, "CENTER")
		f.pass:SetTexture("Interface\\Icons\\Ability_Seal")			
		f.pass:SetWidth(butSize)
		f.pass:SetHeight(butSize)
		f.pass:SetBlendMode("ADD")		
		
		
		f.passcapt = f:CreateFontString(nil,"OVERLAY")
		f.passcapt:SetFont(font, math.floor(10 * bidWindowScale))
		f.passcapt:SetWidth(50)
		f.passcapt:SetText(L["Pass"])
		f.passcapt:SetShadowOffset(.8, -.8)
		f.passcapt:SetShadowColor(0, 0, 0, 1)
		f.passcapt:ClearAllPoints()
		f.passcapt:SetPoint("BOTTOMLEFT", f.passbutton, "BOTTOMLEFT", math.floor(-10*bidWindowScale), math.floor(-20*bidWindowScale))
		
		
		
		f.orlictimeLeft = time;
		f.orlictimemsg = f:CreateFontString(nil,"OVERLAY")
		f.orlictimemsg:SetFont(font, math.floor(10 * bidWindowScale))
		f.orlictimemsg:SetWidth(110)
		f.orlictimemsg:SetText(L["Remaining: "]..f.orlictimeLeft)
		f.orlictimemsg:SetShadowOffset(.8, -.8)
		f.orlictimemsg:SetShadowColor(0, 0, 0, 1)
		f.orlictimemsg:ClearAllPoints()
		f.orlictimemsg:SetPoint("TOPLEFT", f, "TOPLEFT",  math.floor(8*bidWindowScale), math.floor(-8*bidWindowScale))
				

		f:Show();
				
		EnqueueCLF(id, f);
		
		

end


function EnqueueCLF(id, frameObj)

	CLFQueue[id] = frameObj;
	
end


function DequeueCLF(id)
	local obj;
	
	
	obj = CLFQueue[id];
	CLFQueue[id] = nil;
	return obj;
	
end		


function StartTickCLF()
	if clfTickStarted == 0 then
		clfTickStarted = 1;
		TickCLF();
	end
	
end

function TickCLF()
	local windowsOpen = false;
	
	

	for key, id in ipairs(windowIDRecord) do
		local value;
		value = CLFQueue[id];
		
		
		if not (value == nil) then
			windowsOpen = true;		
			if value.orlictimeLeft == 0 then
				value:Hide();
				DequeueCLF(id);
			else
				value.orlictimeLeft = value.orlictimeLeft - 1;
				value.orlictimemsg:SetText(L["Remaining: "]..value.orlictimeLeft);
				value:Show();
			end
		end
	end
	
	if windowsOpen then
		scheduler:ScheduleEvent(TickCLF, 1)	
	else
		ResetCLFs()
	end  

	
end


function ResetCLFs()
	windowIDRecordIndex = 0;
	windowIDRecord = { };
	clfTickStarted = 0;
	CLFQueue = { };

end



-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
-----------------------------DISTRO DUTY!--------------------------------------------------

local	distroRecordIndex = 0;
local distroIDRecord = { };

local distroTabletaItem = { };
local distroTabletaMode = { };
local distroTabletaTime = { };
local distroTabletaID = { };
local distroTabletaIsOpen = false;

local distroTimePassed = -1;

local distro_myname = { };
local DIQ = { };   -- Distro Item Queue.  I KNOW, I KNOW, its not a real FIFO object.  Just a list :P

local recentChat = { };


local recordedItems = { };


function ResetDistroVars()
	distroRecordIndex = 0;
	distroIDRecord = { };

	distroTabletaItem = { };
	distroTabletaMode = { };
	distroTabletaTime = { };
	distroTabletaID = { };	

	distro_myname = { };
	DIQ = { };
	
--	recordedWhispers = { };
	recordedItems = { };	
	distroTabletaIsOpen = false;
	distroTimePassed = -1;
	
end

function EnqueueDIQ(item, key)
	local x;
	
	if Orlic.db.profile.defaults.stripItemLinks == true then
		x = ExtractNameFromLink(item);
	else
		x = item;
	end
	
	-- let it be known key is the window id registered with tablet:Register
	DIQ[key] = x;
end

function DequeueDIQ(key)
	DIQ[key] = nil;
end



----- PRE 2.4 CODE
----- Changes to itemlinks involve references to corpse ID's due to Blizzard's new ID mob system.
----- Sadly, this has to be rewritten
function ItemInDIQ(item)
 	local present;
 		
 	present = false;
 	
 	for key, value in pairs(DIQ) do
-- 		Orlic:PrintLiteral("Value in Queue="..value);
-- 		Orlic:PrintLiteral("Item in tell="..item);
 		if value == item then
-- 			Orlic:Print("Comparison result:  Yep");
			present = true;
		else
--			Orlic:Print("Comparison result:  Nope");
		end
	end
	
	-- If it's been found, it's been found.
--	if present == true then
--		return present;
--	end
	
	-- There are some false positives due to the fact that Blizzard strips some 
	-- information out of the item string after passing strings through their chat servers.
	-- Below, we are going to check to see if Blizzard has mutilated our item link
--	local shortened_version = { };
--	for key, value in pairs(DIQ) do
--		shortened_version = ShortHandLootLink(value);
--		Orlic:PrintLiteral("ShortHandLink="..shortened_version);
		
--		Orlic:PrintLiteral("Item="..item);
		
--		if shortened_version == item then
--		Orlic:Print("Shorthand succeeds.");
--			present = true;
--		else
--		Orlic:Print("Shorthand fails.");
--			present = false;  -- false, still.
--		end
--	end
	
	
	return present;
end


function ExtractNameFromLink(text)
	local s;
	local i;
	
	i = string.find(text, "|h");
	s = string.sub(text, i);
	
-- Orlic:Print("s="..s); 
	return s;

end


-- Deprecated code
function ShortHandLootLink(linkstr)
	local itemhead, itemmidright, itemmidleft, itemtail;
	local a, z;
		
	a, z = string.find(linkstr, "|h");
	itemhead = string.sub(linkstr, 1, a-1);
	itemtail = string.sub(linkstr, a);
		
		

	for x=5, 20 do
		a, z = string.find(itemhead, ":", -x);
		if not (a == nil) then 		
			break;
		end
	end
		
	itemmidright = string.sub(itemhead, a);				
	itemhead = string.sub(linkstr, 1, a-1);	
	
	for x=1, 20 do
		a, z = string.find(itemhead, ":", -x);
		if not (a == nil) then 		
			break;
		end
	end
		
	itemmidleft = string.sub(itemhead, a+1);


	itemhead = string.sub(linkstr, 1, a);
	

	return itemhead.."0:0"..itemtail;
end


function CleanUpDistroVT()

	 scheduler:ScheduleEvent(function() distroTabletaIsOpen = false;  tablet:Close("OrlicDistroTells"); end, 0.1)

end

function ShowTellsString() 
	local tellstr = "";
	local RW;
	local RWIndex;
	
	if Orlic.db.profile.defaults.stripItemLinks == true then
		RWIndex = ExtractNameFromLink(distroTabletaItem);
	else
		RWIndex = distroTabletaItem;
	end

	if distroTabletaMode == true then
 			RW = recordedItems[RWIndex];
 			if not (RW == nil) then
				for key, value in pairs(RW) do
					if (value.interest == PRIMARY) then
						tellstr = tellstr..key.." "..L["[pri]"]..", ";
					elseif (value.interest == SECONDARY) then
						tellstr = tellstr..key.." "..L["[sec]"]..", ";

					end
				end
			end
	
	else	
		RW = recordedItems[RWIndex];
		if not (RW == nil) then
			for key, value in pairs(RW) do
				if value.interest == PRIMARY then
					tellstr = tellstr..key..", ";
				end
			end
		end
	
	
	end
	
	WhisperEditBox:SetText(tellstr);
	WhisperEditBox:HighlightText();
	WhisperFrame:Show();
end



function SetupDistroVT()
	local cat;
 	local RW;
 	local nameAndRank; 
	local RWIndex;
	
	if Orlic.db.profile.defaults.stripItemLinks == true then
		RWIndex = ExtractNameFromLink(distroTabletaItem);
	else
		RWIndex = distroTabletaItem;
	end
 	

	
	tablet:SetTitleColor(0.3, 0.5, 0.7)
	tablet:SetTitle(L["Whispers Received so far"])

	if distroTabletaMode == true then	
			cat = tablet:AddCategory("columns", 2)
			cat:AddLine("text", distroTabletaItem);
			cat:AddLine("text", distroTimePassed, 
			            "textR", 0.3, 
			            "textG", 0.3,
			            "textB", 1,
			            "text2", distroTabletaTime,
			            "text2R",  1,
			            "text2G", 1,
			            "text2B", 1
			            );
			cat:AddLine("text", priKeyword, "text2", secKeyword);
			cat:AddLine("text", " ");
			
 			RW = recordedItems[RWIndex];
 			if not (RW == nil) then
				for key, value in pairs(RW) do
					
					-- key is the person's name btw
					if value.rank == nil then
						nameAndRank = key;
					else
						nameAndRank = key.." ("..value.rank..")";
					end
					
					if (value.interest == PRIMARY) then
	

						cat:AddLine("text", nameAndRank,
						"textR", 1, "textG", 1, "textB", 1,
						"func", ConfirmWinner, 
						"arg1", key,     
						"arg2", distroTabletaItem, 
						"arg3", PRIMARY, 
						"arg4", distroTabletaID);
					elseif (value.interest == SECONDARY) then
						cat:AddLine("text2", nameAndRank, 
						"text2R", 0.7, "text2G", 0.7, "text2B", 0.7,
						"func", ConfirmWinner, 
						"arg1", key, 
						"arg2", distroTabletaItem, 
						"arg3", SECONDARY, 
						"arg4", distroTabletaID);
					end
				end
			end
			
		
	else 
		cat = tablet:AddCategory("columns", 1)
		cat:AddLine("text", distroTabletaItem);		
		cat:AddLine("text", distroTimePassed, 
			            "textR", 0.3, 
			            "textG", 0.3,
			            "textB", 1
			            );		
		cat:AddLine("text", L["Loot Interest"]);
		cat:AddLine("text", " ");		
		
		RW = recordedItems[RWIndex];
		
		if not (RW == nil) then
			for key, value in pairs(RW) do
				if value.interest == PRIMARY then
				
					if value.rank == nil then
						nameAndRank = key;
					else
						nameAndRank = key.." ("..value.rank..")";
					end
				
					cat:AddLine("text", nameAndRank, 
					"textR", 1, "textG", 1, "textB", 1,
					"func", ConfirmWinner, 
					"arg1", key, 
					"arg2", distroTabletaItem, 
					"arg3", PRIMARY_ONLY, 
					"arg4", distroTabletaID);
				end
			end
		end
		
	end
	
	cat:AddLine("text", " ");
	cat:AddLine("text", L["Show String"], "func", ShowTellsString);
	cat:AddLine("text", L["Close"], "func", CleanUpDistroVT);
	            
	
	
--	DebugRW();

end

function DistroViewTells(item, id)

	if confirmLock == true then
		return;
	end


	distroTabletaItem = item;
	distroTabletaID = id;
	
	
		if tablet:IsRegistered("OrlicDistroTells") then
			tablet:Open("OrlicDistroTells")
			distroTabletaIsOpen = true;
			tablet:Refresh("OrlicDistroTells")

			return
		end
	
	
		tablet:Register("OrlicDistroTells", 
		'parent', WorldFrame,
		'strata', "dialog",
		'data', { }, 
		'detachedData', { }, 
		'minWidth', 300,
		'maxHeight', 500,
		'clickable', true,
		'hideWhenEmpty', false,
		'showHintWhenDetached', false ,
		'showTitleWhenDetached', true	, 
--	  'point', function()        return "TOPRIGHT", "TOPLEFT"    end,
    'cantAttach', true,
    'children', SetupDistroVT
 )   
    

		--tablet:SetColor("OrlicDistroTells", 0.3, 0.5, 0.7)
		
		tablet:SetFontSizePercent("OrlicDistroTells", 1.2)
		
		distroTabletaIsOpen = true;
		tablet:Open("OrlicDistroTells")  

		tablet:Close("OrlicDistroTells")
		tablet:Open("OrlicDistroTells")
	
	

end


function DeclareShard(item, windowID)
	local broad;
	local id, channame;
	
	if SOLO_CODING == 1 then
			broad = "CHANNEL"; 
		  id, channame = GetChannelName("orlic");
	else
		  broad = "RAID";
		  id = nil;
		  channame = nil;
	end

	
	SendChatMessage("ORLIC: There is no interest in "..item..", shard/leave it.", broad, nil, id);  
	
	
		
	
	
	-- All this shit needs to be in a cleanup function
	tablet:Close(windowID);

	
	-- Show some confirmation dialogues, THEN call HardCleanDDW
	HardCleanDDW(windowID);


end

function DeclareWinner(person, item, pri_sec_or_silent, wID)
	local msg;
	local broad;
	local id, channame;
	
	if SOLO_CODING == 1 then
			broad = "CHANNEL"; 
		  id, channame = GetChannelName("orlic");
	else
		  broad = "RAID";
		  id = nil;
		  channame = nil;
	end
	
	
	msg = "ORLIC:  "..person.." "..L["wins"].." "..item;
	
	if pri_sec_or_silent == PRIMARY_ONLY then
		msg = msg..".";
	elseif pri_sec_or_silent == PRIMARY then
		-- msg = msg.." "..L["Primary"]..".";
		msg = msg.." "..priKeyword..".";
	elseif pri_sec_or_silent == SECONDARY then
		msg = msg.." "..secKeyword..".";	
	else
		msg = "ORLIC: Oh dear!";
	end
	

	SendChatMessage(msg, broad, nil, id);  
	
	tablet:Close(wID);
	HardCleanDDW(wID);
	
end




function HardCleanDDW(id)
	tablet:Unregister(id);
	DequeueDIQ(id);


end


function Framework.prototype:SetMyNameDistro(myname)
	distro_myname = myname;
end

function Framework.prototype:DistroDutyWindow(item, secondaryMode, time)


		local windowID;
		local baseID;
		local wNum;
		
		local pointerLUA;  -- fuck with the LUA pointer by forcing a copy.  C++ ftw
		                   -- It's actually only needed for the 'children' section of the Register() blocks.
		                   
		-- local boolFIX;     -- Honestly, "false" is eating additional arguments for me.  Sorry Tablet doesn't pass bool args well.
		
		
		if resetLock == true then
			scheduler:ScheduleEvent(function() self:DistroDutyWindow(item, secondaryMode, time) end, 0.1);
			return;
		end
		
		distroTabletaTime = time;
		distroTabletaMode = secondaryMode;
		
		scheduler:ScheduleEvent(function() StartDistroTimer() end, 1);
		
		
		baseID = "OrlicDistroFrame";
		wNum = 1;
		
		for i, id in ipairs(distroIDRecord) do
			windowID = baseID.."_"..wNum;
			if windowID == id then
				 wNum = wNum + 1;
			end
			distroRecordIndex = i;					
		end
		
		distroRecordIndex = distroRecordIndex + 1;
		distroIDRecord[distroRecordIndex] = baseID.."_"..wNum;
		
		pointerLUA = distroIDRecord[distroRecordIndex]; 

--		if secondaryMode == true then 
--			boolFIX = "T";
--		else 
--			boolFIX = "F";
--		end

		EnqueueDIQ(item, pointerLUA);
		

		tablet:Register(distroIDRecord[distroRecordIndex], 
		'parent', WorldFrame,
		'strata', "dialog",
		'data', {  }, 
		'detachedData', { offsetx = 300, offsety= 200 - distroRecordIndex*100 }, 
		'minWidth', 300,
		'maxHeight', 500,
		'clickable', true,
		'hideWhenEmpty', false,
		'showHintWhenDetached', false ,
		'showTitleWhenDetached', true	, 
	  'point',  function() return "TOPLEFT", "TOPLEFT" end,
 		-- 'relativePoint', 
 		-- function() self:SetPoint("TOPLEFT", distroIDRecord[distroRecordIndex], "TOPLEFT", -200, -200)  end,
    'cantAttach', true,
    'children', function()
    
				local cat = tablet:AddCategory("columns", 1)
				tablet:SetTitleColor(0.3, 0.5, 0.7)		
				tablet:SetTitle(L["You're a decider for:"])		
		
				cat:AddLine('text', item);
        cat:AddLine(
							"text", L["View Tells So Far"],
							"textR", 0.7,
							"textG", 0.7,
							"textB", 0.1,
							"justify", "CENTER",
							"wrap", true, 
							"func", DistroViewTells,
							"arg1", item,
-- 							"arg2", boolFIX,
							"arg2", pointerLUA -- distroIDRecord[distroRecordIndex] 
					)        	

        cat:AddLine(
							"text", L["Declare shard/no interest"],
							"textR", 0.7,
							"textG", 0.7,
							"textB", 0.1,
							"justify", "CENTER",
							"wrap", true, 
							"func",  ConfirmShard,
							"arg1", item,
							"arg2", pointerLUA  -- distroIDRecord[distroRecordIndex]
					)        	
					
		    
    
    
			end
 )   
    

		--tablet:SetColor(distroIDRecord[distroRecordIndex], 0.3, 0.5, 0.7)
		
		--tablet:SetFontSizePercent(distroIDRecord[distroRecordIndex], 1.0)
		

		tablet:Open(distroIDRecord[distroRecordIndex])  

		tablet:Close(distroIDRecord[distroRecordIndex])
		tablet:Open(distroIDRecord[distroRecordIndex])



end


function ParseTell(message) 
	local words = { };
	local a, z;
	local adjust = 1;
	

	for word in string.gmatch(message, "%a+") do 
		words[1] = word;
		break;
	end

	if words[1] == nil then
		return nil, nil;
	end

	
	-- a, z = string.find(message:lower(), "primary%s");
	a, z = string.find(message:lower(), priKeyword.."%s");
	if(z == nil) then
		-- a, z = string.find(message:lower(), "secondary%s");
		a, z = string.find(message:lower(), secKeyword.."%s");
	end
	
	if(z == nil) then
		-- a, z = string.find(message:lower(), "primary");
		a, z = string.find(message:lower(), priKeyword);
		if z == nil then
				-- a, z = string.find(message:lower(), "secondary");
				a, z = string.find(message:lower(), secKeyword);
		end
		
		if z == nil then
			return nil, nil;
		else
			adjust = 0;
		end
		
	end
	
	
	
	
	words[2] = string.sub(message, z+adjust) 
	
	
	if words[2] == nil then
		return nil, nil;
	end
	
	-- if words[1]:lower() == "primary" then
	if words[1]:lower() == priKeyword then
		return false, words[2]
	end
	
	-- if words[1]:lower() == "secondary" then
	if words[1]:lower() == secKeyword then
		return true, words[2]
	end
	
	return nil, nil;

end


function Framework.prototype:ReceiveWhisper(person, message)

	local useSec, itemtext, itemtextgroomed;
	local raidMember;
	local orlicheader= { };
	
	raidMember = rosterlib:GetUnitIDFromName(person)


	orlicheader = string.sub(message, 1, 6);

	if not (orlicheader == nil)  then
		if orlicheader == "ORLIC:" then
			return;
		end
	end


	-- Orlic:PrintLiteral(message);

	if distroTabletaMode == true then    -- use secondary
	
			useSec, itemtext = ParseTell(message)
			
		

			if itemtext == nil then
				OrlicDaemonMsg("ORLIC:  ".."Whisper format invalid!  whisper me: '"..priKeyword.."/"..secKeyword.." <itemlink>'", person);
				return;
			end
			

			
			if string.sub(itemtext, 1, 1) == " " then
				itemtext = string.sub(itemtext, 2);
			end
			
			if Orlic.db.profile.defaults.stripItemLinks == true then
				itemtext = ExtractNameFromLink(itemtext);
			end

			-- Orlic:PrintLiteral("whispertext="..itemtext);			
			
			 -- DebugDIQ();
			
			if ItemInDIQ(itemtext) then
					
					if raidMember == nil then
						OrlicDaemonMsg("ORLIC:  "..L["You are not even in the raid!"], person);
						return;
					end
					
					AddItemWhisperToTablet(itemtext, person, true, useSec);					
			else
					OrlicDaemonMsg("ORLIC:  "..L["I am either not doing loot for that item, or your tell isn't formatted properly.  Read raid chat.  Becareful, spaces count."], person);
			end

	else                         -- primary only.
	
		if string.sub(message, 1, 1) == " " then
			itemtext = string.sub(message, 2);
		else
			itemtext = message;			
		end
		
		if Orlic.db.profile.defaults.stripItemLinks == true then
			itemtext = ExtractNameFromLink(itemtext);
		end
		
	
		if ItemInDIQ(itemtext) then 								
		
		
				if raidMember == nil then
					OrlicDaemonMsg("ORLIC:  "..L["You are not even in the raid!"], person);
					return;
				end
		
		
				AddItemWhisperToTablet(itemtext, person, false, false);				
		else
				OrlicDaemonMsg("ORLIC:  "..L["I'm not doing loot for that item, or you didn't link me the item."], person);

		end	
	end


end


function OrlicDaemonMsg(message, person)

	if recentChat[person] == 1 then
		return;
	end
	if not (distro_myname == nil) and not (person == nil) and not (person == "") and not (distro_myname == "")then
		if not (person:lower() == distro_myname:lower()) then    -- prevent a vicious whisper circle!
			SendChatMessage(message, "WHISPER", nil, person);
			recentChat[person] = 1;
			scheduler:ScheduleEvent(function() ThrottleBackChat() end, 2.0)		
		else
 --			Orlic:Print(message);
			recentChat[person] = 1;
			scheduler:ScheduleEvent(function() ThrottleBackChat() end, 2.0)					
		end
	end
end

function ThrottleBackChat()
	recentChat = { };

end


-- This function may be called duplicate times due to the nature of the hook.
-- Only record the tell once.
function AddItemWhisperToTablet(itemlink, person, secondaryOn, useSec)
	local lootinterest;
	local guildrank;
	local prettyprint;
	local RW = { };


	if Orlic.db.profile.defaults.stripItemLinks == true then

		prettyprint = string.sub(itemlink, 4);
		prettyprint = string.sub(prettyprint, 1, string.len(prettyprint)-5);
	else
		prettyprint = itemlink;
	end

-- Orlic:PrintLiteral(prettyprint);

	if not (recordedItems[itemlink] == nil) then
		RW = recordedItems[itemlink];
		if not (RW[person] == nil) then 
	
				if secondaryOn == false then
					return;
				end
								
		
				if useSec == true then
					if RW[person].interest == SECONDARY then
						return;
					end			

					-- only if there is time.
					if distroTabletaTime > distroTimePassed then
						RW[person].interest = SECONDARY;
						recordedItems[itemlink] = RW;
						OrlicDaemonMsg("ORLIC: "..L["Your loot interest has been changed to secondary for: "]..prettyprint, person);
						return;
					else
						return;
					end

			
				else    -- useSec == false
					if RW[person].interest == PRIMARY then
						return;
					end
	
					if distroTabletaTime > distroTimePassed then
						RW[person].interest = PRIMARY;
						recordedItems[itemlink] = RW;
						OrlicDaemonMsg("ORLIC: "..L["Your loot interest has been changed to primary for: "]..prettyprint, person);
						return;
					else
						return;
					end
					
				end
					
			end
	end

	
	
	if secondaryOn == true then
		if useSec == true then
			lootinterest = SECONDARY;
		else
			lootinterest = PRIMARY;
		end
	else
		lootinterest = PRIMARY;
	end
		
	
	if secondaryOn == true then
		if useSec == true then
			OrlicDaemonMsg("ORLIC:  "..L["I have received and registered your tell for:"].." "..prettyprint.." ["..secKeyword.."]", person);
		else
			OrlicDaemonMsg("ORLIC:  "..L["I have received and registered your tell for:"].." "..prettyprint.." ["..priKeyword.."]", person);
		end
	else
			OrlicDaemonMsg("ORLIC:  "..L["I have received and registered your tell for:"].." "..prettyprint, person);
	end

	guildrank = GetRank(person);

	RW[person] = { };
	RW[person].interest = lootinterest;
	RW[person].rank = guildrank;

	-- RW[person] = lootinterest;	
	recordedItems[itemlink] = RW;
	
	
end

function GetRank(person)
local name, rank, rankIndex, level, class, zone, note, officernote, online, status;

	if not IsInGuild() then
		return nil;
	end

	for x=1, 100 do
		name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(x)
		if name == nil then
			break;
		end
		
		if name == person then
			return rank;
		end
	end
	
	return nil;

end


function StartDistroTimer()
	if distroTimePassed < 0 then
		distroTimePassed = 0;
		scheduler:ScheduleEvent(TickDistro, 1)		
	end
	
end

function TickDistro()
	local diqs_open = false;
	
	if distroTimePassed < 0 then
		return;
	end
	
	
	if distroTabletaIsOpen == true then
		tablet:Refresh("OrlicDistroTells");
	end
	
	for key, value in pairs(DIQ) do
		diqs_open = true;
	end
	
	
	if diqs_open == true then
		distroTimePassed = distroTimePassed + 1;		
		scheduler:ScheduleEvent(TickDistro, 1)
	else
		AllLootDone();
	end
	
	
end


function CleanUpConfirmShard(item, id, shardit)

	scheduler:ScheduleEvent( function() 
															tablet:Close("OrlicConfirmDialog");  
															tablet:Unregister("OrlicConfirmDialog"); 
															confirmLock = false;
															end, 0.1);
	
	if shardit == true then
		DeclareShard(item, id);
	end


end


function ConfirmShard(item, id)

	if confirmLock == true then
		return;
	end

	if distroTabletaIsOpen == true then
		tablet:Close("OrlicDistroTells");
		distroTabletaIsOpen = false;
	end

		confirmLock = true;

		tablet:Register("OrlicConfirmDialog", 
		'parent', WorldFrame,
		'strata', "dialog",
		'data', {  }, 
		'detachedData', {  }, 
		'minWidth', 300,
		'maxHeight', 500,
		'clickable', true,
		'hideWhenEmpty', false,
		'showHintWhenDetached', false ,
		'showTitleWhenDetached', true	, 
	  'point',  function() return "TOPLEFT", "TOPLEFT" end,
    'cantAttach', true,
    'children', function()
				local cat = tablet:AddCategory("columns", 1)
				tablet:SetTitleColor(0.3, 0.5, 0.7)		
				tablet:SetTitle(L["Confirm Action"])	
				cat:AddLine('text', L["Declare shard: "]..item);
        cat:AddLine(
							"text", L["YES"],
							"justify", "CENTER",
							"wrap", true, 
							"func",  CleanUpConfirmShard,
							"arg1", item,
							"arg2", id,
							"arg3", true
					)        	

        cat:AddLine(
							"text", L["NO"],
							"justify", "CENTER",
							"wrap", true, 
							"func",  CleanUpConfirmShard,
							"arg1", item,
							"arg2", id,
							"arg3", false
					)        	
					    
    
			end
 )   
    

		--tablet:SetColor(distroIDRecord[distroRecordIndex], 0.3, 0.5, 0.7)
		
		tablet:SetFontSizePercent("OrlicConfirmDialog", 1.3)
		

		tablet:Open("OrlicConfirmDialog")  

		tablet:Close("OrlicConfirmDialog")
		tablet:Open("OrlicConfirmDialog")



end



function CleanUpConfirmWin(person, item, PSS, id, confirmed)


	scheduler:ScheduleEvent( function() tablet:Close("OrlicConfirmWinDialog"); 
	                                    tablet:Unregister("OrlicConfirmWinDialog"); 	
	                                    confirmLock = false;
	                                    end, 0.1);
	
	
	if confirmed == true then	
		DeclareWinner(person, item, PSS, id);
	end


end

function ConfirmWinner(person, item, PSS, id)

		distroTabletaIsOpen = false;
		tablet:Close("OrlicDistroTells");
		
		confirmLock = true;
		
		tablet:Register("OrlicConfirmWinDialog", 
		'parent', WorldFrame,
		'strata', "dialog",
		'data', {  }, 
		'detachedData', {  }, 
		'minWidth', 300,
		'maxHeight', 500,
		'clickable', true,
		'hideWhenEmpty', false,
		'showHintWhenDetached', false ,
		'showTitleWhenDetached', true	, 
	  'point',  function() return "TOPLEFT", "TOPLEFT" end,
    'cantAttach', true,
    'children', function()
				local cat = tablet:AddCategory("columns", 1)
				tablet:SetTitleColor(0.3, 0.5, 0.7)		
				tablet:SetTitle(L["Confirm Action"])	
				cat:AddLine('text', L["Confirm Winner: "]..person, "justify", "CENTER");
				cat:AddLine('text', L["For Item: "]..item, "justify", "RIGHT");
        cat:AddLine(
							"text", L["YES"],
							"justify", "CENTER",
							"wrap", true, 
							"func",  CleanUpConfirmWin,
							"arg1", person,
							"arg2", item,
							"arg3", PSS,
							"arg4", id,
							"arg5", true
					)        	

        cat:AddLine(
							"text", L["NO"],
							"justify", "CENTER",
							"wrap", true, 
							"func", CleanUpConfirmWin,
							"arg1", person,
							"arg2", item,
							"arg3", PSS,
							"arg4", id,
							"arg5", false
							
					)        	
					    
    
			end
 )   
    

		
		tablet:SetFontSizePercent("OrlicConfirmWinDialog", 1.3)
		

		tablet:Open("OrlicConfirmWinDialog")  

		tablet:Close("OrlicConfirmWinDialog")
		tablet:Open("OrlicConfirmWinDialog")



end



function AllLootDone() 

	local x;

	if Orlic:IsHooked("ChatFrame_MessageEventHandler") then
  	Orlic:Unhook("ChatFrame_MessageEventHandler")
  end    
  
  x = distro_myname;

	ResetDistroVars()    -- resets distro_myname =-)
	
	Orlic:DistroReportingDone(x);
	

end



function Framework.prototype:RLStartLoot(selfcall)

	local xObj;
	local amDistro = false;
	
	
	resetLock = true;
	
	
		if tablet:IsRegistered("OrlicDistroTells") then
				if distroTabletaIsOpen == true then
					tablet:Close("OrlicDistroTells");
					distroTabletaIsOpen = false;
				end
				
				tablet:Unregister("OrlicDistroTells")
		end
		
		if tablet:IsRegistered("OrlicConfirmDialog") then
				tablet:Close("OrlicConfirmDialog");
				tablet:Unregister("OrlicConfirmDialog")
		end

		if tablet:IsRegistered("OrlicConfirmWinDialog") then
				tablet:Close("OrlicConfirmWinDialog");
				tablet:Unregister("OrlicConfirmWinDialog")
		end
	
	
	-- clean up anything left in DIQ from a previous run of loot.
	for key, value in pairs(DIQ) do
		amDistro = true;
		tablet:Close(key);
		HardCleanDDW(key);
	end

	ResetDistroVars();
	
	confirmLock = false;
	
	for key, value in pairs(CLFQueue) do
		xObj = DequeueCLF(key);	
		xObj:Close();
	end
	
	ResetCLFs()


	resetLock = false;	
	
	-- We could, for amDistro == true, report in so that outstanding distros gets set to 0 for the raid leader.
	-- For now, I hard set it to 0 when in the Toggle function in Orlic.lua
	-- Consider, for example, the user disconnected, or heaven forbid, isn't even running the mod.
	-- There is also the touchy matter that the call order is:  RLStartLoot, item, item, item.
	-- Checking in, you know, would definitely confuse the raid leader's mod to think you're checking in 
	-- for THIS occurrence of loot in progress.
	
end




function DebugRW() 

	Orlic:Print("---pass---");
	Orlic:Print("Relevant Distro Tableta: "..distroTabletaItem);
	for k1, v1 in pairs(recordedItems) do
		for k2, v2 in pairs(recordedItems[k1]) do
			Orlic:Print("item="..k1.."   person="..k2.."   pri/sec="..v2.interest);
		end
	end
	Orlic:Print("---end pass---");


end

function DebugDIQ()
	Orlic:Print("DebugDIQ");
	for k, v in pairs (DIQ) do
		Orlic:Print("DebugDIQ -- in queue! -- "..v);
		Orlic:PrintLiteral(v);
	end
end
