﻿

local L = AceLibrary("AceLocale-2.2"):new("Orlic")

local options = { 
    type='group',
    args = {
--				config = {

				
				
--				},
    },
}

local SOLO_DEV = false;

local loot_in_progress = false;
local loot_open;
local distrosForResolution;
local FW = { }
local OC = { }

-- GTT = { };


-- Create Orlic as an ACE Module w/ its respective libraries.
Orlic = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "AceComm-2.0", "AceHook-2.1", "FuBarPlugin-2.0")
local waterfall = AceLibrary("Waterfall-1.0")


-- Create some very default slash commands.
Orlic:RegisterChatCommand(L["Slash-Commands"], options)




-- Database registration and defaults
Orlic:RegisterDB("ORLICDB", "ORLICDBPC")
Orlic:RegisterDefaults("profile", {

	defaults = {    

			lootDistros = { },
			defaultLootTime = 60,
			bidWindowScale = 74.0,
		    useSecondary = false,
		    primaryKeyword = "primary",
		    secondaryKeyword = "secondary",
		    permitTransparency = false,
		    stickyBid = false,
		    
		    -- developer use only
		    stripItemLinks = true,
	    
  }
    
} )


--Fubar
Orlic.title = "ORLIC";
Orlic.hasNoColor = true;
Orlic.cannotDetachTooltip = true;
Orlic.hasIcon = "Interface\\Icons\\INV_Misc_Bag_SatchelofCenarius";


Orlic.OnMenuRequest = {
   type = 'group',
   args = {
		senseloot = {
			type = "execute",
			name = L["Start Loot"],
			desc = L["Start the loot divvy process.  You need to have a loot-window open when you activate this."],
			func = function() Orlic:RaidLeaderStartDivvy() end,
			disabled = function()
				 
				 if SOLO_DEV then
				 		return loot_in_progress;
				 else
						return loot_in_progress or (not (IsRaidLeader("player") or IsRaidOfficer("player") or IsPartyLeader("player") or (GetNumPartyMembers() + GetNumRaidMembers() == 0))  )
						--return loot_in_progress or (not (IsRaidLeader("player") or IsPartyLeader("player") or (GetNumPartyMembers() + GetNumRaidMembers() == 0))  )
				 end
			end,
			order = 500
		},
   
   }
 }




function Orlic:OnInitialize()
    -- onLoad event...
           
    

	local Distros = { };
	distrosForResolution = 0;
	
  
  self:Hook("ChatFrame_MessageEventHandler", "ParseWhisper", true)
  
	
	
	for k, person in ipairs(Orlic.db.profile.defaults.lootDistros) do
		Distros[k] = person

	end
	
	self.waterfallOptions.args.raidleader.args.lootdistros.args.removeuser.validate	= Distros;
	
	waterfall:Register('Orlic', 
                   'aceOptions', self.waterfallOptions,  
                  'title','ORLIC Configuration',
                   'colorR', .3, 'colorG', .5, 'colorB' , .7)
                   
--	self.OnMenuRequest = self.fubarOptions

	self.loot_open = false;
	
--	GTT = new CreateFrame("GameTooltip", nil, nil);
	
	FW = Framework:new()
	OC = OrlicComm:new()
	

	
end

function Orlic:OnEnable()

    self:RegisterEvent("LOOT_OPENED")
  	self:RegisterEvent("LOOT_CLOSED")    
    
    
    OC:Enable()
    FW:Enable()
    
	if self:IsHooked("ChatFrame_MessageEventHandler") then
  	self:Unhook("ChatFrame_MessageEventHandler")
  end    
  
  
    
end
    
    

function Orlic:OnDisable()

	FW:Disable()
	OC:Disable()

end


--From Fubar
function Orlic:OnClick() 

		waterfall:Open('Orlic')


end


function Orlic:ToggleLootInProgress()

	loot_in_progress = not loot_in_progress;

	distrosForResolution = 0;
end



function Orlic:LOOT_OPENED() 
	self.loot_open = true

end

function Orlic:LOOT_CLOSED()
	self.loot_open = false

end

function Orlic:RefreshWaterfall()


	local Distros = { };
	
	for k, person in ipairs(Orlic.db.profile.defaults.lootDistros) do
		Distros[k] = person

	end
	
	self.waterfallOptions.args.raidleader.args.lootdistros.args.removeuser.validate	= Distros;

	waterfall:Refresh('Orlic')

end



function Orlic:RaidLeaderStartDivvy() 

	local arr;
	local shakeduplicates;
	local offset = 0;
	local hasItems = false;

	--INV Axe 66
	if self.loot_open == false then
		FW.NeedLootWindowOpenMsg()
		return
	end	
	
	arr = { "Nothing!" };

	local numItems = GetNumLootItems()
	
	for x=1, numItems do
	
		local itemlink = GetLootSlotLink(x)
		if not (itemlink == nil) then 
			arr[x-offset] = itemlink;
			hasItems = true;
		else 
			offset = offset + 1;
		end
		
		
		--lootIcon, lootName, lootQuantity, rarity = GetLootSlotInfo(x);		
		--self:Print(lootQuantity)
	end	


	
	-- HelloWorld:HelloWorld();
	if hasItems == true then
	  loot_in_progress = true;
	  
	  shakeduplicates = { };
	  for key, value in ipairs(arr) do
	    -- 1 is just a placeholder.  Duplicate item values will result in index collisions, losing data (we want this).
	  	shakeduplicates[value] = 1;
	  end
	  
	  offset = 1;
	  arr = { };
	  for key, value in pairs(shakeduplicates) do
	  	arr[offset] = key;
	  	offset = offset + 1;
	  end
	  
		FW:DivvyPane(arr)
	end
	

end


function Orlic:AssignDistro(distro) 
	local Distros = { };
	local x;

	x = 0;
	for k, person in ipairs(Orlic.db.profile.defaults.lootDistros) do
		Distros[k] = person
		x = k;
	end

	x = x + 1;
	Distros[x] = distro;
	
	Orlic.db.profile.defaults.lootDistros	= Distros;

end


-- lootlist w/ number index, and assignments w/ lootlink index for distro person.
function Orlic:BeginLootBroadcast(lootlist, assignments)

			local id, channame;
			local broad;			
			local dists;

			
			
			if SOLO_DEV then
				broad = "CHANNEL"; 
		  	id, channame = GetChannelName("orlic");
		  else
		  	broad = "RAID";
		  	id = nil;
		  	channame = nil;
		  end
		  
		  
			SendChatMessage("ORLIC loot distribution started.  If you do not have it installed, send tells in the following format:",
		                   broad, nil, id);
		                   

			if Orlic.db.profile.defaults.useSecondary then
				SendChatMessage("/whisper <name> "..Orlic.db.profile.defaults.primaryKeyword.." <lootlink>",
		                   broad, nil, id);			
				SendChatMessage("or, /whisper <name> "..Orlic.db.profile.defaults.secondaryKeyword.." <lootlink>",
		                   broad, nil, id);
		  else
		  	SendChatMessage("/whisper <name> <lootlink>",
		                   broad, nil, id);					                   
		  end
		  
		 
		 OC:RLStartLoot();



		for k, item in ipairs(lootlist) do
			
			SendChatMessage(k..".  Send tells to "..assignments[item].." for "..item,
		                   broad, nil, id);			
			OC:NotifyDropPair(item, assignments[item]);
		end
		
		
		dists = { };
		for key, value in pairs(assignments) do
			dists[value] = 1;
		end
		
		for key, value in pairs(dists) do
			distrosForResolution = distrosForResolution + 1;
		end
		
		
		
		-- This line is a courtesy if they want to do more loot fast.
		Orlic:ToggleLootInProgress();    

end

function Orlic:ShowLootInterestWindow(itemlink, distro, secondaryMode, time) 
	
	FW:ShowLootInterestWindow(itemlink, distro, secondaryMode, time)
end


function Orlic:YOUGOTDISTRODUTY(item, secondaryMode, time, myname)


	-- unhook when the last of the distro windows closes.
	if not self:IsHooked("ChatFrame_MessageEventHandler") then
  	self:Hook("ChatFrame_MessageEventHandler", "ParseWhisper", true)
  end
  GuildRoster();    -- won't call more once every 10 seconds according WoW-Wiki.
  FW:SetMyNameDistro(myname);
	FW:DistroDutyWindow(item, secondaryMode, time);
	

end

function Orlic:ParseWhisper(source, event, ...)
--	self:Print(source)
--	self:Print(event)
--	self:Print(arg1)
--	self:Print(arg2)

	if event == "CHAT_MSG_WHISPER" and type(arg1) == "string" and type(arg2) == "string" then
		FW:ReceiveWhisper(arg2, arg1);		
	end
	
	return self.hooks["ChatFrame_MessageEventHandler"](source, event, ...)	

end


function Orlic:DistroReportingDone(name)

		OC:AnnounceDistroDone(name);

end


function Orlic:DistDoneCommReceived(name)

	-- Umm, ok, it stands to reason if I started the loot process, I'm the only one who should have 
	-- loot_in_progress on.  Everyone else will see "Start Loot" grayed out because they're not raid leader

	if IsRaidLeader("player") or IsPartyLeader("player") then
		if loot_in_progress == true then
		
			distrosForResolution = distrosForResolution - 1;
			
			if distrosForResolution == 0 then
				loot_in_progress = false;
			end
		end
	end

end

function Orlic:RLStartLoot(selfcall)
	FW:RLStartLoot(selfcall);
end

function Orlic:SetLeaderSettings(priKeyword, secKeyword, amILeader, permitTransparency)

	if amILeader == true then
		FW:SetKeywords(Orlic.db.profile.defaults.primaryKeyword, Orlic.db.profile.defaults.secondaryKeyword);
		return;
	end
	
	FW:SetKeywords(priKeyword, secKeyword);

end