﻿OrlicComm = AceLibrary("AceOO-2.0").Class()

Orlic.commPrefix = "Orlic"



function OrlicComm.prototype:Disable()

	Orlic:UnregisterComm(Orlic.commPrefix, "RAID");
	Orlic:UnregisterComm(Orlic.commPrefix, "WHISPER");	

end


-- SendAddonMessage

function OrlicComm.prototype:Enable()

		
		Orlic:SetCommPrefix(Orlic.commPrefix)
		Orlic:RegisterComm(Orlic.commPrefix, "RAID",  MessageReceive)
		Orlic:RegisterComm(Orlic.commPrefix, "WHISPER",  WhisperMessageReceive)

			
end

function MessageReceive(prefix, sender, distribution, arg1, arg2, arg3, arg4, arg5, arg6, arg7, ...)



	if arg1 == "RLStartLoot" then 
		Orlic:SetLeaderSettings(arg2, arg3, arg4, arg5);
	
		Orlic:RLStartLoot(arg4);
	end
	
	if arg1 == "BroadCastItems" then
	
		if arg2 == nil or arg6 == nil or arg7 == nil then
			Orlic:Print("ORLIC: "..sender..L[" is sending you invalid add-on broadcast codes.  He/she needs to update."]);
			return;
		end

		Orlic:ShowLootInterestWindow(arg2..arg6..arg7, arg3, arg4, arg5);

	end
	
	if arg1 == "DistroDone" then
		Orlic:DistDoneCommReceived(arg2);
	end
	
end


function WhisperMessageReceive(prefix, sender, distribution, arg1, arg2, arg3, arg4, arg5, arg6, ...) 

	Orlic:YOUGOTDISTRODUTY(arg1..arg5..arg6, arg2, arg3, arg4);

end



function OrlicComm.prototype:NotifyDropPair(item, distro)

		local secondaryMode = false;
		local time;
		local name, realm;
		local itemhead, itemmid, itemtail;
		local a, z;

		
		secondaryMode = Orlic.db.profile.defaults.useSecondary;
		time = Orlic.db.profile.defaults.defaultLootTime;
		
-- Orlic:PrintLiteral(item);		
		-- Workaround a bug in AceComm
			a, z = string.find(item, "|h");
			itemhead = string.sub(item, 1, a-1);
			itemtail = string.sub(item, a);
		
		
--		Orlic:PrintLiteral(itemhead);
--		Orlic:PrintLiteral(itemtail);

			for x=5, 20 do
				a, z = string.find(itemhead, ":", -x);
				if not (a == nil) then 
								
					break;
				end
			end
		
			itemmid = string.sub(itemhead, a+1);
		
		
			itemhead = string.sub(item, 1, a);
--		 Orlic:Print("------");
--		 Orlic:PrintLiteral(itemhead);
--		 Orlic:PrintLiteral(itemmid);	
--		 Orlic:PrintLiteral(itemtail);	
				

		
			if itemhead == nil or itemtail == nil or itemmid == nil then
				-- I know, I skipped localizations.  Sue me.
				Orlic:Print("itemhead and/or itemtail was nil!  This error is severe -- some itemlinks may be 'tainted'");			
				Orlic:Print("This is most LIKELY caused by someone in your raid is running an improperly modified version of the mod.");
				Orlic:Print("There might be other reasons.  I recommend restarting loot for this corpse.");
				Orlic:Print("If you see this again, I recommend distributing manually.");
				itemhead = item;
				itemtail = "";
			end
		

	    Orlic:SendCommMessage("RAID", "BroadCastItems", itemhead, distro, secondaryMode, time, itemmid, itemtail)    
		name, realm = UnitName("player");
	    MessageReceive(Orlic.commPrefix, name, "RAID", "BroadCastItems", itemhead, distro, secondaryMode, time, itemmid, itemtail)

	    -- Now notify the distros, even if I am one.
	    if name == distro then
    		WhisperMessageReceive(Orlic.commPrefix, name, "WHISPER", itemhead, secondaryMode, time, distro, itemmid, itemtail);
	    else
    		Orlic:SendCommMessage("WHISPER", distro, itemhead, secondaryMode, time, distro, itemmid, itemtail) 
    	end
    	        
    
        


end



function OrlicComm.prototype:AnnounceDistroDone(distro)

		-- End of the distro's thread.
    Orlic:SendCommMessage("RAID", "DistroDone", nil, distro, nil, nil)    
    
    
end


function OrlicComm.prototype:RLStartLoot()

    Orlic:SendCommMessage("RAID", 
                    "RLStartLoot",  -- arg1
    				Orlic.db.profile.defaults.primaryKeyword,   -- arg2
    				Orlic.db.profile.defaults.secondaryKeyword, -- arg3
    				false,  -- arg4
    				Orlic.db.profile.defaults.permitTransparency   -- This is not binding.  Hacking add-on chat won't help.
    				);
    
    -- the text nils is they don't fark my debug messages.  Its a local call anyway, no data xmit.
    MessageReceive(Orlic.commPrefix, "nil", "RAID", "RLStartLoot", "nil", "nil", true, "nil");
end