
----------------------------------------------------------------------------------------
--	Text Format Vars
--		(HP/MP text and status bars)
--		$miss = Missing hp/mp
--		$cur = current hp/mp
--		$max = Max hp/mp
--		$perc = Percent hp/mp
--
--		(Name/Level text)
--		$name = Name
--		$level = Level
--		$class = Class
--		$guild = Guild
--		$race = Race
--		$rname = PvP Rank Name
--		$rnum = PvP Rank Number
--		$key = Key Binding
--
--	Element Names
--		hp, mp, xp, combo, target
--		name, level, class, race
--		pvp, leader, master, feedback
--		group, status, buff, debuff
--		raidtarget, highlight, pet, portrait
--
--	StatusBar Animations
--		glide
----------------------------------------------------------------------------------------

function Nurfed_HealthPercColor(perc, unit)
	local color = {};
	if (perc > 0.6) then
		color.r = (54/255);
		color.g = (86/255);
		color.b = (111/255);
	else
		if (perc > 0.2) then
			color.r = (( 255+((0.6-perc)*100*(128/40)))/255);
			color.g = ((100+((0.6-perc)*100*(-89/40)))/255);
			color.b = ((100+((0.6-perc)*100*(-136/40)))/255);
		else
			color.r = (255/255);
			color.g = (17/255);
			color.b = (17/255);
		end
	end
	if (unit) then
		local change = getglobal("Nurfed_"..unit.."name");
		if (unit == "target") then
			if (UnitIsTapped(unit) and not UnitIsTappedByPlayer(unit)) then
				change:SetBackdropColor(1, (165/255), 0, .95);
			elseif (UnitIsTapped(unit) and UnitIsTappedByPlayer(unit)) then
				change:SetBackdropColor(1, 0, 0, .95);
			elseif (UnitPlayerControlled(unit) and UnitCanAttack(unit, "player") and UnitCanAttack("player", unit)) then
				change:SetBackdropColor(1, 0, 0, .95);
			elseif (UnitCreatureType(unit) == "Humanoid" and UnitIsFriend("player", unit) and not UnitIsPlayer(unit)) then
				change:SetBackdropColor(0, (100/255), 0, .95);
			else
				change:SetBackdropColor(.06, .13, .22, .95);
			end
		end
	end
	return color;
end

ManaBarColor[0] = { r = (115/255), g = (184/255), b = (255/255), prefix = MANA };	-- mana
ManaBarColor[1] = { r = (255/255), g = (100/255), b = (100/255), prefix = RAGE_POINTS };	-- rage
ManaBarColor[2] = { r = (255/255), g = (255/255), b = (120/255), prefix = FOCUS_POINTS };	-- focus
ManaBarColor[3] = { r = (200/255), g = (200/255), b = (0/255), prefix = ENERGY_POINTS };	-- energy
ManaBarColor[4] = { r = (160/255), g = (170/255), b = (185/255), prefix = HAPPINESS_POINTS };	-- happiness


if (not Nurfed_UnitsLayout) then

	Nurfed_UnitsLayout = {};

	Nurfed_UnitsLayout.Name = "|cffff0000Stupified Layout v2.0|r";
	Nurfed_UnitsLayout.Author = "Benumbed - modified by Andeh";

-- ==============================
-- Frame Templates
-- ==============================
	
	Nurfed_UnitsLayout.templates = {
		Nurfed_Unit_10 = {
			type = "Font",
			Font = { NRF_FONT.."Charcoal.ttf", 10, "OUTLINE" },
			TextColor = { 1, 1, 1 },
		},
		Nurfed_Unit_12 = {
			type = "Font",
			Font = { NRF_FONT.."Charcoal.ttf", 12, "OUTLINE" },
			TextColor = { 1, 1, 1 },
		},
		Nurfed_Unit_14 = {
			type = "Font",
			Font = { NRF_FONT.."Charcoal.ttf", 14, "OUTLINE" },
			TextColor = { 1, 1, 1 },
		},

		Nurfed_Unit_backdrop = {
			bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
			edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
			tile = true,
			tileSize = 16,
			edgeSize = 16,
			insets = { left = 4, right = 4, top = 4, bottom = 4 },
		},
		
		Nurfed_Unit_backdrop2 = {
			bgFile = NRF_IMG.."statusbar5",
			edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
			tile = true,
			tileSize = 16,
			edgeSize = 16,
			insets = { left = 4, right = 4, top = 4, bottom = 4 },
		},
		
		Nurfed_Unit_model = {
			type = "PlayerModel",
			FrameStrata = "LOW",
			ModelScale = 1.9,
			Camera = 0,
			FrameLevel = 1,
		},

		Nurfed_Unit_portrait = {
			type = "Texture",
			FrameStrata = "LOW",
			FrameLevel = 1,
		},

		Nurfed_Model_frame = {
			type = "Frame",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 1 },
		},
		
		Nurfed_BuffTemp = {
			type = "Button",
			uitemp = "TargetDebuffButtonTemplate",
			size = {20,20},
		},
		
		Nurfed_Info_frame = {
			type = "Frame",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 1 },
		},
		
-- ==============================
-- Player Frame Templates
-- ==============================

		Nurfed_Unit_Player_casting = {
			type = "Frame",
			size = { 159, 25 },
			FrameStrata = "LOW",
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 1 },
			children = {
				casting = {
					type = "StatusBar",
					size = { 145, 11 },
					Orientation = "HORIZONTAL",
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
					StatusBarTexture = NRF_IMG.."statusbar8",
					FrameLevel = 2,
					children = {
						info = {
							template = "Nurfed_Info_frame",
							size = { 44, 25 },
							Anchor = { "TOPRIGHT", "$parent", "TOPLEFT", -4, 7 },
						},
						text = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 120, 10 },
							JustifyH = "LEFT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 0 },
							vars = { format = "$spell ($rank)" },
						},
						time = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 40, 10 },
							JustifyH = "RIGHT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "CENTER", "$parentinfo", "CENTER", -6, 0 },
						},

					},
					Hide = true,
				},
			},
			Hide = true,
		},

		Nurfed_Player_Name_frame = {
			type = "Frame",
			Backdrop = "Nurfed_Unit_backdrop2",
			BackdropColor = { 0, 0, 0, 1 },
			children = {
				text = {
					type = "FontString",
					size = { 95, 25 },
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "LEFT",
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 0 },
					vars = { format = "$name" },
				},
				text2 = {
					type = "FontString",
					size = { 95, 25 },
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "RIGHT",
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, 0 },
					vars = { format = "$guild" },
				},
			},
		},
		
		Nurfed_Unit_Player_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "LEFT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 0 },
					vars = { format = "$cur / $max" },
				},
				text2 = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.25 },
					ShadowOffset = { 1, -1 },
					TextColor = { 1, 0.25, 0 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, 0 },
					vars = { format = "$miss" },
				},
				hpperc = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					TextColor = { 1, 1, 1 },
					JustifyH = "LEFT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "BOTTOMLEFT", "$parent", "TOPRIGHT", -30, 4 },
					vars = { format = "$perc" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Player_mp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 0, 1, 1, 0.25 },
					Anchor = "all" },
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "LEFT",
					ShadowColor = { 0, 0, 0, 0.75 },
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 0 },
					vars = { format = "$cur / $max" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Player_ToT_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "CENTER",
					ShadowColor = { 0, 0, 0, 0.25 },
					ShadowOffset = { 1, -1 },
					Anchor = { "CENTER", "$parent", "CENTER", 132, 0 },
					vars = { format = "$perc" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Player_ToT = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 198, 20 },
			FrameStrata = "LOW",
			FrameLevel = 1,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			children = {
				info = {
					template = "Nurfed_Info_frame",
					size = { 68, 20 },
					Anchor = { "TOPLEFT", "$parent", "TOPRIGHT", -2, 0 },
				},
				name = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parenthp", "LEFT", 5, 0 },
					vars = { format = "$name" },
				},
				hp = {
					template = "Nurfed_Unit_Player_ToT_hp",
					size = { 183, 6},
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -7 },
				},
				highlight = {
					type = "Texture",
					size = { 188, 10 },
					layer = "ARTWORK",
					Texture = "Interface\\QuestFrame\\UI-QuestTitleHighlight",
					BlendMode = "ADD",
					Alpha = 0.50,
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
				},
			},
			Hide = true,
		},

-- ==============================
-- Target Frame Templates
-- ==============================

		Nurfed_Unit_Target_casting = {
			type = "Frame",
			size = { 159, 25 },
			FrameStrata = "LOW",
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 1 },
			children = {
				casting = {
					type = "StatusBar",
					size = { 145, 11 },
					Orientation = "HORIZONTAL",
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
					StatusBarTexture = NRF_IMG.."statusbar8",
					FrameLevel = 2,
					children = {
						info = {
							template = "Nurfed_Info_frame",
							size = { 44, 25 },
							Anchor = { "TOPRIGHT", "$parent", "TOPLEFT", -4, 7 },
						},
						text = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 120, 10 },
							JustifyH = "LEFT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 0 },
							vars = { format = "$spell ($rank)" },
						},
						time = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 40, 10 },
							JustifyH = "RIGHT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "CENTER", "$parentinfo", "CENTER", -6, 0 },
						},

					},
					Hide = true,
				},
			},
			Hide = true,
		},

		Nurfed_Target_Name_frame = {
			type = "Frame",
			Backdrop = "Nurfed_Unit_backdrop2",
			BackdropColor = { 0, 0, 0, 1 },
			children = {
				text = {
					type = "FontString",
					size = { 95, 25 },
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "LEFT",
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 0 },
					vars = { format = "$name" },
				},
				text2 = {
					type = "FontString",
					size = { 95, 25 },
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "RIGHT",
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, 0 },
					vars = { format = "$guild" },
				},
			},
		},
		
		Nurfed_Unit_Target_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "LEFT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 0 },
					vars = { format = "$cur / $max" },
				},
				text2 = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.25 },
					ShadowOffset = { 1, -1 },
					TextColor = { 1, 0.25, 0 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, 0 },
					vars = { format = "$miss" },
				},
				hpperc = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					TextColor = { 1, 1, 1 },
					JustifyH = "LEFT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "BOTTOMLEFT", "$parent", "TOPRIGHT", -30, 4 },
					vars = { format = "$perc" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Target_mp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 0, 1, 1, 0.25 },
					Anchor = "all" },
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "LEFT",
					ShadowColor = { 0, 0, 0, 0.75 },
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 0 },
					vars = { format = "$cur / $max" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Target_ToT_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "CENTER",
					ShadowColor = { 0, 0, 0, 0.25 },
					ShadowOffset = { 1, -1 },
					Anchor = { "CENTER", "$parent", "CENTER", 66, 0 },
					vars = { format = "$perc" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Target_ToT = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 99, 20 },
			FrameStrata = "LOW",
			FrameLevel = 1,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			children = {
				info = {
					template = "Nurfed_Info_frame",
					size = { 34, 20 },
					Anchor = { "TOPLEFT", "$parent", "TOPRIGHT", -2, 0 },
				},
				name = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parenthp", "LEFT", 5, 0 },
					vars = { format = "$name" },
				},
				hp = {
					template = "Nurfed_Unit_Target_ToT_hp",
					size = { 85, 6},
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -7 },
				},
				highlight = {
					type = "Texture",
					size = { 94, 10 },
					layer = "ARTWORK",
					Texture = "Interface\\QuestFrame\\UI-QuestTitleHighlight",
					BlendMode = "ADD",
					Alpha = 0.50,
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
				},
			},
			Hide = true,
		},

-- ==============================
-- Pet Frame Templates
-- ==============================

		Nurfed_Unit_Pet_casting = {
			type = "Frame",
			size = { 169, 20 },
			FrameStrata = "LOW",
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 1 },
			children = {
				casting = {
					type = "StatusBar",
					size = { 155, 6 },
					Orientation = "HORIZONTAL",
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
					StatusBarTexture = NRF_IMG.."statusbar8",
					FrameLevel = 2,
					children = {
						info = {
							template = "Nurfed_Info_frame",
							size = { 44, 20 },
							Anchor = { "TOPRIGHT", "$parent", "TOPLEFT", -4, 7 },
						},
						text = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 120, 10 },
							JustifyH = "LEFT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 3 },
							vars = { format = "$spell ($rank)" },
						},
						time = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 40, 10 },
							JustifyH = "RIGHT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "CENTER", "$parentinfo", "CENTER", -6, 0 },
						},

					},
					Hide = true,
				},
			},
			Hide = true,
		},
		
		Nurfed_Unit_Pet_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, -1 },
					vars = { format = "$cur / $max" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Pet_mp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 0, 1, 1, 0.25 },
					Anchor = "all" },
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75 },
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, -1 },
					vars = { format = "$cur / $max" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Pet_ToT = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 169, 20 },
			FrameStrata = "LOW",
			FrameLevel = 1,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			children = {
				info = {
					template = "Nurfed_Info_frame",
					size = { 44, 20 },
					Anchor = { "TOPRIGHT", "$parent", "TOPLEFT", 3, 0 },
				},
				name = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parenthp", "LEFT", 5, 0 },
					vars = { format = "$name" },
				},
				hp = {
					template = "Nurfed_Unit_Pet_ToT_hp",
					size = { 155, 6},
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -7 },
				},
				highlight = {
					type = "Texture",
					size = { 160, 10 },
					layer = "ARTWORK",
					Texture = "Interface\\QuestFrame\\UI-QuestTitleHighlight",
					BlendMode = "ADD",
					Alpha = 0.50,
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
				},
			},
			Hide = true,
		},
		Nurfed_Unit_Pet_ToT_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "CENTER",
					ShadowColor = { 0, 0, 0, 0.25 },
					ShadowOffset = { 1, -1 },
					Anchor = { "CENTER", "$parent", "CENTER", -104, 0 },
					vars = { format = "$perc" },
				},
			},
			vars = { ani = "glide" },
		},
		
-- ==============================
-- Focus Frame Templates
-- ==============================

		Nurfed_Unit_Focus_casting = {
			type = "Frame",
			size = { 169, 20 },
			FrameStrata = "LOW",
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 1 },
			children = {
				casting = {
					type = "StatusBar",
					size = { 155, 6 },
					Orientation = "HORIZONTAL",
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
					StatusBarTexture = NRF_IMG.."statusbar8",
					FrameLevel = 2,
					children = {
						info = {
							template = "Nurfed_Info_frame",
							size = { 44, 20 },
							Anchor = { "TOPLEFT", "$parent", "TOPRIGHT", 4, 7 },
						},
						text = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 120, 10 },
							JustifyH = "LEFT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 3 },
							vars = { format = "$spell ($rank)" },
						},
						time = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 40, 10 },
							JustifyH = "RIGHT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "CENTER", "$parentinfo", "CENTER", -6, 0 },
						},

					},
					Hide = true,
				},
			},
			Hide = true,
		},
		
		Nurfed_Unit_Focus_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, -1 },
					vars = { format = "$cur / $max" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Focus_mp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 0, 1, 1, 0.25 },
					Anchor = "all" },
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75 },
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, -1 },
					vars = { format = "$cur / $max" },
				},
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Focus_ToT = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 169, 20 },
			FrameStrata = "LOW",
			FrameLevel = 1,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			children = {
				info = {
					template = "Nurfed_Info_frame",
					size = { 44, 20 },
					Anchor = { "TOPLEFT", "$parent", "TOPRIGHT", -3, 0 },
				},
				name = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parenthp", "LEFT", 5, 0 },
					vars = { format = "$name" },
				},
				hp = {
					template = "Nurfed_Unit_Focus_ToT_hp",
					size = { 155, 6},
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -7 },
				},
				highlight = {
					type = "Texture",
					size = { 160, 10 },
					layer = "ARTWORK",
					Texture = "Interface\\QuestFrame\\UI-QuestTitleHighlight",
					BlendMode = "ADD",
					Alpha = 0.50,
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
				},
			},
			Hide = true,
		},
		Nurfed_Unit_Focus_ToT_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "CENTER",
					ShadowColor = { 0, 0, 0, 0.25 },
					ShadowOffset = { 1, -1 },
					Anchor = { "CENTER", "$parent", "CENTER", 104, 0 },
					vars = { format = "$perc" },
				},
			},
			vars = { ani = "glide" },
		},

-- ==============================
-- Party Frame Templates
-- ==============================
		
		Nurfed_Unit_Party_casting = {
			type = "Frame",
			size = { 170, 20 },
			FrameStrata = "LOW",
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 1 },
			children = {
				casting = {
					type = "StatusBar",
					size = { 155, 6 },
					Orientation = "HORIZONTAL",
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -7 },
					StatusBarTexture = NRF_IMG.."statusbar8",
					FrameLevel = 2,
					children = {
						info = {
							template = "Nurfed_Info_frame",
							size = { 40, 20 },
							Anchor = { "TOPLEFT", "$parent", "TOPRIGHT", 6, 7 },
						},
						text = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 120, 10 },
							JustifyH = "LEFT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 5, 3 },
							vars = { format = "$spell ($rank)" },
						},
						time = {
							type = "FontString",
							layer = "ARTWORK",
							size = { 40, 10 },
							JustifyH = "RIGHT",
							FontObject = "Nurfed_Unit_10",
							ShadowColor = { 0, 0, 0, 0.75 },
							ShadowOffset = { -1, -1 },
							Anchor = { "CENTER", "$parentinfo", "CENTER", -6, 0 },
						},

					},
					Hide = true,
				},
			},
			Hide = true,
		},
		
		Nurfed_Unit_Party_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, -1 },
					vars = { format = "$cur / $max" },
				},
				--[[text2 = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "CENTER",
					ShadowColor = { 0, 0, 0, 0.25 },
					ShadowOffset = { 1, -1 },
					TextColor = { 1, 0.25, 0 },
					Anchor = { "CENTER", "$parent", "CENTER", 105, -9 },
					vars = { format = "$miss" },
				},]]--
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Party_mp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 0, 1, 1, 0.25 },
					Anchor = "all" },
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75 },
					ShadowOffset = { -1, -1 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", -5, -1 },
					vars = { format = "$cur / $max" },
				},
			},
			vars = { ani = "glide" },
		},
				
		Nurfed_Unit_Party_ToT_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				--[[text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "CENTER",
					ShadowColor = { 0, 0, 0, 0.25 },
					ShadowOffset = { 1, -1 },
					Anchor = { "CENTER", "$parent", "CENTER", 105, 0 },
					vars = { format = "$perc" },
				},]]--
			},
			vars = { ani = "glide" },
		},
		
		Nurfed_Unit_Party_ToT = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 170, 20 },
			FrameStrata = "LOW",
			FrameLevel = 1,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			children = {
				--[[info = {
					template = "Nurfed_Info_frame",
					size = { 40, 20 },
					Anchor = { "TOPLEFT", "$parent", "TOPRIGHT", -2, 0 },
				},]]--
				name = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parenthp", "LEFT", 5, 0 },
					vars = { format = "$name" },
				},
				hp = {
					template = "Nurfed_Unit_Party_ToT_hp",
					size = { 155, 6},
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -7 },
				},
				highlight = {
					type = "Texture",
					size = { 160, 10 },
					layer = "ARTWORK",
					Texture = "Interface\\QuestFrame\\UI-QuestTitleHighlight",
					BlendMode = "ADD",
					Alpha = 0.50,
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
				},
			},
			Hide = true,
		},
		
		Nurfed_Party = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 170, 47 },
			FrameStrata = "LOW",
			ClampedToScreen = true,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			Movable = true,
			Mouse = true,
			children = {
				--[[info = {
					template = "Nurfed_Info_frame",
					size = { 40, 47 },
					Anchor = { "TOPLEFT", "$parent", "TOPRIGHT", -2, 0 },
				},]]--
				hp = {
					template = "Nurfed_Unit_Party_hp",
					size = { 156, 15 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -7 },
				},
				name = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parenthp", "LEFT", 5, 0 },
					vars = { format = "$name" },
				},
				pvp = {
					type = "Texture",
					size = { 30, 30 },
					layer = "OVERLAY",
					FrameLevel = 2,
					Anchor = { "CENTER", "$parent", "CENTER", -5, -7 },
				},
				mp = {
					template = "Nurfed_Unit_Party_mp",
					size = { 156, 15 },
					Anchor = { "TOPLEFT", "$parenthp", "BOTTOMLEFT", 0, -3 },
				},
				level = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parentmp", "LEFT", 5, 0 },
					vars = { format = "$level" },
				},
				
				buff1 = { template = "Nurfed_BuffTemp", Anchor = { "BOTTOMLEFT", "$parent", "TOPLEFT", 4, 0 } },
				buff2 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff1", "RIGHT", 2, 0 } },
				buff3 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff2", "RIGHT", 2, 0 } },
				buff4 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff3", "RIGHT", 2, 0 } },
				buff5 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff4", "RIGHT", 2, 0 } },
				buff6 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff5", "RIGHT", 2, 0 } },
				buff7 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff6", "RIGHT", 2, 0 } },
				buff8 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff7", "RIGHT", 2, 0 } },
				buff9 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff8", "RIGHT", 2, 0 } },
				buff10 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff9", "RIGHT", 2, 0 } },

				debuff1 = { template = "Nurfed_BuffTemp", Anchor = { "TOPLEFT", "$parent", "TOPRIGHT", 39, -4 } },
				debuff2 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentdebuff1", "RIGHT", 1, 0 } },
				debuff3 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentdebuff2", "RIGHT", 1, 0 } },
				debuff4 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentdebuff3", "RIGHT", 1, 0 } },
				
				raidtarget = {
					type = "Texture",
					Texture = "Interface\\TargetingFrame\\UI-RaidTargetingIcons",
					size = { 20, 20 },
					Layer = "OVERLAY",
					Anchor = { "CENTER", "$parent", "TOPRIGHT", 18, -5 },
					Hide = true,
				},
				
				leader = {
					type = "Texture",
					size = { 13, 13 },
					layer = "OVERLAY",
					Texture = "Interface\\GroupFrame\\UI-Group-LeaderIcon",
					Anchor = { "LEFT", "$parent", "RIGHT", 6, -13 },
				},
				master = {
					type = "Texture",
					size = { 13, 13 },
					layer = "OVERLAY",
					Texture = "Interface\\GroupFrame\\UI-Group-MasterLooter",
					Anchor = { "LEFT", "$parent", "RIGHT", 18, -13 },
				},
				status = {
					type = "Texture",
					size = { 22, 22 },
					layer = "OVERLAY",
					Texture = "Interface\\CharacterFrame\\UI-StateIcon",
					Anchor = { "CENTER", "$parent", "CENTER", 5, -1 },
				},
				
				highlight = {
					type = "Texture",
					size = { 160, 37 },
					layer = "ARTWORK",
					Texture = "Interface\\QuestFrame\\UI-QuestTitleHighlight",
					BlendMode = "ADD",
					Alpha = 0.50,
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
				},

				pet = { template = "Nurfed_Unit_Party_pet", Anchor = { "BOTTOMLEFT", "$parentinfo", "BOTTOMRIGHT", -2, 0 } },
				target = { template = "Nurfed_Unit_Party_ToT", Anchor = { "TOPLEFT", "$parent", "BOTTOMLEFT", 0, 4 } },
				castingframe = { template = "Nurfed_Unit_Party_casting", Anchor = { "TOPLEFT", "$parenttarget", "BOTTOMLEFT", 0, 4 } },
			},
			vars = { aurawidth = 176 },
		},

-- ==============================
-- Party Pet Frame Templates
-- ==============================

		Nurfed_Unit_Party_Pet_hp = {
			type = "StatusBar",
			FrameStrata = "LOW",
			FrameLevel = 1,
			Orientation = "HORIZONTAL",
			StatusBarTexture = NRF_IMG.."statusbar8",
			children = {
				bg = {
					type = "Texture",
					layer = "BACKGROUND",
					Texture = NRF_IMG.."statusbar8",
					VertexColor = { 1, 0, 0, 0.25 },
					Anchor = "all"
				},
				text = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
					vars = { format = "$perc" },
				},
			},
			vars = { ani = "glide" },
		},

		Nurfed_Unit_Party_pet = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 60, 30 },
			FrameStrata = "LOW",
			FrameLevel = 1,
			ClampedToScreen = true,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			Movable = true,
			Mouse = true,
			children = {
				name = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "CENTER", "$parent", "CENTER", 0, 6 },
					vars = { format = "$name" },
				},
				hp = {
					template = "Nurfed_Unit_Party_Pet_hp",
					size = { 46, 8 },
					Anchor = { "BOTTOMLEFT", "$parent", "BOTTOMLEFT", 7, 7 },
				},
				highlight = {
					type = "Texture",
					size = { 50, 20 },
					layer = "ARTWORK",
					Texture = "Interface\\QuestFrame\\UI-QuestTitleHighlight",
					BlendMode = "ADD",
					Alpha = 0.50,
					Anchor = { "CENTER", "$parent", "CENTER", 0, 0 },
				},
			},
			Hide = true,
		},
	};

-- ==============================
-- Frame Design
-- ==============================

	Nurfed_UnitsLayout.Layout = {
	
-- ==============================
-- Player Frame Design
-- ==============================

		player = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 265, 70 },
			FrameStrata = "LOW",
			ClampedToScreen = true,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			Movable = true,
			Mouse = true,
			children = {
				name = {
					template = "Nurfed_Player_Name_frame",
					size = { 200, 25 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 65, 10 },
				},
				levelclass = {
					type = "FontString",
					size = { 145, 14 },
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "LEFT",
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 72, -13 },
					vars = { format = "Level $level $race $class" },
				},
				
				hp = {
					template = "Nurfed_Unit_Player_hp",
					size = { 186, 15 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 72, -30 },
				},
				pvp = {
					type = "Texture",
					size = { 30, 30 },
					layer = "OVERLAY",
					FrameLevel = 2,
					Anchor = { "CENTER", "$parent", "CENTER", 37, -16 },
				},
				status = {
					type = "Texture",
					size = { 22, 22 },
					layer = "OVERLAY",
					Texture = "Interface\\CharacterFrame\\UI-StateIcon",
					Anchor = { "CENTER", "$parent", "CENTER", 47, -10 },
				},
				mp = {
					template = "Nurfed_Unit_Player_mp",
					size = { 186, 15 },
					Anchor = { "TOPLEFT", "$parenthp", "BOTTOMLEFT", 0, -3 },
				},
				
				raidtarget = {
					type = "Texture",
					Texture = "Interface\\TargetingFrame\\UI-RaidTargetingIcons",
					size = { 20, 20 },
					Layer = "OVERLAY",
					Anchor = { "CENTER", "$parent", "TOPLEFT", 35, -3 },
					Hide = true,
				},
				
				leader = {
					type = "Texture",
					size = { 12, 12 },
					layer = "OVERLAY",
					Texture = "Interface\\GroupFrame\\UI-Group-LeaderIcon",
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 11, 3 },
				},
				master = {
					type = "Texture",
					size = { 12, 12 },
					layer = "OVERLAY",
					Texture = "Interface\\GroupFrame\\UI-Group-MasterLooter",
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 47, 4 },
				},
				
				group = {
					type = "FontString",
					size = { 50, 14 },
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_10",
					JustifyH = "LEFT",
					TextColor = { 0.5, 0.5, 0.5 },
					Anchor = { "CENTER", "$parentname", "TOP", 0, 5 },
				},

				model_frame = {
					template = "Nurfed_Model_frame",
					size = { 70, 70 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 0, 0 },
				},
				--[[model = {
					template = "Nurfed_Unit_model",
					size = { 60, 60 },
					Anchor = { "BOTTOMLEFT", "$parentmodel_frame", "BOTTOMLEFT", 6, 4 },
				},]]--
				portrait = {
					template = "Nurfed_Unit_portrait",
					size = { 58, 58 },
					Anchor = { "BOTTOMLEFT", "$parentmodel_frame", "BOTTOMLEFT", 6, 6 },
				},
				castingframe = { template = "Nurfed_Unit_Player_casting", Anchor = { "TOP", "$parent", "BOTTOM", 53, 4 } },
			},
			vars = { unit = "player" },
		},

-- ==============================
-- Target Frame Design
-- ==============================

		target = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 265, 70 },
			FrameStrata = "LOW",
			ClampedToScreen = true,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			Movable = true,
			Mouse = true,
			children = {
				name = {
					template = "Nurfed_Target_Name_frame",
					size = { 200, 25 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 0, 10 },
				},
				
				levelclass = {
					type = "FontString",
					size = { 145, 14 },
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_14",
					JustifyH = "LEFT",
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -13 },
					vars = { format = "Level $level $race $class" },
				},
				
				hp = {
					template = "Nurfed_Unit_Target_hp",
					size = { 186, 15 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -30 },
				},
				pvp = {
					type = "Texture",
					size = { 30, 30 },
					layer = "OVERLAY",
					FrameLevel = 2,
					Anchor = { "CENTER", "$parent", "CENTER", -30, -16 },
				},
				status = {
					type = "Texture",
					size = { 22, 22 },
					layer = "OVERLAY",
					Texture = "Interface\\CharacterFrame\\UI-StateIcon",
					Anchor = { "CENTER", "$parent", "CENTER", -20, -10 },
				},
				mp = {
					template = "Nurfed_Unit_Target_mp",
					size = { 186, 15 },
					Anchor = { "TOPLEFT", "$parenthp", "BOTTOMLEFT", 0, -3 },
				},
				
				raidtarget = {
					type = "Texture",
					Texture = "Interface\\TargetingFrame\\UI-RaidTargetingIcons",
					size = { 20, 20 },
					Layer = "OVERLAY",
					Anchor = { "CENTER", "$parent", "TOPRIGHT", -35, -3 },
					Hide = true,
				},

				combo = {
					type = "FontString",
					layer = "OVERLAY",
					Font = { NRF_FONT.."Charcoal.ttf", 22, "OUTLINE" },
					JustifyH = "RIGHT",
					Anchor = { "LEFT", "$parent", "RIGHT", -42, 0 },
				},

				model_frame = {
					template = "Nurfed_Model_frame",
					size = { 70, 70 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", 0, 0 },
				},
				--[[model = {
					template = "Nurfed_Unit_model",
					size = { 60, 60 },
					Anchor = { "BOTTOMLEFT", "$parentmodel_frame", "BOTTOMLEFT", 6, 4 },
				},]]--
				
				portrait = {
					template = "Nurfed_Unit_portrait",
					size = { 58, 58 },
					Anchor = { "BOTTOMLEFT", "$parentmodel_frame", "BOTTOMLEFT", 6, 6 },
				},

				target = { template = "Nurfed_Unit_Target_ToT", Anchor = { "TOPLEFT", "$parent", "BOTTOMLEFT", 1, 4 } },
				targettarget = { template = "Nurfed_Unit_Target_ToT", Anchor = { "TOPLEFT", "$parenttarget", "TOPRIGHT", 34, 0 } },

				castingframe = { template = "Nurfed_Unit_Target_casting", Anchor = { "TOPLEFT", "$parenttarget", "BOTTOMLEFT", 40, 4 } },
				
				buff1 = { template = "Nurfed_BuffTemp", Anchor = { "BOTTOMLEFT", "$parent", "TOPLEFT", 4, 10 } },
				buff2 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff1", "RIGHT", 2, 0 } },
				buff3 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff2", "RIGHT", 2, 0 } },
				buff4 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff3", "RIGHT", 2, 0 } },
				buff5 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff4", "RIGHT", 2, 0 } },
				buff6 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff5", "RIGHT", 2, 0 } },
				buff7 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff6", "RIGHT", 2, 0 } },
				buff8 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff7", "RIGHT", 2, 0 } },
				buff9 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff8", "RIGHT", 2, 0 } },
				buff10 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff9", "RIGHT", 2, 0 } },
				buff11 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff10", "RIGHT", 2, 0 } },
				buff12 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff11", "RIGHT", 2, 0 } },

				debuff1 = { template = "Nurfed_BuffTemp", Anchor = { "TOPRIGHT", "$parentcastingframe", "BOTTOMRIGHT", -6, 0 } },
				debuff2 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff1", "LEFT", 1, 0 } },
				debuff3 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff2", "LEFT", 1, 0 } },
				debuff4 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff3", "LEFT", 1, 0 } },
				debuff5 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff4", "LEFT", 1, 0 } },
				debuff6 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff5", "LEFT", 1, 0 } },
				debuff7 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff6", "LEFT", 1, 0 } },
				debuff8 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff7", "LEFT", 1, 0 } },
				debuff9 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff8", "LEFT", 1, 0 } },
				debuff10 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff9", "LEFT", 1, 0 } },
				debuff11 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff10", "LEFT", 1, 0 } },
				debuff12 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff11", "LEFT", 1, 0 } },
			},
			vars = { unit = "target" },
		},

-- ==============================
-- Pet Frame Design
-- ==============================

		pet = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 210, 47 },
			FrameStrata = "LOW",
			ClampedToScreen = true,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			Movable = true,
			Mouse = true,
			children = {
				hp = {
					template = "Nurfed_Unit_Pet_hp",
					size = { 156, 15 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 47, -7 },
				},
				
				name = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parenthp", "LEFT", 5, 0 },
					vars = { format = "$name" },
				},

				pvp = {
					type = "Texture",
					size = { 30, 30 },
					layer = "OVERLAY",
					FrameLevel = 2,
					Anchor = { "CENTER", "$parent", "CENTER", 15, -6 },
				},
				status = {
					type = "Texture",
					size = { 22, 22 },
					layer = "OVERLAY",
					Texture = "Interface\\CharacterFrame\\UI-StateIcon",
					Anchor = { "CENTER", "$parent", "CENTER", 25, 0 },
				},
				mp = {
					template = "Nurfed_Unit_Pet_mp",
					size = { 156, 15 },
					Anchor = { "TOPLEFT", "$parenthp", "BOTTOMLEFT", 0, -3 },
				},
				
				levelclass = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parentmp", "LEFT", 5, 0 },
					vars = { format = "$level $class" },
				},
				
				happiness = {
					type = "Texture",
					Texture = "Interface\\PetPaperDollFrame\\UI-PetHappiness",
					size = { 14, 14 },
					layer = "OVERLAY",
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 16, 3 },
					Hide = true,
				},
				
				highlight = {
					type = "Texture",
					size = { 146, 37 },
					layer = "ARTWORK",
					Texture = "Interface\\QuestFrame\\UI-QuestTitleHighlight",
					BlendMode = "ADD",
					Alpha = 0.50,
					Anchor = { "CENTER", "$parent", "CENTER", 27, 0 },
				},

				model_frame = {
					template = "Nurfed_Model_frame",
					size = { 47, 47 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 0, 0 },
				},

				--[[model = {
					template = "Nurfed_Unit_model",
					size = { 37, 37 },
					Anchor = { "BOTTOMLEFT", "$parentmodel_frame", "BOTTOMLEFT", 6, 4 },
				},]]--			

				portrait = {
					template = "Nurfed_Unit_portrait",
					size = { 35, 35 },
					Anchor = { "BOTTOMLEFT", "$parentmodel_frame", "BOTTOMLEFT", 6, 6 },
				},

				buff1 = { template = "Nurfed_BuffTemp", Anchor = { "TOPLEFT", "$parent", "BOTTOMLEFT", 6, -16 } },
				buff2 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff1", "RIGHT", 2, 0 } },
				buff3 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff2", "RIGHT", 2, 0 } },
				buff4 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff3", "RIGHT", 2, 0 } },
				buff5 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff4", "RIGHT", 2, 0 } },
				buff6 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff5", "RIGHT", 2, 0 } },

				debuff1 = { template = "Nurfed_BuffTemp", Anchor = { "TOPRIGHT", "$parent", "BOTTOMRIGHT", -6, -16 } },
				debuff2 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff1", "LEFT", 1, 0 } },
				debuff3 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff2", "LEFT", 1, 0 } },
				debuff4 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff3", "LEFT", 1, 0 } },
				debuff5 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff2", "LEFT", 1, 0 } },
				debuff6 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff3", "LEFT", 1, 0 } },
				
				castingframe = { template = "Nurfed_Unit_Pet_casting", Anchor = { "BOTTOM", "$parent", "TOP", 21, -3 } },
				target = { template = "Nurfed_Unit_Pet_ToT", Anchor = { "TOP", "$parent", "BOTTOM", 21, 3 } },
				
			},
			vars = { unit = "pet" },
		},
		
-- ==============================
-- Focus Frame Design
-- ==============================

		focus = {
			type = "Button",
			uitemp = "SecureUnitButtonTemplate",
			size = { 210, 47 },
			FrameStrata = "LOW",
			ClampedToScreen = true,
			Backdrop = "Nurfed_Unit_backdrop",
			BackdropColor = { 0, 0, 0, 0.75 },
			Movable = true,
			Mouse = true,
			children = {
				hp = {
					template = "Nurfed_Unit_Focus_hp",
					size = { 156, 15 },
					Anchor = { "TOPLEFT", "$parent", "TOPLEFT", 7, -7 },
				},
				
				name = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parenthp", "LEFT", 5, 0 },
					vars = { format = "$name" },
				},

				pvp = {
					type = "Texture",
					size = { 30, 30 },
					layer = "OVERLAY",
					FrameLevel = 2,
					Anchor = { "CENTER", "$parent", "CENTER", -25, -6 },
				},
				status = {
					type = "Texture",
					size = { 22, 22 },
					layer = "OVERLAY",
					Texture = "Interface\\CharacterFrame\\UI-StateIcon",
					Anchor = { "CENTER", "$parent", "CENTER", -15, 0 },
				},
				mp = {
					template = "Nurfed_Unit_Focus_mp",
					size = { 156, 15 },
					Anchor = { "TOPLEFT", "$parenthp", "BOTTOMLEFT", 0, -3 },
				},
				
				levelclass = {
					type = "FontString",
					layer = "OVERLAY",
					FontObject = "Nurfed_Unit_12",
					JustifyH = "RIGHT",
					ShadowColor = { 0, 0, 0, 0.75},
					ShadowOffset = { -1, -1 },
					Anchor = { "LEFT", "$parentmp", "LEFT", 5, 0 },
					vars = { format = "$level $class" },
				},
				
				highlight = {
					type = "Texture",
					size = { 146, 37 },
					layer = "ARTWORK",
					Texture = "Interface\\QuestFrame\\UI-QuestTitleHighlight",
					BlendMode = "ADD",
					Alpha = 0.50,
					Anchor = { "CENTER", "$parent", "CENTER", -27, 0 },
				},

				model_frame = {
					template = "Nurfed_Model_frame",
					size = { 47, 47 },
					Anchor = { "TOPRIGHT", "$parent", "TOPRIGHT", 0, 0 },
				},

				--[[model = {
					template = "Nurfed_Unit_model",
					size = { 37, 37 },
					Anchor = { "BOTTOMLEFT", "$parentmodel_frame", "BOTTOMLEFT", 6, 4 },
				},]]--

				portrait = {
					template = "Nurfed_Unit_portrait",
					size = { 35, 35 },
					Anchor = { "BOTTOMLEFT", "$parentmodel_frame", "BOTTOMLEFT", 6, 6 },
				},
				
				buff1 = { template = "Nurfed_BuffTemp", Anchor = { "TOPLEFT", "$parent", "BOTTOMLEFT", 6, -16 } },
				buff2 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff1", "RIGHT", 2, 0 } },
				buff3 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff2", "RIGHT", 2, 0 } },
				buff4 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff3", "RIGHT", 2, 0 } },
				buff5 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff4", "RIGHT", 2, 0 } },
				buff6 = { template = "Nurfed_BuffTemp", Anchor = { "LEFT", "$parentbuff5", "RIGHT", 2, 0 } },

				debuff1 = { template = "Nurfed_BuffTemp", Anchor = { "TOPRIGHT", "$parent", "BOTTOMRIGHT", -6, -16 } },
				debuff2 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff1", "LEFT", 1, 0 } },
				debuff3 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff2", "LEFT", 1, 0 } },
				debuff4 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff3", "LEFT", 1, 0 } },
				debuff5 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff2", "LEFT", 1, 0 } },
				debuff6 = { template = "Nurfed_BuffTemp", Anchor = { "RIGHT", "$parentdebuff3", "LEFT", 1, 0 } },
				
				castingframe = { template = "Nurfed_Unit_Focus_casting", Anchor = { "BOTTOM", "$parent", "TOP", -20, -3 } },
				target = { template = "Nurfed_Unit_Focus_ToT", Anchor = { "TOP", "$parent", "BOTTOM", -20, 3 } },
				
			},
			vars = { unit = "focus" },
		},

-- ==============================
-- Party Frame Design
-- ==============================

		Nurfed_party1 = { template = "Nurfed_Party", vars = { unit = "party1" } },
		Nurfed_party2 = { template = "Nurfed_Party", vars = { unit = "party2" } },
		Nurfed_party3 = { template = "Nurfed_Party", vars = { unit = "party3" } },
		Nurfed_party4 = { template = "Nurfed_Party", vars = { unit = "party4" } },
		
	};
end