local mod = Numen
if not mod then return end

local AceOO = AceLibrary("AceOO-2.0")
mod.PopButton = AceOO.Class("AceEvent-2.0")
local prototype = mod.PopButton.prototype

local _G = getfenv(0)

local function ShowTooltip(b)
	mod:ShowTooltip(b)
end

local function HideTooltip()
	mod:HideTooltip()
end

function prototype:init(spellName)
	mod.PopButton.super.prototype.init(self)

	local spellName, spellRank = GetSpellName(spellName)
	self.spellName = spellName
	self.spellRank = spellRank
	local name = spellName:gsub("(%s)", "")
	self.button = CreateFrame("CheckButton", "NumenPopButton"..name, mod.root, "SecureAnchorUpDownTemplate,SecureActionButtonTemplate,ActionButtonTemplate")
	self.button.class = self
	self.button:SetWidth(36)
	self.button:SetHeight(36)
	self.button.texture = self.button:CreateTexture(nil, "BACKGROUND")
	self.button.texture:SetAllPoints(self.button)
	self.button.texture:SetTexture(GetSpellTexture(spellName))
	self.button:SetCheckedTexture("")
	self.button:SetNormalTexture("")
	self.button:SetFrameStrata("High")
	self:ApplyStyle()
	self.button.texture:SetPoint("TOPLEFT", self.button, "TOPLEFT", 3, -3)
	self.button.texture:SetPoint("BOTTOMRIGHT", self.button, "BOTTOMRIGHT",  -3, 3)
	self.button.texture:SetTexCoord(0.08, 0.92, 0.08, 0.92)
	self.button:SetAttribute("*type1", "spell")
	self.button:SetAttribute("spell", spellName)
	self.button:SetAttribute("onmouseupbutton", "mup")
	self.button:SetAttribute("shift-childstate-mup", ATTRIBUTE_NOOP)
	mod.root:SetAttribute("addchild", self.button)
	self.button:SetScript("OnEnter", ShowTooltip)
	self.button:SetScript("OnLeave", HideTooltip)
	self.button.cooldown = _G[self.button:GetName().."Cooldown"]
	self:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN", "UpdateCooldown")

	mod.popbuttons[spellName] = self
end

function prototype:UpdatePosition(parent, order)
	self.button:ClearAllPoints()
	local x, y = 0, 0
	local pos = (36 + mod.db.profile.padding) * order
	if not mod.db.profile.growup then
		pos = pos * -1
	end
	if mod.db.profile.vertical then
		x = pos
	else
		y = pos
	end
	self.button:SetPoint("TOPLEFT", parent.frame, "TOPLEFT", x, y)
end

function prototype:ApplyStyle()
	local frame = CreateFrame("Frame", self.button:GetName().."DL", self.button)
	frame:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 1, edgeFile = "", edgeSize = 0, insets = {left = 0, right = 0, top = 0, bottom = 0},})
	frame:SetBackdropColor(0, 0, 0, 0.6)
	frame:SetAllPoints(self.button)
	frame:SetFrameLevel(0)
end

function prototype:UpdateCooldown()
	local spellId = mod.spellList[self.spellName]
	if spellId then
		local start, duration, enable = GetSpellCooldown(spellId, BOOKTYPE_SPELL)
		CooldownFrame_SetTimer(self.button.cooldown, start, duration, enable)
	end
end

function prototype:Disable()
	self.button:SetAttribute("*childstate-mup", ATTRIBUTE_NOOP)
	self.button:SetAttribute("showstates", "")
	self.button:Hide()
end

function prototype:Update(parent, parentOrder, order)
	local spellName, spellRank = GetSpellName(self.spellName)
	self.spellName = spellName
	self.spellRank = spellRank
	if mod.db.profile.unsetableSpell[self.spellName] then
		self.button:SetAttribute("*childstate-mup", ATTRIBUTE_NOOP)
	else
		self.button:SetAttribute("*childstate-mup", order)
	end
	self.button:SetAttribute("anchorchild", parent.frame)
	self.button:SetAttribute("showstates", "-1,"..tostring(parentOrder))
	parent.button:SetAttribute("spell-"..order, self.spellName)
	parent.frame:SetAttribute("statemap-anchor-"..order, tostring(order))
	self:UpdatePosition(parent, order)
	self:UpdateCooldown()
end