local mod = Numen
if not mod then return end

local AceOO = AceLibrary("AceOO-2.0")
mod.Button = AceOO.Class("AceEvent-2.0")
local prototype = mod.Button.prototype

local _G = getfenv(0)

local function SwapTexture(button, name, value)
	if (name=="state-parent") then
		if (value ~= "0") then
			local p = button.class.popbuttons[tonumber(value)]
			if p then
				local spellName = p.spellName
				button.class.spellName = spellName
				button.class.spellRank = p.spellRank
				button.texture:SetTexture(GetSpellTexture(spellName))
				button.class:UpdateCooldown()
				mod.db.profile.selectedSpell[button.class.id] = spellName
			end
		end
	end
end

local function ShowTooltip(b)
	mod:ShowTooltip(b)
end

local function HideTooltip()
	mod:HideTooltip()
end

local elementID = {
	Fire = 1,
	Earth = 2,
	Water = 3,
	Air = 4,
}

function prototype:init(id)
	mod.Button.super.prototype.init(self)

	self.id = id
	self.frame = CreateFrame("Frame", "NumenFrame"..id, mod.root, "SecureStateHeaderTemplate")
	self.button = CreateFrame("CheckButton", "NumenButton"..id, self.frame, "SecureAnchorEnterTemplate,SecureActionButtonTemplate,ActionButtonTemplate")
	self.button.class = self
	self.button:SetPoint("TOPLEFT", self.frame, "TOPLEFT", 0, 0)
	self.button:SetWidth(36)
	self.button:SetHeight(36)
	self.button:RegisterForClicks("AnyUp")
	self.button:SetAttribute("type", "spell")
	if id == "Earth" or id == "Fire" or id == "Water" or id == "Air" then
		self.button:SetAttribute("type2", "macro")
		self.button:SetAttribute("macrotext", "/run DestroyTotem("..elementID[id]..")")
	end
	if id ~= "Call" then
		self.button:SetAttribute("childstate-onenter", "show"..id)
		self.button:SetAttribute("childstate-onleave", "hide"..id)
	end
	self.button:SetAttribute("anchorchild", mod.root)
	self.button:HookScript("OnEnter", ShowTooltip)
	self.button:HookScript("OnLeave", HideTooltip)
	self.button.texture = self.button:CreateTexture(nil, "BACKGROUND")
	self.button:SetCheckedTexture("")
	self.button:SetNormalTexture("")
	self:ApplyStyle()
	self.button.texture:SetPoint("TOPLEFT", self.button, "TOPLEFT", 3, -3)
	self.button.texture:SetPoint("BOTTOMRIGHT", self.button, "BOTTOMRIGHT",  -3, 3)
	self.button.texture:SetTexCoord(0.08, 0.92, 0.08, 0.92)
	self.frame:SetAttribute("addchild", self.button)

	self.button:SetScript("OnAttributeChanged", SwapTexture)
	self.button:SetFrameStrata("LOW")
	self.button.cooldown = _G[self.button:GetName().."Cooldown"]
	self.button.pulse = CreateFrame("Cooldown", self.button:GetName().."Pulse", self.button, "CooldownFrameTemplate")
	self:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN", "UpdateCooldown")

	self.popbuttons = {}

	mod.buttons[id] = self
end

function prototype:ApplyStyle()
	local frame = CreateFrame("Frame", self.button:GetName().."DL", self.button)
	frame:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 1, edgeFile = "", edgeSize = 0, insets = {left = 0, right = 0, top = 0, bottom = 0},})
	frame:SetBackdropColor(0, 0, 0, 0.6)
	frame:SetAllPoints(self.button)
	frame:SetFrameLevel(0)
end

function prototype:UpdateCooldown()
	local spellId = mod.spellList[self.spellName]
	if spellId then
		local start, duration, enable = GetSpellCooldown(spellId, BOOKTYPE_SPELL)
		if (Numen.db.profile.timer) then
			if start > 0 and duration > 1.5 and enable > 0 then
				self:ScheduleEvent(self.id.."-Cooldown", self.UpdateCooldown, duration, self)
			else
				start = mod.spellTimers[self.id] or 0
--[[
				duration = mod.spellDuration[self.spellName] or 0
				if type(duration) == "table" then
					duration = duration[self.spellRank] or 0
				end
]]--
				duration = mod.affinityDurations[self.id] or 0
				enable = 1
			end
		end
		CooldownFrame_SetTimer(self.button.cooldown, start, duration, enable)
	end
end

function prototype:Update(order, num, state)
	local s = ""
	local s2 = ""
	for i=1, num do
		s = s..i..":"..i..";"
		s2 = s2..i..":"..i.."rmb;"
		self.button:SetAttribute("type-"..i.."rmb","macro")
	end
	self.button:SetAttribute("statebutton*", s)
	self.button:SetAttribute("statebutton2", s2)
	self.frame:SetAttribute("state", state or "1")
	mod.root:SetAttribute("statemap-anchor-show"..self.id, "*:"..order)
	mod.root:SetAttribute("statemap-anchor-hide"..self.id, "")
	mod.root:SetAttribute("delaystatemap-anchor-hide"..self.id, order..":0")
	mod.root:SetAttribute("delaytimemap-anchor-hide"..self.id,  order..":0.5")
	mod.root:SetAttribute("delayhovermap-anchor-hide"..self.id, order..":true")
	self:UpdatePosition(order)
	self:UpdateCooldown()
	self.frame:Show()
	self.button:Show()
end

function prototype:UpdatePosition(order)
	self.frame:ClearAllPoints()
	local x, y = 0, 0
	local pos = (36 + mod.db.profile.padding) * (order - 1)
	if mod.db.profile.vertical then
		y = pos * -1
	else
		x = pos
	end
	self.frame:SetPoint("TOPLEFT", mod.root, "TOPLEFT", x, y)
end

function prototype:Disable()
	self.button:SetAttribute("statebutton", "")
	self.frame:SetAttribute("state", "0")
	mod.root:SetAttribute("statemap-anchor-show"..self.id, "")
	mod.root:SetAttribute("statemap-anchor-hide"..self.id, "")
	mod.root:SetAttribute("delaystatemap-anchor-hide"..self.id, "")
	mod.root:SetAttribute("delaytimemap-anchor-hide"..self.id,  "")
	mod.root:SetAttribute("delayhovermap-anchor-hide"..self.id, "")
	self.frame:Hide()
	self.button:Hide()
end