
-- Exported Data
NuNDataExport = {};


-- Local Data
local searchFor = NUN_SEARCHFOR;
local Notes = "notes~";
local exportName = "";

-- Confirmations
StaticPopupDialogs["NUN_CONFIRM_EXPORT"] = {
	text = TEXT(NUN_CONFIRM),
	button1 = TEXT(NUN_DB_EXPORT),
	button2 = TEXT(CANCEL),
	hasEditBox = 1,
	showAlert = 1,
	timeout = 0,
	OnShow = function()
		local lExportName;
		for category, data in pairs(NuNDataExport) do
			lExportName = category;
			break;
		end
		if ( lExportName ) then
			getglobal(this:GetName().."EditBox"):SetText(lExportName);
			exportName = lExportName;
		else
			getglobal(this:GetName().."EditBox"):SetText("");
		end

		local numToExport = 0;
		local totalFound = getn(NuNSearchFrame.foundNuN);
		local n = NuNGet_CommandID(searchFor, "Notes");
		local notesTxt = searchFor[n].Display;
		for i=1, totalFound, 1 do
			local noteType = string.sub( NuNSearchFrame.foundNuN[i], 1, 1 );
			if ( ( noteType == NuNC.NUN_HORD_C ) or ( noteType == NuNC.NUN_ALLI_C ) ) then
			else
				numToExport = numToExport + 1;
			end
		end
		getglobal(this:GetName().."Text"):SetText(NUN_DB_EXPORT.." : "..numToExport.." "..notesTxt);
	end,
	OnAccept = function()
		local numExported = 0;
		local n = NuNGet_CommandID(searchFor, "Notes");
		local notesTxt = searchFor[n].Display;
		local checkName = getglobal(this:GetParent():GetName().."EditBox"):GetText();
		if ( exportName == "" ) then
			exportName = checkName;
		end
		if ( ( not checkName ) or ( checkName == "" ) or ( checkName ~= exportName ) ) then
			return true;
		else
			exportName = checkName;
			local toExport = NuNSearchFrame.foundNuN;
			local exports = getn(toExport);
			local pKey = NuNSearchFrame.pKey;

			if ( not NuNDataExport ) then
				NuNDataExport = {};
			end
			if ( not NuNDataExport[exportName] ) then
				NuNDataExport[exportName] = {};
			end

			for i=1, exports, 1 do
				local noteType = string.sub( toExport[i], 1, 1 );
				local noteName = string.sub( toExport[i], 2 );

				if ( ( noteType == NuNC.NUN_HORD_C ) or ( noteType == NuNC.NUN_ALLI_C ) ) then
					-- Don't allow the export of contacts

				else
					if ( ( NuNData ) and ( NuNData[Notes] ) and ( NuNData[Notes][noteName] ) ) then		-- 20200
						NuNDataExport[exportName][noteName] = NuNData[Notes][noteName];
						numExported = numExported + 1;

					elseif ( ( NuNData ) and ( pKey ) and ( NuNData[pKey] ) and ( NuNData[pKey][Notes] ) and ( NuNData[pKey][Notes][noteName] ) ) then		-- 20200
						NuNDataExport[exportName][noteName] = NuNData[pKey][Notes][noteName];
						numExported = numExported + 1;
					end
				end
			end
		end

		if ( NuNSearchFrame:IsVisible() ) then
			NuNSearchFrame:Hide();
		end

		NuN_Message( NUN_FINISHED_PROCESSING.." - "..NUN_DB_EXPORT.." : "..numExported.." "..notesTxt );
	end,
	hideOnEscape = 1,
};
