--[[

Some General Developer Notes

Some of the coding here is far from ideal ;p (I was learning Lua & XML while I wrote it, so buhu2u)
But at the time I write this, (v6.BETA), I don't have a gaming account to test with, and a complete re-write is out of the question :(

I have added some comments throughout the code.
And here are some general ramblings that might help someone who's puzzling over the code :

c_name & c_note			:	These variables are global to the AddOn and refer to the note names for the currently Open 
						Contact & General notes respectively. Some functions process notes in the background while
						the user potentially has a note open, and the code will sometimes copy these values to temporary
						variables, use them in processing, and then reset them to the saved temporary values.
						I'm not sure this is necessary in some cases, but as I can't test any more, I'm sticking to the rule of
						thumb "If it ain't broke, don't fix it" Oh, for a OO approach from the very beginning ;P

Note Sizes (6006 characters)		This is controlled by the constants : 
							NuNC.NUN_MAX_ADD_TXT = 5;
							NuNC.NUN_MAX_TXT_CHR = 1001;
						WoW originally limited the size of the text fields that could be saved in SavedVariables, so my solution
						was to split the note in to my own chunks of text and save them as sequential text fields.
						The splitting and concatenation of these chunks in to single notes is handled by the SetCText, GetCText,
						SetGText, and GetGText functions, (i.e. for Contact & General notes)
						To avoid Blizzard substituting invalid character sequences in to NotesUNeed notes when the game ends
						and Saved Variables are actually saved - NuN also substitutes certain special characters within notes.
						i.e. this stops Blizzard carrying out its own substitution of these characters which has been known to
						lead to crashes and loss of entire NuN databases.
						These character substitutions are carried out in the background and hidden from the end user, and are
						handled by the _SetSaveText, and _SetDisplayText functions.

User Definable Buttons			Users can define their own button values for the 10 buttons in the top left of the Contact note frame
						 There are 5 Headings buttons with default values, and 5 Details Buttons left blank by default
						 The first 2 Heading buttons are Guild, and Guild Rank by default, and if left un-changed, then NuN will try to auto-populate Guild information in to the first 2 Detail buttons
						 If a Heading is blanked, then the associated Detail button is disabled
						 They can have a different value for a specific Contact note saved in NuNData
						 OR They can have a new default for all Contacts saved in NuNSettings
						 OR NuN will use its own hard coded defaults

Note Saving Levels				i.e. Saving at Realm level or Account level
						Player Notes are always saved at Realm level, and the code doesn't have to worry about duplicates;
						Ofc, this means users can't see Player notes made on other Realms
						General Notes can be saved at Realm, or account level.
						The user is allowed to have multiple notes with the same name saved on different Realms.
						But can't have the same note saved at Account Level as well.
						NotesUNeed will give a warning when you are about to save a new note with the same name as an existing note

receiptPending			:	NuN allows Players to send each other Notes - See the various comments in the ChatMessage_EventHandler hook
						If someone sends you a note that has the same name as one of your existing notes, then you are presented
						with a duplicate record dialog box, and flagged as receiptPending, until you decide to either replace your note
						with the one being sent to you, or reject the one that has been sent to you.
						This flag stops you from doing things that could result in corrupted data, such as trying to alter the original
	 					note, or open a new one, and or displaying yet another note from a third party.....
						(Other players aren't informed that you are receiptPending - its just a local measure to try and prevent any data
						corruption until you make your mind up)

MapNotes integration			NotesUNeed allows creation of MapNotes at the Player's current location; And while standing in a single location, you can create multiple 
						MapNotes that will be merged on the same Map note - NotesUNeed creates an index of the notes merged this way,
						and shows a little sub-menu detailing the separate notes merged on that point when you mouse over the Map note - this sub-menu can itself be moused
						over (when the <control> key is pressed to show tooltips for each individual note, or clicked to open the note (or clicked to delete the note and remove
						it from the merged MapNotes)
						Best to experiment to understand - stand in one place with a few NPCs around.
						Have MapNotes (Fan's Update) installed
						Have auto-Map Noting of NPCs turned on.
						Without moving, create NotesUNeed notes for several NPCs around you
						You should see a few MapNotes creation messages in the chat frame.
						Open, the map and play with the MapNote thus created.
						
]]--

-- Saved Data

NuNData = {};
NuNSettings = {};



-- Duplicated deliberately here as well as localisation files as need to be able to access multiple versions from the code
local enHeadings = {
	"Guild : ",
	"Guild Rank : ",
	"Real Name : ",
	"e-mail : ",
	"WWW : "
};
local deHeadings = {
	"Gilde : ",
	"Gilden Rang  : ",
	"Echter Name : ",
	"e-mail : ",
	"WWW : "
};
local frHeadings = {
	"Guilde : ",
	"Grade de Guilde : ",
	"Vrai Nom : ",
	"e-mail : ",
	"WWW : "
};
local fromHeadings = {};

local Races = {};
local Ranks = {};
local Classes = {};

local foundNuN = {};
local c_continents = {};
local foundHNuN = {};
local foundANuN = {};
local foundNNuN = {};
local NuNQuestLog = {};

local NuN_Filtered = {};

local NuN_FriendUpdate = {};
local NuN_IgnoreUpdate = {};

local NuN_FriendIgnoreActivity;

local NuN_LastOpen = {};

local NuN_TransStrings = {};
	NuN_TransStrings[1] = {};
		NuN_TransStrings[1][1] = "NotesUNeed NOTE TRANSMISSION FROM : ";
		NuN_TransStrings[1][2] = "NotesUNeed NOTIZ\195\156BERTRAGUNG VON : ";
	NuN_TransStrings[2] = {};
		NuN_TransStrings[2][1] = "NotesUNeed NOTE BEGINS : ";
		NuN_TransStrings[2][2] = "NotesUNeed NOTIZANFANG : ";
	NuN_TransStrings[3] = {};
		NuN_TransStrings[3][1] = "NotesUNeed NOTE ENDS   : ";
		NuN_TransStrings[3][2] = "NotesUNeed NOTIZENDE   : ";



-- Local Variables

-- c_name & c_note are the MAIN global variables (i.e. global to the Script)
-- Not great coding form, but these will always reference the Open Note
-- The use of these variables is SO deeply ingrained, that it would take a re-write to make notes more OO
local c_name;		-- global variable name of Player whose Contact Note is open, or was last opened
local c_note;		-- global variable name of General Note that is open, or was last opened

-- below are more global variables associated with Contact / General Notes
local c_class;
local c_race;
local c_sex;
local c_prating;
local c_prof1;
local c_prof2;
local c_arena;
local c_hrank;
local c_guild;
local c_route;
local c_text;
local c_text_len;
local g_text;
local g_text_len;
local c_type;

-- Drop Down Box Selections
local ddBoxes = {};

-- Misc
local bttnChanges = {};								-- record changes to User Definable buttons BEFORE the Note is Saved
local uBttns = getn(NUN_DFLTHEADINGS);
local detlOffset = uBttns;
local pHead = "~Hdng";
local pDetl = "~Detl";
local discard;
local prevName;
local txtTxt = "txt";
local pName;
local qhName;										-- 5.60 Name used for fetching Quest History, defaults to pName (i.e. logged name)
local qhKey;										-- 5.60 Realm key used for fetching Quest History, defatulst to pKey (i.e. logged realm)
local qhI, qhT;										-- 5.60 Saves me having to do an array search for selected player details
local pKey;
local pFaction = nil;
local hdNbr;
local nameHdNbr;
local nameDtNbr;
local oriTxt;
local isTitle;
local bttnNumb;
local lastDD;										-- allows one DropDown box change to be undone on the Contact Note Edit frame
local switch;
local parm1;
local Notes = "notes~";								-- database key
local itmIndex = "ItmIndex~";						-- database key (related to saving of Notes with Item Links as Names)
local mrgIndex = "merged~";							-- database key (related to merging of multiple MapNotes)
local prevNote;
local tryI;
local lastBttn;
local lastBttnIndex;
local deletedE;
local visibles;
local lastVisible;
local lastBttnDetl;
local timeSinceLastUpdate = 0;
local popUpTimeSinceLastUpdate = 0;
local NuNRaceDropDown;
local NuNClassDropDown;
local NuNHRankDropDown;
local NuN_rType;
local ttName;
local gtName;
local NuN_TT_Y_Offset = 0;
local NuN_GNote_OriTitle = nil;
local prevLink;
local NuN_Fingers;
local NuN_Trinkets;
local NuN_Hand;
local sendTo;
local msgSeq = 0;
local rMsgSeq = 0;
local popUpHide = nil;
local qTriggs = 0;
local noTipAnchor = nil;
local NuN_QuestAccepted = nil;
local NuN_Receiving = {};
local defaultReceiptDeadline = 3;
local receiptDeadline = defaultReceiptDeadline;
local NuN_uCount = 999;
local NuN_tCount = 999;
local rBuff = "~receiptBuffer";
local receiptPending = nil;
local NuN_msgKey = nil;
local NuN_transmissionTimer = 0;
local NuN_AttemptedFriendIgnores = 0;
local delayedItemTooltip = nil;
local NuN_QLF = nil;
local lastTextKey = "";
local filterText = "";
local suppressDateUpdate = nil;
local NuN_horde = nil;
local fBusy = nil;
local iBusy = nil;
local NuN_ImportModule = nil;
local NuN_ImportData = nil;
local NPCInfo_Proceed = nil;
local NuN_WhoReturnStruct = {};		-- 5.60
local bttnTxtObj;					-- 5.60
local ddProfSearch;					-- 5.60
local ddClassSearch;				-- 5.60
local ddQHSearch;					-- 5.60

-- NuN States
local NuN_State = {};
	NuN_State.inBG = false;
	NuN_State.NuN_FirstTime = true;
	NuN_State.NuN_PinUpHeader = false;
	NuN_State.pinnedTTMoved = true;
	NuN_State.NuN_Fade = false;
	NuN_State.NuN_MouseOver = false;
	NuN_State.NuN_QuestsUpdating = false;
	NuN_State.oneDone = false;
	NuN_State.NuN_AtStartup = true;
	NuN_State.NuN_forceGR = false;
	NuN_State.togglePinUp = false;

local busySending = {};
	busySending.user = "";
	busySending.active = nil;
	busySending.counter = 0;

local sendToChannel = {};
	sendToChannel.id = 0;
	sendToChannel.name = "";

-- 5.60 abridged Database entries
local NuNDataPlayers = {};
local NuNDataANotes = {};
local NuNDataRNotes = {};
local NuNQuestHistory = {};

-- 5.60 Array for holding Alts
local AltArray = {};

local maxRatings = 26;

local NuNTalents = {};

----------------------------------------------------------------------------------------------------------------------------
-- Local Function Hooks -- NOT 'Securing' the following for the time being;
-- (Lets see if they 'really' produce any errors - seem OK for last couple of weeks)
local NuNHooks = {};

----------------------------------------------------------------------------------------------------------------------------

-- Delayed Transmission Variables	-- Leaving Reception untouched apart from allowing more time for message to be fully sent; Only delaying by a fixed amount between Transmissions
local NuN_DTrans = {};
	NuN_DTrans.Status = "Inactive";
	NuN_DTrans.Prefix = "";
	NuN_DTrans.pArray = {};
	NuN_DTrans.tDelay = 0.33;	-- 3 per second default -- Multiply by number of messages and add default Wait to calculate the amount of time to allow for the final message to arrive after the first was sent
	NuN_DTrans.tTrack = 0;
	NuN_DTrans.aIndex = 0;
	NuN_DTrans.Params = {};








-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------
-- Warning & Confirmation Dialog Boxes--
------------------------------------------------------


-- NotesUNeed Note Character Limit Exceeded
StaticPopupDialogs["NUN_NOTELIMIT_EXCEEDED"] = {
	text = TEXT(NUN_TEXTLIM1..NUN_TEXTLIM2),
	button1 = TEXT(OKAY),
	OnShow = function()
		getglobal(this:GetName().."Text"):SetText( NUN_TEXTLIM1 .. NuNC.NUN_MAX_TXT_LIM .. NUN_TEXTLIM2 );
	end,
	showAlert = 1,
	timeout = 0,
	hideOnEscape = 1,
};


local oldRating, ratingChosen, chosenRating, curRatingTxt = false;
-- NotesUNeed Choose Note Importing type for Social Notes
StaticPopupDialogs["NUN_CHANGE_RATING_ONE"] = {
	text = TEXT(NUN_CHOOSE_RATING),
	button1 = ACCEPT,
	button2 = CANCEL,
	hasEditBox = 1,
	maxLetters = 28,
	OnShow = function()
		StaticPopup1EditBox:SetText( NuNSettings.ratings[chosenRating] );
		StaticPopup1EditBox:HighlightText();
		StaticPopup1EditBox:SetFocus(true);
		curRatingTxt = UIDropDownMenu_GetText( NuNPRatingDropDown );

		if ( BlackList ) then
			NuN_BLCheckBox:SetParent(StaticPopup1);
			NuN_BLCheckBox:SetFrameLevel( StaticPopup1:GetFrameLevel() + 2 );
			NuN_BLCheckBox:ClearAllPoints();
			NuN_BLCheckBox:SetPoint("TOPLEFT", StaticPopup1, "TOPLEFT", 11, -20);
			NuN_BLCheckBox:SetChecked( false );
			NuN_BLCheckBox_Ignore:SetChecked( false );
			NuN_BLCheckBox_Warn:SetChecked( false );
			NuN_BLCheckBox:Show();
			local r = NuNSettings.ratingsBL[chosenRating];
			if ( r > 0 ) then
				NuN_BLCheckBox:SetChecked( true );
				if ( ( r == 2 ) or ( r == 4 ) ) then
					NuN_BLCheckBox_Ignore:SetChecked( true );
				end
				if ( r > 2 ) then
					NuN_BLCheckBox_Warn:SetChecked( true );
				end
				NuN_BLCheckBox_Ignore:Show();
				NuN_BLCheckBox_Warn:Show();

			else
				NuN_BLCheckBox_Ignore:Hide();
				NuN_BLCheckBox_Warn:Hide();
			end
		end
	end,
	OnAccept = function()
		local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
		if ( text ~= "" ) then
			if ( ( curRatingTxt ) and ( curRatingTxt ~= "" ) and ( oldRating ) ) then
				UIDropDownMenu_SetText( text, NuNPRatingDropDown );
			end
			NuNSettings.ratings[chosenRating] = text;
			NuN_SetupRatings();
			local r = 0;
			if ( NuN_BLCheckBox:GetChecked() ) then
				r = 1;
			end
			if ( NuN_BLCheckBox_Ignore:GetChecked() ) then
				r = r + 1;
			end
			if ( NuN_BLCheckBox_Warn:GetChecked() ) then
				r = r + 2;
			end
			NuNSettings.ratingsBL[chosenRating] = r;
			ratingChosen = true;
		end
	end,
	EditBoxOnEnterPressed = function()
		local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
		if ( text ~= "" ) then
			if ( ( curRatingTxt ) and ( curRatingTxt ~= "" ) and ( oldRating ) ) then
				UIDropDownMenu_SetText( text, NuNPRatingDropDown );
			end
			NuNSettings.ratings[chosenRating] = text;
			NuN_SetupRatings();
			if ( NuN_BLCheckBox:GetChecked() ) then
				r = 1;
			end
			if ( NuN_BLCheckBox_Ignore:GetChecked() ) then
				r = r + 1;
			end
			if ( NuN_BLCheckBox_Warn:GetChecked() ) then
				r = r + 2;
			end
			NuNSettings.ratingsBL[chosenRating] = r;
			ratingChosen = true;
		end
		this:GetParent():Hide();
	end,
	EditBoxOnEscapePressed = function()
		this:GetParent():Hide();
	end,
	OnHide = function()
		NuN_BLCheckBox:Hide();
		NuN_BLCheckBox_Ignore:Hide();
		NuN_BLCheckBox_Warn:Hide();
		StaticPopup1EditBox:SetText("");
		if ( ratingChosen ) then
			StaticPopup_Show("NUN_CHANGE_RATING_TWO");
		end
	end,
	timeout = 0,
	hideOnEscape = 1,
};

-- NotesUNeed Choose Player rating tooltips
StaticPopupDialogs["NUN_CHANGE_RATING_TWO"] = {
	text = TEXT(NUN_CHOOSE_RATING_TEXT),
	button1 = ACCEPT,
	button2 = CANCEL,
	hasEditBox = 1,
	maxLetters = 512,
	OnShow = function()
		StaticPopup1EditBox:SetText( NuNSettings.ratingsT[chosenRating] );
		StaticPopup1EditBox:HighlightText();
		StaticPopup1EditBox:SetFocus(true);
	end,
	OnAccept = function()
		local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
		if ( text ~= NuNSettings.ratingsT[chosenRating] ) then
			NuNSettings.ratingsT[chosenRating] = text;
		end
	end,
	EditBoxOnEnterPressed = function()
		local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
		if ( text ~= NuNSettings.ratings[chosenRating] ) then
			NuNSettings.ratingsT[chosenRating] = text;
		end
		this:GetParent():Hide();
	end,
	EditBoxOnEscapePressed = function()
		this:GetParent():Hide();
	end,
	OnHide = function()
		StaticPopup1EditBox:SetText("");
	end,
	timeout = 0,
	hideOnEscape = 1,
};

-- Import NotesUNeed Notes
StaticPopupDialogs["NUN_IMPORT_NOTES"] = {
	text = TEXT(NUN_OPT_IMPORT),
	button1 = TEXT(NUN_OPT_IMPORT),
	button2 = TEXT(CANCEL),
	showAlert = 1,
	timeout = 0,
	OnShow = function()
		local recordCount = 0;
		for record, records in pairs(NuN_ImportData) do
			recordCount = recordCount + 1;
		end
		recordCount = "\n{"..recordCount.."}";
		getglobal(this:GetName().."Text"):SetText( NuN_ImportModule..recordCount );
	end,
	OnAccept = function()
		local numImported = 0;
		local n = NuNGet_CommandID(NUN_SEARCHFOR, "Notes");
		local notesTxt = NUN_SEARCHFOR[n].Display;
		for note, data in pairs(NuN_ImportData) do
			NuNDataANotes[note] = {};
			NuNDataANotes[note] = data;
			numImported = numImported + 1;
		end
		NuN_Message( NUN_FINISHED_PROCESSING.." - "..NUN_OPT_IMPORT.." : "..numImported.." "..notesTxt );
	end,
	hideOnEscape = 1,
};

-- Mass Delete
StaticPopupDialogs["NUN_MASS_DELETE_CONFIRM"] = {
	text = TEXT(NUN_MASS_DELETE),
	button1 = TEXT(NUN_MASS_DELETE),
	button2 = TEXT(CANCEL),
	showAlert = 1,
	timeout = 0,
	OnAccept = function()
		local numDeleted = 0;
		local n = NuNGet_CommandID(NUN_SEARCHFOR, "Notes");
		local notesTxt = NUN_SEARCHFOR[n].Display;
		local toDelete = foundNuN;
		local deletes = getn(toDelete);			-- #toDelete ?

		if ( NuNFrame:IsVisible() ) then
			NuNFrame:Hide();
		end
		if ( NuNGNoteFrame:IsVisible() ) then
			NuNGNoteFrame:Hide();
		end

		for i=1, deletes, 1 do
			local noteType = string.sub( toDelete[i], 1, 1 );
			local noteName = string.sub( toDelete[i], 2 );

			if ( ( noteType == NuNC.NUN_HORD_C ) or ( noteType == NuNC.NUN_ALLI_C ) ) then
				if ( NuNDataPlayers[noteName] ) then
					if ( ( NuNSettings[pKey].autoA ) and ( ( NuNDataPlayers[noteName].friendLst )
													       or ( NuNDataPlayers[noteName].ignoreLst ) ) ) then
						-- don't delete friends / ignores if auto maintaining lists
					elseif ( ( NuNSettings[pKey].autoN ) and ( NuNDataPlayers[noteName].type == NuNC.NUN_SELF_C ) ) then
						-- don't delete self note if automated
					else
						NuNDataPlayers[noteName] = nil;
						numDeleted = numDeleted + 1;
						for n = 1, uBttns, 1 do
							nameHdNbr = noteName..pHead..n;
							nameDtNbr = noteName..pDetl..n;
							if ( NuNDataPlayers[nameHdNbr] ) then
								NuNDataPlayers[nameHdNbr] = nil;
							end
							if ( NuNDataPlayers[nameDtNbr] ) then
								NuNDataPlayers[nameDtNbr] = nil;
							end
						end
					end
				end

			else
				if ( NuNDataANotes[noteName] ) then
					NuNDataANotes[noteName] = nil;
					numDeleted = numDeleted + 1;

				elseif ( NuNDataRNotes[noteName] ) then
					NuNDataRNotes[noteName] = nil;
					numDeleted = numDeleted + 1;
				end
			end
		end

		if ( FriendsListFrame:IsVisible() ) then
			NuNNew_FriendsList_Update();
		elseif ( IgnoreListFrame:IsVisible() ) then
			NuNNew_IgnoreList_Update();
		elseif ( GuildPlayerStatusFrame:IsVisible() ) then
			NuNNew_GuildStatus_Update();
		elseif ( GuildStatusFrame:IsVisible() ) then
			NuNNew_GuildStatus_Update();
		elseif ( WhoFrame:IsVisible() ) then
			NuNNew_WhoList_Update();
		end

		NuN_Message( NUN_FINISHED_PROCESSING.." - "..NUN_MASS_DELETE.." : "..numDeleted.." "..notesTxt );
		if ( NuNSearchFrame:IsVisible() ) then
			NuNSearchFrame:Hide();
			NuN_DisplayAll();			-- force a full data refresh
			NuNSearchFrame:Hide();
		end
	end,
	hideOnEscape = 1,
};

-- NotesUNeed Confirm Delete of Quest History
StaticPopupDialogs["NUN_DELETE_QUESTHISTORY"] = {
	text = TEXT(DELETE),
	button1 = TEXT(NUN_DELETE),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		if ( ( not NuNGNoteFrame.fromQuest ) and ( NuNGNoteFrame:IsVisible() ) ) then
			NuNGNoteFrame.fromQuest = c_note;
		end
		NuNQuestHistory[NuNGNoteFrame.fromQuest] = nil;
		deletedE = true;
		NuN_FetchQuestHistory();
	end,
	showAlert = 1,
	timeout = 0,
	hideOnEscape = 1,
};









-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------
-- Local Functions --
--------------------------

local NuNF = {};

-- return true if Ignored
function NuNF.NuN_IsPlayerIgnored(player)
	if ( ( NuNDataPlayers ) and ( NuNDataPlayers[player] ) and ( NuNDataPlayers[player].ignoreLst ) ) then
		return true;

	else
		for i = 1, GetNumIgnores(), 1 do
			local lName = GetIgnoreName(i);
			if ( player == lName ) then
				return true;
			end
		end
	end

	return nil;
end

-- bttnChanges records the changes made to the 10 User definable Butons in the top left of the Contact Note Frame
-- i.e. it is an array that records changes BEFORE the actual Note is Saved; When the Note is Saved, then this array
--	can be reset
function NuNF.ClearButtonChanges()
	for i = 1, (uBttns * 2), 1 do
		bttnChanges[i] = "";
	end
end

-- Little helper function; NuN saves the indexes of Drop Down boxes, rather than the Text
function NuNF.NuNGet_TableID(tab, txt)
	for i = 1, getn(tab), 1 do					-- #tab
		if ( tab[i] == txt ) then return i; end
	end
	return nil;
end

-- Users can define their own button values for the 10 buttons in the top left of the Contact note frame
-- There are 5 Headings buttons with default values, and 5 Details Buttons left blank by default
-- The first 2 Heading buttons are Guild, and Guild Rank by default, and if left un-changed, then NuN will try to auto-populate Guild information in to the first 2 Detail buttons
-- If a Heading is blanked, then the associated Detail button is disabled
-- Headings can have a different value for a specific Contact note saved in NuNData
-- OR They can have a new default for all Contacts saved in NuNSettings
-- OR NuN will use its own hard coded defaults from the array NUN_DFLTHEADINGS
function NuNF.UserButtons_Initialise()
	local bttnHeadingText, bttnDetailText, bttnDetail
	for n = 1, uBttns, 1 do
		bttnHeadingText = getglobal("NuNTitleButton"..n.."ButtonTextHeading");
		bttnDetailText = getglobal("NuNInforButton"..n.."ButtonTextDetail");
		bttnDetail = getglobal("NuNInforButton"..n);
		hdNbr = pHead..n;
		nameHdNbr = c_name..hdNbr;
		nameDtNbr = c_name..pDetl..n;
		if ( NuNDataPlayers[nameHdNbr] ) then
			bttnHeadingText:SetText(NuNDataPlayers[nameHdNbr].txt);
		elseif (NuNSettings[pKey][hdNbr]) then
			bttnHeadingText:SetText(NuNSettings[pKey][hdNbr].txt);
		else
			bttnHeadingText:SetText(NUN_DFLTHEADINGS[n]);
		end
		if ( ( bttnHeadingText:GetText() == nil ) or ( bttnHeadingText:GetText() == "" ) ) then  -- 5.60 Shouldn't this check for  "" rather than nil (or at least both "" or nil)
			bttnDetailText:SetText("");
			bttnDetail:Disable();
		else
			bttnDetail:Enable();
			if ( NuNDataPlayers[nameDtNbr] ) then
				bttnDetailText:SetText(NuNDataPlayers[nameDtNbr].txt);
			else
				bttnDetailText:SetText("");
			end
		end

		if ( n == 1 ) and ( c_guild ~= nil ) then
			if ( bttnHeadingText:GetText() == NUN_DFLTHEADINGS[n] ) and ( (bttnDetailText:GetText() == "") or (bttnDetailText:GetText() == nil) ) then
				bttnDetailText:SetText(c_guild);
				bttnChanges[n+detlOffset] = c_guild;
			end
		end
		if ( n == 2 ) and ( gRank ~= nil ) then
			if ( bttnHeadingText:GetText() == NUN_DFLTHEADINGS[n] ) and ( (bttnDetailText:GetText() == "") or (bttnDetailText:GetText() == nil) ) then
				if ( gRankIndex == 0 ) then
					GuildRank = ("GM : "..gRank);
				else
					GuildRank = (gRankIndex.." : "..gRank);
				end
				bttnDetailText:SetText(GuildRank);
				bttnChanges[n+detlOffset] = GuildRank;
			end
		end
	end
end


-- Initialise the Drop Down Boxes on the Contact Note Frame based on saved data
function NuNF.DropDowns_Initialise()
	if ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].race ~= nil ) then
		UIDropDownMenu_SetSelectedID(NuNRaceDropDown, NuNDataPlayers[c_name].race);
		UIDropDownMenu_SetText(Races[ (NuNDataPlayers[c_name].race) ], NuNRaceDropDown);
	elseif ( c_race ~= nil ) then
		ddBoxes.ddRace = NuNF.NuNGet_TableID(Races, c_race);
		UIDropDownMenu_SetSelectedID(NuNRaceDropDown, ddBoxes.ddRace);
		UIDropDownMenu_SetText(c_race, NuNRaceDropDown);
	else
		UIDropDownMenu_ClearAll(NuNRaceDropDown);
	end

	if ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].cls ~= nil ) then
		UIDropDownMenu_SetSelectedID(NuNClassDropDown, NuNDataPlayers[c_name].cls);
		UIDropDownMenu_SetText(Classes[ (NuNDataPlayers[c_name].cls) ], NuNClassDropDown);
	elseif ( c_class ~= nil ) then
		ddBoxes.ddClass = NuNF.NuNGet_TableID(Classes, c_class);
		UIDropDownMenu_SetSelectedID(NuNClassDropDown, ddBoxes.ddClass);
		UIDropDownMenu_SetText(c_class, NuNClassDropDown);
	else
		UIDropDownMenu_ClearAll(NuNClassDropDown);
	end

	if ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].sex ~= nil ) then
		UIDropDownMenu_SetSelectedID(NuNSexDropDown, NuNDataPlayers[c_name].sex);
		UIDropDownMenu_SetText(NUN_SEXES[ (NuNDataPlayers[c_name].sex) ], NuNSexDropDown);
	elseif ( c_sex ~= nil ) then
		ddBoxes.ddSex = c_sex;
		c_sex = NUN_SEXES[ddBoxes.ddSex];
		UIDropDownMenu_SetSelectedID(NuNSexDropDown, ddBoxes.ddSex);
		UIDropDownMenu_SetText(c_sex, NuNSexDropDown);
	else
		UIDropDownMenu_ClearAll(NuNSexDropDown);
	end

	if ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].prating ~= nil ) then
		UIDropDownMenu_SetSelectedID(NuNPRatingDropDown, NuNDataPlayers[c_name].prating);
		UIDropDownMenu_SetText(NuNSettings.ratings[ NuNDataPlayers[c_name].prating ], NuNPRatingDropDown);
	elseif ( c_prating ~= nil ) then
		ddBoxes.ddPRating = c_prating;
		c_prating = NuNSettings.ratings[ddBoxes.ddPRating];
		UIDropDownMenu_SetSelectedID(NuNPRatingDropDown, ddBoxes.ddPRating);
		UIDropDownMenu_SetText(c_prating, NuNPRatingDropDown);
	else
		UIDropDownMenu_ClearAll(NuNPRatingDropDown);
	end

	if ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].prof1 ~= nil ) then
		UIDropDownMenu_SetSelectedID(NuNProf1DropDown, NuNDataPlayers[c_name].prof1);
		UIDropDownMenu_SetText(NUN_PROFESSIONS[ (NuNDataPlayers[c_name].prof1) ], NuNProf1DropDown);
	elseif ( c_prof1 ~= nil ) then
		ddBoxes.ddProf1 = c_prof1;
		c_prof1 = NUN_PROFESSIONS[ddBoxes.ddProf1];
		UIDropDownMenu_SetSelectedID(NuNProf1DropDown, ddBoxes.ddProf1);
		UIDropDownMenu_SetText(c_prof1, NuNProf1DropDown);
	else
		UIDropDownMenu_ClearAll(NuNProf1DropDown);
	end

	if ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].prof2 ~= nil ) then
		UIDropDownMenu_SetSelectedID(NuNProf2DropDown, NuNDataPlayers[c_name].prof2);
		UIDropDownMenu_SetText(NUN_PROFESSIONS[ (NuNDataPlayers[c_name].prof2) ], NuNProf2DropDown);
	elseif ( c_prof1 ~= nil ) then
		ddBoxes.ddProf2 = c_prof2;
		c_prof2 = NUN_PROFESSIONS[ddBoxes.ddProf2];
		UIDropDownMenu_SetSelectedID(NuNProf2DropDown, ddBoxes.ddProf2);
		UIDropDownMenu_SetText(c_prof2, NuNProf2DropDown);
	else
		UIDropDownMenu_ClearAll(NuNProf2DropDown);
	end

	if ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].arena ~= nil ) then
		UIDropDownMenu_SetSelectedID(NuNArenaRDropDown, NuNDataPlayers[c_name].arena);
		UIDropDownMenu_SetText(NUN_ARENAR[ (NuNDataPlayers[c_name].arena) ], NuNArenaRDropDown);
	elseif ( c_arena ~= nil ) then
		ddBoxes.ddArena = c_arena;
		c_arena = NUN_ARENAR[ddBoxes.ddArena];
		UIDropDownMenu_SetSelectedID(NuNArenaRDropDown, ddBoxes.ddArena);
		UIDropDownMenu_SetText(c_arena, NuNArenaRDropDown);
	else
		UIDropDownMenu_ClearAll(NuNArenaRDropDown);
	end

	if ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].hrank ~= nil ) then
		UIDropDownMenu_SetSelectedID(NuNHRankDropDown, NuNDataPlayers[c_name].hrank);
		UIDropDownMenu_SetText(Ranks[ (NuNDataPlayers[c_name].hrank) ], NuNHRankDropDown);
	elseif ( c_hrank ~= nil ) then
		ddBoxes.ddHRank = c_hrank;
		c_hrank = Ranks[ddBoxes.ddHRank];
		UIDropDownMenu_SetSelectedID(NuNHRankDropDown, ddBoxes.ddHRank);
		UIDropDownMenu_SetText(c_hrank, NuNHRankDropDown);
	else
		UIDropDownMenu_ClearAll(NuNHRankDropDown);
	end

end

function NuNF.NuN_GNoteFromItem(link, theTT)
	local catTxt = "";

	catTxt = NuNF.NuN_ExtractTooltipInfo(catTxt, theTT);
	c_note = link;
	c_type = NuNGet_CommandID(NUN_NOTETYPES, "ITM");
	NuN_ShowTitledGNote(catTxt);
end

function NuNF.NuN_ExtractTooltipInfo(xTTText, theTT)
	local lftTxt, rgtTxt, needRight;
	local endLine = "\n";
	local tmpTxt;
	local ttLLen = NuNC.NUN_TT_LEN;

	if ( NuNSettings[pKey].ttLLen ) then
		if ( NuNSettings[pKey].ttLLen == "" ) then
			ttLLen = 0;
		else
			ttLLen = tonumber( NuNSettings[pKey].ttLLen );
		end
	end

	for i=2, 23, 1 do
		lftTxt = getglobal(theTT.."TextLeft"..i);
		rgtTxt = getglobal(theTT.."TextRight"..i);
		if ( lftTxt ) then
			lftTxt = lftTxt:GetText();
			if ( rgtTxt ) then rgtTxt = rgtTxt:GetText(); end
			needRight = false;
			tmpTxt = "";
			if ( lftTxt ) then
				if ( ( string.find(lftTxt, "\"" ) ) or ( ( string.find(lftTxt, "/") ) and ( string.find(lftTxt, "\)") ) ) ) then
					tmpTxt = NuNC.NUN_GOLD..lftTxt;
				elseif ( string.find(lftTxt, ":") ) then
					tmpTxt = NuNC.NUN_GREEN..lftTxt;
				else
					tmpTxt = NuNC.NUN_WHITE..lftTxt;
				end
				if ( rgtTxt ) then
					needRight = NuNF.NuN_TestLeftTT(lftTxt);
					if ( needRight ) then
						local lLen = string.len(lftTxt);
						local rLen = string.len(rgtTxt);
						local spaces = ttLLen - (lLen + rLen) - 10;
						local pad = string.rep(" ", spaces);
						tmpTxt = tmpTxt..pad..rgtTxt;
					end
				end
				xTTText = xTTText..tmpTxt..NuNC.NUN_C_END..endLine;
			end
		end
	end

	return xTTText;
end

function NuNF.NuN_TestLeftTT(lftTxt)
	if 	( string.find(lftTxt, NUN_HAND ) ) or 
		( string.find(lftTxt, NUN_HAND2) ) or 
		( string.find(lftTxt, NUN_FEET ) ) or 
		( string.find(lftTxt, NUN_LEGS ) ) or 
		( string.find(lftTxt, NUN_HEAD ) ) or 
		( string.find(lftTxt, NUN_WAIST ) ) or 
		( string.find(lftTxt, NUN_SHOULDER ) ) or 
		( string.find(lftTxt, NUN_CHEST ) ) or 
		( string.find(lftTxt, NUN_WRIST ) ) or 
		( string.find(lftTxt, NUN_DAMAGE ) ) then
			return true;
	else
			return false;
	end
end

function NuNF.NuN_CheckPartyByName(parmN)
	local partym;
	local numParty = GetNumPartyMembers();

	for groupIndex = 1, numParty, 1 do
 		if (GetPartyMember(groupIndex)) then
 			partym = "party"..groupIndex;
 			lName = UnitName(partym);
 			if ( lName == parmN) then
 				return partym;
 			end
 		end
	end
	return nil;
end

function NuNF.NuN_CheckRaidByName(parmN)
	local raidm;
	local lclName;
	local numRaid = GetNumRaidMembers();

	for raidIndex = 1, numRaid, 1 do
		lclName = GetRaidRosterInfo(raidIndex);
		if ( lclName == parmN ) then
			raidm = "raid"..raidIndex;
			return raidm;
		end
	end
	return nil;
end

function NuNF.NuN_CopyTable(fT, tT)
	if ( ( not fT ) or ( not tT ) or ( type(fT) ~= "table" ) or ( type(tT) ~= "table" ) ) then return -1; end

	for index, value in pairs(fT) do
		if ( type(value) == "table" ) then
			tT[index] = {};
			NuNF.NuN_CopyTable(value, tT[index]);

		else
			tT[index] = value;
		end
	end
end

function NuNF.QueryTalents()
	if ( not NuNTalents.player ) then
		NuNTalents = {};
		return;
	end

	local spent, prefix, name, icon, points = 0, "";
	local nameTalent, iconPath, tier, column, currentRank, maxRank;
	NuNTalents.tabs = GetNumTalentTabs(true) or 0;
	for tab = 1, NuNTalents.tabs do
		-- record tab
		name, icon, points = GetTalentTabInfo(tab, true);
		if ( points ~= nil ) then
			if ( points > spent ) then
				NuNTalents.spec = name;
				NuNTalents.icon = icon;
				spent = points;
			end
			NuNTalents.summary = NuNTalents.summary .. prefix .. points;
			NuNTalents.total =  NuNTalents.total + points;
			NuNTalents[tab] = {};
			NuNTalents[tab].spec = name;
			NuNTalents[tab].points = points;
			NuNTalents[tab].icon = icon;
			NuNTalents[tab].specifics = {};

			-- record talent choices
			for t = 1, GetNumTalents(tab, true) do
				nameTalent, iconPath, tier, column, currentRank, maxRank = GetTalentInfo(tab, t, true);
				if ( ( currentRank ) and ( currentRank > 0 ) ) then
					NuNTalents[tab].specifics[nameTalent] = {};
					NuNTalents[tab].specifics[nameTalent].talentName = nameTalent;
					NuNTalents[tab].specifics[nameTalent].iconPath = iconPath;
					NuNTalents[tab].specifics[nameTalent].curR = currentRank;
					NuNTalents[tab].specifics[nameTalent].maxR = maxRank;
				end
			end

			prefix = "-";
		end
	end

	-- Live update if record for player already exists...
	if ( ( NuNDataPlayers[NuNTalents.player] ) and ( NuNTalents.total > 0 ) ) then
		-- copy NuNTalents details to .talents array
		NuNDataPlayers[NuNTalents.player].talents = {};
		NuNF.NuN_CopyTable(NuNTalents, NuNDataPlayers[NuNTalents.player].talents);
	elseif ( NuNDataPlayers[NuNTalents.player] ) then
		NuNDataPlayers[NuNTalents.player].talents = nil;
	end

end

-- 5.60 NuN_Target re-written to NuN_UnitInfo for adjusting Open Note details without (necessarily) saving to database
function NuNF.NuN_UnitInfo(unitTest, contactName, theUnitID)							-- 5.60 Allow passing of the unitID
	local lName;

	-- Try to fetch a valid unitID
	if ( not theUnitID ) then							-- 5.60 Changes in this if block
		lName = UnitName("target");
		if ( ( lName ) and ( lName == contactName ) ) then
			theUnitID = "target";
		end

		if ( not theUnitID ) then
			theUnitID = NuNF.NuN_CheckPartyByName(contactName);
		end

		if ( not theUnitID ) then
			theUnitID = NuNF.NuN_CheckRaidByName(contactName);
		end
	end

	-- if not just testing, and have a unitID, then fetch info
	if ( ( not unitTest ) and ( theUnitID ) ) then
		local lRace;
		local lClass;
		local lSex;
		local lPvPRank;
		local lPvPRankID;
		local lgName;
		local lgRank;
		local lgRankIndex;

		lRace = UnitRace(theUnitID);
		if ( lRace ~= nil ) then
			c_race = lRace;
			ddBoxes.ddRace = NuNF.NuNGet_TableID(Races, c_race);
			UIDropDownMenu_SetSelectedID(NuNRaceDropDown, ddBoxes.ddRace);
			UIDropDownMenu_SetText(c_race, NuNRaceDropDown);
		end

		lClass = UnitClass(theUnitID);
		if ( lClass ~= nil ) then
			c_class = lClass;
			ddBoxes.ddClass = NuNF.NuNGet_TableID(Classes, c_class);
			UIDropDownMenu_SetSelectedID(NuNClassDropDown, ddBoxes.ddClass);
			UIDropDownMenu_SetText(c_class, NuNClassDropDown);
		end

		lSex = UnitSex(theUnitID);
		if ( lSex ~= nil ) then
			if ( lSex == 2 ) then
				lsex = NUN_MALE;
			elseif ( lSex == 3 ) then
				lsex = NUN_FEMALE;
			end
			ddBoxes.ddSex = NuNF.NuNGet_TableID(NUN_SEXES, lsex);
			UIDropDownMenu_SetSelectedID(NuNSexDropDown, ddBoxes.ddSex);
			UIDropDownMenu_SetText(lsex, NuNSexDropDown);
		end

		lgName, lgRank, lgRankIndex = GetGuildInfo(theUnitID);
		if ( ( lgName ) and ( lgName ~= "" ) ) then
			c_guild = lgName;

			bttnHeadingText1 = getglobal("NuNTitleButton1ButtonTextHeading");
			bttnDetailText1 = getglobal("NuNInforButton1ButtonTextDetail");
			bttnHeadingText2 = getglobal("NuNTitleButton2ButtonTextHeading");
			bttnDetailText2 = getglobal("NuNInforButton2ButtonTextDetail");

			if ( bttnHeadingText1:GetText() == NUN_DFLTHEADINGS[1] ) then
				bttnDetailText1:SetText(lgName);
				bttnChanges[6] = lgName;
			end
			if ( bttnHeadingText2:GetText() == NUN_DFLTHEADINGS[2] ) then
				if ( lgRankIndex == 0 ) then
					lgRankTxt = ( "GM : "..lgRank );
				else
					lgRankTxt = ( lgRankIndex.." : "..lgRank );
				end
				bttnDetailText2:SetText(lgRankTxt);
				bttnChanges[7] = lgRankTxt;
			end
		end

		if ( theUnitID == "target" ) then
			for index = 1, 19, 1 do
				local text = GetInventoryItemLink(theUnitID, index);
				if ( text ) then
					NuNText:SetText( NuNText:GetText() .. "\n" .. text );
				end
			end
		end

		if ( ( contactName ) and ( contactName ~= "" ) ) then
			if ( ( CheckInteractDistance(theUnitID, 1) )
			and ( CanInspect(theUnitID, true) )
			and ( ( UnitLevel(theUnitID) or 0 ) > 9 ) ) then

				NuNTalents = {};
				NuNTalents.player = contactName;
				NuNTalents.total = 0;
				NuNTalents.summary = "";
				NuNTalents.theUnitID = theUnitID;

				local inspected = "";
				if ( (InspectFrame) and ( InspectFrame:IsVisible() ) ) then
					inspected = InspectNameText:GetText();
				end

				if ( inspected == contactName ) then
					NuNF.QueryTalents();

				else
					NuNFrame:RegisterEvent("INSPECT_TALENT_READY");
					NotifyInspect(theUnitID);
				end

			else
				NuNTalents = {};
			end
		end

	end

	return theUnitID;
end

-- 5.60 New function for updating background database information based on unitID
function NuNF.NuN_UnitInfoDB(lMember, lUnit)
	if ( not NuNDataPlayers[lMember] ) then
		return;
	end

	if ( NuN_horde ) then
		NuNDataPlayers[lMember].race = NuNF.NuNGet_TableID( NUN_HRACES, UnitRace(lUnit) );	
	else                                        									
		NuNDataPlayers[lMember].race = NuNF.NuNGet_TableID( NUN_ARACES, UnitRace(lUnit) );	
	end
		
	if ( NuN_horde ) then                       									
		NuNDataPlayers[lMember].cls = NuNF.NuNGet_TableID( NUN_HCLASSES, UnitClass(lUnit) );	
	else                                        									
		NuNDataPlayers[lMember].cls = NuNF.NuNGet_TableID( NUN_ACLASSES, UnitClass(lUnit) );	
	end                                         									

	local lSex = UnitSex( lUnit );                    								
	if ( lSex ) then                                        						
		NuNDataPlayers[lMember].sex = lSex - 1;										
	end                                                     						

	local lGuild, lGRank, lGRankIndex = GetGuildInfo( lUnit );						
	local compoundKey, compoundSettingsKey, lGRankTxt;
	if ( ( lGuild ) and ( lGuild ~= "" ) ) then										
		-- Guild
		NuNDataPlayers[lMember].guild = lGuild;
		settingsKey = pHead .. "1";
		compoundKey = lMember .. settingsKey;
		if ( ( ( NuNDataPlayers[compoundKey] ) and ( NuNDataPlayers[compoundKey].txt ~= NUN_DFLTHEADINGS[1] ) ) or				
			 ( ( NuNSettings[pKey][settingsKey] ) and ( NuNSettings[pKey][settingsKey].txt ~= NUN_DFLTHEADINGS[1] ) ) ) then
		else
			compoundKey = lMember .. pDetl .. "1";                        	
			NuNDataPlayers[compoundKey] = {};									
			NuNDataPlayers[compoundKey].txt = lGuild;							
		end
		-- Guild Rank
		settingsKey = pHead .. "2";
		compoundKey = lMember .. settingsKey;
		if ( ( ( NuNDataPlayers[compoundKey] ) and ( NuNDataPlayers[compoundKey].txt ~= NUN_DFLTHEADINGS[2] ) ) or
			 ( ( NuNSettings[pKey][settingsKey] ) and ( NuNSettings[pKey][settingsKey].txt ~= NUN_DFLTHEADINGS[2] ) ) ) then
		else																		
			compoundKey = lMember .. pDetl .. "2";
			if ( lGRankIndex == 0 ) then
				lGRank = ("GM : "..lGRank);										
			else																	
				lGRank = (lGRankIndex.." : "..lGRank);
			end
			NuNDataPlayers[compoundKey] = {};
			NuNDataPlayers[compoundKey].txt = lGRank;
		end                                                         				
	end																				
end

-- little utility function
function NuNF.NuN_copyT(t1, t2, c_prefix)
	local i1 = getn(t1);
	for i2=1, getn(t2), 1 do		-- #t2
		i1 = i1 + 1;
		t1[i1] = c_prefix..t2[i2];
	end
end

-- Sort the Notes to display :
--	Players of your Faction first			- ofc if no Player notes have been included in the filter then....
--	Players of opposing Faction second		- ofc if no Player notes have been included in the filter than.....
--	General Notes last				- ofc if no General notes have been included in the filter then......
function NuNF.NuN_DefaultSort()
	if ( NuN_horde ) then
		NuNF.NuN_copyT(foundNuN, foundHNuN, NuNC.NUN_HORD_C);
		NuNF.NuN_copyT(foundNuN, foundANuN, NuNC.NUN_ALLI_C);
		NuNF.NuN_copyT(foundNuN, foundNNuN, NuNC.NUN_NOTE_C);
	else
		NuNF.NuN_copyT(foundNuN, foundANuN, NuNC.NUN_ALLI_C);
		NuNF.NuN_copyT(foundNuN, foundHNuN, NuNC.NUN_HORD_C);
		NuNF.NuN_copyT(foundNuN, foundNNuN, NuNC.NUN_NOTE_C);
	end
end

function NuNF.NuN_GetDateStamp()
	local dateStamp = date("%A, %d %B %Y  %H:%M:%S");
	dateStamp = NuNF.NuN_LocaliseDateStamp(dateStamp);
	return dateStamp;
end

-- this was used for usefully timestamping notes in the Saved Variables file
-- not seen by user, and no code depends on it yet, but might be useful
function NuNF.NuN_GetComparitiveDate(originalData)
	if ( ( suppressDateUpdate ) and ( originalData.lastChanged ) ) then
		return originalData.lastChanged;
	else
		local comparitiveDate = tonumber( date("%Y%m%d%H%M%S") );
		return comparitiveDate;
	end
end

-- Location Stamping of notes
function NuNF.NuN_GetLoc()
	local locData = pName.."'s "..NUN_LOC.." : ";
	local myCID, myC, mySubZ, myZID, myZ, px, py, coords;
	local loc = false;

	myCID = GetCurrentMapContinent();
	if ( ( myCID ~= nil) and ( myCID > 0 ) ) then
		myC = c_continents[myCID].name;
	end
	if ( myC ~= nil ) then
		locData = locData..myC..", ";
		loc = true;
	end

	myZ = GetZoneText();
	if ( ( myZ == nil ) or ( myZ == "" ) ) then
		myZID = GetCurrentMapZone();
		if ( ( myZID ~= nil ) and ( myCID ~= nil ) and ( myCID > 0 ) ) then
			myZ = c_continents[myCID].zones[myZID];
		end
	end
	if ( ( myZ ~= nil ) and ( myZ ~= "" ) ) then
		locData = locData..myZ..", ";
	end


	mySubZ = GetSubZoneText();
	if ( ( mySubZ == nil ) or ( mySubZ == "" ) ) then
		mySubZ = GetMinimapZoneText();
	end
	if ( mySubZ ~= nil ) then
		locData = locData..mySubZ..", ";
		loc = true;
	end

	px, py = GetPlayerMapPosition("player");
    	if ( ( px ~= nil ) and ( py ~= nil ) ) then
        	coords = format("(%d, %d)", px * 100.0, py * 100.0);
		locData = locData..coords;
		loc = true; 
    	end
    	if ( loc == true ) then
		return locData;
	else
		return "";
	end
end

function NuNF.NuN_GetDisplayText(dText)
	dText = string.gsub(dText, "n", "\n");
	dText = string.gsub(dText, "q", "\"");
	dText = string.gsub(dText, "s", "\\");
	dText = string.gsub(dText, "\124\124", "|");
	dText = string.gsub(dText, "|C", "|c");
	dText = string.gsub(dText, "|R", "|r");
	dText = string.gsub(dText, "||c", "|c");
	dText = string.gsub(dText, "||r", "|r");
	
	return dText;
end

function NuNF.NuN_SetSaveText(dText)
	dText = string.gsub(dText, "\n", "n");
	dText = string.gsub(dText, "\"", "q");
	dText = string.gsub(dText, "\\", "s");
	dText = string.gsub(dText, "\124\124", "|");
	dText = string.gsub(dText, "|C", "|c");
	dText = string.gsub(dText, "|R", "|r");
	dText = string.gsub(dText, "||c", "|c");
	dText = string.gsub(dText, "||r", "|r");

	return dText;
end

function NuNF.NuN_GetCText(gLclName)
	local txtIndex;
	local catText;

	catText = "";
	if ( NuNDataPlayers[gLclName][txtTxt] ) then
		catText = NuNDataPlayers[gLclName][txtTxt];
	end
	for i = 1, NuNC.NUN_MAX_ADD_TXT, 1 do
		txtIndex = txtTxt..i;
		if ( NuNDataPlayers[gLclName][txtIndex] ) then
			catText = catText..NuNDataPlayers[gLclName][txtIndex];
		end
	end

	catText = NuNF.NuN_GetDisplayText(catText);
	return catText;
end

function NuNF.NuN_GetGText(gLclNote)
	local txtIndex;
	local catText;

	catText = "";
	if ( ( NuNDataRNotes[gLclNote] ) and ( NuNDataRNotes[gLclNote][txtTxt] ) ) then
		catText = NuNDataRNotes[gLclNote][txtTxt];
	elseif ( ( NuNDataANotes[gLclNote] ) and ( NuNDataANotes[gLclNote][txtTxt] ) ) then
		catText = NuNDataANotes[gLclNote][txtTxt];
	end
	for i = 1, NuNC.NUN_MAX_ADD_TXT, 1 do
		txtIndex = txtTxt..i;
		if ( ( NuNDataRNotes[gLclNote] ) and ( NuNDataRNotes[gLclNote][txtIndex] ) ) then
			catText = catText..NuNDataRNotes[gLclNote][txtIndex];
		elseif ( ( NuNDataANotes[gLclNote] ) and ( NuNDataANotes[gLclNote][txtIndex] ) ) then
			catText = catText..NuNDataANotes[gLclNote][txtIndex];
		end
	end

	catText = NuNF.NuN_GetDisplayText(catText);
	return catText;
end

-- c_text must be pre-populated before calling this function
function NuNF.NuN_SetCText(sLclName)
	local cLower;
	local cUpper;
	local txtIndex;
	local tmpText = c_text;

	c_text = NuNF.NuN_SetSaveText(c_text);
	c_text_len = string.len(c_text);
	if ( c_text_len < NuNC.NUN_MAX_TXT_CHR ) then
		cUpper = c_text_len;
	else
		cUpper = NuNC.NUN_MAX_TXT_CHR;
	end
	NuNDataPlayers[sLclName][txtTxt] = string.sub(c_text, 1, cUpper);
	for i = 1, NuNC.NUN_MAX_ADD_TXT, 1 do
		cLower = NuNC.NUN_MAX_TXT_CHR * i;
		txtIndex = txtTxt..i;
		if ( c_text_len > cLower ) then
			cLower = cLower + 1;
			cUpper = NuNC.NUN_MAX_TXT_CHR * ( i + 1 );
			if ( c_text_len < cUpper ) then
				cUpper = c_text_len;
			end
			NuNDataPlayers[sLclName][txtIndex] = string.sub(c_text, cLower, cUpper);
		else
			NuNDataPlayers[sLclName][txtIndex] = "";
		end
	end
	NuNDataPlayers[sLclName].lastChanged = NuNF.NuN_GetComparitiveDate(NuNDataPlayers[sLclName]);

	c_text = tmpText;
end

-- c_note and g_text must be pre-populated with noteName and text before calling this function
function NuNF.NuN_SetGText(saveLvl)
	local cLower;
	local cUpper;
	local txtIndex;
	local tmpText = g_text;

	g_text = NuNF.NuN_SetSaveText(g_text);
	g_text_len = string.len(g_text);
	if ( g_text_len < NuNC.NUN_MAX_TXT_CHR ) then
		cUpper = g_text_len;
	else
		cUpper = NuNC.NUN_MAX_TXT_CHR;
	end

	if ( saveLvl == "Realm" ) then
		NuNDataRNotes[c_note][txtTxt] = string.sub(g_text, 1, NuNC.NUN_MAX_TXT_CHR);
		for i = 1, NuNC.NUN_MAX_ADD_TXT, 1 do
			cLower = NuNC.NUN_MAX_TXT_CHR * i;
			txtIndex = txtTxt..i;
			if ( g_text_len > cLower ) then
				cLower = cLower + 1;
				cUpper = NuNC.NUN_MAX_TXT_CHR * ( i + 1 );
				if ( g_text_len < cUpper ) then
					cUpper = g_text_len;
				end
				NuNDataRNotes[c_note][txtIndex] = string.sub(g_text, cLower, cUpper);
			else
				NuNDataRNotes[c_note][txtIndex] = "";
			end
		end
		NuNDataRNotes[c_note].lastChanged = NuNF.NuN_GetComparitiveDate(NuNDataRNotes[c_note]);
	else
		NuNDataANotes[c_note][txtTxt] = string.sub(g_text, 1, NuNC.NUN_MAX_TXT_CHR);
		for i = 1, NuNC.NUN_MAX_ADD_TXT, 1 do
			cLower = NuNC.NUN_MAX_TXT_CHR * i;
			txtIndex = txtTxt..i;
			if ( g_text_len > cLower ) then
				cLower = cLower + 1;
				cUpper = NuNC.NUN_MAX_TXT_CHR * ( i + 1 );
				if ( g_text_len < cUpper ) then
					cUpper = g_text_len;
				end
				NuNDataANotes[c_note][txtIndex] = string.sub(g_text, cLower, cUpper);
			else
				NuNDataANotes[c_note][txtIndex] = "";
			end
		end
		NuNDataANotes[c_note].lastChanged = NuNF.NuN_GetComparitiveDate(NuNDataANotes[c_note]);
	end

	g_text = tmpText;
end

-- build the NotesUNeed tooltip based on the NotesUNeed note
function NuNF.NuN_BuildTT(nunTT)
	local lGuild = nil;
	local lGuildR = nil;
	local lprof = "";
	local lprating = nil;
	local tt = {};
	local tti = 0;
	local srchText, sStart, sStop, tipText;
	local lineCount = 0;
	local finalTipText;
	local txtLines;
	local NuN_trunc = false;
	local gttLines = 0;
	local ttLinesDiff = 0;
	local ttLen = NuNC.NUN_TT_MAX;
	local ttLLen = NuNC.NUN_TT_LEN;

	if ( ( NuNSettings[pKey].toolTips ) or ( nunTT == NuN_PinnedTooltip ) ) then
		if ( NuN_PinnedTooltip.type ~= "General" ) and ( NuN_PinnedTooltip.type ~= "QuestHistory" ) and ( NuNDataPlayers[ttName] ) then
			local isIgnored = NuNF.NuN_IsPlayerIgnored(ttName);
			if ( ( NuNSettings[pKey].hignores ) and ( isIgnored ) ) then
				return;
			end
			nunTT:AddLine(NUN_NOTESUNEED_INFO .. NuNC.NUN_PINNED_TT_PADDING, 1, 0.7, 0);
			lineCount = lineCount + 1;
	
			if ( ( NuNDataPlayers[ttName].talents ) and ( NuNDataPlayers[ttName].talents.total > 0 ) ) then
				nunTT:AddDoubleLine(NuNDataPlayers[ttName].talents.spec, NuNDataPlayers[ttName].talents.summary, nil, nil, nil, 0, 1, 0);
			end

			srchText = NuNF.NuN_GetCText(ttName);

			local alts, counter = "", 0;
			local _, found, alt = string.find(srchText, "<ALT:(%a+)>");
			while ( alt ) do
				counter = counter + 1;
				alts = alts .. alt;
				_, found, alt = string.find(srchText, "<ALT:(%a+)>", found);
				if ( alt ) then
					alts = alts .. ", ";
					if ( counter > 3 ) then
						alts = alts .. "\n";
						counter = 0;
					end
				end
			end
			if ( alts ~= "" ) then
				nunTT:AddLine(alts, 0.1, 0.9, 0.1);
				srchText = string.gsub(srchText, "<ALT:%a+>\n", "");
				srchText = string.gsub(srchText, "<ALT:%a+>,%s*", "");
				srchText = string.gsub(srchText, "<ALT:%a+>", "");
			end

			if ( NuN_State.NuN_PinUpHeader == true ) then
				nunTT:AddLine(ttName);
				lineCount = lineCount + 1;
			end

			for n = 1, uBttns, 1 do
				hdNbr = pHead..n
				nameHdNbr = ttName..hdNbr;
				nameDtNbr = ttName..pDetl..n;
				if ( ( (n == 1) and (not NuNDataPlayers[nameHdNbr]) ) or ( (n==1) and ( NuNDataPlayers[nameHdNbr].txt == NUN_DFLTHEADINGS[n] ) ) ) then
					if ( NuNDataPlayers[nameDtNbr] ) then
						lGuild = NuNDataPlayers[nameDtNbr].txt;
					end
				elseif ( ( (n == 2) and (not NuNDataPlayers[nameHdNbr]) ) or ( (n==2) and ( NuNDataPlayers[nameHdNbr].txt == NUN_DFLTHEADINGS[n] ) ) ) then
					if ( NuNDataPlayers[nameDtNbr] ) then
						lGuildR = NuNDataPlayers[nameDtNbr].txt;
					end
				elseif ( NuNDataPlayers[nameHdNbr] ) then
					local ttDetl = (string.lower(NuNDataPlayers[nameHdNbr].txt));
					if ( string.find(ttDetl, NuNC.NUN_TT_HDNG) ) then
						if ( NuNDataPlayers[nameDtNbr] ) then
							tti = tti + 1;
							tt[tti] = NuNDataPlayers[nameDtNbr].txt;
						end
					end
				elseif ( NuNSettings[pKey][hdNbr] ) then
					local ttDetl = (string.lower(NuNSettings[pKey][hdNbr].txt));
					if ( string.find(ttDetl, NuNC.NUN_TT_HDNG) ) then
						if ( NuNDataPlayers[nameDtNbr] ) then
							tti = tti + 1;
							tt[tti] = NuNDataPlayers[nameDtNbr].txt;
						end
					end
				end
			end

			for i = 1, getn(tt), 1 do				-- #tt
				nunTT:AddLine(tt[i], 0.9, 0.2, 0.2);
				lineCount = lineCount + 1;
			end

			if ( ( lGuild ~= nil) and ( lGuild ~= "" ) ) then
				if ( ( lGuildR ~= nil ) and ( lGuildR ~= "" ) ) then
					lGuild = lGuild.." : "..lGuildR;
				end
				nunTT:AddLine(lGuild, 0.9, 0.9, 0);
				lineCount = lineCount + 1;
			end

			if ( NuNDataPlayers[ttName].prating ) then
				lprating = NuNSettings.ratings[ NuNDataPlayers[ttName].prating ];
				nunTT:AddLine(lprating, 0.7, 0.7, 0.9);
				lineCount = lineCount + 1;
			end

			if ( NuNDataPlayers[ttName].prof1 ) then
				lprof = NUN_PROFESSIONS[NuNDataPlayers[ttName].prof1];
			end
			if ( NuNDataPlayers[ttName].prof2 ) then
				if (lprof == "") then
					lprof = NUN_PROFESSIONS[NuNDataPlayers[ttName].prof2];
				else
					lprof = lprof.." - "..NUN_PROFESSIONS[NuNDataPlayers[ttName].prof2];
				end
			end
			if ( lprof ~= "" ) then
				nunTT:AddLine(lprof, 0.8, 0.2, 0.8);
				lineCount = lineCount + 1;
			end

		elseif ( ( NuN_PinnedTooltip.type ~= "Contact" ) and ( NuN_PinnedTooltip.type ~= "QuestHistory" ) and ( ( NuNDataRNotes[ttName] ) or ( NuNDataANotes[ttName] ) ) ) then
			nunTT:AddLine(NUN_NOTESUNEED_INFO .. NuNC.NUN_PINNED_TT_PADDING, 1, 0.7, 0);
			lineCount = lineCount + 1;

			if ( NuN_State.NuN_PinUpHeader == true ) then
				nunTT:AddLine(ttName);
				lineCount = lineCount + 1;
			end

			srchText = NuNF.NuN_GetGText(ttName);
		elseif ( ( NuN_PinnedTooltip.type == "QuestHistory" ) and ( NuNQuestHistory[ttName] ) ) then
			nunTT:AddLine(NUN_NOTESUNEED_INFO .. NuNC.NUN_PINNED_TT_PADDING, 1, 0.7, 0);
			lineCount = lineCount + 1;

			if ( NuN_State.NuN_PinUpHeader == true ) then
				nunTT:AddLine(ttName);
				lineCount = lineCount + 1;
			end

			srchText = NuNF.NuN_GetDisplayText( NuNQuestHistory[ttName].txt );
		end

		if ( NuN_PinnedTooltip.type ~= "QuestHistory" ) then
			if ( NuNSettings[pKey].ttLen ) then
				if ( NuNSettings[pKey].ttLen == "" ) then
					ttLen = 0;
				else
					ttLen = tonumber( NuNSettings[pKey].ttLen );
				end
			end
			if ( NuNSettings[pKey].ttLLen ) then
				if ( NuNSettings[pKey].ttLLen == "" ) then
					ttLLen = 0;
				else
					ttLLen = tonumber( NuNSettings[pKey].ttLLen );
				end
			end
		end

		if ( ( NuN_State.NuN_MouseOver == true ) and ( NuNSettings[pKey].minOver ) and ( not IsAltKeyDown() ) ) then
			srchText = "";
		end

		if ( ( srchText ~= nil ) and ( srchText ~= "" ) ) then
			sStart = string.find(srchText, NuNC.NUN_TT_KEYPHRASE);
			if ( sStart ~= nil ) then
				sStart = sStart + NuNC.NUN_TT_KEYPHRASE_LEN;
				sStop = string.find(srchText, NuNC.NUN_TT_END, sStart);
				if ( sStop == nil ) then
					sStop = sStart + ttLen - 1;
				else
					sStop = sStop - 1;
					local sDiff = sStop - sStart;
					if ( ( sDiff > ttLen ) or ( sDiff < 0 ) ) then
						sStop = sStart + ttLen - 1;
						NuN_trunc = true;
					end
				end
				tipText = string.sub(srchText, sStart, sStop);
			else
				if ( string.len(srchText) > ttLen ) then
					NuN_trunc = true;
				end
				tipText = string.sub(srchText, 1, ttLen);
			end
			if ( string.len(tipText) > ttLLen ) then
				finalTipText, txtLines = NuNF.NuN_ParseTT(tipText, ttLLen);
			else
				finalTipText = tipText;
				txtLines = 1;
			end
			if ( NuN_trunc == true ) then
				finalTipText = finalTipText..NuNC.NUN_TT_ETC;
			end
			nunTT:AddLine(finalTipText, 0, 1, 0);
			lineCount = lineCount + txtLines;
		end

		local gttLines = GameTooltip:NumLines();
		local ttLinesDiff = lineCount - gttLines;
		if ( ttLinesDiff > NuNC.NUN_TT_LINES_TRIGGER ) then
			local scaleUp = math.floor( 4 * (NuNSettings[pKey].tScale - 1) );
			NuN_TT_Y_Offset = ( ( ttLinesDiff - NuNC.NUN_TT_LINES_TRIGGER ) * ( NuNC.NUN_TT_Y_SHIFT + scaleUp ) );
			NuN_TT_Y_Offset = math.floor( NuN_TT_Y_Offset );
		end
	end
end

-- NotesUNeed allows options to control how long tooltip lines are, and how long they should be in total
function NuNF.NuN_ParseTT(txtIn, fragLen)
	local p1 = 0;
	local p2 = 0;
	local txtOut = "";
	local txtTmp = "";
	local xtraLines = "";
	local parsedLines = 1;

	while ( true ) do
		p2 = string.find(txtIn, "\n", ( p1 + 1 ) );
		if ( p2 == nil ) then
			break;
		end
		txtTmp = string.sub(txtIn, ( p1 + 1 ), p2);
		txtTmpL = string.len(txtTmp);
		if ( txtTmpL > ( fragLen + 10 ) ) then
			txtTmp, xtraLines = NuNF.NuN_Fragment(txtTmp, fragLen);
		else
			xtraLines = 1;
		end
		p1 = p2;
		parsedLines = parsedLines + xtraLines;
		txtOut = txtOut..txtTmp;
	end
	txtTmp = string.sub(txtIn, ( p1 + 1 ) );
	txtTmpL = string.len(txtTmp);
	if ( txtTmpL > fragLen ) then
		txtTmp, xtraLines = NuNF.NuN_Fragment(txtTmp, fragLen);
	else
		xtraLines = 1;
	end
	parsedLines = parsedLines + xtraLines;
	txtOut = txtOut..txtTmp;

	return txtOut, parsedLines;
end

-- Break up text in to lines no longer than that specified by the NuN Tooltip line length option
function NuNF.NuN_Fragment(txtWhole, fragLen)
	local p1 = 0;
	local p2 = 0;
	local lst = 0;
	local txtFrags = "";
	local count = 1;

	while ( true ) do
		p2 = string.find(txtWhole, " ", ( p1 + 1 ) )
		if ( p2 == nil ) then
			break
		end
		if ( p2 > ( lst + fragLen ) ) then
			lst = p1;
			txtFrags = txtFrags.."\n";
			count = count + 1;
		end
		txtFrags = txtFrags..string.sub(txtWhole, ( p1 + 1 ), p2);
		p1 = p2;
	end
	txtFrags = txtFrags..string.sub(txtWhole, ( p1 + 1 ) );

	return txtFrags, count;
end

function NuNF.NuN_HordeSetup()
	NuNRaceDropDown = NuNHRaceDropDown;
	NuNClassDropDown = NuNHClassDropDown;
	NuNHRankDropDown = NuNHHRankDropDown;
	NuNARaceDropDown:Hide();
	NuNHRaceDropDown:Show();
	NuNAClassDropDown:Hide();
	NuNHClassDropDown:Show();
	NuNAHRankDropDown:Hide();
	NuNHHRankDropDown:Show();
	Classes = NUN_HCLASSES;
	Races = NUN_HRACES;
	Ranks = NUN_HRANKS;
	NuNAFlag:Hide();
	NuNHFlag:Show();
end

function NuNF.NuN_AllianceSetup()
	NuNRaceDropDown = NuNARaceDropDown;
	NuNClassDropDown = NuNAClassDropDown;
	NuNHRankDropDown = NuNAHRankDropDown;
	NuNHRaceDropDown:Hide();
	NuNARaceDropDown:Show();
	NuNHClassDropDown:Hide();
	NuNAClassDropDown:Show();
	NuNHHRankDropDown:Hide();
	NuNAHRankDropDown:Show();
	Classes = NUN_ACLASSES;
	Races = NUN_ARACES;
	Ranks = NUN_ARANKS;
	NuNHFlag:Hide();
	NuNAFlag:Show();
end

function NuNF.NuN_GetSimpleName(cmplxName)
	local smplName, posB, posE;

	posB = string.find(cmplxName, "|h");
	posE = string.find(cmplxName, "]|h");
	if ( posB ~= nil ) and ( posE ~= nil ) and ( posB < posE ) then
		smplName = string.sub(cmplxName, (posB + 3), (posE - 1));
		return smplName
	else
		return nil;
	end
end


function NuNF.NuN_GNoteExists(tstNote, simpleCheck)
	local cmplxName;

	if ( ( NuNDataRNotes[tstNote] ) or ( NuNDataANotes[tstNote] ) ) then
		if ( not simpleCheck ) then
			c_note = tstNote;
		end
		return true;

	elseif ( NuNData[itmIndex][tstNote] ) then
		cmplxName = NuNData[itmIndex][tstNote];
		if ( ( NuNDataRNotes[cmplxName] ) or ( NuNDataANotes[cmplxName] ) ) then
			if ( not simpleCheck ) then
				c_note = cmplxName;
			end
			return true;
		end
	end

	return false;
end

function NuNF.NuN_BuildQuestText()
	local numQuestRewards, numQuestChoices, numQuestSpellRewards;
	local QuestRewardMoney, QuestRequiredMoney;
	local qText = "\n";
	local obj, objTxt, objType, itm, itmTxt;
	local gold, silver, copper, moneyTxt;
	local tmpQText1 = "";
	local tmpQText2 = "";
	local questItem = "QuestLogItem";
	local error = false;

	numQuestRewards = GetNumQuestLogRewards();
	numQuestChoices = GetNumQuestLogChoices();
	if ( GetQuestLogRewardSpell() ) then
		numQuestSpellRewards = 1;
	end
	QuestRewardMoney = GetQuestLogRewardMoney();
	QuestRequiredMoney = GetQuestLogRequiredMoney();

	tmpQText1, tmpQText2 = GetQuestLogQuestText();
	qText = tmpQText2.."\n\n";

	if ( GetQuestLogTimeLeft() ) then
		qText = qText.."\nTimed Quest\n";
	end

	if ( QuestRequiredMoney ) and ( QuestRequiredMoney > 0 ) then
		if ( QuestRequiredMoney > 9999 ) then
			gold = ( QuestRequiredMoney / 10000 );
			gold = string.format("%d", gold);
			QuestRequiredMoney = QuestRequiredMoney - ( gold * 10000 );
		else
			gold = 0;
		end
		if ( QuestRequiredMoney > 99 ) then
			silver = ( QuestRequiredMoney / 100 );
			silver = string.format("%d", silver);
			QuestRequiredMoney = QuestRequiredMoney - ( silver * 100 );
		else
			silver = 0;
		end
		copper = QuestRequiredMoney;
		QuestRequiredMoneyTxt = string.format("\n%dg %ds %dc", gold, silver, copper);
		qText = qText..QuestRequiredMoneyTxt.."\n\n";
	end

	qText = qText.."\n\n"..tmpQText1.."\n";

	if ( ( QuestRewardMoney ) and ( QuestRewardMoney > 0 ) ) or ( numQuestRewards > 0 ) then
		qText = qText.."\n".. NuNC.NUN_REWARDS .."\n";
	end

	if ( QuestRewardMoney ) and ( QuestRewardMoney > 0 ) then
		QuestRewardMoneyTxt = NuN_BuildMoneyString(QuestRewardMoney);
		qText = qText..QuestRewardMoneyTxt.."\n";
	end

	for i=1, numQuestRewards, 1 do
		bttn = getglobal("QuestLogItem"..i + numQuestChoices);
		if ( bttn.type ) then
			local link = GetQuestLogItemLink(bttn.type, bttn:GetID());
			if ( link ) then
				qText = qText..link.."\n";
			else
				link = GetQuestLogItemLink(bttn.type, ( i + numQuestChoices ) );
				if ( link ) then
					qText = qText..link.."\n";
				else
					error = true;
					qText = NUN_SLOWSERVER.." : NuN Err03";
					return qText, error;
				end
			end
		end
	end

	if ( numQuestChoices > 1 ) then
		qText = qText.."\n".. NuNC.NUN_CHOICES .."\n";
	end

	for i=1, numQuestChoices, 1 do
		bttn = getglobal("QuestLogItem"..i);
		if ( bttn.type ) then
			local link = GetQuestLogItemLink(bttn.type, bttn:GetID());
			if ( link ) then
				if ( i > 1 ) then
					qText = qText.." / "..link;
				else
					qText = qText..link;
				end
			else
				link = GetQuestLogItemLink(bttn.type, i);
				if ( link ) then
					if ( i > 1 ) then
						qText = qText.." / "..link;
					else
						qText = qText..link;
					end
				else
					error = true;
					qText = NUN_SLOWSERVER.." : NuN Err03";
					return qText, error;
				end
			end
		end
	end

	if ( qText ) then
		qText = NuNF.NuN_CleanQuestText(qText);
		if ( not qText ) then
			qText = "";
		end
	end

	return qText, error;
end

function NuNF.NuN_CheckQuestList(findName)
	local qTitle, qLevel, qTag, qGroup, qHeader, qCollapsed, qComplete;
	local foundIndex = -1;
	local rLevel, rTag, rComplete;

	NuNQuestLog = {};

	for i = 1, GetNumQuestLogEntries(), 1 do
		qTitle, qLevel, qTag, qGroup, qHeader, qCollapsed, qComplete = GetQuestLogTitle(i);
		if ( ( qTitle ) and ( not qHeader ) ) then
			NuNQuestLog[qTitle] = 1;
			if ( ( findName ) and ( findName == qTitle ) ) then
				foundIndex = i;
				rLevel = qLevel;
				rTag = qTag;
				rComplete = qComplete;
			end
		end
	end

	return foundIndex, rLevel, rTag, rComplete;
end

function NuNF.NuN_UpdateQuestNotes(qEvent)
	local quest, qLevel, qTag, qGroup, qHeader, qCollapsed, qComplete;

	local previousQ = GetQuestLogSelection();

	qTriggs = 0;

	if ( pFaction ) then
		for qI=1, GetNumQuestLogEntries(), 1 do
			quest, qLevel, qTag, qGroup, qHeader, qCollapsed, qComplete = GetQuestLogTitle(qI);
			if ( ( quest ) and ( not qHeader ) ) then
				NuNF.NuN_ProcessQuest(quest, qLevel, qTag, qHeader, qCollapsed, qComplete, qI, qEvent);
			end
		end
	end

	if ( qTriggs > 2 ) then
		timeSinceLastUpdate = 0;
		NuN_State.NuN_QuestsUpdating = true;
	end

	if ( previousQ > 0 ) then
		QuestLog_SetSelection(previousQ);
	end
end

function NuNF.NuN_ProcessQuest(quest, qLevel, qTag, qHeader, qCollapsed, qComplete, qI, qEvent)
	local saveLvl = nil;
	local qText;
	local location = NuNF.NuN_GetLoc();
	local pNuNQuestHistory = NuNData[pKey].QuestHistory[pName];
	
	local l_c_note = c_note;
	local l_g_text = g_text;
	local l_c_name = c_name;

	if ( ( pNuNQuestHistory[quest] ) and ( pNuNQuestHistory[quest].abandoned ) ) then
		pNuNQuestHistory[quest].abandoned = nil;
		return;
	end

	QuestLog_SetSelection(qI);

	local qChar = NuN_CheckTarget();
	if ( qChar == "N" ) then
		qChar = c_note;
	else
		qChar = "";
	end
	if ( ( not pNuNQuestHistory[quest] ) and ( NuNSettings[pKey].autoQ ) ) then
		pNuNQuestHistory[quest] = {};
		pNuNQuestHistory[quest].sortDate = tostring(date("%Y%m%d%H%M%S"))..":"..qI;
		pNuNQuestHistory[quest].pLevel = UnitLevel("player");
		local qTxt = NuNC.NUN_CREATED.."   "..qChar.."\n    "..NuNF.NuN_GetDateStamp().."\n    "..location.."\n";
		pNuNQuestHistory[quest].txt = NuNF.NuN_SetSaveText(qTxt);
		qTriggs = qTriggs + 1;
	end

	local chk = NuNF.NuN_CleanQuestText( GetQuestLogQuestText() );
	if ( qLevel == nil ) then
		qLevel = "--";
	end
	if ( qTag == nil ) then
		qTag = "";
	end
	if ( qChar ~= "" ) then
		qChar = qChar.."   "..NuN_LocStrip(location);
	end
	qText = "\n"..quest.."     "..NUN_QLVL..qLevel.."     "..qTag.."\n"..qChar.."\n\n"..NuNF.NuN_BuildQuestText().."\n";

	if ( chk ) and ( not string.find(chk, UNKNOWN) ) then
		local testComplete = nil;
		if ( ( pNuNQuestHistory[quest] ) and ( pNuNQuestHistory[quest].complete ) ) then
			testComplete = NuNF.NuN_GetDisplayText(pNuNQuestHistory[quest].complete);
		end
		if ( ( qComplete ) and ( pNuNQuestHistory[quest] ) and ( ( not testComplete ) or ( ( testComplete ~= chk ) and ( string.find(qText, chk) ) ) ) ) then
			pNuNQuestHistory[quest].complete = NuNF.NuN_SetSaveText(chk);
			local qTxt = NuNF.NuN_GetDisplayText( pNuNQuestHistory[quest].txt );
			qTxt = qTxt .. "\n\n".. NuNC.NUN_COMPLETE .."\n    "..NuNF.NuN_GetDateStamp().."\n    "..location.."\n";
			pNuNQuestHistory[quest].txt = NuNF.NuN_SetSaveText(qTxt);
		end
		if ( NuNDataANotes[quest] ) then
			c_note = quest;
			g_text = NuNF.NuN_GetGText(c_note);
			if ( ( not string.find( g_text, chk) ) and ( string.find(qText, chk) ) ) then
				if ( ( NuNGNoteFrame:IsVisible() ) and ( NUN_NOTETYPES[NuNGNoteFrame.type].Command == "QST" ) ) then
					NuNGNoteFrame:Hide();
				end
				g_text = g_text.."\n\n".."--------------".."\n\n"..qText;
				NuNF.NuN_SetGText("Account");
			end
		elseif ( NuNDataRNotes[quest] ) then
			c_note = quest;
			g_text = NuNF.NuN_GetGText(c_note);
			if ( ( not string.find( g_text, chk ) ) and ( string.find(qText, chk) ) ) then
				if ( ( NuNGNoteFrame:IsVisible() ) and ( NUN_NOTETYPES[NuNGNoteFrame.type].Command == "QST" ) ) then
					NuNGNoteFrame:Hide();
				end
				g_text = g_text.."\n\n".."--------------".."\n\n"..qText;
				NuNF.NuN_SetGText("Realm");
			end
		elseif ( ( not NuNDataANotes[quest] ) and ( not NuNDataRNotes[quest] ) and ( NuNSettings[pKey].autoQ ) ) then
			if ( NuNSettings[pKey].dLevel ) then
				NuNDataANotes[quest] = {};
				NuNDataANotes[quest].type = 5;
				saveLvl = "Account";
			else
				NuNDataRNotes[quest] = {};
				NuNDataRNotes[quest].type = 5;
				saveLvl = "Realm";
			end
			c_note = quest;
			g_text = qText;
			NuNF.NuN_SetGText(saveLvl);
			if ( ( qChar ~= "" ) and ( NuNSettings[pKey].autoMapNotes ) and ( qEvent == "Accepted" ) ) then
--				NuN_MapNote("Target", NUN_QUEST_GIVER, "", 9);
			end
		end
	end

	c_note = l_c_note;
	g_text = l_g_text;
	c_name = l_c_name;
end

function NuNF.NuN_InitialiseSavedVariables()
	local index, value;

	pKey = GetCVar("realmName");

	if ( not NuNData[pKey] ) then
		NuNData[pKey] = {};
		NuNSettings[pKey] = {};
		NuNSettings[pKey].toolTips = "1";
		NuNSettings[pKey].pScale = 1.00;
		NuNSettings[pKey].tScale = 1.00;
		NuNSettings[pKey].mScale = 1.00;
		NuNSettings[pKey].ttLen = NuNC.NUN_TT_MAX;
		NuNSettings[pKey].ttLLen = NuNC.NUN_TT_LEN;
		NuNData[pKey][Notes] = {};
		NuNSettings[pKey].dLevel = "1";
	end

	if ( not NuNSettings ) then
		NuNSettings = {};
	end

	if ( not NuNSettings[pKey] ) then
		NuNSettings[pKey] = {};
		NuNSettings[pKey].toolTips = "1";
		NuNSettings[pKey].pScale = 1.00;
		NuNSettings[pKey].tScale = 1.00;
		NuNSettings[pKey].mScale = 1.00;
		NuNSettings[pKey].ttLen = NuNC.NUN_TT_MAX;
		NuNSettings[pKey].ttLLen = NuNC.NUN_TT_LEN;
		NuNSettings[pKey].dLevel = "1";
	end

	if ( not NuNSettings.Version ) then
		for index, value in pairs(NuNSettings) do
			if ( index ~= "Version" ) then
				NuNSettings[index].toolTips = "1";
				NuNSettings[index].pScale = 1.00;
				NuNSettings[index].tScale = 1.00;
				NuNSettings[index].mScale = 1.00;
				NuNSettings[index].ttLen = NuNC.NUN_TT_MAX;
				NuNSettings[index].ttLLen = NuNC.NUN_TT_LEN;
				NuNSettings[pKey].dLevel = "1";
			end
		end
		NuNSettings.Version = NUN_VERSION;
		NuN_DataFix1();
	end

	if ( NuNSettings.Version < "2.51" ) then
		for index, value in pairs(NuNSettings) do
			if ( index ~= "Version" ) then
				NuNSettings[index].mScale = 1.00;
			end
		end
		NuN_DataFix1();
		NuN_ResetFriendlyData(true, nil);
	elseif ( NuNSettings.Version < "3.00" ) then
		for index, value in pairs(NuNSettings) do
			if ( index ~= "Version" ) then
				NuNSettings[index].mScale = 1.00;
			end
		end
		NuN_DataFix1();
		NuN_ResetFriendlyData(true, nil);
	elseif ( NuNSettings.Version < "4.25" ) then
		NuN_DataFix1();
		NuN_ResetFriendlyData(true, nil);
	elseif ( NuNSettings.Version < "5.00" ) then
		NuN_ResetFriendlyData(true, nil);
	end

	if ( NuNSettings.Version < NUN_VERSION ) then
		NuNSettings.Version = NUN_VERSION;
	end

	if ( not NuNData[itmIndex] ) then
		NuNData[itmIndex] = {};
	end

	if ( not NuNData[Notes] ) then
		NuNData[Notes] = {};
	end

	if ( not NuNSettings[pKey].gNotFriends ) then
		NuNSettings[pKey].gNotFriends = {};
	end

	if ( not NuNSettings[pKey].gNotIgnores ) then
		NuNSettings[pKey].gNotIgnores = {};
	end

	if ( NuNSettings[pKey].mapNotesPlayedVersions ) then
		NuNSettings[pKey].mapNotesPlayedVersions = nil;
	end

	if ( not NuNData[pKey].QuestHistory ) then
		NuNData[pKey].QuestHistory = {};
	end

	if ( not NuNData[pKey].QuestHistory[pName] ) then
		NuNData[pKey].QuestHistory[pName] = {};
	end

	if ( not NuNData[mrgIndex] ) then
		NuNData[mrgIndex] = {};
	end

	if ( not NuNData.dbg ) then
		NuNData.dbg = {};
	end

	if ( ( not NuNSettings[pKey].modifier ) or ( NuNSettings[pKey].modifier == "1" ) ) then
		NuNSettings[pKey].modifier = "on";
	end

	if ( NuNSettings[pKey].delay ) then
		NuN_DTrans.tDelay = NuNSettings[pKey].delay;
	end

	if ( not NuNSettings[pKey].cc1 ) then
		NuNSettings[pKey].cc1 = NuNC.NUN_CPRESETS[1];
	end
	if ( not NuNSettings[pKey].gc1 ) then
		NuNSettings[pKey].gc1 = NuNC.NUN_CPRESETS[1];
	end
	if ( not NuNSettings[pKey].cc2 ) then
		NuNSettings[pKey].cc2 = NuNC.NUN_CPRESETS[2];
	end
	if ( not NuNSettings[pKey].gc2 ) then
		NuNSettings[pKey].gc2 = NuNC.NUN_CPRESETS[2];
	end
	if ( not NuNSettings[pKey].cc3 ) then
		NuNSettings[pKey].cc3 = NuNC.NUN_CPRESETS[3];
	end
	if ( not NuNSettings[pKey].gc3 ) then
		NuNSettings[pKey].gc3 = NuNC.NUN_CPRESETS[3];
	end
	if ( not NuNSettings[pKey].cc4 ) then
		NuNSettings[pKey].cc4 = NuNC.NUN_CPRESETS[4];
	end
	if ( not NuNSettings[pKey].gc4 ) then
		NuNSettings[pKey].gc4 = NuNC.NUN_CPRESETS[4];
	end
	if ( not NuNSettings[pKey].cc5 ) then
		NuNSettings[pKey].cc5 = NuNC.NUN_CPRESETS[5];
	end
	if ( not NuNSettings[pKey].gc5 ) then
		NuNSettings[pKey].gc5 = NuNC.NUN_CPRESETS[5];
	end

	-- 5.60 Database shortcuts
	NuNDataPlayers = NuNData[pKey];
	NuNDataANotes = NuNData[Notes];
	NuNDataRNotes = NuNData[pKey][Notes];
	qhName = pName;
	qhKey = pKey;
	qhI = 1;
	qhT = pName;
	NuNQuestHistory = NuNData[qhKey].QuestHistory[qhName];
end

-- ele1 & ele2 are the note names as specified in the browser frame, which are all prefixed with a 1 char code for the type of note
function NuNF.NuN_SortQuestHistory(ele1, ele2)
	ele1 = string.sub(ele1, 2);
	ele2 = string.sub(ele2, 2);
	if ( NuNQuestHistory[ele1].sortDate > NuNQuestHistory[ele2].sortDate ) then
		return true;
	end

	return false;
end

-- 5.60
function NuNF.NuN_SortAltArray(ele1, ele2)
	if ( ele1.sortKey > ele2.sortKey ) then
		return true;
	end
	return false;
end

function NuNF.NuN_CleanQuestText(dirtyText)
	if ( dirtyText ) then
		local cleanText = string.gsub(dirtyText, pName, "$N");

		local class = UnitClass("player");
		cleanText = string.gsub(cleanText, class, "$C");
		cleanText = string.gsub(cleanText, strlower(class), "$C");

		return cleanText;
	end
end

function NuNF.NuN_CreateLevelUpNote(levelUpName, newLevel, hp, mana, str, agi, sta, int, spr)
	if ( ( levelUpName ) and ( levelUpName ~= "" ) ) then
		local tmp_c_note = c_note;
		local tmp_g_text = g_text;

		c_note = levelUpName;
		NuNDataRNotes[c_note] = {};
		NuNDataRNotes[c_note].type = 1;
		g_text = NUN_LVL_REACHED.. newLevel .." : ";
		g_text = g_text.."\n    "..NuNF.NuN_GetDateStamp();
		g_text = g_text.."\n    "..NuNF.NuN_GetLoc();
		g_text = g_text.."\n\n    "..NUN_HIT_POINTS.." : "..hp;
		g_text = g_text.."\n    "..NUN_MANA.." : "..mana;
		g_text = g_text.."\n    "..NUN_STRENGTH.." : "..str;
		g_text = g_text.."\n    "..NUN_AGILITY.." : "..agi;
		g_text = g_text.."\n    "..NUN_STAMINA.." : "..sta;
		g_text = g_text.."\n    "..NUN_INTELLECT.." : "..int;
		g_text = g_text.."\n    "..NUN_SPIRIT.." : "..spr;
		NuNF.NuN_SetGText("Realm");

		c_note = tmp_c_note;
		g_text = tmp_g_text;
	end
end

function NuNF.NuN_LocaliseDateStamp(dateStamp)
	if ( ( GetLocale() ~= "enUS" ) and ( GetLocale() ~= "enGB" ) and ( NUN_DAY_LIST ) and ( NUN_MONTH_LIST ) ) then
		dateStamp = string.gsub(dateStamp, "Monday", NUN_DAY_LIST[1]);
		dateStamp = string.gsub(dateStamp, "Tuesday", NUN_DAY_LIST[2]);
		dateStamp = string.gsub(dateStamp, "Wednesday", NUN_DAY_LIST[3]);
		dateStamp = string.gsub(dateStamp, "Thursday", NUN_DAY_LIST[4]);
		dateStamp = string.gsub(dateStamp, "Friday", NUN_DAY_LIST[5]);
		dateStamp = string.gsub(dateStamp, "Saturday", NUN_DAY_LIST[6]);
		dateStamp = string.gsub(dateStamp, "Sunday", NUN_DAY_LIST[7]);
		dateStamp = string.gsub(dateStamp, "January", NUN_MONTH_LIST[1]);
		dateStamp = string.gsub(dateStamp, "February", NUN_MONTH_LIST[2]);
		dateStamp = string.gsub(dateStamp, "March", NUN_MONTH_LIST[3]);
		dateStamp = string.gsub(dateStamp, "April", NUN_MONTH_LIST[4]);
		dateStamp = string.gsub(dateStamp, "May", NUN_MONTH_LIST[5]);
		dateStamp = string.gsub(dateStamp, "June", NUN_MONTH_LIST[6]);
		dateStamp = string.gsub(dateStamp, "July", NUN_MONTH_LIST[7]);
		dateStamp = string.gsub(dateStamp, "August", NUN_MONTH_LIST[8]);
		dateStamp = string.gsub(dateStamp, "September", NUN_MONTH_LIST[9]);
		dateStamp = string.gsub(dateStamp, "October", NUN_MONTH_LIST[10]);
		dateStamp = string.gsub(dateStamp, "November", NUN_MONTH_LIST[11]);
		dateStamp = string.gsub(dateStamp, "December", NUN_MONTH_LIST[12]);
	end

	return dateStamp;
end

function NuNF.NuN_QuestLogButtons()
	local bIndex = 7;			-- Minimum of 6 already created
	local qButton = getglobal("QuestLogTitle" .. bIndex);
	while ( qButton ) do
		local newButton = getglobal("NuN_QuestNotesButton"..bIndex);
		if ( newButton ) then
			return;				-- buttons already created
		else
			newButton = CreateFrame("Button", "NuN_QuestNotesButton"..bIndex, qButton, "NuN_NoteButtonTemplate4");
			if ( newButton ) then
				newButton:SetID(bIndex);
				newButton:SetPoint("RIGHT", qButton, "LEFT", 20, -1);
				newButton:Show();
				NuNC.NUN_QUESTLOG_BUTTONS = NuNC.NUN_QUESTLOG_BUTTONS + 1;
				bIndex = bIndex + 1;
				qButton = getglobal("QuestLogTitle" .. bIndex);
			else
				return;			-- unexpected error really ... but no point trying to create more
			end
		end
	end
end

function NuNF.NuN_DtoH(r, g, b)
	r = string.format("%.2X", (r * 255));
	g = string.format("%.2X", (g * 255));
	b = string.format("%.2X", (b * 255));

	return ("|c00" .. r .. g .. b);
end

function NuNF.NuN_HtoD(h)
	local start = 5;
	
	if ( string.len(h) == 6 ) then
		start = 1;
	end

	local r = string.lower( string.sub(h, start, start+1) );
	local g = string.lower( string.sub(h, start+2, start+3) );
	local b = string.lower( string.sub(h, start+4, start+5) );

	r = ( NuNC.hArray[ string.sub(r, 1, 1) ] * 16 + NuNC.hArray[ string.sub(r, 2, 2) ] ) / 255;
	g = ( NuNC.hArray[ string.sub(g, 1, 1) ] * 16 + NuNC.hArray[ string.sub(g, 2, 2) ] ) / 255;
	b = ( NuNC.hArray[ string.sub(b, 1, 1) ] * 16 + NuNC.hArray[ string.sub(b, 2, 2) ] ) / 255;

	return r, g, b;
end


-- return text that has been highlighted in the Edit Boxes using the mouse
function NuNF.NuN_GetSelectedText(eBox)
	local tLen, tS, tE;

	if ( ( eBox.cPosStart ) and ( eBox.cPosEnd ) ) then
		tLen = math.abs( eBox.cPosStart - eBox.cPosEnd );
	end

	if ( ( tLen ) and ( tLen > 0 ) ) then
		if ( eBox.cPosStart < eBox.cPosEnd ) then
			tS = eBox.cPosStart;
			tE = eBox.cPosEnd;
		else
			tS = eBox.cPosEnd;
			tE = eBox.cPosStart;
		end

		local selectedText = eBox:GetText();
		selectedText = string.sub(selectedText, tS+1, tE);

		if ( selectedText ) then
			return selectedText;
		end
	end

	return nil;
end

function NuNF.CapitaliseName(parm1)
	local contactName, newInitial, remainder;

	local initial = string.sub(parm1, 1, 1);
	local t2 = string.sub(parm1, 2, 2);
	local remainder = string.sub(parm1,2);
	remainder = string.lower( remainder );

	local t1 = string.byte( string.sub(initial, 1, 1) );
	if ( t1 == 195 ) then
		if ( t2 ) then
			t2 = string.byte(t2);

			if ( ( t2 ) and ( t2 > 159 ) and ( t2 < 190 ) ) then
				t2 = t2 - 32;
				newInitial = string.char(t1) .. string.char(t2);

			elseif ( ( t2 > 127 ) and ( t2 < 160 ) ) then
				newInitial = string.char(t1) .. string.char(t2);
			end
		end
	end

	if ( newInitial ) then
		contactName = newInitial..remainder;
		initial = newInitial;

	else
		initial = string.upper(initial);
		if ( string.len(initial) > 0 ) then
			contactName = initial..remainder;

		else

			contactName = initial .. remainder;	-- I give up - they should pass capitalised...
			initial = nil;
			remainder = nil;
		end
	end

	return contactName, initial, remainder;
end


local sn = {};
	sn.Choice = nil;
	sn.Name = "";
	sn.Body = "";
	sn.CancelAll = nil;
	sn.totCount = 0;
	sn.Count = 0;
	sn.Imported, sn.Ignored, sn.Exists = 0, 0, 0;
	sn.Array = {};
	sn.Waiting = nil;
-- NotesUNeed Choose Note Importing type for Social Notes
StaticPopupDialogs["NUN_CHOOSE_SN_IMPORT"] = {
	text = TEXT(NUN_SN_IMPORT),
	button1 = TEXT(NUN_SN_IMPORT_CHOICE),
	button2 = TEXT(CANCEL),
	OnShow = function()
		sn.Waiting = true;
		sn.Choice = nil;
		getglobal(this:GetName().."Text"):SetText( NUN_SN_IMPORT.." "..sn.Count.."/"..sn.totCount.." : "..sn.Name.." ?" );
	end,
	OnAccept = function()
		if ( ( IsControlKeyDown() ) and ( not IsAltKeyDown() ) ) then
			sn.Choice = "Alliance";
			return nil;
		elseif ( ( IsAltKeyDown() ) and ( not IsControlKeyDown() ) ) then
			sn.Choice = "Horde";
			return nil;
		else
			return true;
		end
	end,
	OnCancel = function()
		if ( IsShiftKeyDown() ) then
			sn.CancelAll = true;
		end
	end,
	OnHide = function()
		if ( sn.Choice ) then
			NuNDataPlayers[sn.Name] = {};
			NuNDataPlayers[sn.Name].faction = sn.Choice;
			local tmpTxt = c_text;
			c_text = sn.Body .. "\n" .. NUN_SN_FLAG;
			NuNF.NuN_SetCText(sn.Name);
			c_text = tmpTxt;
			sn.Imported = sn.Imported + 1;
		else
			sn.Ignored = sn.Ignored + 1;
		end
		sn.Waiting = nil;
	end,
	timeout = 0,
	hideOnEscape = 1,
};

-- Duplicate Record
StaticPopupDialogs["NUN_DUPLICATE_RECORD"] = {
	text = TEXT(NUN_DUPLICATE),
	button1 = TEXT(NUN_REPLACE),
	button2 = TEXT(CANCEL),
	showAlert = 1,
	timeout = 0,
	OnAccept = function()
		if ( ( NuN_Receiving.type == "Contact" ) and ( NuNFrame:IsVisible() ) ) then
			if ( IsAltKeyDown() ) then
				local oriText = NuNF.NuN_GetCText(c_name);
				local newText = NuNText:GetText();
				if ( not oriText ) then oriText = ""; end
				if ( not newText ) then newText = ""; end
				NuNText:SetText( oriText.."\n\n"..newText );
			end
			NuN_Delete(true);
			NuN_WriteNote();
		elseif ( NuNGNoteFrame:IsVisible() ) then
			if ( IsAltKeyDown() ) then
				local oriText = NuNF.NuN_GetGText(c_note);
				local newText = NuNGNoteTextScroll:GetText();
				if ( not oriText ) then oriText = ""; end
				if ( not newText ) then newText = ""; end
				NuNGNoteTextScroll:SetText(oriText.."\n\n"..newText);
			end
			NuNGNote_Delete(true);
			NuNGNote_WriteNote();
		end
	end,
	OnHide = function()
		if ( ( NuN_Receiving.type == "General" ) and ( NuNGNoteFrame:IsVisible() ) ) then
			NuNGNoteFrame:Hide();
		elseif ( ( NuN_Receiving.type == "Contact" ) and ( NuNFrame:IsVisible() ) ) then
			NuNFrame:Hide();
		end
		NuN_Receiving = {};
		receiptDeadline = defaultReceiptDeadline;
		NuN_uCount = 999;
		NuN_tCount = 999;
		receiptPending = nil;
	end,
	hideOnEscape = 1,
};










-- DropDownBox Initialisers and OnClick functions Localised in-line
-- Most of the colouring code is also localised in-line


-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------
-- Mod Functions --
-----------------------

function NuN_OnLoad()
	local continentID, zoneID, continent, zone;
	local c_zones = {};

	-- Apparently no Taint issues with the following, but haven't seen any errors caused, and I DEFINITELY want to be able to completely
	-- intercept some messages BEFORE they reach the Player
	NuNHooks.NuNOri_ChatFrame_MessageEventHandler = ChatFrame_MessageEventHandler;
	ChatFrame_MessageEventHandler = NuNNew_ChatFrame_MessageEventHandler;
	-- Risking an unsecure hook, to allow disambiguation from other AddOn Hooks
	NuNHooks.NuNOri_ContainerFrameItemButton_OnModifiedClick = ContainerFrameItemButton_OnModifiedClick;
	ContainerFrameItemButton_OnModifiedClick = NuNNew_ContainerFrameItemButton_OnModifiedClick;

	hooksecurefunc("FriendsList_Update", NuNNew_FriendsList_Update);
	hooksecurefunc("IgnoreList_Update", NuNNew_IgnoreList_Update);
	hooksecurefunc("GuildStatus_Update", NuNNew_GuildStatus_Update);
	hooksecurefunc("WhoList_Update", NuNNew_WhoList_Update);
	hooksecurefunc("QuestLog_Update", NuNNew_QuestLog_Update);
	hooksecurefunc("LFMFrame_Update", NuNNew_LFMFrame_Update);
	hooksecurefunc("AbandonQuest", NuNNew_AbandonQuest);
	hooksecurefunc("QuestDetailAcceptButton_OnClick", NuNNew_QuestDetailAcceptButton_OnClick);
	hooksecurefunc("QuestRewardCompleteButton_OnClick", NuNNew_QuestRewardCompleteButton_OnClick);
	hooksecurefunc("FriendsFrameFriendButton_OnClick", NuNNew_FriendsFrameFriendButton_OnClick);
	hooksecurefunc("FriendsFrameIgnoreButton_OnClick", NuNNew_FriendsFrameIgnoreButton_OnClick);
	hooksecurefunc("FriendsFrameGuildStatusButton_OnClick", NuNNew_FriendsFrameGuildStatusButton_OnClick);
	hooksecurefunc("FriendsFrameWhoButton_OnClick", NuNNew_FriendsFrameWhoButton_OnClick);
	hooksecurefunc("SetItemRef", NuNNew_SetItemRef);
	hooksecurefunc("PaperDollItemSlotButton_OnModifiedClick", NuNNew_PaperDollItemSlotButton_OnModifiedClick);
	hooksecurefunc("ToggleWorldMap", NuNNew_ToggleWorldMap);						-- 5.40
--	hooksecurefunc("ContainerFrameItemButton_OnModifiedClick", NuNNew_ContainerFrameItemButton_OnModifiedClick);	-- 5.40	-- 5.60
	hooksecurefunc("QuestWatch_Update", NuN_QuestWatch_Update);
	hooksecurefunc("SetAbandonQuest", NuNNew_SetAbandonQuest);

	-- Well, again supposedly Secure, but haven't had any errors caused by these, and the amount of testing
	-- involved in order to reset them to securehooks has daunted me 2 days before Christmas... ;p
	NuNHooks.NuNOri_AddFriend = AddFriend;
	AddFriend = NuNNew_AddFriend;
	NuNHooks.NuNOri_RemoveFriend = RemoveFriend;
	RemoveFriend = NuNNew_RemoveFriend;
	NuNHooks.NuNOri_AddIgnore = AddIgnore;
	AddIgnore = NuNNew_AddIgnore;
	NuNHooks.NuNOri_DelIgnore = DelIgnore;
	DelIgnore = NuNNew_DelIgnore;
	NuNHooks.NuNOri_AddOrDelIgnore = AddOrDelIgnore;
	AddOrDelIgnore = NuNNew_AddOrDelIgnore;

	this:RegisterEvent("WHO_LIST_UPDATE");			-- 5.60
	this:RegisterEvent("IGNORELIST_UPDATE");
	this:RegisterEvent("FRIENDLIST_UPDATE");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("PLAYER_LEVEL_UP");
	this:RegisterEvent("QUEST_LOG_UPDATE");
	this:RegisterEvent("PARTY_MEMBERS_CHANGED");
	this:RegisterEvent("RAID_ROSTER_UPDATE");
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("GUILD_ROSTER_UPDATE");		-- 5.60
	this:RegisterEvent("ADDON_LOADED");
--  Removed several redundant event checks -- 5.60
	SlashCmdList["NOTEUN"] = function(pList)
		local gap = string.find(pList, " ");

		if ( gap ) then
			switch = string.sub(pList, 1, (gap - 1));
			parm1 = string.sub(pList, (gap + 1));
		else
			switch = pList;
			parm1 = nil;
		end
		NuN_CmdLine(switch, parm1, pList);
	end
	SLASH_NOTEUN1 = "/nun";

	tryI = true;
	pName = UnitName("player");

	NuNF.ClearButtonChanges();

	-- Prepopulate localised continent/zone names for Location Stamping NuNF.NuN_GetLoc()
	c_continents[1] = {};
	c_continents[2] = {};
	c_continents[3] = {};
	for continentID, continent in ipairs{GetMapContinents()} do
		c_zones = {};
		c_continents[continentID].name = continent;
		for zoneID, zone in ipairs{GetMapZones(continentID)} do
			c_zones[zoneID] = zone;
		end
		c_continents[continentID].zones = c_zones;
	end
end
 
function NuN_CmdLine(option, parm1, pList)
	local index;
	local value;
	local initial;
	local remainder;
	local contactName;
	local switch;

	-- Just toggle the Options frame if no parameters passed
	if ( ( option == "" ) or ( option == nil ) ) then
		NuN_Options();
	else
		switch = string.lower(option);

		-- help echoes the slash command list
		if ( ( switch == "-h" ) or ( switch == "-help" ) or ( switch == "?" ) or ( switch == "-?" ) ) then
			DEFAULT_CHAT_FRAME:AddMessage(" ");
			index = 0;
			value = "NUN_HELP_TEXT"..index;
			while( NuNC[value] ) do
				DEFAULT_CHAT_FRAME:AddMessage(NuNC[value]);
				index = index + 1;
				value = "NUN_HELP_TEXT"..index;
			end
			DEFAULT_CHAT_FRAME:AddMessage(" ");

		-- Guild Refresh -- 5.60
		elseif ( switch == "-gr" ) then												-- 5.60
			NuN_GuildRefreshCheckBox_OnClick();										-- 5.60

		elseif ( switch == "-grv" ) then											-- 5.60
			NuN_GRVerboseCheckBox_OnClick();										-- 5.60
			
		-- Toggles the NotesUNeed Help Tooltips & the main NuN Game Tooltip
		elseif ( switch == "-tt" ) then
			NuN_ToggleToolTips();

		-- Create Alliance / Horde Contact Notes without validating Player exists
		elseif  ( ( switch == "-ca" ) or ( switch == "-ch" ) ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
				return;
			end
			contactName, initial, remainder = NuNF.CapitaliseName(parm1);
--			initial = string.upper( string.sub(parm1, 1, 1) );
--			remainder = string.lower( string.sub(parm1,2) );
--			contactName = initial..remainder;
			if ( NuNDataPlayers[contactName] ) then
				if ( NuNFrame:IsVisible() ) then
					NuNEditDetailsFrame:Hide();
					NuNFrame:Hide();
				end
				NuN_ShowSavedNote(contactName);
			else
				NuN_CreateContact(contactName, switch);
			end

		-- Purges the Exported Records file in \SavedVariables; Allowing replacement / appending with another record set.
		elseif ( switch == "-purgeexport" ) then
			NuN_PurgeExport();

		-- Open up the Note Browser Frame with all notes
		elseif ( switch == "-a" ) then
			if ( receiptPending ) then
				return;
			end
			NuN_DisplayAll();

		-- Toggle the 4 Microbuttons Panel
		elseif ( switch == "-micro" ) then
			NuN_ToggleMicroButtons();

		-- Open up a new un-named General Note
		--  OR Open up the General Note with the Passed parameter name
		--  OR Open up a new General Note with the Passed parameter name
		elseif ( switch == "-g" ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "General" ) ) then
				return;
			end
			if ( ( parm1 ~= nil ) and ( parm1 ~= "") ) then
				local exists = NuNF.NuN_GNoteExists(parm1);
				NuNGNoteFrame.fromQuest = nil;
				if ( exists ) then
					NuN_ShowSavedGNote();
				else
					c_note = parm1;
					c_type = NuNGet_CommandID(NUN_NOTETYPES, "   ");
					NuN_ShowTitledGNote("");
				end
			else
				NuN_ShowNewGNote();
			end

		-- Open up your own Player Note if Nothing Targetted
		--  OR Open up / Create a Contact Note if another Player Targetted (Horde OR Alliance)
		--  OR Open up / Create a General Note if a Mob / NPC Targetted
		elseif ( switch == "-t" ) then
			if ( receiptPending ) then
				return;
			end
			NuN_FromTarget(false);

		-- old legacy fix for conversion from German to English								???
		elseif ( ( switch == "->de" ) or ( switch == "->en" ) ) then
			NuN_LangPatch(switch);

		elseif ( switch == "-sendc") then
			NuN_ManualTransmit(nil, "Contact", parm1);
		
		elseif ( switch == "-sendg" ) then
			NuN_ManualTransmit(nil, "General", parm1);
		
		elseif ( switch == "-sendcf" ) then
			NuN_ManualTransmit(true, "Contact", parm1);

		elseif ( switch == "-sendgf" ) then
			NuN_ManualTransmit(true, "General", parm1);

		elseif ( switch == "-delay" ) then
			if ( parm1 ) then
				parm1 = tonumber(parm1);
			end
			if ( not parm1 ) then parm1 = 0.33; end
			local oldDelay = NuN_DTrans.tDelay;
			NuN_DTrans.tDelay = parm1;
			NuNSettings[pKey].delay = NuN_DTrans.tDelay;
			NuN_Message(oldDelay .. " ---> " .. NuN_DTrans.tDelay);

		elseif ( switch == "-restrictwho" ) then
			if ( not NuNSettings[pKey].restrictwho ) then
				NuNSettings[pKey].restrictwho = true;
				NuN_Message("-restrictwho : On");
			else
				NuNSettings[pKey].restrictwho = nil;
				NuN_Message("-restrictwho : Off");
			end

		elseif ( switch == "-alternativewho" ) then
			if ( not NuNSettings[pKey].alternativewho ) then
				NuNSettings[pKey].alternativewho = true;
				NuN_Message("-alternativewho : On");
			else
				NuNSettings[pKey].alternativewho = nil;
				NuN_Message("-alternativewho : Off");
			end

		elseif ( switch == "-importsn" ) then
			NuN_ImportSocialNotes_Start();

		-- Execute the Note as LUA Script
		elseif ( switch == "-x" ) then
			NuN_ExecuteNote(parm1);

		-- Expects parm1 to be a Player name - NuN will stop trying to ignore said player
		elseif ( switch == "-i" ) then
			NuN_ResetPlayerIgnoreStatus(parm1);

		-- Expects parm1 to be a Player name - NuN will stop trying to befriend said player
		elseif ( switch == "-f" ) then
			NuN_ResetPlayerFriendStatus(parm1);

		-- Resets Friend / Ignore lists to current Toons lists
		elseif ( switch == "-resetlists" ) then
			NuN_ResetFriendIgnoreLists();

		-- Try to open up existing Player note with passed parameter name
		--  OR Try to open up existing General note with passed parameter name
		--  OR Create Contact note if passed parameter is name of current target / or a member of Party or Raid
		--  OR bring up the Browser window and search for passed parameter
		else
			if ( receiptPending ) then
				return;
			end
			contactName, initial, remainder = NuNF.CapitaliseName(switch);	-- pass 'switch' NOT 'parm1'
--			initial = string.upper( string.sub(switch, 1, 1) );
--			remainder = string.lower( string.sub(switch,2) );
--			contactName = initial..remainder;
			if ( NuNDataPlayers[contactName] ) then
				if ( NuNFrame:IsVisible() ) then
					NuNEditDetailsFrame:Hide();
					NuNFrame:Hide();
				end
				NuN_ShowSavedNote(contactName);
			elseif ( NuNF.NuN_GNoteExists(pList) ) then
				NuNGNoteFrame.fromQuest = nil;
				NuN_ShowSavedGNote();
			else
				local theUnitID = NuNF.NuN_UnitInfo(true, contactName);
				if ( theUnitID ) then
					NuN_NewContact(theUnitID);
				else
					NuN_SearchForNote("Text", pList);
				end
			end
		end
	end
end


-- NuN does not Target other Players, but will create different kinds of notes based on whether the current target is Self / Player / NPC(including Mobs)
function NuN_FromTarget(autoHide)
	local theUnitID = "target";
	local npcText;

	-- NuN_CheckTarget determines whether the target is : 
	--	Self		"S"
	--	NPC		"N"
	--	Player	"F"	-- I guess I started out thinking "F"riend, but this includes Players of the opposite Faction
	local tstValue = NuN_CheckTarget();

	if ( receiptPending ) then
		return;
	end

	-- <Alt> Clicking on Microbutton re-opens the last opened Contact note
	if ( IsAltKeyDown() ) then
		NuN_LastOpen.type = "Contact";
		NuN_ReOpen();
		return;
	end

	-- <Shift> Clicking on Microbutton allows Note Creation for Target without leaving the NotesUNeed Frame Open (e.g. background Noting of Target)
	if ( IsShiftKeyDown() ) then
		autoHide = true;
	end

	-- if we have targetted a Mob/NPC, then create a General Note
	if ( tstValue == "N" ) then
		NuNGNoteFrame.fromQuest = nil;
		-- If a Note already exists for the Target, then Show it if NOT auto-hiding
		if ( ( NuNDataRNotes[c_note] ) or ( NuNDataANotes[c_note] ) ) then
			if ( autoHide ~= true ) then
				NuN_ShowSavedGNote();
			end
		-- Else Gather Mob / NPC Info for the creation of a new note
		else
			NPCInfo_Proceed = nil;
			NuN_NPCInfo(NuN_NPCCreateNote, autoHide);
		end

	-- else we have targetted a player controlled toon of some kind
	else
		-- if the note already exists, and not auto-hiding, then show it
		if ( NuNDataPlayers[c_name] ) then
			if ( autoHide ~= true ) then
				NuN_ShowSavedNote(c_name);
			end
		-- else create a new Player note for the target, and auto-save and hide it again if necessary.
		else
			NuN_NewContact(theUnitID);
			if ( autoHide == true ) then
				NuN_WriteNote();
				NuNFrame:Hide();
				NuN_Message(c_name..NUN_AUTONOTED);
			end
		end
	end
end

-- Eventually called when NPC Tooltip shows up for current Target
-- The call the NuN_NPCInfo() will now go in to the main routine and fetch info from the tooltip, after which we can hide it again
-- Player shouldn't notice the Tooltip flashing up - or at least I never did
function NuN_NPCCreateNote(autoHide)
	c_type = NuNGet_CommandID(NUN_NOTETYPES, "NPC");
	local npcText = NuN_NPCInfo();
	GameTooltip:ClearLines();
	GameTooltip:Hide();
	NuN_ShowTitledGNote(npcText);
	if ( autoHide == true ) then
		NuNGNote_WriteNote();
		if ( not NuN_ConfirmFrame:IsVisible() ) then
			NuNGNoteFrame:Hide();
			NuN_Message(c_note..NUN_AUTONOTED);
		end
	end
end


-- Return information about the current target
-- If nothing actually targetted, then return a reference to your own Player character
function NuN_CheckTarget()
	if ( UnitExists("target") ) then																	-- 20200
		local chkName = UnitName("target");																-- 20200
		if ( ( UnitPlayerControlled("target") )  and ( UnitIsUnit("player", "target") ) ) then			-- 20200
			c_name = pName;																				-- 20200
			return "S";																					-- 20200
			
		elseif ( ( ( UnitPlayerControlled("target") )  and (not UnitIsUnit("player", "target") ) ) or ( UnitInParty("target") ) or ( UnitInRaid("target") ) )then
			c_name = chkName;
			return "F";

		elseif ( not UnitPlayerControlled("target") ) then
			c_note = chkName;
			return "N";
		end

	else																								-- 20200
		c_name = pName;
		return "S";
	end
end



-- Open up the Note Browser i.e. NuNSearchFrame  (but not necessarily with ALL notes)
--  If <Alt>-Left Click, then open up just General Notes (i.e. no Player Notes)
--  If Right Click, then open up Quest History (for current Toon)
function NuN_DisplayAll(mButton)
	if ( not mButton ) then
		mButton = "LeftButton";
	end

	if ( NuNSearchFrame:IsVisible() ) then
		NuNSearchFrame:Hide();
	else
		-- Commands are all in English; Localisation files associate localised variables with the English commands
		local sTyp = "All";	-- default
		if ( mButton == "LeftButton" ) then
			if ( IsAltKeyDown() ) then
				sTyp = "Notes";
			end
		else
			sTyp = "Quest History";
		end
		NuNSearchFrameBackButton:Disable();
		NuNSearchFrame.backEnabled = nil;
		ddBoxes.ddSearch = NuNGet_CommandID(NUN_SEARCHFOR, sTyp);
		searchType = NUN_SEARCHFOR[ddBoxes.ddSearch].Command;
		NuNOptions_Search();							-- Actually Opens the Note Browser with the appropriate Note Filtering algorithm
	end
end



-- Toggle the Options Frame
function NuN_Options()
	if ( NuNOptionsFrame:IsVisible() ) then
		NuNOptionsFrame:Hide();
	else
		if ( ( MapNotes_OnLoad ) or ( MetaMap_Quicknote ) ) then
			NuN_AutoMapCheckBox:Enable();
			if ( NuNSettings[pKey].autoMapNotes ) then
				NuN_AutoMapCheckBox:SetChecked(1);
			else
				NuN_AutoMapCheckBox:SetChecked(0);
			end
		else
			NuN_AutoMapCheckBox:SetChecked(0);
			NuN_AutoMapCheckBoxLabel:SetText(NUN_NOMAPNOTES);
			NuN_AutoMapCheckBox:Disable();
		end
		if ( NuNFrame:IsVisible() ) then
			NuNEditDetailsFrame:Hide();
			NuNFrame:Hide();
		end
		if ( NuNSearchFrame:IsVisible() ) then
			NuNSearchFrame:Hide();
		end
		if ( NuNGNoteFrame:IsVisible() ) then
			NuNGNoteFrame:Hide();
		end
		UIDropDownMenu_SetSelectedID(NuNOptionsSearchDropDown, 1);
		UIDropDownMenu_SetText(NUN_SEARCHFOR[1].Display, NuNOptionsSearchDropDown);
		ddBoxes.ddSearch = NuNGet_CommandID(NUN_SEARCHFOR, "All");
		if ( NuNSettings[pKey].autoG ) then
			NuNOptionsGuildCheckButton:SetChecked(1);
		else
			NuNOptionsGuildCheckButton:SetChecked(0);
		end
		if ( NuNSettings[pKey].hignores ) then
			NuN_HignoresCheckBox:SetChecked(1);
		else
			NuN_HignoresCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].autoA ) then
			NuNOptionsAddCheckButton:SetChecked(1);
		else
			NuNOptionsAddCheckButton:SetChecked(0);
		end
		if ( NuNSettings[pKey].autoFI ) then
			NuNOptionsAACheckButton:SetChecked(1);
		else
			NuNOptionsAACheckButton:SetChecked(0);
		end
		if ( NuNSettings[pKey].autoS ) then
			NuNOptionsVerboseCheckButton:SetChecked(1);
		else
			NuNOptionsVerboseCheckButton:SetChecked(0);
		end
		if ( NuNSettings[pKey].autoD ) then
			NuNOptionsDeleteCheckButton:SetChecked(1);
		else
			NuNOptionsDeleteCheckButton:SetChecked(0);
		end
		if ( NuNSettings[pKey].autoQ ) then
			NuN_AutoQuestCheckBox:SetChecked(1);
		else
			NuN_AutoQuestCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].autoN ) then
			NuN_AutoNoteCheckBox:SetChecked(1);
		else
			NuN_AutoNoteCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].dLevel ) then
			NuN_DefaultLevelCheckBox:SetChecked(1);
		else
			NuN_DefaultLevelCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].toolTips ) then
			NuN_HelpTTCheckBox:SetChecked(1);
		else
			NuN_HelpTTCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].autoP ) then
			NuN_AutoPartyCheckBox:SetChecked(1);
		else
			NuN_AutoPartyCheckBox:SetChecked(0);
		end
		-- 5.60 Options	-- 5.60 Options	-- 5.60 Options	-- 5.60 Options	-- 5.60 Options	-- 5.60 Options	-- 5.60 Options
		if ( NuNSettings[pKey].autoGuildNotes ) then
			NuN_GuildRefreshCheckBox:SetChecked(1);
		else
			NuN_GuildRefreshCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].autoGRVerbose ) then
			NuN_GRVerboseCheckBox:SetChecked(1);
		else
			NuN_GRVerboseCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].nunFont ) then
			NuN_CustomFontCheckBox:SetChecked(1);
		else
			NuN_CustomFontCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].modifier == "on" ) then
			NuN_ModifierMasterCheckBox:SetChecked(1);
			NuNOptionsModifier:Enable();
			NuNOptions_SetModifierText();
		else
			NuN_ModifierMasterCheckBox:SetChecked(0);
			NuNOptionsModifier:SetText("n/a");
			NuNOptionsModifier:Disable();
		end
		-- 5.60 Options 	-- 5.60 Options	-- 5.60 Options	-- 5.60 Options	-- 5.60 Options	-- 5.60 Options	-- 5.60 Options	-- 5.60 Options
		if ( NuNSettings[pKey].hideMicro ) then
			NuN_MicroCheckBox:SetChecked(0);
		else
			NuN_MicroCheckBox:SetChecked(1);
		end
		if ( NuNSettings[pKey].minOver ) then
			NuN_OverTTCheckBox:SetChecked(1);
		else
			NuN_OverTTCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].chatty ) then
			NuN_ChatTagCheckBox:SetChecked(1);
		else
			NuN_ChatTagCheckBox:SetChecked(0);
		end
		if ( NuNSettings[pKey].bHave ) then
			NuN_BehaveCheckBox:SetChecked(1);
		else
			NuN_BehaveCheckBox:SetChecked(0);
		end

		NuNOptionsTTLengthTextBox:SetText( NuNSettings[pKey].ttLen );
		NuNOptionsTTLineLengthTextBox:SetText( NuNSettings[pKey].ttLLen );
		NuNSearchFrameBackButton:Enable();
		NuNSearchFrame.backEnabled = true;
		NuNOptionsFrame:SetScale(NuNSettings[pKey].pScale);

		NuNOptionsFrame:Show();
	end
end



function NuN_ShowSavedNote(cName)
	if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
		return;
	elseif ( not cName ) then
		return;
	end
	-- reset globals
	c_name = cName;
	c_class = nil;
	c_race = nil;
	c_sex = nil;
	c_prof1 = nil;
	c_prof2 = nil;
	c_arena = nil;
	c_hrank = nil;
	c_guild = nil;
	gRank = nil;
	gRankIndex = nil;
	gNote = nil;
	gOfficerNote = nil;
	c_route = "Saved";
	if ( NuNDataPlayers[c_name].faction == "Horde" ) then
		NuNF.NuN_HordeSetup();
	else
		NuNF.NuN_AllianceSetup();
	end
	NuN_ShowNote();
end



function NuN_ShowWhoNote(cName)
	if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
		return;
	end

	c_name = cName;
	c_class = nil;
	c_race = nil;
	c_sex = nil;
	c_prof1 = nil;
	c_prof2 = nil;
	c_arena = nil;
	c_hrank = nil;
	c_guild = nil;
	gRank = nil;
	gRankIndex = nil;
	gNote = nil;
	gOfficerNote = nil;
	c_route = "Who";
	if ( NuN_horde ) then
		NuNF.NuN_HordeSetup();
	else
		NuNF.NuN_AllianceSetup();
	end
	NuN_ShowNote();
end



function NuN_ShowNote()
	local hText;
	local theText;

	-- Toggle the frame if for the same Player
	if ( ( NuNFrame:IsVisible() ) and ( prevName == c_name ) ) then
		NuNFrame:Hide();
	else
		NuNFrame:Hide();
		prevName = c_name;		-- save for toggle check

		if ( NuNOptionsFrame:IsVisible() ) then
			NuNOptionsFrame:Hide();
		end

		lastDD = nil;					-- just opened so no changes to Drop Down Boxes yet
		NuNButtonClrDD:Disable();

		NuNF.ClearButtonChanges();			-- just opened so no changes to User Definable Buttons yet

		NuNHeader:SetText(c_name);

		-- if loading a saved note, then access SavedVariables
		if ( NuNDataPlayers[c_name] ) then
			c_text = NuNF.NuN_GetCText(c_name);
			if ( ( c_text == nil ) or ( c_text == "" ) ) then
				c_text = "\n";
			end
			NuNText:SetText( c_text );
			if ( ( NuNSettings[pKey].autoA ) and ( ( NuNDataPlayers[c_name].friendLst ) or ( NuNDataPlayers[c_name].ignoreLst ) ) ) then
				NuNButtonDelete:Disable();
			else
				NuNButtonDelete:Enable();
			end
			NuNCOpenChatButton:Enable();
			NuNCTTCheckBoxLabel:Show();
			NuN_CTTCheckBox:Show();
			NuN_CTTCheckBox:SetChecked(0);
			if ( NuN_PinnedTooltip.type == "Contact" ) then
				NuN_CTTCheckBox:SetChecked( NuN_CheckPinnedBox(c_name) );
			end
			if ( c_name == pName ) then
				NuNHeader:SetText(NUN_PLAYER.." : "..c_name);
			elseif ( NuNDataPlayers[c_name].type == NuNC.NUN_AUTO_C ) then
				NuNHeader:SetText(NUN_AUTO.." : "..c_name);
			elseif ( NuNDataPlayers[c_name].type == NuNC.NUN_MANU_C ) then
				NuNHeader:SetText(NUN_MANU.." : "..c_name);
			elseif ( NuNDataPlayers[c_name].type == NuNC.NUN_PARTY_C ) then
				NuNHeader:SetText(NUN_PARTY.." : "..c_name );
			elseif ( NuNDataPlayers[c_name].type == NuNC.NUN_SELF_C ) then
				NuNHeader:SetText(NUN_SELF.." : "..c_name);
			elseif ( NuNDataPlayers[c_name].type == NuNC.NUN_GUILD_C ) then
				NuNHeader:SetText(NUN_GUILD.." : "..c_name);
			else
				NuNHeader:SetText(c_name);
			end
		else
			theText = "";
			NuNHeader:SetText(NUN_NEW.." : "..c_name);
			if ( gNote ~= nil ) then
				theText = "\n"..gNote;
			end
			if ( gOfficerNote ~= nil ) then
				theText = theText.."\n"..gOfficerNote;
			end
			if ( theText == "" ) then
				theText = "\n";
			end
			NuNText:SetText(theText);
			NuNButtonDelete:Disable();
			NuNCOpenChatButton:Disable();
			NuNCTTCheckBoxLabel:Hide();
			NuN_CTTCheckBox:Hide();
		end

		NuNF.UserButtons_Initialise();
		NuNF.DropDowns_Initialise();

		-- variables that save changes to drop down boxes BEFORE the actual note is saved
		ddBoxes.ddRace = nil;
		ddBoxes.ddClass = nil;
		ddBoxes.ddSex = nil;
		ddBoxes.ddPRating = nil;
		ddBoxes.ddProf1 = nil;
		ddBoxes.ddProf2 = nil;
		ddBoxes.ddArena = nil;
		ddBoxes.ddHRank = nil;

		if ( NuNEditDetailsFrame:IsVisible() ) then
			NuNEditDetailsFrame:Hide();
		end
		if ( NuNcDeleteFrame:IsVisible() ) then
			NuNcDeleteFrame:Hide();
		end

		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name][pName] ) and ( NuNDataPlayers[c_name][pName].partied ) ) then
--			NuNPartiedLabel:Show();
			NuNPartiedNumberLabel:SetText("(x"..tostring(NuNDataPlayers[c_name][pName].partied)..")");
			NuNPartiedNumberLabel:Show();
			NuNFramePartyDownButton:Show();
		else
--			NuNPartiedLabel:Hide();
			NuNPartiedNumberLabel:SetText("(0)");
			NuNPartiedNumberLabel:Hide();
			NuNFramePartyDownButton:Hide();
		end

		NuNFrame:SetScale(NuNSettings[pKey].pScale);
		NuNFrame:Show();

		-- Try to auto-populate more data about any opening Player Note												-- 5.60
		if ( not NuNSettings[pKey].restrictwho ) then
			NuN_Who();																			-- 5.60
		end

		-- One of the NuN Options controls whether the Text box gains focus automatically when you open a note
		if ( not NuNSettings[pKey].bHave ) then
			NuNText:SetFocus();
		else
			NuNText:ClearFocus();
		end
	end
end


function NuN_HideIgnores()
--	NuN_Message("Wibble");
	if ( this:GetChecked() ) then
		NuNSettings[pKey].hignores = true;
	else
		NuNSettings[pKey].hignores = nil;
	end
end


-- automatic montoring of Ignore List for note creation and sharing with Alts
function NuN_Update_Ignored()
	local index;
	local value;
	local x;
	local iName;
	NuN_FriendIgnoreActivity = true;
	local stopIgnoring = {};
	local startIgnoring = {};
	NuN_IgnoreUpdate.func = nil;
	NuN_IgnoreUpdate.name = nil;
	NuN_IgnoreUpdate.time = 0;
	NuN_FriendUpdate.func = nil;
	NuN_FriendUpdate.name = nil;
	NuN_FriendUpdate.time = 0;

	if ( not NuNSettings[pKey].gNotFriends ) then
		NuNSettings[pKey].gNotFriends = {};
	end

	if ( pFaction ~= nil ) then
		local isIgnored = {};
		for i = 1, GetNumIgnores(), 1 do
			local lName = GetIgnoreName(i);
			if ( ( not lName ) or ( lName == "" ) or ( lName == UNKNOWN ) or ( lName == UNKNOWNOBJECT ) ) then -- 5.60
				return true;
			else
				isIgnored[lName] = true;
			end
		end

		-- Check WoW Ignored List and validate against Saved Data
		for i = 1, GetNumIgnores(), 1 do
			iName = GetIgnoreName(i);
			if ( ( iName ) and ( iName ~= UNKNOWN ) and ( lName ~= UNKNOWNOBJECT ) ) then -- 5.60
				if ( NuNSettings[pKey].gNotIgnores[iName] )  then
					if ( NuNSettings[pKey].autoA ) then
						stopIgnoring[iName] = true;
					end
					if ( ( NuNDataPlayers[iName] ) and ( NuNDataPlayers[iName].ignoreLst ) ) then
						if ( ( NuNSettings[pKey].autoD ) and ( NuNDataPlayers[iName].type == NuNC.NUN_AUTO_C ) and ( not NuNDataPlayers[iName].friendLst ) ) then
							NuNDataPlayers[iName] = nil;
						else
							NuNDataPlayers[iName].ignoreLst = nil;
						end
					end

				elseif ( ( NuNSettings[pKey].autoA ) and ( not NuNDataPlayers[iName] ) ) then
					NuNDataPlayers[iName] = {};
					NuNDataPlayers[iName].type = NuNC.NUN_AUTO_C;
					NuNDataPlayers[iName].faction = pFaction;
					NuNDataPlayers[iName][txtTxt] = NUN_AUTO_IGNORE..NuNF.NuN_GetDateStamp();
					NuNDataPlayers[iName].ignoreLst = true;
				end
			end
		end

		-- Check Saved Data and validate against WoW Ignored List
		for index, value in pairs(NuNDataPlayers) do
			if ( ( NuNDataPlayers[index].faction) and ( NuNDataPlayers[index].faction == pFaction ) and ( index ~= pName ) ) then
				local isIndexIgnored = false;
				if ( isIgnored[index] ) then
					isIndexIgnored = true;
				end

				if ( ( isIndexIgnored ) and ( NuNSettings[pKey].gNotIgnores[index] ) ) then
					if ( ( NuNSettings[pKey].autoA ) and ( not stopIgnoring[index] ) ) then
						stopIgnoring[index] = true;
					end
					if ( ( NuNDataPlayers[index] ) and ( NuNDataPlayers[index].ignoreLst ) ) then
						if ( ( NuNSettings[pKey].autoD ) and ( NuNDataPlayers[index].type == NuNC.NUN_AUTO_C ) and ( not NuNDataPlayers[index].friendLst ) ) then
							NuNDataPlayers[index] = nil;
						else
							NuNDataPlayers[index].ignoreLst = nil;
						end
					end

				elseif ( isIndexIgnored ) then
					if ( not NuNDataPlayers[index].ignoreLst ) then			-- Ignored but no ignore list currently
						NuNDataPlayers[index].ignoreLst = true;
					end

				else
					if ( NuNDataPlayers[index].ignoreLst ) then
						if ( NuNSettings[pKey].gNotIgnores[index] ) then
							if ( ( NuNDataPlayers[index].type == NuNC.NUN_AUTO_C ) and ( NuNSettings[pKey].autoD ) and ( not NuNDataPlayers[index].friendLst ) ) then
								NuNDataPlayers[index] = nil;
							else
								NuNDataPlayers[index].ignoreLst = nil;
							end

						else
							if ( NuNSettings[pKey].autoA ) then
								startIgnoring[index] = true;
							end
							if ( NuNDataPlayers[index] ) then
								NuNDataPlayers[index].ignoreLst = true;
							elseif ( NuNSettings[pKey].autoFI ) then
								NuNDataPlayers[index] = {};
								NuNDataPlayers[index].type = NuNC.NUN_AUTO_C;
								NuNDataPlayers[index].faction = pFaction;
								NuNDataPlayers[index][txtTxt] = NUN_AUTO_IGNORE..NuNF.NuN_GetDateStamp();
								NuNDataPlayers[index].ignoreLst = true;
							end
						end
					end
				end
			end
		end
	end

	for name, player in pairs(stopIgnoring) do
		NuN_AttemptedFriendIgnores = NuN_AttemptedFriendIgnores + 1;
		if ( not NuNSettings[pKey].autoS ) then
			NuN_Message(DELETE.." "..IGNORE.." "..name);
		end
		DelIgnore(name);
	end

	for name, player in pairs(startIgnoring) do
		NuN_AttemptedFriendIgnores = NuN_AttemptedFriendIgnores + 1;
		if ( not NuNSettings[pKey].autoS ) then
			NuN_Message(IGNORE.." "..name);
		end
		AddIgnore(name);
	end

	NuN_FriendIgnoreActivity = nil;

	return nil;
end


-- automatic monitoring of Friends list for note creation and sharing with alts
function NuN_Update_Friends()
	local index;
	local value;
	local x;
	local iName;
	local addFriends = {};
	local remFriends = {};
	NuN_FriendIgnoreActivity = true;
	NuN_IgnoreUpdate.func = nil;
	NuN_IgnoreUpdate.name = nil;
	NuN_IgnoreUpdate.time = 0;
	NuN_FriendUpdate.func = nil;
	NuN_FriendUpdate.name = nil;
	NuN_FriendUpdate.time = 0;

	if ( not NuNSettings[pKey].gNotFriends ) then
		NuNSettings[pKey].gNotFriends = {};
	end

	if ( pFaction ~= nil ) then
		local isFriendly = {};
		for i = 1, GetNumFriends(), 1 do
			local lName = GetFriendInfo(i);
			if ( ( not lName ) or ( lName == "" ) or ( lName == UNKNOWN ) or ( lName == UNKNOWNOBJECT ) ) then -- 5.60
				return true;
			else
				isFriendly[lName] = true;
			end
		end

		-- Check WoW Friend List and validate against Saved Data
		for i = 1, GetNumFriends(), 1 do
			iName = GetFriendInfo(i);
			if ( ( iName ~= nil ) and ( iName ~= UNKNOWN ) and ( iName ~= UNKNOWNOBJECT ) ) then -- 5.60
				if ( NuNSettings[pKey].gNotFriends[iName] )  then
					if ( NuNSettings[pKey].autoA ) then
						remFriends[iName] = true;
					end
					if ( ( NuNDataPlayers[iName] ) and ( NuNDataPlayers[iName].friendLst ) ) then
						if ( ( NuNSettings[pKey].autoD ) and ( NuNDataPlayers[iName].type == NuNC.NUN_AUTO_C ) and ( not NuNDataPlayers[iName].ignoreLst ) ) then
							NuNDataPlayers[iName] = nil;
						else
							NuNDataPlayers[iName].friendLst = nil;
						end
					end

				elseif ( ( not NuNDataPlayers[iName] ) and ( NuNSettings[pKey].autoA ) ) then
					NuNDataPlayers[iName] = {};
					NuNDataPlayers[iName].type = NuNC.NUN_AUTO_C;
					NuNDataPlayers[iName].faction = pFaction;
					NuNDataPlayers[iName][txtTxt] = NUN_AUTO_FRIEND..NuNF.NuN_GetDateStamp();
					NuNDataPlayers[iName].friendLst = true;
				end
			end
		end

		-- Check Saved Data and validate against WoW Friend List
		for index, value in pairs(NuNDataPlayers) do
			if  ( index == pName ) then
				NuNDataPlayers[index].type = NuNC.NUN_SELF_C;

			elseif ( ( NuNDataPlayers[index].faction ) and ( NuNDataPlayers[index].faction == pFaction ) ) then
				local isIndexFriendly = false;
				if ( isFriendly[index] ) then
					isIndexFriendly = true;
				end

				if ( ( isIndexFriendly ) and ( NuNSettings[pKey].gNotFriends[index] ) ) then
					if ( ( NuNSettings[pKey].autoA ) and ( not remFriends[index] ) ) then
						remFriends[index] = true;
					end
					if ( ( NuNDataPlayers[index] ) and ( NuNDataPlayers[index].friendLst ) ) then
						if ( ( NuNSettings[pKey].autoD ) and ( NuNDataPlayers[index].type == NuNC.NUN_AUTO_C ) and ( not NuNDataPlayers[index].ignoreLst ) ) then
							NuNDataPlayers[index] = nil;
						else
							NuNDataPlayers[index].friendLst = nil;
						end
					end

				elseif ( isIndexFriendly ) then
					if ( not NuNDataPlayers[index].friendLst ) then			-- Ignored but no ignore list currently
						NuNDataPlayers[index].friendLst = true;
					end

				else
					if ( NuNDataPlayers[index].friendLst ) then
						if ( NuNSettings[pKey].gNotFriends[index] ) then
							if ( ( NuNDataPlayers[index].type == NuNC.NUN_AUTO_C ) and ( NuNSettings[pKey].autoD ) and ( not NuNDataPlayers[index].ignoreLst ) ) then
								NuNDataPlayers[index] = nil;
							else
								NuNDataPlayers[index].friendLst = nil;
							end

						else
							if ( NuNSettings[pKey].autoA ) then
								addFriends[index] = true;
							end
							if ( NuNDataPlayers[index] ) then
								NuNDataPlayers[index].friendLst = true;
							elseif ( NuNSettings[pKey].autoFI ) then
								NuNDataPlayers[index] = {};
								NuNDataPlayers[index].type = NuNC.NUN_AUTO_C;
								NuNDataPlayers[index].faction = pFaction;
								NuNDataPlayers[index][txtTxt] = NUN_AUTO_FRIEND..NuNF.NuN_GetDateStamp();
								NuNDataPlayers[index].friendLst = true;
							end
						end
					end
				end
			end
		end
	end

	for name, player in pairs(addFriends) do
		NuN_AttemptedFriendIgnores = NuN_AttemptedFriendIgnores + 1;
		if ( not NuNSettings[pKey].autoS ) then
			NuN_Message(FRIENDS.." "..name);
		end
		AddFriend(name);
	end

	for name, player in pairs(remFriends) do
		NuN_AttemptedFriendIgnores = NuN_AttemptedFriendIgnores + 1;
		if ( not NuNSettings[pKey].autoS ) then
			NuN_Message(DELETE.." "..FRIENDS.." "..name);
		end
		RemoveFriend(name);
	end

	NuN_FriendIgnoreActivity = nil;

	return nil;
end



-- Little helper function
function NuNGet_CommandID(tab, txt)
	for i = 1, getn(tab), 1 do					-- #tab
		if ( tab[i].Command == txt ) then return i; end
	end
	return nil;
end



-- The actual Note Saving Routine for Contact Notes
-- (General notes have a different Save routine)
-- Note that Player notes are saved at Realm level, and we don't have to worry about duplicates
function NuN_WriteNote()
	if ( ( c_name == UNKNOWN ) or ( c_name == UNKNOWNOBJECT ) ) then -- 5.60
		return;
	end

	if (not NuNDataPlayers[c_name]) then
		NuNDataPlayers[c_name] = {};
	end

	if ( c_name == pName ) then
		NuNDataPlayers[c_name].type = NuNC.NUN_SELF_C;
		NuNHeader:SetText(NUN_PLAYER.." : "..c_name);
	elseif ( ( not NuNDataPlayers[c_name].type ) or ( NuNDataPlayers[c_name].type == NuNC.NUN_AUTO_C ) ) then
		NuNDataPlayers[c_name].type = NuNC.NUN_MANU_C;
		NuNHeader:SetText(NUN_MANU.." : "..c_name);
	end

	if ( not NuNDataPlayers[c_name].faction ) then
		if ( ( c_route == "Target" ) or ( c_route == "Create" ) or ( c_route == "Receipt" ) ) then
			NuNDataPlayers[c_name].faction = c_faction;
		else
			NuNDataPlayers[c_name].faction = pFaction;
		end
	end

	-- update the note status in visible Blizzard frames to show note now exists
	if ( FriendsListFrame:IsVisible() ) then
		NuNNew_FriendsList_Update();
	elseif ( IgnoreListFrame:IsVisible() ) then
		NuNNew_IgnoreList_Update();
	elseif ( GuildPlayerStatusFrame:IsVisible() ) then
		NuNNew_GuildStatus_Update();
	elseif ( GuildStatusFrame:IsVisible() ) then
		NuNNew_GuildStatus_Update();
	elseif ( WhoFrame:IsVisible() ) then
		NuNNew_WhoList_Update();
	elseif ( LFMFrame:IsVisible() ) then
		LFMFrame_Update();
	end

	if ( c_guild ~= nil ) then
		NuNDataPlayers[c_name].guild = c_guild;
	end
	if ( not NuNDataPlayers[c_name].guild ) then
		NuNDataPlayers[c_name].guild = "";
	end

	if ( NuN_Is_Ignored(c_name) ) then
		if ( not NuNDataPlayers[c_name].ignoreLst ) then
			NuNDataPlayers[c_name].ignoreLst = true;
		end
	end

	if ( NuN_Is_Friendly(c_name) ) then
		if ( not NuNDataPlayers[c_name].friendLst ) then
			NuNDataPlayers[c_name].friendLst = true;
		end
	end

	-- if any of the Drop Down boxes have changed, then save the change in the note
	--  -1 is used to flag the value has been nulled
	if (ddBoxes.ddRace) then
		if ( ddBoxes.ddRace == -1 ) then
			NuNDataPlayers[c_name].race = nil;
		else
			NuNDataPlayers[c_name].race = ddBoxes.ddRace;
		end
		ddBoxes.ddRace = nil;
	elseif ( c_race ~= nil ) then
		NuNDataPlayers[c_name].race = NuNF.NuNGet_TableID(Races, c_race);
	end
	if (ddBoxes.ddClass) then
		if ( ddBoxes.ddClass == -1 ) then
			NuNDataPlayers[c_name].cls = nil;
		else
			NuNDataPlayers[c_name].cls = ddBoxes.ddClass;
		end
		ddBoxes.ddClass = nil;
	elseif ( c_class ~= nil )  then
		NuNDataPlayers[c_name].cls = NuNF.NuNGet_TableID(Classes, c_class);
	end
	if (ddBoxes.ddSex) then
		if ( ddBoxes.ddSex == -1 ) then
			NuNDataPlayers[c_name].sex = nil;
		else
			NuNDataPlayers[c_name].sex = ddBoxes.ddSex;
		end
		ddBoxes.ddSex = nil;
	elseif ( c_sex ~= nil ) then
		NuNDataPlayers[c_name].sex = NuNF.NuNGet_TableID(NUN_SEXES, c_sex);
	end
	if ( ddBoxes.ddPRating ) then
		if ( ddBoxes.ddPRating == -1 ) then
			NuNDataPlayers[c_name].prating = nil;
		else
			NuNDataPlayers[c_name].prating = ddBoxes.ddPRating;
		end
	elseif ( c_prating ~= nil ) then
		NuNDataPlayers[c_name].prating = NuNF.NuNGet_TableID(NuNSettings.ratings, c_prating);
	end
	if (ddBoxes.ddProf1) then
		if ( ddBoxes.ddProf1 == -1 ) then
			NuNDataPlayers[c_name].prof1 = nil;
		else
			NuNDataPlayers[c_name].prof1 = ddBoxes.ddProf1;
		end
		ddBoxes.ddProf1 = nil;
	elseif ( c_prof1 ~= nil ) then
		NuNDataPlayers[c_name].prof1 = NuNF.NuNGet_TableID(NUN_PROFESSIONS, c_prof1);
	end
	if (ddBoxes.ddProf2) then
		if ( ddBoxes.ddProf2 == -1 ) then
			NuNDataPlayers[c_name].prof2 = nil;
		else
			NuNDataPlayers[c_name].prof2 = ddBoxes.ddProf2;
		end
		ddBoxes.ddProf2 = nil;
	elseif ( c_prof2 ~= nil ) then
		NuNDataPlayers[c_name].prof2 = NuNF.NuNGet_TableID(NUN_PROFESSIONS, c_prof2);
	end
	if ( ddBoxes.ddArena ) then
		if ( ddBoxes.ddArena == -1 ) then
			NuNDataPlayers[c_name].arena = nil;
		else
			NuNDataPlayers[c_name].arena = ddBoxes.ddArena;
		end
	elseif ( c_arena ~= nil ) then
		NuNDataPlayers[c_name].arena = NuNF.NuNGet_TableID(NUN_ARENAR, c_arena);
	end
	if (ddBoxes.ddHRank) then
		if ( ddBoxes.ddHRank == -1 ) then
			NuNDataPlayers[c_name].hrank = nil;
		else
			NuNDataPlayers[c_name].hrank = ddBoxes.ddHRank;
		end
		ddBoxes.ddHRank = nil;
	elseif ( c_hrank ~= nil ) then
		NuNDataPlayers[c_name].hrank = NuNF.NuNGet_TableID(Ranks, c_hrank);
	end

	c_text = NuNText:GetText();
	NuNF.NuN_SetCText(c_name);				-- split the text in to chunks for saving, and carry out special character substitution
	c_text = string.gsub(c_text, "\124\124", "|");
	c_text = string.gsub(c_text, "|C", "|c");
	c_text = string.gsub(c_text, "|R", "|r");
	c_text = string.gsub(c_text, "||c", "|c");
	c_text = string.gsub(c_text, "||r", "|r");
	NuNText:SetText(c_text);
	NuN_AllowColours("Contact");

	-- if any User Definable buttons changed value, then save those changes
	local b;
	for n = 1, uBttns, 1 do
		if (bttnChanges[n] ~= "") and (bttnChanges[n] ~= nil) then
			hdNbr = pHead..n;
			nameHdNbr = c_name..hdNbr;
			if (not NuNDataPlayers[nameHdNbr]) then
				NuNDataPlayers[nameHdNbr] = {};
			end
			if (bttnChanges[n] == -1) then		-- 5.60 Use -1 to flag blank
				NuNDataPlayers[nameHdNbr].txt = "";					-- nil = default; "" = manually blanked. For User Button Headers.
			else
				NuNDataPlayers[nameHdNbr].txt = bttnChanges[n];
			end
		end
		-- 5.60 code moved in to this loop rather than looping a second time below
		b = n + detlOffset;
		if (bttnChanges[b] ~= nil) and (bttnChanges[b] ~= "") then	-- 5.60 test swap
			nameDtNbr = c_name..pDetl..n;
			if (not NuNDataPlayers[nameDtNbr]) then
				NuNDataPlayers[nameDtNbr] = {};
			end
			if (bttnChanges[b] == -1) then	-- 5.60 Use -1 to flag blank
				NuNDataPlayers[nameDtNbr].txt = nil;
			else
				NuNDataPlayers[nameDtNbr].txt = bttnChanges[b];
			end
		end
	end

	-- Talents ?
	if ( ( NuNTalents.player ) and ( NuNTalents.total ) and ( NuNTalents.player == c_name ) and ( NuNTalents.total > 0 ) ) then
		-- copy NuNTalents details to .talents array
		NuNDataPlayers[c_name].talents = {};
		NuNF.NuN_CopyTable(NuNTalents, NuNDataPlayers[c_name].talents)
	end

	-- Refresh the note browser, as this write may need to be reflected in it
	if ( ( NuNSearchFrame:IsVisible() ) and ( not string.find(NuNSearchTitleText:GetText(), NUN_QUESTS_TEXT) ) ) then
		NuNSearch_Search();
	end

	NuNF.ClearButtonChanges();
	if ( ( NuNSettings[pKey].autoA ) and ( ( NuNDataPlayers[c_name].friendLst ) or ( NuNDataPlayers[c_name].ignoreLst ) ) ) then
	else
		NuNButtonDelete:Enable();
	end
	NuNCOpenChatButton:Enable();
	NuNCTTCheckBoxLabel:Show();
	NuN_CTTCheckBox:Show();

	-- Update the Pin up Tooltip if necessary
	if ( NuN_CTTCheckBox:GetChecked() ) then
		ttName = c_name;
		NuN_PinnedTooltip:ClearLines();
		NuN_State.NuN_PinUpHeader = true;
		NuN_PinnedTooltip.type = "Contact";
		NuNSettings[pKey].pT = {};
		NuNSettings[pKey].pT.type = "Contact";
		NuNSettings[pKey].pT.name = ttName;
		NuNF.NuN_BuildTT(NuN_PinnedTooltip);
		NuN_State.NuN_PinUpHeader = false;
		NuN_PinnedTooltip:Show();
		if ( NuN_State.pinnedTTMoved ) then
			NuN_PinnedTooltip:ClearAllPoints();
			NuN_PinnedTooltip:SetPoint("CENTER", "UIParent", "BOTTOMLEFT", NuN_PinnedTooltip.x, NuN_PinnedTooltip.y);
		end
	end

	if ( NuN_SaveReport ) then
		NuN_Message(NuNC.NUN_SAVED_NOTE .. " : " .. c_name);
	end

	-- MapNotes related functionality for linking NuN notes to MapNotes
	NuN_IndexAll();
end


-- The Note Saving function for General notes
function NuNGNote_WriteNote(noteName)
	local conflict = false;
	local value, index, pad;
	local conflicts = 0;
	local saveLvl;
	local NuN_Creating = nil;

	-- need to fetch a reliable note name for this note; Can be passed as parm, or must be fetched from Frame components
	if ( ( noteName ) and ( type(noteName) == "string" ) and ( noteName ~= "" ) ) then
		c_note = noteName;
	else
		if ( ( NuNGNoteTitleButton:IsVisible() ) and ( NuNGNoteTitleButtonText:GetText() ~= "" ) ) then
			c_note = NuNGNoteTitleButtonText:GetText();
		else
			c_note = NuNGNoteTextBox:GetText();
		end
	end

	-- Check that IF Saving this Note at Account Level, you won't wipe out Notes saved at Realm Level on other Realms
	-- i.e.	you can have multiple notes with the same name saved on different Realms, or ONE Account level note with that name
	--	you can NOT have an Account level note with the same name as Realm level notes (even on other Realms)
	NuNConflictedRealmsLabel:SetText(" ");
	if ( ( NuN_GLevel_CheckBox:GetChecked() ) and ( not NuNGNoteFrame.confirmed ) ) then
		for index, value in pairs(NuNData) do
			if ( ( index ~= pKey ) and ( NuNData[index][Notes] ) ) then
				if ( NuNData[index][Notes][c_note] ) then
					conflicts = conflicts + 1;
					if ( conflicts == 1 ) then
						pad = "";
					else
						pad = ", ";
					end
					if ( conflicts < 5 ) then
						NuNConflictedRealmsLabel:SetText( NuNConflictedRealmsLabel:GetText()..pad..index );
					end
					conflict = true;
				end
			end
		end
	end

	if ( ( conflict ) and ( not NuNGNoteFrame.confirmed ) ) then
		if ( conflicts > 4 ) then
			NuNConflictedRealmsLabel:SetText( NuNConflictedRealmsLabel:GetText().."...." );
		end
		NuN_ConfirmFrame:Show();
	else
		if ( NuN_ConfirmFrame:IsVisible() ) then
			NuN_ConfirmFrame:Hide();
		end
		if ( not NuN_GNote_OriTitle ) then
			NuN_Creating = true;
			if ( ( NuN_Receiving.active ) and ( c_note == NuN_Receiving.title ) ) then
				NuN_Creating = nil;
			end
		end

		if ( ( ( NuN_GNote_OriTitle ) and ( NuN_GNote_OriTitle ~= c_note ) ) or ( not NuN_GNote_OriTitle ) ) then
			if ( ( NuNDataRNotes[c_note] ) or ( NuNDataANotes[c_note] ) ) then
				NuN_SearchForNote("Text", c_note);
				receiptPending = true;
				StaticPopup_Show("NUN_DUPLICATE_RECORD");
				return;
			else
				if ( NuNDataRNotes[NuN_GNote_OriTitle] ) then
					NuNDataRNotes[NuN_GNote_OriTitle] = nil;
				elseif ( NuNDataANotes[NuN_GNote_OriTitle] ) then
					NuNDataANotes[NuN_GNote_OriTitle] = nil;
				end
			end
		end

		NuN_GNote_OriTitle = c_note;
		g_text = NuNGNoteTextScroll:GetText();
		if ( g_text == nil ) then
			g_text = "";
		end

		if ( NuN_GLevel_CheckBox:GetChecked() ) then
			saveLvl = "Account";
			NuNDataANotes[c_note] = {};
			for index, value in pairs(NuNData) do
				if ( NuNData[index][Notes] ) then
					if ( NuNData[index][Notes][c_note] ) then
						NuNData[index][Notes][c_note] = nil;
					end
				end
			end
		else
			saveLvl = "Realm";
			NuNDataRNotes[c_note] = {};
			if ( NuNDataANotes[c_note] ) then
				NuNDataANotes[c_note] = nil;
			end
		end

		g_text = string.gsub(g_text, "\124\124", "|");
		g_text = string.gsub(g_text, "|C", "|c");
		g_text = string.gsub(g_text, "|R", "|r");
		g_text = string.gsub(g_text, "||c", "|c");
		g_text = string.gsub(g_text, "||r", "|r");
		-- THIS is basically the moment of saving
		NuNF.NuN_SetGText(saveLvl);
		NuNGNoteTextScroll:SetText(g_text);
		NuN_AllowColours("General");

		-- Index Item Links against Simple text names, so that Item Link note names can be looked up from Simple text names
		if ( string.find(c_note, "|Hitem:") ) then
			simpleName = NuNF.NuN_GetSimpleName(c_note);
			if ( simpleName ~= nil ) then
				NuNData[itmIndex][simpleName] = c_note;
			end
		end

		if ( not NuNGNoteFrame.type ) then
			NuNGNoteFrame.type = c_type;
		end
		if ( not NuNGNoteFrame.type ) then
			NuNGNoteFrame.type = NuNGet_CommandID(NUN_NOTETYPES, "   ");
			c_type = NuNGet_CommandID(NUN_NOTETYPES, "   ");
		end
		if ( NuNGNoteFrame.type ) then
			if ( NuN_GLevel_CheckBox:GetChecked() ) then
				NuNDataANotes[c_note].type = NuNGNoteFrame.type;
			else
				NuNDataRNotes[c_note].type = NuNGNoteFrame.type;
			end
			-- If a Quest Note, and auto-noting Quests, and no Quest History for this quest, then.........
			if ( NUN_NOTETYPES[NuNGNoteFrame.type].Command == "QST"  ) then
				if ( not NuNData[pKey].QuestHistory[pName][c_note] ) then
					NuNData[pKey].QuestHistory[pName][c_note] = {};
					NuNData[pKey].QuestHistory[pName][c_note].sortDate = tostring(date("%Y%m%d%H%M%S"));
					NuNData[pKey].QuestHistory[pName][c_note].pLevel = UnitLevel("player");
					local qTxt = NuNC.NUN_CREATED.."\n    "..NuNF.NuN_GetDateStamp().."\n    "..NuNF.NuN_GetLoc().."\n";
					NuNData[pKey].QuestHistory[pName][c_note].txt = NuNF.NuN_SetSaveText(qTxt);
					NuNF.NuN_UpdateQuestNotes("Write");
				end
				
			-- else if an NPC note, and auto-noting NPCs, and MapNotes is installed, then .............
			elseif ( ( NUN_NOTETYPES[NuNGNoteFrame.type].Command == "NPC" ) and ( NuN_Creating ) and ( NuNSettings[pKey].autoMapNotes ) ) then
				NuN_MapNote("Target", "", "", nil);
			end
		end

		-- Refresh other frames that might reflect the recent Save
		
		if ( QuestLogFrame:IsVisible() ) then
			QuestLog_Update();
		end

		if ( ( NuNSearchFrame:IsVisible() ) and ( NuNGNoteFrame.fromQuest ) ) then
			NuN_FetchQuestHistory();
		elseif ( ( NuNSearchFrame:IsVisible() ) and ( not string.find(NuNSearchTitleText:GetText(), NUN_QUESTS_TEXT) ) ) then
			NuNSearch_Search();
		end

		-- Update Note Buttons to reflect the fact it has been saved e.g. can now delete
		
		NuNGNoteButtonDelete:Enable();
		if ( ( MapNotes_OnLoad ) or ( MetaMap_Quicknote ) ) then
			NuNMapNoteButton:Enable();
		end
		NuNGOpenChatButton:Enable();
		NuN_GTTCheckBox:Show();
		NuN_GTTCheckBox:SetChecked(0);
		if ( NuN_PinnedTooltip.type == "General" ) then
			NuN_GTTCheckBox:SetChecked( NuN_CheckPinnedBox(c_note) );
		end
		NuNGTTCheckBoxLabel:Show();
		NuNGNoteTitleButtonText:SetText(c_note);
		NuNGNoteTextBox:Hide();
		NuNGNoteTitleButton:Show();
		NuNGNoteHeader:SetText(NuNC.NUN_SAVED_NOTE);

		if ( NuN_SaveReport ) then
			NuN_Message(NuNC.NUN_SAVED_NOTE .. " : " .. c_note);
		end

		-- Update the Pinned up tooltip if necessary
		if ( NuN_GTTCheckBox:GetChecked() ) then
			ttName = c_note;
			NuN_PinnedTooltip:ClearLines();
			NuN_State.NuN_PinUpHeader = true;
			NuN_PinnedTooltip.type = "General";
			NuNSettings[pKey].pT = {};
			NuNSettings[pKey].pT.type = "General";
			NuNSettings[pKey].pT.name = ttName;
			NuNF.NuN_BuildTT(NuN_PinnedTooltip);
			NuN_State.NuN_PinUpHeader = false;
			NuN_PinnedTooltip:Show();
			if ( NuN_State.pinnedTTMoved ) then
				NuN_PinnedTooltip:ClearAllPoints();
				NuN_PinnedTooltip:SetPoint("CENTER", "UIParent", "BOTTOMLEFT", NuN_PinnedTooltip.x, NuN_PinnedTooltip.y);
			end
		end
		NuN_IndexAll();
	end
end

function NuNNew_BLRemovePlayer(_, player, ...)
	if (player == "target") then
		name = UnitName("target");
	else
		name = player;
	end

	if (name == nil) then
		index = BlackList:GetSelectedBlackList();
	else
		index = BlackList:GetIndexByName(name);
	end

	if (index > 0) then
		entry = BlackList:GetPlayerByIndex(index);

		if ( entry ) then
			local name = entry.name;
			local NuNned = string.find(entry.reason, "[NuN]");
			if ( ( name ) and ( NuNned ) and ( NuNDataPlayers[name] ) and ( NuNDataPlayers[name].prating ) ) then
				NuNDataPlayers[name].prating = nil;
			end		
		end
	end

	NuNHooks.NuNOri_BLRemovePlayer(_, player, ...);
end

function NuN_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		NuN_Message("NotesUNeed |c0000FF00"..NUN_VERSION.."|r "..NUN_LOADED);

		-- If Loading due to a ReloadUI triggered by NuN BackUp OR Restore, then finish processing
		if ( NuNSettings.BackedUp ) then
			NuNSettings.BackedUp = nil;
			NuN_Message( NUN_FINISHED_PROCESSING.." : "..NUN_OPT_BACKUP );
		elseif ( NuNSettings.Restored ) then
			NuNSettings.Restored = nil;
			NuN_Message( NUN_FINISHED_PROCESSING.." : "..NUN_OPT_RESTORE );
		end

		if ( TipBuddyTooltip ) then
			NuN_TipBuddyTooltipControl:SetParent(TipBuddyTooltip);
		end
		NuNHooks.NuNOri_AlphaMapNotes_OnEnter = AlphaMapNotes_OnEnter;
		AlphaMapNotes_OnEnter = NuNNew_AlphaMapNotes_OnEnter;

		tryI = true;							-- one time try to refresh Ignores in OnUpdate
		pName = UnitName("player");
		NuN_getFaction();
		
		NuNF.NuN_InitialiseSavedVariables();

		if ( not NuNDataPlayers[pName] ) then
			NuN_AutoNote();						-- function itself checks if option is checked
		end
		if ( not NuNSettings[pKey].hideMicro ) then
			NuNMicroFrame:Show();
		else
			NuNMicroFrame:Hide();
		end

		NuN_PinnedTooltip:SetScale(NuNSettings[pKey].tScale);
		NuN_Tooltip:SetScale(NuNSettings[pKey].tScale);
		WorldMapTooltip:SetScale(NuNSettings[pKey].mScale);
		NuN_MapTooltip:SetScale(NuNSettings[pKey].mScale);
		NuNPopup:SetScale(NuNSettings[pKey].mScale);

		if ( MapNotes_OnLoad ) then
			NuN_MapIndexHouseKeeping();
		end

		NuN_State.NuN_AtStartup = true;

		-- one time MapNotes function hooking
		if ( NuN_State.NuN_FirstTime ) then
			NuN_State.NuN_FirstTime = nil;
			if ( MapNotes_OnLoad ) then
				NuNHooks.NuNOri_MapNotes_OnEnter = MapNotes_OnEnter;
				MapNotes_OnEnter = NuNNew_MapNotes_OnEnter;
				NuNHooks.NuNOri_MapNotes_OnLeave = MapNotes_OnLeave;
				MapNotes_OnLeave = NuNNew_MapNotes_OnLeave;
				NuNHooks.NuNOri_MapNotes_DeleteNote = MapNotes_DeleteNote;
				MapNotes_DeleteNote = NuNNew_MapNotes_DeleteNote;
				NuNHooks.NuNOri_MapNotes_WriteNote = MapNotes_WriteNote;
				MapNotes_WriteNote = NuNNew_MapNotes_WriteNote;
				NuNHooks.NuNOri_MapNotes_Quicknote = MapNotes_Quicknote;
				MapNotes_Quicknote = NuNNew_MapNotes_Quicknote;
			end
		end

		-- Extended Quest Log compatibility changes - not sure if necessary any more in 5.60
		if ( EQL3_QuestLogFrame ) then
			NuN_QLF = EQL3_QuestLogFrame;
		elseif ( EQL_QuestLogFrame ) then
			NuN_QLF = EQL_QuestLogFrame;
		elseif ( QuestGuru_QuestLogFrame ) then
			NuN_QLF = QuestGuru_QuestLogFrame;
		elseif ( UberQuest_List ) then
			NuN_QLF = UberQuest_List;
		else
			NuN_QLF = QuestLogFrame;
		end
		NuNF.NuN_QuestLogButtons();

		-- If there is data available to Import, then enable the Import button
		for index, data in pairs(NuNDataExport) do
			NuN_ImportModule = index;
			NuN_ImportData = data;
		end
		if ( NuN_ImportModule ) then
			NuNOptionsDBImport:Enable();
		end

		-- alternative mono-spaced font for use in Note edit boxes
		if ( NuNSettings[pKey].nunFont ) then
			NuN_UpdateFont(NuNC.NUN_FONT1, 12);
			NuN_CustomFontCheckBox:SetChecked(1);
		end

		-- MapNotes related functions linking NuN to Map Notes
		NuN_IndexAll();

		-- Unit Right Click Menu changes
		NuN_SetupRatings(true);

		-- Ensure Guild Roster Update
		if ( NuNSettings[pKey].autoGuildNotes ) then
			if ( NuNSettings[pKey].autoGRVerbose ) then
				NuN_GuildRefresh("Startup");
			else
				NuN_GuildRefresh();
			end
--			NuN_State.NuN_forceGR = true;
--			GuildRoster();
		end

		--Cosmos integration
		if (EarthFeature_AddButton) then
			EarthFeature_AddButton(
				{
					id = NUN_OPTIONS_HEADER;
					name = NUN_OPTIONS_HEADER;
					subtext = "";
					tooltip = "";
					icon = "Interface\\Buttons\\UI-CheckBox-Check";
					callback = NuN_Options;
					test = nil;
				}
			);
		elseif (Cosmos_RegisterButton) then
			Cosmos_RegisterButton(
				NUN_OPTIONS_HEADER,
				NUN_OPTIONS_HEADER,
				"",
				"Interface\\Buttons\\UI-CheckBox-Check",
				NuN_Options
			);
		end
		
		-- 5.60 Build array of Noted Alts
		local altCounter = 1;
		local sortKey;
		local tAltArray = {};
				tAltArray[1] = {};	-- for other Alts on this Realm
				tAltArray[2] = {};	-- for other Alts on other Realms

		AltArray[altCounter] = {};
		AltArray[altCounter].name = pName;
		AltArray[altCounter].realm = pKey;
		AltArray[altCounter].displayName = pName;
		
		for altName in pairs(NuNData[pKey].QuestHistory) do
			if ( altName ~= pName ) then
				tAltArray[1][altCounter] = {};
				tAltArray[1][altCounter].name = altName;
				tAltArray[1][altCounter].realm = pKey;
				tAltArray[1][altCounter].displayName = altName;
				tAltArray[1][altCounter].sortKey = altName;
				altCounter = altCounter + 1;
			end
		end
		table.sort(tAltArray[1], NuNF.NuN_SortAltArray);

		altCounter = 1;
		for altRealm in pairs(NuNData) do
			if ( ( NuNData[altRealm].QuestHistory ) and ( altRealm ~= pKey ) ) then
				for altName in pairs(NuNData[altRealm].QuestHistory) do
					sortKey = altRealm..altName;
					tAltArray[2][altCounter] = {};
					tAltArray[2][altCounter].name = altName;
					tAltArray[2][altCounter].realm = altRealm;
					tAltArray[2][altCounter].displayName = altName .. "-" .. altRealm;
					tAltArray[2][altCounter].sortKey = sortKey;
					altCounter = altCounter + 1;
				end
			end
		end
		table.sort(tAltArray[2], NuNF.NuN_SortAltArray);

		altCounter = 1;	-- start at 2; pName at 1
		for i=1, getn(tAltArray[1]), 1 do
			altCounter = altCounter + 1;
			AltArray[altCounter] = {};
			AltArray[altCounter].name = tAltArray[1][i].name;
			AltArray[altCounter].realm = tAltArray[1][i].realm;
			AltArray[altCounter].displayName = tAltArray[1][i].displayName;
		end
		for i=1, getn(tAltArray[2]), 1 do
			altCounter = altCounter + 1;
			AltArray[altCounter] = {};
			AltArray[altCounter].name = tAltArray[2][i].name;
			AltArray[altCounter].realm = tAltArray[2][i].realm;
			AltArray[altCounter].displayName = tAltArray[2][i].displayName;
		end

		-- Now can populate the Drop Down box
		NuNSearchQHDropDown_OnLoad();
		UIDropDownMenu_SetSelectedID(NuNSearchQHDropDown, 1);
		UIDropDownMenu_SetText(pName, NuNSearchQHDropDown);

		-- Set up colour picker presets
		local cpKey, bttn, r, g, b;
		for i=1, 5, 1 do
			-- Contact note frame button
			cpKey = "cc"..i;
			bttn = getglobal("NuNCColourPreset"..i);
			bttn.preset = NuNSettings[pKey][cpKey];
			bttn.parentType = "Contact";
			bttn:SetID(i);
			r, g, b = NuNF.NuN_HtoD(bttn.preset);
			getglobal(bttn:GetName().."Texture"):SetVertexColor(r, g, b);
			-- General note frame button
			cpKey = "gc"..i;
			bttn = getglobal("NuNGColourPreset"..i);
			bttn.preset = NuNSettings[pKey][cpKey];
			bttn.parentType = "General";
			bttn:SetID(i);
			r, g, b = NuNF.NuN_HtoD(bttn.preset);
			getglobal(bttn:GetName().."Texture"):SetVertexColor(r, g, b);
		end

		if ( BlackList ) then
			NuNHooks.NuNOri_BLRemovePlayer = BlackList.RemovePlayer;
			BlackList.RemovePlayer = NuNNew_BLRemovePlayer;
		end

		if ( NuNSettings[pKey].pT ) then
			ttName = NuNSettings[pKey].pT.name;
			NuN_PinnedTooltip:ClearLines();
			NuN_PinnedTooltip:SetOwner(UIParent, ANCHOR_NONE);
			NuN_State.NuN_PinUpHeader = true;
			NuN_PinnedTooltip.type = NuNSettings[pKey].pT.type;
			NuN_PinnedTooltip.noteName = ttName;
			NuNF.NuN_BuildTT(NuN_PinnedTooltip);
			NuN_State.NuN_PinUpHeader = false;
			NuN_PinnedTooltip.x = NuNSettings[pKey].pT.x;
			NuN_PinnedTooltip.y = NuNSettings[pKey].pT.y;
			NuN_PinnedTooltip:Show();
			NuN_State.togglePinUp = true;
		end

		for key, value in pairs( NuNData[itmIndex] ) do
			NuNData[itmIndex][key] = string.gsub(value, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\|", ":0:0:0:0:0:0:0|");
			NuNData[itmIndex][key] = string.gsub(value, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\124", ":0:0:0:0:0:0:0\124");
		end

	elseif ( event == "ADDON_LOADED" ) then
		if ( arg1 == "Blizzard_AuctionUI" ) then
			for i = 1, 8, 1 do
				bttn = getglobal("BrowseButton"..i.."Item");
				if ( bttn ) then
					bttn:RegisterForClicks("LeftButtonUp", "MiddleButtonUp", "RightButtonUp");
					local func = bttn:GetScript("OnClick");
					if ( func ) then
						if ( not NuNHooks.NuNOri_AH_BrowseButtonItem_OnClick ) then
							NuNHooks.NuNOri_AH_BrowseButtonItem_OnClick = func;
						end
						bttn:SetScript("OnClick", NuN_AH_BrowseButton_OnClick);
					end
				end
			end
		end

	-- Get Delayed Who Event information on players
	elseif ( ( event == "WHO_LIST_UPDATE" ) and ( NuN_WhoReturnStruct.func ) ) then		-- 5.60
		NuN_WhoReturnStruct.func();														-- 5.60
		NuN_WhoReturnStruct.func = nil;													-- 5.60
		NuN_WhoReturnStruct.name = nil;													-- 5.60
		NuN_WhoReturnStruct.timeLimit = nil;											-- 5.60
		NuN_WhoReturnStruct.secondTry = nil;
		NuN_suppressExtraWho = nil;
		if ( ( NuNSettings[pKey] ) and ( NuNSettings[pKey].alternativewho ) ) then
			SetWhoToUI(0);                                          					-- 5.60
			FriendsFrame:RegisterEvent("WHO_LIST_UPDATE");								-- 5.60
		end

	-- Update Ignores
	elseif ( event == "IGNORELIST_UPDATE" ) then
		if ( NuN_IgnoreUpdate.func ) then
			local tDiff = GetTime();
			tDiff = tDiff - NuN_IgnoreUpdate.time;
			if ( tDiff < 0.75 ) then
				local func = NuN_IgnoreUpdate.func;
				func( NuN_IgnoreUpdate.name );
			else
				NuN_IgnoreUpdate.func = nil;
				NuN_IgnoreUpdate.name = nil;
				NuN_IgnoreUpdate.time = 0;
			end
		end

	-- this really needs tidying up, but I can't do it without testing :(
	elseif ( event == "PLAYER_ENTERING_WORLD" ) then
		if ( ( pFaction == nil ) or ( NuN_horde == nil ) ) then
			NuN_getFaction();
		end
		if ( ( pFaction ) and ( NuN_horde ) ) then
			NuN_AttemptedFriendIgnores = 0;
			fBusy = NuN_Update_Friends();
			iBusy = NuN_Update_Ignored();
		end

	-- update Friend notes
	elseif ( event == "FRIENDLIST_UPDATE" ) then
		if ( NuN_FriendUpdate.func ) then
			local tDiff = GetTime();
			tDiff = tDiff - NuN_FriendUpdate.time;
			if ( tDiff < 0.75 ) then
				local func = NuN_FriendUpdate.func;
				func( NuN_FriendUpdate.name );
			else
				NuN_FriendUpdate.func = nil;
				NuN_FriendUpdate.name = nil;
				NuN_FriendUpdate.time = 0;
			end
		end

	-- player levelling up notes
	elseif ( ( event == "PLAYER_LEVEL_UP" ) and ( NuNSettings[pKey].autoN ) ) then
		local newLevel = arg1;
		local oldLevel = newLevel - 1;
		local levelUpName = pName.." "..oldLevel.." - "..newLevel;
		if ( not NuNDataRNotes[levelUpName] ) then
			NuNF.NuN_CreateLevelUpNote(levelUpName, newLevel, arg2, arg3, arg5, arg6, arg7, arg8, arg9);
		end

	-- Mainly for auto noting people you Party with, and counting the number of times you have partied with them
	elseif ( ( event == "PARTY_MEMBERS_CHANGED" ) or ( event == "RAID_ROSTER_UPDATE" ) ) then
		if ( NuNSettings[pKey].autoP ) then
			NuN_ProcessParty();
		end

	elseif ( ( not NuN_State.NuN_QuestsUpdating ) and ( not NuN_State.NuN_AtStartup ) and ( event == "QUEST_LOG_UPDATE" ) ) then
		local hideFrame = nil;
		if ( ( NuNGNoteFrame:IsVisible() ) and ( NUN_NOTETYPES[NuNGNoteFrame.type].Command == "QST" ) ) then
--			NuNGNoteFrame:Hide();
			hideFrame = true;
		end
		-- i.e. if we have just clicked on a Quest Frame Accept button (NOT Quest Log.... Quest Frame)
		if ( NuN_QuestAccepted ) then
			local qHeader = nil;
			local qCollapsed = nil;
			local qIndex, qLevel, qTag, qComplete = NuNF.NuN_CheckQuestList(NuN_QuestAccepted);
			if ( qIndex > 0 ) then
				if ( hideFrame ) then NuNGNoteFrame:Hide(); end
				NuNF.NuN_ProcessQuest(NuN_QuestAccepted, qLevel, qTag, qHeader, qCollapsed, qComplete, qIndex, "Accepted");
			end
			NuN_QuestAccepted = nil;
			return;
		end
		if ( NuN_State.NuN_IgnoreNextQUpdate ) then
			NuN_State.NuN_IgnoreNextQUpdate = nil;
		elseif ( ( not NuN_QLF ) or ( not NuN_QLF:IsVisible() ) ) then
--			if ( hideFrame ) then NuNGNoteFrame:Hide(); end
			NuNF.NuN_UpdateQuestNotes(event);
		end

	-- This could be a problem if it gets triggered for every member in the Guild.... but if it gets triggered once when the Guild Roster is updated as a whole, then OK....
	elseif ( event == "GUILD_ROSTER_UPDATE" ) then
		if ( ( pKey ) and ( NuNSettings[pKey] ) and ( NuNSettings[pKey].autoGuildNotes ) ) then
			if ( NuN_State.NuN_forceGR ) then
				NuN_State.NuN_forceGR = false;
				if ( NuNSettings[pKey].autoGRVerbose ) then
					NuN_GuildRefresh("Startup");
				else
					NuN_GuildRefresh();
				end

			else
				NuN_GuildRefresh( NuNSettings[pKey].autoGRVerbose );
			end
		end

	elseif ( event == "INSPECT_TALENT_READY" ) then
		NuNF.QueryTalents();

	end
end


-- Lots of Drop Down Box set up routines

function NuNPRatingDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNPRatingsDropDown, NuNF.NuNPRatingsDropDown_Initialise);
	UIDropDownMenu_SetWidth(109);
end

function NuNF.NuNPRatingsDropDown_Initialise()
	if ( NuNSettings.ratings ) then
		local info = UIDropDownMenu_CreateInfo();
		for i=1, getn(NuNSettings.ratings), 1 do					-- #
			info.func = NuNF.NuNPRatingsButton_OnClick;
			info.text = NuNSettings.ratings[i];
			info.tooltipTitle = NuNSettings.ratings[i];
			info.tooltipText = NUN_CHANGE_RATING;
			info.checked = nil;
			UIDropDownMenu_AddButton(info);
		end
	end
end

-- RatingModifier
function NuNF.NuNPRatingsButton_OnClick()
	chosenRating = this:GetID();
	oldRating = UIDropDownMenu_GetSelectedID( NuNPRatingDropDown );
	if ( chosenRating == oldRating ) then
		oldRating = true;
	else
		oldRating = false;
	end
	ratingChosen = false;

	if ( IsControlKeyDown() ) then
		if ( chosenRating < maxRatings ) then
			StaticPopup_Show("NUN_CHANGE_RATING_ONE");
		end

	elseif ( IsAltKeyDown() ) then
		if ( chosenRating < maxRatings ) then
			NuNSettings.ratings[chosenRating] = NUN_ORATINGS[chosenRating];
			NuNSettings.ratingsT[chosenRating] = NUN_ORATINGS_TEXT[chosenRating];
			NuNSettings.ratingsBL[chosenRating] = 0;
			NuN_SetupRatings();
			curRatingTxt = UIDropDownMenu_GetText( NuNPRatingDropDown );
			if ( ( curRatingTxt ) and ( curRatingTxt ~= "" ) and ( oldRating ) ) then
				UIDropDownMenu_SetText( NUN_ORATINGS[chosenRating], NuNPRatingDropDown );
			end
		end

	else
		UIDropDownMenu_SetSelectedID(NuNPRatingDropDown, chosenRating);
		ddBoxes.ddPRating = chosenRating;
		lastDD = "PRating";
		NuNButtonClrDD:Enable();
		if ( BlackList ) then
			NuN_BlackList(c_name, chosenRating);
		end
	end
end



function NuNHRaceDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNHRaceDropDown, NuNF.NuNHRaceDropDown_Initialise);
	UIDropDownMenu_SetWidth(71);
end

function NuNF.NuNHRaceDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_HRACES), 1 do				-- #NUN_HRACES
		info.func = NuNF.NuNHRaceButton_OnClick;
		info.text = NUN_HRACES[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNHRaceButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNHRaceDropDown, this:GetID());
	ddBoxes.ddRace = this:GetID();
	lastDD = "Race";
	NuNButtonClrDD:Enable();
end

function NuNARaceDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNARaceDropDown, NuNF.NuNARaceDropDown_Initialise);
	UIDropDownMenu_SetWidth(71);
end

function NuNF.NuNARaceDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_ARACES), 1 do				-- #NUN_ARACES
		info.func = NuNF.NuNARaceButton_OnClick;
		info.text = NUN_ARACES[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNARaceButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNARaceDropDown, this:GetID());
	ddBoxes.ddRace = this:GetID();
	lastDD = "Race";
	NuNButtonClrDD:Enable();
end



function NuNHClassDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNHClassDropDown, NuNF.NuNHClassDropDown_Initialise);
	UIDropDownMenu_SetWidth(70);
end

function NuNF.NuNHClassDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_HCLASSES), 1 do						 -- #NUN_HCLASSES
		info.func = NuNF.NuNHClassButton_OnClick;
		info.text = NUN_HCLASSES[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNHClassButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNHClassDropDown, this:GetID());
	ddBoxes.ddClass = this:GetID();
	lastDD = "Class";
	NuNButtonClrDD:Enable();
end

function NuNAClassDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNAClassDropDown, NuNF.NuNAClassDropDown_Initialise);
	UIDropDownMenu_SetWidth(70);
end

function NuNF.NuNAClassDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_ACLASSES), 1 do						-- #NUN_ACLASSES
		info.func = NuNF.NuNAClassButton_OnClick;
		info.text = NUN_ACLASSES[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNAClassButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNAClassDropDown, this:GetID());
	ddBoxes.ddClass = this:GetID();
	lastDD = "Class";
	NuNButtonClrDD:Enable();
end



function NuNSexDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNSexDropDown, NuNF.NuNSexDropDown_Initialise);
	UIDropDownMenu_SetWidth(70);
end

function NuNF.NuNSexDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_SEXES), 1 do						-- #NUN_SEXES
		info.func = NuNF.NuNSexButton_OnClick;
		info.text = NUN_SEXES[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNSexButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNSexDropDown, this:GetID());
	ddBoxes.ddSex = this:GetID();
	lastDD = "Sex";
	NuNButtonClrDD:Enable();
end



function NuNProf1DropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNProf1DropDown, NuNF.NuNProf1DropDown_Initialise);
	UIDropDownMenu_SetWidth(216);
end

function NuNF.NuNProf1DropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_PROFESSIONS), 1 do					-- #NUN_PROFESSIONS
		info.func = NuNF.NuNProf1Button_OnClick;
		info.text = NUN_PROFESSIONS[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNProf1Button_OnClick()
	UIDropDownMenu_SetSelectedID(NuNProf1DropDown, this:GetID());
	ddBoxes.ddProf1 = this:GetID();
	lastDD = "Prof1";
	NuNButtonClrDD:Enable();
end



function NuNProf2DropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNProf2DropDown, NuNF.NuNProf2DropDown_Initialise);
	UIDropDownMenu_SetWidth(216);
end

function NuNF.NuNProf2DropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_PROFESSIONS), 1 do					-- #NUN_PROFESSIONS
		info.func = NuNF.NuNProf2Button_OnClick;
		info.text = NUN_PROFESSIONS[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNProf2Button_OnClick()
	UIDropDownMenu_SetSelectedID(NuNProf2DropDown, this:GetID());
	ddBoxes.ddProf2 = this:GetID();
	lastDD = "Prof2";
	NuNButtonClrDD:Enable();
end



function NuNArenaRDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNArenaRDropDown, NuNF.NuNArenaRDropDown_Initialise);
	UIDropDownMenu_SetWidth(141);
end

function NuNF.NuNArenaRDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_ARENAR), 1 do
		info.func = NuNF.NuNArenaRButton_OnClick;
		info.text = NUN_ARENAR[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNArenaRButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNArenaRDropDown, this:GetID());
	ddBoxes.ddArena = this:GetID();
	lastDD = "Arena";
	NuNButtonClrDD:Enable();
end



function NuNHHRankDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNHHRankDropDown, NuNF.NuNHHRankDropDown_Initialise);
	UIDropDownMenu_SetWidth(141);
end

function NuNF.NuNHHRankDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_HRANKS), 1 do						-- #NUN_HRANKS
		info.func = NuNF.NuNHHRankButton_OnClick;
		info.text = NUN_HRANKS[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNHHRankButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNHHRankDropDown, this:GetID());
	ddBoxes.ddHRank = this:GetID();
	lastDD = "HRank";
	NuNButtonClrDD:Enable();
end

function NuNAHRankDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNAHRankDropDown, NuNF.NuNAHRankDropDown_Initialise);
	UIDropDownMenu_SetWidth(141);
end

function NuNF.NuNAHRankDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_ARANKS), 1 do						-- #NUN_ARANKS
		info.func = NuNF.NuNAHRankButton_OnClick;
		info.text = NUN_ARANKS[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNAHRankButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNAHRankDropDown, this:GetID());
	ddBoxes.ddHRank = this:GetID();
	lastDD = "HRank";
	NuNButtonClrDD:Enable();
end


function NuNOptionsSearchDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNOptionsSearchDropDown, NuNF.NuNOptionsSearchDropDown_Initialise);
	UIDropDownMenu_SetWidth(165);
end

function NuNF.NuNOptionsSearchDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_SEARCHFOR), 1 do						-- #NUN_SEARCHFOR
		info.func = NuNF.NuNOptionsSearchDropDown_OnClick;
		info.text = NUN_SEARCHFOR[i].Display;
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNOptionsSearchDropDown_OnClick()
	UIDropDownMenu_SetSelectedID(NuNOptionsSearchDropDown, this:GetID());
	ddBoxes.ddSearch = this:GetID();
end



function NuNSearchClassDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNSearchClassDropDown, NuNF.NuNSearchClassDropDown_Initialise);
	UIDropDownMenu_SetWidth(204);
end

function NuNF.NuNSearchClassDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_ALLCLASSES), 1 do						-- #NUN_ALLCLASSES
		info.func = NuNF.NuNSearchClassButton_OnClick;
		info.text = NUN_ALLCLASSES[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNSearchClassButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNSearchClassDropDown, this:GetID());
	ddClassSearch = this:GetID();
	ddBoxes.ddSearch = NuNGet_CommandID(NUN_SEARCHFOR, "Class");
	searchType = "Class";
	NuNSearch_Search();
end



function NuNSearchProfDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNSearchProfDropDown, NuNF.NuNSearchProfDropDown_Initialise);
	UIDropDownMenu_SetWidth(204);
end

function NuNF.NuNSearchProfDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_PROFESSIONS), 1 do						-- #NUN_PROFESSIONS
		info.func = NuNF.NuNSearchProfButton_OnClick;
		info.text = NUN_PROFESSIONS[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNSearchProfButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNSearchProfDropDown, this:GetID());
	ddProfSearch = this:GetID();
	ddBoxes.ddSearch = NuNGet_CommandID(NUN_SEARCHFOR, "Profession");
	searchType = "Profession";
	NuNSearch_Search();
end


-- 5.60 Allow viewing of Quest History for other Alts
function NuNSearchQHDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNSearchQHDropDown, NuNF.NuNSearchQHDropDown_Initialise);
	UIDropDownMenu_SetWidth(204, NuNSearchQHDropDown);				-- 5.60 Need to specify Frame as not called from its own _OnLoad script
end

function NuNF.NuNSearchQHDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(AltArray), 1 do
		info.func = NuNF.NuNSearchQHButton_OnClick;
		info.text = AltArray[i].displayName;						-- 5.60  Make sure AltArray[1] = pName
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNSearchQHButton_OnClick()
	ddQHSearch = this:GetID();
	UIDropDownMenu_SetSelectedID(NuNSearchQHDropDown, ddQHSearch);
	qhKey = AltArray[ddQHSearch].realm;
	qhName = AltArray[ddQHSearch].name;
	qhI = ddQHSearch;
	qhT = AltArray[ddQHSearch].displayName;
	NuNQuestHistory = NuNData[qhKey].QuestHistory[qhName];
--	ddBoxes.ddSearch = NuNGet_CommandID(NUN_SEARCHFOR, "Quest History");		-- no need to update this, should already be Quest History command...
--	searchType = "Quest History";
	NuN_FetchQuestHistory();
end



function NuNChatDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNChatDropDown, NuNF.NuNChatDropDown_Initialise);
	UIDropDownMenu_SetWidth(110);
end

function NuNF.NuNChatDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_TRANSMITTO), 1 do							-- #NUN_TRANSMITTO
		info.func = NuNF.NuNChatButton_OnClick;
		info.text = NUN_TRANSMITTO[i].Display;
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNChatButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNChatDropDown, this:GetID());
	sendTo = NUN_TRANSMITTO[this:GetID()].Command;
	if ( sendTo == "WHISPER" ) or ( sendTo == "NuN" ) then
		NuNChatTextBox:SetText("");
		NuNChatTextBox:Show();
		NuNTransmit:Disable();
		NuNChannelDropDown:Hide();
	elseif ( sendTo == "CHANNEL" ) then
		NuNChatTextBox:Hide();
		NuNTransmit:Disable();
		NuNChannelDropDown:Show();
	else
		if ( NuNChatTextBox:IsVisible() ) then
			NuNChatTextBox:Hide();
		end
		if ( NuNChannelDropDown:IsVisible() ) then
			NuNChannelDropDown:Hide();
		end
		if ( busySending.active ) then
			NuNTransmit:Disable();
		else
			NuNTransmit:Enable();
		end
	end
end

function NuNChannelDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNChannelDropDown, NuNF.NuNChannelDropDown_Initialise);
	UIDropDownMenu_SetWidth(175);
end

function NuNF.NuNChannelDropDown_Initialise()
	local counter = 1;
	local channelArray = { GetChannelList() };
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(channelArray), 2 do						-- #channelArray
		local cIndex, cName = GetChannelName(channelArray[i]);
		info.func = NuNF.NuNChannelButton_OnClick;
		info.text = channelArray[i]..". "..cName;
		info.arg1 = channelArray[i];
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNChannelButton_OnClick(a1)
	UIDropDownMenu_SetSelectedID(NuNChannelDropDown, this:GetID());
	sendToChannel.id = a1;
	sendToChannel.name = this:GetText();
	if ( busySending.active ) then
		NuNTransmit:Disable();
	else
		NuNTransmit:Enable();
	end
end

function NuNGTypeDropDown_OnLoad()
	UIDropDownMenu_Initialize(NuNGTypeDropDown, NuNF.NuNGTypeDropDown_Initialise);
	UIDropDownMenu_SetWidth(70);
end

function NuNF.NuNGTypeDropDown_Initialise()
	local info = UIDropDownMenu_CreateInfo();
	for i=1, getn(NUN_NOTETYPES), 1 do							-- #NUN_NOTETYPES
		info.func = NuNF.NuNGTypeButton_OnClick;
		info.text = NUN_NOTETYPES[i].Display;
		info.checked = nil;
		UIDropDownMenu_AddButton(info);
	end
end

function NuNF.NuNGTypeButton_OnClick()
	UIDropDownMenu_SetSelectedID(NuNGTypeDropDown, this:GetID());
	NuNGNoteFrame.type = this:GetID();
	if ( NUN_NOTETYPES[NuNGNoteFrame.type].Command == "NPC" ) then
		NuNNPCTargetButton:Show();
	else
		NuNNPCTargetButton:Hide();
	end
end


-- This function is for changing the details of the User Definable Buttons on the Contact Note Frame
function NuNEditDetails()
	local prntObj;
	local prntTxtObj;

	local newTxt = (NuNEditDetailsBox:GetText());

	if (newTxt ~= oriTxt) then
		local chldObj = getglobal("NuNInforButton"..bttnNumb);
		if ((newTxt == "") and (isTitle)) or ((newTxt == nil) and (isTitle)) then
			getglobal("NuNInforButton"..bttnNumb.."ButtonTextDetail"):SetText("");		-- 5.60
			chldObj:Disable();
		else
			chldObj:Enable();
		end
		bttnTxtObj:SetText(newTxt);

		if (isTitle) then
			if ( NuNEditDetail_CheckButton:GetChecked() ) then
				hdNbr = pHead..bttnNumb;
				nameHdNbr = c_name..hdNbr;
				if (not NuNSettings[pKey][hdNbr]) then
					NuNSettings[pKey][hdNbr] = {};
				end
				NuNSettings[pKey][hdNbr].txt = newTxt;
				if ( NuNDataPlayers[nameHdNbr] ) then	-- As we have set a new Account Default while viewing this Player, then nil any Player specific setting for this player
					NuNDataPlayers[nameHdNbr] = nil;	-- this does not reset all player specific settings.
				end
			else
				index = tonumber(bttnNumb);
				if ( ( newTxt == "" ) or ( newTxt == nil ) ) then
					bttnChanges[index] = -1;						-- 5.60 Use -1 to flag blank
				else
					bttnChanges[index] = newTxt;
				end
			end
		else
			index = bttnNumb + detlOffset;
			if ( newTxt == "" ) then
				bttnChanges[index] = -1;							-- 5.60 Use -1 to flag blank
			else
				bttnChanges[index] = newTxt;
			end
			if ( index == (detlOffset + 1) ) then					-- really not sure if this setting of c_guild is necessary; seems a cart before horse way of setting the data.... ?
				prntTxtObj = getglobal("NuNTitleButton"..bttnNumb.."ButtonTextHeading");
				if ( prntTxtObj:GetText() == NUN_DFLTHEADINGS[1] ) then
					c_guild = newTxt;
				end
			end
		end
		NuNButtonSaveNote:Enable();
		NuNEditDetailsFrame:Hide();
	else
		NuNButtonSaveNote:Enable();
		NuNEditDetailsFrame:Hide();
	end
end



-- User Definable Buttons on Click
function NuNUserButton_OnClick(bttn)
	local bttnName = bttn:GetName();
	local prfx = (string.sub(bttnName,  1, 8));

	bttnNumb = (string.sub(bttnName, 15,  15));

	if (prfx == "NuNTitle") then
		isTitle = true;
		bttnTxtObj = getglobal(bttnName.."ButtonTextHeading");
	else
		isTitle = false;
		bttnTxtObj = getglobal(bttnName.."ButtonTextDetail");
	end
	oriTxt = bttnTxtObj:GetText();

	NuNEditDetails_ShowFrame(isTitle);
end


-- for editing User Definable Buttons
function NuNEditDetails_ShowFrame(isTitle)
	NuNButtonSaveNote:Disable();

	NuNText:ClearFocus();
	if (oriTxt == nil) then
		NuNEditDetailsBox:SetText("");
	else
		NuNEditDetailsBox:SetText(oriTxt);
	end
	if (isTitle) then
		NuNCheckBoxLabel:SetText("Save as Default");
		NuNEditDetail_CheckButton:SetChecked(0);
		NuNEditDetailsRestoreButton:Enable();
		NuNEditDetail_CheckButton:Show();
		NuNEditDetailsRestoreButton:Show();
	else
		NuNCheckBoxLabel:SetText("");
		NuNEditDetail_CheckButton:Hide();
		NuNEditDetailsRestoreButton:Hide();
	end
	NuNEditDetailsFrame:Show();
	NuNEditDetailsBox:SetFocus();
end



function NuN_EditDetailCheckButtonOnClick()
	if ( NuNEditDetail_CheckButton:GetChecked() ) then
		NuNEditDetailsRestoreButton:Disable();
	else
		NuNEditDetailsRestoreButton:Enable();
	end
end



function NuNEditDetailsRestore()
	nameHdNbr = c_name..pHead..bttnNumb;
	if ( NuNDataPlayers[nameHdNbr] ) then
		NuNDataPlayers[nameHdNbr] = nil;
	end
	NuNButtonSaveNote:Enable();
	NuNEditDetailsFrame:Hide();
	NuNEditDetailsFrame:Hide();
	NuNFrame:Hide();
	NuN_ShowNote();
end





-------------------------------------------------------------------------------------------
-- Succesful Function Hooks



function NuNNew_FriendsFrameFriendButton_OnClick(button)
 	if ( ( button == "LeftButton" ) and ( NuNFrame:IsVisible() ) ) then
 		NuNEditDetailsFrame:Hide();
		NuNFrame:Hide();
 		NuN_ShowFriendNote();
 	end
end

function NuNNew_FriendsFrameIgnoreButton_OnClick()
	if ( NuNFrame:IsVisible() ) then
		NuNEditDetailsFrame:Hide();
		NuNFrame:Hide();
		NuN_ShowIgnoreNote();
	end
end

function NuNNew_FriendsFrameGuildStatusButton_OnClick(button)
	if ( ( button == "LeftButton" ) and ( NuNFrame:IsVisible() ) ) then
		NuNEditDetailsFrame:Hide();
		NuNFrame:Hide();
		NuN_ShowGuildNote();
	end
end

function NuNNew_FriendsFrameWhoButton_OnClick(button)
	if ( ( button == "LeftButton" ) and ( NuNFrame:IsVisible() ) ) then
		NuNEditDetailsFrame:Hide();
		NuNFrame:Hide();	
		NuN_ShowWhoNote(WhoFrame.selectedName);
	end
end

function NuNNew_FriendsList_Update()
	local bttnIndx;

	for i = 1, 10, 1 do
		bttnIndx = getglobal("NuN_FriendNotesButton"..i);
		NuN_UpdateNoteButton(bttnIndx, i, "F");
	end
end

function NuNNew_IgnoreList_Update()
	local bttnIndx;

	for i = 1, 20, 1 do
		bttnIndx = getglobal("NuN_IgnoreNotesButton"..i);
		NuN_UpdateNoteButton(bttnIndx, i, "I");
	end
end

function NuNNew_GuildStatus_Update()
	local bttnIndx;

	for i = 1, 13, 1 do
		bttnIndx = getglobal("NuN_GuildSNotesButton"..i);
		NuN_UpdateNoteButton(bttnIndx, i, "GS");
		bttnIndx = getglobal("NuN_GuildNotesButton"..i);
		NuN_UpdateNoteButton(bttnIndx, i, "G");
	end
end

function NuNNew_WhoList_Update()
	local bttnIndx;

	for i = 1, 17, 1 do
		bttnIndx = getglobal("NuN_WhoNotesButton"..i);
		NuN_UpdateNoteButton(bttnIndx, i, "W");
	end
end

function NuNNew_QuestLog_Update()
	local bttnIndx;

	NuNF.NuN_QuestLogButtons();
	
	for i = 1, NuNC.NUN_QUESTLOG_BUTTONS, 1 do
		bttnIndx = getglobal("NuN_QuestNotesButton"..i);
		if ( bttnIndx ) then
			NuN_UpdateNoteButton(bttnIndx, i, NuNC.NUN_QUEST_C);
		else
--			NuN_Message(NuNC.NUN_QUESTLOG_BUTTONS .. " | " .. i);
		end
	end
end

function NuNNew_LFMFrame_Update()
	local bttnIndx;
	
	for i = 1, 14, 1 do
		bttnIndex = getglobal("NuN_LFMFrameNotesButton"..i);
		NuN_UpdateNoteButton(bttnIndex, i, "L");
	end
end


function NuN_AH_BrowseButton_OnClick(...)
	NuNHooks.NuNOri_AH_BrowseButtonItem_OnClick(...);

	if ( ( NuNSettings[pKey].modifier == "on" ) and ( IsNuNModifierKeyDown(arg1) ) ) then
		this = this:GetParent();
		local itmLink = GetAuctionItemLink("list", this:GetID() + FauxScrollFrame_GetOffset(BrowseScrollFrame));
		itmLink = string.gsub(itmLink, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\|", ":0:0:0:0:0:0:0|");
		itmLink = string.gsub(itmLink, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\124", ":0:0:0:0:0:0:0\124");

		if ( ( itmLink ~= nil ) and ( itmLink ~= "" ) ) then
			if ( ( NuNGNoteFrame:IsVisible() ) or ( NuNFrame:IsVisible() ) ) then
				if ( NuNGNoteFrame:IsVisible() ) then
					NuNGNoteTextScroll:Insert(itmLink);				-- + v5.00.11200
					StackSplitFrame:Hide();
					return true;
				elseif ( NuNFrame:IsVisible() ) then
					NuNText:Insert(itmLink);					-- + v5.00.11200
					StackSplitFrame:Hide();
					return true;
				end
			else
				NuNGNoteFrame.fromQuest = nil;
				if ( NuNData[itmIndex][itmLink] ) then
					itmLink = ( NuNData[itmIndex][itmLink] );
				end
				if ( ( NuNDataRNotes[itmLink] ) or ( NuNDataANotes[itmLink] ) ) then
					c_note = itmLink;
					NuN_ShowSavedGNote();
					StackSplitFrame:Hide();
					return true;
				else
					NuNF.NuN_GNoteFromItem(itmLink, "GameTooltip");
					StackSplitFrame:Hide();
					return true;
				end
			end
		end
	end
end

function NuNNew_ContainerFrameItemButton_OnModifiedClick(button)
	if ( ( NuNSettings[pKey].modifier == "on" ) and ( IsNuNModifierKeyDown(button) ) ) then
		if ( ( receiptPending ) and ( NuN_Receiving.type == "General" ) ) then

		else
			local itmLink = GetContainerItemLink( this:GetParent():GetID(), this:GetID() );
			itmLink = string.gsub(itmLink, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\|", ":0:0:0:0:0:0:0|");
			itmLink = string.gsub(itmLink, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\124", ":0:0:0:0:0:0:0\124");

			if ( ( itmLink ~= nil ) and ( itmLink ~= "" ) ) then
				if ( ( NuNGNoteFrame:IsVisible() ) or ( NuNFrame:IsVisible() ) ) then
					if ( NuNGNoteFrame:IsVisible() ) then
						NuNGNoteTextScroll:Insert(itmLink);				-- + v5.00.11200
						StackSplitFrame:Hide();
						return true;
					elseif ( NuNFrame:IsVisible() ) then
						NuNText:Insert(itmLink);					-- + v5.00.11200
						StackSplitFrame:Hide();
						return true;
					end
				else
					NuNGNoteFrame.fromQuest = nil;
					if ( NuNData[itmIndex][itmLink] ) then
						itmLink = ( NuNData[itmIndex][itmLink] );
					end
					if ( ( NuNDataRNotes[itmLink] ) or ( NuNDataANotes[itmLink] ) ) then
						c_note = itmLink;
						NuN_ShowSavedGNote();
						StackSplitFrame:Hide();
						return true;
					else
						NuNF.NuN_GNoteFromItem(itmLink, "GameTooltip");
						StackSplitFrame:Hide();
						return true;
					end
				end
			end
		end
	
	else
		NuNHooks.NuNOri_ContainerFrameItemButton_OnModifiedClick(button);
	end
end

function NuNNew_SetItemRef(link, text, button)
	if ( NuNSettings[pKey].modifier == "on" ) then
		if ( ( receiptPending ) and ( NuN_Receiving.type == "General" ) ) then

		elseif ( strsub(link, 1, 6) == "player" ) then
			local name = string.sub(link, 8);
			if ( name and (string.len(name) > 0) ) then
				local uid = string.find(name, ":");
				if ( uid ) then
					name = string.sub(name, 1, uid-1);
				end
				if ( IsNuNModifierKeyDown(button) ) then
					if ( NuNDataPlayers[name] ) then
						NuN_ShowSavedNote(name);
					else
						NuN_CreateContact(name, pFaction);
					end
					if ( DEFAULT_CHAT_FRAME.editBox ) then
						ChatEdit_OnEscapePressed(DEFAULT_CHAT_FRAME.editBox);
					end

				elseif ( IsModifiedClick("CHATLINK") ) then
					local NuN_staticPopup = StaticPopup_Visible("ADD_IGNORE");
					if ( not NuN_staticPopup ) then NuN_staticPopup = StaticPopup_Visible("ADD_IGNORE"); end
					if ( not NuN_staticPopup ) then NuN_staticPopup = StaticPopup_Visible("ADD_MUTE"); end
					if ( not NuN_staticPopup ) then NuN_staticPopup = StaticPopup_Visible("ADD_FRIEND"); end
					if ( not NuN_staticPopup ) then NuN_staticPopup = StaticPopup_Visible("ADD_GUILDMEMBER"); end
					if ( not NuN_staticPopup ) then NuN_staticPopup = StaticPopup_Visible("ADD_TEAMMEMBER"); end
					if ( not NuN_staticPopup ) then NuN_staticPopup = StaticPopup_Visible("ADD_RAIDMEMBER"); end
					if ( ( not NuN_staticPopup ) and ( not ChatFrameEditBox:IsVisible() ) and ( NuNDataPlayers[name] ) ) then
						ttName = name;
						NuN_ClearPinnedTT();
						NuN_PinnedTooltip:SetOwner(this, "ANCHOR_RIGHT");
						NuN_State.NuN_PinUpHeader = true;
						NuN_PinnedTooltip.type = "Contact";
						NuNSettings[pKey].pT = {};
						NuNSettings[pKey].pT.type = "Contact";
						NuNSettings[pKey].pT.name = ttName;
						NuNF.NuN_BuildTT(NuN_PinnedTooltip);
						NuN_State.NuN_PinUpHeader = false;
						NuN_PinnedTooltip:Show();
					end
				end
			end

		elseif ( IsNuNModifierKeyDown(button) ) then			-- 5.60
			text = string.gsub(text, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\|", ":0:0:0:0:0:0:0|");
			text = string.gsub(text, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\124", ":0:0:0:0:0:0:0\124");

			if ( ( NuNGNoteFrame:IsVisible() ) or ( NuNFrame:IsVisible() ) ) then
				if ( NuNGNoteFrame:IsVisible() ) then
					NuNGNoteTextScroll:Insert(text);					-- + v5.00.11200
					return;
				elseif ( NuNFrame:IsVisible() ) then
					NuNText:Insert(text);							-- + v5.00.11200
					return;
				end
				HideUIPanel(ItemRefTooltip);						
			else
				NuNGNoteFrame.fromQuest = nil;
				if ( NuNData[itmIndex][text] ) then
					text = ( NuNData[itmIndex][text] );
				end
				if ( ( NuNDataRNotes[text] ) or ( NuNDataANotes[text] ) ) then
					c_note = text;
					NuN_ShowSavedGNote();
					HideUIPanel(ItemRefTooltip);					
				else
					ItemRefTooltip:Show();
					if ( not ItemRefTooltip:IsVisible() ) then
						ItemRefTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE");
					end
					ItemRefTooltip:SetHyperlink(link);
					delayedItemTooltip = text;
				end
				return;
			end
		end
	end

	if ( ItemRefTooltip:IsVisible() ) then
		NuN_ItemRefTooltip_OnShow();
	end
end

function NuNNew_PaperDollItemSlotButton_OnModifiedClick(button)
	if ( NuNSettings[pKey].modifier == "on" ) then
		local itmLink;

		if ( ( receiptPending ) and ( NuN_Receiving.type == "General" ) ) then

		elseif ( IsNuNModifierKeyDown(button) ) then
			if ( ( InspectFrame ) and ( InspectFrame:IsVisible() ) ) then
				itmLink = GetInventoryItemLink("target", this:GetID());
			else
				itmLink = GetInventoryItemLink("player", this:GetID());
			end
			if ( ( itmLink ~= nil ) and ( itmLink ~= "" ) ) then
				itmLink = string.gsub(itmLink, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\|", ":0:0:0:0:0:0:0|");
				itmLink = string.gsub(itmLink, "\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\:%-*%d+\124", ":0:0:0:0:0:0:0\124");
				if ( ( NuNGNoteFrame:IsVisible() ) or ( NuNFrame:IsVisible() ) ) then
					if ( NuNGNoteFrame:IsVisible() ) then
						NuNGNoteTextScroll:Insert(itmLink);				-- + v5.00.11200
						return;
					elseif ( NuNFrame:IsVisible() ) then
						NuNText:Insert(itmLink);					-- + v5.00.11200
						return;
					end
				else
					NuNGNoteFrame.fromQuest = nil;
					if ( NuNData[itmIndex][itmLink] ) then
						itmLink = ( NuNData[itmIndex][itmLink] );
					end
					if ( ( NuNDataRNotes[itmLink] ) or ( NuNDataANotes[itmLink] ) ) then
						c_note = itmLink;
						NuN_ShowSavedGNote();
					else
						NuNF.NuN_GNoteFromItem(itmLink, "GameTooltip");
					end
					return;
				end
			end
		end
	end
end

function NuNNew_SetAbandonQuest()
	NuN_State.NuN_abandonQuest = GetAbandonQuestName();
end
-- 5.60 Removed the Quest Frame Item on click note creation hooks   2.2 nerfed them, and they weren't missed so didn't try to find out what the new function names would be....
--QuestLogFrameAbandonButton
function NuNNew_AbandonQuest()
	if ( NuN_State.NuN_abandonQuest ) then
		timeSinceLastUpdate = 0;
		NuN_State.NuN_IgnoreNextQUpdate = true;
		if ( NuNData[pKey].QuestHistory[pName][NuN_State.NuN_abandonQuest] ) then
			NuNData[pKey].QuestHistory[pName][NuN_State.NuN_abandonQuest].abandoned = true;
			if ( NuNQuestLog[NuN_State.NuN_abandonQuest] ) then
				NuNQuestLog[NuN_State.NuN_abandonQuest] = nil;
			end
		end
	end
end

function NuNNew_QuestDetailAcceptButton_OnClick()
	NuN_QuestAccepted = GetTitleText();
	if ( ( NuNSettings[pKey].autoMapNotes ) and ( NuNSettings[pKey].autoQ ) ) then
		NuN_MapNote("Target", NUN_QUEST_GIVER, "", 9);
	end
end

-- THIS is the important function for monitoring when Quests are handed in
function NuNNew_QuestRewardCompleteButton_OnClick()
	local q = GetTitleText();
	local i = 1;
	local f = 0;

	if ( NuNData[pKey].QuestHistory[pName][q] ) then
		local l_c_note = c_note;
		local l_c_name = c_name;
		local qChar = NuN_CheckTarget();
		if ( qChar == "N" ) then
			qChar = c_note;
		else
			qChar = "";
		end
		NuNData[pKey].QuestHistory[pName][q].handedIn = 1;
		for i = 1, 4, 1 do
			f = string.find(NuNData[pKey].QuestHistory[pName][q].txt, NuNC.NUN_FINISHED, (f+1) );
			if ( f == nil ) then
				f = i;
				break;
			end
		end
		if ( f < 4 ) then
			local qTxt = NuNF.NuN_GetDisplayText( NuNData[pKey].QuestHistory[pName][q].txt );
			qTxt = qTxt.."\n\n".. NuNC.NUN_FINISHED .."   "..qChar.."\n    "..NuNF.NuN_GetDateStamp().."\n    "..NuNF.NuN_GetLoc().."\n";
			NuNData[pKey].QuestHistory[pName][q].txt = NuNF.NuN_SetSaveText(qTxt);
		end
		c_note = l_c_note;
		c_name = l_c_name;
	end
end



function NuNNew_ChatFrame_MessageEventHandler(...)
	local processedByNuN = nil;
	local eventDetails = "" .. ( select(1, ...) );
	local localDbg = "";

	-- hook all necessary AddMessage functions for each chat frame
	if ( not this.NuNOri_AddMessage ) then
		this.NuNOri_AddMessage = this.AddMessage;
		this.AddMessage = NuNNew_AddMessage;
	end

	-- Suppress Friend not found messages when attempting to Befriend someone
	if ( ( eventDetails == "CHAT_MSG_SYSTEM" ) and ( arg1 == "ERR_FRIEND_NOT_FOUND" ) and ( NuN_AttemptedFriendIgnores > 0 ) ) then
		NuN_AttemptedFriendIgnores = NuN_AttemptedFriendIgnores - 1;
		if ( not NuNSettings[pKey].autoS ) then
			NuN_Message(ERR_FRIEND_NOT_FOUND);
		end
		processedByNuN = true;

	-- Suppress Ignore not found messages when attempting to Ignore someone
	elseif ( ( eventDetails == "CHAT_MSG_SYSTEM" ) and ( arg1 == "ERR_IGNORE_NOT_FOUND" ) and ( NuN_AttemptedFriendIgnores > 0 ) ) then
		NuN_AttemptedFriendIgnores = NuN_AttemptedFriendIgnores - 1;
		if ( not NuNSettings[pKey].autoS ) then
			NuN_Message(ERR_IGNORE_NOT_FOUND);
		end
		processedByNuN = true;

	-- if sending mutliple lines of a message to someone who is AFK or DND, then we don't want to receive MULTIPLE "X is AFK" messages echoed back to us - we only need to see 1 for each set of lines sent
	elseif ( ( ( eventDetails == "CHAT_MSG_AFK" ) or ( eventDetails == "CHAT_MSG_DND" ) ) and ( arg2 ) and ( arg2 == busySending.user ) ) then
		if ( busySending.counter > 0 ) then
			processedByNuN = true;
		end
		busySending.counter = 1;

	-- if waitng for a /who, then ignore Chat_msg_system messages that contain the name of the /who we were looking for...
	-- won't ignore more than 1 but shouldn't usually have > 1, and its only a chat message anyway so...
	elseif ( eventDetails == "CHAT_MSG_SYSTEM" ) then

		if ( type(arg1) == "string" ) then
			if ( ( NuN_WhoReturnStruct.func ) and ( string.find(arg1, NuN_WhoReturnStruct.name) ) ) then
				NuN_WhoReturnStruct.func();														-- 5.60
				NuN_WhoReturnStruct.func = nil;													-- 5.60
				NuN_WhoReturnStruct.name = nil;													-- 5.60
				NuN_WhoReturnStruct.timeLimit = nil;											-- 5.60
				NuN_WhoReturnStruct.secondTry = nil;
				if ( ( NuNSettings[pKey] ) and ( NuNSettings[pKey].alternativewho ) ) then
					SetWhoToUI(0);                                          					-- 5.60
					FriendsFrame:RegisterEvent("WHO_LIST_UPDATE");
				end
				processedByNuN = true;
				NuN_suppressExtraWho = true;

			elseif ( ( NuN_suppressExtraWho ) 
					and	 ( ( string.find(arg1, WHO_NUM_RESULTS) )
							or ( ( WHO_NUM_RESULTS_P1 ) and( string.find(arg1, WHO_NUM_RESULTS_P1) ) ) ) ) then
				processedByNuN = true;
				NuN_suppressExtraWho = nil;
			end
		end
			
	-- This is the bulk of the message parsing required to reconstruct notes sent from other players
	-- Multiple lines are needed to send NuN notes, and these lines are connected by a _msgKey which identifies them as a set
	-- NOTE 1 :	Only "Formatted" NotesUNeed transmissions contain the information examined below to allow note reconstruction
	--		Unformatted note transmissions, are just received as a normal sequence of chat messages
	-- NOTE 2 :	We ignore messages with a key that we have just sent to avoid receiving our own transmissions
	-- NuN_Receiving is an AddOn Global array variable holding all the relevant information about a Note being received from another user
	-- 5.60 THIS LIST OF TESTS BELOW MAY NEED ADDING TO GIVEN THE EXTRA SEND OPTIONS I TRIED TO INCLUDE...
--	elseif ( ( eventDetails == "CHAT_MSG_WHISPER" ) or 
--			 ( eventDetails == "CHAT_MSG_GUILD" ) or 
--			 ( eventDetails == "CHAT_MSG_PARTY" ) or 
--			 ( eventDetails == "CHAT_MSG_RAID" ) or 
--			 ( eventDetails == "CHAT_MSG_RAID_WARNING" ) or				-- 5.60
--			 ( eventDetails == "CHAT_MSG_SAY" ) or 						-- 5.60
--			 ( eventDetails == "CHAT_MSG_OFFICER" ) or					-- 5.60
--			 ( eventDetails == "CHAT_MSG_BATTLEGROUND" ) ) then			-- 5.60
	elseif ( type(arg1) == "string" ) then
		-- I think this suppresses echoing our own formatted messages as we send them
		if ( NuN_msgKey ) then
			local kLen = string.len(NuN_msgKey);
			local kTst = string.sub(arg1, 1, kLen);
			if ( kTst == NuN_msgKey ) then
				return;
			end
		end

		-- waiting for decision to receive a previous note which would have replaced an existing note
		if ( receiptPending ) then
--			processedByNuN = true;				-- ???  Stop processing OK, but why flag as processed and hide the message ???

		-- if in the middle of receiving a series of messages that complete a note, then parse it based on its type
		-- i.e. different line types hold different information, such as basic text, or Drop Down box contents, etc.,  Or control messages such as First message in a sequence / Final message in a sequence
		-- NOTE 1 :	Note transmission depends on ordered, sequential FIFO transmission of messages (i..e they will be received in the same sequence that they were sent for easy re-building of the original note)
		-- NOTE 2 :	NuN triggers a Timer when the first message in a sequence arrives, which is then monitored in OnUpdate.
		--		If a "Note Ends" type message (Line Type 4) isn't received within a certain amount of time, then the Note Receiving process is abandoned, and the user warned
		elseif ( NuN_Receiving.active ) then
			local lLineType = 0;
			if ( string.find(arg1, NuN_TransStrings[2][1]) ) then
				lLineType = 2;
			elseif ( string.find(arg1, NuN_TransStrings[2][2]) ) then
				lLineType = 2;
			elseif ( string.find(arg1, NuNC.NUN_SOURCE) ) then
				lLineType = 3;
			elseif ( string.find(arg1, NuN_TransStrings[3][1]) ) then
				lLineType = 4;
			elseif ( string.find(arg1, NuN_TransStrings[3][2]) ) then
				lLineType = 4;
			end
		
			-- LineType 4 : Signifies Last Message in sequence, and the note can now be created
			if ( ( lLineType == 4 ) and ( NuN_Receiving.version ) ) then
				NuN_Receiving.log = NuN_Receiving.log.."\n"..arg1;			-- NuN Creates a NuN Log type note recording the last 10 transmitted/received notes for tracking / debugging purposes
				NuN_CreateReceivedNote();
				if ( not receiptPending ) then
					NuN_Receiving = {};
					NuN_uCount = 999;
					NuN_tCount = 999;
					receiptDeadline = defaultReceiptDeadline;
				end
				processedByNuN = true;
				NuN_Receiving.timer = 0;

			-- LineType 2 : identifies whether the note being sent is for a Contact or a General Note, and the Name under which the note should be saved
			elseif ( ( lLineType == 2 ) and ( NuN_Receiving.version ) ) then
				NuN_Receiving.log = NuN_Receiving.log.."\n"..arg1;			-- NuN Creates a NuN Log type note recording the last 10 transmitted/received notes for tracking / debugging purposes
				local nameStart = string.find(arg1, ": Contact : ");
				if ( nameStart ) then
					NuN_Receiving.type = "Contact";
					nameStart = nameStart + 12;
					NuN_Receiving.title = string.sub(arg1, nameStart);
					processedByNuN = true;
					NuN_Receiving.timer = 0;
				else
					nameStart = string.find(arg1, ": General");
					if ( nameStart ) then
						NuN_Receiving.type = "General";
						NuN_Receiving.subtype = tonumber( string.sub(arg1, nameStart+10, nameStart+10) );
						nameStart = nameStart + 15;
						NuN_Receiving.title = string.sub(arg1, nameStart);
						processedByNuN = true;
						NuN_Receiving.timer = 0;
					end
				end

			-- LineType 3 : Control message specifying the client language of the Sender, and the version of NotesUNeed they use
			-- Transmission of notes between different versions of NuN needed to be handled
			elseif ( lLineType == 3 ) then
				NuN_Receiving.log = NuN_Receiving.log.."\n"..arg1;			-- NuN Creates a NuN Log type note recording the last 10 transmitted/received notes for tracking / debugging purposes
				local split = string.find(arg1, "v");
				NuN_Receiving.lang = strsub(arg1, NuNC.NUN_SOURCE_LEN+NuN_Receiving.pos+1, split-2);
				NuN_Receiving.version = strsub(arg1, split+1);
				processedByNuN = true;
				NuN_Receiving.timer = 0;

			elseif  ( NuN_Receiving.version ) then
			-- The MAIN Body of the message is flagged with a message key prefix to identify chat messages that need to be included in the Note. They are not assigned a 'global' line type in the above sequence
			-- Line Type below is determined by a Text flag in the message at NuN_Receiving.pos + 1 ;p
				local msgPrefix = strsub(arg1, 1, NuN_Receiving.pos);
				if ( msgPrefix == NuN_Receiving.prefix ) then
					NuN_Receiving.log = NuN_Receiving.log.."\n"..arg1;			-- NuN Creates a NuN Log type note recording the last 10 transmitted/received notes for tracking / debugging purposes
					local lineType = strsub(arg1, NuN_Receiving.pos+1, NuN_Receiving.pos+1);
					local lineData = strsub(arg1, NuN_Receiving.pos+3);

					-- LineType "G" : Information from the Drop Down boxes in a Contact Note
					if ( lineType == "G" ) then
						if ( string.find(arg1, "Horde" ) ) then
							NuN_Receiving.faction = "Horde";
						else
							NuN_Receiving.faction = "Alliance";
						end
						local tBeg = string.find(arg1, "<");
						local tEnd = string.find(arg1, ">");
						if ( ( tBeg ) and ( tEnd ) ) then
							value = "0";
							local nextOne = string.find(arg1, ",", tBeg);
							local value = string.sub(arg1, tBeg+1, nextOne-1);
							if ( value > "0" ) then
								NuN_Receiving.race = tonumber(value);
							end
							value = "0";
							tBeg = nextOne+1;
							nextOne = string.find(arg1, ",", tBeg);
							value = string.sub(arg1, tBeg, nextOne-1);
							if ( value > "0" ) then
								NuN_Receiving.class = tonumber(value);
							end
							value = "0";
							tBeg = nextOne+1;
							nextOne = string.find(arg1, ",", tBeg);
							value = string.sub(arg1, tBeg, nextOne-1);
							if ( value > "0" ) then
								NuN_Receiving.sex = tonumber(value);
							end
							value = "0";
							tBeg = nextOne+1;
							nextOne = string.find(arg1, ",", tBeg);
							value = string.sub(arg1, tBeg, nextOne-1);
							if ( value > "0" ) then
								NuN_Receiving.prating = tonumber(value);
							end
							value = "0";
							tBeg = nextOne+1;
							nextOne = string.find(arg1, ",", tBeg);
							value = string.sub(arg1, tBeg, nextOne-1);
							if ( value > "0" ) then
								NuN_Receiving.prof1 = tonumber(value);
							end
							value = "0";
							tBeg = nextOne+1;
							nextOne = string.find(arg1, ",", tBeg);
							value = string.sub(arg1, tBeg, nextOne-1);
							if ( value > "0" ) then
								NuN_Receiving.prof2 = tonumber(value);
							end
							value = "0";
							tBeg = nextOne+1;
							nextOne = string.find(arg1, ",", tBeg);
							value = string.sub(arg1, tBeg, nextOne-1);
							if ( value > "0" ) then
								NuN_Receiving.arena = tonumber(value);
							end
							value = "0";
							tBeg = nextOne+1;
							nextOne = string.find(arg1, ",", tBeg);
							value = string.sub(arg1, tBeg, tEnd-1);
							if ( value > "0" ) then
								NuN_Receiving.hrank = tonumber(value);
							end
						end

					-- Line Type "U" : Information from the User Definable Buttons in a Contact Note
					elseif ( lineType == "U" ) then
						local usrData = tonumber( string.sub(lineData, 1, 1) );
						if ( usrData ~= (NuN_uCount+1) ) then
							return;
						end
						NuN_uCount = NuN_uCount + 1;
						if ( NuN_uCount > 5 ) then
							return;
						end
						if ( NuN_uCount == 1 ) then
							NuN_Receiving.user = {};
						end
						local titleEnd = string.find(lineData, "~    ");
						local detlBeg = string.find(lineData, "~    ~");
						if ( titleEnd ) then
							NuN_Receiving.user[NuN_uCount] = {};
							NuN_Receiving.user[NuN_uCount].title = string.sub(lineData, 3, titleEnd-1);
						end
						if ( detlBeg ) then
							detlBeg = detlBeg + 6;
							if ( NuN_Receiving.user[NuN_uCount] ) then
								NuN_Receiving.user[NuN_uCount].detl = string.sub(lineData, detlBeg);
							end
						end

					-- Line Type "T" : Text information from the main Text Edit box in either a General OR a Contact Note
					elseif ( lineType == "T" ) then
						if ( lastTextKey == string.sub(lineData, 1, 1) ) then
							return;
						else
							lastTextKey = string.sub(lineData, 1, 1);
						end
						NuN_tCount = NuN_tCount + 1;
						if ( NuN_tCount == 1 ) then
							NuN_Receiving.text = {};
						end
						NuN_Receiving.text[NuN_tCount] = string.sub(lineData, 2);
					end
					processedByNuN = true;
					NuN_Receiving.timer = 0;
				end
			end
		else
			-- Different language clients have different localised headings, and this was needed to translate them
			local prfx1 = "";
			if ( string.find(arg1, NuN_TransStrings[1][1]) ) then
				prfx1 = NuN_TransStrings[1][1];
			elseif ( string.find(arg1, NuN_TransStrings[1][2]) ) then
				prfx1 = NuN_TransStrings[1][2];
			end

			-- if the message is the first in a series indicating a NuN Note is being sent to you, then NuN_Receiving.active = true
			-- i.e. if the LineType is a NotesUNeed sent message Prefix then........
			local prfxPos = string.find(arg1, prfx1);
			if ( ( prfx1 ~= "" ) and ( prfxPos ) ) then
				local prfxLen = string.len(prfx1);
				local prfxEnd = string.find(arg1, "  --->");
				NuN_Receiving.from = string.sub(arg1, prfxPos+prfxLen, prfxEnd-1);
				NuN_Receiving.pos = string.find(arg1, ":", 1);
				if ( NuN_Receiving.pos ) then
					local _, _, delay = string.find(arg1, ".+::(%d+%.*%d*)::.*");				-- Custom time delay between each line
					if ( delay ) then delay = tonumber(delay); end
					if ( ( delay ) and ( delay > defaultReceiptDeadline ) ) then
						receiptDeadline = delay;
					else
						receiptDeadline = defaultReceiptDeadline;
					end
					NuN_Receiving.prefix = strsub(arg1, 1, NuN_Receiving.pos);
					NuN_Receiving.active = true;
					NuN_Receiving.timer = 0;
					NuN_uCount = 0;
					NuN_tCount = 0;
					processedByNuN = true;
					NuN_Message(NUN_RECEIVING_START..NuN_Receiving.from);
					NuN_Receiving.log = arg1;			-- NuN Creates a NuN Log type note recording the last 10 transmitted/received notes for tracking / debugging purposes
					NuN_Receiving.receivedKeys = {};
					lastTextKey = "";
				end
			end
		end
	end

	-- don't echo messages that have been intercepted and processed by NuN
	if ( processedByNuN ) then
		if ( ( not NuN_State.NuN_AtStartup ) and ( NuN_Receiving.active ) ) then
			PlaySound("TellMessage");		-- I have absolutely NO memory of why I'm doing this !!!
		end
	else

		NuNHooks.NuNOri_ChatFrame_MessageEventHandler( ... );
	end
end

-- World Map Frame was altered to allow normal GameTooltips to appear above it
-- !!! again this is code that would be better replaced with a proper world map tooltip, but I don't have the testing ability
-- btw, the reason I do this is because I want the NuN_MapTooltip to be shown over MapNotes in AlphaMap and Atlas, as well as the WorldMap
-- and letting it be a "child" of the World Map means its not visible over alphaMap / atlas.... so I make it a normal tooltip...
-- could test trying to change the parent, and see what happens, other addons that change the world map anyway can do so and not affect me I think.
-- Worth a try ....
function NuNNew_ToggleWorldMap()
	if ( ( UIPanelWindows["WorldMapFrame"] ) and ( UIPanelWindows["WorldMapFrame"].area == "full" ) ) then
		UIPanelWindows["WorldMapFrame"] = { area="center", pushable=UIPanelWindows["WorldMapFrame"].pushable };
	end
	NuNPopup:Hide();
	NuN_MapTooltip:Hide();
--	NuNHooks.NuNOri_ToggleWorldMap();		-- 5.40
	if ( WorldMapFrame:IsVisible() ) then
		NuN_UpdateCurLinks();
	end
end

function NuN_UpdateCurLinks()
	local cont, zone, curZ;

	if ( MapNotes_Data_Notes ) then							-- + v5.00.11200
		cont = "WM ";								-- + v5.00.11200
		local map = GetMapInfo();						-- + v5.00.11200
		if ( map ) then								-- + v5.00.11200
			cont = cont..map;						-- + v5.00.11200
		else									-- + v5.00.11200
			cont = cont.."WorldMap";					-- + v5.00.11200
		end									-- + v5.00.11200
		zone = 0;								-- + v5.00.11200
		if ( MapNotes_Data_Notes[cont] ) then					-- + v5.00.11200
			NuN_IndexByZone(cont, zone, MapNotes_Data_Notes[cont]);		-- + v5.00.11200
		end									-- + v5.00.11200
	end										-- + v5.00.11200
end

function NuNNew_AlphaMapNotes_OnEnter(id, lFrame)
	if ( ( NuNPopup:IsVisible() ) and ( IsControlKeyDown() ) ) then
		return;	-- suppress tooltip changes while the Control key is pressed
	end
	NuNHooks.NuNOri_AlphaMapNotes_OnEnter(id, lFrame);
	NuN_WorldMapTooltip_OnShow(id, GameTooltip);
end

-------------------------------------------------------------------------------------------
-- Attempt to Hook MapNotes functions

function NuNNew_MapNotes_OnEnter(id)
	if ( ( NuNPopup:IsVisible() ) and ( IsControlKeyDown() ) ) then
		return;	-- suppress tooltip changes while Control Key is pressed
	end
	NuNHooks.NuNOri_MapNotes_OnEnter(id);
	NuN_WorldMapTooltip_OnShow(id);
end

function NuNNew_MapNotes_OnLeave(id)
--	if ( NuNPopup:IsVisible() ) then
--		popUpHide = true;
--		NuNPopup.id = id;
--		return;
--	else
		popUpHide = true;
		NuNHooks.NuNOri_MapNotes_OnLeave(id);
--	end
end

function NuNNew_MapNotes_DeleteNote(id, cont, zone)
	local lId = id;
	local lCont, lZone, lLst;
	if ( id > 0 ) then
		lCont, lZone, lLst = NuN_PreDeleteMapIndex(id, cont, zone);
	end
	NuNHooks.NuNOri_MapNotes_DeleteNote(id, cont, zone);
	if ( ( lId > 0 ) and ( lCont ) and ( lCont ~= 0 ) ) then
		NuN_DeleteMapIndex(lId, lCont, lZone, lLst);
	end
end

function NuNNew_MapNotes_WriteNote()
	NuNHooks.NuNOri_MapNotes_WriteNote();
	if ( MapNotes_Data_Notes ) then							-- + v5.00.11200
		local cont = "WM ";							-- + v5.00.11200
		local map = GetMapInfo();						-- + v5.00.11200
		if ( map ) then								-- + v5.00.11200
			cont = cont..map;						-- + v5.00.11200
		else									-- + v5.00.11200
			cont = cont.."WorldMap";					-- + v5.00.11200
		end									-- + v5.00.11200
		zone = 0;								-- + v5.00.11200
		if ( MapNotes_Data_Notes[cont] ) then					-- + v5.00.11200
			NuN_IndexByZone(cont, zone, MapNotes_Data_Notes[cont]);		-- + v5.00.11200
		end									-- + v5.00.11200
	end										-- + v5.00.11200
end

function NuNNew_MapNotes_Quicknote()
	NuNHooks.NuNOri_MapNotes_Quicknote();
	if ( MapNotes_Data_Notes ) then							-- + v5.00.11200
		local cont = "WM ";							-- + v5.00.11200
		local map = GetMapInfo();						-- + v5.00.11200
		if ( map ) then								-- + v5.00.11200
			cont = cont..map;						-- + v5.00.11200
		else									-- + v5.00.11200
			cont = cont.."WorldMap";					-- + v5.00.11200
		end									-- + v5.00.11200
		zone = 0;								-- + v5.00.11200
		if ( MapNotes_Data_Notes[cont] ) then					-- + v5.00.11200
			NuN_IndexByZone(cont, zone, MapNotes_Data_Notes[cont]);		-- + v5.00.11200
		end									-- + v5.00.11200
	end										-- + v5.00.11200
end


----------------------------
-- No More Hookers --
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------





function NuN_Who()
	if ( not NuN_WhoReturnStruct.func ) then												-- 5.60
	    -- make sure the /who call triggers an EVENT, rather than a chat message 										-- 5.60
		if ( ( NuNSettings[pKey] ) and ( NuNSettings[pKey].alternativewho ) ) then
			SetWhoToUI(1);                                          						-- 5.60
			FriendsFrame:UnregisterEvent("WHO_LIST_UPDATE");								-- 5.60
		end
		-- unregister the who frame from the who update events, and trigger the who									-- 5.60
		-- also set up the Who Return Structure so the EVENT returns to the correct function								-- 5.60
		NuN_WhoReturnStruct.func = NuN_Who;													-- 5.60
		NuN_WhoReturnStruct.timeLimit = 0;													-- 5.60
		NuN_WhoReturnStruct.name = c_name;													-- 5.60
		NuN_WhoReturnStruct.secondTry = nil;
		NuN_suppressExtraWho = true;
		SendWho("n-"..c_name);																-- 5.60 "n-"..

	elseif ( NuN_WhoReturnStruct.func == NuN_Who ) then										-- 5.60
		local wName = nil;
		local wGuildName = nil;
		local wRace = nil;
		local wClass = nil;
		local bttnHeadingText1;
		local bttnDetailText1;
	
		local n = GetNumWhoResults();
		for i = 1, n, 1 do
			wName, wGuildName, _, wRace, wClass, _ = GetWhoInfo(i);							-- 5.60 merged double call
			if ( wName == c_name ) then														-- Not interested in Level / Zone
				if ( wGuildName ~= nil ) then
					c_guild = wGuildName;
				end
				bttnHeadingText1 = getglobal("NuNTitleButton1ButtonTextHeading");
				bttnDetailText1 = getglobal("NuNInforButton1ButtonTextDetail");
				if ( bttnHeadingText1:GetText() == NUN_DFLTHEADINGS[1] ) and ( wGuildName ~= nil) then
					bttnDetailText1:SetText(wGuildName);
					c_guild = wGuildName;
					if ( wGuildName == "" ) then
						bttnChanges[6] = -1;												-- 5.60 Use -1 to flag blank
					else
						bttnChanges[6] = wGuildName;
					end
				end
				if ( wClass ~= nil ) then
					c_class = wClass;
					ddBoxes.ddClass = NuNF.NuNGet_TableID(Classes, c_class);
					UIDropDownMenu_SetSelectedID(NuNClassDropDown, ddBoxes.ddClass);
					UIDropDownMenu_SetText(c_class, NuNClassDropDown);
				end
				if ( wRace ~= nil ) then
					c_race = wRace;
					ddBoxes.ddRace = NuNF.NuNGet_TableID(Races, c_race);
					UIDropDownMenu_SetSelectedID(NuNRaceDropDown, ddBoxes.ddRace);
					UIDropDownMenu_SetText(c_race, NuNRaceDropDown);
				end

				-- auto update existing notes - but not saving new notes automatically
				if ( NuNDataPlayers[c_name] ) then
					NuN_WriteNote();
				end

			end
		end
	end																						-- 5.60
end

-- 5.60 Replaces NuN_Target() call from XML
function NuN_UnitInfo_OnClick()
	local unitID = NuNF.NuN_UnitInfo(true, c_name);
	if ( unitID ) then
		NuNF.NuN_UnitInfo(false, c_name, unitID);	-- UnitID ? Bleh ! Fixed - but untested fix
	end
end



-- The Main Contact Note Deletion Routine
function NuN_Delete(noRefresh)
	if ( NuNDataPlayers[c_name] ) then
		NuNDataPlayers[c_name] = nil;
	end

	for n = 1, uBttns, 1 do
		nameHdNbr = c_name..pHead..n;
		nameDtNbr = c_name..pDetl..n;
		if ( NuNDataPlayers[nameHdNbr] ) then
			NuNDataPlayers[nameHdNbr] = nil;
		end
		if ( NuNDataPlayers[nameDtNbr] ) then
			NuNDataPlayers[nameDtNbr] = nil;
		end
	end
	if ( NuN_CTTCheckBox:GetChecked() ) then
		NuN_ClearPinnedTT();
	end

	if ( noRefresh ) then
		return;
	end

	NuNEditDetailsFrame:Hide();
	NuNFrame:Hide();

	if ( ( NuNSearchFrame:IsVisible() ) and ( not string.find(NuNSearchTitleText:GetText(), NUN_QUESTS_TEXT) ) ) then
		deletedE = true;
		NuNSearch_Search();
	end
	if ( FriendsListFrame:IsVisible() ) then
		NuNNew_FriendsList_Update();
	elseif ( IgnoreListFrame:IsVisible() ) then
		NuNNew_IgnoreList_Update();
	elseif ( GuildPlayerStatusFrame:IsVisible() ) then
		NuNNew_GuildStatus_Update();
	elseif ( GuildStatusFrame:IsVisible() ) then
		NuNNew_GuildStatus_Update();
	elseif ( WhoFrame:IsVisible() ) then
		NuNNew_WhoList_Update();
	elseif ( LFMFrame:IsVisible() ) then
		LFMFrame_Update();
	end
end

-- The Main General Note Deletion Routine
function NuNGNote_Delete(noRefresh)
	local c_note = NuNGNoteTitleButtonText:GetText();
	if ( NuNGNoteFrame.fromQuest ) then
		NuNQuestHistory[c_note] = nil;
		NuNGNoteFrame:Hide();
		if ( ( NuNSearchFrame:IsVisible() ) and ( not noRefresh ) ) then
			deletedE = true;
			NuN_FetchQuestHistory();
		end
	else
		if ( ( string.find(c_note, "|Hitem:") ) and ( not noRefresh ) ) then
			for index in pairs(NuNData[itmIndex]) do
				if ( NuNData[itmIndex][index] == toDelete ) then
					NuNData[itmIndex][index] = nil;
				end
			end
		end
		if ( NuNDataRNotes[c_note] ) then
			NuNDataRNotes[c_note] = nil;
		elseif ( NuNDataANotes[c_note] ) then
			NuNDataANotes[c_note] = nil;
		end
		if ( NuN_GTTCheckBox:GetChecked() ) then
			NuN_ClearPinnedTT();
		end

		if ( noRefresh ) then
			return;
		end

		NuNGNoteFrame:Hide();
		if ( NuNSearchFrame:IsVisible() ) then
			deletedE = true;
			NuNSearch_Search();
		end
		if ( ( QuestLogFrame:IsVisible() ) and ( not NuNGNoteFrame.fromQuest ) ) then
			QuestLog_Update();
		end
		NuN_UpdateMapNotesIndex(c_note);
	end
end



function NuNOptions_ResetDefaults()
	NuNSettings[pKey] = {};
	NuNSettings[pKey].autoG = nil;
	NuNSettings[pKey].autoA = nil;
	NuNSettings[pKey].autoFI = nil;
	NuNSettings[pKey].autoD = nil;
	NuNSettings[pKey].hignores = nil;
	NuNSettings[pKey].toolTips = "1";
	NuNSettings[pKey].pScale = 1.00;
	NuNSettings[pKey].tScale = 1.00;
	NuNSettings[pKey].mScale = 1.00;
	NuN_PinnedTooltip:SetScale(1);
	NuN_Tooltip:SetScale(1);
	WorldMapTooltip:SetScale(1);
	NuN_MapTooltip:SetScale(1);
	NuNPopup:SetScale(1);
	NuNSettings[pKey].dLevel = "1";
	NuNSettings[pKey].autoQ = nil;
	NuNSettings[pKey].autoN = nil;
	NuNSettings[pKey].autoP = nil;
	NuNSettings[pKey].minOver = nil;
	NuNSettings[pKey].ttLen = NuNC.NUN_TT_MAX;
	NuNSettings[pKey].ttLLen = NuNC.NUN_TT_LEN;
	NuNSettings[pKey].hideMicro = nil;
	NuNSettings[pKey].autoGuildNotes = nil;									-- 5.60
	NuNSettings[pKey].autoGRVerbose = nil;									-- 5.60
	NuNSettings[pKey].modKeys = nil;										-- 5.60
	NuNSettings[pKey].antiKey = nil;										-- 5.60
	NuNSettings[pKey].mouseBttn = nil;										-- 5.60
	NuNOptions_SetModifierText();											-- 5.60
	NuNSettings[pKey].modifier = "on";										-- 5.60
	NuNSettings[pKey].delay = nil;											-- 5.60 Effect won't be noticed until relog
	NuNSettings[pKey].restrictwho = nil;
	NuNSettings[pKey].alternativewho = nil;
	-- Reset colour picker presets
	local cpKey, bttn, r, g, b;
	for i=1, 5, 1 do
		-- Contact note frame button
		cpKey = "cc"..i;
		NuNSettings[pKey][cpKey] = NuNC.NUN_CPRESETS[i];
		bttn = getglobal("NuNCColourPreset"..i);
		bttn.preset = NuNSettings[pKey][cpKey];
		r, g, b = NuNF.NuN_HtoD(bttn.preset);
		getglobal(bttn:GetName().."Texture"):SetVertexColor(r, g, b);
		-- General note frame button
		cpKey = "gc"..i;
		NuNSettings[pKey][cpKey] = NuNC.NUN_CPRESETS[i];
		bttn = getglobal("NuNGColourPreset"..i);
		bttn.preset = NuNSettings[pKey][cpKey];
		r, g, b = NuNF.NuN_HtoD(bttn.preset);
		getglobal(bttn:GetName().."Texture"):SetVertexColor(r, g, b);
	end
	NuNSettings.ratings = {};
	NuNSettings.ratingsT = {};
	NuNSettings.ratingsBL = {};
	for i, value in pairs(NUN_ORATINGS) do
		NuNSettings.ratings[i] = value;
	end
	for i, value in pairs(NUN_ORATINGS_TEXT) do
		NuNSettings.ratingsT[i] = value;
	end
	for i=1, maxRatings, 1 do
		NuNSettings.ratingsBL[i] = 0;
	end
	NuNOptionsFrame:Hide();
	NuNFrame:SetUserPlaced(0);
	NuNFrame:ClearAllPoints();
	NuNFrame:SetPoint("CENTER", UIParent, "CENTER", 220, 15);
	NuNGNoteFrame:SetUserPlaced(0);
	NuNGNoteFrame:ClearAllPoints();
	NuNGNoteFrame:SetPoint("CENTER", UIParent, "CENTER", 250, -15);
	NuNSearchFrame:SetUserPlaced(0);
	NuNSearchFrame:ClearAllPoints();
	NuNSearchFrame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 60, -144);
	if ( NuNMicroFrame:IsVisible() ) then
		NuNMicroFrame:Hide();
	end
	NuNMicroFrame:SetUserPlaced(0);
	NuNMicroFrame:ClearAllPoints();
	NuNMicroFrame:SetPoint("TOP", UIParent, "TOP", 0, -30);
	NuNSettings[pKey].nunFont = nil;										-- 5.60
	NuN_UpdateFont("Fonts\\FRIZQT__.TTF", 12);								-- 5.60
	NuNMicroFrame:Show();
	NuN_Options();
end


-- Nothing to do with the new NuN Import/Export functionality
-- Update WoW Friends/Ignores based on Saved Data
function NuNOptions_Import()
	local x;
	local index;
	local value;
	local isInGuild = false;
	local lGuild = GetGuildInfo("player");
	if ( ( lGuild ) and ( lGuild ~= "" ) ) then
		isInGuild = true;
	end

	NuN_FriendIgnoreActivity = true;
	NuN_IgnoreUpdate.func = nil;
	NuN_IgnoreUpdate.name = nil;
	NuN_IgnoreUpdate.time = 0;
	NuN_FriendUpdate.func = nil;
	NuN_FriendUpdate.name = nil;
	NuN_FriendUpdate.time = 0;

	for index, value in pairs(NuNDataPlayers) do
		if ( ( index ~= UNKNOWN ) and ( index ~= UNKNOWNOBJECT ) ) then -- 5.60
			if ( ( NuNDataPlayers[index].faction ) and ( index == pName ) ) then
				NuNDataPlayers[index].type = NuNC.NUN_SELF_C;

			elseif ( NuNDataPlayers[index].faction == pFaction ) then
				if ( NuNDataPlayers[index].ignoreLst ) then
					if ( ( not NuN_Is_Ignored(index) ) and ( not NuNSettings[pKey].gNotIgnores[index] ) ) then
						NuN_AttemptedFriendIgnores = NuN_AttemptedFriendIgnores + 1;
						if ( not NuNSettings[pKey].autoS ) then
							NuN_Message(IGNORE.." "..index);
						end
						AddIgnore(index);
					end
				end

				if  ( ( isInGuild ) and ( NuNDataPlayers[index].guild == lGuild ) and ( not NuNSettings[pKey].autoG ) ) then
					-- Forget this entry as they are guild mates with current player and settings say not to add as friend

				elseif ( NuNDataPlayers[index].friendLst ) then
					if ( ( not NuN_Is_Friendly(index) ) and ( not NuNSettings[pKey].gNotFriends[index] ) ) then
						NuN_AttemptedFriendIgnores = NuN_AttemptedFriendIgnores + 1;
						if ( not NuNSettings[pKey].autoS ) then
							NuN_Message(FRIENDS.." "..index);
						end
						AddFriend(index);
					end
				end
			end
		end
	end

	NuN_FriendIgnoreActivity = nil;
end


-- Nothing to do with the new NuN Import/Export functionality
-- Update Saved Data based on WoW Friends/Ignores
function NuNOptions_Export()
	local iName;
	for i = 1, GetNumFriends(), 1 do
		iName = GetFriendInfo(i);
		if ( ( iName ~= UNKNOWN ) and ( iName ~= UNKNOWNOBJECT ) ) then -- 5.60
			if ( NuNDataPlayers[iName] ) then
				NuNDataPlayers[iName].friendLst = true;
			else
				NuNDataPlayers[iName] = {};
				NuNDataPlayers[iName].type = NuNC.NUN_AUTO_C;
				NuNDataPlayers[iName].faction = pFaction;
				NuNDataPlayers[iName][txtTxt] = NUN_AUTO_FRIEND..NuNF.NuN_GetDateStamp();
				NuNDataPlayers[iName].friendLst = true;
			end
			if ( NuNSettings[pKey].gNotFriends[iName] ) then
				NuNSettings[pKey].gNotFriends[iName] = nil;
			end
		end
	end
	for i = 1, GetNumIgnores(), 1 do
		iName = GetIgnoreName(i);
		if ( ( iName ~= UNKNOWN ) and ( iName ~= UNKNOWNOBJECT ) ) then -- 5.60
			if ( NuNDataPlayers[iName] ) then
				NuNDataPlayers[iName].ignoreLst = true;
			else
				NuNDataPlayers[iName] = {};
				NuNDataPlayers[iName].type = NuNC.NUN_AUTO_C;
				NuNDataPlayers[iName].faction = pFaction;
				NuNDataPlayers[iName][txtTxt] = NUN_AUTO_IGNORE..NuNF.NuN_GetDateStamp();
				NuNDataPlayers[iName].ignoreLst = true;
			end
			if ( NuNSettings[pKey].gNotIgnores[iName] ) then
				NuNSettings[pKey].gNotIgnores[iName] = nil;
			end
		end
	end
end


-- This is executed when you click on the "Search" button on the Options Frame (i.e. this is the function that actually opens the Browser Frame)
-- Perhaps a better name would have been "Filter" - it filters notes based on the Drop Down Box available on the Options Frame
-- e.g. Just show Quest Notes, or show Player Notes with a Profession drop down box for further filtering
function NuNOptions_Search()
	local lDisplay = NUN_SEARCHFOR[ddBoxes.ddSearch].Display;	-- ddBoxes.ddSearch must be set before calling this function
	local lCommand = NUN_SEARCHFOR[ddBoxes.ddSearch].Command;	-- i.e. ddBoxes.ddSearch controls how records are filtered when the Browser frame is displayed

	ddClassSearch = nil;
	ddProfSearch = nil;
	ddQHSearch = nil;		-- 5.60
	ddText = nil;
	lastBttnIndex = 0;
	lastBttn = nil;
	lastBttnDetl = nil;
	NuN_Filtered = nil;
	filterText = "";
	foundNuN = {};
	NuNSearchFrame:SetScale(NuNSettings[pKey].pScale);
	NuNSearchFrame:Show();
	NuNOptionsFrame:Hide();
	NuNSearchFrame.searchType = lDisplay;
	NuNSearchTitleText:SetText(lDisplay);
	NuNSearchFrameSearchButton:Enable();
	NuNSearchFrameSearchButton:Show();

	NuNSearchFrame_MassDelete:Show();
	NuNSearchFrame_Export:Show();
	NuNExtraOptions:Show();
	NuNSearchFrame.qh = nil;

	if ( ( lCommand == "All" ) or ( string.find(lCommand, "Notes") ) ) then
		NuNSearchClassDropDown:Hide();
		NuNSearchProfDropDown:Hide();
		NuNSearchTextBox:Hide();
		NuNSearchSubSet:Hide();
		NuNSearchQHDropDown:Hide();								-- 5.60
		NuNSearch_Search();

	elseif ( lCommand == "Class" ) then
		UIDropDownMenu_ClearAll(NuNSearchClassDropDown);
		NuNSearchClassDropDown:Show();
		NuNSearchProfDropDown:Hide();
		NuNSearchTextBox:Hide();
		NuNSearchSubSet:Hide();
		NuNSearchFrameSearchButton:Disable();
		NuNSearchQHDropDown:Hide();								-- 5.60
		NuNSearch_Update();

	elseif ( lCommand == "Profession" ) then
		NuNSearchClassDropDown:Hide();
		UIDropDownMenu_ClearAll(NuNSearchProfDropDown);
		NuNSearchProfDropDown:Show();
		NuNSearchTextBox:Hide();
		NuNSearchSubSet:Hide();
		NuNSearchFrameSearchButton:Disable();
		NuNSearchQHDropDown:Hide();								-- 5.60
		NuNSearch_Update();

	elseif ( lCommand == "Quest History" ) then
		NuN_FetchQuestHistory();

	else
		NuNSearchClassDropDown:Hide();
		NuNSearchProfDropDown:Hide();
		NuNSearchTextBox:Show();
		NuNSearchSubSet:Show();
		NuNSearchTextBox:SetFocus();
		filterText = NuNSearchTextBox:GetText();
		NuNSearchQHDropDown:Hide();								-- 5.60
		NuNSearch_Search();
	end
end


-- THIS is the routing that actually filters and searches notes for Text / Class / etc. etc.
function NuNSearch_Search(mButton)
	local index;
	local value;
	local tstTxt = NuNSearchTextBox:GetText();
	local srchText;
	local countH = 0;
	local countA = 0;
	local countN = 0;
	local classType;
	local searchType = NUN_SEARCHFOR[ddBoxes.ddSearch].Command;
	local subType = "";
	local noteType = 0;
	local results = 0;
	local sortType = "Default";

	if ( searchType == "Date" ) then		-- Possible future development, not implemented atm
		sortType = "Date";
		searchType = "All";
	end

	if ( not mButton ) then
		mButton = "LeftButton";
	end

	if ( mButton == "LeftButton" ) then
		tstTxt = string.lower(tstTxt);
	end

	if ( searchType == "Class" ) then
		classType = NUN_ALLCLASSES[ddClassSearch];
	end
	if ( string.find(searchType, "Notes:") ) then
		subType = string.sub(searchType, 7);
		searchType = string.sub(searchType, 1, 5);
	end

	foundNuN = {};
	foundHNuN = {};
	foundANuN = {};
	foundNNuN = {};
	local skip;

	for index, value in pairs(NuNDataPlayers) do
		skip = false;

		if ( NuNSettings[pKey].hignores ) then
			local isIgnored = NuNF.NuN_IsPlayerIgnored(index);
			if ( isIgnored ) then
				skip = true;
			end
		end

		if ( not skip ) then
			if ( searchType == "All" ) then
				if ( NuNDataPlayers[index].faction == "Horde" ) then
					countH = countH + 1;
					foundHNuN[countH] = index;
				elseif ( NuNDataPlayers[index].faction == "Alliance" ) then
					countA = countA + 1;
					foundANuN[countA] = index;
				end

			elseif ( searchType == "Class" ) then
				if ( NuNDataPlayers[index].faction == "Horde" ) then
					if ( NUN_HCLASSES[NuNDataPlayers[index].cls] == classType ) then
						countH = countH + 1;
						foundHNuN[countH] = index;
					end
				elseif ( NuNDataPlayers[index].faction == "Alliance" ) then
					if ( NUN_ACLASSES[NuNDataPlayers[index].cls] == classType ) then
						countA = countA + 1;
						foundANuN[countA] = index;
					end
				end

			elseif ( searchType == "Profession" ) then
				if ( NuNDataPlayers[index].faction == "Horde" ) then
					if ( ( NuNDataPlayers[index].prof1 == ddProfSearch ) or ( NuNDataPlayers[index].prof2 == ddProfSearch ) ) then
						countH = countH + 1;
						foundHNuN[countH] = index;
					end
				elseif ( NuNDataPlayers[index].faction == "Alliance" ) then
					if ( ( NuNDataPlayers[index].prof1 == ddProfSearch ) or ( NuNDataPlayers[index].prof2 == ddProfSearch ) ) then
						countA = countA + 1;
						foundANuN[countA] = index;
					end
				end

			-- Need to account for non-standard letters such as Umlauts...
			-- Does the lowerCase transformation interfere (?)... she's a nosey bitch isn't she.... :P
			elseif ( searchType == "Text" ) then
				if ( NuNDataPlayers[index].txt ) then
					srchText = NuNF.NuN_GetCText(index);
					local noteTitle = index;
					if ( not srchText ) then
						srchText = "";
					end
					if ( mButton == "LeftButton" ) then
						srchText = string.lower(srchText);
						noteTitle = string.lower(noteTitle);
					end
					-- still testing [index].txt for the special case of pDetl/pHeader User Definable buttons  LOWER CASE IT !!!
					if ( ( string.find(srchText, tstTxt) ) or ( string.find(NuNDataPlayers[index].txt, tstTxt) ) or ( string.find(noteTitle, tstTxt) ) ) then
						local tName = index;
						if ( not NuNDataPlayers[index].faction ) then
							tName = nil;
							local pos = string.find(index, pDetl);
							if ( not pos ) then
								pos = string.find(index, pHead);
							end
							if ( pos ) then
								tName = string.sub(index, 1, (pos - 1));
							end
						end
						if ( ( tName ) and ( NuNDataPlayers[tName] ) and ( NuNDataPlayers[tName].faction ) ) then
							if ( NuNDataPlayers[tName].faction == "Horde" ) then
								if ( NuNF.NuNGet_TableID(foundHNuN, tName) == nil ) then
									countH = countH + 1;
									foundHNuN[countH] = tName;
								end
							else
								if ( NuNF.NuNGet_TableID(foundANuN, tName) == nil ) then
									countA = countA + 1;
									foundANuN[countA] = tName;
								end
							end
						end
					end
				end
			end
		end
	end

	if ( ( searchType ~= "Class" ) and ( searchType ~= "Profession" ) ) then
		for index, value in pairs(NuNDataRNotes) do
			if ( ( NuNDataRNotes[index] ) and ( NuNDataRNotes[index].type ) ) then
				noteType = NuNDataRNotes[index].type;
			else
				noteType = 1;
			end
			if ( ( searchType == "All" ) or ( searchType == "Notes" ) ) then
				if ( ( subType == "" ) or ( ( subType == "Generic" ) and ( noteType == 1 ) ) or ( ( subType == "Items" ) and ( noteType == 2 ) ) or ( ( subType == "Logs" ) and ( noteType == 3 ) ) or ( ( subType == "NPCs" ) and ( noteType == 4 ) ) or ( ( subType == "Quests" ) and ( noteType == 5 ) ) or ( ( subType == "LUA" ) and ( noteType == 6 ) ) ) then
					countN = countN + 1;
					foundNNuN[countN] = index;
				end

			elseif ( searchType == "Text" ) then
				srchText = NuNF.NuN_GetGText(index);
				local noteTitle = index;
				if ( srchText == nil ) then
					srchText = "";
				end
				if ( mButton == "LeftButton" ) then
					srchText = string.lower(srchText);
					noteTitle = string.lower(noteTitle);
				end
				if ( ( string.find(srchText, tstTxt)) or ( string.find(noteTitle, tstTxt ) ) ) then
					countN = countN + 1;
					foundNNuN[countN] = index;
				end
			end
		end

		for index, value in pairs(NuNDataANotes) do
			if ( ( NuNDataANotes[index] ) and ( NuNDataANotes[index].type ) ) then
				noteType = NuNDataANotes[index].type;
			else
				noteType = 1;
			end

			if ( ( searchType == "All" ) or ( searchType == "Notes" ) ) then
				if ( ( subType == "" ) or ( ( subType == "Generic" ) and ( noteType == 1 ) ) or ( ( subType == "Items" ) and ( noteType == 2 ) ) or ( ( subType == "Logs" ) and ( noteType == 3 ) ) or ( ( subType == "NPCs" ) and ( noteType == 4 ) ) or ( ( subType == "Quests" ) and ( noteType == 5 ) ) or ( ( subType == "LUA" ) and ( noteType == 6 ) ) ) then
					countN = countN + 1;
					foundNNuN[countN] = index;
				end

			elseif ( searchType == "Text" ) then
				srchText = NuNF.NuN_GetGText(index);
				local noteTitle = index;
				if ( srchText == nil ) then
					srchText = "";
				end
				if ( mButton == "LeftButton" ) then
					srchText = string.lower(srchText);
					noteTitle = string.lower(noteTitle);
				end
				if ( ( string.find(srchText, tstTxt)) or ( string.find(noteTitle, tstTxt ) ) ) then
					countN = countN + 1;
					foundNNuN[countN] = index;
				end
			end
		end
	end

	if ( sortType == "Default" ) then
		table.sort(foundANuN);
		table.sort(foundHNuN);
		table.sort(foundNNuN);
		NuNF.NuN_DefaultSort();
	elseif ( sortType == "Date" ) then
		NuNF.NuN_DefaultSort();
	end

	if ( ( searchType ~= "Class" ) and ( searchType ~= "Profession" ) ) then
		NuNSearchTextBox:Show();
		NuNSearchSubSet:Show();
		if ( NuN_Filtered ) then
			local tmpNuN = {};
			local c = 0;

			for i=1, getn(foundNuN), 1 do					-- #foundNuN
				if ( NuNF.NuNGet_TableID(NuN_Filtered, foundNuN[i]) ) then
					c = c + 1;
					tmpNuN[c] = foundNuN[i];
				end
			end
			foundNuN = tmpNuN;
			if ( filterText == "" ) then
				NuNSearchSubSet:SetText( "" );
			else
				NuNSearchSubSet:SetText( "{"..filterText.."}" );
			end
		else
			NuN_Filtered = foundNuN;
		end
	end

	results = getn(foundNuN);
	NuNSearchTitleText:SetText(NuNSearchFrame.searchType.." ("..results..")");

	NuNSearch_Update();
	if ( ( deletedE ) and ( visibles > 0 ) and ( lastBttn ~= nil ) ) then
		deletedE = false;
		if ( lastBttnIndex > visibles ) then
			NuNSearch_HighlightRefresh(lastVisible);
			NuNSearchNote_OnClick(lastVisible);
		else
			NuNSearch_HighlightRefresh(lastBttn);
			NuNSearchNote_OnClick(lastBttn);
		end
	else
		NuNSearch_HighlightRefresh(nil);
	end
end


-- Why do I get the feeling that people are spying on me ffs - am I really just paranoid ?
-- Button on the Browswer frame, goes back to the Options Frame : only available if you reached the Browser frame from the Options frame in the first place
function NuNSearch_Back()
	if ( NuNFrame:IsVisible() ) then
		NuNEditDetailsFrame:Hide();
		NuNFrame:Hide();
	end
	if ( NuNGNoteFrame:IsVisible() ) then
		NuNGNoteFrame:Hide();
	end
	NuNSearchFrame:Hide();
	NuNOptionsFrame:SetScale(NuNSettings[pKey].pScale);
	NuN_Options();
end


-- Refresh the Browser Window, based on the records that have been filtered in to the NuNFound array of records to display
function NuNSearch_Update()
	local theNoteIndex;
	local theOffsetNoteIndex;
	local theNote;
	local theNoteHFlag;
	local theNoteAFlag;
	local theNoteNFlag;
	local theNoteLFlag;
	local theNoteType;
	local theNoteReps;
	local numNuNFound = getn(foundNuN);

	NuNF.NuN_CheckQuestList();

	visibles = 0;
	FauxScrollFrame_Update(NuNSearchListScrollFrame, numNuNFound, NuNC.NUN_SHOWN, NuNC.NUN_NOTE_HEIGHT);
	for theNoteIndex=1, NuNC.NUN_SHOWN, 1 do
		theOffsetNoteIndex = theNoteIndex + FauxScrollFrame_GetOffset(NuNSearchListScrollFrame);
		theNote = getglobal( "NuNSearchNote"..theNoteIndex );
		if ( theOffsetNoteIndex > numNuNFound ) then
			theNote:Hide();
		else
			theNote:SetTextColor(1, 0.82, 0, 1);
			theNoteHFlag = getglobal( "NuNSearchNote"..theNoteIndex.."FrameHFlag" );
			theNoteAFlag = getglobal( "NuNSearchNote"..theNoteIndex.."FrameAFlag" );
			theNoteNFlag = getglobal( "NuNSearchNote"..theNoteIndex.."FrameNFlag" );
			theNoteLFlag = getglobal( "NuNSearchNote"..theNoteIndex.."FrameLFlag" );
			theNoteType = getglobal( "NuNSearchNote"..theNoteIndex.."FrameType" );
			theNoteReps = getglobal( "NuNSearchNote"..theNoteIndex.."FrameReps" );
			theNoteReps:SetText("   ");
			theNoteLFlag:Hide();
			local typ = string.sub(foundNuN[theOffsetNoteIndex], 1, 1);
			local noteName = string.sub(foundNuN[theOffsetNoteIndex], 2);
			theNote:SetText( noteName );
			if ( typ == NuNC.NUN_HORD_C ) then
				theNoteAFlag:Hide();
				theNoteNFlag:Hide();
				theNoteHFlag:Show();
			elseif ( typ == NuNC.NUN_ALLI_C ) then
				theNoteHFlag:Hide();
				theNoteNFlag:Hide();
				theNoteAFlag:Show();
			elseif ( typ == NuNC.NUN_QUEST_C ) then
				theNoteHFlag:Hide();
				theNoteAFlag:Hide();
				if ( ( NuNDataANotes[noteName] ) or ( NuNDataRNotes[noteName] ) ) then
					theNoteNFlag:Show();
				else
					theNoteNFlag:Hide();
				end
			else
				theNoteHFlag:Hide();
				theNoteAFlag:Hide();
				theNoteNFlag:Show();
			end
			theNote.type = typ;
			if ( typ == NuNC.NUN_HORD_C ) or ( typ == NuNC.NUN_ALLI_C ) then
				if ( NuNDataPlayers[noteName].type ) then
					typ = NuNDataPlayers[noteName].type;
					if ( typ == NuNC.NUN_AUTO_C ) then
						theNoteType:SetText(NUN_AUTO);
					elseif ( noteName == pName ) then
						theNoteType:SetText(NUN_PLAYER);
					elseif ( typ == NuNC.NUN_SELF_C ) then
						theNoteType:SetText(NUN_SELF);
					elseif ( typ == NuNC.NUN_MANU_C ) then
						theNoteType:SetText(NUN_MANU);
					elseif ( typ == NuNC.NUN_PARTY_C ) then
						theNoteType:SetText(NUN_PARTY);
					elseif ( typ == NuNC.NUN_GUILD_C ) then
						theNoteType:SetText(NUN_GUILD);
					else
						theNoteType:SetText("   ");
					end
					if ( ( NuNSettings[pKey].autoP ) and ( NuNDataPlayers[noteName][pName] ) and ( NuNDataPlayers[noteName][pName].partied ) ) then
						theNoteReps:SetText("x"..NuNDataPlayers[noteName][pName].partied);
					end
				else
					theNoteType:SetText("   ");
				end
			elseif ( typ == NuNC.NUN_QUEST_C ) then
				theNoteLFlag:Hide();
				if ( ( not NuNQuestLog[noteName] ) and ( ( NuNQuestHistory[noteName].handedIn ) or ( NuNQuestHistory[noteName].complete ) ) ) then
					theNoteLFlag:Show();
				elseif ( ( NuNQuestHistory[noteName] ) and ( NuNQuestHistory[noteName].abandoned ) ) then
					theNote:SetTextColor(0.9, 0, 0, 0.9);
				elseif ( NuNQuestLog[noteName] ) then
					theNote:SetTextColor(0, 0.9, 0, 0.9);
				end
				theNoteType:SetText(NuNQuestHistory[noteName].pLevel);
			else
				if ( ( NuNDataRNotes[noteName] ) and ( NuNDataRNotes[noteName].type ) ) then
					typ = NuNDataRNotes[noteName].type;
				elseif ( NuNDataANotes[noteName] ) then
					theNoteLFlag:Show();
					if ( NuNDataANotes[noteName].type ) then
						typ = NuNDataANotes[noteName].type;
					end
				else
					typ = 1;
				end
				theNoteType:SetText(NUN_NOTETYPES[typ].Display);
				if ( NUN_NOTETYPES[typ].Command == "QST" ) then
					if ( NuNQuestLog[noteName] ) then
						theNote:SetTextColor(0, 0.9, 0, 0.9);
					elseif ( ( NuNQuestHistory[noteName] ) and ( NuNQuestHistory[noteName].abandoned ) ) then
						theNote:SetTextColor(0.9, 0, 0, 0.9);
					end
				end
			end
			theNote:Show();
			visibles = visibles + 1;
			lastVisible = theNote;
			if ( theOffsetNoteIndex == lastBttnDetl ) then
				theNote:LockHighlight();
			else
				theNote:UnlockHighlight();
			end
		end
	end
end


-- helper tooltip
function NuNSearchNote_OnEnter(bttnNote)
	local bttnName = bttnNote:GetName();
	local storePinned = NuN_PinnedTooltip.type;

	local x, y = GetCursorPosition();
	if ( x > 500 ) then
		NuN_Tooltip:SetOwner(this, "ANCHOR_LEFT");
	else
		NuN_Tooltip:SetOwner(this, "ANCHOR_RIGHT");
	end
	ttName = bttnNote:GetText();
	NuN_Tooltip:ClearLines();
	if ( bttnNote.type == "N" ) then
		NuN_PinnedTooltip.type = "General";
	elseif ( bttnNote.type == "A" ) or ( bttnNote.type == "H" ) then
		NuN_PinnedTooltip.type = "Contact";
	elseif ( bttnNote.type == NuNC.NUN_QUEST_C ) then
		NuN_PinnedTooltip.type = "QuestHistory";
	end
	NuNF.NuN_BuildTT(NuN_Tooltip);
	NuN_PinnedTooltip.type = storePinned;
	NuN_State.NuN_Fade = false;
	NuN_Tooltip:Show();
end


-- This code executes when you click on a Note in the Note Browswer frame, to past its title in to Chat or another note, etc. OR just to open the Note in its NuN editing frame
function NuNSearchNote_OnClick(bttnNote, mButton)
	local noteName = bttnNote:GetText();
	local lclNote;
	local lclNoteHFlag;
	local lclNoteAFlag;
	local lclNoteNFlag;
	local lastBttnDetlN;
	local nType;

	if ( not mButton ) then
		mButton = "LeftButton";
	end

	if ( IsShiftKeyDown() ) then
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:Insert(noteName);
		elseif ( NuNGNoteFrame:IsVisible() ) then
			local cText = NuNGNoteTextScroll:GetText().."\n"..noteName;
			NuNGNoteTextScroll:SetText(cText);
		elseif ( NuNFrame:IsVisible() ) then
			local cText = NuNText:GetText().."\n"..noteName;
			NuNText:SetText(cText);
		end
	else
		lastBttn = bttnNote;
		lastBttnIndex = bttnNote:GetID();
		lastBttnDetlN = bttnNote.type..noteName;
		lastBttnDetl = NuNF.NuNGet_TableID(foundNuN, lastBttnDetlN);

		NuNSearch_HighlightRefresh(bttnNote);

		if ( ( bttnNote.type == NuNC.NUN_HORD_C ) or ( bttnNote.type == NuNC.NUN_ALLI_C ) ) then
			if ( mButton == "LeftButton" ) then
				NuN_ShowSavedNote(noteName);
			else
				NuN_PinnedTooltipToggle("Contact", noteName, true);
			end
		else
			if ( ( receiptPending ) and ( NuN_Receiving.type == "General" ) ) then
				return;
			end
			if ( bttnNote.type == NuNC.NUN_QUEST_C ) then
				NuNGNoteFrame.fromQuest = "1";
				c_type = NuNGet_CommandID(NUN_NOTETYPES, "QST");
			else
				NuNGNoteFrame.fromQuest = nil;
			end
			if ( ( NuNGNoteFrame.fromQuest ) and ( mButton == "RightButton" ) ) then
				NuNGNoteFrame.fromQuest = noteName;
				StaticPopup_Show("NUN_DELETE_QUESTHISTORY");
				return;
			end
			if ( ( NuNDataANotes[noteName] ) or ( NuNDataRNotes[noteName] ) ) then
				if ( mButton == "LeftButton" ) then
					c_note = noteName;
					NuN_ShowSavedGNote();
				else
					NuN_PinnedTooltipToggle("General", noteName, true);
				end
			end
		end
	end
end


-- highlighting of the selected note in the Browser
function NuNSearch_HighlightRefresh(tstNote)
	local theNote;
	for i=1, NuNC.NUN_SHOWN, 1 do
		theNote = getglobal("NuNSearchNote"..i);
		if ( ( theNote == tstNote ) and ( theNote:IsVisible() ) ) then
			theNote:LockHighlight();
		else
			theNote:UnlockHighlight();
		end
	end
end



function NuN_DateStamp()
	NuNText:SetText(NuNText:GetText().."\n"..NuNF.NuN_GetDateStamp());
end

function NuNGNote_DateStamp()
	NuNGNoteTextScroll:SetText(NuNGNoteTextScroll:GetText().."\n"..NuNF.NuN_GetDateStamp());
end


function NuN_Loc()
	NuNText:SetText(NuNText:GetText().."\n"..NuNF.NuN_GetLoc());
end

function NuNGNote_Loc()
	NuNGNoteTextScroll:SetText(NuNGNoteTextScroll:GetText().."\n"..NuNF.NuN_GetLoc());
end

-- Create note for "Self"
function NuN_AutoNote()
	if ( ( NuNSettings ) and ( pKey ) and ( NuNSettings[pKey] ) and ( NuNSettings[pKey].autoN ) ) then
		local lName;
		local lRace;
		local lClass;
		local lSex;
		local lPvPRank;
		local lPvPRankID;
		local lgName;
		local lgRank;
		local lgRankIndex;
		local bttnKey;

		if ( pFaction ~= nil ) then
			NuNDataPlayers[pName] = {};
			NuNDataPlayers[pName].type = NuNC.NUN_SELF_C;
			NuNDataPlayers[pName].faction = pFaction;
			NuNDataPlayers[pName][txtTxt] = "";
			lRace = UnitRace("player");
			if ( lRace ~= nil ) then
				ddBoxes.ddRace = NuNF.NuNGet_TableID(Races, lRace);
				NuNDataPlayers[pName].race = ddBoxes.ddRace;
			end
			lClass = UnitClass("player");
			if ( lClass ~= nil ) then
				ddBoxes.ddClass = NuNF.NuNGet_TableID(Classes, lClass);
				NuNDataPlayers[pName].cls = ddBoxes.ddClass;
			end
			lSex = UnitSex("player");
			if ( lSex ~= nil ) then
				NuNDataPlayers[pName].sex = lSex - 1;
			end
			lgName, lgRank, lgRankIndex = GetGuildInfo("player");
			if ( lgName ~= "" ) and ( lgName ~= nil ) then
				bttnKey = pName..pDetl.."1";
				NuNDataPlayers[bttnKey] = {};
				NuNDataPlayers[bttnKey].txt = lgName;
				bttnKey = pName..pDetl.."2";
				NuNDataPlayers[bttnKey] = {};
				if ( lgRankIndex == 0 ) then
					NuNDataPlayers[bttnKey].txt = ( "GM : "..lgRank );
				else
					NuNDataPlayers[bttnKey].txt = ( lgRankIndex.." : "..lgRank );
				end
			end
		end
	end
end


-- Clear the last changed Drop Down box in the Contact Note Frame - only allows 1 Drop down box Undo effectively
function NuN_ClrDD()
	if ( lastDD == "Race" ) then
		UIDropDownMenu_ClearAll(NuNRaceDropDown);
		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].race ) ) then
			ddBoxes.ddRace = -1;
		else
			ddBoxes.ddRace = nil;
		end
	elseif ( lastDD == "Class" ) then
		UIDropDownMenu_ClearAll(NuNClassDropDown);
		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].cls ) ) then
			ddBoxes.ddClass = -1;
		else
			ddBoxes.ddClass = nil;
		end
	elseif ( lastDD == "Sex" ) then
		UIDropDownMenu_ClearAll(NuNSexDropDown);
		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].sex ) ) then
			ddBoxes.ddSex = -1;
		else
			ddBoxes.ddSex = nil;
		end
	elseif ( lastDD == "Prof1" ) then
		UIDropDownMenu_ClearAll(NuNProf1DropDown);
		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].prof1 ) ) then
			ddBoxes.ddProf1 = -1;
		else
			ddBoxes.ddProf1 = nil;
		end
	elseif ( lastDD == "Prof2" ) then
		UIDropDownMenu_ClearAll(NuNProf2DropDown);
		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].prof2 ) ) then
			ddBoxes.ddProf2 = -1;
		else
			ddBoxes.ddProf2 = nil;
		end
--	elseif ( lastDD == "CRank" ) then
--		UIDropDownMenu_ClearAll(NuNCRankDropDown);
--		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].crank ) ) then
--			ddCRank = -1;
--		else
--			ddCRank = nil;
--		end
	elseif ( lastDD == "Arena" ) then
		UIDropDownMenu_ClearAll(NuNArenaRDropDown);
		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].arena ) ) then
			ddBoxes.ddArena = -1;
		else
			ddBoxes.ddArena = nil;
		end
	elseif ( lastDD == "HRank" ) then
		UIDropDownMenu_ClearAll(NuNHRankDropDown);
		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].hrank ) ) then
			ddBoxes.ddHRank = -1;
		else
			ddBoxes.ddHRank = nil;
		end
	elseif ( lastDD == "PRating" ) then
		UIDropDownMenu_ClearAll(NuNPRatingDropDown);
		if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].prating ) ) then
			ddBoxes.ddPRating = -1;
		else
			ddBoxes.ddPRating = 0;
		end
	end
	lastDD = nil;
	NuNButtonClrDD:Disable();
end


-- Show slightly different note buttons depending on the Type of General note
function NuN_GTypeDependant_Setup()
	UIDropDownMenu_SetSelectedID(NuNGTypeDropDown, c_type);
	UIDropDownMenu_SetText(NUN_NOTETYPES[c_type].Display, NuNGTypeDropDown);
	if ( NUN_NOTETYPES[c_type].Command == "NPC" ) then
		NuNNPCTargetButton:Show();
	else
		NuNNPCTargetButton:Hide();
	end
end


-- open a saved general note in its NuN editing frame; fetch data from database
function NuN_ShowSavedGNote()
	if ( ( NuNGNoteFrame:IsVisible() ) and ( prevNote == c_note ) ) then
		NuNGNoteFrame:Hide();
	else
		if ( ( NuNDataRNotes[c_note] ) and ( NuNDataRNotes[c_note].type ) ) then
			c_type = NuNDataRNotes[c_note].type;
		elseif ( ( NuNDataANotes[c_note] ) and ( NuNDataANotes[c_note].type ) ) then
			c_type = NuNDataANotes[c_note].type;
		else
			c_type = NuNGet_CommandID(NUN_NOTETYPES, "   ");
		end
		NuNGNoteFrame.type = c_type;
		NuN_GTypeDependant_Setup();

		if ( NuNDataRNotes[c_note] ) then
			NuN_GLevel_CheckBox:SetChecked(0);
		elseif ( NuNDataANotes[c_note] ) then
			NuN_GLevel_CheckBox:SetChecked(1);
		end
		NuN_GNote_OriTitle = c_note;
		prevNote = c_note;
		if ( NuNOptionsFrame:IsVisible() ) then
			NuNOptionsFrame:Hide();
		end
		if ( NuNcDeleteFrame:IsVisible() ) then
			NuNcDeleteFrame:Hide();
		end
		NuNGNoteFrame:SetScale(NuNSettings[pKey].pScale);
		NuNGNoteFrame:Hide();
		NuNGNoteFrame:Show();
		NuNGNoteTextBox:Hide();
		g_text = NuNF.NuN_GetGText(c_note);
		if ( g_text == "" ) then
			g_text = "\n";
		end
		NuNGNoteTextScroll:SetText(g_text);
		NuNGNoteTitleButtonText:SetText(c_note);
		NuNGNoteTitleButton:Show();
		if ( not NuNSettings[pKey].bHave ) then
			NuNGNoteTextScroll:SetFocus();
		end
		if ( NuNGNoteFrame.fromQuest ) then
			NuNGNoteHeader:SetText(NuNC.NUN_QUEST_NOTE);
			NuNGNoteButtonDelete:Enable();
			NuNGNoteTitleButton:Disable();
			NuNGNoteButtonSaveNote:Disable();
		else
			NuNGNoteHeader:SetText(NuNC.NUN_SAVED_NOTE);
			NuNGNoteButtonDelete:Disable();
			NuNGNoteTitleButton:Enable();
			NuNGNoteButtonSaveNote:Enable();
		end
		NuNGNoteButtonDateStamp:Enable();
		NuNGNoteButtonLoc:Enable();
		NuNGNoteButtonDelete:Enable();
		if ( ( MapNotes_OnLoad ) or ( MetaMap_Quicknote ) ) then
			NuNMapNoteButton:Enable();
		end
		NuNGOpenChatButton:Enable();
		NuNGTTCheckBoxLabel:Show();
		NuN_GTTCheckBox:Show();
		NuN_GTTCheckBox:SetChecked(0);
		if ( NuN_PinnedTooltip.type == "General" ) then
			NuN_GTTCheckBox:SetChecked( NuN_CheckPinnedBox(c_note) );
		end
	end
end

-- show a new General note, having been passed a note Title
function NuN_ShowTitledGNote(GNoteText)
	if ( ( NuNGNoteFrame:IsVisible() ) and ( prevNote == c_note ) ) then
		NuNGNoteFrame:Hide();
	else
		if ( NuNSettings[pKey].dLevel ) then
			NuN_GLevel_CheckBox:SetChecked(1);
		else
			NuN_GLevel_CheckBox:SetChecked(0);
		end
		prevNote = c_note;
		NuNGNoteFrame.type = c_type;
		NuN_GTypeDependant_Setup();
		NuN_GNote_OriTitle = nil;
		if ( NuNOptionsFrame:IsVisible() ) then
			NuNOptionsFrame:Hide();
		end
		if ( NuNcDeleteFrame:IsVisible() ) then
			NuNcDeleteFrame:Hide();
		end
		NuNGNoteFrame:SetScale(NuNSettings[pKey].pScale);
		NuNGNoteFrame:Hide();
		NuNGNoteFrame:Show();
		NuNGNoteTextScroll:SetText(GNoteText);
		NuNGNoteTextBox:Hide();
		NuNGNoteTitleButtonText:SetText(c_note);
		NuNGNoteTitleButton:Show();
		if ( not NuNSettings[pKey].bHave ) then
			NuNGNoteTextScroll:SetFocus();
		end
		NuNGNoteButtonDateStamp:Enable();
		NuNGNoteButtonLoc:Enable();
		if ( NuNGNoteFrame.fromQuest ) then
			NuNGNoteHeader:SetText(NuNC.NUN_QUEST_NOTE);
			NuNGNoteButtonDelete:Enable();
			if ( ( MapNotes_OnLoad ) or ( MetaMap_Quicknote ) ) then
				NuNMapNoteButton:Enable();
			end
			NuNGNoteTitleButton:Disable();
			NuNGNoteButtonSaveNote:Disable();
		else
			NuNGNoteHeader:SetText(NuNC.NUN_NEW_NOTE);
			NuNGNoteButtonDelete:Disable();
			NuNMapNoteButton:Disable();
			NuNGNoteTitleButton:Enable();
			NuNGNoteButtonSaveNote:Enable();
		end
		NuNGOpenChatButton:Disable();
		NuNGTTCheckBoxLabel:Hide();
		NuN_GTTCheckBox:Hide();
	end
end

-- Show new untitled General note
function NuN_ShowNewGNote()
	local tstTxt = NuNGNoteTextBox:GetText();
	if ( ( NuNGNoteFrame:IsVisible() ) and ( NuNGNoteTextBox:IsVisible() ) and ( tstTxt == "" ) ) then
		NuNGNoteFrame:Hide();
	else
		if ( IsAltKeyDown() ) then
			NuN_LastOpen.type = "General";
			NuN_ReOpen();
			return;
		end

		if ( NuNSettings[pKey].dLevel ) then
			NuN_GLevel_CheckBox:SetChecked(1);
		else
			NuN_GLevel_CheckBox:SetChecked(0);
		end
		c_type = NuNGet_CommandID(NUN_NOTETYPES, "   ");
		NuNGNoteFrame.type = c_type;
		NuNGNoteFrame.fromQuest = nil;
		NuN_GTypeDependant_Setup();
		NuN_GNote_OriTitle = nil;
		if ( NuNOptionsFrame:IsVisible() ) then
			NuNOptionsFrame:Hide();
		end
		if ( NuNcDeleteFrame:IsVisible() ) then
			NuNcDeleteFrame:Hide();
		end
		if ( NuNGNoteFrame.fromQuest ) then
			NuNGNoteHeader:SetText(NuNC.NUN_QUEST_NOTE);
		else
			NuNGNoteHeader:SetText(NuNC.NUN_NEW_NOTE);
		end
		NuNGNoteButtonSaveNote:Disable();
		NuNGNoteFrame:SetScale(NuNSettings[pKey].pScale);
		NuNGNoteFrame:Hide();
		NuNGNoteFrame:Show();
		NuNGNoteTextScroll:SetText("");
		NuNGNoteTitleButton:Hide();
		NuNGNoteTextBox:SetText("");
		NuNGNoteTextBox:Show();
		NuNGNoteTextBox:SetFocus();
		NuNGNoteButtonDelete:Disable();
		NuNMapNoteButton:Disable();
		NuNGOpenChatButton:Disable();
		NuNGTTCheckBoxLabel:Hide();
		NuN_GTTCheckBox:Hide();
	end
end


---------------------------------------------
-- Options Control Click Processing --
---------------------------------------------

function NuN_OptionsGuildCheckBox_OnClick()
	if ( NuNOptionsGuildCheckButton:GetChecked() ) then
		NuNSettings[pKey].autoG = "1";
	else
		NuNSettings[pKey].autoG = nil;
	end
end

function NuN_OptionsAddCheckBox_OnClick()
	if ( NuNOptionsAddCheckButton:GetChecked() ) then
		NuNSettings[pKey].autoA = "1";
		NuN_AttemptedFriendIgnores = 0;
		NuN_Update_Friends();
		NuN_Update_Ignored();
		NuNSettings[pKey].autoFI = "1";
		NuNOptionsAACheckButton:SetChecked(1);
	else
		NuNSettings[pKey].autoA = nil;
	end
end

function NuN_OptionsAACheckBox_OnClick()
	if ( NuNOptionsAddCheckButton:GetChecked() ) then
		NuNOptionsAACheckButton:SetChecked(1);
		NuNSettings[pKey].autoFI = "1";
	else
		if ( NuNOptionsAACheckButton:GetChecked() ) then
			NuNSettings[pKey].autoFI = "1";
		else
			NuNSettings[pKey].autoFI = nil;
		end
	end
end

function NuN_OptionsVerboseCheckBox_OnClick()
	if ( NuNOptionsVerboseCheckButton:GetChecked() ) then
		NuNSettings[pKey].autoS = "1";
	else
		NuNSettings[pKey].autoS = nil;
	end
end

function NuN_OptionsDeleteCheckBox_OnClick()
	if ( NuNOptionsDeleteCheckButton:GetChecked() ) then
		NuNSettings[pKey].autoD = "1";
	else
		NuNSettings[pKey].autoD = nil;
	end
end

function NuN_DefaultLevelCheckBox_OnClick()
	if ( NuN_DefaultLevelCheckBox:GetChecked() ) then
		NuNSettings[pKey].dLevel = "1";
	else
		NuNSettings[pKey].dLevel = nil;
	end
end

function NuN_HelpTTCheckBox_OnClick()
	if ( NuN_HelpTTCheckBox:GetChecked() ) then
		NuNSettings[pKey].toolTips = "1";
	else
		NuNSettings[pKey].toolTips = nil;
	end
end

function NuN_AutoQuestCheckBox_OnClick()
	if ( NuN_AutoQuestCheckBox:GetChecked() ) then
		NuNSettings[pKey].autoQ = "1";
		NuNF.NuN_UpdateQuestNotes("SwitchedOn");
	else
		NuNSettings[pKey].autoQ = nil;
	end
end

function NuN_AutoNoteCheckBox_OnClick()
	if ( NuN_AutoNoteCheckBox:GetChecked() ) then
		NuNSettings[pKey].autoN = "1";
		if ( not NuNDataPlayers[pName] ) then
			NuN_AutoNote();
		end
	else
		NuNSettings[pKey].autoN = nil;
	end
end


function NuN_OnUpdate(arg1)
	if ( ( NuNMicroFrame:IsVisible() ) and ( MouseIsOver(NuNMicroFrame) ) ) then
		NuNMicroBorder:Show();
	else
		NuNMicroBorder:Hide();
	end
end



function NuN_NewContact(unitType)
	if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
		return;
	end

	local Friendly;

	if ( ( unitType == "target" ) and ( c_name ~= pName ) ) then
		if ( UnitIsFriend("player", "target") ) then
			Friendly = true;
		else
			Friendly = false;
		end
	else
		Friendly = true;
	end
	if ( ((NuN_horde) and (Friendly))  or  ((not NuN_horde) and (not Friendly)) ) then
		c_faction = "Horde";
		NuNF.NuN_HordeSetup();
	else
		c_faction = "Alliance";
		NuNF.NuN_AllianceSetup();
	end
	c_route = "Target";
	c_race = nil;
	c_class = nil;
	c_sex = nil;
	c_prof1 = nil;
	c_prof2 = nil;
	c_arena = nil;
	c_hrank = nil;
	c_guild = nil;
	gRank = nil;
	gRankIndex = nil;
	gNote = nil;
	gOfficerNote = nil;
	NuN_ShowNote();
	NuNF.NuN_UnitInfo(false, c_name, unitType);
end


function NuN_CreateContact(contactName, tFaction)
	if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
		return;
	end

	c_name = contactName;
	c_route = "Create";
	if ( ( tFaction == "-ch" ) or ( tFaction == "Horde" ) ) then
		c_faction = "Horde";
		NuNF.NuN_HordeSetup();
	else
		c_faction = "Alliance";
		NuNF.NuN_AllianceSetup();
	end
	c_race = nil;
	c_class = nil;
	c_sex = nil;
	c_prof1 = nil;
	c_prof2 = nil;
	c_arena = nil;
	c_hrank = nil;
	c_guild = nil;
	gRank = nil;
	gRankIndex = nil;
	gNote = nil;
	gOfficerNote = nil;
	NuN_ShowNote();
end


function NuN_TextWarning(box, tLabel)
	local lenTxt, lenTxtL, oLabel;

	lenTxt = box:GetText();
	lenTxtL = string.len(lenTxt);
	local _, nL = string.gsub(lenTxt, "\n", "\n");
	lenTxtL = lenTxtL + nL;
	oLabel = getglobal(tLabel);
	if ( ( lenTxtL == nil ) or ( lenTxtL == 0 ) ) then
		oLabel:SetText("0 / "..NuNC.NUN_MAX_TXT_LIM);
	else
		oLabel:SetText(lenTxtL.." / "..NuNC.NUN_MAX_TXT_LIM);
	end
	if ( lenTxtL > NuNC.NUN_MAX_TXT_LIM ) then
		StaticPopup_Show("NUN_NOTELIMIT_EXCEEDED");
	end
end


function NuN_ToggleToolTips()
	if ( NuNSettings[pKey].toolTips ) then
		NuNSettings[pKey].toolTips = nil;
	else
		NuNSettings[pKey].toolTips = "1";
	end
end


-- OK, this was a pain; Needed to account for the "EVENT" delay between :SetUnit("target") and the tooltip having useful information about said target....
-- so NPCInfo_Proceed is monitored in an OnUpdate routine
function NuN_NPCInfo(funcToCall, autoHide)
	local text = UnitName("target");

	if ( not NPCInfo_Proceed ) then
		if ( ( text ) and ( text ~= "" ) and ( funcToCall ) ) then
			GameTooltip:ClearLines();
			GameTooltip:Hide();
			GameTooltip:SetOwner(UIParent, "ANCHOR_CURSOR");
			GameTooltip:SetUnit("target");
			GameTooltip:Show();
			NPCInfo_Proceed = {};
			NPCInfo_Proceed.func = funcToCall;
			NPCInfo_Proceed.autoHide = autoHide;
		end

	else
		local NPCInfo = "";
		local NPCloc;
		local NPCtimed;
		local someInfo = false;
		local listText = nil;

		NPClvl = UnitLevel("target");
		NPCcls = UnitClass("target");
		NPCclsXtra = UnitClassification("target");
		NPCtype = UnitCreatureType("target");
		NPCsex = UnitSex("target");
		if ( NPClvl ~= nil ) then
			if ( NPClvl == -1 ) then
				NPCInfo = NUN_LEVEL.." : ??     ";
			else
				NPCInfo = NUN_LEVEL.." : "..NPClvl.."     ";
			end
		end
		if ( NPCcls ~= nil ) then
			NPCInfo = NPCInfo..NUN_CLASS.." : "..NPCcls..",  ";
		end
		if ( NPCsex ~= nil ) then
			if ( NPCsex == 1 ) then
				NPCInfo = NPCInfo..",  ";
			elseif ( NPCsex == 2 ) then
				NPCInfo = NPCInfo..NUN_MALE..",  ";
			elseif ( NPCsex == 3 ) then
				NPCInfo = NPCInfo..NUN_FEMALE..",  ";
			else
				NPCInfo = NPCInfo.."??"..",  ";
			end
		end
		if ( NPCtype ~= nil ) then
			NPCInfo = NPCInfo..NPCtype.."     ";
		end
		if ( NPCclsXtra ~= "normal" ) then
			NPCInfo = NPCInfo..( string.upper(NPCclsXtra) );
		end

		GameTooltip:SetUnit("target");
		NPCprof = GameTooltipTextLeft2:GetText();
		if ( ( NPCprof == nil ) or ( string.find(NPCprof, NUN_LEVEL) ) ) then
			-- skip
		else
			NPCInfo = NPCInfo.."\n"..NUN_PROF.." : "..NPCprof.."    ";
		end

		NPCtimed = NuNF.NuN_GetDateStamp();
		NPCloc = NuNF.NuN_GetLoc();

		NPCInfo = NPCInfo.."\n\n"..NPCtimed.."\n"..NPCloc;

		if ( MerchantFrame:IsVisible() ) then
			listText = NuN_BuildShoppingList();
		end

		if ( listText ) then
			NPCInfo = NPCInfo.."\n\n"..listText;
		end

		-- Reset
		NPCInfo_Proceed = nil;

		return NPCInfo;
	end
end





function NuN_ShowFriendNote()
	if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
		return;
	end


	local numFriends = GetNumFriends();
	if (numFriends ~= nil) and (numFriends > 0) then
		if ( FriendsFrame.selectedFriend ) then
			FriendsFrame.selectedFriend = GetSelectedFriend();
			c_name, discard, c_class, discard, connected = GetFriendInfo(FriendsFrame.selectedFriend);
			if ( c_class == UNKNOWN ) then		-- 5.60
				c_class = nil;
			end;
			c_race = nil;
			c_sex = nil;
			c_prof1 = nil;
			c_prof2 = nil;
			c_arena = nil;
			c_hrank = nil;
			c_guild = nil;
			gRank = nil;
			gRankIndex = nil;
			gNote = nil;
			gOfficerNote = nil;
			c_route = "Friend";
			if ( NuN_horde ) then
				NuNF.NuN_HordeSetup();
			else
				NuNF.NuN_AllianceSetup();
			end
			NuN_ShowNote();
		end
	end
end



function NuN_ShowIgnoreNote()
	if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
		return;
	end

	local numIgnores = GetNumIgnores();
	if (numIgnores ~= nil) and (numIgnores > 0) then
		FriendsFrame.selectedIgnore = GetSelectedIgnore();
		if ( FriendsFrame.selectedIgnore ) then
			c_name = GetIgnoreName(FriendsFrame.selectedIgnore);
			c_class = nil;
			c_race = nil;
			c_sex = nil;
			c_prof1 = nil;
			c_prof2 = nil;
			c_arena = nil;
			c_hrank = nil;
			c_guild = nil;
			gRank = nil;
			gRankIndex = nil;
			gNote = nil;
			gOfficerNote = nil;
			c_route = "Ignore";
			if ( NuN_horde ) then
				NuNF.NuN_HordeSetup();
			else
				NuNF.NuN_AllianceSetup();
			end
			NuN_ShowNote();
		end
	end
end



function NuN_ShowGuildNote()
	if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
		return;
	end

	local numGuildMembers = GetNumGuildMembers();
	if (numGuildMembers ~= nil) and (numGuildMembers > 0) then
		c_class = nil;
		c_race = nil;
		c_name, gRank, gRankIndex, discard, c_class, discard, discard, gNote, gOfficerNote, discard = GetGuildRosterInfo( GetGuildRosterSelection() );
		if ( c_name ~= nil ) then
			c_guild = GetGuildInfo("player");
			c_route = "Guild";
			if ( NuN_horde ) then
				NuNF.NuN_HordeSetup();
			else
				NuNF.NuN_AllianceSetup();
			end
			NuN_ShowNote();
		end
		c_sex = nil;
		c_prof1 = nil;
		c_prof2 = nil;
		c_arena = nil;
		c_hrank = nil;
	end
end

-- Update Note buttons on Social Frames
function NuN_UpdateNoteButton(nBttn, nBttnID, NuN_rType)
	local bName = nBttn:GetName();
	local pBttnTxt, discard, qHeader;
	local bttnNoteHFlag = getglobal(bName.."FrameHFlag");
	local bttnNoteAFlag = getglobal(bName.."FrameAFlag");
	local bttnNoteNFlag = getglobal(bName.."FrameNFlag");
	local bttnNoteQFlag = getglobal(bName.."FrameQFlag");

	if ( NuN_rType == "A" ) then
		if ( FriendsListFrame:IsVisible() ) then
			NuN_rType = "F";
		elseif ( IgnoreListFrame:IsVisible() ) then
			NuN_rType = "I";
		elseif ( GuildPlayerStatusFrame:IsVisible() ) then
			NuN_rType = "G";
		elseif ( GuildStatusFrame:IsVisible() ) then
			NuN_rType = "GS";
		elseif ( WhoFrame:IsVisible() ) then
			NuN_rType = "W";
		elseif ( QuestFrame:IsVisible() ) then
			NuN_rType = NuNC.NUN_QUEST_C;
		end
	end

	if ( ( FriendsFrame:IsVisible() ) and ( bttnNoteAFlag ) and ( bttnNoteHFlag ) and ( bttnNoteNFlag ) ) then
		pBttnTxt = NuN_GetName_FrameButton(nBttnID, NuN_rType);
		if ( NuNDataPlayers[pBttnTxt] ) then
			if ( NuNDataPlayers[pBttnTxt].faction == "Horde" ) then
				bttnNoteAFlag:Hide();
				bttnNoteNFlag:Hide();
				bttnNoteHFlag:Show();
			else
				bttnNoteHFlag:Hide();
				bttnNoteNFlag:Hide();
				bttnNoteAFlag:Show();
			end
		else
			bttnNoteAFlag:Hide();
			bttnNoteHFlag:Hide();
			bttnNoteNFlag:Show();
		end

	elseif ( ( QuestLogFrame:IsVisible() ) and ( bttnNoteQFlag ) and ( bttnNoteNFlag ) ) then
		local lOffset = nBttnID + FauxScrollFrame_GetOffset(QuestLogListScrollFrame);
		pBttnTxt, discard, discard, discard, qHeader = GetQuestLogTitle(lOffset);
		if ( qHeader ) then
			nBttn:Hide();
		elseif ( pBttnTxt ) then
			nBttn:Show();
			local _, _, modifiedText = string.find(pBttnTxt, ".+]%s*(.+)");
			if ( modifiedText ) then pBttnTxt = modifiedText; end
			if ( ( NuNDataRNotes[pBttnTxt] ) or ( NuNDataANotes[pBttnTxt] ) ) then
				bttnNoteNFlag:Hide();
				bttnNoteQFlag:Show();
			else
				bttnNoteQFlag:Hide();
				bttnNoteNFlag:Show();
			end
		end

	elseif ( ( LFMFrame:IsVisible() ) and ( bttnNoteAFlag ) and ( bttnNoteHFlag ) and ( bttnNoteNFlag ) ) then
		local pere = nBttn:GetParent();
		if ( pere.nameLine ) then
			_, _, pBttnTxt = string.find(pere.nameLine, "(%a+)%s.+");
			if ( NuNDataPlayers[pBttnTxt] ) then
				if ( pFaction == "Horde" ) then
					bttnNoteAFlag:Hide();
					bttnNoteNFlag:Hide();
					bttnNoteHFlag:Show();
				else
					bttnNoteHFlag:Hide();
					bttnNoteNFlag:Hide();
					bttnNoteAFlag:Show();
				end
			else
				bttnNoteAFlag:Hide();
				bttnNoteHFlag:Hide();
				bttnNoteNFlag:Show();
			end
		else
		
		end
	end
end


-- What to do when someone clicks on a Social Frames NotesUNeed button e.g. Friends Frame
function NuN_NoteButton_OnInteract(nBttnID, uAction)
	local pBttnTxt;
	local lOffset;
	local qLevel, qTag, qGroup, qHeader, qCollapsed, qComplete;
	local qText = "";

	if ( FriendsListFrame:IsVisible() ) then
		pBttnTxt = NuN_GetName_FrameButton(nBttnID, "F");
		if ( uAction == "Click" ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
				return;
			end
			lOffset = FauxScrollFrame_GetOffset(FriendsFrameFriendsScrollFrame);
			SetSelectedFriend( (tonumber(nBttnID)+lOffset) );
			FriendsList_Update();
			if ( NuNDataPlayers[pBttnTxt] ) then
				NuN_ShowSavedNote(pBttnTxt);
			else
				NuN_ShowFriendNote();
			end
		elseif ( uAction == "MouseOver" ) then
			ttName = pBttnTxt;
			NuN_StaticTT();
		end

	elseif ( IgnoreListFrame:IsVisible() ) then
		pBttnTxt = NuN_GetName_FrameButton(nBttnID, "I");
		if ( uAction == "Click" ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
				return;
			end
			lOffset = FauxScrollFrame_GetOffset(FriendsFrameIgnoreScrollFrame);
			SetSelectedIgnore( (tonumber(nBttnID)+lOffset) );
			IgnoreList_Update();
			if ( NuNDataPlayers[pBttnTxt] ) then
				NuN_ShowSavedNote(pBttnTxt);
			else
				NuN_ShowIgnoreNote();
			end
		elseif ( uAction == "MouseOver" ) then
			ttName = pBttnTxt;
			NuN_StaticTT();
		end

	elseif ( GuildPlayerStatusFrame:IsVisible() ) then
		pBttnTxt = NuN_GetName_FrameButton(nBttnID, "G");
		if ( uAction == "Click" ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
				return;
			end
			GuildFrame.selectedGuildMember = getglobal("GuildFrameButton"..nBttnID).guildIndex;
			GuildFrame.selectedName = getglobal("GuildFrameButton"..nBttnID.."Name"):GetText();
			SetGuildRosterSelection(GuildFrame.selectedGuildMember);
			NuNNew_GuildStatus_Update();
			if ( NuNDataPlayers[pBttnTxt] ) then
				if ( ( IsAltKeyDown() ) and ( NuNFrame:IsVisible() ) and ( pBttnTxt ~= c_name ) ) then
					local insrt = "<ALT:"..pBttnTxt..">";
					local chkT = NuNText:GetText();
					if ( not string.find(chkT, insrt) ) then
						NuNText:Insert("\n" .. insrt);
					end
				else
					NuN_ShowSavedNote(pBttnTxt);
				end
			elseif ( not IsAltKeyDown() ) then
				NuN_ShowGuildNote();
			end
		elseif ( uAction == "MouseOver" ) then
			ttName = pBttnTxt;
			NuN_StaticTT();
		end

	elseif ( GuildStatusFrame:IsVisible() ) then
		pBttnTxt = NuN_GetName_FrameButton(nBttnID, "GS");
		if ( uAction == "Click" ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
				return;
			end
			GuildFrame.selectedGuildMember = getglobal("GuildFrameGuildStatusButton"..nBttnID).guildIndex;
			GuildFrame.selectedName = getglobal("GuildFrameGuildStatusButton"..nBttnID.."Name"):GetText();
			SetGuildRosterSelection(GuildFrame.selectedGuildMember);
			GuildStatus_Update();
			if ( NuNDataPlayers[pBttnTxt] ) then
				if ( ( IsAltKeyDown() ) and ( NuNFrame:IsVisible() ) and ( pBttnTxt ~= c_name ) ) then
					local insrt = "<ALT:"..pBttnTxt..">";
					local chkT = NuNText:GetText();
					if ( not string.find(chkT, insrt) ) then
						NuNText:Insert("\n" .. insrt);
					end
				else
					NuN_ShowSavedNote(pBttnTxt);
				end
			elseif ( not IsAltKeyDown() ) then
				NuN_ShowGuildNote();
			end
		elseif ( uAction == "MouseOver" ) then
			ttName = pBttnTxt;
			NuN_StaticTT();
		end

	elseif ( WhoFrame:IsVisible() ) then
		pBttnTxt = NuN_GetName_FrameButton(nBttnID, "W");
		if ( uAction == "Click" ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
				return;
			end
			WhoFrame.selectedWho = getglobal("WhoFrameButton"..nBttnID).whoIndex;
			WhoFrame.selectedName = getglobal("WhoFrameButton"..nBttnID.."Name"):GetText();
			WhoList_Update();
			if ( NuNDataPlayers[pBttnTxt] ) then
				NuN_ShowSavedNote(pBttnTxt);
			else
				NuN_ShowWhoNote(pBttnTxt);
			end
		elseif ( uAction == "MouseOver" ) then
			ttName = pBttnTxt;
			NuN_StaticTT();
		end

	elseif ( QuestLogFrame:IsVisible() ) then
		lOffset = nBttnID + FauxScrollFrame_GetOffset(QuestLogListScrollFrame);
		pBttnTxt, qLevel, qTag, qGroup, qHeader, qCollapsed, qComplete = GetQuestLogTitle(lOffset);
		c_note = pBttnTxt;
		if ( uAction == "Click" ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "General" ) ) then
				return;
			end
			QuestLog_SetSelection(lOffset);
			QuestLog_Update();
			if ( qHeader ) then
				qText = "";
			else
				NuNGNoteFrame.fromQuest = nil;
				if ( ( NuNDataRNotes[c_note] ) or ( NuNDataANotes[c_note] ) ) then
					NuN_ShowSavedGNote();
				else
					if ( qLevel == nil ) then
						qLevel = "--";
					end
					if ( qTag == nil ) then
						qTag = "";
					end
					qText = "\n"..c_note.."     "..NUN_QLVL..qLevel.."     "..qTag.."     ".."\n\n"..NuNF.NuN_BuildQuestText().."\n";
					if ( qHeader ) then
						c_type = NuNGet_CommandID(NUN_NOTETYPES, "   ");
					else
						c_type = NuNGet_CommandID(NUN_NOTETYPES, "QST");
					end
					NuN_ShowTitledGNote( qText );
				end
			end
		elseif ( uAction == "MouseOver" ) then
			ttName = c_note;
			NuN_StaticTT();
		end

	elseif ( LFMFrame:IsVisible() ) then
		local pere, lvl, clss = this:GetParent();
		lOffset = nBttnID + FauxScrollFrame_GetOffset(LFMListScrollFrame);
		_, _, pBttnTxt, lvl, clss = string.find(pere.nameLine, "(%a+)%s.%s%a+%s(%d+)%s(%a+)");
		if ( uAction == "Click" ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "Contact" ) ) then
				return;
			end
			LFMFrame.selectedLFM = getglobal("LFMFrameButton"..nBttnID).lOffset;
			LFGFrame.selectedName = getglobal("LFMFrameButton"..nBttnID.."Name"):GetText();
			LFMFrame_Update();
			if ( NuNDataPlayers[pBttnTxt] ) then
				NuN_ShowSavedNote(pBttnTxt);
			else
				NuN_ShowWhoNote(pBttnTxt);
			end
		elseif ( uAction == "MouseOver" ) then
			ttName = pBttnTxt;
			NuN_StaticTT();
		end

	end
end


-- When clicking on a Social Frame NuN button, which frame was showing - Friends, Ignores, etc.
function NuN_GetName_FrameButton(lBttnID, NuN_rType)
	local lBttn, lBttnTxt;

	if ( NuN_rType == "F" ) then
		lBttn = getglobal("FriendsFrameFriendButton"..lBttnID.."ButtonTextName");	-- v6.47.20400 Removed checking for blanks / "Offline" also...
		lBttnTxt = lBttn:GetText();
		if ( string.find(lBttnTxt, NUN_OFF) ) then
			local pos = string.find(lBttnTxt, " ");
			if ( not pos ) then
				return nil;
			end
			lBttnTxt = string.sub(lBttnTxt, 11, (pos - 1));							-- Get the name from the OFFLINE Template text without Grey colouring...
		end
	elseif ( NuN_rType == "I" ) then
		lBttn = getglobal("FriendsFrameIgnoreButton"..lBttnID.."ButtonTextName");
		lBttnTxt = lBttn:GetText();
	elseif ( NuN_rType == "G" ) then
		lBttn = getglobal("GuildFrameButton"..lBttnID.."Name");
		lBttnTxt = lBttn:GetText();
	elseif ( NuN_rType == "GS" ) then
		lBttn = getglobal("GuildFrameGuildStatusButton"..lBttnID.."Name");
		lBttnTxt = lBttn:GetText();
	elseif ( NuN_rType == "W" ) then
		lBttn = getglobal("WhoFrameButton"..lBttnID.."Name");
		lBttnTxt = lBttn:GetText();
	elseif ( NuN_rType == NuNC.NUN_QUEST_C ) then
		lBttn = getglobal("QuestLogTitle"..lBttnID.."NormalText");
		lBttnTxt = lBttn:GetText();
	end

	return lBttnTxt;
end


function NuN_StaticTT()
	local storePinned = NuN_PinnedTooltip.type;

	NuN_Tooltip:ClearLines();
	NuN_PinnedTooltip.type = "Nil";
	NuNF.NuN_BuildTT(NuN_Tooltip);
	NuN_PinnedTooltip.type = storePinned;
	NuN_State.NuN_Fade = false;
	NuN_Tooltip:Show();
end

-- the NuN Tooltip should fade with the Game Tooltip, or WorldMap tooltip
function NuN_Tooltip_OnUpdate()
	if ( ( NuN_State.NuN_Fade ) and ( not UnitExists("mouseover") ) ) then
		local gt = GameTooltipTextLeft1:GetText();
		if ( gt ~= gtName ) then
			this:Hide();
			return;
		end
		if ( this.fadeStartTime == 0 ) then
			this.fadeStartTime = GetTime();
		end
		local elapsed = GetTime() - this.fadeStartTime;
		local fadeHoldTime = this.fadeHoldTime;
		local fadeOutTime = this.fadeOutTime;
		if ( elapsed >= ( fadeHoldTime + fadeOutTime ) ) then
			this:ClearLines();
			this:Hide();
		elseif  ( elapsed > fadeHoldTime ) then
			local alpha = 1 - ( ( elapsed - fadeHoldTime ) / fadeOutTime );
			this:SetAlpha(alpha);
		end
	end
end


function NuN_FFButton_OnShow()
	NuN_FFButton_Up();
end

-- There is a single note in the Header of the Social Frame which will show/create a note depending on what Frame is showing, and what player is selected
function NuN_FFButton_Down()
	if ( NuN_horde ) then
		NuN_FFButton_StateADown:Hide();
		NuN_FFButton_StateAUp:Hide();
		NuN_FFButton_StateHUp:Hide();
		NuN_FFButton_StateHDown:Show();
	else
		NuN_FFButton_StateHDown:Hide();
		NuN_FFButton_StateHUp:Hide();
		NuN_FFButton_StateAUp:Hide();
		NuN_FFButton_StateADown:Show();
	end

	if ( ( FriendsFrameRemovePlayerButton ) and ( FriendsFrameRemovePlayerButton:IsVisible() ) ) then
		local index = BlackList:GetSelectedBlackList();
		if ( index > 0 ) then
			local name = BlackList:GetNameByIndex(index);
			if ( ( name ) and ( NuNDataPlayers[name] ) ) then
				NuN_ShowSavedNote(name);
			end
		end

	elseif ( FriendsListFrame:IsVisible() ) then
		NuN_ShowFriendNote();

	elseif ( IgnoreListFrame:IsVisible() ) then
		NuN_ShowIgnoreNote();

	elseif ( GuildPlayerStatusFrame:IsVisible() ) then
		NuN_ShowGuildNote();

	elseif ( GuildStatusFrame:IsVisible() ) then
		NuN_ShowGuildNote();

	elseif ( WhoFrame:IsVisible() ) then
		if ( WhoFrame.selectedName ) then
			NuN_ShowWhoNote(WhoFrame.selectedName);
		end

	elseif ( RaidFrame:IsVisible() ) then
		local tstValue = NuN_CheckTarget();
		if ( UnitInRaid("target") ) then
			c_name = UnitName("target");
			if ( NuNDataPlayers[c_name] ) then
				NuN_ShowSavedNote(c_name);
			else
				NuN_NewContact("target");
			end
		end
	end
end

function NuN_FFButton_Up()
	if ( NuN_horde ) then
		NuN_FFButton_StateADown:Hide();
		NuN_FFButton_StateAUp:Hide();
		NuN_FFButton_StateHDown:Hide();
		NuN_FFButton_StateHUp:Show();
	else
		NuN_FFButton_StateHDown:Hide();
		NuN_FFButton_StateHUp:Hide();
		NuN_FFButton_StateADown:Hide();
		NuN_FFButton_StateAUp:Show();
	end
end


-- The Titles of General Notes can be edited, allowing the note to be renamed
function NuN_GNoteTitle_OnClick()
	NuN_ClearPinnedTT();
	NuNGTTCheckBoxLabel:Hide();
	NuN_GTTCheckBox:Hide();
	NuNGNoteTextBox:SetText( NuNGNoteTitleButtonText:GetText() );
	NuNGNoteTitleButton:Hide();
	NuNGNoteTextBox:Show();
	NuNGNoteTextBox:SetFocus();
end

function NuN_GNoteTitleSet()
	c_note = NuNGNoteTextBox:GetText();
	c_note = string.gsub(c_note, "\124\124", "|");
	c_note = string.gsub(c_note, "|C", "|c");
	c_note = string.gsub(c_note, "|R", "|r");
	c_note = string.gsub(c_note, "||c", "|c");
	c_note = string.gsub(c_note, "||r", "|r");
	NuNGNoteTitleButtonText:SetText( c_note );
	NuNGNoteTextBox:Hide();
	NuNGNoteTitleButton:Show();
end


-- NotesUNeed tooltip shows alongside the game tooltip, rather than modifying the normal tooltip itself
function NuN_GameTooltip_OnShow(tTip)
	local storePinned = NuN_PinnedTooltip.type;
	local p1 = 1;
	local strippedName = "";
	local sNLen = 0;
	local anchorBy, anchorTo;
	local pRating;

	local focus = GetMouseFocus();
	if ( focus ) then
		focus = focus:GetName();
		if ( ( focus ) and ( string.find( focus, "AlphaMapNotesPOI") ) ) then
			return;
		end
	end

	if ( not tTip ) then
		tTip = GameTooltip;
	end

	local tx, ty;
	tx, ty = tTip:GetCenter();
	if ( ( not tx ) or ( not ty ) ) then
		noTipAnchor = tTip;
		return;
	end

	gtName = GameTooltipTextLeft1:GetText();
	if ( not gtName ) then
		return;
	end

	for index, value in ipairs(NuNSettings.ratings) do
		if ( gtName == value ) then
			pRating = index;
			break;
		end
	end

	if ( not UnitExists("mouseover") ) then
		if ( not focus ) then focus = ""; end
		if ( string.find( focus, "Container") ) then

		else
			sNLen = string.len(gtName);
			for i=sNLen, 1, -1 do
				local tstChar = string.sub(gtName, i, i);
				if ( tstChar == " " ) then
					p1 = i + 1;
					break;
				end
			end
			strippedName = string.sub(gtName, p1);
			if ( NuNDataPlayers[strippedName] ) then
				gtName = strippedName;
			end
		end
	end

	if ( ( UnitExists("mouseover") ) or ( ( RaidFrame:IsVisible() ) and ( MouseIsOver(RaidFrame) ) ) or ( ( TargetFrame:IsVisible() ) and ( MouseIsOver(TargetFrame) ) ) ) then
		local typ = "Nil";
		if ( UnitExists("mouseover") ) then
			ttName = UnitName("mouseover");
			NuN_State.NuN_Fade = true;
			if ( UnitIsPlayer("mouseover") ) then
				typ = "Contact";
				if ( not NuNDataPlayers[ttName] ) then
					ttName = nil;
				end
			else
				typ = "General";
				if ( ( not NuNDataRNotes[ttName] ) and ( not NuNDataANotes[ttName] ) ) then
					ttName = nil;
				end
			end
		else
			ttName = gtName;
			NuN_State.NuN_Fade = false;
		end
		if ( ( ttName ~= nil ) and ( ( NuNDataPlayers[ttName] ) or ( NuNDataRNotes[ttName] ) or ( NuNDataANotes[ttName] ) ) ) then
			anchorBy, anchorTo = NuN_GetTipAnchor(tTip);
			NuN_Tooltip:Hide();
			NuN_Tooltip:SetOwner(this, "ANCHOR_NONE");
			NuN_TT_Y_Offset = 0;
			NuN_PinnedTooltip.type = typ;
			NuN_State.NuN_MouseOver = true;
			NuNF.NuN_BuildTT(NuN_Tooltip);
			NuN_State.NuN_MouseOver = false;
			NuN_PinnedTooltip.type = storePinned;
			NuN_Tooltip:SetScale( tTip:GetScale() );
			NuN_Tooltip:ClearAllPoints();
			NuN_Tooltip:SetPoint(anchorBy, tTip, anchorTo, 0, 0);
			NuN_Tooltip:Show();

		else
			NuN_Tooltip:ClearLines();
			NuN_Tooltip:Hide();
		end

	elseif ( ( gtName == LFM_TITLE ) or ( gtName == LFG_TITLE ) ) then
		NuN_State.NuN_Fade = false;
		NuN_Tooltip:ClearLines();
		NuN_Tooltip:Hide();
		NuN_Tooltip:SetOwner(GameTooltip, "ANCHOR_NONE");
		NuN_TT_Y_Offset = 0;
		NuN_PinnedTooltip.type = "Nil";

		local ttTextArray = {};
		local counter = 0;
		local pere = GetMouseFocus(), 1;
		if ( pere.nameLine ) then
			local numPartyMembers = pere.partyMembers;
			local _, _, leader = string.find(pere.nameLine, "(%a+)%s.+");
			local member;
			if ( ( NuNDataPlayers[leader] ) and ( NuNDataPlayers[leader].prating ) ) then
				counter = counter + 1;
				ttTextArray[counter] = {};
				ttTextArray[counter].left = leader;
				ttTextArray[counter].right = NuNSettings.ratings[ NuNDataPlayers[leader].prating ];
			end

			local lfmType = UIDropDownMenu_GetSelectedID(LFMFrameTypeDropDown);
			local lfmName = UIDropDownMenu_GetSelectedID(LFMFrameNameDropDown);
			for i=1, numPartyMembers, 1 do
				member = GetLFGPartyResults(lfmType, lfmName, pere.lfgIndex, i);
				if ( ( member ) and ( NuNDataPlayers[member] ) and ( NuNDataPlayers[member].prating ) ) then
					counter = counter + 1;
					ttTextArray[counter] = {};
					ttTextArray[counter].left = member;
					ttTextArray[counter].right = NuNSettings.ratings[ NuNDataPlayers[member].prating ];
				end
			end
		end
		if ( counter > 0 ) then
			NuN_Tooltip:AddLine(NUN_NOTESUNEED_INFO .. NuNC.NUN_PINNED_TT_PADDING, 1, 0.7, 0);
			for i in ipairs(ttTextArray) do
				NuN_Tooltip:AddDoubleLine(ttTextArray[i].left, ttTextArray[i].right, 1, 0.7, 0, 0.7, 0.7, 0.9);
			end
		end

		NuN_PinnedTooltip.type = storePinned;
		NuN_Tooltip:SetScale( tTip:GetScale() );
		NuN_Tooltip:ClearAllPoints();
		NuN_Tooltip:SetPoint("TOPLEFT", GameTooltip, "TOPRIGHT", 0, 0);
		NuN_Tooltip:Show();		

	elseif ( pRating ) then
		pRating = NuNSettings.ratingsT[pRating];
		if ( ( pRating ) and ( pRating ~= "" ) ) then
			pRating = NuNF.NuN_ParseTT(pRating, 80);
			GameTooltip:AddLine(pRating);
		end

	else
		ttName = gtName;
		if ( NuNData[itmIndex][ttName] ) then
			ttName = ( NuNData[itmIndex][ttName] );
		end
		if ( ( ttName ~= nil ) and  ( ( NuNDataPlayers[ttName] ) or ( NuNDataRNotes[ttName] ) or ( NuNDataANotes[ttName] ) ) ) then
			NuN_State.NuN_Fade = false;
			NuN_Tooltip:ClearLines();
			NuN_Tooltip:Hide();
			NuN_Tooltip:SetOwner(this, "ANCHOR_NONE");
			NuN_TT_Y_Offset = 0;
			NuN_PinnedTooltip.type = "Nil";
			NuNF.NuN_BuildTT(NuN_Tooltip);
			NuN_PinnedTooltip.type = storePinned;
			NuN_Tooltip:SetScale( tTip:GetScale() );
			NuN_Tooltip:ClearAllPoints();
			local num1 = ShoppingTooltip1:NumLines();
			local num2 = ShoppingTooltip2:NumLines();
			if ( num2 and ( num2 > 0 ) and ShoppingTooltip2 and MerchantFrame and ( MerchantFrame:IsVisible() ) and ( MouseIsOver(MerchantFrame) ) ) or ( num2 and ( num2 > 0 ) and ShoppingTooltip2 and AuctionFrame and ( AuctionFrame:IsVisible() ) and ( MouseIsOver(AuctionFrame) ) ) then
				anchorBy, anchorTo = NuN_GetTipAnchor(ShoppingTooltip2);
				NuN_Tooltip:SetPoint(anchorBy, "ShoppingTooltip2", anchorTo, 0, 0);
			elseif ( num1 and ( num1 > 0 ) ) and ( ShoppingTooltip1 and MerchantFrame and ( MerchantFrame:IsVisible() ) and ( MouseIsOver(MerchantFrame) ) ) or ( num1 and ( num1 > 0 ) ) and ( ShoppingTooltip1 and AuctionFrame and ( AuctionFrame:IsVisible() ) and ( MouseIsOver(AuctionFrame) ) ) then
				anchorBy, anchorTo = NuN_GetTipAnchor(ShoppingTooltip1);
				NuN_Tooltip:SetPoint(anchorBy, "ShoppingTooltip1", anchorTo, 0, 0);
			else
				anchorBy, anchorTo = NuN_GetTipAnchor(tTip);
				NuN_Tooltip:SetPoint(anchorBy, tTip, anchorTo, 1, 0);
			end
			NuN_Tooltip:Show();
		else
			NuN_Tooltip:ClearLines();
			NuN_Tooltip:Hide();
		end
	end
end



function NuN_WorldMapTooltip_OnShow(id, lTooltip)
	local noPopup = true;
	local nName;

	if ( not lTooltip ) then
		lTooltip = WorldMapTooltip;
	end

	local tName = lTooltip:GetName();
	local tField = getglobal(tName.."TextLeft1");
	nName = tField:GetText();

	NuNPopup:Hide();
	if ( NuNData[itmIndex][nName] ) then
		nName = ( NuNData[itmIndex][nName] );
	end

	local MNCont = nil;
	local MNZone = nil;
	local NuN_Key = nil;

	if ( MapNotes_Data_Notes ) then					-- + v5.00.11200
		MNCont = "WM ";						-- + v5.00.11200
		local cont = GetMapInfo();				-- + v5.00.11200
		if ( cont ) then					-- + v5.00.11200
			MNCont = MNCont..cont;				-- + v5.00.11200
		else							-- + v5.00.11200
			MNCont = MNCont.."WorldMap";			-- + v5.00.11200
		end							-- + v5.00.11200
		MNZone = 0;						-- + v5.00.11200

	else
		id = nil;
	end

	if ( id ) then
		NuN_Key = MNCont.."-"..MNZone.."-"..id;
	end

	if ( NuN_Key ) then
		if ( ( NuNData[mrgIndex] ) and ( NuNData[mrgIndex][NuN_Key] ) ) then
			local index, value, lBttn, lHeight;
			local lWidth = NuNPopupTitle:GetWidth();
			local lCount = 0;
			NuNPopupButton1:SetText("");
			NuNPopupButton1:Hide();
			NuNPopupButton2:SetText("");
			NuNPopupButton2:Hide();
			NuNPopupButton3:SetText("");
			NuNPopupButton3:Hide();
			NuNPopupButton4:SetText("");
			NuNPopupButton4:Hide();
			NuNPopupButton5:SetText("");
			NuNPopupButton5:Hide();
			for index, value in pairs(NuNData[mrgIndex][NuN_Key]) do
				if ( index ~= "noteCounter" ) then
					if ( ( NuNDataANotes[index] ) or ( NuNDataRNotes[index] ) ) then
						lCount = lCount + 1;
						lBttn = getglobal("NuNPopupButton"..lCount);
						lBttn.note = index;
						lBttn:SetText(index);
						lBttn:Show();
						local tWidth = lBttn:GetTextWidth();
						if ( ( tWidth ) and ( tWidth > lWidth ) ) then
							lWidth = tWidth;
						end
					end
				end
			end
			if ( lCount > 0 ) then
				local lHeight = math.ceil( ((20*(lCount + 1)) + 10) );
				lWidth = math.ceil( (lWidth) * 1.15 );
				if ( lCount > 2 ) then
					lHeight = lHeight - (lCount * lCount);
				end
				NuNPopup:Hide();
				NuNPopup:ClearAllPoints();
				NuNPopup:SetHeight(lHeight);
				NuNPopup:SetWidth(lWidth);
				NuNPopupButton1:SetWidth(lWidth - 4);
				NuNPopupButton2:SetWidth(lWidth - 4);
				NuNPopupButton3:SetWidth(lWidth - 4);
				NuNPopupButton4:SetWidth(lWidth - 4);
				NuNPopupButton5:SetWidth(lWidth - 4);
				NuNPopup.id = id;
				local x, y = GetCursorPosition();
				if ( y > 300 ) then
					if ( x > 500 ) then
						NuNPopup:SetPoint("TOPRIGHT", lTooltip, "BOTTOMRIGHT", 0, 0);
						NuNPopup.point = "TOPRIGHT";
						NuNPopup.relativePoint = "BOTTOMRIGHT";
					else
						NuNPopup:SetPoint("TOPLEFT", lTooltip, "BOTTOMLEFT", 0, 0);
						NuNPopup.point = "TOPLEFT";
						NuNPopup.relativePoint = "BOTTOMLEFT";
					end
				else
					if ( x > 500 ) then
						NuNPopup:SetPoint("BOTTOMRIGHT", lTooltip, "TOPRIGHT", 0, 0);
						NuNPopup.point = "BOTTOMRIGHT";
						NuNPopup.relativePoint = "TOPRIGHT";
					else
						NuNPopup:SetPoint("BOTTOMLEFT", lTooltip, "TOPLEFT", 0, 0);
						NuNPopup.point = "BOTTOMLEFT";
						NuNPopup.relativePoint = "TOPLEFT";
					end
				end
				NuNPopupTitle:SetTextColor(0.1, 0.9, 0.1, 0.9);
--				popUpHide = nil;
				NuNPopup:SetAlpha(1);
				NuNPopup:Show();
				NuN_MapTooltip:ClearAllPoints();
				NuN_MapTooltipShow(NuNPopupButton1.note, "NuNPopup", NuNPopup.point, NuNPopup.relativePoint);
				NuNPopupButton1:LockHighlight();
				noPopup = nil;
			end
		end
	end

	if ( noPopup ) then
		if ( ( NuNDataPlayers[nName] ) or ( NuNDataRNotes[nName] ) or ( NuNDataANotes[nName] ) ) then
			NuN_MapTooltipShow(nName, lTooltip, nil, nil);
		end
	end
end


function NuN_MapTooltipShow(nName, relativeTo, point, relativePoint)
	local storePinned = NuN_PinnedTooltip.type;

	NuNPopupButton1:UnlockHighlight();
	if ( not nName ) then
		return;
	end
	gtName = nName;
	ttName = gtName;
	if ( ( ttName ~= nil ) and  ( ( NuNDataPlayers[ttName] ) or ( NuNDataRNotes[ttName] ) or ( NuNDataANotes[ttName] ) ) ) then
		NuN_State.NuN_Fade = false;
		NuN_MapTooltip:ClearLines();
		NuN_MapTooltip:Hide();
		NuN_MapTooltip:SetOwner(this, "ANCHOR_NONE");
		NuN_PinnedTooltip.type = "Nil";
		NuNF.NuN_BuildTT(NuN_MapTooltip);
		NuN_PinnedTooltip.type = storePinned;
		if ( ( point ) and ( relativePoint ) ) then
			NuN_MapTooltip:SetPoint(point, relativeTo, relativePoint, 0, 0);
		else
			local x, y = GetCursorPosition();
			if ( y > 300 ) then
				if ( x > 500 ) then
					NuN_MapTooltip:SetPoint("TOPRIGHT", relativeTo, "BOTTOMRIGHT", 0, 0);
				else
					NuN_MapTooltip:SetPoint("TOPLEFT", relativeTo, "BOTTOMLEFT", 0, 0);
				end
			else
				if ( x > 500 ) then
					NuN_MapTooltip:SetPoint("BOTTOMRIGHT", relativeTo, "TOPRIGHT", 0, 0);
				else
					NuN_MapTooltip:SetPoint("BOTTOMLEFT", relativeTo, "TOPLEFT", 0, 0);
				end
			end
		end
		if ( type(relativeTo) == "string" ) then
			relativeTo = getglobal(relativeTo);
		end
		NuN_MapTooltip:Show();
	else
		NuN_MapTooltip:ClearLines();
		NuN_MapTooltip:Hide();
	end
end


function NuN_WorldMapTooltip_OnHide()
	popUpHide = true;
	if ( NuNPopup:IsVisible() ) then
		WorldMapTooltip:Show();
	else
		NuN_MapTooltip:ClearLines();
		NuN_MapTooltip:Hide();
	end
end


function NuN_ItemRefTooltip_OnShow()
	gtName = ItemRefTooltipTextLeft1:GetText();
	ttName = gtName;

	if ( NuNData[itmIndex][ttName] ) then
		ttName = ( NuNData[itmIndex][ttName] );
	end
	if ( ( ttName ~= nil ) and ( ( NuNDataRNotes[ttName] ) or ( NuNDataANotes[ttName] ) ) ) then
		NuN_PinnedTooltip.noteName = ttName;
		NuN_State.NuN_Fade = false;
		NuN_ClearPinnedTT();
		NuN_PinnedTooltip:SetOwner(ItemRefTooltip, "ANCHOR_TOPLEFT");
		NuN_State.NuN_PinUpHeader = true;
		NuN_PinnedTooltip.type = "General";
		NuNF.NuN_BuildTT(NuN_PinnedTooltip);
		NuN_State.NuN_PinUpHeader = false;
		NuN_PinnedTooltip:Show();
		NuN_State.pinnedTTMoved = false;
		if ( NuNGNoteFrame:IsVisible() ) then
			NuN_GTTCheckBox:SetChecked( NuN_CheckPinnedBox(ttName) );
		end
	elseif ( not NuN_State.pinnedTTMoved ) then
		NuN_ClearPinnedTT();
	end
end


function NuN_ItemRefTooltip_OnHide()
	if ( not NuN_State.pinnedTTMoved ) then
		NuN_ClearPinnedTT();
	end
end


function NuN_FlagMoved()
	NuN_State.pinnedTTMoved = true;
	NuN_PinnedTooltip.x, NuN_PinnedTooltip.y = NuN_PinnedTooltip:GetCenter();
	NuNSettings[pKey].pT.x = NuN_PinnedTooltip.x;
	NuNSettings[pKey].pT.y = NuN_PinnedTooltip.y;
end


function NuN_GameTooltip_OnHide()
	popUpHide = true;
	noTipAnchor = nil;
	if ( not NuN_State.NuN_Fade ) then
		NuN_Tooltip:ClearLines();
		NuN_Tooltip:Hide();
	end
	if ( not NuNPopup:IsVisible() ) then
		NuN_MapTooltip:ClearLines();
		NuN_MapTooltip:Hide();
	end
end


function NuN_TTCheckBox_OnClick(frameType)
	NuN_State.pinnedTTMoved = false;
	if ( frameType == "Contact" ) then
		if ( NuN_CTTCheckBox:GetChecked() ) then
			ttName = c_name;
			NuN_PinnedTooltip.noteName = c_name;
			NuN_ClearPinnedTT();
			NuN_PinnedTooltip:SetOwner(this, ANCHOR_BOTTOMRIGHT);
			NuN_State.NuN_PinUpHeader = true;
			NuN_PinnedTooltip.type = frameType;
			NuNSettings[pKey].pT = {};
			NuNSettings[pKey].pT.type = "Contact";
			NuNSettings[pKey].pT.name = ttName;
			NuNF.NuN_BuildTT(NuN_PinnedTooltip);
			NuN_State.NuN_PinUpHeader = false;
			NuN_PinnedTooltip:Show();
			NuN_CTTCheckBox:SetChecked(true);
		else
			NuN_ClearPinnedTT();
		end
	elseif ( frameType == "General" ) then
		if ( NuN_GTTCheckBox:GetChecked() ) then
			ttName = c_note;
			NuN_PinnedTooltip.noteName = c_note;
			NuN_ClearPinnedTT();
			NuN_PinnedTooltip:SetOwner(this, ANCHOR_BOTTOMRIGHT);
			NuN_State.NuN_PinUpHeader = true;
			NuN_PinnedTooltip.type = frameType;
			NuNSettings[pKey].pT = {};
			NuNSettings[pKey].pT.type = "General";
			NuNSettings[pKey].pT.name = ttName;
			NuNF.NuN_BuildTT(NuN_PinnedTooltip);
			NuN_State.NuN_PinUpHeader = false;
			NuN_PinnedTooltip:Show();
			NuN_GTTCheckBox:SetChecked(true);
		else
			NuN_ClearPinnedTT();
		end
	end
end

-- Toggling of the NotesUNeed Pin up tooltip
function NuN_PinnedTooltipToggle(ttType, noteName, setTTOwner)
	if ( ( not ttType ) or ( not noteName ) ) then
		ttType = NuN_PinnedTooltip.type;
		noteName = NuN_PinnedTooltip.noteName;
		if ( ( not ttType ) or ( ttType == "Empty" ) or ( not noteName ) ) then
			if ( NuNGNoteFrame:IsVisible() ) then
				ttType = "General";
				noteName = c_note;

			elseif ( NuNFrame:IsVisible() ) then
				ttType = "Contact";
				noteName = c_name;
	
			else
				return;
			end
		end
	end
--toggle
	if ( ( not NuN_PinnedTooltip:IsVisible() ) or ( ( NuN_PinnedTooltip:IsVisible() ) and ( noteName ~= NuN_PinnedTooltip.noteName ) ) ) then
		ttName = noteName;
		NuN_PinnedTooltip.noteName = noteName;
		NuN_ClearPinnedTT();
		if ( setTTOwner ) then
			NuN_PinnedTooltip:SetOwner(this, ANCHOR_BOTTOMRIGHT);
		else
			NuN_PinnedTooltip:SetOwner(UIParent, ANCHOR_NONE);
		end
		NuN_State.NuN_PinUpHeader = true;
		NuN_PinnedTooltip.type = ttType;
		NuNSettings[pKey].pT = {};
		NuNSettings[pKey].pT.type = ttType;
		NuNSettings[pKey].pT.name = ttName;
		NuNF.NuN_BuildTT(NuN_PinnedTooltip);
		NuN_State.NuN_PinUpHeader = false;
		NuN_PinnedTooltip:Show();
		if ( not setTTOwner ) then
			if ( ( NuN_PinnedTooltip.x ) and ( NuN_PinnedTooltip.y ) ) then
				NuN_PinnedTooltip:ClearAllPoints();
				NuN_PinnedTooltip:SetPoint("CENTER", "UIParent", "BOTTOMLEFT", NuN_PinnedTooltip.x, NuN_PinnedTooltip.y);
			else
				NuN_PinnedTooltip:ClearAllPoints();
				NuN_PinnedTooltip:SetPoint("TOP", "UIParent", "TOP", 0, -60);
			end
		end

	else
		NuN_ClearPinnedTT();
	end

	if ( ( ttType == "Contact" ) and ( NuNFrame:IsVisible() ) ) then
		if ( ( NuN_PinnedTooltip:IsVisible() ) and ( NuN_PinnedTooltip.noteName == c_name ) ) then
			NuN_CTTCheckBox:SetChecked(1);
		else
			NuN_CTTCheckBox:SetChecked(0);
		end
	elseif ( ( ttType == "General" ) and ( NuNGNoteFrame:IsVisible() ) ) then
		if ( ( NuN_PinnedTooltip:IsVisible() ) and ( NuN_PinnedTooltip.noteName == c_note ) ) then
			NuN_GTTCheckBox:SetChecked(1);
		else
			NuN_GTTCheckBox:SetChecked(0);
		end
	end
end


function NuN_ClearPinnedTT()
	if ( NuN_PinnedTooltip:IsVisible() ) then
		NuN_PinnedTooltip:ClearLines();
		NuN_PinnedTooltip:Hide();
	end
end


function NuN_CheckPinnedBox(tst)
	if ( ( NuN_PinnedTooltip:IsVisible() ) and ( NuN_PinnedTooltip.noteName == tst ) ) then
		return 1;
	else
		return 0;
	end
end



function NuN_PinnedTT_OnClick()
	local ttTitle = NuN_PinnedTooltipTextLeft2:GetText();

	if ( NuN_PinnedTooltip.type == "Contact" ) then
		if ( NuNDataPlayers[ttTitle] ) then
			NuN_ShowSavedNote(ttTitle);
		end

	elseif ( NuN_PinnedTooltip.type == "General" ) then
		if ( NuNData[itmIndex][ttTitle] ) then
			ttTitle = NuNData[itmIndex][ttTitle];
		end
		if ( ( NuNDataRNotes[ttTitle] ) or ( NuNDataANotes[ttTitle] ) ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "General" ) ) then
				return;
			end
			c_note = ttTitle;
			NuNGNoteFrame.fromQuest = nil;
			NuN_ShowSavedGNote();
		end
	end
end


function NuN_PinnedTT_OnHide()
	NuNSettings[pKey].pT = nil;
	if ( NuN_PinnedTooltip.type == "Contact" ) then
		if ( ( NuNFrame:IsVisible() ) and ( NuN_CTTCheckBox:GetChecked() ) ) then
			NuN_CTTCheckBox:SetChecked(0);
		end

	elseif ( NuN_PinnedTooltip.type == "General" ) then
		if ( ( NuNGNoteFrame:IsVisible() ) and ( NuN_GTTCheckBox:GetChecked() ) ) then
			NuN_GTTCheckBox:SetChecked(0);
		end
	end
end


function NuN_OpenChat(noteType)
	local dspText, dspTextL;
	local hdrMax = 29;

--	UIDropDownMenu_ClearAll(NuNChatDropDown);
--	NuNTransmit:Disable();
--	NuNChatTextBox:Hide();
	NuN_ChatFrame.type = noteType;
	if ( noteType == "Contact" ) then
		dspText = c_name;
		NuN_ChatCheckBox:Show();
	elseif ( noteType == "General" ) then
		dspText = c_note;
		NuN_ChatCheckBox:Hide();
	end
	if ( string.find(dspText, "|Hitem:") ) then
		hdrMax = hdrMax + 50;
	end
	dspTextL = string.len(dspText);
	if ( dspTextL > hdrMax ) then
		dspText = string.sub(dspText, 1, hdrMax).."....";
	end
	NuNChatNoteTitle:SetText(dspText);
	NuN_ChatFrame:Show();

end


-- -sendC, -sendG, -sendCF, -sendGF
function NuN_ManualTransmit(formatted, tType, parms)
	if ( formatted ) then
		NuN_ChatFormatCheckBox:SetChecked(1);
	else
		NuN_ChatFormatCheckBox:SetChecked(0);
	end

	if ( tType ) then
		_, _, noteName, sendType, tUser = string.find(parms, "\"(.*)\"%,*%s*\"(.*)\"%,*%s*\"(.*)\"");
		if ( not noteName ) then
			_, _, noteName, sendType, tUser = string.find(parms, "\"(.*)\"%,*%s*\"(.*)\"");
		end

		if ( ( noteName ) and ( sendType ) ) then
			
			-- just to be a tiny bit more forgiving
			sendType = string.upper(sendType);
			
			if ( sendType == "CHANNEL" ) then
				if ( not tUser ) then
					NuN_Message("Invalid Channel");
					return;
				end
				local nTest = tonumber(tUser);
				if ( nTest ) then
					sendToChannel.id, sendToChannel.name = GetChannelName(nTest);
				else
					sendToChannel.name = tUser;
					sendToChannel.id = GetChannelName(tUser);
				end
				tUser = sendToChannel.id;

			elseif ( sendType == "WHISPER" ) then
				if ( not tUser ) then
					NuN_Message("Invalid WHISPER Target");
					return;
				end
			end
		
			if ( ( tType == "Contact" ) and ( NuNDataPlayers[noteName] ) ) then
				if ( NuNFrame:IsVisible() ) then
					NuNEditDetailsFrame:Hide();
					NuNFrame:Hide();
				end
				NuN_ShowSavedNote(noteName);

			elseif ( NuNF.NuN_GNoteExists(noteName) ) then
				NuNGNoteFrame.fromQuest = nil;
				NuN_ShowSavedGNote();
				
			else
				NuN_Message(NUN_TRANSMISSION_MISSING .. " : " .. noteName);
				return;
			end

			sendTo = sendType;

			if ( sendTo ) then
				NuN_Transmit(tType, tUser);
			end

			NuNEditDetailsFrame:Hide();
			NuNFrame:Hide();
			NuNGNoteFrame:Hide();

		else
			NuN_Message("Invalid Parameters : " .. parms);
		end
	end
end


------------------------------------------------------------------------------------------------------------------
-- Functions for Splitting Notes and Sending them to other Players / Broadcasting to channels --
-- Main Transmit function
function NuN_Transmit(tType, tUser)
	local dfltLang = nil;
	local user = nil;
	local error = nil;
	local singleLine;
	local parsedArray = {};
	local contents = nil;
	local linesInError = {};
	local nonCriticalError = false;
	local e = 0;
	local tLog = "Transmit Log ";
	local chatTarget;
	local prfx;
	local msgPrfx = "";
	local logText = "";
	local saveLvl;
	local sendAll = true;
	local formattedNote = NuN_ChatFormatCheckBox:GetChecked();
	local msgDelay = 0;

	-- ensure valid delay value, otherwise reset the value and the edit box displayed value
	if ( NuN_ChatDelay_EditBoxValidate() ) then
		NuN_ChatDelay_EditBoxInit();
	end

	NuNTransmit:Disable();
	NuN_transmissionTimer = defaultReceiptDeadline;
	busySending.active = true;

	msgSeq = msgSeq + 1;
	if ( msgSeq > 9 ) then
		msgSeq = 1;
	end
	local errorNoteName = pName.."_X"..msgSeq;
	NuN_msgKey = pName..msgSeq..":";
	tLog = tLog..NuN_msgKey;

	if ( formattedNote ) then
		msgPrfx = NuN_msgKey;
	end

	if ( NuNSettings[pKey].dLevel ) then
		NuNDataANotes[tLog] = {};
		logText = NuNF.NuN_GetDateStamp().."\n";
		NuNDataANotes[tLog].type = NuNGet_CommandID(NUN_NOTETYPES, "LOG");
		saveLvl = "Account";
	else
		NuNDataRNotes[tLog] = {};
		logText = NuNF.NuN_GetDateStamp().."\n";
		NuNDataRNotes[tLog].type = NuNGet_CommandID(NUN_NOTETYPES, "LOG");
		saveLvl = "Realm";
	end

	if ( NuNChatTextBox:IsVisible() ) then
		user = NuNChatTextBox:GetText();
		busySending.user = user;
	elseif ( tUser ) and ( sendTo == "WHISPER" ) then						-- 5.61
		user = tUser;														-- 5.61
		busySending.user = user;											-- 5.61
	end

	if ( sendTo == "WHISPER" ) or ( sendTo == "NuN" ) then
		chatTarget = user;
	elseif ( sendTo == "CHANNEL" ) then
		msgDelay = NuN_DTrans.tDelay;
		if ( ( not sendToChannel.id ) or ( sendToChannel.id < 1 ) ) then
			NuN_Message("Invalid id");
			return;
		else
			local cIndex, cName = GetChannelName(sendToChannel.id);
			if ( not cName ) then
				NuN_Message("Invalid name"..sendToChannel.name.." : "..sendToChannel.id);
				return;
			else
				user = sendToChannel.id;
				chatTarget = sendToChannel.name;
			end
		end
	else
		chatTarget = sendTo;
		if ( ( sendTo == "GUILD" ) or ( sendTo == "OFFICER" ) ) then
			if ( not GetGuildInfo("player") ) then
				sendAll = nil;
			end
		elseif ( ( sendTo == "RAID" ) or ( sendTo == "RAID_WARNING" ) ) then
			if ( not UnitInRaid("player") ) then
				sendAll = nil;
			end
		elseif ( sendTo == "PARTY" ) then
			if ( ( not GetNumPartyMembers() ) or ( GetNumPartyMembers() < 1 ) ) then
				sendAll = nil;
			end
		end
	end
	
	prfx = NuN_msgKey..NUN_TRANSMISSION_PREFIX1..pName.."  --->  "..chatTarget.." ::"..msgDelay.."::";
	prfx2 = NuN_msgKey..NuNC.NUN_SOURCE..NUN_CLIENT.." v"..NUN_VERSION;
	logText = logText.."\n"..prfx;

	-- Which type of note to create
	if ( tType == "Contact" ) then										-- 5.61
		parsedArray, error = NuN_TransmitContact(dfltLang, user);		-- 5.61
	elseif ( tType == "General" ) then									-- 5.61
		parsedArray, error = NuN_TransmitGeneral(dfltLang, user);		-- 5.61
	elseif ( NuN_ChatFrame.type == "Contact" ) then						-- 5.61
		parsedArray, error = NuN_TransmitContact(dfltLang, user);
	else
		parsedArray, error = NuN_TransmitGeneral(dfltLang, user);
	end

	if ( parsedArray ) then
		local tmp_c_note = c_note;
		local tmp_g_text = g_text;
		contents = getn(parsedArray);
		local lineCount = 0;
		local flagged = nil;
		for i=1, contents, 1 do
			singleLine = parsedArray[i];
			singleLine = string.gsub(singleLine, "\n", " ");
			singleLine = string.gsub(singleLine, "\\n", " ");
			if ( string.len(singleLine) > 255 ) then
				error = "Err02";
				break;
			end
			local beginnings = NuN_Validate(singleLine, "|c");
			local endings = NuN_Validate(singleLine, "|h|r");
			if ( beginnings == endings ) then
				parsedArray[i] = singleLine;
				lineCount = lineCount + 1;
				if ( string.len(logText) < (NuNC.NUN_MAX_TXT_LIM - 360) ) then
					logText = logText.."\n"..singleLine;
				elseif ( not flagged ) then
					flagged = true;
					logText = logText.."\n"..NUN_NOROOM;
				end

			else
				parsedArray[i] = "";
				nonCriticalError = true;
				e = e + 1;
				linesInError[e] = NUN_LINEERROR_TEXT.."----->"..i.." : \n";
				e = e + 1;
				linesInError[e] = singleLine.."\n";
			end
		end
		c_note = tLog;
		g_text = logText;
		NuNF.NuN_SetGText(saveLvl);
		c_note = tmp_c_note;
		g_text = tmp_g_text;
	end

	local dCount = 0;

	if ( contents ) and ( not error ) then
		if ( sendTo == "SELF" ) then
			DEFAULT_CHAT_FRAME:AddMessage(prfx);
		elseif ( ( sendTo == "CHANNEL" ) and ( not formattedNote ) ) then

		else
			if ( msgDelay == 0 ) then
				SendChatMessage(prfx, sendTo, dfltLang, user);
			else
				dCount = dCount + 1;
				NuN_DTrans.pArray[ dCount ] = prfx;
			end
		end
		if ( sendAll ) then
			if ( formattedNote ) then
				NuN_Message(NUN_SENDING_NOTE.." -> "..chatTarget);
				if ( sendTo == "SELF" ) then
					DEFAULT_CHAT_FRAME:AddMessage(prfx2);
				else
					if ( msgDelay == 0 ) then
						SendChatMessage(prfx2, sendTo, dfltLang, user);
					else
						dCount = dCount + 1;
						NuN_DTrans.pArray[ dCount ] = prfx2;
					end
				end
			end
			for i=1, contents, 1 do
				if ( sendTo == "SELF" ) then
					DEFAULT_CHAT_FRAME:AddMessage(msgPrfx..parsedArray[i]);
				else
					if ( msgDelay == 0 ) then
						SendChatMessage(msgPrfx..parsedArray[i], sendTo, dfltLang, user);
					else
						dCount = dCount + 1;
						NuN_DTrans.pArray[ dCount ] = msgPrfx..parsedArray[i];
					end
				end
			end
		end
	elseif ( error ) then
		NuN_Message(NUN_TRANSMISSION_ERROR..error);
	else
		NuN_Message(NUN_TRANSMISSION_MISSING);
	end

	if ( dCount > 0 ) then
		NuN_DTrans.Status = "Sending";
		NuN_DTrans.Params.sendTo = sendTo;
		NuN_DTrans.Params.dfltLang = dfltLang;
		NuN_DTrans.Params.user = user;
		NuN_DTrans.tTrack = 0;
		NuN_transmissionTimer = defaultReceiptDeadline + ( msgDelay * dCount );
	end

	if ( nonCriticalError ) then
		if ( NuNSettings[pKey].dLevel ) then
			NuNDataANotes[errorNoteName] = {};
			NuNDataANotes[errorNoteName].txt = "";
			NuNDataANotes[errorNoteName].type = NuNGet_CommandID(NUN_NOTETYPES, "LOG");
		else
			NuNDataRNotes[errorNoteName] = {};
			NuNDataRNotes[errorNoteName].txt = "";
			NuNDataANotes[errorNoteName].type = NuNGet_CommandID(NUN_NOTETYPES, "LOG");
		end
		for i=1, getn(linesInError), 1 do					-- #linesInError
			local lineTxt = NuNF.NuN_SetSaveText( linesInError[i].."\n" );
			if ( NuNSettings[pKey].dLevel ) then
				NuNDataANotes[errorNoteName].txt = NuNDataANotes[errorNoteName].txt..lineTxt;
			else
				NuNDataRNotes[errorNoteName].txt = NuNDataRNotes[errorNoteName].txt..lineTxt;
			end
		end
		NuN_Message(NUN_NONCRITICAL_ERROR..errorNoteName);
	end
end



function NuN_TransmitContact(dfltLang, user)
	local parsedArray = {};
	local singleLine = "";
	local lineType = "";
	local formatIt = NuN_ChatFormatCheckBox:GetChecked();


	if ( NuNDataPlayers[c_name] ) then
		local parsedArray = {};
		local singleLine = "";
		local arrayCounter = 0;
		local parseText = "";
		local txtArray = {};

		if ( formatIt ) then
			arrayCounter = arrayCounter + 1;
			parsedArray[arrayCounter] = NUN_TRANSMISSION_PREFIX2.."Contact : "..c_name;
--		else
--			parsedArray[arrayCounter] = c_name;
		end

		if ( not NuN_ChatCheckBox:GetChecked() ) then
			local generalCode = "<";
			singleLine = NuNDataPlayers[c_name].faction;
			if ( NuNDataPlayers[c_name].race ) then
				if ( NuN_horde ) then
					singleLine = singleLine..",  "..NUN_HRACES[NuNDataPlayers[c_name].race];
				else
					singleLine = singleLine..",  "..NUN_ARACES[NuNDataPlayers[c_name].race];
				end
				generalCode = generalCode..NuNDataPlayers[c_name].race;
			elseif ( formatIt ) then
				singleLine = singleLine..", -";
				generalCode = generalCode.."-";
			end
			if ( NuNDataPlayers[c_name].cls ) then
				if ( NuN_horde ) then
					singleLine = singleLine..",  "..NUN_HCLASSES[NuNDataPlayers[c_name].cls];
				else
					singleLine = singleLine..",  "..NUN_ACLASSES[NuNDataPlayers[c_name].cls];
				end
				generalCode = generalCode..","..NuNDataPlayers[c_name].cls;
			elseif ( formatIt ) then
				singleLine = singleLine..", -";
				generalCode = generalCode..",-";
			end
			if ( NuNDataPlayers[c_name].sex ) then
				singleLine = singleLine..",  "..NUN_SEXES[NuNDataPlayers[c_name].sex];
				generalCode = generalCode..","..NuNDataPlayers[c_name].sex;
			elseif ( formatIt ) then
				singleLine = singleLine..", -";
				generalCode = generalCode..",-";
			end
			if ( NuNDataPlayers[c_name].prating ) then
				singleLine = singleLine..", "..NuNSettings.ratings[NuNDataPlayers[c_name].prating];
				generalCode = generalCode..","..NuNDataPlayers[c_name].prating;
			elseif ( formatIt ) then
				singleLine = singleLine..", -";
				generalCode = generalCode..",-";
			end
			if ( NuNDataPlayers[c_name].prof1 ) then
				singleLine = singleLine..",  "..NUN_PROFESSIONS[NuNDataPlayers[c_name].prof1];
				generalCode = generalCode..","..NuNDataPlayers[c_name].prof1;
			elseif ( formatIt ) then
				singleLine = singleLine..", -";
				generalCode = generalCode..",-";
			end
			if ( NuNDataPlayers[c_name].prof2 ) then
				singleLine = singleLine..",  "..NUN_PROFESSIONS[NuNDataPlayers[c_name].prof2];
				generalCode = generalCode..","..NuNDataPlayers[c_name].prof2;
			elseif ( formatIt ) then
				singleLine = singleLine..", -";
				generalCode = generalCode..",-";
			end
			if ( NuNDataPlayers[c_name].arena ) then
				singleLine = singleLine..", "..NUN_ARENAR[NuNDataPlayers[c_name].arena];
				generalCode = generalCode..","..NuNDataPlayers[c_name].arena;
			elseif ( formatIt ) then
				singleLine = singleLine..", -";
				generalCode = generalCode..",-";
			end
			if ( NuNDataPlayers[c_name].hrank ) then
				if ( NuN_horde ) then
					singleLine = singleLine..",  "..NUN_HRANKS[NuNDataPlayers[c_name].hrank];
				else
					singleLine = singleLine..",  "..NUN_ARANKS[NuNDataPlayers[c_name].hrank];
				end
				generalCode = generalCode..","..NuNDataPlayers[c_name].hrank..">";
			elseif ( formatIt ) then
				singleLine = singleLine..", -";
				generalCode = generalCode..",->";
			end

			if ( singleLine ~= "" ) then
				if ( formatIt ) then
					lineType = "G:";
				end
				singleLine = lineType..singleLine;
				if ( formatIt ) then
					singleLine = singleLine.." "..generalCode;
				end
				arrayCounter = arrayCounter + 1;
				parsedArray[arrayCounter] = singleLine;
			end

			if ( formatIt ) then
				lineType = "U:";
			end
			for n = 1, uBttns, 1 do
				singleLine = "";
				hdNbr = pHead..n;
				nameHdNbr = c_name..hdNbr;
				nameDtNbr = c_name..pDetl..n;
				if ( ( NuNDataPlayers[nameHdNbr] ) and ( NuNDataPlayers[nameHdNbr].txt ) ) then
					singleLine = NuNDataPlayers[nameHdNbr].txt.."~    ";
				elseif ( NuNSettings[pKey][hdNbr] ) then
					singleLine = NuNSettings[pKey][hdNbr].txt.."~    ";
				else
					singleLine = NUN_DFLTHEADINGS[n].."~    ";
				end
				if ( ( NuNDataPlayers[nameDtNbr] ) and ( NuNDataPlayers[nameDtNbr].txt ) ) then
					singleLine = singleLine.."~"..NuNDataPlayers[nameDtNbr].txt;
				end
				if ( singleLine ~= "" ) then
					arrayCounter = arrayCounter + 1;
					singleLine = lineType..n..":"..singleLine;
					parsedArray[arrayCounter] = singleLine;
				end
			end
		end

--		parseText = NuNF.NuN_GetCText(c_name);
		parseText = NuNText:GetText();
		txtArray = NuN_ParseNote(parseText);
		if ( txtArray ) then
			local lKey = 0;
			for i=1, getn(txtArray), 1 do					-- #txtArray
				if ( formatIt ) then
					lKey = lKey + 1;
					if ( lKey > 9 ) then
						lKey = 1;
					end
					lineType = "T:"..lKey;
				end
				arrayCounter = arrayCounter + 1;
				parsedArray[arrayCounter] = lineType..txtArray[i];
			end
		end

		if ( formatIt ) then
			arrayCounter = arrayCounter + 1;
			parsedArray[arrayCounter] = NUN_TRANSMISSION_POSTFIX.."Contact : "..c_name;
		end

		return parsedArray, nil;
	else
		return nil, "Err01";
	end
end



function NuN_TransmitGeneral(dfltLang, user)
	local ref = c_note;
	local lineType = "";
	local formatIt = NuN_ChatFormatCheckBox:GetChecked();

	if ( NuNData[itmIndex][ref] ) then
		ref = NuNData[itmIndex][ref];
	end

	if ( ( NuNDataRNotes[ref] ) or ( NuNDataANotes[ref] ) ) then
		local parsedArray = {};
		local singleLine = "";
		local arrayCounter = 0;
		local parseText = "";
		local txtArray = {};
		local nType;

		if ( ( NuNDataRNotes[ref] ) and ( NuNDataRNotes[ref].type ) ) then
			nType = NuNDataRNotes[ref].type;
		elseif ( ( NuNDataANotes[ref] ) and ( NuNDataANotes[ref].type ) ) then
			nType = NuNDataANotes[ref].type;
		else
			nType = 1;
		end

		if ( not formatIt ) then
			nType = NUN_NOTETYPES[nType].Display;
			if ( nType == "   " ) then
				nType = "-";
			end
		end

		if ( formatIt ) then
			arrayCounter = arrayCounter + 1;
			parsedArray[arrayCounter] = NUN_TRANSMISSION_PREFIX2.."General("..nType..") : "..c_note;
--		else
--			parsedArray[arrayCounter] = c_note;
		end

--		parseText = NuNF.NuN_GetGText(c_note);
		parseText = NuNGNoteTextScroll:GetText();
		txtArray = NuN_ParseNote(parseText);
		if ( txtArray ) then
			local lKey = 0;
			for i=1, getn(txtArray), 1 do				-- #txtArray
				if ( formatIt ) then
					lKey = lKey + 1;
					if ( lKey > 9 ) then
						lKey = 1;
					end
					lineType = "T:"..lKey;
				end
				arrayCounter = arrayCounter + 1;
				parsedArray[arrayCounter] = lineType..txtArray[i];
			end
		end

		if ( formatIt ) then
			arrayCounter = arrayCounter + 1;
			parsedArray[arrayCounter] = NUN_TRANSMISSION_POSTFIX.."General : "..c_note;
		end

		return parsedArray, nil;
	else
		return nil, "Err01";
	end
end



function NuN_ParseNote(parseText)
	local parsedArray = {};
	local arrayCounter = 0;
	local p1 = 0;
	local p2 = 0;
	local txtTmp = "";

	if ( ( not parseText ) or ( parseText == "" ) or ( parseText == "\n" ) or ( parseText == " " ) ) then
		return nil;
	end

	parseText = NuN_RemoveColours(parseText);

	if ( ( not parseText ) or ( parseText == "" ) or ( parseText == "\n" ) or ( parseText == " " ) ) then
		return nil;
	end

	parseText = NuN_CheckHyperlinkPositions(parseText);
	parseText = NuN_CheckEnchantLinkPositions(parseText);

	local parseTextLen = string.len(parseText);
	local negOffset = -1 * (parseTextLen);

	parseText = gsub(parseText, "|h|r\n", "|h|r");	-- Not EVERY Hyperlink is NECESSARILY followed by a SINGLE new line...
	parseText = gsub(parseText, "|h|r", "|h|r\n");	-- Until AFTER BOTH of these lines of code

	while ( negOffset < 0 ) do
		p2 = string.find(parseText, "\n", (p1+1) );
		if ( ( p2 == nil ) or ( p2 > ( NuNC.NUN_CHAT_LIMIT + p1 ) ) ) then
			negOffset = p1 + NuNC.NUN_CHAT_LIMIT - parseTextLen;
			if ( negOffset < 0 ) then
				p2 = string.find(parseText, " ", negOffset);
				if ( ( p2 == nil ) or ( p2 <= p1 ) ) then
					txtTmp = string.sub(parseText, (p1+1), (p1+NuNC.NUN_CHAT_LIMIT));
				else
					txtTmp = string.sub(parseText, (p1+1), p2);
				end
			else
				txtTmp = string.sub(parseText, (p1+1));
			end
		else
			txtTmp = string.sub(parseText, (p1+1), p2);
		end
		if ( p2 ) then
			p1 = p2;
		else
			p1 = parseTextLen;
		end
		if ( txtTmp ~= "" ) and ( txtTmp ~= " " ) then
			arrayCounter = arrayCounter + 1;
			parsedArray[arrayCounter] = txtTmp;
		end
	end

	return parsedArray;
end


function NuN_RemoveColours(colouredText)
	local plainText, preText, postText, midText = "", "", "", "";
	local workingText = string.gsub(colouredText, "<", "1~");
	local workingText = string.gsub(workingText, ">", "2~");

	local next = 0;
	while ( true ) do
		local ps = string.find(workingText, "|c%x%x%x%x%x%x%x%x", next+1);
		if ( ps ) then
			if ( string.sub(workingText, ps+10, ps+16) == "|Hitem:" ) then
			elseif ( string.sub(workingText, ps+10, ps+19) == "|Henchant:" ) then
			else
				if ( string.sub(workingText, ps+10, ps+11) == "|h" ) then
					toEnd = 2;
				else
					toEnd = 0;
				end
				if ( ps == 1 ) then
					preText = "";
				else
					preText = string.sub(workingText, 1, ps-1);
				end
				midText = string.sub(workingText, ps, (ps+9+toEnd));
				postText = string.sub(workingText, ps+10+toEnd);
				workingText = preText .. "<" .. midText .. ">" .. postText;
				ps = ps + 2;
			end
			next = ps+8;
		else
			break;
		end
	end

	local next = 0;
	while ( true ) do
		local ps = string.find(workingText, "|r", next+1);
		if ( ps ) then
			if ( string.sub(workingText, ps-3, ps-1) == "\]|h" ) then
			else
				if ( string.sub(workingText, ps-2, ps-1) == "|h" ) then
					fromStart = -2;
				else
					fromStart = 0;
				end
				if ( ps == 1 ) then
					preText = "";
				else
					preText = string.sub(workingText, 1, (ps-1+fromStart));
				end
				midText = string.sub(workingText, (ps+fromStart), ps+1);
				postText = string.sub(workingText, ps+2);
				workingText = preText .. "<" .. midText .. ">" .. postText;
				ps = ps + 2;
			end
			next = ps;
		else
			break;
		end
	end
	workingText = string.gsub(workingText, "%b<>", "");

	plainText = string.gsub(workingText, "1~", "<");
	plainText = string.gsub(plainText, "2~", ">");

	return plainText;
end


function NuN_Validate(txt, tst)
	local p1 = 0;
	local p2 = 0;
	local count = 0;

	while ( true ) do
		p2 = string.find(txt, tst, (p1+1));
		if ( p2 == nil ) then
			break;
		else
			count = count + 1;
			p1 = p2;
		end
	end

	return count;
end

function NuN_ChatFormatCheckBox_OnClick()
	if ( NuN_ChatFormatCheckBox:GetChecked() ) then
		NuN_Message(NUN_TRANSMISSION_WARNING);
		PlaySound("igMainMenuOptionCheckBoxOn");
	else
		PlaySound("igMainMenuOptionCheckBoxOff");
	end
end

function NuN_CheckHyperlinkPositions(theText)
	local hypBegs = {};
	local p1 = 0;
	local p2 = 0;
	local counter = 0;
	local Begs = 0;
	local rtrnText = "";

	while ( true ) do
		p2 = string.find(theText, "|Hitem:", (p1+1) );
		if ( p2 == nil ) then
			break;
		else
			counter = counter + 1;
			hypBegs[counter] = p2 - 10;
			p1 = p2;
		end
	end

	if ( hypBegs ) then
		local base = 1;
		local preText = "";
		local len = 0;
		for i=1, getn(hypBegs), 1 do						-- #hypBegs
			preText = string.sub(theText, base, (hypBegs[i] - 1));
			len = string.len(preText);
			local p3 = 0;
			local p4 = 0;
			p2 = nil;
			while ( true ) do
				p4 = string.find(preText, "\n", (p3+1));
				if ( p4 == nil ) then
					break;
				else
					p2 = p4;
					p3 = p4;
				end
			end
			if ( p2 == nil ) and ( len > 120 ) then
				rtrnText = rtrnText..preText.."\n";
				base = base + len;
			elseif ( p2 ) and ( (len - p2) > 120 ) then
				rtrnText = rtrnText..preText.."\n";
				base = base + len;
			elseif ( p2 ) then
				rtrnText = rtrnText..string.sub(theText, base, (base + p2));
				base = base + p2 + 1;
			end
		end
		rtrnText = rtrnText..string.sub(theText, base);
	end

	return rtrnText;
end

function NuN_CheckEnchantLinkPositions(theText)
	local hypBegs = {};
	local p1 = 0;
	local p2 = 0;
	local counter = 0;
	local Begs = 0;
	local rtrnText = "";

	while ( true ) do
		p2 = string.find(theText, "|Henchant:", (p1+1) );
		if ( p2 == nil ) then
			break;
		else
			counter = counter + 1;
			hypBegs[counter] = p2 - 10;
			p1 = p2;
		end
	end

	if ( hypBegs ) then
		local base = 1;
		local preText = "";
		local len = 0;
		for i=1, getn(hypBegs), 1 do						-- #hypBegs
			preText = string.sub(theText, base, (hypBegs[i] - 1));
			len = string.len(preText);
			local p3 = 0;
			local p4 = 0;
			p2 = nil;
			while ( true ) do
				p4 = string.find(preText, "\n", (p3+1));
				if ( p4 == nil ) then
					break;
				else
					p2 = p4;
					p3 = p4;
				end
			end
			if ( p2 == nil ) and ( len > 120 ) then
				rtrnText = rtrnText..preText.."\n";
				base = base + len;
			elseif ( p2 ) and ( (len - p2) > 120 ) then
				rtrnText = rtrnText..preText.."\n";
				base = base + len;
			elseif ( p2 ) then
				rtrnText = rtrnText..string.sub(theText, base, (base + p2));
				base = base + p2 + 1;
			end
		end
		rtrnText = rtrnText..string.sub(theText, base);
	end

	return rtrnText;
end

-- Functions for Splitting and Sending Notes to other Players --
---------------------------------------------------------------------------------


function NuN_NPCTarget()
	local chkName = UnitName("target");
	local npcText = "";

	if ( ( chkName ) and ( not UnitPlayerControlled("target") ) ) then
		NPCInfo_Proceed = nil;
		NuN_NPCInfo(NuN_NPCGetText);
	end
end


function NuN_NPCGetText()
	local npcText = NuN_NPCInfo();
	NuNGNoteTextScroll:SetText( NuNGNoteTextScroll:GetText().."\n"..npcText );
	GameTooltip:ClearLines();
	GameTooltip:Hide();
end



function NuNScaleFrameShow()
	if ( NuN_ScaleFrame:IsVisible() ) then
		NuN_ScaleFrame:Hide();
	else
		NuN_ScaleFrame:Show();
	end
end


function NuNFrameScaleSlider_OnShow()
	local pScale = NuNSettings[pKey].pScale;

	NuNFrameScaleSliderLow:SetText(NuNC.NUN_FRAMESCALE_MAX_TXT);
	NuNFrameScaleSliderHigh:SetText(NuNC.NUN_FRAMESCALE_MIN_TXT);

	NuNFrameScaleSliderCurrent:SetText( string.format("%d", (pScale * 100)) .. "%");
	this:SetMinMaxValues(NuNC.NUN_FRAMESCALE_MIN, NuNC.NUN_FRAMESCALE_MAX);
	this:SetValueStep(NuNC.NUN_FRAMESCALE_STEP);
	this:SetValue(NuNC.NUN_FRAMESCALE_MIN + NuNC.NUN_FRAMESCALE_MAX - pScale);
	this.previousValue = this:GetValue();
end


function NuNFrameScaleSlider_OnValueChanged()
	local pScale;

	if (this:GetValue() ~= this.previousValue) then
		this.previousValue = this:GetValue();
		pScale = (NuNC.NUN_FRAMESCALE_MIN + NuNC.NUN_FRAMESCALE_MAX - this:GetValue());
		NuNSettings[pKey].pScale = pScale;
		NuNFrameScaleSliderCurrent:SetText( string.format("%d", (pScale * 100)) .. "%");
		if ( NuNOptionsFrame:IsVisible() ) then
			NuNOptionsFrame:SetScale(NuNSettings[pKey].pScale);
		end
		if ( NuNFrame:IsVisible() ) then
			NuNFrame:SetScale(NuNSettings[pKey].pScale);
		end
		if ( NuNGNoteFrame:IsVisible() ) then
			NuNGNoteFrame:SetScale(NuNSettings[pKey].pScale);
		end
		if ( NuNSearchFrame:IsVisible() ) then
			NuNSearchFrame:SetScale(NuNSettings[pKey].pScale);
		end
	end
end


function NuNFontScaleSlider_OnShow()
	local tScale = NuNSettings[pKey].tScale;

	NuNFontScaleSliderLow:SetText(NuNC.NUN_TT_FONTSCALE_MAX_TXT);
	NuNFontScaleSliderHigh:SetText(NuNC.NUN_TT_FONTSCALE_MIN_TXT);

	NuNFontScaleSliderCurrent:SetText( string.format("%d", (tScale * 100)) .. "%");
	this:SetMinMaxValues(NuNC.NUN_TT_FONTSCALE_MIN, NuNC.NUN_TT_FONTSCALE_MAX);
	this:SetValueStep(0.01);	-- 5.60 replaced constant (note NuNC.NUN_FONT deleted also)
	this:SetValue(NuNC.NUN_TT_FONTSCALE_MIN + NuNC.NUN_TT_FONTSCALE_MAX - tScale);
	this.previousValue = this:GetValue();
end


function NuNFontScaleSlider_OnValueChanged()
	local tScale;

	if (this:GetValue() ~= this.previousValue) then
		this.previousValue = this:GetValue();
		tScale = (NuNC.NUN_TT_FONTSCALE_MIN + NuNC.NUN_TT_FONTSCALE_MAX - this:GetValue());
		NuNSettings[pKey].tScale = tScale;
		NuNFontScaleSliderCurrent:SetText( string.format("%d", (tScale * 100)) .. "%");
		NuN_PinnedTooltip:SetScale(NuNSettings[pKey].tScale);
		NuN_Tooltip:SetScale(NuNSettings[pKey].tScale);
	end
end



function NuNMapFontScaleSlider_OnShow()
	local mScale = NuNSettings[pKey].mScale;

	NuNMapFontScaleSliderLow:SetText(NuNC.NUN_TT_MAPFONTSCALE_MAX_TXT);
	NuNMapFontScaleSliderHigh:SetText(NuNC.NUN_TT_MAPFONTSCALE_MIN_TXT);

	NuNMapFontScaleSliderCurrent:SetText( string.format("%d", (mScale * 100)) .. "%");
	this:SetMinMaxValues(NuNC.NUN_TT_MAPFONTSCALE_MIN, NuNC.NUN_TT_MAPFONTSCALE_MAX);
	this:SetValueStep(0.01);	-- 5.60 replaced constant
	this:SetValue(NuNC.NUN_TT_MAPFONTSCALE_MIN + NuNC.NUN_TT_MAPFONTSCALE_MAX - mScale);
	this.previousValue = this:GetValue();
end


function NuNMapFontScaleSlider_OnValueChanged()
	local mScale;

	if (this:GetValue() ~= this.previousValue) then
		this.previousValue = this:GetValue();
		mScale = (NuNC.NUN_TT_MAPFONTSCALE_MIN + NuNC.NUN_TT_MAPFONTSCALE_MAX - this:GetValue());
		NuNSettings[pKey].mScale = mScale;
		NuNMapFontScaleSliderCurrent:SetText( string.format("%d", (mScale * 100)) .. "%");
		mScale = UIParent:GetScale() * NuNSettings[pKey].mScale;
		WorldMapTooltip:SetScale(NuNSettings[pKey].mScale);
		NuN_MapTooltip:SetScale(NuNSettings[pKey].mScale);
		NuNPopup:SetScale(NuNSettings[pKey].mScale);
	end
end


-- Mutliple functions for monitoring and noting Quest information

function NuN_ForceUpdateQuestNotes(qEvent)
	if ( NuNSettings[pKey].autoQ ) then
		NuNF.NuN_UpdateQuestNotes(qEvent);
	end
end



function NuN_OptionsTextLengthSet()
	local len = this:GetText();

	if ( len ) then
		NuNSettings[pKey].ttLen = len;
	else
		NuNSettings[pKey].ttLen = "0";
	end
end



function NuN_OptionsTextLineLengthSet()
	local len = this:GetText();

	if ( len ) then
		NuNSettings[pKey].ttLLen = len;
	else
		NuNSettings[pKey].ttLLen = "0";
	end
end


-- the list of Quests someone has had, together with their status, and when they Accepted, completed, handed in, abandoned them
function NuN_FetchQuestHistory()
	local index, value;
	local counter = 0;
	local results = 0;

	foundNuN = {};
	for index, value in pairs(NuNQuestHistory) do
		counter = counter + 1;
		foundNuN[counter] = NuNC.NUN_QUEST_C..index;
	end

	table.sort(foundNuN, NuNF.NuN_SortQuestHistory);
	results = getn(foundNuN);
	NuNSearchTitleText:SetText(pName.."'s "..NUN_QUESTS_TEXT.." ("..results..")");

	UIDropDownMenu_SetSelectedID(NuNSearchQHDropDown, qhI);
	UIDropDownMenu_SetText(qhT, NuNSearchQHDropDown);
	NuNSearchQHDropDown:Show();
	NuNSearchFrame_MassDelete:Hide();
	NuNSearchFrame_Export:Hide();
	NuNExtraOptions:Hide();
	NuNSearchFrameSearchButton:Disable();
	NuNSearchClassDropDown:Hide();
	NuNSearchProfDropDown:Hide();
	NuNSearchTextBox:Hide();
	NuNSearchSubSet:Hide();
	NuNSearchFrame.qh = true;

	NuNSearch_Update();
	if ( ( deletedE ) and ( visibles > 0 ) and ( lastBttn ~= nil ) ) then
		deletedE = false;
		if ( lastBttnIndex > visibles ) then
			NuNSearch_HighlightRefresh(lastVisible);
			NuNSearchNote_OnClick(lastVisible);
		else
			NuNSearch_HighlightRefresh(lastBttn);
			NuNSearchNote_OnClick(lastBttn);
		end
	else
		NuNSearch_HighlightRefresh(nil);
	end
	if ( NuNGNoteFrame:IsVisible() ) then
		NuNGNoteFrame.fromQuest = c_note;
	end
end

function NuN_ToggleMicroButtons()
	if ( NuNMicroFrame:IsVisible() ) then
		NuNMicroFrame:Hide();
		NuNSettings[pKey].hideMicro = "1";
	else
		NuNMicroFrame:Show();
		NuNSettings[pKey].hideMicro = nil;
	end
end


-- autonote Party members, and count the number of times you have partied with them
function NuN_ProcessParty()
	local pChanged = nil;
	local lMember, index, value;
	local partyA = {};
	local lMembers = GetNumPartyMembers();
	local inInstance, location = IsInInstance();

	-- Need to update this check with an IsInInstance check..... !!!
	if ( ( inInstance ) and ( ( location == "pvp" ) or ( location == "arena" ) ) ) then
		return;					-- Simply don't process in BG where many players from other Realms
	end

	if ( not NuNData[pKey][NuNC.NUN_PARTIES] ) then
		NuNData[pKey][NuNC.NUN_PARTIES] = {};
	end
	if ( ( not NuNData[pKey][NuNC.NUN_PARTIES][pName] ) or ( ( not UnitInRaid("player") ) and ( lMembers == 0 ) ) ) then
		NuNData[pKey][NuNC.NUN_PARTIES][pName] = {};
	end

	for i = 1, lMembers, 1 do
		lUnit = "party"..i;
		lMember = UnitName(lUnit);
		if ( ( lMember == UNKNOWN ) or ( lMember == UNKNOWNOBJECT ) ) then		-- 5.60 "Unknown Entity"
			return;
		end
		if ( lMember ) then
			partyA[lMember] = {};
			partyA[lMember].pos = i;
			if ( not NuNData[pKey][NuNC.NUN_PARTIES][pName][lMember] ) then
				NuNData[pKey][NuNC.NUN_PARTIES][pName][lMember] = {};
				NuNData[pKey][NuNC.NUN_PARTIES][pName][lMember].pos = i;
				if ( not NuNDataPlayers[lMember] ) then
					NuNDataPlayers[lMember] = {};
					NuNDataPlayers[lMember].type = NuNC.NUN_PARTY_C;
					NuNDataPlayers[lMember].faction = pFaction;
					NuNDataPlayers[lMember][txtTxt] = NUN_AUTO_PARTIED..NuNF.NuN_GetDateStamp();
					NuNDataPlayers[lMember][pName] = {};
					NuNDataPlayers[lMember][pName].partied = 1;
				else
					if ( not NuNDataPlayers[lMember][pName] ) then
						NuNDataPlayers[lMember][pName] = {};
						NuNDataPlayers[lMember][pName].partied = 1;
					elseif ( not NuNDataPlayers[lMember][pName].partied ) then
						NuNDataPlayers[lMember][pName].partied = 1;
					else
						NuNDataPlayers[lMember][pName].partied = NuNDataPlayers[lMember][pName].partied + 1;
					end
				end
				NuNDataPlayers[lMember][pName].partiedOn = NuNF.NuN_GetDateStamp();
				NuNF.NuN_UnitInfoDB(lMember, lUnit);												-- 5.60 Auto-populate some data 
			end
		end
	end

	for index, value in pairs(NuNData[pKey][NuNC.NUN_PARTIES][pName]) do
		if ( not partyA[index] ) then
			if ( UnitInRaid("player") ) then
				local rID = NuNF.NuN_CheckRaidByName(index);
				if ( not rID ) then
					NuNData[pKey][NuNC.NUN_PARTIES][pName][index] = nil;
				end
			else
				NuNData[pKey][NuNC.NUN_PARTIES][pName][index] = nil;
			end
		end
	end
end



function NuN_PartyDownButton_OnClick()
	local lParties = NuNDataPlayers[c_name][pName].partied;

	lParties = lParties - 1;
	if ( lParties < 1 ) then
		NuNDataPlayers[c_name][pName].partied = nil;
		NuNDataPlayers[c_name][pName].partiedOn = nil;
--		NuNPartiedLabel:Hide();
		NuNPartiedNumberLabel:SetText("(0)");
		NuNPartiedNumberLabel:Hide();
		NuNFramePartyDownButton:Hide();
	else
		NuNDataPlayers[c_name][pName].partied = lParties;
		NuNPartiedNumberLabel:SetText("(x"..tostring(lParties)..")");
	end
end



-- When Noting a Merchant / Vendor, then NotesUNeed can note what they sell also
function NuN_BuildShoppingList()
	local listText = "";
	local mName = MerchantNameText:GetText();

	if ( mName == c_note ) then
		local iPrice, iPriceTxt, iQuant, iNumAvail, iLink, iDiscard;
		local numMerchantItems = GetMerchantNumItems();

		for i=1, numMerchantItems, 1 do
			iLink = GetMerchantItemLink(i);
			if ( iLink ) then
				listText = listText.."\n"..iLink;
			end
			iDiscard, iDiscard, iPrice, iQuant, iNumAvail = GetMerchantItemInfo(i);
			if ( ( iQuant ) and ( iQuant > 1 ) ) then
				listText = listText.." ("..iQuant..") ";
			end
			if ( ( iPrice ) and ( iPrice > 0 ) ) then
				iPriceTxt = NuN_BuildMoneyString(iPrice);
				listText = listText.."   "..iPriceTxt;
			end
			if ( ( iNumAvail ) and ( iNumAvail > 0 ) ) then
				listText = listText.."        "..NUN_LIMITED;
			end
		end
	end

	if ( listText == "" ) then
		return nil;
	else
		return listText;
	end
end


function NuN_BuildMoneyString(moneyVal)
	local moneyTxt = nil;
	local gold, silver, copper;

	if ( ( moneyVal ) and ( moneyVal > 0 ) ) then
		if ( moneyVal > 9999 ) then
			gold = ( moneyVal / 10000 );
			gold = string.format("%d", gold);
			moneyVal = moneyVal - ( gold * 10000 );
		else
			gold = 0;
		end
		if ( moneyVal > 99 ) then
			silver = ( moneyVal / 100 );
			silver = string.format("%d", silver);
			moneyVal = moneyVal - ( silver * 100 );
		else
			silver = 0;
		end
		copper = moneyVal;
		moneyTxt = string.format("%dg %ds %dc", gold, silver, copper);
	end

	return moneyTxt;
end


function NuN_TextEscape(lFrame, lText)
	if ( NuNSettings[pKey].bHave ) then
		lText:ClearFocus();
		if ( ( lText:GetText() == nil ) or ( lText:GetText() == "" ) ) then
			lText:SetText("\n");
		end
	else
		lFrame:Hide();
	end
end



function NuN_OverTTCheckBox_OnClick()
	if ( NuN_OverTTCheckBox:GetChecked() ) then
		NuNSettings[pKey].minOver = "1";
	else
		NuNSettings[pKey].minOver = nil;
	end
end

function NuN_ChatTagCheckBox_OnClick()
	if ( NuN_ChatTagCheckBox:GetChecked() ) then
		NuNSettings[pKey].chatty = "1";
	else
		NuNSettings[pKey].chatty = nil;
	end
end


function NuN_AutoPartyCheckBox_OnClick()
	if ( NuN_AutoPartyCheckBox:GetChecked() ) then
		NuNSettings[pKey].autoP = "1";
		NuN_ProcessParty();
	else
		NuNSettings[pKey].autoP = nil;

	end
end


function NuN_BehaveCheckBox_OnClick()
	if ( NuN_BehaveCheckBox:GetChecked() ) then
		NuNSettings[pKey].bHave = "1";
	else
		NuNSettings[pKey].bHave = nil;
	end
end


function NuN_DeleteNote(dType)
	if ( NuNcDeleteFrame:IsVisible() ) then
		NuNcDeleteFrame:Hide();
	end
	NuNcDeleteFrame.type = dType;
	if ( dType == "Contact" ) then
		NuNcDeleteLabel:SetText(NUN_CONTACT_TXT.." :\n"..c_name);
		NuNcDeleteFrame:Show();
		NuNText:ClearFocus();
		NuNcDeleteGhostTextBox:SetFocus();
	else
		if ( NuNGNoteFrame.fromQuest ) then
			NuNcDeleteLabel:SetText(NuNC.NUN_QUEST_NOTE.." :\n"..c_note);
		else
			NuNcDeleteLabel:SetText(NUN_GENERAL_TXT.." :\n"..c_note);
		end
		NuNcDeleteFrame:Show();
		NuNGNoteTextScroll:ClearFocus();
		NuNcDeleteGhostTextBox:SetFocus();
	end
end


function NuNcDeleteButton_OnClick()
	if ( NuNcDeleteFrame.type == "Contact" ) then
		NuNcDeleteFrame:Hide();
		NuN_Delete();
	elseif ( NuNcDeleteFrame.type == "General" ) then
		NuNcDeleteFrame:Hide();
		NuNGNote_Delete();
	end
end


function NuN_LocStrip(locData)
	if ( locData ) then
		local p = string.find(locData, " : ");
		if ( p ) then
			locData = string.sub(locData, (p+3));
		end
	end

	return locData;
end




function NuN_MapNote(MNType, MNxtra1, MNxtra2, MNColour)
	local MNCont, MNZone, x, y;
	local checknote = nil;
	local nKey = nil;

	if ( MetaMap_Quicknote ) then

	elseif ( MapNotes_OnLoad ) then
		MNCont, MNZone, x, y, checknote, nKey = NuN_GetMapNotesKey();
		if ( ( not MNCont ) or ( ( x == 0 ) and ( y == 0 ) ) ) then
			if ( MapNotes_OnLoad ) then
				MapNotes_StatusPrint(MAPNOTES_QUICKNOTE_NOPOSITION);
			end
	        	return;
		end
	else
		return;
	end

	local MNLine1, MNLine2, MNAuthor, NuN_Reaction;
	local MNName;
	local tName = UnitName("target");
	if ( ( MNType == "Target" ) and ( tName ) and ( not UnitPlayerControlled("target") ) ) then
		NuN_Reaction = UnitReaction("player", "target");
		if ( not MNColour ) then
			if ( NuN_Reaction < 4 ) then
				MNColour = 1;
			elseif ( NuN_Reaction == 4 ) then
				MNColour = 0;
			end
		end
		MNName = UnitName("target");
	else
		if ( not c_note ) then
			if ( NuNGNoteTitleButton:IsVisible() ) then
				c_note = NuNGNoteTitleButtonText:GetText();
			else
				c_note = NuNGNoteTextBox:GetText();
			end
		end
		MNName = c_note;
		if ( ( not MNName ) or ( MNName == "" ) ) then
			return;
		end
	end

	if ( not MNColour ) then
		MNColour = 3;
	end

	if ( MetaMap_Quicknote ) then
		MetaMap_Quicknote(MNName);
		return;
	end

	local theData;
	if ( MapNotes_Data_Notes ) then							-- + v5.00.11200
		theData = MapNotes_Data_Notes[MNCont];					-- + v5.00.11200
	end

	if (checknote) then
		if ( ( ( NuN_State.inBG ) or ( MapNotes_Data_Notes ) ) and ( MNName == theData[checknote].name ) ) then		-- c v5.00.11200
			NuN_ReLinkMapNote(MNName, MNCont, MNZone, checknote);
			return;
		elseif ( not MapNotes_Data_Notes ) then
			if ( ( not NuN_State.inBG ) and ( MNName == theData[MNZone][checknote].name ) ) then
				NuN_ReLinkMapNote(MNName, MNCont, MNZone, checknote);
				return;
			end
		end
		local mergeFailed = NuN_MergeMapNote(MNCont, MNZone, checknote, MNName, nKey, MNxtra1, MNxtra2);
		if ( mergeFailed ) then
			local repName;
			if ( ( NuN_State.inBG ) or ( ( MapNotes_Data_Notes ) and ( MNZone == 0 ) ) ) then							-- c v5.00.11200
				repName = theData[checknote].name;
			else
				repName = theData[MNZone][checknote].name;
			end
			if ( MapNotes_OnLoad ) then
				MapNotes_StatusPrint( format(MAPNOTES_QUICKNOTE_NOTETONEAR, repName));
			end
			NuN_Message( NUN_MAX_MERGED );
		end
	else
		MNLine1 = MNxtra1;
		MNLine2 = MNxtra2;
		MNAuthor = "NotesUNeed - "..pName;
		NuN_WriteMapNote(MNCont, MNZone, x, y, MNColour, MNName, MNLine1, MNLine2, MNAuthor);
	end
end

function NuN_ReLinkMapNote(MNName, MNCont, MNZone, tmpID)
	local NuN_Key = MNCont.."-"..MNZone.."-"..tmpID;
	if ( not NuNData[mrgIndex] ) then
		NuNData[mrgIndex] = {};
	end
	if ( not NuNData[mrgIndex][NuN_Key] ) then
		NuNData[mrgIndex][NuN_Key] = {};
		NuNData[mrgIndex][NuN_Key].noteCounter = 0;
	end
	if ( NuNData[mrgIndex][NuN_Key][MNName] ) then
--		NuN_Message(NUN_NOTESUNEED_INFO);
		return;
	end
	if ( not NuNData[mrgIndex][NuN_Key].noteCounter ) then
		NuNData[mrgIndex][NuN_Key].noteCounter = 0;
	end
	NuNData[mrgIndex][NuN_Key].noteCounter = NuNData[mrgIndex][NuN_Key].noteCounter + 1;
	NuNData[mrgIndex][NuN_Key][MNName] = "1";
	if ( MapNotes_OnLoad ) then
		NuN_Message("NotesUNeed <> MapNote");
	end
end

function NuN_MergeMapNote(MNCont, MNZone, id, MNName, NuN_Key, MNxtra1, MNxtra2)
	local Merged = nil;
	local MNLine1, MNLine2, MNAuthor;
	local mrgEntry = nil;
	local oriNote;
	local mapNoted = true;
	local theData;

	if ( MapNotes_Data_Notes ) then							-- + v5.00.11200
		theData = MapNotes_Data_Notes[MNCont];

	else
		return;
	end
	oriNote = theData[id].name;

	if ( not string.find(oriNote, MNName) ) then
		mapNoted = nil;
	end

	if ( not NuNData[mrgIndex] ) then
		NuNData[mrgIndex] = {};
	end

	if ( not NuNData[mrgIndex][NuN_Key] ) then
		NuNData[mrgIndex][NuN_Key] = {};

	else
		mrgEntry = true;
	end

	if ( mrgEntry ) then
		if ( not NuNData[mrgIndex][NuN_Key].noteCounter ) then
			local counter = 0;
			local index, value;
			for index, value in pairs(NuNData[mrgIndex][NuN_Key]) do
				counter = counter + 1;
			end
			NuNData[mrgIndex][NuN_Key].noteCounter = counter;
		end
		if ( NuNData[mrgIndex][NuN_Key].noteCounter > 4 ) then
			return "Failed";
		end
		if ( NuNData[mrgIndex][NuN_Key][MNName] ) then
			return nil;
		else
			NuNData[mrgIndex][NuN_Key].noteCounter = NuNData[mrgIndex][NuN_Key].noteCounter + 1;
			NuNData[mrgIndex][NuN_Key][MNName] = "1";
		end

	elseif ( mapNoted ) then
		NuN_ReLinkMapNote(MNName, MNCont, MNZone, id);

	else
		if ( ( not NuNDataANotes[oriNote] ) and ( not NuNDataRNotes[oriNote] ) ) then
			NuNData[mrgIndex][NuN_Key].noteCounter = 1;
			NuNData[mrgIndex][NuN_Key][MNName] = "1";
		else
			NuNData[mrgIndex][NuN_Key].noteCounter = 2;
			NuNData[mrgIndex][NuN_Key][MNName] = "1";
			NuNData[mrgIndex][NuN_Key][oriNote] = "1";
		end
	end

	if ( not mapNoted ) then
		theData[id].name = theData[id].name.." | "..MNName;
		theData[id].inf1 = theData[id].inf1.." | "..MNxtra1;
		theData[id].inf2 = theData[id].inf2.." | "..MNxtra2;
		theData[id].creator = NUN_POPUP_TITLE.." - "..pName;
	end

	if ( MapNotes_OnLoad ) then
			MapNotes_StatusPrint( format(NUN_MERGING.." "..theData[id].name) );
	end

	return nil;
end


function NuN_WriteMapNote(MNCont, MNZone, x, y, MNColour, MNName, MNLine1, MNLine2, MNAuthor)
	local id = 0;
	local NuN_Key;
	local theData, theMiniData;
	local NuN_SetNextAsMiniNote;
	local numNotes, i, j, tmpID;

	if ( MapNotes_Data_Notes ) then							-- + v5.00.11200
		theData = MapNotes_Data_Notes[MNCont];					-- + v5.00.11200
		theMiniData = MapNotes_MiniNote_Data;					-- + v5.00.11200
		NuN_SetNextAsMiniNote = MapNotes_SetNextAsMiniNote;			-- + v5.00.11200
		numNotes = MapNotes_NotesPerZone;					-- + v5.00.11200
		i = MapNotes_GetZoneTableSize(theData);					-- + v5.00.11200

	else
		return;
	end

	if (NuN_SetNextAsMiniNote ~= 2) then
		if ( ( not numNotes ) or ( ( numNotes ) and (i < numNotes) ) ) then
			tmpID = i + 1;
			theData[tmpID] = {};
			theData[tmpID].name = MNName;
			theData[tmpID].ncol = 0;
			theData[tmpID].inf1 = MNLine1;
			theData[tmpID].in1c = 0;
			theData[tmpID].inf2 = MNLine2;
			theData[tmpID].in2c = 0;
			theData[tmpID].creator = MNAuthor;
			theData[tmpID].icon = MNColour;
			theData[tmpID].xPos = x;
			theData[tmpID].yPos = y;

			if (NuN_SetNextAsMiniNote ~= 0) then
				theData[tmpID].mininote = true;
			end

			MapNotes_StatusPrint(format(MAPNOTES_QUICKNOTE_OK, GetRealZoneText()));

			NuN_Key = MNCont.."-"..MNZone.."-"..tmpID;
			if ( not NuNData[mrgIndex] ) then
				NuNData[mrgIndex] = {};
			end
			if ( not NuNData[mrgIndex][NuN_Key] ) then
				NuNData[mrgIndex][NuN_Key] = {};
			end
			NuNData[mrgIndex][NuN_Key].noteCounter = 1;
			NuNData[mrgIndex][NuN_Key][MNName] = "1";
		else
			if ( MapNotes_OnLoad ) then
				MapNotes_StatusPrint(format(MAPNOTES_QUICKNOTE_TOOMANY, GetRealZoneText()));
			end
		end
	end

end


function NuN_GetMapNotesKey()
	local id = nil;
	local nKey = nil;
	local x, y;
	local MNCont = nil;
	local MNZone = nil;

	NuN_State.inBG = false;

	SetMapToCurrentZone();

	x, y = GetPlayerMapPosition("player");
	if ( ( ( x == 0 ) and ( y == 0 ) ) or ( MNCont == 0 ) ) then
		return nil;
	end

	if ( MapNotes_Data_Notes ) then									-- + v5.00.11200
		MNCont = "WM ";										-- + v5.00.11200
		local map = GetMapInfo();								-- + v5.00.11200
		if ( map ) then										-- + v5.00.11200
			MNCont = MNCont..map;								-- + v5.00.11200
		else											-- + v5.00.11200
			MNCont = MNCont.."WorldMap";							-- + v5.00.11200
		end											-- + v5.00.11200
		MNZone = 0;										-- + v5.00.11200
		id = MapNotes_CheckNearNotes(MNCont, x, y);						-- + v5.00.11200
	end												-- + v5.00.11200

	if ( id ) then
		nKey = MNCont.."-"..MNZone.."-"..id;
	end

	return MNCont, MNZone, x, y, id, nKey;
end

-- NuN equivalent of the MapNotes proximity to other map notes check
function NuN_ProximityCheck(theBG, xPos, yPos)
	local chkData = {};
	local minDiff;

	local chkData = {};

	if ( MapNotes_OnLoad ) then
		chkData = MapNotes_Data[theBG];
		minDiff = MapNotes_MinDiff;
	end

	if ( ( not minDiff ) or ( minDiff == 0 ) ) then
		minDiff = 7;
	end

	if ( not chkData ) then
		return;
	end

	local i = 1;
	for j, value in pairs(chkData) do
		local deltax = abs(chkData[i].xPos - xPos);
		local deltay = abs(chkData[i].yPos - yPos);
		if(deltax <= 0.0009765625 * minDiff and deltay <= 0.0013020833 * minDiff) then
			return i;
		end
		i = i + 1;
	end

	return nil;
end


-- 5.60
function NuN_AutoMapCheckBox_OnClick()
	if ( NuN_AutoMapCheckBox:GetChecked() ) then
		NuNSettings[pKey].autoMapNotes = "1";
	else
		NuNSettings[pKey].autoMapNotes = nil;
	end
end


-- 5.60
function NuN_GuildRefreshCheckBox_OnClick()
	if ( NuN_GuildRefreshCheckBox:GetChecked() ) then
		NuNSettings[pKey].autoGuildNotes = "1";
		NuN_GRVerboseCheckBox:Enable();
		NuN_GRVerboseCheckBox:SetChecked(true);					-- Default verbose guild reporting when turning on
		NuNSettings[pKey].autoGRVerbose = "1";
		NuN_GuildRefresh( NuNSettings[pKey].autoGRVerbose );	-- Trigger an immediate Guild Refresh
	else
		NuNSettings[pKey].autoGuildNotes = nil;
		NuNSettings[pKey].autoGRVerbose = nil;
		NuN_GRVerboseCheckBox:SetChecked(false);
		NuN_GRVerboseCheckBox:Disable();
	end
end


-- 5.60
function NuN_GRVerboseCheckBox_OnClick()
	if ( NuN_GRVerboseCheckBox:GetChecked() ) then
		NuNSettings[pKey].autoGRVerbose = "1";
		NuN_GuildRefresh( NuNSettings[pKey].autoGRVerbose );	-- Trigger an immediate Guild Refresh
	else
		NuNSettings[pKey].autoGRVerbose = nil;
	end
end

-- 5.60
function NuN_ModifierMasterCheckBox_OnClick()
	if ( NuN_ModifierMasterCheckBox:GetChecked() ) then
		NuNSettings[pKey].modifier = "on";
		NuNOptionsModifier:Enable();
		NuNOptions_SetModifierText();
	else
		NuNSettings[pKey].modifier = "off";
		NuNOptionsModifier:SetText("n/a");
		NuNOptionsModifier:Disable();
	end
end



-- Dump the Hyperlinks in the Notes main text to the chat frame, where the user can click on them
function NuN_HyperButton_OnClick(nType)
	local p1, p2;
	local linkA = {};
	local aCounter = 0;
	local lText, lTextLen;

	if ( nType == "Contact" ) then
		lText = NuNF.NuN_GetSelectedText(NuNText);
	elseif ( nType == "General" ) then
		lText = NuNF.NuN_GetSelectedText(NuNGNoteTextBox);
	end

	if ( not lText ) then
		if ( nType == "Contact" ) then
			lText = NuNText:GetText();
		elseif ( nType == "General" ) then
			lText = NuNGNoteTextScroll:GetText();
		else
			NuN_Message(NUN_LINKFAILURE);
			return;
		end
	end

	lTextLen = string.len(lText);

	p1 = string.find(lText, "|Hitem");
	while ( ( p1 ) and ( p1 > 10 ) ) do
		p2 = string.find(lText, "|h|r", p1);
		if ( ( not p2 ) or ( (p2+3) > lTextLen ) ) then
			break;
		end
		p1 = p1 - 10;
		p2 = p2 + 3;
		local link = string.sub(lText, p1, p2);
		aCounter = aCounter + 1;
		linkA[aCounter] = link;
		p1 = string.find(lText, "|Hitem", (p2+1));
	end

	p1 = string.find(lText, "|Henchant");
	while ( p1 ) do
		p2 = string.find(lText, "|h|r", p1);
		if ( ( not p2 ) or ( (p2+3) > lTextLen ) ) then
			break;
		end
		p2 = p2 + 3;
		local link = string.sub(lText, p1, p2);
		aCounter = aCounter + 1;
		linkA[aCounter] = link;
		p1 = string.find(lText, "|Henchant", (p2+1));
	end

	local loops = getn(linkA);
	local concat, sep = "", "";
	if ( loops ) and ( loops > 0 ) then
		if ( ChatFrameEditBox:IsVisible() ) then
			for i=1, loops, 1 do
				concat = concat .. sep .. linkA[i];
				sep = ", ";
			end
			ChatFrameEditBox:Insert(concat);

		else
			for i=1, loops, 1 do
				DEFAULT_CHAT_FRAME:AddMessage(linkA[i]);
			end
		end

	else
		NuN_Message(NUN_NOLINKS);
	end
end



-- What to do when you click on the MapNotes index of NuN Notes
function NuNPopup_OnClick(bttn, noteN)
	if ( bttn == "RightButton" ) then
		if ( IsAltKeyDown() ) then
			NuN_DeleteMapIndexNote(NuNPopup.id, noteN);
		end
	elseif ( bttn == "LeftButton" ) then
		WorldMapFrame:Hide();
		NuNPopup:Hide();
		if ( ( receiptPending ) and ( NuN_Receiving.type == "General" ) ) then
			return;
		end
		if ( NuNGNoteFrame:IsVisible() ) then
			if ( c_note == noteN ) then
				return;
			end
			NuNGNoteFrame:Hide();
		end
		NuNGNoteFrame.fromQuest = nil;
		c_note = noteN;
		NuN_ShowSavedGNote();
	end
end

function NuNPopup_OnShow()
	popUpHide = nil;
end

function NuNPopup_OnUpdate(arg1)
	popUpTimeSinceLastUpdate = popUpTimeSinceLastUpdate + arg1;
	if ( popUpTimeSinceLastUpdate > 0.1 ) then
		if ( ( popUpHide ) and ( not IsControlKeyDown() ) ) then
			NuNPopup:Hide();
			popUpHide = nil;
		end
--		if ( ( popUpHide ) and ( not MouseIsOver(NuNPopup) ) and ( not IsControlKeyDown() ) ) then
--			NuNPopup:Hide();
--			if ( NuNHooks.NuNOri_MapNotes_OnLeave ) then
--				NuNHooks.NuNOri_MapNotes_OnLeave(NuNPopup.id);
--			end
--		end
		popUpTimeSinceLastUpdate = 0;
	end
end

-- Keep Global cos' I likes it ;)
function NuN_Message(msg, r, g, b)
	if ( not msg ) then
		msg = " {NIL Value Passed}";
	end
	msg = "NotesUNeed : "..msg;
	if ( not r ) then
		r, g, b = 0.64, 0.21, 0.93;						--   |c00A335ED
	end
	if DEFAULT_CHAT_FRAME then
		DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b);
	end
end



function NuN_UpdateMapNotesIndex(deletedNote)
	local MNindex, MNvalue, nIndex, nValue;

	for MNindex, MNvalue in pairs(NuNData[mrgIndex]) do
		for nIndex, nValue in pairs(NuNData[mrgIndex][MNindex]) do
			if ( nIndex == deletedNote ) then
				NuNData[mrgIndex][MNindex][nIndex] = nil;
				NuNData[mrgIndex][MNindex].noteCounter = NuNData[mrgIndex][MNindex].noteCounter - 1;
				break;
			end
			if ( NuNData[mrgIndex][MNindex].noteCounter < 1 ) then
				NuNData[mrgIndex][MNindex] = nil;
			end
		end
	end
end



function NuN_PreDeleteMapIndex(id, cont, zone)
	local curZ, lstEntry;

	if ( MapNotes_Data_Notes ) then								-- + v5.00.11200
		if ( not cont ) then
			cont = GetMapInfo();
			if ( cont ) then
				cont = "WM "..cont;
			else
				cont = "WM WorldMap";
			end
		end
		if ( MapNotes_Data_Notes[cont] ) then
			curZ = MapNotes_Data_Notes[cont];						-- + v5.00.11200
		end
	end											-- + v5.00.11200

	lstEntry = MapNotes_GetZoneTableSize(curZ);
	return cont, zone, lstEntry;
end

-- Called when a MapNote is deleted

function NuN_DeleteMapIndex(id, cont, zone, lstEntry)
	if ( not zone ) then									-- + v5.00.11200
		zone = 0;									-- + v5.00.11200
	end											-- + v5.00.11200
	local nKey = cont.."-"..zone.."-"..id;
	local lstKey = cont.."-"..zone.."-"..lstEntry;
	if ( NuNData[mrgIndex][nKey] ) then
		NuNData[mrgIndex][nKey] = nil;
	end
	if ( ( lstEntry ~= 0 ) and ( nKey ~= lstKey ) and ( NuNData[mrgIndex][lstKey] ) ) then
		local index, value;
		NuNData[mrgIndex][nKey] = {};
		for index, value in pairs(NuNData[mrgIndex][lstKey]) do
			NuNData[mrgIndex][nKey][index] = NuNData[mrgIndex][lstKey][index];
		end
		NuNData[mrgIndex][lstKey] = nil;
	end
end



-- Called when Alt-Right Clicking on a button in the Popup to remove a single NuN - MapNote link

function NuN_DeleteMapIndexNote(id, noteN)
	local cont, zone;									-- + v5.00.11200

	if ( MapNotes_Data_Notes ) then								-- + v5.00.11200
		cont = "WM ";									-- + v5.00.11200
		local map = GetMapInfo();							-- + v5.00.11200
		if ( map ) then									-- + v5.00.11200
			cont = cont..map;							-- + v5.00.11200
		else										-- + v5.00.11200
			cont = cont.."WorldMap";						-- + v5.00.11200
		end										-- + v5.00.11200
		zone = 0;									-- + v5.00.11200
	end											-- + v5.00.11200

	local nKey = cont.."-"..zone.."-"..id;
	if ( ( NuNData[mrgIndex][nKey] ) and ( NuNData[mrgIndex][nKey][noteN] ) ) then
		NuNData[mrgIndex][nKey][noteN] = nil;
		NuNData[mrgIndex][nKey].noteCounter = NuNData[mrgIndex][nKey].noteCounter - 1;
		if ( NuNData[mrgIndex][nKey].noteCounter < 1 ) then
			NuNData[mrgIndex][nKey] = nil;
		end
	end
	WorldMapTooltip:Hide();
	NuNPopup:Hide();
	NuN_MapTooltip:Hide();
end



function NuN_MapIndexHouseKeeping()
	local MNindex, MNvalue;

	if ( ( MetaMap_Quicknote ) and ( MapNotes_OnLoad ) ) then
		return;
	end

	for MNindex, MNvalue in pairs(NuNData[mrgIndex]) do
		local valid = NuN_ExtractMapNotesInfo(MNindex);
		if ( not valid ) then
			NuNData[mrgIndex][MNindex] = nil;
		end
	end
end


function NuN_ExtractMapNotesInfo(nKey)
	local cont, zone, id;
	local sep = "-";
	local p, q;

	p = string.find(nKey, sep);
	if ( not p ) then
		return nil;
	end
	q = string.find(nKey, sep, (p+1));
	if ( not q ) then
		return nil;
	end

	cont = tonumber( string.sub(nKey, 1, (p-1)) );
	zone = tonumber( string.sub(nKey, (p+1), (q-1)) );
	id = tonumber( string.sub(nKey, (q+1)) );

	if ( MapNotes_Data_Notes ) then							-- + v5.00.11200
		theData = MapNotes_Data_Notes;						-- + v5.00.11200
	end

	if ( ( zone == 0 ) and ( theData[cont] ) and ( theData[cont][id] ) ) then
		return true;

	elseif ( ( theData[cont] ) and ( theData[cont][zone] ) and ( theData[cont][zone][id] ) ) then
		return true;

	else
		return nil;
	end
end



function NuN_SaveLast(saveType)
	NuN_LastOpen.type = saveType;
	if ( saveType == "Contact" ) then
		NuN_LastOpen.name = c_name;
	elseif ( saveType == "General" ) then
		NuN_LastOpen.note = c_note;
	end
end


function NuN_ReOpen()
	if ( NuN_LastOpen.type ) then
		if ( NuN_LastOpen.type == "Contact" ) then
			if ( NuNDataPlayers[NuN_LastOpen.name] ) then
				NuN_ShowSavedNote(NuN_LastOpen.name);
			end
		elseif ( NuN_LastOpen.type == "General" ) then
			if ( ( receiptPending ) and ( NuN_Receiving.type == "General" ) ) then
				return;
			end
			if ( ( NuNDataRNotes[NuN_LastOpen.note] ) or ( NuNDataANotes[NuN_LastOpen.note] ) ) then
				c_note = NuN_LastOpen.note;
				NuN_ShowSavedGNote();
			end
		end
	end
end



function NuN_RunButton_OnClick()
	local script = NuNGNoteTextScroll:GetText();

	RunScript(script);
end



function NuN_GetTipAnchor(theTT)
	local anchorBy, anchorTo;
	local x1, y1 = theTT:GetCenter();
	local x2, y2 = UIParent:GetCenter();

	if ( theTT == ShoppingTooltip1 ) then
		anchorBy = "TOPLEFT";
		anchorTo = "TOPRIGHT";
		return anchorBy, anchorTo;
	elseif ( theTT == ShoppingTooltip2 ) then
		anchorBy = "TOPLEFT";
		anchorTo = "BOTTOMLEFT";
		return anchorBy, anchorTo;
	end

	if ( ( not x1 ) or ( not y1 ) ) then
		anchorBy = "BOTTOMRIGHT";
		anchorTo = "BOTTOMLEFT";
	else
		if ( y1 > y2 ) then
			if ( x1 > x2 ) then
				anchorBy = "TOPRIGHT";
				anchorTo = "TOPLEFT";
			else
				anchorBy = "TOPLEFT";
				anchorTo = "TOPRIGHT";
			end
		else
			if ( x1 > x2 ) then
				anchorBy = "BOTTOMRIGHT";
				anchorTo = "BOTTOMLEFT";
			else
				anchorBy = "BOTTOMLEFT";
				anchorTo = "BOTTOMRIGHT";
			end
		end
	end

	return anchorBy, anchorTo;
end


--------------------------------------------------------------------------
-- Create the note when receiving data from another Player --

function NuN_CreateReceivedNote()
	if ( ( NuN_Receiving.active ) and ( not receiptPending ) ) then
		if ( not NuN_Receiving.version ) then
			return;
		end
		if ( ( not NuN_Receiving.title ) or ( NuN_Receiving.title == "" ) ) then
			return;
		end
		NuN_WriteReceiptLog();
		if ( NuN_Receiving.type == "General" ) then
			if ( NuNGNoteFrame:IsVisible() ) then
				if ( not NuNGNoteFrame.fromQuest ) then
					NuNGNote_WriteNote();
					NuN_Message(NUN_SAVED_NOTIFY1.."\""..c_note.."\""..NUN_SAVED_NOTIFY2);
					NuN_Message(NUN_SAVED_NOTIFY3.."\""..NuN_Receiving.title.."\"");
				end
				NuNGNoteFrame:Hide();
			end
			c_note = NuN_Receiving.title;
			c_type = NuN_Receiving.subtype;
			g_text = "";
			local nL = "";
			for index, value in ipairs(NuN_Receiving.text) do
				g_text = g_text..nL..NuN_Receiving.text[index];
				nL = "\n";
			end
			NuN_ShowTitledGNote(g_text);
			NuNGNote_WriteNote();

		elseif ( NuN_Receiving.type == "Contact" ) then
			if ( NuNFrame:IsVisible() ) then
				NuN_WriteNote();
				NuNFrame:Hide();
				NuN_Message(NUN_SAVED_NOTIFY1.."\""..c_name.."\""..NUN_SAVED_NOTIFY2);
				NuN_Message(NUN_SAVED_NOTIFY3.."\""..NuN_Receiving.title.."\"");
			end
			NuN_ShowReceivedContact();
			if ( NuNDataPlayers[c_name] ) then
				NuN_SearchForNote("Text", c_name);
				receiptPending = true;
				StaticPopup_Show("NUN_DUPLICATE_RECORD");
			else
				NuN_WriteNote();
				NuNHeader:SetText(NUN_SENT.." : "..c_name);
			end
		end

	end
end


function NuN_WriteReceiptLog()
	local saveLvl;
	local tmp_c_note = c_note;
	local tmp_g_text = g_text;
	rMsgSeq = rMsgSeq + 1;
	if ( rMsgSeq > 9 ) then
		rMsgSeq = 1;
	end
	c_note = "Receipt Log "..pName..rMsgSeq..":";
	if ( not NuN_Receiving.title ) then
		NuN_Receiving.title = "T?";
	end
	if ( not NuN_Receiving.prefix ) then
		NuN_Receiving.prefix = "P?";
	end
	if ( not NuN_Receiving.log ) then
		NuN_Receiving.log = "L?";
	end
	g_text = NuN_Receiving.title.."\n"..NuN_Receiving.prefix.." : "..NuNF.NuN_GetDateStamp().."\n\n"..NuN_Receiving.log;

	if ( NuNSettings[pKey].dLevel ) then
		NuNDataANotes[c_note] = {};
		NuNDataANotes[c_note].type = NuNGet_CommandID(NUN_NOTETYPES, "LOG");
		saveLvl = "Account";
	else
		NuNDataRNotes[c_note] = {};
		NuNDataRNotes[c_note].type = NuNGet_CommandID(NUN_NOTETYPES, "LOG");
		saveLvl = "Realm";
	end
	NuNF.NuN_SetGText(saveLvl);
	c_note = tmp_c_note;
	g_text = tmp_g_text;
end


function NuN_ShowReceivedContact()
	c_name = NuN_Receiving.title;
	c_route = "Receipt";

	if ( NuN_Receiving.faction == "Horde" ) then
		c_faction = "Horde";
		NuNF.NuN_HordeSetup();
	else
		c_faction = "Alliance";
		NuNF.NuN_AllianceSetup();
	end


	-- Get note Text
	c_text = "";
	if ( NuN_Receiving.text ) then
		local nL = "";
		for index, value in ipairs(NuN_Receiving.text) do
			c_text = c_text..nL..NuN_Receiving.text[index];
			nL = "\n";
		end
		local lenCheck = string.len(c_text);
		if ( lenCheck > NuNC.NUN_MAX_TXT_LIM ) then
			NuN_Message(NUN_RECEIPT_TRUNCATION_WARNING);
			c_text = string.sub(c_text, 1, NuNC.NUN_MAX_TXT_LIM);
		end
	end

	prevName = c_name;

	if ( NuNOptionsFrame:IsVisible() ) then
		NuNOptionsFrame:Hide();
	end

	lastDD = nil;
	NuNButtonClrDD:Disable();

	NuNF.ClearButtonChanges();

	NuNHeader:SetText(NUN_SENT.." : "..c_name);
	NuNText:SetText( c_text );
	NuNButtonDelete:Disable();
	NuNCOpenChatButton:Disable();
	NuNCTTCheckBoxLabel:Hide();
	NuN_CTTCheckBox:Hide();

	c_race = nil;
	c_class = nil;
	c_sex = nil;
	c_prof1 = nil;
	c_prof2 = nil;
	c_arena = nil;
	c_hrank = nil;

	-- Process Drop Down Boxes if Sender has v3.50 or later
	if ( NuN_Receiving.version ) then
		-- If Sender has different client, create a dummy note for language translation processing
		if ( ( NuN_Receiving.lang ~= NUN_CLIENT ) and ( ( NuN_Receiving.lang == "German" ) or ( NUN_CLIENT == "German" ) ) ) then
			if ( NuN_Receiving.lang == "German" ) then
				langDir = "->en";
			else
				langDir = "->de";
			end
			NuNDataPlayers[rBuff] = {};
			NuNDataPlayers[rBuff].faction = NuN_Receiving.faction;
			NuNDataPlayers[rBuff].race = NuN_Receiving.race;
			NuNDataPlayers[rBuff].cls = NuN_Receiving.class;
			NuNDataPlayers[rBuff].prof1 = NuN_Receiving.prof1;
			NuNDataPlayers[rBuff].prof2 = NuN_Receiving.prof2;
			NuN_LangPatch(langDir, rBuff);
			if ( NuN_Receiving.race ) then
				NuN_Receiving.race = NuNDataPlayers[rBuff].race;
			end
			if ( NuN_Receiving.class ) then
				NuN_Receiving.class = NuNDataPlayers[rBuff].cls;
			end
			if ( NuN_Receiving.prof1 ) then
				NuN_Receiving.prof1 = NuNDataPlayers[rBuff].prof1;
			end
			if ( NuN_Receiving.prof2 ) then
				NuN_Receiving.prof2 = NuNDataPlayers[rBuff].prof2;
			end
			NuNDataPlayers[rBuff] = nil;
		end
		if ( NuN_Receiving.race ~= nil ) then
			c_race = Races[NuN_Receiving.race];
			ddBoxes.ddRace = NuN_Receiving.race;
			UIDropDownMenu_SetSelectedID(NuNRaceDropDown, ddBoxes.ddRace);
			UIDropDownMenu_SetText(c_race, NuNRaceDropDown);
		else
			ddBoxes.ddRace = -1;
			UIDropDownMenu_ClearAll(NuNRaceDropDown);
		end
		if ( NuN_Receiving.class ~= nil ) then
			c_class = Classes[NuN_Receiving.class];
			ddBoxes.ddClass = NuN_Receiving.class;
			UIDropDownMenu_SetSelectedID(NuNClassDropDown, ddBoxes.ddClass);
			UIDropDownMenu_SetText(c_class, NuNClassDropDown);
		else
			ddBoxes.ddClass = -1;
			UIDropDownMenu_ClearAll(NuNClassDropDown);
		end
		if ( NuN_Receiving.sex ~= nil ) then
			c_sex = NUN_SEXES[NuN_Receiving.sex];
			ddBoxes.ddSex = NuN_Receiving.sex;
			UIDropDownMenu_SetSelectedID(NuNSexDropDown, ddBoxes.ddSex);
			UIDropDownMenu_SetText(c_sex, NuNSexDropDown);
		else
			ddBoxes.ddSex = -1;
			UIDropDownMenu_ClearAll(NuNSexDropDown);
		end
		if ( NuN_Receiving.prating ~= nil ) then
			ddBoxes.ddPRating = NuN_Receiving.prating;
			c_prating = NuNSettings.ratings[NuN_Receiving.prating];
			UIDropDownMenu_SetSelectedID(NuNPRatingDropDown, ddBoxes.ddPRating);
			UIDropDownMenu_SetText(c_prating, NuNPRatingDropDown);
		else
			ddBoxes.ddPRating = -1;
			UIDropDownMenu_ClearAll(NuNPRatingDropDown);
		end
		if ( NuN_Receiving.prof1 ~= nil ) then
			ddBoxes.ddProf1 = NuN_Receiving.prof1;
			c_prof1 = NUN_PROFESSIONS[NuN_Receiving.prof1];
			UIDropDownMenu_SetSelectedID(NuNProf1DropDown, ddBoxes.ddProf1);
			UIDropDownMenu_SetText(c_prof1, NuNProf1DropDown);
		else
			ddBoxes.ddProf1 = -1;
			UIDropDownMenu_ClearAll(NuNProf1DropDown);
		end
		if ( NuN_Receiving.prof2 ~= nil ) then
			ddBoxes.ddProf2 = NuN_Receiving.prof2;
			c_prof2 = NUN_PROFESSIONS[NuN_Receiving.prof2];
			UIDropDownMenu_SetSelectedID(NuNProf2DropDown, ddBoxes.ddProf2);
			UIDropDownMenu_SetText(c_prof2, NuNProf2DropDown);
		else
			ddBoxes.ddProf2 = -1;
			UIDropDownMenu_ClearAll(NuNProf2DropDown);
		end
		if ( NuN_Receiving.arena ~= nil ) then
			ddBoxes.ddArena = NuN_Receiving.arena;
			c_arena = NUN_ARENAR[NuN_Receiving.arena];
			UIDropDownMenu_SetSelectedID(NuNArenaRDropDown, ddBoxes.ddArena);
			UIDropDownMenu_SetText(c_arena, NuNArenaRDropDown);
		else
			ddBoxes.ddArena = -1;
			UIDropDownMenu_ClearAll(NuNArenaRDropDown);
		end
		if ( NuN_Receiving.hrank ~= nil ) then
			ddBoxes.ddHRank = NuN_Receiving.hrank;
			c_hrank = Ranks[NuN_Receiving.hrank];
			UIDropDownMenu_SetSelectedID(NuNHRankDropDown, ddBoxes.ddHRank);
			UIDropDownMenu_SetText(c_hrank, NuNHRankDropDown);
		else
			ddBoxes.ddHRank = -1;
			UIDropDownMenu_ClearAll(NuNHRankDropDown);
		end
	end



	-- Process the User Buttons, and populate pre-save array
	c_guild = nil;
	gRank = nil;
	gRankIndex = nil;
	gNote = nil;
	gOfficerNote = nil;

	-- Have a step to check for sends from different clients
	--   If sent from a different language client, then need to check for default headings against the different languages defaults...
	--   If a different language default, then can substitute with this Clients default...
	if ( ( NuN_Receiving.user ) and ( NuN_Receiving.lang ~= NUN_CLIENT ) ) then
		if ( NuN_Receiving.lang == "English" ) then
			NuN_xlateHeadings(enHeadings);
		elseif ( NuN_Receiving.lang == "German" ) then
			NuN_xlateHeadings(deHeadings);
		elseif ( NuN_Receiving.lang == "French" ) then
			NuN_xlateHeadings(frHeadings);
		end
	end

	-- Loop through the User buttons
	NuN_SetReceivedUserButtons();

	if ( NuNEditDetailsFrame:IsVisible() ) then
		NuNEditDetailsFrame:Hide();
	end
	if ( NuNcDeleteFrame:IsVisible() ) then
		NuNcDeleteFrame:Hide();
	end

--	NuNPartiedLabel:Hide();
	NuNPartiedNumberLabel:SetText("(0)");
	NuNPartiedNumberLabel:Hide();
	NuNFramePartyDownButton:Hide();

	NuNFrame:SetScale(NuNSettings[pKey].pScale);
	NuNFrame:Show();
	if ( not NuNSettings[pKey].bHave ) then
		NuNText:SetFocus();
	else
		NuNText:ClearFocus();
	end
end

function NuN_xlateHeadings()
	for i=1, uBttns, 1 do
		if ( ( NuN_Receiving.user[i] ) and ( NuN_Receiving.user[i].title ) ) then
			if ( NuN_Receiving.user[i].title == fromHeadings[i] ) then
				NuN_Receiving.user[i].title = NUN_DFLTHEADINGS[i];
			end
		end
	end
end

function NuN_SetReceivedUserButtons()
	for i=1, uBttns, 1 do
		local bttnHeadingText = getglobal("NuNTitleButton"..i.."ButtonTextHeading");
		local bttnDetailText = getglobal("NuNInforButton"..i.."ButtonTextDetail");
		local bttnDetail = getglobal("NuNInforButton"..i);
		local hdNbr = pHead..i;
		local nameHdNbr = c_name..hdNbr;
		local nameDtNbr = c_name..pDetl..i;
		bttnHeadingText:SetText(NUN_DFLTHEADINGS[i]);
		bttnDetailText:SetText("");
		bttnDetail:Enable();
		if ( NuN_Receiving.user ) then
			if ( ( NuN_Receiving.user[i] ) and ( NuN_Receiving.user[i].title ) ) then
				-- if Receiver NOT using Global defaults <OR> we have not been sent a global default, then create Notes specific heading
				if ( ( NuNSettings[pKey][hdNbr] ) or ( NuN_Receiving.user[i].title ~= NUN_DFLTHEADINGS[i] ) ) then
					bttnHeadingText:SetText( NuN_Receiving.user[i].title );
					bttnChanges[i] = NuN_Receiving.user[i].title;
				end
				-- process detail, only if sent a heading
				local hdngTest = bttnHeadingText:GetText();
				if ( ( not hdngTest ) or ( hdngTest == "" ) ) then
					bttnDetailText:SetText("");
					bttnDetail:Disable();
					bttnChanges[i] = -1;					-- 5.60 Use -1 to flag blank
					bttnChanges[i+detlOffset] = -1;			-- 5.60 Use -1 to flag blank
				else
					if ( NuN_Receiving.user[i].detl ) then
						bttnDetailText:SetText( NuN_Receiving.user[i].detl );
						bttnChanges[i+detlOffset] = NuN_Receiving.user[i].detl;
					end
				end
			end
		end
	end
end



function NuN_HidePopup(fType)
	if ( ( StaticPopup1 ) and ( StaticPopup1:IsVisible() ) ) then
		local testText = StaticPopup1Text:GetText();
		if ( testText == NUN_DUPLICATE ) then
			if ( fType == NuN_Receiving.type ) then
				StaticPopup1:Hide();
			end
		end
	end
end

-- END of Receiving a NuN Note from another User Processing--
------------------------------------------------------------------------------

function NuN_SearchForNote(sType, sTitle)
	if ( ( type(sTitle) == "string" ) and ( string.find(sTitle, "|Hitem:") ) ) then
		local simpleTitle = NuNF.NuN_GetSimpleName(sTitle);
		if ( simpleTitle ~= nil ) then
			sTitle = simpleTitle;
		end
	end
	ddBoxes.ddSearch = NuNGet_CommandID(NUN_SEARCHFOR, sType);
	searchType = NUN_SEARCHFOR[ddBoxes.ddSearch].Command;
	if ( sType == "Text" ) then
		NuNSearchTextBox:SetText(sTitle);
	end
	NuNOptions_Search();
end


-- Generic function for parsing the NotesUNeed database and executing fixes on the data
function NuN_DataFix1(NuN_FixFunction, fixParm1)
	local lKey = pKey;
	local debugCounter = 0;
	local questHistoryArray = {};

	suppressDateUpdate = true;

	for index, value in pairs(NuNData) do
		if ( index == Notes ) then
			for index2, value2 in pairs(NuNData[index]) do
				if ( NuNData[index][index2].txt ) then
					g_text = NuNF.NuN_GetGText(index2);
					if ( g_text ) then
						if ( ( NuN_FixFunction ) and ( type(NuN_FixFunction) == "function" ) ) then
							g_text = NuN_FixFunction(index2, g_text, fixParm1);
						end
						debugCounter = debugCounter + 1;
						c_note = index2;
						NuNF.NuN_SetGText("Account");
					end
				end
			end
		elseif ( not string.find(index, "~") ) then
			for index2, value2 in pairs(NuNData[index]) do
				if ( NuNData[index][index2].faction ) then
					pKey = index;
					c_text = NuNF.NuN_GetCText(index2);
					if ( c_text ) then
						if ( ( NuN_FixFunction ) and ( type(NuN_FixFunction) == "function" ) ) then
							c_text = NuN_FixFunction(index2, c_text, fixParm1);
						end
						debugCounter = debugCounter + 1;
						NuNF.NuN_SetCText(index2);
					end
				elseif ( index2 == Notes ) then
					pKey = index;
					for index3, value3 in pairs(NuNData[index][index2]) do
						if ( NuNData[index][index2][index3].txt ) then
							g_text = NuNF.NuN_GetGText(index3);
							if ( g_text ) then
								if ( ( NuN_FixFunction ) and ( type(NuN_FixFunction) == "function" ) ) then
									g_text = NuN_FixFunction(index3, g_text, fixParm1);
								end
								debugCounter = debugCounter + 1;
								c_note = index3;
								NuNF.NuN_SetGText("Realm");
							end
						end
					end
				end
				if ( ( NuNData[index].QuestHistory ) and ( not questHistoryArray[index] ) ) then
					questHistoryArray[index] = true;
					for player, players in pairs(NuNData[index].QuestHistory) do
						for quest, quests in pairs(NuNData[index].QuestHistory[player]) do
							if ( NuNData[index].QuestHistory[player][quest].txt ) then
								local txt = NuNF.NuN_GetDisplayText( NuNData[index].QuestHistory[player][quest].txt );
									if ( ( NuN_FixFunction ) and ( type(NuN_FixFunction) == "function" ) ) then
										txt = NuN_FixFunction(nil, txt, fixParm1);
									end
								txt = NuNF.NuN_SetSaveText(txt);
								NuNData[index].QuestHistory[player][quest].txt = txt;
								debugCounter = debugCounter + 1;
							end
							if ( NuNData[index].QuestHistory[player][quest].complete ) then
								local complete = NuNF.NuN_GetDisplayText( NuNData[index].QuestHistory[player][quest].complete );
									if ( ( NuN_FixFunction ) and ( type(NuN_FixFunction) == "function" ) ) then
										complete = NuN_FixFunction(nil, complete, fixParm1);
									end
								complete = NuNF.NuN_SetSaveText(complete);
								NuNData[index].QuestHistory[player][quest].complete = complete;
								debugCounter = debugCounter + 1;
							end
						end
					end
				end
			end
		end
	end
	pKey = lKey;
	suppressDateUpdate = nil;
end



-- Execute the contents of a note as a Lua Script
function NuN_ExecuteNote(parm1)
	local script;
	if ( NuNDataANotes[parm1] ) then
		script = NuNF.NuN_GetGText(parm1);
	elseif ( NuNDataRNotes[parm1] ) then
		script = NuNF.NuN_GetGText(parm1);
	else
		NuN_SearchForNote("Text", parm1);
		return nil;
	end

	RunScript(script);
	return true;
end



function NuN_Tooltip_OnHide()
	if ( not NuNSettings[pKey].tScale ) then
		NuNSettings[pKey].tScale = 1.0;
	end
	NuN_Tooltip:SetScale( NuNSettings[pKey].tScale );
end



function NuN_SearchFrameSearch(parm1)
	if ( NuNSearchTextBox:GetText() ~= "" ) then
		ddBoxes.ddSearch = NuNGet_CommandID(NUN_SEARCHFOR, "Text");
	else
		ddBoxes.ddSearch = NuNGet_CommandID(NUN_SEARCHFOR, "All");
	end
	NuNSearch_Search(parm1);
end

function NuN_IndexAll()
	local curZ;

	if ( MapNotes_Data_Notes ) then						-- + v5.00.11200
		curZ = MapNotes_Data_Notes;					-- + v5.00.11200

	else
		return;
	end

	for cont, dataSet in pairs(curZ) do
		if ( type(cont) == "string" ) then
			NuN_IndexByZone(cont, 0, curZ[cont]);

		elseif ( type(cont) == "number" ) then
			for zone=0, 40, 1 do
				if ( curZ[cont][zone] ) then
					NuN_IndexByZone(cont, zone, curZ[cont][zone]);
				end
			end
		end
	end
end

function NuN_IndexByZone(cont, zone, curZ)
	local nName, preKey, nKey = "", (cont.."-"..zone.."-"), "";

	for index, dataSet in pairs(curZ) do
		nName = dataSet.name;
		if ( nName ) then
			nKey = preKey..index;
			if ( NuNData[itmIndex][nName] ) then
				nName = ( NuNData[itmIndex][nName] );
			end
			if ( ( NuNDataRNotes[nName] ) or ( NuNDataANotes[nName] ) ) then
				NuN_CreateIndex(nKey, nName);
			else
				local c = " | ";
				NuN_SubStrings(nKey, nName, c);
				local c = " \124\124 ";
				NuN_SubStrings(nKey, nName, c);
			end
		end
	end
end

-- This function splits up MapNote names which have been generated by Merging multiple NotesUNeed Notes
-- e.g.  "Note 1 | Note 2 | Note 3"  where 3 notes are linked to the MapNote
function NuN_SubStrings(nKey, nName, sep)
	local p1, p2, sName = 1, -1, "";
	local len = string.len(sep);

	p2 = string.find(nName, sep);
	while ( p2 ) do
		sName = string.sub(nName, p1, p2-1);
		if ( NuNData[itmIndex][sName] ) then
			sName = ( NuNData[itmIndex][sName] );
		end
		if ( ( sName ) and ( ( NuNDataRNotes[sName] ) or ( NuNDataANotes[sName] ) ) ) then
			NuN_CreateIndex(nKey, sName);
		end
		p1 = p2+len;
		p2 = string.find(nName, sep, p1);
		if ( not p2 ) then
			sName = string.sub(nName, p1);
			if ( NuNData[itmIndex][sName] ) then
				sName = ( NuNData[itmIndex][sName] );
			end
			if ( ( sName ) and ( ( NuNDataRNotes[sName] ) or ( NuNDataANotes[sName] ) ) ) then
				NuN_CreateIndex(nKey, sName);
			end
		end
	end
end

function NuN_CreateIndex(nKey, nName)
	if ( not NuNData[mrgIndex][nKey] ) then
		NuNData[mrgIndex][nKey] = {};
		NuNData[mrgIndex][nKey].noteCounter = 1;
		NuNData[mrgIndex][nKey][nName] = "1";
--		NuN_Message("-> MapNote : "..nName);
	elseif ( ( NuNData[mrgIndex][nKey] ) and ( NuNData[mrgIndex][nKey].noteCounter ) and  ( NuNData[mrgIndex][nKey].noteCounter < 5 ) and ( not NuNData[mrgIndex][nKey][nName] ) ) then
		NuNData[mrgIndex][nKey].noteCounter = NuNData[mrgIndex][nKey].noteCounter + 1;
		NuNData[mrgIndex][nKey][nName] = "1";
--		NuN_Message("-> MapNote : "..nName);
	end
end

function NuN_getFaction()
	pFaction = UnitFactionGroup("player");
	if ( pFaction ) then
		if ( pFaction == "Horde" ) then
			NuN_horde = true;
		else
			NuN_horde = false;
		end
	else
		NuN_horde = nil;
	end
end



function NuN_ResetFriendlyData(resetTo, targetRealm)
	for realmName, realm in pairs(NuNData) do
		if ( ( not targetRealm ) or ( realmName == targetRealm ) ) then
			for playerName, playerData in pairs(realm) do
				if ( type(playerData) == "table" ) then
					if ( playerData.faction ) then
						if ( playerData.friendLst ) then
							playerData.friendLst = resetTo;
						end
						if ( playerData.ignoreLst ) then
							playerData.ignoreLst = resetTo;
						end
					end
				end
			end
		end
	end
end



-- Stop NuN trying to Ignore a Player (who never seems to be online for example)
function NuN_ResetPlayerIgnoreStatus(parm1)
	if ( ( NuNDataPlayers[parm1] ) and ( NuNDataPlayers[parm1].ignoreLst ) ) then
		if ( ( NuNSettings[pKey].autoD ) and ( NuNDataPlayers[parm1].type == NuNC.NUN_AUTO_C ) and ( not NuNDataPlayers[parm1].friendLst ) ) then
			NuNDataPlayers[parm1] = nil;
		else
			NuNDataPlayers[parm1].ignoreLst = nil;
		end
		NuNSettings[pKey].gNotIgnores[parm1] = true;
		if ( NuNSettings[pKey].autoA ) then
			NuN_Update_Ignored();
		end
		NuN_Message( NUN_FINISHED_PROCESSING .. " : " .. parm1 );
	end
end

-- Stop NuN trying to Befriend a Player (who isn't on the server any more for example)
function NuN_ResetPlayerFriendStatus(parm1)
	if ( ( NuNDataPlayers[parm1] ) and ( NuNDataPlayers[parm1].friendLst ) ) then
		if ( ( NuNSettings[pKey].autoD ) and ( NuNDataPlayers[parm1].type == NuNC.NUN_AUTO_C ) and ( not NuNDataPlayers[parm1].ignoreLst ) ) then
			NuNDataPlayers[parm1] = nil;
		else
			NuNDataPlayers[parm1].friendLst = nil;
		end
		NuNSettings[pKey].gNotFriends[parm1] = true;
		if ( NuNSettings[pKey].autoA ) then
			NuN_Update_Friends();
		end
		NuN_Message( NUN_FINISHED_PROCESSING .. " : " .. parm1 );
	end
end

-- reset Friend/Ignore lists to those of Current Toon
function NuN_ResetFriendIgnoreLists()
	NuN_ResetFriendlyData(nil, pKey);
	NuNSettings[pKey].gNotFriends = {};
	NuNSettings[pKey].gNotIgnores = {};
	NuNOptions_Export();					-- NOT a NuN Export function - this exports Blizzard Friend / Ignores to NotesUNeed notes
	NuN_Message( NUN_FINISHED_PROCESSING );
end




function NuNOptions_DBBackUp_OnClick()
	local isLoaded = IsAddOnLoaded("NotesUNeed_Backup");
	if ( not isLoaded ) then
		isLoaded = LoadAddOn("NotesUNeed_Backup");
	end
	if ( isLoaded ) then
		StaticPopup_Show("NUN_CONFIRM_BACKUP");
	end
end

function NuNOptions_DBRestore_OnClick()
	local isLoaded = IsAddOnLoaded("NotesUNeed_Backup");
	if ( not isLoaded ) then
		isLoaded = LoadAddOn("NotesUNeed_Backup");
	end
	if ( isLoaded ) then
		StaticPopup_Show("NUN_CONFIRM_RESTORE");
	end
end



function NuNOptions_DBImport()
	if ( NuN_ImportModule ) then
		StaticPopup_Show("NUN_IMPORT_NOTES");
	end
end

function NuNOptions_DBExport()
	if ( not NuNSearchFrame.qh ) then
		local isLoaded = IsAddOnLoaded("NotesUNeed_Export");
		if ( not isLoaded ) then
			isLoaded = LoadAddOn("NotesUNeed_Export");
		end
		if ( isLoaded ) then
			NuNSearchFrame.foundNuN = foundNuN;
			NuNSearchFrame.pKey = pKey;
			StaticPopup_Show("NUN_CONFIRM_EXPORT");
		end
	end
end

function NuN_PurgeExport()
	local isLoaded = IsAddOnLoaded("NotesUNeed_Export");
	if ( not isLoaded ) then
		isLoaded = LoadAddOn("NotesUNeed_Export");
	end
	if ( isLoaded ) then
		NuNDataExport = {};
	end
	NuN_Message( NUN_FINISHED_PROCESSING );
end



function NuN_MassDelete()
	if ( not string.find(NuNSearchTitleText:GetText(), NUN_QUESTS_TEXT) ) then
		StaticPopup_Show("NUN_MASS_DELETE_CONFIRM");
	end
end



-- Set up the Unit Right Click menu options for recording Player Rating : will create a note if necesary
function NuN_SetupRatings(initialSetup)

	-- Player specified ratings - MUST create Brand New arrays so that Originals are not corrupted by changes and are available to "Reset" the values
	if ( not NuNSettings.ratings ) then
		NuNSettings.ratings = {};
		NuNSettings.ratingsT = {};
		NuNSettings.ratingsBL = {};
		for i, value in pairs(NUN_ORATINGS) do
			NuNSettings.ratings[i] = value;
		end
		for i, value in pairs(NUN_ORATINGS_TEXT) do
			NuNSettings.ratingsT[i] = value;
		end
		for i=1, maxRatings, 1 do
			NuNSettings.ratingsBL[i] = 0;
		end

	else
		NUN_PR_TP = NuNSettings.ratings[1];			
		NUN_PR_MB = NuNSettings.ratings[2];			
		NUN_PR_AO = NuNSettings.ratings[3];			
		NUN_PR_RB = NuNSettings.ratings[4];			
		NUN_PR_SA = NuNSettings.ratings[5];			
		NUN_PR_LW = NuNSettings.ratings[6];        	
		NUN_PR_RR = NuNSettings.ratings[7];          
		NUN_PR_MG = NuNSettings.ratings[8];        	
		NUN_PR_DJ = NuNSettings.ratings[9];			
		NUN_PR_NJ = NuNSettings.ratings[10];			
		NUN_PR_SW = NuNSettings.ratings[11];			
		NUN_PR_NG = NuNSettings.ratings[12];
		NUN_PR_FG = NuNSettings.ratings[13];
		NUN_PR_AV = NuNSettings.ratings[14];
		NUN_PR_KS = NuNSettings.ratings[15];
		NUN_PR_TENSTAR = NuNSettings.ratings[16];
		NUN_PR_NINESTAR = NuNSettings.ratings[17];
		NUN_PR_EIGHTSTAR = NuNSettings.ratings[18];
		NUN_PR_SEVENSTAR = NuNSettings.ratings[19];
		NUN_PR_SIXSTAR = NuNSettings.ratings[20];
		NUN_PR_FIVESTAR = NuNSettings.ratings[21];
		NUN_PR_FOURSTAR = NuNSettings.ratings[22];
		NUN_PR_THREESTAR = NuNSettings.ratings[23];
		NUN_PR_TWOSTAR = NuNSettings.ratings[24];
		NUN_PR_ONESTAR = NuNSettings.ratings[25];
		NUN_PR___ = NuNSettings.ratings[26];
	end

	UnitPopupButtons["NUN_POPUP"] 		= { text = TEXT(NUN_POPUP_TITLE), dist = 0, nested = 1 };
	UnitPopupButtons[NUN_POPUP_TOGGLE]	= { text = TEXT(NUN_POPUP_TOGGLE), dist = 0};
	UnitPopupButtons[NUN_PR_TP] 		= { text = TEXT(NUN_PR_TP), dist = 0 };
	UnitPopupButtons[NUN_PR_MB] 		= { text = TEXT(NUN_PR_MB), dist = 0 };
	UnitPopupButtons[NUN_PR_AO] 		= { text = TEXT(NUN_PR_AO), dist = 0 };
	UnitPopupButtons[NUN_PR_RB] 		= { text = TEXT(NUN_PR_RB), dist = 0 };
	UnitPopupButtons[NUN_PR_SA] 		= { text = TEXT(NUN_PR_SA), dist = 0 };
	UnitPopupButtons[NUN_PR_LW] 		= { text = TEXT(NUN_PR_LW), dist = 0 };
	UnitPopupButtons[NUN_PR_RR] 		= { text = TEXT(NUN_PR_RR), dist = 0 };
	UnitPopupButtons[NUN_PR_MG] 		= { text = TEXT(NUN_PR_MG), dist = 0 };
	UnitPopupButtons[NUN_PR_DJ] 		= { text = TEXT(NUN_PR_DJ), dist = 0 };
	UnitPopupButtons[NUN_PR_NJ] 		= { text = TEXT(NUN_PR_NJ), dist = 0 };
	UnitPopupButtons[NUN_PR_SW] 		= { text = TEXT(NUN_PR_SW), dist = 0 };
	UnitPopupButtons[NUN_PR_NG]			= { text = TEXT(NUN_PR_NG), dist = 0 };
	UnitPopupButtons[NUN_PR_FG]			= { text = TEXT(NUN_PR_FG), dist = 0 };
	UnitPopupButtons[NUN_PR_AV]			= { text = TEXT(NUN_PR_AV), dist = 0 };
	UnitPopupButtons[NUN_PR_KS]			= { text = TEXT(NUN_PR_KS), dist = 0 };
	UnitPopupButtons[NUN_PR_TENSTAR] 	= { text = TEXT(NUN_PR_TENSTAR), dist = 0 };
	UnitPopupButtons[NUN_PR_NINESTAR] 	= { text = TEXT(NUN_PR_NINESTAR), dist = 0 };
	UnitPopupButtons[NUN_PR_EIGHTSTAR] 	= { text = TEXT(NUN_PR_EIGHTSTAR), dist = 0 };
	UnitPopupButtons[NUN_PR_SEVENSTAR] 	= { text = TEXT(NUN_PR_SEVENSTAR), dist = 0 };
	UnitPopupButtons[NUN_PR_SIXSTAR] 	= { text = TEXT(NUN_PR_SIXSTAR), dist = 0 };
	UnitPopupButtons[NUN_PR_FIVESTAR] 	= { text = TEXT(NUN_PR_FIVESTAR), dist = 0 };
	UnitPopupButtons[NUN_PR_FOURSTAR] 	= { text = TEXT(NUN_PR_FOURSTAR), dist = 0 };
	UnitPopupButtons[NUN_PR_THREESTAR] 	= { text = TEXT(NUN_PR_THREESTAR), dist = 0 };
	UnitPopupButtons[NUN_PR_TWOSTAR] 	= { text = TEXT(NUN_PR_TWOSTAR), dist = 0 };
	UnitPopupButtons[NUN_PR_ONESTAR] 	= { text = TEXT(NUN_PR_ONESTAR), dist = 0 };
	UnitPopupButtons[NUN_PR___] 		= { text = TEXT(NUN_PR___), dist = 0 };

	UnitPopupMenus["NUN_POPUP"] 	= {
		"NUN_POPUP_TOGGLE",
		"NUN_PR_TP",
		"NUN_PR_MB",
		"NUN_PR_AO",
		"NUN_PR_RB",
		"NUN_PR_SA",
		"NUN_PR_LW",
		"NUN_PR_RR",
		"NUN_PR_MG",
		"NUN_PR_DJ",
		"NUN_PR_NJ",
		"NUN_PR_SW",
		"NUN_PR_NG",
		"NUN_PR_FG",
		"NUN_PR_AV",
		"NUN_PR_KS",
		"NUN_PR_TENSTAR",
		"NUN_PR_NINESTAR",
		"NUN_PR_EIGHTSTAR",
		"NUN_PR_SEVENSTAR",
		"NUN_PR_SIXSTAR",
		"NUN_PR_FIVESTAR",
		"NUN_PR_FOURSTAR",
		"NUN_PR_THREESTAR",
		"NUN_PR_TWOSTAR",
		"NUN_PR_ONESTAR",
		"NUN_PR___",
	};

	UnitPopupMenus["NUN_POPUP"][1] = NUN_POPUP_TOGGLE;
	for i=1, maxRatings, 1 do
		UnitPopupMenus["NUN_POPUP"][i+1] = NuNSettings.ratings[i];
	end

	if ( initialSetup ) then
		-- Add NotesUNeed Options to Right Click Menus
		local nMenu = getn(UnitPopupMenus["RAID"]) + 1;
		local cMenu = nMenu + 2;
		if ( UnitPopupMenus["RAID"][nMenu] == "CANCEL" ) then
			UnitPopupMenus["RAID"][nMenu] = "NUN_POPUP";
			UnitPopupMenus["RAID"][cMenu] = "CANCEL";
		else
			UnitPopupMenus["RAID"][cMenu] = "NUN_POPUP";
		end

		nMenu = getn(UnitPopupMenus["PARTY"]);
		cMenu = nMenu + 1;
		if ( UnitPopupMenus["PARTY"][nMenu] == "CANCEL" ) then
			UnitPopupMenus["PARTY"][nMenu] = "NUN_POPUP";
			UnitPopupMenus["PARTY"][cMenu] = "CANCEL";
		else
			UnitPopupMenus["PARTY"][cMenu] = "NUN_POPUP";
		end

		nMenu = getn(UnitPopupMenus["PLAYER"]);
		cMenu = nMenu + 1;
		if ( UnitPopupMenus["PLAYER"][nMenu] == "CANCEL" ) then
			UnitPopupMenus["PLAYER"][nMenu] = "NUN_POPUP";
			UnitPopupMenus["PLAYER"][cMenu] = "CANCEL";
		else
			UnitPopupMenus["PLAYER"][cMenu] = "NUN_POPUP";
		end

		nMenu = getn(UnitPopupMenus["FRIEND"]);
		cMenu = nMenu + 1;
		if ( UnitPopupMenus["FRIEND"][nMenu] == "CANCEL" ) then
			UnitPopupMenus["FRIEND"][nMenu] = "NUN_POPUP";
			UnitPopupMenus["FRIEND"][cMenu] = "CANCEL";
		else
			UnitPopupMenus["FRIEND"][cMenu] = "NUN_POPUP";
		end

		hooksecurefunc("UnitPopup_OnClick", NuNNew_UnitPopup_OnClick);		-- 5.40
		hooksecurefunc("UnitPopup_ShowMenu", NuNNew_UnitPopup_ShowMenu);	-- 5.40
	end
end

function NuNNew_UnitPopup_ShowMenu(...)
	if ( "NUN_POPUP" == UIDROPDOWNMENU_MENU_VALUE ) then
		local dropdownFrame = getglobal(UIDROPDOWNMENU_INIT_MENU);
		local name = dropdownFrame.name;
		if ( ( name ) and ( NuNDataPlayers[name] ) and ( NuNDataPlayers[name].prating ) ) then
			local pBttn = getglobal( "DropDownList2Button" .. ( NuNDataPlayers[name].prating + 1 ) );
			if ( pBttn ) then
				local chk = getglobal(pBttn:GetName().."Check");
				if ( chk ) then
					chk:Show();
				end
			end
		end
	end
end

-- 5.60 Re-Written
function NuNNew_UnitPopup_OnClick(...)
	local button = this.value;
	local NuN_PlayerRated = nil;
	local rating = nil;

	if ( button == NUN_POPUP_TOGGLE ) then
		-- open a NuN Note for the Player
		rating = 99;
	else
		for i=1, maxRatings, 1 do							-- 5.60 BETA.02	leave if no NuN button clicked
			if ( button == NuNSettings.ratings[i] ) then	-- 5.60 BETA.02	leave if no NuN button clicked
				NuN_PlayerRated = true;
				rating = i;
				break;								-- 5.60 BETA.02	leave if no NuN button clicked
			end										-- 5.60 BETA.02	leave if no NuN button clicked
		end											-- 5.60 BETA.02	leave if no NuN button clicked
	end

	if ( not rating ) then return; end
	
	local dropdownFrame = getglobal(UIDROPDOWNMENU_INIT_MENU);
	local name = dropdownFrame.name;
	local server = dropdownFrame.server;
	local unit = dropdownFrame.unit;

	if ( ( server ) and ( server ~= "" ) and ( server ~= pKey ) ) then
					-- Ignore Players from other Realms.... ? Concatenate Server-Name.... ? Try to fetch Name from other Realm Player data.... ?
--		NuN_Message("NuN : Player " .. name .. " from different Realm : " .. server);
		return;		-- Ignore for now...
	end

	-- simplifies the readability of the "if" tests later on...
	local leaveOpen = nil;
	if ( ( not NuN_PlayerRated ) or ( IsAltKeyDown() ) ) then
		leaveOpen = true;
	end

	-- if player note already exists
	if ( NuNDataPlayers[name] ) then
		if ( unit ) then
			-- not currently updating existing notes with double checks of data
			-- but if I want to, then this is the place to do it
		end
		if ( leaveOpen ) then
			NuN_ShowSavedNote(name);
		end

	-- else have to create a note via some method
	else
		if ( ( unit ) and ( unit == "target" ) ) then
			if ( leaveOpen ) then
				NuN_FromTarget(false);
			else
				NuN_FromTarget(true);
			end

		elseif ( unit ) then
			NuN_NewContact(unit);
			if ( not leaveOpen ) then
				NuN_WriteNote();
				NuNFrame:Hide();
				NuN_Message(c_name..NUN_AUTONOTED);
			end

		else
			NuN_CreateContact(name, pFaction);	-- fingers crossed not an opposing faction name ??? "target" taken care of above, but what about chat links ?
			if ( not leaveOpen ) then
				NuN_WriteNote();
				NuNFrame:Hide();
				NuN_Message(c_name..NUN_AUTONOTED);
			end
		end
	end

	if ( ( NuN_PlayerRated ) and ( rating ~= 99 ) ) then
		if ( NuNDataPlayers[name] ) then
			NuNDataPlayers[name].prating = rating;
		end
		if ( name == c_name ) then
			ddBoxes.ddPRating = rating;
			c_prating = NuNSettings.ratings[ddBoxes.ddPRating];
			UIDropDownMenu_SetSelectedID(NuNPRatingDropDown, ddBoxes.ddPRating);
			UIDropDownMenu_SetText(c_prating, NuNPRatingDropDown);
		end
		if ( BlackList ) then
			NuN_BlackList(name, rating);
		end
	end

	DropDownList1:Hide();
end

function NuN_BlackList(name, rating)
	local r = NuNSettings.ratingsBL[rating];
	
	if ( r > 0 ) then
		local reason = "|cffA335ED[NuN]: |r" .. NuNSettings.ratings[rating] .. "\n" .. NuNSettings.ratingsT[rating];
		local ignore, warn = false, false;
		if ( ( r == 2 ) or ( r == 4 ) ) then
			ignore = true;
		end
		if ( r > 2 ) then
			warn = true;
		end
		local blI = BlackList:GetIndexByName(name);
		if ( blI > 0 ) then
			local player = BlackList:GetPlayerByIndex(blI);
			local l, c, r = player.level, player.class, player.race;
			NuN_BLCheckBox_Ignore:SetChecked(ignore);
			NuN_BLCheckBox_Warn:SetChecked(warn);
			ignore = NuN_BLCheckBox_Ignore;
			warn = NuN_BLCheckBox_Warn;
			BlackList:UpdateDetails(blI, ignore, warn, reason, l, c, r);
		else
			BlackList:AddPlayer(name, warn, ignore, reason);
		end
	end

	StaticPopup1:Hide();
end

function NuN_EnableBL()
	if ( NuN_BLCheckBox:GetChecked() ) then
		NuN_BLCheckBox_Ignore:Show();
		NuN_BLCheckBox_Warn:Show();
	else
		NuN_BLCheckBox_Ignore:Hide();
		NuN_BLCheckBox_Warn:Hide();
	end
end

-- test this
function NuNNew_AddMessage(this, msg, r, g, b, id, ...)
	if ( this.processingMsg ) then return; end
	this.processingMsg = true;

	if ( ( msg ) and ( type(msg) == "string" ) ) then
		local altmsg = "";

		if ( ( NuNSettings ) and ( NuNSettings[pKey] ) and ( NuNSettings[pKey].chatty ) ) then		-- 20200
			local c1, c2 = string.find(msg, "%b[]");
			if ( ( c1 ) and ( c2 ) ) then
				c1 = c1 + 1;
				c2 = c2 - 1;
				if ( c2 > c1 ) then
					local checkName = string.sub(msg, c1, c2);
					local dash = string.find(checkName, "-");
					if ( dash ) then
						checkName = string.sub(msg, 1, dash-1);
					end
					if ( checkName ) then
						local d = string.len(checkName);
						if ( ( d > 2 ) and ( d < 11 ) ) then
							if ( ( NuNDataPlayers[checkName] ) and ( checkName ~= pName ) ) then
								altmsg = altmsg.."|cffA336ED<NuN";
								if ( NuNDataPlayers[checkName].prating ) then
									local rating = NuNSettings.ratings[NuNDataPlayers[checkName].prating];
									if ( ( rating ~= "" ) and ( rating ~= " " ) ) then
										altmsg = altmsg..":"..rating;
									end
								end
								altmsg = altmsg..">|r";
							end
						end
					end
				end
			end
		end

		msg = altmsg..msg;
	end

	this.NuNOri_AddMessage(this, msg, r, g, b, id, ...);
	this.processingMsg = nil;
end


-- This function records the player location in a new QST type note when Objectives are completed so you know for next time
function NuN_QuestWatch_Update()
	local numObjectives;
	local text, type, finished;
	local questIndex;

	if ( ( not pKey ) or ( not NuNDataPlayers ) ) then
		return;
	end

	for i=1, GetNumQuestWatches() do
		questIndex = GetQuestIndexForWatch(i);

		if ( questIndex ) then
			local theQuest = GetQuestLogTitle(questIndex);

			if ( theQuest ) then
				local qNoteLevel = nil;

				if ( NuNDataANotes[theQuest] ) then
					qNoteLevel = "Account";

				elseif ( NuNDataRNotes[theQuest] ) then
					qNoteLevel = "Realm";
				end

				if ( ( qNoteLevel ) and ( NuNSettings[pKey].autoQ ) ) then
					local l_c_note = c_note;
					local l_g_text = g_text;
					local l_c_name = c_name;

					local theQuestI = theQuest..":"..NUN_OBJECTIVES;
					c_note = theQuestI;
					if ( ( not NuNDataANotes[theQuestI] ) and ( not NuNDataRNotes[theQuestI] ) ) then
						if ( qNoteLevel == "Account" ) then
							NuNDataANotes[theQuestI] = {};
							NuNDataANotes[theQuestI].type = 5;
						else
							NuNDataRNotes[theQuestI] = {};
							NuNDataRNotes[theQuestI].type = 5;
						end
						g_text = " ";
						NuNF.NuN_SetGText(qNoteLevel);

					elseif ( NuNDataANotes[theQuestI] ) then
						qNoteLevel = "Account";
						g_text = NuNF.NuN_GetGText(c_note);

					elseif ( NuNDataRNotes[theQuestI] ) then
						qNoteLevel = "Realm";
						g_text = NuNF.NuN_GetGText(c_note);
					end

					numObjectives = GetNumQuestLeaderBoards(questIndex);

					local location = nil;
					if ( numObjectives > 0 ) then
						for j=1, numObjectives do
							text, type, finished = GetQuestLogLeaderBoard(j, questIndex);
							if ( ( not string.find(g_text, text) and ( not string.find(text, ": 0") ) and ( string.len(g_text) < NuNC.NUN_MAX_TXT_BUF ) ) ) then
								if ( not location ) then
									SetMapToCurrentZone();
									location = NuNF.NuN_GetLoc();
									if ( location ) then
										location = NuN_LocStrip(location);
									end
								end
								if ( location ) then
									g_text = g_text.."\n"..location.."\n"..text.."\n";
									NuNF.NuN_SetGText(qNoteLevel);
								end
							end
						end
					end

					c_note = l_c_note;
					g_text = l_g_text;
					c_name = l_c_name;
				end
			end
		end
	end
end



function NuN_MainUpdate()
	-- delay harvesting NPC information from a tooltip, until the tooltip is actually visible
	if ( ( NPCInfo_Proceed ) and ( GameTooltip:IsVisible() ) ) then
		NPCInfo_Proceed.func( NPCInfo_Proceed.autoHide );
		return;
	end

	-- In case of unforseen circumstance; Make sure the WhoFrame doesn't remain UnRegistered for more than a maximum of  (NuNC.NUN_WHO_TIMELIMIT * 2)  seconds
	if ( NuN_WhoReturnStruct.timeLimit ) then
		NuN_WhoReturnStruct.timeLimit = NuN_WhoReturnStruct.timeLimit + arg1;
		if ( NuN_WhoReturnStruct.timeLimit > (NuNC.NUN_WHO_TIMELIMIT * 2) ) then
					NuN_WhoReturnStruct.func = nil;													-- 5.60
					NuN_WhoReturnStruct.name = nil;													-- 5.60
					NuN_WhoReturnStruct.timeLimit = nil;											-- 5.60
					NuN_WhoReturnStruct.secondTry = nil;
					NuN_suppressExtraWho = nil;
					if ( ( NuNSettings[pKey] ) and ( NuNSettings[pKey].alternativewho ) ) then
						SetWhoToUI(0);                                          					-- 5.60
						FriendsFrame:RegisterEvent("WHO_LIST_UPDATE");								-- 5.60
					end

		elseif ( ( NuN_WhoReturnStruct.timeLimit > NuNC.NUN_WHO_TIMELIMIT ) and ( not NuN_WhoReturnStruct.secondTry ) ) then
			NuN_WhoReturnStruct.secondTry = true;
			NuN_suppressExtraWho = true;
			SendWho("n-"..NuN_WhoReturnStruct.name);								-- 1 more try, as perhaps the first was ignored by Blizzard Timer
--			NuN_WhoReturnStruct.timeLimit = 9999;
		end
	end

	if ( NuN_DTrans.Status == "Sending" ) then
		NuN_DTrans.tTrack = NuN_DTrans.tTrack + arg1;
		if ( NuN_DTrans.tTrack > NuN_DTrans.tDelay ) then
			NuN_DTrans.tTrack = 0;
			NuN_DTrans.aIndex = NuN_DTrans.aIndex + 1;
			if ( NuN_DTrans.pArray[ NuN_DTrans.aIndex ] ) then
					SendChatMessage(	NuN_DTrans.pArray[ NuN_DTrans.aIndex ], 
										NuN_DTrans.Params.sendTo, 
										NuN_DTrans.Params.dfltLang, 
										NuN_DTrans.Params.user	);
			else
				NuN_DTrans.Status = "Inactive";
				NuN_DTrans.aIndex = 0;
				NuN_DTrans.pArray = {};
				NuN_DTrans.Prefix = "";
			end
		end
	end

	-------------------------- 5.60 Moved from MicroButton OnUpdate --------------------------------
	if ( ( pFaction == nil ) or ( NuN_horde == nil ) ) then
		NuN_getFaction();
	end

	-- needed to introduce a delay at startup before Friends/Ignores could be refreshed... not sure if still necessary
	if ( ( fBusy ) or ( iBusy ) ) then
		NuN_AttemptedFriendIgnores = 0;

		if ( fBusy ) then
			if ( GetNumFriends() > 0 ) then
				fBusy = NuN_Update_Friends();
			else
				fBusy = nil;
			end
		end

		if ( iBusy ) then
			if ( GetNumIgnores() > 0 ) then
				iBusy = NuN_Update_Ignored();
			else
				iBusy = nil;
			end
		end
	end

	-- accounts for the delay between tooltip SetLink and display of the actual ItemRef tooltip.....
	if ( ( delayedItemTooltip ) and ( ItemRefTooltip:IsVisible() ) ) then
		NuNF.NuN_GNoteFromItem(delayedItemTooltip, "ItemRefTooltip");
		delayedItemTooltip = nil;
		ItemRefTooltip:Hide();
	end

	-- delayed display of NuN tooltip until we have something to anchor it to
	if ( noTipAnchor ) then
		NuN_GameTooltip_OnShow(noTipAnchor);
	end

	-- If receiving a note, and not waiting for a decision from the player on a possible Duplicate Record
	if ( ( NuN_Receiving.active ) and ( not receiptPending ) ) then
		NuN_Receiving.timer = NuN_Receiving.timer + arg1;
		if ( NuN_Receiving.timer > receiptDeadline ) then
			if ( NuN_Receiving.version ) then
				NuN_Message(NUN_RECEIPT_EXPIRED..NuN_Receiving.from);	-- Final parts of the message didn't arrive in a reasonable amount of time, so gave up on receipt process
				NuN_WriteReceiptLog();
			end
			NuN_Receiving = {};
			receiptDeadline = defaultReceiptDeadline;
		end
	end

	-- This stops the user from double clicking the Transmit button, and sending multiple notes in quick succession
	if ( busySending.active ) then
		NuN_transmissionTimer = NuN_transmissionTimer - arg1;
		if ( NuN_transmissionTimer < 0.1 ) then
			busySending = {};
			busySending.user = "";
			busySending.active = nil;
			busySending.counter = 0;
			NuN_transmissionTimer = 0;
			NuNTransmit:Enable();
		end
	end

	if ( NuN_State.togglePinUp ) then
		NuN_FlagMoved();
		NuN_ClearPinnedTT();
		NuN_PinnedTooltipToggle(NuN_PinnedTooltip.type, NuN_PinnedTooltip.noteName);
		NuN_State.togglePinUp = false;
	end
	
	-- Mainly a timed update of Quest notes
	timeSinceLastUpdate = timeSinceLastUpdate + arg1;
	if ( ( timeSinceLastUpdate > 3 ) and ( not UnitAffectingCombat("player") ) ) then
		if ( not NuNDataPlayers[pName] ) then
			NuN_AutoNote();
		end
		if ( NuN_State.NuN_forceGR ) then
			GuildRoster();
		end
		if ( NuN_State.oneDone ) then
			NuN_State.oneDone = false;
			NuN_State.NuN_AtStartup = false;
			NuN_State.NuN_QuestsUpdating = false;

		else
			NuN_State.oneDone = true;
			if ( not NuN_QLF:IsVisible() ) then
				NuNF.NuN_CheckQuestList();
				if ( not NuN_State.NuN_IgnoreNextQUpdate ) then
					NuNF.NuN_UpdateQuestNotes("Timed");
				end
			end
		end
		timeSinceLastUpdate = 0;
	end
	-------------------------- 5.60 Moved from MicroButton OnUpdate --------------------------------

	if ( sn.totCount > 0 ) then
		if ( not sn.Waiting ) then
			sn.Count = sn.Count + 1;
			if ( sn.Array[sn.Count] ) then
				NuN_ProcessSocialNote( sn.Array[sn.Count] );
			else
				NuN_ImportSocialNote_Terminate();
			end
		end
	end

end



function NuN_CustomFontCheckBox_OnClick()
	if ( this:GetChecked() ) then
		NuN_UpdateFont(NuNC.NUN_FONT1, 12);
		NuNSettings[pKey].nunFont = true;
	else
		NuN_UpdateFont("Fonts\\FRIZQT__.TTF", 12);
		NuNSettings[pKey].nunFont = nil;
	end
end

function NuN_UpdateFont(theFont, fontSize)
	if ( theFont ) then
		NuNText:SetFont(theFont, fontSize);
		NuNEditDetailsBox:SetFont(theFont, fontSize);
		NuNOptionsTTLengthTextBox:SetFont(theFont, fontSize);
		NuNOptionsTTLineLengthTextBox:SetFont(theFont, fontSize);
		NuNChatTextBox:SetFont(theFont, fontSize);
		NuNSearchTextBox:SetFont(theFont, fontSize);
		NuNGNoteTextBox:SetFont(theFont, fontSize);
		NuNGNoteTextScroll:SetFont(theFont, fontSize);
	end
end



----------------------------------------------------------------------------------------------------------------------------------------------

function NuN_GuildRefresh(forceReport)	
	local numGuildMembers = GetNumGuildMembers(true);
	local pGuild = GetGuildInfo("player");

	if ( ( not pGuild ) or ( pGuild == "" ) ) then
		return;

	elseif ( numGuildMembers < 1 ) then
		GuildRoster();
		NuN_State.NuN_forceGR = true;
		return;
	end

	local statsNoted, statsOnline, statsNew, statsX = 0, 0, 0, 0;
	local classes;
	if ( NuN_horde ) then
		classes = NUN_HCLASSES;
	else
		classes = NUN_ACLASSES;
	end

	-- Build array of Members we have already noted (may need to rely on .guild rather than User Definable...) i.e. do BEFORE updating notes from Guild Roster ;)
	local notedMembers = {};
	for name, details in pairs(NuNDataPlayers) do
		if ( ( details.guild ) and ( details.guild == pGuild ) ) then
			notedMembers[name] = true;
			statsNoted = statsNoted + 1;
		end
	end

	-- Process the Guild Roster, updating notes, and noting Newly noted members
	local lgName, lgRank, lgRankIndex, lgClass, lgOnline, lgStatus;
	local rosterA = {};
	local hdr1, hdr2 = pHead..1, pHead..2;
	local phdr, pdtl;
	local dfltH1, dfltH2 = NUN_DFLTHEADINGS[1], NUN_DFLTHEADINGS[2];
	for gI = 1, numGuildMembers, 1 do
		lgName, lgRank, lgRankIndex, _, lgClass, _, _, _, lgOnline, lgStatus = GetGuildRosterInfo(gI);
		lgClass = NuNF.NuNGet_TableID(classes, lgClass);
		if ( lgName ) then
			rosterA[lgName] = {};
			rosterA[lgName].i = gI;
			if ( lgOnline ) then
				statsOnline = statsOnline + 1;
				rosterA[lgName].o = lgOnline;
			end
			if ( not NuNDataPlayers[lgName] ) then
				rosterA[lgName].n = true;
				statsNew = statsNew + 1;
				NuNDataPlayers[lgName] = {};
				NuNDataPlayers[lgName].type = NuNC.NUN_GUILD_C;
			else
				if ( ( NuNDataPlayers[lgName].guild ) and ( not NuNDataPlayers[lgName].type ) ) then
					NuNDataPlayers[lgName].type = NuNC.NUN_GUILD_C;
				end
				if ( NuNDataPlayers[lgName].guild ) and ( NuNDataPlayers[lgName].guild == pGuild ) then
					rosterA[lgName].n = nil;
				else
					NuNDataPlayers[lgName].guild = pGuild;
					rosterA[lgName].n = true;
					statsNew = statsNew + 1;
				end
			end
			NuNDataPlayers[lgName].faction = pFaction;
			NuNDataPlayers[lgName].guild = pGuild;
			NuNDataPlayers[lgName].cls = lgClass;
			-- if Player Specific Heading not equal to default, -OR- Account Specific Heading not equal to default, then don't update -ELSE-
			phdr = lgName..hdr1;
			if	( ( ( NuNDataPlayers[phdr] ) and ( NuNDataPlayers[phdr].txt ~= dfltH1 ) ) or
					( NuNSettings[hdr1] ) and ( NuNSettings[hdr1].txt ~= dfltH1 ) ) then
 
			else
				pdtl = lgName..pDetl..1;
				NuNDataPlayers[pdtl] = {};
				NuNDataPlayers[pdtl].txt = pGuild;
				phdr = lgName..hdr2;
				if 	( ( ( NuNDataPlayers[phdr] ) and ( NuNDataPlayers[phdr].txt ~= dfltH2 ) ) or
						( NuNSettings[hdr2] ) and ( NuNSettings[hdr2].txt ~= dfltH2 ) ) then
	
				else
					pdtl = lgName..pDetl..2;
					NuNDataPlayers[pdtl] = {};
					if ( lgRankIndex == 0 ) then
						lgRank = ("GM : "..lgRank);
					else
						lgRank = (lgRankIndex.." : "..lgRank);
					end
					NuNDataPlayers[pdtl].txt = lgRank;
				end
			end
		end
	end

	-- Check for members we noted as in the Guild previously, who are no longer in the Guild
	for member in pairs(notedMembers) do
		if ( not rosterA[member] ) then
				rosterA[member] = {};
				rosterA[member].x = true;
				statsX = statsX + 1;
		end
	end

	-- if forceReport mode, then report refresh details
	if ( ( forceReport ) and ( ( forceReport == "Startup" ) or ( statsX > 0 ) or ( statsNew > 0 ) ) ) then
		local catTxt, catSep, catCount = "", "", 0;
		NuN_Message( "NotesUNeed : " .. NUN_GUILD .. " - " .. numGuildMembers .. " (".. statsOnline .. ")" );
		NuN_Message( "NotesUNeed : " .. NUN_NEW_GUILDMATE .. " (" .. statsNew .. ") : " );
		for member, details in pairs(rosterA) do
			if ( details.n ) then
				catTxt = catTxt .. catSep .. member;
				catCount = catCount + 1;
				catSep = ", ";
			end
			if ( catCount > 9 ) then				-- output 10 names per line
				NuN_Message("    " .. catTxt);
				catTxt = "";
				catSep = "";
				catCount = 0;
			end
		end
		if ( catTxt ~= "" ) then
			NuN_Message("    " .. catTxt);
		end
		catTxt = "";
		catSep = "";
		catCount = 0;
		NuN_Message( "NotesUNeed : " .. NUN_X_GUILDMATE .. " (" .. statsX .. ") : " );
		for member, details in pairs(rosterA) do
			if ( details.x ) then
				catTxt = catTxt .. catSep .. member;
				catCount = catCount + 1;
				catSep = ", ";
			end
			if ( catCount > 9 ) then				-- output 10 names per line
				NuN_Message("    " .. catTxt);
				catTxt = "";
				catSep = "";
				catCount = 0;
			end
		end
	end

end										


-----------------------------------------------------------------------------------------------


function NuNOptions_SetModifier(mBttn)
	if ( IsModifierKeyDown() ) then
		local modKeys = "";
		local antiKey = "";
		local sep = "";
		local antiSep = "";

		if ( mBttn == "LeftButton" ) then

			if ( IsControlKeyDown() ) then
				modKeys = "Control";
				sep = "-";
			else
				antiKey = "Control";
				antiSep = "-";
			end
			if ( IsAltKeyDown() ) then
				modKeys = modKeys .. sep .. "Alt";
				sep = "-";
			else
				antiKey = antiKey .. antiSep .. "Alt";
				antiSep = "-";
			end
			if ( IsShiftKeyDown() ) then
				modKeys = modKeys .. sep .. "Shift";
			else
				antiKey = antiKey .. antiSep .. "Shift";
			end

		elseif ( mBttn == "RightButton" ) then

			if ( IsLeftControlKeyDown() ) then
				modKeys = "LeftControl";
				sep = "-";
			else
				antiKey = "LeftControl";
				antiSep = "-";
			end
			if ( IsRightControlKeyDown() ) then
				modKeys = modKeys .. sep .. "RightControl";
				sep = "-";
			else
				antiKey = antiKey .. antiSep .. "RightControl";
				antiSep = "-";
			end
			if ( IsLeftAltKeyDown() ) then
				modKeys = modKeys .. sep .. "LeftAlt";
				sep = "-";
			else
				antiKey = antiKey .. antiSep .. "LeftAlt";
				antiSep = "-";
			end
			if ( IsRightAltKeyDown() ) then
				modKeys = modKeys .. sep .. "RightAlt";
				sep = "-";
			else
				antiKey = antiKey .. antiSep .. "RightAlt";
				antiSep = "-";
			end
			if ( IsLeftShiftKeyDown() ) then
				modKeys = modKeys ..sep .. "LeftShift";
				sep = "-";
			else
				antiKey = antiKey .. antiSep .. "LeftShift";
				antiSep = "-";
			end
			if ( IsRightShiftKeyDown() ) then
				modKeys = modKeys ..sep .. "RightShift";
			else
				antiKey = antiKey .. antiSep .. "RightShift";
			end

		end
		NuNSettings[pKey].modKeys = modKeys;
		NuNSettings[pKey].antiKey = antiKey;
		NuNOptions_SetModifierText();

	else
		NuNSettings[pKey].mouseBttn = mBttn;
		NuNOptions_SetModifierText();
	end
end

function NuNOptions_SetModifierText()
	if ( ( NuNSettings ) and ( NuNSettings[pKey] ) ) then
		if ( not NuNSettings[pKey].modKeys ) then
			NuNSettings[pKey].modKeys = "Alt";
		end
		if ( not NuNSettings[pKey].antiKey ) then
			NuNSettings[pKey].antiKey = "Control-Shift";
		end
		if ( not NuNSettings[pKey].mouseBttn ) then
			NuNSettings[pKey].mouseBttn = "LeftButton";
		end

		local modKeys = {};
		if ( string.find(NuNSettings[pKey].modKeys, "-") ) then
			modKeys = { strsplit("-", NuNSettings[pKey].modKeys) };
		else
			modKeys[1] = NuNSettings[pKey].modKeys;
		end
		local bttnText = "<" .. NUN_MODIFIERS[ modKeys[1] ] .. ">";
		for i=2, getn(modKeys), 1 do
			bttnText = bttnText .. "+<" .. NUN_MODIFIERS[ modKeys[i] ] .. ">";
		end
		bttnText = bttnText .. " : " .. NuNSettings[pKey].mouseBttn;
		NuNOptionsModifier:SetText(bttnText);
	else
		NuNOptionsModifier:SetText("<Alt> : LeftButton");
	end
end

function IsNuNModifierKeyDown(mBttn)
	if ( ( IsModifierKeyDown() ) and ( NuNSettings[pKey] ) ) then
		if ( ( ( not NuNSettings[pKey].mouseBttn ) and ( mBttn == "LeftButton" ) ) or ( mBttn == NuNSettings[pKey].mouseBttn ) ) then
			if ( not NuNSettings[pKey].modKeys ) then
				NuNSettings[pKey].modKeys = "Alt";
			end
			if ( not NuNSettings[pKey].antiKey ) then
				NuNSettings[pKey].antiKey = "Control-Shift";
			end

			local modKeys = {};
			if ( string.find(NuNSettings[pKey].modKeys, "-") ) then
				modKeys = { strsplit("-", NuNSettings[pKey].modKeys) };			-- Note my curly brackets....
			else
				modKeys[1] = NuNSettings[pKey].modKeys;
			end
			local totalKeys = getn(modKeys);
			local keysPressed = 0;
			for i=1, totalKeys, 1 do
				local keyFunc = getglobal("Is"..modKeys[i].."KeyDown");
				if ( ( type(keyFunc) == "function" ) and ( keyFunc() ) ) then	-- I think LUA has short circuit logic
					keysPressed = keysPressed + 1;
				end
			end

			-- STRICT ENFORCEMENT :
			-- The following makes sure that <Control><Alt><Shift> would be ignored where the Modifier Set is <Control><Shift> alone....
			--  i.e. it would allow the full Set of <Control><Alt><Shift> to be used by another AddOn without invoking NotesUNeeds limited <Control><Shift> Set
			local antiKey = {};
			if ( string.find(NuNSettings[pKey].antiKey, "-") ) then
				antiKey = { strsplit("-", NuNSettings[pKey].antiKey) };			-- Note my curly brackets....
			else
				antiKey[1] = NuNSettings[pKey].antiKey;
			end
			local totalAntiKey = getn(antiKey);
			local antiKeyPressed = 0;
			for i=1, totalAntiKey, 1 do
				local keyFunc = getglobal("Is"..antiKey[i].."KeyDown");
				if ( ( type(keyFunc) == "function" ) and ( keyFunc() ) ) then	-- I think LUA has short circuit logic
					antiKeyPressed = antiKeyPressed + 1;
				end
			end

			if ( ( keysPressed == totalKeys ) and ( antiKeyPressed == 0 ) ) then
				return true;
			end
		end
	end
	return nil;
end


-----------------------------------------------------------------------------------------------


function NuN_ImportSocialNotes_Start()
	if ( not SocialNotes ) then
		NuN_Message("SocialNotes AddOn NOT Detected !");
	else
		local loCount = 0;
		for _, playerDetails in pairs(SocialNotes) do
			if ( ( playerDetails.title ) and ( playerDetails.body ) ) then
				loCount = loCount + 1;
				sn.Array[ loCount ] = {};
				sn.Array[ loCount ].title = playerDetails.title;
				sn.Array[ loCount ].body = playerDetails.body;
			end
		end
		sn.totCount = loCount;
	end
end

function NuN_ImportSocialNote_Terminate()
	NuN_Message(sn.Imported .. " Social Notes Imported in to NuN from a total of " .. sn.totCount);
	if ( sn.Exists > 0 ) then NuN_Message(sn.Exists .. " Notes already Imported"); end
	if ( sn.Ignored > 0 ) then NuN_Message(sn.Ignored .. " Social Notes Skipped"); end
	sn.Waiting = nil;
	sn.totCount = 0;
	sn.count = 0;
	sn.Imported, sn.Ignored = 0, 0;
	sn.Array = {};
end		

-- Import Social Notes
function NuN_ProcessSocialNote(playerDetails)
	sn.Name = playerDetails.title;
	sn.Body = playerDetails.body;
				
	if ( NuNDataPlayers[sn.Name] ) then
		local tstTxt = NuNF.NuN_GetCText(sn.Name);
		if ( not string.find(tstTxt, NUN_SN_FLAG) ) then
			local tmpTxt = c_text;
			c_text = tstTxt .. "\n" .. sn.Body .. "\n" .. NUN_SN_FLAG;
			NuNF.NuN_SetCText(sn.Name);
			c_text = tmpTxt;
			sn.Imported = sn.Imported + 1;
		else
			sn.Exists = sn.Exists + 1;
		end

	elseif ( sn.CancelAll ) then
		sn.Ignored = sn.Ignored + 1;

	else
		StaticPopup_Show("NUN_CHOOSE_SN_IMPORT");
	end

end


-----------------------------------------------------------------------------------------------




function NuN_ColourText(noteType, fBttn, mBttn)
	local eBox = NuNGNoteTextScroll;
	
	if ( noteType == "General" ) then
	
	elseif ( noteType == "Contact" ) then
		eBox = NuNText;
	end

	-- Toggle display of colour markers or change Preset colour selection
	if ( mBttn == "RightButton" ) then

		-- Open Colour Picker to change a preset if necessary
		if ( fBttn.preset ) then
			-- Reset the preset if Alt key is down
			if ( IsAltKeyDown() ) then
				local hexVal = NuNC.NUN_CPRESETS[ fBttn:GetID() ];
				local cKey = "cc";
				if ( fBttn.parentType == "General" ) then
					cKey = "gc";
				end
				cKey = cKey .. fBttn:GetID();
				NuNSettings[pKey][cKey] = hexVal;
				fBttn.preset = hexVal;
				
				local r, g, b = NuNF.NuN_HtoD(hexVal);
				getglobal(fBttn:GetName().."Texture"):SetVertexColor(r, g, b);


			-- or open the colour picker to choose a different preset colour
			else
				if ( ColorPickerFrame:IsVisible() ) then
					if ( ColorPickerFrame.cancelFunc ) then
						ColorPickerFrame.cancelFunc(ColorPickerFrame.previousValues);
					end
					HideUIPanel(ColorPickerFrame);
				else
					NuNF.NuN_ChoosePresetColour(fBttn);
				end
			end

		-- else Right Click on Colour Picker button to Toggle display of Colour Tags in the Edit Box
		else
			if ( fBttn.showCTags ) then
				NuN_AllowColours(fBttn.parentType);
				local dText = eBox:GetText();
				dText = string.gsub(dText, "\124\124", "|");
				-- converting double to single is safe in one step
				dText = string.gsub(dText, "|C", "|c");
				dText = string.gsub(dText, "|R", "|r");
				dText = string.gsub(dText, "||c", "|c");
				dText = string.gsub(dText, "||r", "|r");
				eBox:SetText(dText);

			else
				NuN_ForbidColours(fBttn.parentType);
				local dText = eBox:GetText();
				dText = string.gsub(dText, "\124\124", "|");
				-- convert ALL double to single FIRST, otherwise double could be converted to triple by the end...
				dText = string.gsub(dText, "|C", "|c");
				dText = string.gsub(dText, "|R", "|r");
				dText = string.gsub(dText, "||c", "|c");
				dText = string.gsub(dText, "||r", "|r");
				-- the actual conversion we want
				dText = string.gsub(dText, "|c", "||c");
				dText = string.gsub(dText, "|r", "||r");
				eBox:SetText(dText);
			end
		end


	-- Choose custom colour selection for text
	elseif ( mBttn == "LeftButton" ) then
		-- if a preset Colour Button, then apply the preset colour
		if ( fBttn.preset ) then
			NuNF.NuN_ColourPicked(eBox, fBttn.preset);


		-- else open the colour picker to choose a custom colour....
		else
			-- need a way of testing full acceptance of a colour
			-- I can NOT apply the colour EVERY time it changes, unless I reselect the text (i.e. rehighlight it...)
			-- the best option would be to store the colour change EVERY time, but I need to hook when the Actual OK button is clicked...
			-- Gonna set up the Color Picker with a dummy .func() and monitor the Okay button instead
			if ( not fBttn.showCTags ) then
				if ( ColorPickerFrame:IsVisible() ) then
					if ( ColorPickerFrame.cancelFunc ) then
						ColorPickerFrame.cancelFunc(ColorPickerFrame.previousValues);
					end
					HideUIPanel(ColorPickerFrame);
				else
					NuNF.NuN_ChooseTextColour(eBox, textToColour);
				end
			end
		end
	end

end


-- Functions to choose custom text colours
function NuNF.NuN_ChooseTextColour(eBox, textToColour)
	local col = { r=1, g=1, b=1 };
	if ( NuNSettings[pKey].lastCustomC ) then
		col.r = NuNSettings[pKey].lastCustomC.r;
		col.g = NuNSettings[pKey].lastCustomC.g;
		col.b = NuNSettings[pKey].lastCustomC.b;
	end

	ColorPickerFrame.eBox = eBox;
	ColorPickerFrame.textToColour = textToColour;
	ColorPickerFrame.hasOpacity = false;
	ColorPickerFrame.func = NuNF.NuN_AcceptTextColour;
	ColorPickerFrame.cancelFunc = NuNF.NuN_CancelTextColour;
	ColorPickerFrame.previousValues = {col.r, col.g, col.b};
	ColorPickerFrame:SetFrameStrata("FULLSCREEN_DIALOG");
	ColorPickerFrame.opacity = 1.0;
	ColorPickerFrame:SetColorRGB(col.r, col.g, col.b);
	NuN_ColorPickerOkayMask:Show();				-- Intercept actual "accept the colour" clicks on the Okay button
	ColorPickerFrame:Show();
end

function NuNF.NuN_AcceptTextColour()
	-- do nothing : only execute when Okay clicked
end

function NuNF.NuN_CancelTextColour(col)
	-- do nothing : only do something when Okay clicked
	NuN_ColorPickerOkayMask:Hide();
end

function NuN_ColorPickerOkay()
	local r, g, b = ColorPickerFrame:GetColorRGB();
	NuNSettings[pKey].lastCustomC = {};
	NuNSettings[pKey].lastCustomC.r = r;
	NuNSettings[pKey].lastCustomC.g = g;
	NuNSettings[pKey].lastCustomC.b = b;
	NuNF.NuN_ColourPicked(ColorPickerFrame.eBox, NuNF.NuN_DtoH(r, g, b));
	NuN_ColorPickerOkayMask:Hide();
end


-- Function to apply chosen colour to text *!*
function NuNF.NuN_ColourPicked(eBox, toColour)
	local textToColour = NuNF.NuN_GetSelectedText(eBox);

	if ( textToColour ) then
		-- Very basic colouring technique
--		textToColour = toColour .. textToColour .. "|r";
		-- More advanced colouring technique
		textToColour = NuNF.NuN_Colouriser(textToColour, toColour);
		eBox:Insert(textToColour);	
	end
end

-- Try my best to ensure all selected text that is not already "colourised" is NOW colourised...
-- I can't guarantee it, as I don't exhaustively look for colour tags that are "in effect" BEFORE/AFTER the highlighted region... and I ain't going to either ;p This is pretty good for requirements
function NuNF.NuN_Colouriser(textToColour, toColour)
	local tF, tT, qTst = 0;
	local colouredText = "";
	local nextString;
	local openTag = false;
	local col;
	local txtLen = string.len(textToColour);

	textToColour = string.gsub(textToColour, "\124\124", "|");
	textToColour = string.gsub(textToColour, "|C", "|c");
	textToColour = string.gsub(textToColour, "|R", "|r");

	-- if wanting to replace the colouring of selected text that includes its own tag start and end, then do in one fell swoop...
	if ( ( string.sub(textToColour, 1, 2) == "|c" ) and ( string.sub(textToColour, txtLen-1, txtLen) == "|r" ) ) then
		colouredText = toColour .. string.sub(textToColour, 11);
		return colouredText;
	end

	-- otherwise, iterate through the string looking for 'clean' segments of text to colour in...
	while ( true ) do
		tT = string.find(textToColour, "|", tF+1);

		if ( not tT ) then
			nextString = string.sub(textToColour, tF+1);
			if ( ( nextString ) and ( nextString ~= "" ) ) then
				if ( openTag ) then
					col = "";
				else
					col = toColour;
				end
				colouredText = colouredText .. col .. nextString .. "|r";
				openTag = false;
			end
			break;
		else
			qTst = string.sub(textToColour, tT, tT+1);
			if ( qTst == "|r" ) then
				nextString = string.sub(textToColour, tF+1, tT+1);
				if ( ( nextString ) and ( nextString ~= "" ) ) then
					colouredText = colouredText .. string.sub(textToColour, tF+1, tT+1);
				end
				tF = tT + 1;

			elseif ( qTst == "|c" ) then
				nextString = string.sub(textToColour, tF+1, tT-1);
				if ( ( nextString ) and ( nextString ~= "" ) ) then				
					if ( openTag ) then
						col = "";
					else
						col = toColour;
					end
					colouredText = colouredText .. col .. nextString .. "|r";
					openTag = false;
				end
				tF = tT - 1;
				tT = string.find(textToColour, "|r", tF+1);
				if ( not tT ) then
					colouredText = colouredText .. string.sub(textToColour, tF+1);
					break;
				else
					colouredText = colouredText .. string.sub(textToColour, tF+1, tT+1);
					tF = tT + 1;
				end

			else
				nextString = string.sub(textToColour, tF+1, tT);
				if ( openTag ) then
					col = "";
				else
					col = toColour;
				end				
				colouredText = colouredText .. col .. nextString;
				openTag = true;
				tF = tT;
			end
		end
	end

	-- final tidy up of any opening tags that we inserted, and have not already closed...
	if ( openTag ) then colouredText = colouredText .. "|r"; end
	
	return colouredText;
end

-- Functions to select custom Presets
function NuNF.NuN_ChoosePresetColour(fBttn)
	local col = {};
	col.r, col.g, col.b = NuNF.NuN_HtoD(fBttn.preset);

	ColorPickerFrame.fBttn = fBttn;
	ColorPickerFrame.hasOpacity = false;
	ColorPickerFrame.func = NuNF.NuN_AcceptPresetColour;
	ColorPickerFrame.cancelFunc = NuNF.NuN_CancelPresetColour;
	ColorPickerFrame.previousValues = {col.r, col.g, col.b};
	ColorPickerFrame:SetFrameStrata("FULLSCREEN_DIALOG");
	ColorPickerFrame.opacity = 1.0;
	ColorPickerFrame:SetColorRGB(col.r, col.g, col.b);
	ColorPickerFrame:Show();
end

function NuNF.NuN_AcceptPresetColour()
	local r, g, b = ColorPickerFrame:GetColorRGB();
	NuNF.NuN_ApplyPresetColour(ColorPickerFrame.fBttn, r, g, b);
end

function NuNF.NuN_CancelPresetColour(col)
	if ( col ) then
		NuNF.NuN_ApplyPresetColour(ColorPickerFrame.fBttn, col[1], col[2], col[3]);
		ColorPickerFrame.fBttn = nil;
	end
end

function NuNF.NuN_ApplyPresetColour(fBttn, r, g, b)
	local hexVal = NuNF.NuN_DtoH(r, g, b);
	local cKey = "cc";
	if ( fBttn.parentType == "General" ) then
		cKey = "gc";
	end
	cKey = cKey .. fBttn:GetID();

	NuNSettings[pKey][cKey] = hexVal;
	fBttn.preset = hexVal;

	getglobal(fBttn:GetName().."Texture"):SetVertexColor(r, g, b);
end


function NuN_AllowColours(fType)
	if ( fType == "Contact" ) then
		NuNCColourButton.showCTags = nil;
		NuNCColourPreset1:Show();
		NuNCColourPreset2:Show();
		NuNCColourPreset3:Show();
		NuNCColourPreset4:Show();
		NuNCColourPreset5:Show();

	elseif ( fType == "General" ) then
		NuNGColourButton.showCTags = nil;
		NuNGColourPreset1:Show();
		NuNGColourPreset2:Show();
		NuNGColourPreset3:Show();
		NuNGColourPreset4:Show();
		NuNGColourPreset5:Show();
	end
end

function NuN_ForbidColours(fType)
	if ( fType == "Contact" ) then
		NuNCColourButton.showCTags = true;
		NuNCColourPreset1:Hide();
		NuNCColourPreset2:Hide();
		NuNCColourPreset3:Hide();
		NuNCColourPreset4:Hide();
		NuNCColourPreset5:Hide();

	elseif ( fType == "General" ) then
		NuNGColourButton.showCTags = true;
		NuNGColourPreset1:Hide();
		NuNGColourPreset2:Hide();
		NuNGColourPreset3:Hide();
		NuNGColourPreset4:Hide();
		NuNGColourPreset5:Hide();
	end
end


----------------------------------------------------------------------------------------------



function NuN_ChatDelay_EditBoxInit()
	NuN_ChatDelay_EditBox:SetText( NuN_DTrans.tDelay );
end


function NuN_ChatDelay_EditBoxValidate()
	local delay = NuN_ChatDelay_EditBox:GetText();
	delay = tonumber(delay);

	if ( not delay ) then
		NuN_ChatDelay_EditBoxInit();
		return true;

	else
		NuNSettings[pKey].delay = delay;
		NuN_DTrans.tDelay = delay;
	end
end




-- Editing short cut keys...
function NuN_ShortCut(possibleToSave, key)
	if ( ( possibleToSave ) and ( possibleToSave:IsEnabled() ) ) then
		if ( key == "S" ) then
			if ( IsAltKeyDown ) then
				local func = possibleToSave:GetScript("OnClick");
				if ( func ) then
					NuN_SaveReport = true;
					func();
					NuN_SaveReport = nil;
				end
			end
		end
	end
end

function NuN_ShortCut_OnUpdate(eFrame, eBox)
	if ( IsAltKeyDown() ) then
		if ( eFrame.hasFocus ) then
			eFrame.saveReady = eBox:GetCursorPosition();
			eBox:ClearFocus();
		end
		eFrame:EnableKeyboard(true);

	else
		if ( not eFrame.hasFocus ) then
			if ( eFrame.saveReady ) then
				eBox:SetFocus( eFrame.saveReady );
				eFrame.saveReady = nil;
			end
		end
		eFrame:EnableKeyboard(false);
	end
end


-----------------------------------------------------------------------------------------------

-- LOCALISATION RELATED FUNCTIONS

-----------------------------------------------------------------------------------------------


function NuN_LangPatch(langDirection, single)
	local toDeutschAR = {
		4,
		1,
		2,
		3
	}

	local toDeutschHC = {
		1,
		3,
		5,
		6,
		8,
		7,
		2,
		4
	}

	local toDeutschAC = {
		1,
		3,
		5,
		6,
		7,
		8,
		2,
		4
	}

	local toDeutschP = {
		1,
		12,
		13,
		14,
		15,
		16,
		18,
		3,
		4,
		5,
		6,
		8,
		9,
		10,
		11,
		2,
		7,
		17
	}
	local index, value;

	if ( NuNDataPlayers ) then
		if ( langDirection == "->de" ) then
			for index, value in pairs(NuNDataPlayers) do
				if ( NuNDataPlayers[index].faction ) then
					if ( ( not single ) or ( ( single ) and ( index == single ) ) ) then
						if ( NuNDataPlayers[index].faction == "Horde" ) then
							if ( NuNDataPlayers[index].cls ) then
								NuNDataPlayers[index].cls = toDeutschHC[NuNDataPlayers[index].cls];
							end
						else
							if ( NuNDataPlayers[index].race ) then
								NuNDataPlayers[index].race = toDeutschAR[NuNDataPlayers[index].race];
							end
							if ( NuNDataPlayers[index].cls ) then
								NuNDataPlayers[index].cls = toDeutschAC[NuNDataPlayers[index].cls];
							end
						end
						if ( NuNDataPlayers[index].prof1 ) then
							NuNDataPlayers[index].prof1 = toDeutschP[NuNDataPlayers[index].prof1];
						end
						if ( NuNDataPlayers[index].prof2 ) then
							NuNDataPlayers[index].prof2 = toDeutschP[NuNDataPlayers[index].prof2];
						end
					end
				end
			end

		elseif ( langDirection == "->en" ) then
			for index, value in pairs(NuNDataPlayers) do
				if ( NuNDataPlayers[index].faction ) then
					if ( ( not single ) or ( ( single ) and ( index == single ) ) ) then
						if ( NuNDataPlayers[index].faction == "Horde" ) then
							if ( NuNDataPlayers[index].cls ) then
								NuNDataPlayers[index].cls = NuNF.NuNGet_TableID(toDeutschHC, NuNDataPlayers[index].cls);
							end
						else
							if ( NuNDataPlayers[index].race ) then
								NuNDataPlayers[index].race = NuNF.NuNGet_TableID(toDeutschAR, NuNDataPlayers[index].race);
							end
							if ( NuNDataPlayers[index].cls ) then
								NuNDataPlayers[index].cls = NuNF.NuNGet_TableID(toDeutschAC, NuNDataPlayers[index].cls);
							end
						end
						if ( NuNDataPlayers[index].prof1 ) then
							NuNDataPlayers[index].prof1 = NuNF.NuNGet_TableID(toDeutschP, NuNDataPlayers[index].prof1);
						end
						if ( NuNDataPlayers[index].prof2 ) then
							NuNDataPlayers[index].prof2 = NuNF.NuNGet_TableID(toDeutschP, NuNDataPlayers[index].prof2);
						end
					end
				end
			end
		end
	end
end

-----------------------------------------------------------------------------------------------



-----------------------------------------------------------------------------------------------
-- Friend/Ignore Management Hooks and Related Functions
-----------------------------------------------------------------------------------------------
-- Helper function
function NuN_Is_Ignored(aName)
	for i = 1, GetNumIgnores(), 1 do
		iName = GetIgnoreName(i);
		if ( aName == GetIgnoreName(i) ) then
			return true;
		end
	end
	return false;
end
-- Helper function
function NuN_Is_Friendly(aName)
	local iName;
	for i = 1, GetNumFriends(), 1 do
		iName = GetFriendInfo(i);
		if ( iName == aName ) then
			return true;
		end
	end
	return false;
end



function NuNNew_AddFriend(...)
	local name = select(1, ...);

	if ( type(name) == "number" ) then
		name = GetFriendInfo(name);

	elseif ( ( name ) and ( name == "target" ) ) then
		name = UnitName(name);

	elseif ( ( type(name) == "string" ) and ( name == "" ) ) then
		name = UnitName("target");
	end

	if ( not NuN_FriendIgnoreActivity ) then

		if ( name ) then
			NuN_FriendUpdate.func = NuN_AddFriend;
			NuN_FriendUpdate.name = name;
			NuN_FriendUpdate.time = GetTime();
		else
			NuN_FriendUpdate.func = nil;
			NuN_FriendUpdate.name = nil;
			NuN_FriendUpdate.time = 0;
		end
	end

	NuNHooks.NuNOri_AddFriend( ... );
end

function NuN_AddFriend(name)
	if ( ( name ~= nil ) and ( name ~= UNKNOWN ) and ( name ~= UNKNOWNOBJECT ) and ( NuN_Is_Friendly(name) ) ) then -- 5.60
		if ( ( NuNSettings[pKey].autoFI ) and ( not NuNSettings[pKey].autoS ) ) then
			NuN_Message(FRIENDS.." "..name);
		end
		if ( ( NuNSettings[pKey].autoFI ) and ( not NuNDataPlayers[name] ) ) then
			NuNDataPlayers[name] = {};
			NuNDataPlayers[name].type = NuNC.NUN_AUTO_C;
			NuNDataPlayers[name].faction = pFaction;
			NuNDataPlayers[name][txtTxt] = NUN_AUTO_FRIEND..NuNF.NuN_GetDateStamp();
		end
		if ( NuNDataPlayers[name] ) then
			NuNDataPlayers[name].friendLst = true;
		end
		if ( NuNSettings[pKey].gNotFriends[name] ) then
			NuNSettings[pKey].gNotFriends[name] = nil;
		end
		NuN_FriendUpdate.func = nil;
		NuN_FriendUpdate.name = nil;
		NuN_FriendUpdate.time = 0;
	end
	NuNNew_FriendsList_Update();
end



function NuNNew_RemoveFriend(...)
	local name = select(1, ...);
	if ( type(name) == "number" ) then
		name = GetFriendInfo(name);
	end

	if ( not NuN_FriendIgnoreActivity ) then
		if ( name ) then
			NuN_FriendUpdate.func = NuN_RemoveFriend;
			NuN_FriendUpdate.name = name;
			NuN_FriendUpdate.time = GetTime();
		else
			NuN_FriendUpdate.func = nil;
			NuN_FriendUpdate.name = nil;
			NuN_FriendUpdate.time = 0;
		end
	end

	NuNHooks.NuNOri_RemoveFriend( ... );
end

function NuN_RemoveFriend(name)
	if ( ( name ~= nil ) and ( name ~= UNKNOWN ) and ( name ~= UNKNOWNOBJECT ) and ( not NuN_Is_Friendly(name) ) ) then -- 5.60
		if ( ( NuNSettings[pKey].autoFI ) and ( not NuNSettings[pKey].autoS ) ) then
			NuN_Message(DELETE.." "..FRIENDS.." "..name);
		end
		if ( NuNDataPlayers[name] ) then
			if ( ( NuNSettings[pKey].autoD ) and ( NuNDataPlayers[name].type == NuNC.NUN_AUTO_C ) and ( not NuNDataPlayers[name].ignoreLst ) ) then
				NuNDataPlayers[name] = nil;
			else
				NuNDataPlayers[name].friendLst = nil;
			end
		end
		if ( not NuNSettings[pKey].gNotFriends[name] ) then
			NuNSettings[pKey].gNotFriends[name] = true;
		end
		NuN_FriendUpdate.func = nil;
		NuN_FriendUpdate.name = nil;
		NuN_FriendUpdate.time = 0;
	end
	NuNNew_FriendsList_Update();
end



function NuNNew_AddIgnore(...)
	local name = select(1, ...);

	if ( type(name) == "number" ) then
		name = GetIgnoreName(name);
	end

	if ( not NuN_FriendIgnoreActivity ) then
		if ( name ) then
			NuN_IgnoreUpdate.func = NuN_AddIgnore;
			NuN_IgnoreUpdate.name = name;
			NuN_IgnoreUpdate.time = GetTime();
		else
			NuN_IgnoreUpdate.func = nil;
			NuN_IgnoreUpdate.name = nil;
			NuN_IgnoreUpdate.time = 0;
		end
	end

	NuNHooks.NuNOri_AddIgnore( ... );
end

function NuN_AddIgnore(name)
	if ( ( name ~= nil ) and ( name ~= UNKNOWN ) and ( name ~= UNKNOWNOBJECT ) and ( NuN_Is_Ignored(name) ) ) then -- 5.60
		if ( ( NuNSettings[pKey].autoFI ) and ( not NuNSettings[pKey].autoS ) ) then
			NuN_Message(IGNORE.." "..name);
		end
		if ( ( NuNSettings[pKey].autoFI ) and ( not NuNDataPlayers[name] ) ) then
			NuNDataPlayers[name] = {};
			NuNDataPlayers[name].type = NuNC.NUN_AUTO_C;
			NuNDataPlayers[name].faction = pFaction;
			NuNDataPlayers[name][txtTxt] = NUN_AUTO_IGNORE..NuNF.NuN_GetDateStamp();
		end
		if ( NuNDataPlayers[name] ) then
			NuNDataPlayers[name].ignoreLst = true;
		end
		if ( NuNSettings[pKey].gNotIgnores[name] ) then
			NuNSettings[pKey].gNotIgnores[name] = nil;
		end
		NuN_IgnoreUpdate.func = nil;
		NuN_IgnoreUpdate.name = nil;
		NuN_IgnoreUpdate.time = 0;
	end
	NuNNew_IgnoreList_Update();
end



function NuNNew_DelIgnore(...)
	local name = select(1, ...);

	if ( type(name) == "number" ) then
		name = GetIgnoreName(name);

	elseif ( ( name ) and ( name == "target" ) ) then
		name = UnitName(name);

	elseif ( ( type(name) == "string" ) and ( name == "" ) ) then
		name = UnitName("target");
	end

	if ( not NuN_FriendIgnoreActivity ) then
		if ( name ) then
			NuN_IgnoreUpdate.func = NuN_DelIgnore;
			NuN_IgnoreUpdate.name = name;
			NuN_IgnoreUpdate.time = GetTime();
		else
			NuN_IgnoreUpdate.func = nil;
			NuN_IgnoreUpdate.name = nil;
			NuN_IgnoreUpdate.time = 0;
		end
	end

	NuNHooks.NuNOri_DelIgnore( ... );
end

function NuN_DelIgnore(name)
	if ( ( name ~= nil ) and ( name ~= UNKNOWN ) and ( name ~= UNKNOWNOBJECT ) and ( not NuN_Is_Ignored(name) ) ) then -- 5.60
		if ( ( NuNSettings[pKey].autoFI ) and ( not NuNSettings[pKey].autoS ) ) then
			NuN_Message(DELETE.." "..IGNORE.." "..name);
		end
		if ( NuNDataPlayers[name] ) then
			if ( ( NuNSettings[pKey].autoD ) and ( NuNDataPlayers[name].type == NuNC.NUN_AUTO_C ) and ( not NuNDataPlayers[name].friendLst ) ) then
				NuNDataPlayers[name] = nil;
			else
				NuNDataPlayers[name].ignoreLst = nil;
			end
		end
		if ( not NuNSettings[pKey].gNotIgnores[name] ) then
			NuNSettings[pKey].gNotIgnores[name] = true;
		end
		NuN_IgnoreUpdate.func = nil;
		NuN_IgnoreUpdate.name = nil;
		NuN_IgnoreUpdate.time = 0;
	end
	NuNNew_IgnoreList_Update();
end



function NuNNew_AddOrDelIgnore(...)
	local name = select(1, ...);

	if ( type(name) == "number" ) then
		name = GetIgnoreName(name);

	elseif ( ( name ) and ( name == "target" ) ) then
		name = UnitName(name);

	elseif ( ( type(name) == "string" ) and ( name == "" ) ) then
		name = UnitName("target");
	end

	if ( not NuN_FriendIgnoreActivity ) then
		if ( name ) then
			if ( NuN_Is_Ignored(name) ) then
				NuN_IgnoreUpdate.func = NuN_DelIgnore;
				NuN_IgnoreUpdate.name = name;
				NuN_IgnoreUpdate.time = GetTime();
			else
				NuN_IgnoreUpdate.func = NuN_AddIgnore;
				NuN_IgnoreUpdate.name = name;
				NuN_IgnoreUpdate.time = GetTime();
			end
		else
			NuN_IgnoreUpdate.func = nil;
			NuN_IgnoreUpdate.name = nil;
			NuN_IgnoreUpdate.time = 0;
		end
	end

	NuNHooks.NuNOri_AddOrDelIgnore( ... );
end

-- Friend/Ignore Maintenance Hooks and related functions
-----------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------------------------------------------------------------
-- TOOLTIPS
--
-- Retain special Tooltip display function
--

--
-- Replace ALL the following functions with a default Tooltip Handler
--
--function NuN_CustomFontCheckBox_OnEnter()
--function NuN_FFButton_OnEnter()
--function NuN_OptionsButton_OnEnter()
--function NuN_BrowseButton_OnEnter()
--function NuN_ContactButton_OnEnter()
--function NuN_GNoteButton_OnEnter()
--function NuN_ResetButton_OnEnter()
--function NuN_LocButton_OnEnter()
--function NuN_GNoteTitle_OnEnter()
--function NuN_SaveDefCheck_OnEnter()
--function NuN_RestoreDefButton_OnEnter()
--function NuN_TargetButton_OnEnter()
--function NuN_NPCTargetButton_OnEnter()
--function NuN_WhoButton_OnEnter()
--function NuN_UserButtons_OnEnter(owner)
--function NuN_ClearDD_OnEnter()
--function NuNMapNoteButton_OnEnter()
--function NuN_PinnedTT_OnEnter()
--function NuN_OpenChat_OnEnter()
--
-- ??? .fromQuest or NOT .fromQuest, that is the question ??? --
--function NuN_GNoteButtonDelete_OnEnter()
--
--function NuN_TTCheckBox_OnEnter()
--
--function NuN_ChatCheckBox_OnEnter()
--function NuN_ChatFormatCheckBox_OnEnter()
--
--function NuN_Level_CheckBox_OnEnter()
--function NuNGTypeDropDown_OnEnter()
--function NuNScaleFrameButton_OnEnter()
--
--function NuN_PartyDownButton_OnEnter()
--function NuN_bHaveTTCheckBox_OnEnter()
--function NuN_Options_Maintain_OnEnter()
--function NuN_Options_AA_OnEnter()
--function NuN_Options_Verbose_OnEnter()
--
--function NuN_AutoMapCheckBox_OnEnter()
-- 5.60
--function NuN_GuildRefreshCheckBox_OnEnter()
--function NuN_GRVerboseCheckBox_OnEnter()
--function NuN_ModifierMasterCheckBox_OnEnter()
--function NuN_Modifier_OnEnter()
--function NuN_HyperButton_OnEnter()
--
--function NuN_RunButton_OnEnter()
--

function NuN_DisplayTooltip(ttBase)
	if ( NuNSettings[pKey].toolTips ) then
		NuN_State.NuN_Fade = false;
		local x, y = GetCursorPosition();
		if ( x > 500 ) then
			NuN_Tooltip:SetOwner(this, "ANCHOR_TOPRIGHT");
		else
			NuN_Tooltip:SetOwner(this, "ANCHOR_TOPLEFT");
		end
		NuN_Tooltip:ClearLines();
		local ttKey = ttBase .. 1;
		if ( NuNC[ttKey] ) then
			NuN_Tooltip:AddLine(NuNC[ttKey], 1, 0.7, 0);
			for i=2, 9, 1 do
				ttKey = ttBase .. i;
				if ( NuNC[ttKey] ) then
					NuN_Tooltip:AddLine(NuNC[ttKey], 0, 1, 0);			
				else
					break;
				end
			end
			NuN_Tooltip:Show();
		end
	end
end

-- Talents Tooltip
function NuN_TalentsTooltip()
	local talents;

	if ( ( NuNDataPlayers[c_name] ) and ( NuNDataPlayers[c_name].talents ) ) then
		talents = NuNDataPlayers[c_name].talents;
	
	elseif ( ( NuNTalents.player ) and ( NuNTalents.player == c_name ) ) then
		talents = NuNTalents;
		
	else
		return;
	end

	if ( talents.total > 0 ) then
		NuN_State.NuN_Fade = false;
		local x, y = GetCursorPosition();
		if ( x > 500 ) then
			NuN_Tooltip:SetOwner(this, "ANCHOR_TOPRIGHT");
		else
			NuN_Tooltip:SetOwner(this, "ANCHOR_TOPLEFT");
		end
		NuN_Tooltip:ClearLines();

		local details, sep, specifics;

		-- Could set predominent icon here ... tDets.icon
		NuN_Tooltip:AddLine(talents.summary, 0, 0, 1);

		for tab = 1, talents.tabs do
			if ( talents[tab] ) then
				NuN_Tooltip:AddDoubleLine(talents[tab].spec, talents[tab].points, 1, 1, 1, 1, 1, 1);
				NuN_Tooltip:AddTexture(talents[tab].icon);
				specifics = talents[tab].specifics;
				details, sep, col = "", "";
				local i = 1;
				for _, talentDetails in pairs(specifics) do
					if ( ( talentDetails.curR ) and ( talentDetails.curR > 0 ) ) then
						if ( talentDetails.curR == talentDetails.maxR ) then
							col = " |cff00ff00(";
						else
							col = " |cffff0000(";
						end
						details = details..sep.. talentDetails.talentName ..col.. ( talentDetails.curR ) .."/".. ( talentDetails.maxR or "1" ) .. ")" .."|r";
						sep = "\n";
					end
					i = i + 1;
				end
				NuN_Tooltip:AddLine(details);
			end
		end
		NuN_Tooltip:Show();

	end
end

--NuNC.NUN_TT_AUTOP_OFF NuNSettings[pKey].autoP
function NuN_PartyInfo_OnEnter()
	if ( not NuNSettings[pKey].autoP ) then
		NuN_DisplayTooltip("NUN_TT_AUTOP_OFF");
		return;
	end

	local tipArray = {};
	local tipLines = 0;

	for myAlt, record in pairs(NuNDataPlayers[c_name]) do
		if ( ( type(record) == "table" ) and ( record.partied ) and ( record.partiedOn ) ) then
			tipLines = tipLines + 1;
			tipArray[ tipLines ] = {};
			tipArray[ tipLines ].left = myAlt .. " |cffff0000(x" .. record.partied .. ")|r";
			tipArray[ tipLines ].right = record.partiedOn;
		end
	end

	NuN_State.NuN_Fade = false;
	local x, y = GetCursorPosition();
	if ( x > 500 ) then
		NuN_Tooltip:SetOwner(this, "ANCHOR_TOPRIGHT");
	else
		NuN_Tooltip:SetOwner(this, "ANCHOR_TOPLEFT");
	end
	NuN_Tooltip:ClearLines();

	NuN_Tooltip:AddLine(NUN_PARTIED_WITH, 1, 0.7, 0);
	for line, details in ipairs(tipArray) do
		NuN_Tooltip:AddDoubleLine(details.left, details.right, 0, 1, 0, 0.1, 0.1, 0.9);
	end

	NuN_Tooltip:Show();
end

-- TOOLTIPS
--------------------------------------------------------------------------------------------------------------------------------------


--------------------------------------------------------------------------------------------------------------------------------------
-- External functions for other AddOns to fetch / save text in NotesUNeed notes

-- Arguments to pass :
--  - noteType = "General" / "Contact"
--  - noteName = [name of the note EXACTLY]
-- If an error occurs, and the returned text is nil, then the second Return Parameter can be examined to determine the problem
--  1	"Invalid noteType"
--  2	"General Note not Found"
--  3	"Contact Note nof Found"
function NuN_ReturnText(noteType, noteName)
	if ( noteType == "General" ) then
		if ( ( NuNDataRNotes[gLclNote] ) or ( NuNDataANotes[gLclNote] ) ) then
			return NuNF.NuN_GetGText(gLclNote);
		end
		return nil, 2;

	elseif ( noteType == "Contact" ) then
		if ( NuNDataPlayers[noteName] ) then
			return NuNF.NuN_GetCText(noteName);
		end
		return nil, 3;
	end
	
	return nil, 1;
end

-- Arguments to pass :
--  - noteType = "General" / "Contact"
--  - noteName = name of the note EXACTLY
--  - noteText = the text to be inserted
--  - pos = specifies how and where the text is to be inserted
--	-1	:	Replace the entire text
--	#	:	a number specififying the character position after which to insert the text
--			0 = beginning, 1 = after first character, etc.
--			(will append the note if target text is not long enough, but will ALSO return error code 5)
--	<nil>	:	omit to append the text at the end of the note (i.e. default behaviour)
--
-- NOTE : its the responsibility of the caller to ensure that there are appropriate carriage returns, spearaators, etc.
--
-- Function does not return anything when succesful
-- If an error occurs, then the second Return Parameter can be examined to determine the problem
-- 1 "No text passed"
-- 2 "Invalid noteType"
-- 3 "General Note not Found"
-- 4 "Contact Note not Found"
-- 5 "Text appended to note because specified insert position not found"	(*non-critical error)
function NuN_InsertText(noteType, noteName, noteText, pos)
	local errorCode = nil;
	
	if ( ( not noteText ) or ( noteText == "" ) ) then
		return 1;
	end
	if ( ( pos ) and ( type(pos) ~= "number" ) ) then
		pos = nil;
	end
	
	if ( noteType == "General" ) then
		if ( ( NuNDataRNotes[noteName] ) or ( NuNDataANotes[noteName] ) ) then

			local nLvl = "Account";
			if ( NuNDataRNotes[noteName] ) then
				nLvl = "Realm";
			end
			local fetchedText = NuNF.NuN_GetGText(noteName);
			if ( ( not pos ) or ( pos > string.len(fetchedText) ) ) then
				if ( pos > string.len(fetchedText) ) then
					errorCode = 5;
				end
				fetchedText = fetchedText .. noteText;

			elseif ( pos < 0 ) then
				fetchedText = noteText;

			else
				fetchedText = string.sub(fetchedText, 1, pos) .. noteText .. string.sub(fetchedText, pos+1);
			end

			if ( ( NuNGNoteFrame:IsVisible() ) and ( c_note == noteName ) ) then
				NuNGNoteTextBox:SetText( fetchedText );
			end

			local tmpN = c_note;
			local tmpT = g_text;
			c_note = noteName;
			g_text = fetchedText;
			NuNF.NuN_SetCText(nLvl);
			g_text = tmpT;
			c_note = tmpN;
			return errorCode;

		end
		return 3;

	elseif ( noteType == "Contact" ) then
		if ( NuNDataPlayers[noteName] ) then

			local fetchedText = NuNF.NuN_GetCText(noteName);
			if ( ( not pos ) or ( pos > string.len(fetchedText) ) ) then
				if ( ( pos ) and ( pos > string.len(fetchedText) ) ) then
					errorCode = 5;
				end
				fetchedText = fetchedText .. noteText;

			elseif ( ( pos ) and ( pos < 0 ) ) then
				fetchedText = noteText;

			else
				fetchedText = string.sub(fetchedText, 1, pos) .. noteText .. string.sub(fetchedText, pos+1);				
			end
			
			if ( ( NuNFrame:IsVisible() ) and ( c_name == noteName ) ) then
				NuNText:SetText(fetchedText);
			end
			
			local tmpT = c_text;
			c_text = fetchedText;
			NuNF.NuN_SetCText(noteName);
			c_text = tmpT;
			return errorCode;

		end
		return 4;

	end	
	return 2;
end


-- External functions for other AddOns to fetch / save text in NotesUNeed notes
--------------------------------------------------------------------------------------------------------------------------------------


