---------------------------------------
--    NotIt! Priest Edition v1.0    --
--   [ by Pythros of US-Anub'Arak ]  --
---------------------------------------

---------------------------------------
--          [ Color Codes ]          --
---------------------------------------

local CLASS = "|cffFFFFFF";
local CMD = "|cffcc9900";
local VER = "|cff009900";
local TOGGLE0 ="|cffff0000";
local TOGGLE1 ="|cff0000ff";

---------------------------------------
--         [ Search Pattern ]        -- 
---------------------------------------

NotIt_Pattern1 = "[Hh][Ee][Aa][Ll]"
NotIt_Pattern2 = "[Hh][Oo][Ll][Yy]"
NotIt_Pattern3 = "[Rr][Uu][Nn]"
NotIt_Pattern4 = "[Ss][Pp][Ee][Cc]"

---------------------------------------
--            [ On Load ]            --
---------------------------------------

function NotIt_OnLoad()
	this:RegisterEvent("CHAT_MSG_WHISPER");
	SlashCmdList["NOTITCOMMAND"] = NotIt_SlashHandler;
	SLASH_NOTITCOMMAND1 = "/notit";
	
	if (UnitClass("player") == "Priest") then
		NotItSet = "on"
		NotIt_ChatPrint(CMD.."NotIt!"..CLASS.." Priest Edition "..VER.."v1.0"..CMD.." is loaded and "..TOGGLE1.."enabled"..CMD..". For settings, type: /notit show");
	else
		NotItSet = "off"
		NotIt_ChatPrint(CMD.."NotIt!"..CLASS.." Priest Edition "..VER.."v1.0"..CMD.." is loaded but "..TOGGLE0.."disabled"..CMD..". For settings, type: /notit show");
	end
	
	if(NotItPrVar == nil) then
		NotItPrVar = {};
		NotItPrVar["heal"] = "Autoreply: Not a healer.";
		NotItPrVar["holy"] = "Autoreply: Not holy.";
		NotItPrVar["run"] =  "Autoreply: Lowbies 200g for a run through. If that's too much, too bad. For 60+ instances, I will reply if interested.";
	    NotItPrVar["spec"] = "Autoreply: Shadow."
    end
    
end

---------------------------------------
--         [ System Messages ]       --
---------------------------------------

function NotIt_ChatPrint(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg);
end

---------------------------------------
--         [ Slash Commands ]        --
---------------------------------------

function NotIt_SlashHandler(msg)
	if (msg) then
		msg = string.lower(msg);
		if (string.find(msg, "on")) then
			NotItSet = "on"
			NotIt_ChatPrint(CMD.."NotIt! is now "..TOGGLE1.."ON"..CMD..". To switch it off type: /notit off");
		elseif (string.find(msg, "off")) then
			NotItSet = "off"
			NotIt_ChatPrint(CMD.."NotIt! is now "..TOGGLE0.."OFF"..CMD..". To switch it on type: /notit on");
		elseif (string.find(msg, "show")) then
			NotItForm:Show();
            NotItSetSettings();
		else 
			NotIt_ChatPrint(CMD.."NotIt! Commands: /notit [on] [off] [show]")	
		end
	end
end

---------------------------------------
--           [ Is Grouped ]          --
---------------------------------------

local function NameIsGrouped(name)
  local inGroup
  if GetNumPartyMembers()>0 then
    for i=1,4 do
      inGroup = inGroup or (UnitName("party"..i)==name)
    end
  end
  if not inGroup and GetNumRaidMembers()>0 then
    for i=1,40 do
      inGroup = inGroup or (UnitName("raid"..i)==name)
    end
  end
  return inGroup
end

---------------------------------------
--         [ Main Function ]         --
---------------------------------------

function NotIt_OnEvent(event)
	if NotItSet ~= "off" then
	
		if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern1)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItPrVar["heal"], "WHISPER", nil, arg2);
			end
		end
		
		if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern2)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItPrVar["holy"], "WHISPER", nil, arg2);
			end
		end		
		
		if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern3)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItPrVar["run"], "WHISPER", nil, arg2);
			end
		end
        
		if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern4)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItPrVar["spec"], "WHISPER", nil, arg2);
			end
		end
        
	end
end

---------------------------------------
--         [ Save Settings ]         --
---------------------------------------

function NotItSettings()
	
	NotItPrVar["heal"] = NotItFormHealReply:GetText();
	NotItPrVar["holy"] = NotItFormHolyReply:GetText();
	NotItPrVar["run"] = NotItFormRunReply:GetText();
	NotItPrVar["spec"] = NotItFormSpecReply:GetText();
    
	NotItForm:Hide();
end

---------------------------------------
--         [ Load Settings ]         --
---------------------------------------

function NotItSetSettings()

	NotItFormHealReply:SetText(NotItPrVar["heal"]);
	NotItFormHolyReply:SetText(NotItPrVar["holy"]);
	NotItFormRunReply:SetText(NotItPrVar["run"]);
    NotItFormSpecReply:SetText(NotItPrVar["spec"]);
end
