---------------------------------------
--    NotIt! Druid Edition v1.0    --
--   [ by Pythros of US-Anub'Arak ]  --
---------------------------------------

---------------------------------------
--          [ Color Codes ]          --
---------------------------------------

local CLASS = "|cffFF7D0A";
local CMD = "|cffcc9900";
local VER = "|cff009900";
local TOGGLE0 ="|cffff0000";
local TOGGLE1 ="|cff0000ff";

---------------------------------------
--         [ Search Pattern ]        -- 
---------------------------------------

NotIt_Pattern1 = "[Tt][Aa][Nn][Kk]"
NotIt_Pattern2 = "[Bb][Ee][Aa][Rr]"
NotIt_Pattern3 = "[Rr][Uu][Nn]"
NotIt_Pattern4 = "[Ss][Pp][Ee][Cc]"
NotIt_Pattern5 = "[Hh][Ee][Aa][Ll]"
NotIt_Pattern6 = "[Rr][Ee][Ss][Tt][Oo]"
NotIt_Pattern7 = "[Ff][Ee][Rr][Aa][Ll]"

---------------------------------------
--            [ On Load ]            --
---------------------------------------

function NotIt_OnLoad()
	this:RegisterEvent("CHAT_MSG_WHISPER");
	SlashCmdList["NOTITCOMMAND"] = NotIt_SlashHandler;
	SLASH_NOTITCOMMAND1 = "/notit";
	
	if (UnitClass("player") == "Druid") then
		NotItSet = "on"
		NotIt_ChatPrint(CMD.."NotIt!"..CLASS.." Druid Edition "..VER.."v1.0"..CMD.." is loaded and "..TOGGLE1.."enabled"..CMD..". For settings, type: /notit show");
	else
		NotItSet = "off"
		NotIt_ChatPrint(CMD.."NotIt!"..CLASS.." Druid Edition "..VER.."v1.0"..CMD.." is loaded but "..TOGGLE0.."disabled"..CMD..". For settings, type: /notit show");
	end
	
	if(NotItDVar == nil) then
		NotItDVar = {};
		NotItDVar["tank"] = "Autoreply: Not a tank.";
		NotItDVar["bear"] = "Autoreply: Not a bear.";
		NotItDVar["run"] =  "Autoreply: Lowbies 200g for a run through. If that's too much, too bad. For 60+ instances, I will reply if interested.";
	    NotItDVar["spec"] = "Autoreply: <enter spec here>."
        NotItDVar["heal"] = "Autoreply: Not a healer."
        NotItDVar["resto"] = "Autoreply: Not resto."
        NotItDVar["feral"] = "Autoreply: Not feral."
    end
    
end

---------------------------------------
--         [ System Messages ]       --
---------------------------------------

function NotIt_ChatPrint(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg);
end

---------------------------------------
--         [ Slash Commands ]        --
---------------------------------------

function NotIt_SlashHandler(msg)
	if (msg) then
		msg = string.lower(msg);
		if (string.find(msg, "on")) then
			NotItSet = "on"
			NotIt_ChatPrint(CMD.."NotIt! is now "..TOGGLE1.."ON"..CMD..". To switch it off type: /notit off");
		elseif (string.find(msg, "off")) then
			NotItSet = "off"
			NotIt_ChatPrint(CMD.."NotIt! is now "..TOGGLE0.."OFF"..CMD..". To switch it on type: /notit on");
		elseif (string.find(msg, "show")) then
			NotItForm:Show();
            NotItSetSettings();
		else 
			NotIt_ChatPrint(CMD.."NotIt! Commands: /notit [on] [off] [show]")	
		end
	end
end

---------------------------------------
--           [ Is Grouped ]          --
---------------------------------------

local function NameIsGrouped(name)
  local inGroup
  if GetNumPartyMembers()>0 then
    for i=1,4 do
      inGroup = inGroup or (UnitName("party"..i)==name)
    end
  end
  if not inGroup and GetNumRaidMembers()>0 then
    for i=1,40 do
      inGroup = inGroup or (UnitName("raid"..i)==name)
    end
  end
  return inGroup
end

---------------------------------------
--         [ Main Function ]         --
---------------------------------------

function NotIt_OnEvent(event)
	if NotItSet ~= "off" then
	
		if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern1)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItDVar["tank"], "WHISPER", nil, arg2);
			end
		end
		
		if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern2)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItDVar["bear"], "WHISPER", nil, arg2);
			end
		end		
		
		if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern3)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItDVar["run"], "WHISPER", nil, arg2);
			end
		end
        
		if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern4)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItDVar["spec"], "WHISPER", nil, arg2);
			end
		end
        
        if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern5)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItDVar["heal"], "WHISPER", nil, arg2);
			end
		end
        
        if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern6)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItDVar["resto"], "WHISPER", nil, arg2);
			end
		end
		if (event == "CHAT_MSG_WHISPER" and string.find(arg1, NotIt_Pattern7)) then
			if event=="CHAT_MSG_WHISPER" and NameIsGrouped(arg2 or "") then
				--[[ someone in same party/raid as you sent you that whisper ]]
			else
				SendChatMessage(NotItDVar["feral"], "WHISPER", nil, arg2);
			end
		end
        
	end
end

---------------------------------------
--         [ Save Settings ]         --
---------------------------------------

function NotItSettings()
	
	NotItDVar["tank"] = NotItFormTankReply:GetText();
	NotItDVar["bear"] = NotItFormBearReply:GetText();
	NotItDVar["run"] = NotItFormRunReply:GetText();
	NotItDVar["spec"] = NotItFormSpecReply:GetText();
    NotItDVar["heal"] = NotItFormHealReply:GetText();
    NotItDVar["resto"] = NotItFormRestoReply:GetText();
    NotItDVar["feral"] = NotItFormFeralReply:GetText();
	NotItForm:Hide();
end

---------------------------------------
--         [ Load Settings ]         --
---------------------------------------

function NotItSetSettings()

	NotItFormTankReply:SetText(NotItDVar["tank"]);
	NotItFormBearReply:SetText(NotItDVar["bear"]);
	NotItFormRunReply:SetText(NotItDVar["run"]);
    NotItFormSpecReply:SetText(NotItDVar["spec"]);
    NotItFormHealReply:SetText(NotItDVar["heal"]);
    NotItFormRestoReply:SetText(NotItDVar["resto"]);
    NotItFormFeralReply:SetText(NotItDVar["feral"]);
end
