local slashcommand = function()
	local base = UnitDefense("player");
	local targetLevel = UnitLevel("player") + 3;
	local crit = 5 + ((targetLevel - UnitLevel("player")) * 0.2)
	
	local _, class = UnitClass("player");
	if(class == "DRUID") then
		local _, _, _, _, sotf = GetTalentInfo(2, 16); -- Survival of the Fittest
		crit = crit - sotf;
	end
	
	crit = crit - GetCombatRatingBonus(CR_DEFENSE_SKILL)*0.04;
	crit = crit - GetCombatRatingBonus(CR_CRIT_TAKEN_MELEE);

	DEFAULT_CHAT_FRAME:AddMessage("--- Missing ratings to reach crit immunity ---");
	DEFAULT_CHAT_FRAME:AddMessage(format("Your chance to be critically hit: %+.2f%%", crit));
	DEFAULT_CHAT_FRAME:AddMessage(format("Defense Rating: %+.0f", getRatingFromStat(1.5, crit/0.04)));
	DEFAULT_CHAT_FRAME:AddMessage(format("Resilience Rating: %+.0f", getRatingFromStat(25, crit)));
end;

getRatingFromStat = function(base, stat)
	local factor = (base * 82 / (262 - 3 * UnitLevel("player")));
	
	return stat*factor;
end;

getStatFromRating = function(base, rating)
	local factor = (base * 82 / (262 - 3 * UnitLevel("player")));
	
	return rating/factor;
end;

SlashCmdList["NOCRIT"] = slashcommand;
SLASH_NOCRIT1 = "/nocrit";
