
local L = AceLibrary("AceLocale-2.2"):new("NextStep")
local BF = LibStub("LibBabble-Faction-3.0"):GetLookupTable()

local TipHooker = AceLibrary("TipHooker-1.0")

L:RegisterTranslations("enUS", function()
	return {
	["NextStep"] = true,
	["NextStep - add faction item info in your tooltip"] = true,
	["Your %s reputation is too high.(%d rep with %dEA)"] = true,
	["Need %dEA to go your %s reputation is %s(%d rep with %dEA)"] = true,
	["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"] = true,
	["You are already exalted with %s.(%d rep with %dEA)"] = true,
	["%s's Rep %s ◀ %dEA = %dP / %dP X %dEA"] = true,
	["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"] = true,
	["It is unusable. Your %s reputation is %s."] = true,
	["Use until %s reputation is %s(%d rep with %dEA)"] = true,
	["Show Highest Rank"] = true,
	["Show Highest Rank info using item"] = true,
	["Short Text"] = true,
	["Show short text type"] = true,
	["Announce"] = true,
	["Toggle Announce"] = true,

	["Need Cenarion Tactical Badge and Cenarion Combat Badge"] = true,
	["Need Cenarion Logistics Badge and Cenarion Combat Badge"] = true,
	["Need Cenarion Logistics Badge and Cenarion Tactical Badge"] = true,
	["Need Razzashi Coin and Hakkari Coin"] = true,
	["Need Zulian Coin and Hakkari Coin"] = true,
	["Need Zulian Coin and Razzashi Coin"] = true,
	["Need Vilebranch Coin and Witherbark Coin"] = true,
	["Need Gurubashi Coin and Witherbark Coin"] = true,
	["Need Gurubashi Coin and Vilebranch Coin"] = true,
	["Need Skullsplitter Coin and Bloodscalp Coin"] = true,
	["Need Sandfury Coin and Bloodscalp Coin"] = true,
	["Need Sandfury Coin and Skullsplitter Coin"] = true,

	["You receive item:.+item:(%d+):"] = true,
	["%s's Rep %s ◀ %dP = %dEA"] = true,
}
end)

L:RegisterTranslations("koKR", function()
	return {
	["NextStep - add faction item info in your tooltip"] = "NextStep - 툴팁에 평판 아이템 관련 정보를 표시합니다",
	["Your %s reputation is too high.(%d rep with %dEA)"] = "%s에 대하여 더이상 사용할 수 없습니다(%3$d개당 %2$d)",
	["Need %dEA to go your %s reputation is %s(%d rep with %dEA)"] = "%2$s에 대하여 %3$s까지 %1$d개 필요(%5$d개당 %4$d의 평판)",
	["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"] = "%2$s에 대하여 %3$s까지 %1$d개 필요(%5$d개당 %4$d의 평판 X %7$d회)",
	["You are already exalted with %s.(%d rep with %dEA)"] = "%s|1은;는; 이미 확고한 동맹입니다.(%3$d개당 %2$d)",
	["%s's Rep %s ◀ %dEA = %dP / %dP X %dEA"] = "%s %s ◀ %d개 = %d점 / %d점 X %d개",
	["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"] = "%s %s ◀ %d개 = ( %d점 / %d점 X %d개 ) - %d개",

	["It is unusable. Your %s reputation is %s."] = "사용 불가능. 적대진영인 %s|1이;가; %s 평판입니다",
	["Use until %s reputation is %s(%d rep with %dEA)"] = "%1$s진영이 %2$s일 때까지 사용가능(%4$d개당 %3$d)",
	["Show Highest Rank"] = "최대 등급 표시",
	["Show Highest Rank info using item"] = "해당 아이템으로 올릴 수 있는 최고 등급의 평판까지의 필요한 갯수를 표시합니다",
	["Short Text"] = "짧게 표시",
	["Show short text type"] = "정보를 짧게 표시합니다",
	["Announce"] = "알림",
	["Toggle Announce"] = "아이템 습득시 알림 기능을 토글합니다",

	["Need Cenarion Tactical Badge and Cenarion Combat Badge"] = "세나리온 전술 휘장, 세나리온 전투 휘장 필요",
	["Need Cenarion Logistics Badge and Cenarion Combat Badge"] = "세나리온 병참 휘장, 세나리온 전투 휘장 필요",
	["Need Cenarion Logistics Badge and Cenarion Tactical Badge"] = "세나리온 전술 휘장, 세나리온 병참 휘장 필요",
	["Need Razzashi Coin and Hakkari Coin"] = "래즈자쉬부족 주화, 학카리부족 주화 필요",
	["Need Zulian Coin and Hakkari Coin"] = "줄리안부족 주화, 학카리부족 주화 필요",
	["Need Zulian Coin and Razzashi Coin"] = "줄리안부족 주화, 래즈자쉬부족 주화 필요",
	["Need Vilebranch Coin and Witherbark Coin"] = "썩은가지부족 주화, 마른나무껍질부족 주화 필요",
	["Need Gurubashi Coin and Witherbark Coin"] = "구루바시부족 주화, 마른나무껍질부족 주화 필요",
	["Need Gurubashi Coin and Vilebranch Coin"] = "구루바시부족 주화, 썩은가지부족 주화 필요",
	["Need Skullsplitter Coin and Bloodscalp Coin"] = "백골가루부족 주화, 붉은머리부족 주화 필요",
	["Need Sandfury Coin and Bloodscalp Coin"] = "성난모래부족 주화, 붉은머리부족 주화 필요",
	["Need Sandfury Coin and Skullsplitter Coin"] = "성난모래부족 주화, 백골가루부족 주화 필요",
	["You receive item:.+item:(%d+):"] = "^아이템을 획득했습니다: .+item:(%d+):",
	["%s's Rep %s ◀ %dP = %dEA"] = "%s 평판 %s ◀ %d점 = %d개",
}
end)

L:RegisterTranslations("zhCN", function()
	return {
	["NextStep"] = "最长的一码",
	["NextStep - add faction item info in your tooltip"] = "NextStep - 在物品提示信息框里添加声望信息",
	["Your %s reputation is too high.(%d rep with %dEA)"] = "你的%s声望过高 (每%3$d个换%2$d声望)",
	["Need %dEA to go your %s reputation is %s(%d rep with %dEA)"] = "还需要%d个 你的%s声望目前为%s (每%5$d个换%4$d声望)",
	["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"] = "还需要%d个 你的%s声望目前为%s (每%5$d X %6$d个换%4$d声望)",
	["You are already exalted with %s.(%d rep with %dEA)"] = "你的%s声望已经崇拜了 (每%3$d个换%2$d声望)",
	["%s's Rep %s ◀ %dEA = %dP / %dP X %dEA"] = "%s 可到%s %4$d声望 / 每%6$d个换%5$d声望 = 还需%3$d个",
	["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"] = "%s 可到%s ( %4$d声望 / 每%6$d个换%5$d声望 ) - 现有%7$d个 = 还需%3$d个",
	["It is unusable. Your %s reputation is %s."] = "当前无法上交，你的%s声望为%s。",
	["Use until %s reputation is %s(%d rep with %dEA)"] = "在%s声望为%s前可以上交 (每%4$d个换%3$d声望)",
	["Show Highest Rank"] = "显示最高级别",
	["Show Highest Rank info using item"] = "显示使用物品的最高级别信息",
	["Short Text"] = "简短文本",
	["Show short text type"] = "显示简短文本类型",
	["Announce"] = "通告",
	["Toggle Announce"] = "通告开关",

	["Need Cenarion Tactical Badge and Cenarion Combat Badge"] = "需要塞纳里奥战术徽章以及塞纳里奥作战徽章",
	["Need Cenarion Logistics Badge and Cenarion Combat Badge"] = "需要塞纳里奥后勤徽章以及塞纳里奥作战徽章",
	["Need Cenarion Logistics Badge and Cenarion Tactical Badge"] = "需要塞纳里奥后勤徽章以及纳里奥战术徽章",
	["Need Razzashi Coin and Hakkari Coin"] = "需要拉扎什硬币以及哈卡莱硬币",
	["Need Zulian Coin and Hakkari Coin"] = "需要祖利安硬币以及哈卡莱硬币",
	["Need Zulian Coin and Razzashi Coin"] = "需要祖利安硬币以及拉扎什硬币",
	["Need Vilebranch Coin and Witherbark Coin"] = "需要邪枝硬币以及枯木硬币",
	["Need Gurubashi Coin and Witherbark Coin"] = "需要古拉巴什硬币以及枯木硬币",
	["Need Gurubashi Coin and Vilebranch Coin"] = "需要古拉巴什硬币以及邪枝硬币",
	["Need Skullsplitter Coin and Bloodscalp Coin"] = "需要碎颅硬币以及血顶硬币",
	["Need Sandfury Coin and Bloodscalp Coin"] = "需要沙怒硬币以及血顶硬币",
	["Need Sandfury Coin and Skullsplitter Coin"] = "需要沙怒硬币以及碎颅硬币",

	["You receive item:.+item:(%d+):"] = "你获得了物品：.+item:(%d+):",
	["%s's Rep %s ◀ %dP = %dEA"] = "%s 可到%s 每%4$d个换%3$d声望",
}
end)
L:RegisterTranslations("zhTW", function()
	return {
	["NextStep"] = "最長的一碼",
	["NextStep - add faction item info in your tooltip"] = "NextStep - 在物品提示資訊框裡添加聲望資訊",
	["Your %s reputation is too high.(%d rep with %dEA)"] = "你的%s聲望過高 (每%3$d個換%2$d聲望)",
	["Need %dEA to go your %s reputation is %s(%d rep with %dEA)"] = "還需要%d個 你的%s聲望目前為%s (每%5$d個換%4$d聲望)",
	["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"] = "還需要%d個 你的%s聲望目前為%s (每%5$d X %6$d個換%4$d聲望)",
	["You are already exalted with %s.(%d rep with %dEA)"] = "你的%s聲望已經崇拜了 (每%3$d個換%2$d聲望)",
	["%s's Rep %s ◀ %dEA = %dP / %dP X %dEA"] = "%s 可到%s %4$d聲望 / 每%6$d個換%5$d聲望 = 還需%3$d個",
	["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"] = "%s 可到%s ( %4$d聲望 / 每%6$d個換%5$d聲望 ) - 現有%7$d個 = 還需%3$d個",
	["It is unusable. Your %s reputation is %s."] = "當前無法上交，你的%s聲望為%s。",
	["Use until %s reputation is %s(%d rep with %dEA)"] = "在%s聲望為%s前可以上交 (每%4$d個換%3$d聲望)",
	["Show Highest Rank"] = "顯示最高級別",
	["Show Highest Rank info using item"] = "顯示使用物品的最高級別資訊",
	["Short Text"] = "簡短文本",
	["Show short text type"] = "顯示簡短文本類型",
	["Announce"] = "通告",
	["Toggle Announce"] = "通告開關",

	["Need Cenarion Tactical Badge and Cenarion Combat Badge"] = "需要塞納裡奧戰術徽章以及塞納裡奧作戰徽章",
	["Need Cenarion Logistics Badge and Cenarion Combat Badge"] = "需要塞納裡奧後勤徽章以及塞納裡奧作戰徽章",
	["Need Cenarion Logistics Badge and Cenarion Tactical Badge"] = "需要塞納裡奧後勤徽章以及納裡奧戰術徽章",
	["Need Razzashi Coin and Hakkari Coin"] = "需要拉札希硬幣以及哈卡萊硬幣",
	["Need Zulian Coin and Hakkari Coin"] = "需要祖利安硬幣以及哈卡萊硬幣",
	["Need Zulian Coin and Razzashi Coin"] = "需要祖利安硬幣以及拉札希硬幣",
	["Need Vilebranch Coin and Witherbark Coin"] = "需要邪枝硬幣以及枯木硬幣",
	["Need Gurubashi Coin and Witherbark Coin"] = "需要古拉巴什硬幣以及枯木硬幣",
	["Need Gurubashi Coin and Vilebranch Coin"] = "需要古拉巴什硬幣以及邪枝硬幣",
	["Need Skullsplitter Coin and Bloodscalp Coin"] = "需要劈顱硬幣以及血頂硬幣",
	["Need Sandfury Coin and Bloodscalp Coin"] = "需要沙怒硬幣以及血頂硬幣",
	["Need Sandfury Coin and Skullsplitter Coin"] = "需要沙怒硬幣以及劈顱硬幣",

	["You receive item:.+item:(%d+):"] = "你獲得了物品：.+item:(%d+):",
	["%s's Rep %s ◀ %dP = %dEA"] = "%s 可到%s 每%4$d個換%3$d聲望",
}
end)

local NS_Point = {
	[1] = -42000,
	[2] = -6000,
	[3] = -3000,
	[4] = 0,
	[5] = 3000,
	[6] = 9000,
	[7] = 21000,
	[8] = 42000,
}

local ItemInfo = {
	["25433"] = {
		{
			name = UnitFactionGroup("player") == "Horde" and BF["The Mag'har"] or BF["Kurenai"],
			num = 10,
			rep = 500,
			high = 8,
		},
		{
			name = BF["The Consortium"],
			num = 10,
			rep = 250,
			high = 8,
		},
	},
	["29209"] = {
		{
			name = BF["The Consortium"],
			num = 10,
			rep = 250,
			high = 8,
		},
	},
	["25416"] = {
		{
			name = BF["The Consortium"],
			num = 10,
			rep = 250,
			high = 5,
		},
	},
	["25463"] = {
		{
			name = BF["The Consortium"],
			num = 3,
			rep = 250,
			high = 5,
		},
	},
	["31957"] = {
		{
			name = BF["The Consortium"],
			num = 1,
			rep = 250,
			high = 8,
		},
	},
	["29739"] = {
		{
			name = BF["The Scryers"],
			num = 1,
			rep = 350,
			high = 8,
			opp = BF["The Aldor"].."|4",
		},
	},
	["29426"] = {
		{
			name = BF["The Scryers"],
			num = 1,
			rep = 25,
			high = 6,
			opp = BF["The Aldor"].."|4",
		},
	},
	["30810"] = {
		{
			name = BF["The Scryers"],
			num = 1,
			rep = 25,
			high = 8,
			opp = BF["The Aldor"].."|4",
		},
	},
	["25744"] = {
		{
			name = BF["The Scryers"],
			num = 8,
			rep = 25,
			high = 4,
			opp = BF["The Aldor"].."|9",
		},
	},
	["29740"] = {
		{
			name = BF["The Aldor"],
			num = 1,
			rep = 350,
			high = 8,
			opp = BF["The Scryers"].."|4",
		},
	},
	["29425"] = {
		{
			name = BF["The Aldor"],
			num = 1,
			rep = 25,
			high = 6,
			opp = BF["The Scryers"].."|4",
		},
	},
	["30809"] = {
		{
			name = BF["The Aldor"],
			num = 1,
			rep = 25,
			high = 8,
			opp = BF["The Scryers"].."|4",
		},
	},
	["25802"] = {
		{
			name = BF["The Aldor"],
			num = 8,
			rep = 25,
			high = 4,
			opp = BF["The Scryers"].."|9",
		},
	},
	["25719"] = {
		{
			name = BF["Lower City"],
			num = 30,
			rep = 250,
			high = 6,
		},
	},
	["24401"] = {
		{
			name = BF["Cenarion Expedition"],
			num = 10,
			rep = 250,
			high = 6,
		},
	},
	["24407"] = {
		{
			name = BF["Cenarion Expedition"],
			num = 1,
			rep = 500,
			high = 8,
		},
	},
	["24368"] = {
		{
			name = BF["Cenarion Expedition"],
			num = 1,
			rep = 75,
			high = 8,
		},
	},
	["24449"] = {
		{
			name = BF["Sporeggar"],
			num = 10,
			rep = 750,
			high = 8,
		},
	},
	["24291"] = {
		{
			name = BF["Sporeggar"],
			num = 6,
			rep = 750,
			high = 5,
		},
	},
	["24290"] = {
		{
			name = BF["Sporeggar"],
			num = 10,
			rep = 750,
			high = 5,
		},
	},
	["24246"] = {
		{
			name = BF["Sporeggar"],
			num = 5,
			rep = 750,
			high = 8,
		},
	},
	["24245"] = {
		{
			name = BF["Sporeggar"],
			num = 10,
			rep = 750,
			high = 4,
		},
	},
	["20404"] = {
		{
			name = BF["Cenarion Circle"],
			num = 10,
			rep = 500,
			high = 8,
		},
	},
	["20513"] = {
		{
			name = BF["Cenarion Circle"],
			num = 3,
			rep = 150,
			high = 8,
		},
	},
	["20514"] = {
		{
			name = BF["Cenarion Circle"],
			num = 3,
			rep = 100,
			high = 8,
		},
	},
	["20515"] = {
		{
			name = BF["Cenarion Circle"],
			num = 3,
			rep = 150,
			high = 8,
		},
	},
	["20800"] = {
		{
			name = BF["Cenarion Circle"],
			num = 1,
			rep = 500,
			high = 8,
			note = L["Need Cenarion Tactical Badge and Cenarion Combat Badge"],
		},
	},
	["20801"] = {
		{
			name = BF["Cenarion Circle"],
			num = 1,
			rep = 500,
			high = 8,
			note = L["Need Cenarion Logistics Badge and Cenarion Combat Badge"],
		},
	},
	["20802"] = {
		{
			name = BF["Cenarion Circle"],
			num = 1,
			rep = 500,
			high = 8,
			note = L["Need Cenarion Logistics Badge and Cenarion Tactical Badge"],
		},
	},
	["12840"] = {
		{
			name = BF["Argent Dawn"],
			num = 20,
			rep = 50,
			high = 8,
		},
	},
	["12841"] = {
		{
			name = BF["Argent Dawn"],
			num = 10,
			rep = 50,
			high = 8,
		},
	},
	["12843"] = {
		{
			name = BF["Argent Dawn"],
			num = 1,
			rep = 50,
			high = 8,
		},
	},
	["12844"] = {
		{
			name = BF["Argent Dawn"],
			num = 1,
			rep = 100,
			high = 8,
		},
	},
		["22528"] = {
		{
			name = BF["Argent Dawn"],
			num = 30,
			rep = 20,
			high = 8,
		},
	},
		["22529"] = {
		{
			name = BF["Argent Dawn"],
			num = 30,
			rep = 20,
			high = 8,
		},
	},
		["13920"] = {
		{
			name = BF["Argent Dawn"],
			num = 1,
			rep = 150,
			high = 8,
		},
	},
		["22525"] = {
		{
			name = BF["Argent Dawn"],
			num = 30,
			rep = 20,
			high = 8,
		},
	},
		["22526"] = {
		{
			name = BF["Argent Dawn"],
			num = 30,
			rep = 20,
			high = 8,
		},
	},
		["22527"] = {
		{
			name = BF["Argent Dawn"],
			num = 30,
			rep = 20,
			high = 8,
		},
	},
		["22528"] = {
		{
			name = BF["Argent Dawn"],
			num = 30,
			rep = 20,
			high = 8,
		},
	},
	["21229"] = {
		{
			name = BF["Brood of Nozdormu"],
			num = 1,
			rep = 1000,
			high = 8,
		},
		{
			name = BF["Cenarion Circle"],
			num = 1,
			rep = 200,
			high = 8,
		},
	},
	["21230"] = {
		{
			name = BF["Brood of Nozdormu"],
			num = 1,
			rep = 1000,
			high = 8,
		},
	},
	["20384"] = {
		{
			name = BF["Brood of Nozdormu"],
			num = 200,
			rep = 200,
			high = 4,
		},
	},
	["11370"] = {
		{
			name = BF["Thorium Brotherhood"],
			num = 10,
			rep = 75,
			high = 8,
		},
	},
	["17011"] = {
		{
			name = BF["Thorium Brotherhood"],
			num = 1,
			rep = 500,
			high = 8,
		},
	},
	["17010"] = {
		{
			name = BF["Thorium Brotherhood"],
			num = 1,
			rep = 500,
			high = 8,
		},
	},
	["17012"] = {
		{
			name = BF["Thorium Brotherhood"],
			num = 2,
			rep = 150,
			high = 8,
		},
	},
	["11382"] = {
		{
			name = BF["Thorium Brotherhood"],
			num = 1,
			rep = 500,
			high = 8,
		},
	},
	["18945"] = {
		{
			name = BF["Thorium Brotherhood"],
			num = 4,
			rep = 25,
			high = 6,
		},
	},
	["18944"] = {
		{
			name = BF["Thorium Brotherhood"],
			num = 2,
			rep = 25,
			high = 5,
		},
	},
	["19714"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 75,
			high = 8,
		},
	},
	["19712"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 75,
			high = 8,
		},
	},
	["19711"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 75,
			high = 8,
		},
	},
	["19710"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 75,
			high = 8,
		},
	},
	["19708"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 75,
			high = 8,
		},
	},
	["19707"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 75,
			high = 8,
		},
	},
	["19715"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 75,
			high = 8,
		},
	},
	["19709"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 75,
			high = 8,
		},
	},
	["19858"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 50,
			high = 8,
		},
	},
	["19698"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 25,
			high = 8,
			note = L["Need Razzashi Coin and Hakkari Coin"],

		},
	},
	["19699"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 25,
			high = 8,
			note = L["Need Zulian Coin and Hakkari Coin"],

		},
	},
	["19700"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 25,
			high = 8,
			note = L["Need Zulian Coin and Razzashi Coin"],

		},
	},
	["19701"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 25,
			high = 8,
			note = L["Need Vilebranch Coin and Witherbark Coin"],

		},
	},
	["19702"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 25,
			high = 8,
			note = L["Need Gurubashi Coin and Witherbark Coin"],

		},
	},
	["19703"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 25,
			high = 8,
			note = L["Need Gurubashi Coin and Vilebranch Coin"],

		},
	},
	["19704"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 25,
			high = 8,
			note = L["Need Skullsplitter Coin and Bloodscalp Coin"],
		},
	},
	["19705"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 25,
			high = 8,
			note = L["Need Sandfury Coin and Bloodscalp Coin"],
		},
	},
	["19706"] = {
		{
			name = BF["Zandalar Tribe"],
			num = 1,
			rep = 25,
			high = 8,
			note = L["Need Sandfury Coin and Skullsplitter Coin"],
		},
	},
	["21383"] = {
		{
			name = BF["Timbermaw Hold"],
			num = 5,
			rep = 150,
			high = 8,
		},
	},
	["21377"] = {
		{
			name = BF["Timbermaw Hold"],
			num = 5,
			rep = 150,
			high = 8,
		},
	},
	["32427"] = {
		{
			name = BF["Netherwing"],
			num = 40,
			rep = 250,
			high = 8,
		},
	},
	["32468"] = {
		{
			name = BF["Netherwing"],
			num = 40,
			rep = 250,
			high = 8,
		},
	},
	["32468"] = {
		{
			name = BF["Netherwing"],
			num = 40,
			rep = 250,
			high = 8,
		},
	},
	["32464"] = {
		{
			name = BF["Netherwing"],
			num = 40,
			rep = 250,
			high = 8,
		},
	},
	["32733"] = {
		{
			name = BF["Ogri'la"],
			num = 1,
			rep = 500,
			high = 8,
		},
	},
	["32697"] = {
		{
			name = BF["Ogri'la"],
			num = 1,
			rep = 500,
			high = 8,
		},
		{
			name = BF["Sha'tari Skyguard"],
			num = 1,
			rep = 500,
			high = 8,
		},
	},
	["32388"] = {
		{
			name = BF["Sha'tari Skyguard"],
			num = 6,
			rep = 75,
			high = 8,
		},
	},
	["11407"] = {
		{
			name = BF["Darkmoon Faire"],
			num = 5,
			rep = 250,
			high = 4,
		},
	},
	["5117"] = {
		{
			name = BF["Darkmoon Faire"],
			num = 5,
			rep = 250,
			high = 4,
		},
	},
	["11404"] = {
		{
			name = BF["Darkmoon Faire"],
			num = 5,
			rep = 250,
			high = 6,
		},
	},
	["19933"] = {
		{
			name = BF["Darkmoon Faire"],
			num = 5,
			rep = 250,
			high = 6,
		},
	},
}


NextStep = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")

NextStep.value = 0

NextStep.options = {
	name = L["NextStep"],
	icon = [[Interface\MINIMAP\Tracking\Reagents]],
	desc = L["NextStep - add faction item info in your tooltip"],
	type = "group",
	args = {
		highest = {
			name = L["Show Highest Rank"],
			type = "toggle",
			desc = L["Show Highest Rank info using item"],
			get = function() return NextStep.db.account.Highest end,
			set = function(v) NextStep.db.account.Highest = v end,
		},
		shorttext = {
			name = L["Short Text"],
			type = "toggle",
			desc = L["Show short text type"],
			get = function() return NextStep.db.account.Shorttext end,
			set = function(v) NextStep.db.account.Shorttext = v end,
		},
		shorttext = {
			name = L["Announce"],
			type = "toggle",
			desc = L["Toggle Announce"],
			get = function()
				return NextStep.db.account.Announce
			end,
			set = function(v)
				NextStep.db.account.Announce = v
				if NextStep.db.account.Announce then
					NextStep:RegisterEvent("CHAT_MSG_LOOT")
				else
					NextStep:UnregisterEvent("CHAT_MSG_LOOT")
				end
			end,
		},
	},
}

NextStep:RegisterChatCommand({"/nextstep", "/ns"}, NextStep.options)

NextStep:RegisterDB("NextStepDB")
NextStep:RegisterDefaults("account", {
	Highest = true,
	Shorttext = true,
	Announce = true,
})

--[[--------------------------------------------------------------------------------
	OnEnable, enable the mod
-----------------------------------------------------------------------------------]]
function NextStep:OnEnable()
	if self.db.account.Announce then
		self:RegisterEvent("CHAT_MSG_LOOT")
	end

	TipHooker:Hook(self.ProcessTooltip, "item")
end

--[[--------------------------------------------------------------------------------
	OnDisable, disable the mod
-----------------------------------------------------------------------------------]]
function NextStep:OnDisable()
	TipHooker:Unhook(self.ProcessTooltip, "item")
end



-- 알림 기능
function NextStep:CHAT_MSG_LOOT(msg)
	local _,_,id = strfind(msg, L["You receive item:.+item:(%d+):"])
	local countplus = 1
	if id and strfind(msg, "x(%d+)$") then
		_,_,countplus = strfind(msg, "x(%d+)$")
	end
	local value = ItemInfo[id]

	if value ~= nil then
		local i = 1;
		while value[i] do
			local info = value[i]
			if self:GetFactionStanding(info.name) then
				local standing, current = self:GetFactionStanding(info.name)
				if info.opp then
					local oppose, opposecheck, opposestanding
					_, _, oppose, opposecheck = string.find(info.opp, "([^\|]+)|(%d+)")
					opposestanding = self:GetFactionStanding(oppose)
					if opposestanding and tonumber(opposecheck) < tonumber(opposestanding) then

					elseif standing < info.high and standing < 8 then
						local TotalCount = self:GetCount(id)
						if self.db.account.Highest then
							local point = NS_Point[info.high] - current
							local count = point / info.rep
							if ( math.floor(count) < count) then
								count = math.floor(count) + 1
							end
							if self.db.account.Shorttext then
								DEFAULT_CHAT_FRAME:AddMessage("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..info.high), count*info.num - TotalCount, point, info.rep, info.num, TotalCount), 1.0, 1.0, 0, 1)
							else
								DEFAULT_CHAT_FRAME:AddMessage("|CFF49A5D3NS:|r"..string.format(L["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"], Hcount*info.num - TotalCount, info.name, getglobal("FACTION_STANDING_LABEL"..info.high), info.rep, info.num, count), 1.0, 1.0, 0, 1)
							end
						else
							local point = NS_Point[standing + 1] - current
							local count = point / info.rep
							if ( math.floor(count) < count) then
								count = math.floor(count) + 1
							end
							if self.db.account.Shorttext then
								DEFAULT_CHAT_FRAME:AddMessage("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..(standing+1)), count*info.num - TotalCount, point, info.rep, info.num, TotalCount), 1.0, 1.0, 0, 1)
							else
								DEFAULT_CHAT_FRAME:AddMessage("|CFF49A5D3NS:|r"..string.format(L["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"], Hcount*info.num - TotalCount, info.name, getglobal("FACTION_STANDING_LABEL"..(standing+1)), info.rep, info.num, count), 1.0, 1.0, 0, 1)
							end
						end
					end
				elseif standing < info.high and standing < 8 then
					local TotalCount = self:GetCount(id) + countplus
					if self.db.account.Highest then
						local point = NS_Point[info.high] - current
						local count = point / info.rep
						if ( math.floor(count) < count) then
							count = math.floor(count) + 1
						end
						if self.db.account.Shorttext then
							DEFAULT_CHAT_FRAME:AddMessage("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..info.high), count*info.num - TotalCount, point, info.rep, info.num, TotalCount), 1.0, 1.0, 0, 1)
						else
							DEFAULT_CHAT_FRAME:AddMessage("|CFF49A5D3NS:|r"..string.format(L["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"], Hcount*info.num - TotalCount, info.name, getglobal("FACTION_STANDING_LABEL"..info.high), info.rep, info.num, count), 1.0, 1.0, 0, 1)
						end
					else
						local point = NS_Point[standing + 1] - current
						local count = point / info.rep
						if ( math.floor(count) < count) then
							count = math.floor(count) + 1
						end
						if self.db.account.Shorttext then
							DEFAULT_CHAT_FRAME:AddMessage("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..(standing+1)), count*info.num - TotalCount, point, info.rep, info.num, TotalCount), 1.0, 1.0, 0, 1)
						else
							DEFAULT_CHAT_FRAME:AddMessage("|CFF49A5D3NS:|r"..string.format(L["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"], Hcount*info.num - TotalCount, info.name, getglobal("FACTION_STANDING_LABEL"..(standing+1)), info.rep, info.num, count), 1.0, 1.0, 0, 1)
						end
					end
				end
			end
			i = i + 1
		end
	end

end

--[[--------------------------------------------------------------------------------
	Utility functions
-----------------------------------------------------------------------------------]]
function NextStep.ProcessTooltip(tooltip, name, link)
	local _, _, itemid = strfind(link, "item:(%d+):")
	if itemid then
		itemid = tonumber(itemid)
		NextStep:AddCountToTooltip(itemid, tooltip)
	end
	tooltip:Show()
end


function NextStep:GetCount(id)
	local TotalCount = 0;
	local text = "item:"..id..":";

	for bag = 0,4 do
		local slots = GetContainerNumSlots(bag);
		if (slots) then
			for slot = 1,slots do
				local itemLink = GetContainerItemLink(bag, slot);
				if (itemLink) then
					if ( string.find(itemLink, text) ) then
						local _, Count = GetContainerItemInfo(bag,slot);
						TotalCount = TotalCount + Count

					end
				end
			end
		end
	end

	return TotalCount;
end

function NextStep:GetFactionStanding(n)
	local name, standing;

	for i=1, GetNumFactions(), 1 do
		name, _, standing, _, _, current  = GetFactionInfo(i);
		if name == n then
			return standing, current
		end
	end
end

function NextStep:AddCountToTooltip(id, tooltip)
	if ItemInfo then
		local value
		for k, v in pairs(ItemInfo) do
			if tonumber(k) == tonumber(id) then
				value = v
			end
		end

		if value ~= nil then
			local i = 1;
			while value[i] do
				local info = value[i]
				if self:GetFactionStanding(info.name) and self:GetFactionStanding(info.name) ~= nil then
					local standing, current = self:GetFactionStanding(info.name)
					if info.opp then
						local oppose, opposecheck, opposestanding
						_, _, oppose, opposecheck = string.find(info.opp, "([^\|]+)|(%d+)")
						opposestanding = self:GetFactionStanding(oppose)
						if opposestanding and tonumber(opposecheck) < tonumber(opposestanding) then
							if self.db.account.Shorttext then
								tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dP = %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..info.high), info.rep, info.num), 1.0, 1.0, 0, 0)
							else
								tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["Use until %s reputation is %s(%d rep with %dEA)"], info.name, getglobal("FACTION_STANDING_LABEL"..tonumber(info.high)), info.rep, info.num), 1.0, 1.0, 0)
							end
						elseif standing < info.high and standing < 8 then
							local TotalCount = self:GetCount(id)
							if self.db.account.Highest then
								local point = NS_Point[info.high] - current
								local count = point / info.rep
								if ( math.floor(count) < count) then
									count = math.floor(count) + 1
								end
								if self.db.account.Shorttext then
									tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..info.high), count*info.num - TotalCount, point, info.rep, info.num, TotalCount), 1.0, 1.0, 0, 1)
								else
									tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"], Hcount*info.num - TotalCount, info.name, getglobal("FACTION_STANDING_LABEL"..info.high), info.rep, info.num, count), 1.0, 1.0, 0, 1)
								end
							else
								local point = NS_Point[standing + 1] - current
								local count = point / info.rep
								if ( math.floor(count) < count) then
									count = math.floor(count) + 1
								end
								if self.db.account.Shorttext then
									tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..(standing+1)), count*info.num - TotalCount, point, info.rep, info.num, TotalCount), 1.0, 1.0, 0, 1)
								else
									tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"], Hcount*info.num - TotalCount, info.name, getglobal("FACTION_STANDING_LABEL"..(standing+1)), info.rep, info.num, count), 1.0, 1.0, 0, 1)
								end
							end
						else
							if opposestanding ~= nil then
								tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["It is unusable. Your %s reputation is %s."], oppose, getglobal("FACTION_STANDING_LABEL"..opposestanding)), 1.0, 1.0, 0, 0)
							end
							if self.db.account.Shorttext then
								tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dP = %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..info.high), info.rep, info.num), 1.0, 1.0, 0, 0)
							else
								tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["Use until %s reputation is %s(%d rep with %dEA)"], info.name, getglobal("FACTION_STANDING_LABEL"..tonumber(info.high)), info.rep, info.num), 1.0, 1.0, 0)
							end
						end
					elseif standing < info.high and standing < 8 then
						local TotalCount = self:GetCount(id)
						if self.db.account.Highest then
							local point = NS_Point[info.high] - current
							local count = point / info.rep
							if ( math.floor(count) < count) then
								count = math.floor(count) + 1
							end
							if self.db.account.Shorttext then
								tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..info.high), count*info.num - TotalCount, point, info.rep, info.num, TotalCount), 1.0, 1.0, 0, 1)
							else
								tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"], Hcount*info.num - TotalCount, info.name, getglobal("FACTION_STANDING_LABEL"..info.high), info.rep, info.num, count), 1.0, 1.0, 0, 1)
							end
						else
							local point = NS_Point[standing + 1] - current
							local count = point / info.rep
							if ( math.floor(count) < count) then
								count = math.floor(count) + 1
							end
							if self.db.account.Shorttext then
								tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dEA = ( %dP / %dP X %dEA ) - %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..(standing+1)), count*info.num - TotalCount, point, info.rep, info.num, TotalCount), 1.0, 1.0, 0, 1)
							else
								tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["Need %dEA to go your %s reputation is %s(%d rep with %dEA X %d)"], Hcount*info.num - TotalCount, info.name, getglobal("FACTION_STANDING_LABEL"..(standing+1)), info.rep, info.num, count), 1.0, 1.0, 0, 1)
							end
						end
					else
						if self.db.account.Shorttext then
							tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dP = %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..info.high), info.rep, info.num), 1.0, 1.0, 0, 0)
						else
							tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["Use until %s reputation is %s(%d rep with %dEA)"], info.name, getglobal("FACTION_STANDING_LABEL"..tonumber(info.high)), info.rep, info.num), 1.0, 1.0, 0)
						end
					end
				else
					if self.db.account.Shorttext then
						tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["%s's Rep %s ◀ %dP = %dEA"], info.name, getglobal("FACTION_STANDING_LABEL"..info.high), info.rep, info.num), 1.0, 1.0, 0, 0)
					else
						tooltip:AddLine("|CFF49A5D3NS:|r"..string.format(L["Use until %s reputation is %s(%d rep with %dEA)"], info.name, getglobal("FACTION_STANDING_LABEL"..tonumber(info.high)), info.rep, info.num), 1.0, 1.0, 0, 0)
					end
				end
				if info.note and info.note ~= nil then
					tooltip:AddLine("|CFF49A5D3NS:|r"..info.note, 1.0, 1.0, 0, 0)
				end
				i = i + 1
			end
		end
	end
end

