-- --------------------------------------
-- TellMeWhen
-- by Nephthys <Drunken Monkeys> of Hyjal
-- --------------------------------------



function NeedToKnow.SlashCommand(cmd)
	if ( cmd == NEEDTOKNOW.CMD_RESET ) then
		NeedToKnow.Reset();
	else 
		NeedToKnow.LockToggle();
	end
end


-- -----------------------
-- INTERFACE OPTIONS PANEL
-- -----------------------

function NeedToKnow.UIPanel_OnLoad(self)
	local versionText = getglobal(self:GetName().."Version");
	local subText1 = getglobal(self:GetName().."SubText1");
	local subText2 = getglobal(self:GetName().."SubText2");
	local numberbarsLabel = getglobal(self:GetName().."NumberbarsLabel");
	local barTextureLabel = getglobal(self:GetName().."BarTextureDropDownLabel");
	versionText:SetText(NEEDTOKNOW.VERSION);
	subText1:SetText(NEEDTOKNOW.UIPANEL_SUBTEXT1);
	subText2:SetText(NEEDTOKNOW.UIPANEL_SUBTEXT2);
	numberbarsLabel:SetText(NEEDTOKNOW.UIPANEL_NUMBERBARS);
	numberbarsLabel:SetWidth(50);
	barTextureLabel:SetText(NEEDTOKNOW.UIPANEL_BARTEXTURE);
end

function NeedToKnow.UIPanel_Update()
	for groupID = 1, NEEDTOKNOW.MAXGROUPS do
		NeedToKnow.GroupEnableButton_Update(groupID);
		NeedToKnow.NumberbarsWidget_Update(groupID);
	end
	NeedToKnow.BarTextureDropDown_Update();
	NeedToKnow.LockUnlockButton_Update();
end

function NeedToKnow.GroupEnableButton_Update(groupID)
	local button = getglobal("InterfaceOptionsNeedToKnowPanelGroup"..groupID.."EnableButton");
	button:SetChecked(NeedToKnow_Settings["Groups"][groupID]["Enabled"]);
end

function NeedToKnow.GroupEnableButton_OnClick(self)
	local groupID = self:GetParent():GetID();
	if ( self:GetChecked() ) then
		NeedToKnow_Settings["Groups"][groupID]["Enabled"] = true;
	else
		NeedToKnow_Settings["Groups"][groupID]["Enabled"] = false;
	end
	NeedToKnow.Update();
end

function NeedToKnow.NumberbarsWidget_Update(groupID)
	local widgetName = "InterfaceOptionsNeedToKnowPanelGroup"..groupID.."NumberbarsWidget";
	local text = getglobal(widgetName.."Text");
	local leftButton = getglobal(widgetName.."LeftButton");
	local rightButton = getglobal(widgetName.."RightButton");
	local numberBars = NeedToKnow_Settings["Groups"][groupID]["NumberBars"];
	text:SetText(numberBars);
	leftButton:Enable();
	rightButton:Enable();
	if ( numberBars == 1 ) then
		leftButton:Disable();
	elseif ( numberBars == NEEDTOKNOW.MAXBARS ) then
		rightButton:Disable();
	end
end

function NeedToKnow.NumberbarsButton_OnClick(self, increment)
	local groupID = self:GetParent():GetParent():GetID();
	local oldNumber = NeedToKnow_Settings["Groups"][groupID]["NumberBars"];
	if ( oldNumber == 1 ) and ( increment < 0 ) then 
		return;
	elseif ( oldNumber == NEEDTOKNOW.MAXBARS ) and ( increment > 0 ) then
		return;
	end
	NeedToKnow_Settings["Groups"][groupID]["NumberBars"] = oldNumber + increment;
	NeedToKnow.Group_Update(groupID);
	NeedToKnow.NumberbarsWidget_Update(groupID);
end

function NeedToKnow.BarTextureDropDown_Update()
	getglobal("InterfaceOptionsNeedToKnowPanelBarTextureDropDownText"):SetText(NeedToKnow_Settings["BarTexture"]);
end

function NeedToKnow.BarTextureDropDown(self)
	local textureList = {"Aluminum", "Armory", "BantoBar", "DarkBottom", "Default", "Flat", "Glaze", "Gloss", "Graphite", "Minimalist", "Otravi", "Smooth", "Smoothv2", "Striped" };
	if ( NeedToKnow_Settings ) then
		for key, textureName in ipairs(textureList) do 
			info = UIDropDownMenu_CreateInfo();
			info.value = textureName;
			info.text = textureName;
			info.checked = ( NeedToKnow_Settings["BarTexture"] == textureName );
			info.func = NeedToKnow.ChooseBarTexture;
			UIDropDownMenu_AddButton(info);
		end
	end
end

function NeedToKnow.ChooseBarTexture()
	NeedToKnow_Settings["BarTexture"] = this.value;
	NeedToKnow.Update();
	NeedToKnow.BarTextureDropDown_Update();
end

function NeedToKnow.LockUnlockButton_Update()
	local text = getglobal("InterfaceOptionsNeedToKnowPanelLockUnlockButtonText");
	if ( NeedToKnow_Settings["Locked"] ) then
		text:SetText(NEEDTOKNOW.UIPANEL_UNLOCK);
	else
		text:SetText(NEEDTOKNOW.UIPANEL_LOCK);
	end
end

function NeedToKnow.LockToggle()
	if ( NeedToKnow_Settings["Locked"] ) then
		NeedToKnow_Settings["Locked"] = false;
	else
		NeedToKnow_Settings["Locked"] = true;
	end
	PlaySound("UChatScrollButton");
	NeedToKnow.Update();
end

function NeedToKnow.Reset()
	NeedToKnow_Settings = CopyTable(NEEDTOKNOW.DEFAULTS);
	NeedToKnow_Settings["Groups"][1]["Enabled"] = true;
	for groupID = 1, NEEDTOKNOW.MAXGROUPS do
		local group = getglobal("NeedToKnow_Group"..groupID);
		group:ClearAllPoints();
		group:SetPoint("TOPLEFT", "UIParent", "TOPLEFT", 100, -100 - 100*groupID);
	end
	NeedToKnow.Update();
	NeedToKnow.UIPanel_Update();
end

function NeedToKnow.Cancel()
	NeedToKnow_Settings = CopyTable(NeedToKnow_OldSettings);
	NeedToKnow.Update();
end


-- --------
-- BAR GUI
-- --------

NeedToKnow.CurrentBar = { groupID = 1, barID = 1 };		-- a dirty hack, i know.  

StaticPopupDialogs["NEEDTOKNOW.CHOOSENAME_DIALOG"] = {
	text = NEEDTOKNOW.CHOOSENAME_DIALOG,
	button1 = ACCEPT,
	button2 = CANCEL,
	hasEditBox = 1,
	maxLetters = 35,
	OnShow = function()
		getglobal(this:GetName().."EditBox"):SetFocus();
	end,
	OnAccept = function(iconNumber)
		local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
		NeedToKnow.BarMenu_ChooseName(text);
	end,
	EditBoxOnEnterPressed = function(iconNumber)
		local text = getglobal(this:GetParent():GetName().."EditBox"):GetText();
		NeedToKnow.BarMenu_ChooseName(text);
		this:GetParent():Hide();
	end,
	EditBoxOnEscapePressed = function()
		this:GetParent():Hide();
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		getglobal(this:GetName().."EditBox"):SetText("");
	end,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1,
};

NeedToKnow.BarMenu_MoreOptions = {
	{ VariableName = "BuffOrDebuff", MenuText = NEEDTOKNOW.BARMENU_BUFFORDEBUFF, HasSubmenu = true },
	{ VariableName = "Unit", MenuText = NEEDTOKNOW.BARMENU_CHOOSEUNIT, HasSubmenu = true },
};

NeedToKnow.BarMenu_SubMenus = {
	-- the keys on this table need to match the settings variable names
	BuffOrDebuff = {
	  	{ Setting = "HELPFUL", MenuText = NEEDTOKNOW.BARMENU_BUFF },
	  	{ Setting = "HARMFUL", MenuText = NEEDTOKNOW.BARMENU_DEBUFF },
	},
	Unit = {
		{ Setting = "player", MenuText = NEEDTOKNOW.BARMENU_PLAYER }, 
		{ Setting = "target", MenuText = NEEDTOKNOW.BARMENU_TARGET }, 
		{ Setting = "targettarget", MenuText = NEEDTOKNOW.BARMENU_TARGETTARGET }, 
		{ Setting = "focus", MenuText = NEEDTOKNOW.BARMENU_FOCUS }, 
		{ Setting = "pet", MenuText = NEEDTOKNOW.BARMENU_PET }, 
	},
};

function NeedToKnow.Bar_OnEnter(self)
	local tooltip = getglobal("GameTooltip");
	GameTooltip_SetDefaultAnchor(tooltip, self);
	tooltip:AddLine(NEEDTOKNOW.BAR_TOOLTIP1, HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b, 1);
	tooltip:AddLine(NEEDTOKNOW.BAR_TOOLTIP2, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, 1);
	tooltip:Show();
end

function NeedToKnow.Bar_OnMouseUp(self, button)
	if ( button == "RightButton" ) then
 		PlaySound("UChatScrollButton");
		NeedToKnow.CurrentBar["barID"] = self:GetID();
		NeedToKnow.CurrentBar["groupID"] = self:GetParent():GetID();
		ToggleDropDownMenu(1, nil, getglobal(self:GetName().."DropDown"), "cursor", 0, 0);
 	end
end

function NeedToKnow.BarMenu_Initialize()

	local groupID = NeedToKnow.CurrentBar["groupID"];
	local barID = NeedToKnow.CurrentBar["barID"];
	local barSettings = NeedToKnow_Settings["Groups"][groupID]["Bars"][barID];

	if ( UIDROPDOWNMENU_MENU_LEVEL == 2 ) then
		local subMenus = NeedToKnow.BarMenu_SubMenus;
		for index, value in ipairs(subMenus[UIDROPDOWNMENU_MENU_VALUE]) do
			-- here, UIDROPDOWNMENU_MENU_VALUE is the setting name
			local info = UIDropDownMenu_CreateInfo();
			info.text = subMenus[UIDROPDOWNMENU_MENU_VALUE][index]["MenuText"];
			info.value = subMenus[UIDROPDOWNMENU_MENU_VALUE][index]["Setting"];
			info.checked = ( info.value == NeedToKnow_Settings["Groups"][groupID]["Bars"][barID][UIDROPDOWNMENU_MENU_VALUE] );
			info.func = NeedToKnow.BarMenu_ChooseSetting;
			UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL);
		end
		return;
	end

	-- show name
	if ( barSettings.AuraName ) and ( barSettings.AuraName ~= "" ) then
		local info = UIDropDownMenu_CreateInfo();
		info.text = barSettings.AuraName;
		info.isTitle = true;
		UIDropDownMenu_AddButton(info);
	end

	-- enable bar
	info = UIDropDownMenu_CreateInfo();
	info.value = "Enabled";
	info.text = NEEDTOKNOW.BARMENU_ENABLE;
	info.checked = barSettings.Enabled;
	info.func = NeedToKnow.BarMenu_ToggleSetting;
	info.keepShownOnClick = true;
	UIDropDownMenu_AddButton(info);

	-- choose aura name
	info = UIDropDownMenu_CreateInfo();
	info.value = "NEEDTOKNOW.BARMENU_CHOOSENAME";
	info.text = NEEDTOKNOW.BARMENU_CHOOSENAME;
	info.func = NeedToKnow.BarMenu_ShowNameDialog;
	UIDropDownMenu_AddButton(info);

	local moreOptions = NeedToKnow.BarMenu_MoreOptions;
	for index, value in ipairs(moreOptions) do
		info = UIDropDownMenu_CreateInfo();
		info.text = moreOptions[index]["MenuText"];
		info.value = moreOptions[index]["VariableName"];
		info.hasArrow = moreOptions[index]["HasSubmenu"];
		if not info.hasArrow then
			info.func = NeedToKnow.BarMenu_ToggleSetting;
			info.checked = NeedToKnow_Settings["Groups"][groupID]["bars"][barID][info.value];
		end
		info.keepShownOnClick = true;
		UIDropDownMenu_AddButton(info);
	end

	-- choose bar color
	info = UIDropDownMenu_CreateInfo();
	info.text = NEEDTOKNOW.BARMENU_BARCOLOR;
	info.hasColorSwatch = 1;
	info.r = barSettings.BarColor.r;
	info.g = barSettings.BarColor.g;
	info.b = barSettings.BarColor.b;
	info.func = UIDropDownMenuButton_OpenColorPicker;
	info.swatchFunc = NeedToKnow.BarMenu_SetColor;
	info.cancelFunc = NeedToKnow.BarMenu_CancelColor;
	UIDropDownMenu_AddButton(info);

	info = UIDropDownMenu_CreateInfo();
	info.disabled = true;
	UIDropDownMenu_AddButton(info);

	-- clear settings
	info = UIDropDownMenu_CreateInfo();
	info.text = NEEDTOKNOW.BARMENU_CLEARSETTINGS;
	info.func = NeedToKnow.BarMenu_ClearSettings;
	UIDropDownMenu_AddButton(info);


end

function NeedToKnow.BarMenu_ToggleSetting()
	local groupID = NeedToKnow.CurrentBar["groupID"];
	local barID = NeedToKnow.CurrentBar["barID"];
	NeedToKnow_Settings["Groups"][groupID]["Bars"][barID][this.value] = this.checked;
	NeedToKnow.Bar_Update(groupID, barID);
end

function NeedToKnow.BarMenu_ChooseSetting()
	local groupID = NeedToKnow.CurrentBar["groupID"];
	local barID = NeedToKnow.CurrentBar["barID"];
	NeedToKnow_Settings["Groups"][groupID]["Bars"][barID][UIDROPDOWNMENU_MENU_VALUE] = this.value;
	NeedToKnow.Bar_Update(groupID, barID);
end

function NeedToKnow.BarMenu_ShowNameDialog()
	local dialog = StaticPopup_Show("NEEDTOKNOW.CHOOSENAME_DIALOG");
end

function NeedToKnow.BarMenu_ChooseName(text)
	local groupID = NeedToKnow.CurrentBar["groupID"];
	local barID = NeedToKnow.CurrentBar["barID"];
	NeedToKnow_Settings["Groups"][groupID]["Bars"][barID]["AuraName"] = text;
	NeedToKnow.Bar_Update(groupID, barID);
end

function NeedToKnow.BarMenu_SetColor()
	local groupID = NeedToKnow.CurrentBar["groupID"];
	local barID = NeedToKnow.CurrentBar["barID"];
	local r,g,b = ColorPickerFrame:GetColorRGB();
	NeedToKnow_Settings["Groups"][groupID]["Bars"][barID]["BarColor"]["r"] = r;
	NeedToKnow_Settings["Groups"][groupID]["Bars"][barID]["BarColor"]["g"] = g;
	NeedToKnow_Settings["Groups"][groupID]["Bars"][barID]["BarColor"]["b"] = b;
	NeedToKnow.Bar_Update(groupID, barID);
end

function NeedToKnow.BarMenu_CancelColor(previousValues)
	if ( previousValues.r ) then
		local groupID = NeedToKnow.CurrentBar["groupID"];
		local barID = NeedToKnow.CurrentBar["barID"];
		NeedToKnow_Settings["Groups"][groupID]["Bars"][barID]["BarColor"]["r"] = previousValues.r;
		NeedToKnow_Settings["Groups"][groupID]["Bars"][barID]["BarColor"]["g"] = previousValues.g;
		NeedToKnow_Settings["Groups"][groupID]["Bars"][barID]["BarColor"]["b"] = previousValues.b;
		NeedToKnow.Bar_Update(groupID, barID);
	end
end

function NeedToKnow.BarMenu_ClearSettings()
	local groupID = NeedToKnow.CurrentBar["groupID"];
	local barID = NeedToKnow.CurrentBar["barID"];
	NeedToKnow_Settings["Groups"][groupID]["Bars"][barID] = CopyTable(NEEDTOKNOW.BAR_DEFAULTS);
	NeedToKnow.Bar_Update(groupID, barID);
	CloseDropDownMenus();
end


-- -------------
-- RESIZE BUTTON
-- -------------

function NeedToKnow.Resizebutton_OnEnter(self)
	local tooltip = getglobal("GameTooltip");
	GameTooltip_SetDefaultAnchor(tooltip, self);
	tooltip:AddLine(NEEDTOKNOW.RESIZE_TOOLTIP, NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, 1);
	tooltip:Show();
end

function NeedToKnow.StartSizing(self, button)
	local group = self:GetParent();
	local groupID = self:GetParent():GetID();
	group.oldScale = group:GetScale();
	group.oldX = group:GetLeft();			-- use GetPoint() here, instead?
	group.oldY = group:GetTop();
	self.oldCursorX, self.oldCursorY = GetCursorPosition(UIParent);
	self.oldWidth = getglobal(group:GetName().."Bar1"):GetWidth();
	self:SetScript("OnUpdate", NeedToKnow.Sizing_OnUpdate);
end

function NeedToKnow.Sizing_OnUpdate(self)
	local uiScale = UIParent:GetScale();
	local cursorX, cursorY = GetCursorPosition(UIParent);
	local group = self:GetParent();
	local groupID = self:GetParent():GetID();

	-- calculate & set new scale
	local newYScale = group.oldScale * (cursorY/uiScale - group.oldY*group.oldScale) / (self.oldCursorY/uiScale - group.oldY*group.oldScale) ;
	local newScale = max(0.6, newYScale);
	group:SetScale(newScale);

	-- set new frame coords to keep same on-screen position
	local newX = group.oldX * group.oldScale / newScale;
	local newY = group.oldY * group.oldScale / newScale;
	group:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", newX, newY);

	-- calculate & set new bar width
	local newWidth = max(50, ((cursorX - self.oldCursorX)/uiScale + self.oldWidth * group.oldScale)/newScale);
	NeedToKnow.SetWidth(groupID, newWidth);
end

function NeedToKnow.SetWidth(groupID, width)	
	for barID = 1, NeedToKnow_Settings["Groups"][groupID]["NumberBars"] do
		local bar = getglobal("NeedToKnow_Group"..groupID.."Bar"..barID);
		local background = getglobal(bar:GetName().."Background");
		local text = getglobal(bar:GetName().."Text");
		bar:SetWidth(width);
		text:SetWidth(width-60);
		background:SetWidth(width + 2*NeedToKnow_Settings["BarPadding"]);
	end
	NeedToKnow_Settings["Groups"][groupID]["Width"] = width;		-- move this to StopSizing?
end

function NeedToKnow.StopSizing(self, button)
	self:SetScript("OnUpdate", nil)
	local groupID = self:GetParent():GetID();
	NeedToKnow_Settings["Groups"][groupID]["Scale"] = self:GetParent():GetScale();
end



