-- --------------------------------------
-- NeedToKnow
-- by Nephthys <Drunken Monkeys> of Hyjal
-- --------------------------------------


-- -------------
-- ADDON GLOBALS
-- -------------

NeedToKnow = {};
-- NEEDTOKNOW = {} is defined in the localization file, which must be loaded before this file

NEEDTOKNOW.VERSION = "2.0";
NEEDTOKNOW.MAXGROUPS = 4;
NEEDTOKNOW.MAXBARS = 6;
NEEDTOKNOW.UPDATE_INTERVAL = 0.05;

NEEDTOKNOW.BAR_DEFAULTS = {
	Enabled			= true,
	AuraName		= "",
	Unit			= "player",
	BuffOrDebuff	= "HELPFUL",
	OnlyMine		= false,
	BarColor		= { r=0.6, g=0.6, b=0.6, a=1.0 },
};
NEEDTOKNOW.GROUP_DEFAULTS = {
	Enabled		= false,
	NumberBars	= 3,
	Scale		= 1.0,
	Width		= 270,
	Bars		= {},
};
NEEDTOKNOW.DEFAULTS = {
	Version		= NEEDTOKNOW.VERSION,
	Locked		= false,
	BarTexture	= "BantoBar",
	BkgdColor	= { r=0, g=0, b=0, a=0.8 },
	BarSpacing	= 3,
	BarPadding	= 3,
	Groups		= {},
};
for barID = 1, NEEDTOKNOW.MAXBARS do
	NEEDTOKNOW.GROUP_DEFAULTS["Bars"][barID] = NEEDTOKNOW.BAR_DEFAULTS;
end;
for groupID = 1, NEEDTOKNOW.MAXGROUPS do
	NEEDTOKNOW.DEFAULTS["Groups"][groupID] = NEEDTOKNOW.GROUP_DEFAULTS;
end;

function NeedToKnow.Test(stuff)
	if ( stuff ) then
		DEFAULT_CHAT_FRAME:AddMessage("NeedToKnow test: "..stuff);
	else
		DEFAULT_CHAT_FRAME:AddMessage("NeedToKnow test: "..self:GetName());
	end
end



-- ---------------
-- EXECUTIVE FRAME
-- ---------------

function NeedToKnow.ExecutiveFrame_OnEvent(self, event)
	if ( event == 'VARIABLES_LOADED' ) then
		if ( not NeedToKnow_Settings ) then
			NeedToKnow_Settings = CopyTable(NEEDTOKNOW.DEFAULTS);
			NeedToKnow_Settings["Groups"][1]["Enabled"] = true;
		elseif ( NeedToKnow_Settings["Version"] < NEEDTOKNOW.VERSION ) then
			NeedToKnow.SafeUpgrade();
		end
		SlashCmdList["NEEDTOKNOW"] = NeedToKnow.SlashCommand;
		SLASH_NEEDTOKNOW1 = "/needtoknow";
		SLASH_NEEDTOKNOW2 = "/ntk";
	elseif ( event == "PLAYER_ENTERING_WORLD" ) then
		NeedToKnow.Update();
	end
end

function NeedToKnow.SafeUpgrade()
	if ( NeedToKnow_Settings["Version"] < "2.0" ) then			-- total settings clear if 1.x
		NeedToKnow_Settings = CopyTable(NEEDTOKNOW.DEFAULTS);
		NeedToKnow_Settings["Groups"][1]["Enabled"] = true;
	end
end

function NeedToKnow.Update()
	for groupID = 1, NEEDTOKNOW.MAXGROUPS do
		NeedToKnow.Group_Update(groupID);
	end
end

do
	local executiveFrame = CreateFrame("Frame", "NeedToKnow_ExecutiveFrame");
	executiveFrame:SetScript("OnEvent", NeedToKnow.ExecutiveFrame_OnEvent);
	executiveFrame:RegisterEvent("VARIABLES_LOADED");
	executiveFrame:RegisterEvent("PLAYER_ENTERING_WORLD");
end



-- ------
-- GROUPS
-- ------

function NeedToKnow.Group_Update(groupID)
	local groupName = "NeedToKnow_Group"..groupID;
	local group = getglobal(groupName);
	local groupSettings = NeedToKnow_Settings["Groups"][groupID];

	for barID = 1, groupSettings.NumberBars do
		local barName = groupName.."Bar"..barID;
		local bar = getglobal(barName) or CreateFrame("StatusBar", barName, group, "NeedToKnow_BarTemplate");
		bar:SetID(barID);

		if ( barID > 1 ) then
			bar:SetPoint("TOP", getglobal(groupName.."Bar"..(barID-1)), "BOTTOM", 0, -NeedToKnow_Settings.BarSpacing);
		else
			bar:SetPoint("TOPLEFT", group, "TOPLEFT");
		end

		NeedToKnow.Bar_Update(groupID, barID);

		if ( not groupSettings.Enabled ) then
			NeedToKnow.ClearScripts(bar);
		end
	end
	for barID = groupSettings.NumberBars+1, NEEDTOKNOW.MAXBARS do
		local bar = getglobal(groupName.."Bar"..barID);
		if ( bar ) then
			bar:Hide();
			NeedToKnow.ClearScripts(bar);
		end
	end

	local resizeButton = getglobal(groupName.."ResizeButton");
	resizeButton:SetPoint("BOTTOMRIGHT", groupName.."Bar"..groupSettings.NumberBars, "BOTTOMRIGHT", 8, -8);
	if ( NeedToKnow_Settings["Locked"] ) then
		resizeButton:Hide();
	else
		resizeButton:Show();
	end

	group:SetScale(groupSettings.Scale);
	if ( groupSettings.Enabled ) then
		group:Show();
	else
		group:Hide();
	end
end



-- ----
-- BARS
-- ----

function NeedToKnow.Bar_Update(groupID, barID)
	local barName = "NeedToKnow_Group"..groupID.."Bar"..barID;
	local bar = getglobal(barName);
	local background = getglobal(barName.."Background");
	local spark = getglobal(barName.."Spark");
	local text = getglobal(barName.."Text");
	local time = getglobal(barName.."Time");

	local groupSettings = NeedToKnow_Settings["Groups"][groupID];
--	local barSettings = NeedToKnow_Settings["Groups"][groupID]["Bars"][barID];
	local barSettings = groupSettings["Bars"][barID];
	bar.auraName = barSettings.AuraName;
	bar.buffOrDebuff = barSettings.BuffOrDebuff;
	bar.unit = barSettings.Unit;
--	bar.onlyMine = barSettings.OnlyMine;				-- only needed for WoW 3.0
	bar.updateTimer = NEEDTOKNOW.UPDATE_INTERVAL;
	bar.updateInterval = NEEDTOKNOW.UPDATE_INTERVAL;

	bar:SetMinMaxValues(0,1);
	bar:SetValue(1);
	bar:SetStatusBarTexture("Interface\\AddOns\\NeedToKnow\\Textures\\"..NeedToKnow_Settings["BarTexture"]);
	bar:SetStatusBarColor(barSettings.BarColor.r, barSettings.BarColor.g, barSettings.BarColor.b);

	bar:SetWidth(groupSettings.Width);
	text:SetWidth(groupSettings.Width-60);
	background:SetWidth(groupSettings.Width + 2*NeedToKnow_Settings["BarPadding"]);
	background:SetHeight(bar:GetHeight() + 2*NeedToKnow_Settings["BarPadding"]);
	local bkgdColor = NeedToKnow_Settings.BkgdColor;
	background:SetVertexColor(bkgdColor.r, bkgdColor.g, bkgdColor.b, bkgdColor.a);

	text:SetText(bar.auraName);
	if ( NeedToKnow_Settings["Locked"] ) then
		bar:EnableMouse(0);
		bar:Hide();
		spark:Show();
		time:Show();
	else
		NeedToKnow.ClearScripts(bar);
		bar:EnableMouse(1);
		bar:Show();
		spark:Hide();
		time:Hide();
	end

	if ( barSettings.Enabled ) then
		bar:SetAlpha(1);
	else
		bar:SetAlpha(0.4);
	end

	if ( NeedToKnow_Settings["Locked"] and barSettings.Enabled ) then
		NeedToKnow.SetScripts(bar);
		NeedToKnow.Bar_AuraCheck(bar);		-- a check for when the addon gets locked
	else
		NeedToKnow.ClearScripts(bar);
	end
end

function NeedToKnow.SetScripts(bar)
	bar:SetScript("OnEvent", NeedToKnow.Bar_OnEvent);
	bar:SetScript("OnUpdate", NeedToKnow.Bar_OnUpdate);
	bar:RegisterEvent("PLAYER_TARGET_CHANGED");
	bar:RegisterEvent("PLAYER_FOCUS_CHANGED");
	bar:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	bar:RegisterEvent("UNIT_AURA");
end

function NeedToKnow.ClearScripts(bar)
	bar:SetScript("OnEvent", nil);
	bar:SetScript("OnUpdate", nil);
	bar:UnregisterEvent("PLAYER_TARGET_CHANGED");
	bar:UnregisterEvent("PLAYER_FOCUS_CHANGED");
	bar:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
	bar:UnregisterEvent("UNIT_AURA");
end

function NeedToKnow.Bar_OnEvent(self, event, ...)
	if ( event == "COMBAT_LOG_EVENT_UNFILTERED" ) then
--		local timestamp, combatEvent, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags;
--		local spellID, spellName, spellSchool, auraType;
		local combatEvent = select(2, ...);
		if ( combatEvent == "SPELL_AURA_APPLIED" ) 
			or ( combatEvent == "SPELL_AURA_REMOVED" ) 
			or ( combatEvent == "SPELL_AURA_APPLIED_DOSE" ) 
			or ( combatEvent == "SPELL_AURA_REMOVED_DOSE" ) 
			or ( combatEvent == "SPELL_AURA_REFRESH" ) 		-- not working in WoW 2.4.3
			or ( combatEvent == "SPELL_AURA_BROKEN" ) 
			or ( combatEvent == "SPELL_AURA_BROKEN_SPELL" ) 
		then
			local spellName = select(10, ...);
			if ( spellName == self.auraName ) then			-- could add check for unitGUID here, i guess.  meh.  
				NeedToKnow.Bar_AuraCheck(self);
			end
		elseif ( combatEvent == "UNIT_DIED" ) then
			local dstGUID = select(6, ...);
			local watchedGUID = UnitGUID(self.unit);
			if ( dstGUID == watchedGUID ) then
				NeedToKnow.Bar_AuraCheck(self);
			end
		end
	elseif (event == "UNIT_AURA" ) then						-- only needed for buff/debuff refresh. drop when 3.0 hits. 
		local unit = select(1, ...);
		if ( unit == self.unit ) then
			NeedToKnow.Bar_AuraCheck(self);
		end
	elseif ( event == "PLAYER_TARGET_CHANGED" ) or ( event == "PLAYER_FOCUS_CHANGED" ) then
		NeedToKnow.Bar_AuraCheck(self);
	end
end

function NeedToKnow.Bar_AuraCheck(bar)
	if ( UnitName(bar.unit) ) then
--		local buffName, rank, iconTexture, count, [debuffType,] duration, timeLeft;
		local buffName, count, duration, timeLeft;
		for buffIndex = 1, 40 do
			if ( bar.buffOrDebuff == "HELPFUL" ) then
				buffName, _, _, count, duration, timeLeft = UnitBuff(bar.unit, buffIndex);
			else
				buffName, _, _, count, _, duration, timeLeft = UnitDebuff(bar.unit, buffIndex);
			end
			if ( not buffName ) then
				bar:Hide();
				return;
			elseif ( buffName == bar.auraName ) and ( timeLeft ) then
				bar:Show();
				bar:SetMinMaxValues(0, duration);
				bar:SetValue(timeLeft);
				bar.timeLeft = timeLeft;
				bar.duration = duration;
				getglobal(bar:GetName().."Spark"):SetPoint("CENTER", bar, "LEFT", bar:GetWidth()*bar.timeLeft/bar.duration, 0);
				local text = getglobal(bar:GetName().."Text");
				if ( count > 1 ) then
					text:SetText(bar.auraName.."  ["..count.."]");
				else
					text:SetText(bar.auraName);
				end
				return;
			end
		end
		bar:Hide();		-- move along.  these aren't the buffs you're looking for.  
	else
		bar:Hide();
	end
end

function NeedToKnow.Bar_OnUpdate(self, elapsed)
	self.updateTimer = self.updateTimer - elapsed;
	self.timeLeft = self.timeLeft - elapsed;
	if ( self.updateTimer <= 0 ) then 
		self.updateTimer = self.updateInterval;
		self.timeLeft = max(0, self.timeLeft);
		self:SetValue(self.timeLeft);
		getglobal(self:GetName().."Time"):SetFormattedText(SecondsToTimeAbbrev(self.timeLeft));
		getglobal(self:GetName().."Spark"):SetPoint("CENTER", self, "LEFT", self:GetWidth()*self.timeLeft/self.duration, 0);
	end
end





