﻿
-- constants
local ARROW = " ‹–› " -- ascii 139, 150, 155

local Nauticus = Nauticus

local L = AceLibrary("AceLocale-2.2"):new("Nauticus")

Nauticus.transports = {

[0] = {
ship_type = -1,
name = L["Select None"],
label = -1,
faction = -1,
},
[1] = {
vessel_name = "The Thundercaller",
ship_type = "Zeppelin",
name = L["Durotar"]..ARROW..L["Tirisfal Glades"],
short_name = L["Org"]..ARROW..L["UC"],
label = "org2uc",
faction = "Horde",
},
[2] = {
vessel_name = "The Iron Eagle",
ship_type = "Zeppelin",
name = L["Durotar"]..ARROW..L["Stranglethorn Vale"],
short_name = L["Org"]..ARROW..L["GG"],
label = "org2gg",
faction = "Horde",
},
[3] = {
vessel_name = "The Purple Princess",
ship_type = "Zeppelin",
name = L["Tirisfal Glades"]..ARROW..L["Stranglethorn Vale"],
short_name = L["UC"]..ARROW..L["GG"],
label = "grom2uc",
faction = "Horde",
},
[4] = {
vessel_name = "The Maiden's Fancy",
ship_type = "Boat",
name = L["The Barrens"]..ARROW..L["Stranglethorn Vale"],
short_name = L["Ra"]..ARROW..L["BB"],
label = "ratch2bb",
faction = "Neutral",
},
[5] = {
vessel_name = "The Bravery",
ship_type = "Boat",
name = L["Wetlands"]..ARROW..L["Darkshore"],
short_name = L["MH"]..ARROW..L["Aub"],
label = "mh2aub",
faction = "Alliance",
},
[6] = {
vessel_name = "The Lady Mehley",
ship_type = "Boat",
name = L["Wetlands"]..ARROW..L["Dustwallow Marsh"],
short_name = L["MH"]..ARROW..L["Th"],
label = "mh2thera",
faction = "Alliance",
},
[7] = {
vessel_name = "The Moonspray",
ship_type = "BoatNE",
name = L["Teldrassil"]..ARROW..L["Darkshore"],
short_name = L["RTV"]..ARROW..L["Aub"],
label = "rtv2ds",
faction = "Alliance",
},
[8] = {
vessel_name = "Feathermoon Ferry",
ship_type = "BoatNE",
name = L["Sardor Isle"]..ARROW..L["Feralas"],
short_name = L["FMS"]..ARROW..L["Fer"],
label = "fms2fer",
faction = "Alliance",
},
[9] = {
vessel_name = "Elune's Blessing",
ship_type = "BoatNE",
name = L["Azuremyst Isle"]..ARROW..L["Darkshore"],
short_name = L["Exo"]..ARROW..L["Aub"],
label = "exo2aub",
faction = "Alliance",
},

}

-- reverse lookup table to find the index (bit of a hack)
Nauticus.lookupIndex = {
['org2uc'] =	1,
['org2gg'] =	2,
['grom2uc'] =	3,
['ratch2bb'] =	4,
['mh2aub'] =	5,
['mh2thera'] =	6,
['rtv2ds'] =	7,
['fms2fer'] =	8,
['exo2aub'] =	9,
}

-- accurate round trip times
Nauticus.rtts = {
["org2uc"] =	239.338793,
["org2gg"] =	248.994966,
["grom2uc"] =	315.032275,
["ratch2bb"] =	231.240594,
["mh2aub"] =	241.782811,
["mh2thera"] =	230.166609,
["rtv2ds"] =	312.323234,
["fms2fer"] =	259.752184,
["exo2aub"] =	238.711765,
}

Nauticus.transitZones = {
[ L["Durotar"] ] = { ["org2uc"] = true, ["org2gg"] = true },
[ L["Tirisfal Glades"] ] = { ["org2uc"] = true, ["grom2uc"] = true },
[ L["Stranglethorn Vale"] ] = { ["org2gg"] = true, ["grom2uc"] = true, ["ratch2bb"] = true },
[ L["The Barrens"] ] = { ["ratch2bb"] = true },
[ L["Wetlands"] ] = { ["mh2aub"] = true, ["mh2thera"] = true },
[ L["Azuremyst Isle"] ] = { ["exo2aub"] = true },
[ L["Darkshore"] ] = { ["mh2aub"] = true, ["rtv2ds"] = true, ["exo2aub"] = true },
[ L["Dustwallow Marsh"] ] = { ["mh2thera"] = true },
[ L["Teldrassil"] ] = { ["rtv2ds"] = true },
[ L["Feralas"] ] = { ["fms2fer"] = true },
[ L["The Veiled Sea"] ] = { ["exo2aub"] = true }, -- special case
[ L["Twisting Nether"] ] = { ["exo2aub"] = true }, -- special case
[ L["Orgrimmar"] ] = { ["org2uc"] = true, ["org2gg"] = true, virtual = true }, -- extend to city
[ L["Undercity"] ] = { ["org2uc"] = true, ["grom2uc"] = true, virtual = true }, -- extend to city
}

Nauticus.platforms = {

['org2uc'] = {
[1] = {
name = L["Orgrimmar"].." / "..L["Durotar"],
ebv = L["Org"],
},
[2] = {
name = L["Undercity"].." / "..L["Tirisfal Glades"],
ebv = L["UC"],
},
},
['org2gg'] = {
[1] = {
name = L["Orgrimmar"].." / "..L["Durotar"],
ebv = L["Org"],
},
[2] = {
name = L["Grom'gol"]..", "..L["Stranglethorn Vale"],
ebv = L["GG"],
},
},
['grom2uc'] = {
[1] = {
name = L["Grom'gol"]..", "..L["Stranglethorn Vale"],
ebv = L["GG"],
},
[2] = {
name = L["Undercity"].." / "..L["Tirisfal Glades"],
ebv = L["UC"],
},
},
['ratch2bb'] = {
[1] = {
name = L["Ratchet"]..", "..L["The Barrens"],
ebv = L["Ra"],
},
[2] = {
name = L["Booty Bay"]..", "..L["Stranglethorn Vale"],
ebv = L["BB"],
},
},
['mh2aub'] = {
[1] = {
name = L["Menethil Harbor"]..", "..L["Wetlands"],
ebv = L["MH"],
},
[2] = {
name = L["Auberdine"]..", "..L["Darkshore"],
ebv = L["Aub"],
},
},
['mh2thera'] = {
[1] = {
name = L["Menethil Harbor"]..", "..L["Wetlands"],
ebv = L["MH"],
},
[2] = {
name = L["Theramore"]..", "..L["Dustwallow Marsh"],
ebv = L["Th"],
},
},
['rtv2ds'] = {
[1] = {
name = L["Rut'Theran Village"]..", "..L["Teldrassil"],
ebv = L["RTV"],
},
[2] = {
name = L["Auberdine"]..", "..L["Darkshore"],
ebv = L["Aub"],
},
},
['fms2fer'] = {
[1] = {
name = L["Feathermoon"]..", "..L["Sardor Isle"],
ebv = L["FMS"],
},
[2] = {
name = L["Forgotten Coast"]..", "..L["Feralas"],
ebv = L["Fer"],
},
},
['exo2aub'] = {
[1] = {
name = L["The Exodar"].."/"..L["Azuremyst Isle"],
ebv = L["Exo"],
},
[2] = {
name = L["Auberdine"]..", "..L["Darkshore"],
ebv = L["Aub"],
},
},

}

-- transport positional data in packed delta format - X:Y:t:(s):a:[c]
Nauticus.packedData = {

["rtv2ds"] = {
" 0.17369880629821: 0.20481254717725:60.00:  2:96.74:plat1", -- [1]
" 0.00000768299819: 0.00000144066330:0.801: 11:-0.01", -- [2]
" 0.00002203936978: 0.00000408803602:0.801: 22:-0.04", -- [3]
" 0.00003649424137: 0.00000657533505:0.799: 33:-0.06", -- [4]
" 0.00005126923786: 0.00000921039442:0.800: 45:-0.07", -- [5]
" 0.00006643823428: 0.00001184545378:0.801: 58:-0.07", -- [6]
" 0.00008155798070: 0.00001433275280:0.800: 70:-0.07", -- [7]
" 0.00009714560201: 0.00001690624536:0.799: 81:-0.04", -- [8]
" 0.00011339809817: 0.00001967675171:0.800: 95:-0.01", -- [9]
" 0.00012960134433: 0.00002243494468:0.801:109: 0.04", -- [10]
" 0.00014541059059: 0.00002545171826:0.799:120: 0.11", -- [11]
" 0.00016166308675: 0.00002894871293:0.800:134: 0.20", -- [12]
" 0.00017729995805: 0.00003288898861:0.800:146: 0.31", -- [13]
" 0.00019212420453: 0.00003737105221:0.800:156: 0.46", -- [14]
" 0.00020598807626: 0.00004315833211:0.801:168: 0.64", -- [15]
" 0.00021724169859: 0.00004973366717:0.799:179: 0.88", -- [16]
" 0.00022726407122: 0.00005827914006:0.801:183: 1.19", -- [17]
" 0.00023295244488: 0.00006803132239:0.799:189: 1.59", -- [18]
" 0.00023516869435: 0.00008051707096:0.800:189: 2.16", -- [19]
" 0.00023339569477: 0.00009578563924:0.801:189: 2.95", -- [20]
" 0.00022384119704: 0.00011354150655:0.799:183: 4.13", -- [21]
" 0.00027843480911: 0.00018387542754:0.801:265: 5.49", -- [22]
" 0.00028540368246: 0.00024294262274:0.800:252: 6.86", -- [23]
" 0.00025048544073: 0.00028328119507:0.799:243: 8.01", -- [24]
" 0.00022103394770: 0.00033457865914:0.800:249: 8.27", -- [25]
" 0.00019909307789: 0.00039932231401:0.800:272: 7.18", -- [26]
" 0.00018668208082: 0.00047721663897:0.801:307: 5.14", -- [27]
" 0.00013826934228: 0.00044207430519:0.799:247: 6.80", -- [28]
" 0.00009933722650: 0.00045760145407:0.801:259: 6.44", -- [29]
" 0.00007550023213: 0.00051352874208:0.800:292: 4.21", -- [30]
" 0.00006688148417: 0.00060431515655:0.799:349: 1.55", -- [31]
" 0.00007759335664: 0.00073805057599:0.800:430:-0.62", -- [32]
" 0.00010532110008: 0.00087343598587:0.800:342:-1.80", -- [33]
" 0.00007451523237: 0.00055234045758:0.800:314:-0.40", -- [34]
" 0.00008670460448: 0.00062713181544:0.801:353:-0.15", -- [35]
" 0.00009648072717: 0.00069443664949:0.799:388: 0.05", -- [36]
" 0.00010379435044: 0.00075647136482:0.800:415: 0.24", -- [37]
" 0.00010827609938: 0.00081232477266:0.800:441: 0.42", -- [38]
" 0.00010822684939: 0.00085113648816:0.800:459: 0.62", -- [39]
" 0.00010204597585: 0.00086139351831:0.800:459: 0.83", -- [40]
" 0.00009165422831: 0.00085548310477:0.800:455: 1.10", -- [41]
" 0.00007719935673: 0.00083495673113:0.800:432: 1.42", -- [42]
" 0.00005976486086: 0.00078876931208:0.800:408: 1.23", -- [43]
" 0.00004794486366: 0.00076442579636:0.801:395: 1.05", -- [44]
" 0.00003848886589: 0.00075410719940:0.799:397: 0.93", -- [45]
" 0.00003092899268: 0.00075627435103:0.800:399: 0.79", -- [46]
" 0.00002499436909: 0.00076733174968:0.800:407: 0.61", -- [47]
" 0.00002088199505: 0.00078804282375:0.800:420: 0.42", -- [48]
" 0.00001844412064: 0.00081864152712:0.800:438: 0.24", -- [49]
" 0.00001780387079: 0.00085896778608:0.800:462: 0.07", -- [50]
" 0.00001891199552: 0.00090902160066:0.800:505:-0.09", -- [51]
" 0.00001568612129: 0.00080686995351:0.800:374: 0.93", -- [52]
" 0.00000240905969: 0.00073062145311:0.801:390: 1.30", -- [53]
"-0.00000712676257: 0.00075722836441:0.799:408: 0.85", -- [54]
"-0.00001346020164: 0.00078253871236:0.801:412: 0.46", -- [55]
"-0.00001658089964: 0.00080194583286:0.799:421: 0.12", -- [56]
"-0.00001660719766: 0.00082132007850:0.801:433:-0.22", -- [57]
"-0.00001331994555: 0.00083051188689:0.799:439:-0.52", -- [58]
"-0.00000695144246: 0.00083975739089:0.801:438:-0.83", -- [59]
" 0.00000258597166: 0.00084284762690:0.799:443:-1.15", -- [60]
" 0.00001534927585: 0.00084515105814:0.800:447:-1.47", -- [61]
" 0.00003123766105: 0.00084025051365:0.800:441:-1.82", -- [62]
" 0.00005028619127: 0.00083235397439:0.800:433:-2.19", -- [63]
" 0.00007251239855: 0.00082039848684:0.800:432:-2.59", -- [64]
" 0.00009330098088: 0.00077372496475:0.800:409:-2.72", -- [65]
" 0.00011562361421: 0.00076293543858:0.800:416:-2.34", -- [66]
" 0.00013553997900: 0.00076045009984:0.800:414:-1.95", -- [67]
" 0.00015226113473: 0.00075911976418:0.800:417:-1.57", -- [68]
" 0.00016579146441: 0.00075872526598:0.800:420:-1.20", -- [69]
" 0.00017611781905: 0.00075949672914:0.800:423:-0.84", -- [70]
" 0.00018325334762: 0.00076128950437:0.801:422:-0.49", -- [71]
" 0.00018718051814: 0.00076416934134:0.799:424:-0.13", -- [72]
" 0.00018793877763: 0.00076809898188:0.800:430: 0.20", -- [73]
" 0.00018549306206: 0.00077316390062:0.800:432: 0.54", -- [74]
" 0.00017984337143: 0.00077926766466:0.800:433: 0.88", -- [75]
" 0.00017101162076: 0.00078641904063:0.800:439: 1.21", -- [76]
" 0.00015900219306: 0.00079474295296:0.800:436: 1.53", -- [77]
" 0.00014160605489: 0.00078702832120:0.800:413: 1.33", -- [78]
" 0.00013431273821: 0.00079015362373:0.801:434: 0.46", -- [79]
" 0.00013441354727: 0.00081668143699:0.799:448: 0.41", -- [80]
" 0.00013439163226: 0.00084091020234:0.801:457: 0.37", -- [81]
" 0.00013290141131: 0.00085473736475:0.800:458: 0.34", -- [82]
" 0.00013061786683: 0.00086233803035:0.800:465: 0.31:trig1", -- [83]
" 0.00012722103966: 0.00086148328422:0.799:463: 0.31", -- [84]
" 0.00012316237905: 0.00085554389443:0.800:452: 0.30", -- [85]
" 0.00011815698984: 0.00084227122118:0.801:442: 0.31", -- [86]
" 0.00011174027372: 0.00081852242866:0.799:433: 0.32", -- [87]
" 0.00010478883126: 0.00079064893815:0.800:411: 0.34", -- [88]
" 0.00009685121317: 0.00075527121494:0.801:394: 0.38", -- [89]
" 0.00008760746023: 0.00070989515365:0.799:368: 0.43", -- [90]
" 0.00007777638492: 0.00065996482963:0.800:339: 0.52", -- [91]
" 0.00007037349317: 0.00063469941065:0.800:446: 0.70", -- [92]
" 0.00009618499673: 0.00101734514545:0.700:564: 2.19", -- [93]
" 0.00006087990908: 0.00094662476553:0.800:454: 3.03", -- [94]
" 0.00002127071265: 0.00077873947539:0.800:377: 3.24", -- [95]
"-0.00000529466740: 0.00068030778756:0.801:346: 2.53", -- [96]
"-0.00001869350700: 0.00063995062022:0.800:328: 0.83", -- [97]
"-0.00001864091096: 0.00065484950279:0.800:355:-1.05", -- [98]
"-0.00000826634331: 0.00074938004160:0.799:408:-1.29", -- [99]
"-0.00000379129743: 0.00077428602888:0.801:397: 0.11", -- [100]
"-0.00000815676823: 0.00073452937548:0.800:374: 1.04", -- [101]
"-0.00001960517159: 0.00069956806706:0.800:359: 1.95", -- [102]
"-0.00003659369049: 0.00066047329400:0.799:334: 2.83", -- [103]
"-0.00005843419350: 0.00062764665924:0.801:325: 3.66", -- [104]
"-0.00008321569141: 0.00058981866378:0.799:308: 4.40", -- [105]
"-0.00010480198027: 0.00061195439694:0.800:341: 0.05", -- [106]
"-0.00011093818421: 0.00062144865396:0.800:333: 1.34", -- [107]
"-0.00012175105214: 0.00060114952917:0.801:316: 2.64", -- [108]
"-0.00013532082886: 0.00055332319563:0.799:301: 4.09", -- [109]
"-0.00015092431887: 0.00048642068177:0.800:263: 5.91", -- [110]
"-0.00016830292503: 0.00040733255639:0.801:236: 8.33", -- [111]
"-0.00018583055327: 0.00031775954514:0.800:208:11.33", -- [112]
"-0.00020275771014: 0.00022253644279:0.799:191:14.39", -- [113]
"-0.00021340840698: 0.00012277661097:0.800:180:15.14", -- [114]
"-0.00023411371227: 0.00004698473735:0.800:190:10.46", -- [115]
"-0.00024624148105:-0.00000812227991:0.800:196: 6.94", -- [116]
"-0.00024895894279:-0.00004701980385:0.800:198: 4.69", -- [117]
"-0.00024488275018:-0.00007264465454:0.800:195: 3.21", -- [118]
"-0.00023683117401:-0.00008821856739:0.801:188: 2.22", -- [119]
"-0.00022316497124:-0.00009504776980:0.799:178: 1.51", -- [120]
"-0.00020770173731:-0.00009602963204:0.800:164: 1.00", -- [121]
"-0.00019094113456:-0.00009282104655:0.800:150: 0.60", -- [122]
"-0.00017228269158:-0.00008603129395:0.800:135: 0.28", -- [123]
"-0.00015396173982:-0.00007775998139:0.800:119: 0.03", -- [124]
"-0.00013569338409:-0.00006830517418:0.800:105:-0.18", -- [125]
"-0.00011764856152:-0.00005846463539:0.800: 91:-0.33", -- [126]
"-0.00010053731853:-0.00004892654522:0.800: 77:-0.45", -- [127]
"-0.00008425446308:-0.00003990130274:0.800: 63:-0.53", -- [128]
"-0.00006923391243:-0.00003173957301:0.800: 51:-0.56", -- [129]
"-0.00005488396123:-0.00002435807309:0.800: 40:-0.54", -- [130]
"-0.00004145444061:-0.00001786200249:0.800: 29:-0.48", -- [131]
"-0.00002887522253:-0.00001211986181:0.800: 19:-0.38", -- [132]
"-0.00001673430474:-0.00000687741887:0.801:  9:-0.23", -- [133]
"-0.00000498785721:-0.00000202070752:0.766:  0:-0.07", -- [134]
"-0.00000000876600:-0.00000001753326:60.00:  0: 0.00:plat2", -- [135]
"-0.00000879230364:-0.00000351980073:0.801: 13:-0.06", -- [136]
"-0.00002508392510:-0.00000996765489:0.800: 26:-0.15", -- [137]
"-0.00004131418452:-0.00001618319342:0.801: 39:-0.24", -- [138]
"-0.00005710614366:-0.00002193848404:0.799: 52:-0.30", -- [139]
"-0.00007263512262:-0.00002722037680:0.800: 63:-0.33", -- [140]
"-0.00008794933445:-0.00003211653797:0.800: 76:-0.31", -- [141]
"-0.00010222477461:-0.00003642971845:0.800: 88:-0.26", -- [142]
"-0.00011613642554:-0.00004072098236:0.800: 98:-0.11", -- [143]
"-0.00012937747704:-0.00004519634544:0.801:109: 0.10", -- [144]
"-0.00014055413422:-0.00004989964082:0.799:117: 0.44", -- [145]
"-0.00015166066334:-0.00005637817816:0.800:127: 0.90", -- [146]
"-0.00016081237322:-0.00006486427309:0.801:134: 1.53", -- [147]
"-0.00016777258169:-0.00007639238758:0.800:140: 2.35", -- [148]
"-0.00017364142245:-0.00009297446252:0.800:148: 3.40", -- [149]
"-0.00017635888419:-0.00011530306147:0.799:155: 4.69", -- [150]
"-0.00017716973972:-0.00014632377106:0.801:162: 6.13", -- [151]
"-0.00017480291820:-0.00018778553341:0.799:175: 7.56", -- [152]
"-0.00016520852504:-0.00023508586932:0.801:179: 7.41", -- [153]
"-0.00015396173982:-0.00027710869580:0.799:197: 6.08", -- [154]
"-0.00014568663051:-0.00032603524101:0.800:212: 5.73", -- [155]
"-0.00013486061356:-0.00037657484561:0.801:232: 5.32", -- [156]
"-0.00012094896263:-0.00042609313815:0.799:250: 4.93", -- [157]
"-0.00010475815024:-0.00047596209577:0.800:267: 4.59", -- [158]
"-0.00008602957922:-0.00052548038832:0.800:293: 4.30", -- [159]
"-0.00006424605523:-0.00057079069990:0.801:309: 4.09", -- [160]
"-0.00002420732454:-0.00048410190894:0.800:250: 7.26", -- [161]
" 0.00001513889172:-0.00050724142086:0.799:276: 5.55", -- [162]
" 0.00004542544115:-0.00054658165948:0.800:297: 3.24", -- [163]
" 0.00006485967563:-0.00059264590099:0.800:326: 0.98", -- [164]
" 0.00007006668297:-0.00064213789365:0.800:354:-1.20", -- [165]
" 0.00005809670229:-0.00069851168851:0.800:382:-3.31", -- [166]
" 0.00002528992624:-0.00076214863381:0.800:416:-5.29", -- [167]
"-0.00001474442147:-0.00066979660180:0.801:289:-2.04", -- [168]
"-0.00001119418918:-0.00051449580470:0.799:258: 0.47", -- [169]
"-0.00001109338012:-0.00048766992612:0.801:256:-0.89", -- [170]
"-0.00002075351832:-0.00050893337987:0.799:282:-2.22", -- [171]
"-0.00004233104117:-0.00059468852508:0.800:344:-2.76", -- [172]
"-0.00007723727558:-0.00074887596055:0.801:439:-2.44", -- [173]
"-0.00012394255355:-0.00096180418017:0.799:575:-1.79", -- [174]
"-0.00018253453516:-0.00124182339611:0.800:745:-1.20", -- [175]
"-0.00016774190067:-0.00106438248255:0.800:293:-0.60", -- [176]
"-0.00009348506700:-0.00057484964821:0.801:323:-0.23", -- [177]
"-0.00010353967546:-0.00062662973051:0.799:351:-0.19", -- [178]
"-0.00011312091960:-0.00067591570744:0.800:377:-0.16", -- [179]
"-0.00012175105215:-0.00071959980972:0.800:399:-0.13", -- [180]
"-0.00012951335013:-0.00075852363355:0.800:420:-0.12", -- [181]
"-0.00013646040959:-0.00079259074603:0.800:437:-0.11", -- [182]
"-0.00014257031551:-0.00082189319674:0.801:448:-0.10", -- [183]
"-0.00014783430188:-0.00084640030249:0.799:460:-0.09", -- [184]
"-0.00015206389961:-0.00086497021010:0.800:469:-0.09", -- [185]
"-0.00015604366615:-0.00088208924096:0.800:481:-0.09", -- [186]
"-0.00015860772281:-0.00089107065030:0.800:486:-0.09", -- [187]
"-0.00016072471316:-0.00089746590469:0.801:488:-0.09:trig2", -- [188]
"-0.00016159254772:-0.00089684128252:0.800:487:-0.09", -- [189]
"-0.00016163637774:-0.00089138186557:0.799:484:-0.09", -- [190]
"-0.00016122875849:-0.00088342176825:0.800:478:-0.10", -- [191]
"-0.00015980428257:-0.00086947625638:0.800:469:-0.10", -- [192]
"-0.00015753388711:-0.00085074197450:0.800:458:-0.12", -- [193]
"-0.00015442195512:-0.00082725618080:0.800:445:-0.13", -- [194]
"-0.00015047286958:-0.00079888737586:0.800:428:-0.14", -- [195]
"-0.00014568663051:-0.00076572980094:0.800:409:-0.16", -- [196]
"-0.00014005885490:-0.00072783824744:0.800:384:-0.19", -- [197]
"-0.00013360269175:-0.00068514477400:0.800:368:-0.22", -- [198]
"-0.00012628746006:-0.00063756171436:0.800:341:-0.28", -- [199]
"-0.00006013479859:-0.00029944167805:0.400:323:-0.16", -- [200]
"-0.00455608451360:-0.01934716482287:0.300:532: 1.98:zone1", -- [201]
"-0.00012642472008:-0.00071903874580:0.600:512: 0.27", -- [202]
"-0.00015624558803:-0.00091738237313:0.800:480: 0.69", -- [203]
"-0.00013903271710:-0.00087231546997:0.801:459: 1.13", -- [204]
"-0.00011800297208:-0.00082620193109:0.800:432: 1.64", -- [205]
"-0.00009340260290:-0.00078035928616:0.799:402: 2.26", -- [206]
"-0.00006565023446:-0.00073620357176:0.800:372: 2.97", -- [207]
"-0.00003430261688:-0.00068003001652:0.801:343: 3.73", -- [208]
"-0.00000189612456:-0.00062246505142:0.799:312: 4.50", -- [209]
" 0.00003811949098:-0.00064805221666:0.800:447: 6.94", -- [210]
" 0.00013248246865:-0.00076752876346:0.800:394:11.44", -- [211]
" 0.00020524932644:-0.00065489844566:0.800:364: 9.52", -- [212]
" 0.00024937731599:-0.00056497396650:0.801:347: 6.84", -- [213]
" 0.00026848631146:-0.00049556354762:0.799:327: 4.09", -- [214]
" 0.00026843706148:-0.00044734442393:0.801:303: 1.45", -- [215]
" 0.00025031306577:-0.00041266999789:0.800:277:-1.16", -- [216]
" 0.00025220919032:-0.00044470936456:0.800:321:-1.41", -- [217]
" 0.00025565668950:-0.00044984403631:0.799:300: 1.39", -- [218]
" 0.00024787519135:-0.00040267154834:0.801:276: 3.36", -- [219]
" 0.00024873706614:-0.00034939163305:0.800:259: 5.22", -- [220]
" 0.00025686331422:-0.00029249158949:0.800:249: 6.77", -- [221]
" 0.00026885568638:-0.00023227925166:0.799:243: 7.79", -- [222]
" 0.00028510818253:-0.00017230086771:0.801:241: 8.11", -- [223]
" 0.00025767593903:-0.00009840838525:0.800:193: 7.37", -- [224]
" 0.00024388594229:-0.00004862546463:0.799:195: 5.45", -- [225]
" 0.00024615144175:-0.00001781743412:0.800:192: 3.98", -- [226]
" 0.00024418144222: 0.00000472833083:0.800:190: 2.93", -- [227]
" 0.00023755731878: 0.00002066182062:0.800:183: 2.13", -- [228]
" 0.00022817519601: 0.00003091885077:0.800:179: 1.54", -- [229]
" 0.00021679844870: 0.00003723560523:0.801:166: 1.09", -- [230]
" 0.00020283607700: 0.00003985835123:0.799:156: 0.74", -- [231]
" 0.00018852895539: 0.00004012924519:0.800:145: 0.46", -- [232]
" 0.00017308908404: 0.00003862701508:0.800:132: 0.25", -- [233]
" 0.00015735371277: 0.00003584419537:0.801:119: 0.07", -- [234]
" 0.00014090421665: 0.00003217481365:0.799:107:-0.05", -- [235]
" 0.00012502109542: 0.00002822222460:0.800: 93:-0.16", -- [236]
" 0.00010894097422: 0.00002414650193:0.800: 80:-0.22", -- [237]
" 0.00009357497786: 0.00002005846591:0.800: 68:-0.25", -- [238]
" 0.00007811048151: 0.00001637677082:0.800: 57:-0.27", -- [239]
" 0.00006306461008: 0.00001276895590:0.800: 45:-0.25", -- [240]
" 0.00004836348856: 0.00000946897500:0.800: 33:-0.21", -- [241]
" 0.00003393324197: 0.00000651376825:0.801: 22:-0.17", -- [242]
" 0.00001974924532: 0.00000368169509:0.799: 11:-0.10", -- [243]
" 0.00000590999861: 0.00000105894909:0.748:  2:-0.03", -- [244]
},
["org2uc"] = {
" 0.30112819963795: 0.44814549021832:60.00:  3:-95.35:plat1", -- [1]
"-0.00000515867899: 0.00000085630196:0.801:  7:-0.08", -- [2]
"-0.00001536281495: 0.00000260605950:0.800: 16:-0.23", -- [3]
"-0.00002632412326: 0.00000460527689:0.801: 25:-0.36", -- [4]
"-0.00003842472830: 0.00000705564513:0.800: 35:-0.45", -- [5]
"-0.00005220951113: 0.00001012170154:0.800: 47:-0.52", -- [6]
"-0.00006750156230: 0.00001389721476:0.800: 59:-0.56", -- [7]
"-0.00008442825661: 0.00001850249165:0.799: 73:-0.58", -- [8]
"-0.00010368307902: 0.00002420114585:0.801: 89:-0.60", -- [9]
"-0.00012341909510: 0.00003063225670:0.799:107:-0.60", -- [10]
"-0.00014425902600: 0.00003804882247:0.800:122:-0.63", -- [11]
"-0.00016545277578: 0.00004640307431:0.800:141:-0.65", -- [12]
"-0.00018467929268: 0.00005516070804:0.800:152:-0.71", -- [13]
"-0.00020216502080: 0.00006456233749:0.800:166:-0.80", -- [14]
"-0.00021441422976: 0.00007376935283:0.801:175:-0.96", -- [15]
"-0.00022010363705: 0.00008261898597:0.799:179:-1.22", -- [16]
"-0.00021582950520: 0.00009036462647:0.800:173:-1.69", -- [17]
"-0.00019876835973: 0.00009659050792:0.801:154:-2.63", -- [18]
"-0.00016134847699: 0.00009890110784:0.799:120:-4.80", -- [19]
"-0.00023284465423: 0.00023986362673:0.801:182:-18.26", -- [20]
"-0.00007437626277: 0.00023137668348:0.799:120:-29.42", -- [21]
" 0.00000359479962: 0.00026768282531:0.800:166:-22.18", -- [22]
" 0.00005262701739: 0.00030343697083:0.800:183:-15.71", -- [23]
" 0.00013613180677: 0.00037217466500:0.801:241:-13.26", -- [24]
" 0.00021358275544: 0.00035960259522:0.800:250:-14.61", -- [25]
" 0.00024301694648: 0.00020209434085:0.799:191:-21.01", -- [26]
" 0.00028147705667: 0.00009144208080:0.800:251:-13.11", -- [27]
" 0.00035983378164: 0.00002952118720:0.800:305:-8.25", -- [28]
" 0.00041263770844:-0.00003193970949:0.800:332:-5.39", -- [29]
" 0.00036252988135:-0.00008469958743:0.800:261:-7.66", -- [30]
" 0.00033963780105:-0.00015117445059:0.800:295:-5.50", -- [31]
" 0.00040101122067:-0.00019602591988:0.800:356: 0.44", -- [32]
" 0.00050821833555:-0.00019921582163:0.801:453: 4.91", -- [33]
" 0.00047038094656:-0.00012426993820:0.799:322: 3.44", -- [34]
" 0.00044274769352:-0.00009747865582:0.801:372: 1.10", -- [35]
" 0.00049696689577:-0.00009821818934:0.800:414: 0.74", -- [36]
" 0.00053562514453:-0.00009772457726:0.800:435: 0.48", -- [37]
" 0.00055649338095:-0.00009616235693:0.799:445: 0.30", -- [38]
" 0.00055505687637:-0.00009315291552:0.800:432: 0.11", -- [39]
" 0.00052717595013:-0.00009067777823:0.801:404:-0.34", -- [40]
" 0.00050712149708:-0.00008950832450:0.799:392: 0.05", -- [41]
" 0.00050994497160:-0.00008446958898:0.801:403: 0.64", -- [42]
" 0.00052755807449:-0.00007430542617:0.799:425: 1.11", -- [43]
" 0.00056956344968:-0.00006053028752:0.801:466: 1.42", -- [44]
" 0.00038351841618:-0.00002865957758:0.500:492: 0.96", -- [45]
" 0.40726137274277:-0.12970612499599:1.600:273:17.84:zone1", -- [46]
" 0.00027251736711: 0.00010358464480:0.399:439:-1.59", -- [47]
" 0.00052930525166: 0.00016910902394:0.800:417:-2.80", -- [48]
" 0.00050805442442: 0.00012861140139:0.801:395:-2.16", -- [49]
" 0.00047869393317: 0.00009953246333:0.799:371:-1.34:trig1", -- [50]
" 0.00045369971889: 0.00008439423912:0.800:352:-0.48", -- [51]
" 0.00043160224514: 0.00008117668608:0.800:336: 0.42", -- [52]
" 0.00048370728997: 0.00009688342529:0.800:414:-0.01", -- [53]
" 0.00049326230050: 0.00008625703299:0.801:373:-1.27", -- [54]
" 0.00044787600044: 0.00005914975338:0.799:341:-1.81", -- [55]
" 0.00041383476351: 0.00003122598944:0.800:316:-2.31", -- [56]
" 0.00038710492390: 0.00000286676719:0.800:298:-2.71", -- [57]
" 0.00036855731800:-0.00002529287001:0.800:283:-2.95", -- [58]
" 0.00035607532954:-0.00005292632840:0.800:276:-3.04", -- [59]
" 0.00035461184058:-0.00008118878214:0.800:285:-2.95", -- [60]
" 0.00036330810967:-0.00010976573355:0.800:291:-2.60", -- [61]
" 0.00035512587596:-0.00013103666223:0.801:284:-2.37", -- [62]
" 0.00033873117116:-0.00014680388178:0.800:275:-2.25", -- [63]
" 0.00031641598832:-0.00015775686780:0.799:255:-2.27", -- [64]
" 0.00029078678916:-0.00016512941886:0.801:236:-2.37", -- [65]
" 0.00026088202515:-0.00016826834749:0.800:212:-2.56", -- [66]
" 0.00022940491764:-0.00016836511600:0.800:191:-2.85", -- [67]
" 0.00019673645756:-0.00016541972440:0.799:168:-3.24", -- [68]
" 0.00016446108333:-0.00016026075307:0.800:144:-3.76", -- [69]
" 0.00019319263719:-0.00021753561651:0.801:179:-4.18", -- [70]
" 0.00015553501019:-0.00020722372188:0.799:155:-4.70", -- [71]
" 0.00012443889362:-0.00019824844233:0.800:134:-4.96", -- [72]
" 0.00010070860161:-0.00019211573783:0.800:122:-4.87", -- [73]
" 0.00008236660985:-0.00018695676651:0.801:114:-4.49", -- [74]
" 0.00006810666375:-0.00018168288256:0.799:107:-3.91", -- [75]
" 0.00005736634810:-0.00017704404199:0.800: 99:-3.28", -- [76]
" 0.00004871845881:-0.00017093552962:0.801: 96:-2.65", -- [77]
" 0.00004129820695:-0.00016170623272:0.799: 87:-2.09", -- [78]
" 0.00003515397233:-0.00015083791915:0.801: 80:-1.62", -- [79]
" 0.00002970519733:-0.00013734475965:0.800: 72:-1.24", -- [80]
" 0.00002464950820:-0.00012093040070:0.800: 63:-0.93", -- [81]
" 0.00001988409789:-0.00010215126120:0.799: 51:-0.67", -- [82]
" 0.00001543315626:-0.00008199317040:0.801: 39:-0.48", -- [83]
" 0.00001090359748:-0.00005937353057:0.799: 27:-0.32", -- [84]
" 0.00000653127303:-0.00003608255916:0.801: 14:-0.18", -- [85]
" 0.00000208033140:-0.00001161222152:0.797:  2:-0.06", -- [86]
" 0.00000000604748: 0.00000000000000:60.00:  0: 0.00:plat2", -- [87]
" 0.00000137277683:-0.00000810436294:0.801:  8:-0.11", -- [88]
" 0.00000397319109:-0.00002372038167:0.800: 16:-0.32", -- [89]
" 0.00000641637101:-0.00003950574531:0.800: 25:-0.52", -- [90]
" 0.00000860555696:-0.00005547254989:0.800: 34:-0.72", -- [91]
" 0.00001046817927:-0.00007186876476:0.801: 42:-0.89", -- [92]
" 0.00001188328842:-0.00008854318911:0.800: 51:-1.06", -- [93]
" 0.00001282064706:-0.00010562283159:0.799: 59:-1.18", -- [94]
" 0.00001333468243:-0.00012417214587:0.800: 70:-1.28", -- [95]
" 0.00001326211273:-0.00014319925468:0.800: 80:-1.34", -- [96]
" 0.00001272388746:-0.00016364765101:0.800: 92:-1.35", -- [97]
" 0.00001172605408:-0.00018563829551:0.800:103:-1.31", -- [98]
" 0.00001035932472:-0.00020951592603:0.801:114:-1.22", -- [99]
" 0.00000875674383:-0.00023564342444:0.799:130:-1.08", -- [100]
" 0.00000709973568:-0.00026440786485:0.801:146:-0.89", -- [101]
" 0.00000559391440:-0.00029626889764:0.799:163:-0.65", -- [102]
" 0.00000457189112:-0.00033213372766:0.801:183:-0.40", -- [103]
" 0.00000434208707:-0.00037081089257:0.799:205:-0.11", -- [104]
" 0.00000537620530:-0.00041558447378:0.800:229: 0.20", -- [105]
" 0.00000814594886:-0.00046475497428:0.800:254: 0.49", -- [106]
" 0.00001327420768:-0.00052200564561:0.800:288: 0.78", -- [107]
" 0.00002015623426:-0.00055295342557:0.800:192: 1.13", -- [108]
" 0.00002111778280:-0.00038746112478:0.800:214: 1.45", -- [109]
" 0.00002913673467:-0.00042896876869:0.801:236: 1.06", -- [110]
" 0.00003632718248:-0.00046971436056:0.800:258: 0.71", -- [111]
" 0.00004228999286:-0.00050987934136:0.799:277: 0.38", -- [112]
" 0.00004663812740:-0.00054920969373:0.800:297: 0.06", -- [113]
" 0.00004890593054:-0.00058772356178:0.800:319:-0.26", -- [114]
" 0.00004813790121:-0.00061980232374:0.800:332:-0.60", -- [115]
" 0.00004415866264:-0.00065030254932:0.800:345:-0.98", -- [116]
" 0.00003585547943:-0.00067233855408:0.800:358:-1.42", -- [117]
" 0.00002270222125:-0.00068844748742:0.801:360:-1.96:trig2", -- [118]
" 0.00000380990926:-0.00069263272559:0.799:368:-2.63", -- [119]
"-0.00002148063129:-0.00068727416920:0.800:359:-3.52", -- [120]
"-0.00005425794593:-0.00067098984293:0.801:349:-4.71", -- [121]
"-0.00001932773019:-0.00016094418069:0.199:343:-1.40", -- [122]
"-0.41909014307501: 0.14534298382161:2.000:272:-74.59:zone2", -- [123]
"-0.00011072407436:-0.00001750819061:0.200:347: 0.83", -- [124]
"-0.00041821389370:-0.00008656611341:0.801:318: 2.85", -- [125]
"-0.00038322120834:-0.00010389915135:0.800:295: 2.08", -- [126]
"-0.00034804453718:-0.00010985434230:0.800:271: 1.35", -- [127]
"-0.00031404962102:-0.00010685374697:0.799:242: 0.64", -- [128]
"-0.00028221299991:-0.00009724688814:0.801:214:-0.09", -- [129]
"-0.00025017116385:-0.00008185468338:0.800:191:-0.87", -- [130]
"-0.00022027347010:-0.00006307265514:0.799:166:-1.70", -- [131]
"-0.00024260651661:-0.00005455209673:0.801:353:-1.91", -- [132]
"-0.00037802007108:-0.00009045485664:0.799:258: 1.15", -- [133]
"-0.00027645282885:-0.00007555626396:0.801:192: 1.20", -- [134]
"-0.00020984289008:-0.00006363172833:0.800:151: 0.92", -- [135]
"-0.00017080251695:-0.00005405848464:0.799:129: 0.26", -- [136]
"-0.00015246762358:-0.00004667553402:0.801:120:-0.50", -- [137]
"-0.00014771229809:-0.00004134664658:0.800:118:-0.99", -- [138]
"-0.00018239362284:-0.00005820376462:0.799:151: 2.92", -- [139]
"-0.00016204196196:-0.00007298912729:0.800:119: 3.97", -- [140]
"-0.00012520941853:-0.00006252065883:0.800: 94: 0.95", -- [141]
"-0.00010245886577:-0.00004543354232:0.800: 78:-2.01", -- [142]
"-0.00009001151823:-0.00002920095857:0.800: 69:-3.84", -- [143]
"-0.00008466885344:-0.00001668550381:0.801: 66:-4.35", -- [144]
"-0.00008137126165:-0.00000723610545:0.799: 63:-3.97", -- [145]
"-0.00007756417071:-0.00000034499769:0.800: 59:-3.24", -- [146]
"-0.00007108220917: 0.00000427620217:0.801: 52:-2.46", -- [147]
"-0.00006038272682: 0.00000647887975:0.800: 42:-1.77", -- [148]
"-0.00004599645193: 0.00000648064897:0.800: 30:-1.17", -- [149]
"-0.00002858856397: 0.00000460527689:0.800: 16:-0.67", -- [150]
"-0.00000943988721: 0.00000162768143:0.780:  2:-0.21", -- [151]
},
["ratch2bb"] = {
" 0.28284660925565: 0.52613021611629:60.00:  4:29.01:plat1", -- [1]
" 0.00000660452879:-0.00001703639829:0.801: 15: 0.07", -- [2]
" 0.00001354809908:-0.00003544276175:0.800: 26: 0.14", -- [3]
" 0.00002076290261:-0.00005415431544:0.800: 37: 0.23", -- [4]
" 0.00002845236425:-0.00007361867178:0.800: 50: 0.32", -- [5]
" 0.00003667073067:-0.00009325257826:0.801: 62: 0.43", -- [6]
" 0.00004541800185:-0.00011249312841:0.799: 74: 0.57", -- [7]
" 0.00005473486279:-0.00013203208680:0.800: 88: 0.73", -- [8]
" 0.00006413309368:-0.00015066225644:0.800: 97: 0.94", -- [9]
" 0.00007391105109:-0.00016895332579:0.801:111: 1.23", -- [10]
" 0.00008408229664:-0.00018433491469:0.799:122: 1.61", -- [11]
" 0.00009476888532:-0.00019382294066:0.800:128: 2.16", -- [12]
" 0.00010583520049:-0.00019697657330:0.801:133: 2.98", -- [13]
" 0.00011554534959:-0.00018870930837:0.799:133: 4.29", -- [14]
" 0.00014794415711:-0.00020679691755:0.800:172: 3.45", -- [15]
" 0.00016862568976:-0.00020653241932:0.800:172: 4.97", -- [16]
" 0.00018727297329:-0.00017492827280:0.801:175: 8.83", -- [17]
" 0.00021984808241:-0.00012479568673:0.799:195:12.18", -- [18]
" 0.00026222827226:-0.00005515805229:0.801:177:11.77", -- [19]
" 0.00021544054266:-0.00001493397653:0.799:174: 2.15", -- [20]
" 0.00023830550270: 0.00001308927098:0.800:199: 6.13", -- [21]
" 0.00027424390367: 0.00007509714902:0.800:237: 8.81", -- [22]
" 0.00032755479209: 0.00017520633504:0.800:303: 9.29", -- [23]
" 0.00037808554003: 0.00030060562027:0.800:220: 7.71", -- [24]
" 0.00022094657693: 0.00021956065226:0.800:221: 3.37", -- [25]
" 0.00024773085692: 0.00027245351464:0.801:258: 2.39", -- [26]
" 0.00027296910756: 0.00032219952640:0.800:287: 1.63", -- [27]
" 0.00029837009815: 0.00036807301289:0.800:318: 1.03", -- [28]
" 0.00032398807531: 0.00040920587741:0.799:345: 0.53", -- [29]
" 0.00034860248957: 0.00044304808581:0.801:370: 0.07:trig1", -- [30]
" 0.00037069443492: 0.00046625610928:0.800:389:-0.40", -- [31]
" 0.00034106220619: 0.00041806995885:0.700:401:-0.76", -- [32]
" 0.42449500010526: 0.34292455124769:1.399:101:-43.18:zone1", -- [33]
" 0.00011668180945:-0.00001673364111:0.201:365:-0.87", -- [34]
" 0.00043131376337:-0.00008377721948:0.799:327:-2.88", -- [35]
" 0.00038747629852:-0.00010045635362:0.800:294:-1.77", -- [36]
" 0.00035481629672:-0.00010383578602:0.802:274:-0.52", -- [37]
" 0.00032760871591:-0.00009516917711:0.798:256: 0.78", -- [38]
" 0.00031029727923:-0.00007827201508:0.801:237: 2.03", -- [39]
" 0.00033333375797:-0.00005837696947:0.800:311: 3.53", -- [40]
" 0.00037564454495:-0.00002916123124:0.799:286: 3.33", -- [41]
" 0.00034609242311:-0.00000779449733:0.801:262: 1.33", -- [42]
" 0.00031482278866:-0.00000583224624:0.800:235:-0.66", -- [43]
" 0.00028404387211:-0.00001842335731:0.800:212:-2.66", -- [44]
" 0.00025334674186:-0.00004169783534:0.799:192:-4.71", -- [45]
" 0.00022417628951:-0.00007211272698:0.800:173:-6.71", -- [46]
" 0.00019606905924:-0.00010568902315:0.800:157:-8.47", -- [47]
" 0.00018930805719:-0.00015043924904:0.800:172:-7.56", -- [48]
" 0.00017455925839:-0.00017649358275:0.801:159:-6.13", -- [49]
" 0.00015160456596:-0.00018761300551:0.799:151:-5.45", -- [50]
" 0.00013153965668:-0.00019366327965:0.801:140:-4.82", -- [51]
" 0.00011305594948:-0.00019344525176:0.799:130:-4.24", -- [52]
" 0.00009691678331:-0.00018973877750:0.801:120:-3.70", -- [53]
" 0.00008197714977:-0.00018134470347:0.799:109:-3.24", -- [54]
" 0.00007011813409:-0.00017038880163:0.801:100:-2.81", -- [55]
" 0.00005763208999:-0.00015736163477:0.799: 90:-2.43", -- [56]
" 0.00004669998588:-0.00014291728659:0.800: 79:-2.07", -- [57]
" 0.00003732182176:-0.00012618364548:0.801: 67:-1.75", -- [58]
" 0.00002947033552:-0.00010754226028:0.799: 56:-1.44", -- [59]
" 0.00002265480926:-0.00008797425650:0.801: 44:-1.15", -- [60]
" 0.00001654809774:-0.00006742512720:0.799: 32:-0.87", -- [61]
" 0.00001109567674:-0.00004671247696:0.801: 21:-0.59", -- [62]
" 0.00000594313890:-0.00002540025002:0.799:  9:-0.32", -- [63]
" 0.00000128131893:-0.00000479661374:0.801:  0:-0.07", -- [64]
" 0.00000005452421: 0.00000016352092:0.732:  0: 0.00", -- [65]
"-0.00000185382314:-0.00001580702254:60.00:  0:-0.21:plat2", -- [66]
" 0.00000602492521:-0.00003008784981:0.801: 21:-0.47", -- [67]
" 0.00000962352307:-0.00004812965830:0.800: 31:-0.73", -- [68]
" 0.00001294949988:-0.00006720709930:0.801: 41:-0.96", -- [69]
" 0.00001583928301:-0.00008759270768:0.800: 52:-1.15", -- [70]
" 0.00001774763036:-0.00010901394858:0.799: 63:-1.30", -- [71]
" 0.00001902894930:-0.00013223391963:0.801: 76:-1.42", -- [72]
" 0.00001938335666:-0.00015588994647:0.799: 88:-1.52", -- [73]
" 0.00001930157035:-0.00018123568951:0.800:102:-1.60", -- [74]
" 0.00002088277244:-0.00020887072548:0.801:117:-1.67", -- [75]
" 0.00001962871560:-0.00023639674750:0.800:131:-1.74", -- [76]
" 0.00001671167038:-0.00026381375556:0.800:145:-1.83", -- [77]
" 0.00001215889883:-0.00028975907533:0.799:158:-1.95", -- [78]
" 0.00000591587679:-0.00031434172073:0.801:168:-2.11", -- [79]
"-0.00000245358945:-0.00033538141281:0.800:180:-2.36", -- [80]
"-0.00001297676199:-0.00034944421217:0.799:185:-2.71", -- [81]
"-0.00002608983449:-0.00035881941175:0.800:191:-3.27", -- [82]
"-0.00004198364172:-0.00035723870950:0.801:189:-4.14", -- [83]
"-0.00006477476151:-0.00038890726156:0.800:214:-3.44", -- [84]
"-0.00008693885288:-0.00040863878625:0.799:229:-3.77", -- [85]
"-0.00011311047368:-0.00042139341824:0.800:246:-4.35", -- [86]
"-0.00014323509973:-0.00042444580880:0.801:254:-5.12", -- [87]
"-0.00017720368257:-0.00041561567896:0.799:264:-6.07", -- [88]
"-0.00021662468642:-0.00039512105663:0.800:270:-7.25", -- [89]
"-0.00026076203443:-0.00035827434201:0.800:281:-8.59", -- [90]
"-0.00027395689325:-0.00029117625666:0.800:276:-5.01", -- [91]
"-0.00032172010123:-0.00028643414989:0.801:304:-4.72", -- [92]
"-0.00036752043765:-0.00026386826254:0.800:330:-5.43", -- [93]
"-0.00040495130783:-0.00021492099963:0.799:344:-6.68", -- [94]
"-0.00043305853810:-0.00013550433808:0.801:350:-8.70", -- [95]
"-0.00044516291272:-0.00001918645495:0.799:356:-11.56", -- [96]
"-0.00039879007210: 0.00010672465566:0.800:306:-10.73", -- [97]
"-0.00039110215848: 0.00019742426088:0.801:337:-7.35", -- [98]
"-0.00041449304459: 0.00028954104743:0.800:372:-5.99", -- [99]
"-0.00043240424757: 0.00037909600619:0.799:410:-4.96", -- [100]
"-0.00044633518324: 0.00046429040700:0.801:436:-4.24", -- [101]
"-0.00045173308003: 0.00054070918496:0.799:470:-3.74", -- [102]
"-0.00028115408898: 0.00037190108558:0.500:474:-2.17", -- [103]
"-0.42374980273295:-0.32769285533703:1.501:157:66.48:zone2", -- [104]
"-0.00034669029540:-0.00022082210532:0.599:394:-2.33", -- [105]
"-0.00045179316621:-0.00026409808363:0.800:377:-1.44", -- [106]
"-0.00044442918443:-0.00025562735853:0.800:378: 0.45", -- [107]
"-0.00044158123566:-0.00027261628278:0.800:379: 2.04", -- [108]
"-0.00042225586910:-0.00028317586564:0.800:359: 0.52", -- [109]
"-0.00042392395337:-0.00027744507084:0.800:363:-0.43:trig2", -- [110]
"-0.00042480546132:-0.00027452880839:0.800:355:-0.05", -- [111]
"-0.00041418668095:-0.00026872341151:0.801:344: 0.26", -- [112]
"-0.00038985706157:-0.00025705157972:0.800:322: 0.57", -- [113]
"-0.00035771592559:-0.00024320950611:0.800:293: 0.92", -- [114]
"-0.00031827861613:-0.00022686487238:0.799:266: 1.35", -- [115]
"-0.00027494911003:-0.00020980134607:0.801:224: 1.97", -- [116]
"-0.00034080453464:-0.00028561738769:0.800:341: 2.43", -- [117]
"-0.00033421356751:-0.00030794375043:0.800:284: 2.94", -- [118]
"-0.00027197910633:-0.00028347427390:0.800:239: 3.71", -- [119]
"-0.00021811218984:-0.00026329102495:0.799:206: 4.51", -- [120]
"-0.00017384692915:-0.00024863511066:0.800:177: 5.24", -- [121]
"-0.00013702702021:-0.00023752618533:0.801:154: 5.83", -- [122]
"-0.00013237537058:-0.00032797101324:0.799:206:13.21", -- [123]
"-0.00006399747707:-0.00034424104489:0.800:177:15.82", -- [124]
"-0.00000820480476:-0.00032383398977:0.800:166:11.41", -- [125]
" 0.00002088495756:-0.00031087357688:0.801:161: 5.86", -- [126]
" 0.00003138168297:-0.00030044963414:0.799:160: 1.32", -- [127]
" 0.00003616894922:-0.00025228382972:0.801:130: 4.97", -- [128]
" 0.00004897115697:-0.00023530846948:0.800:127: 4.19", -- [129]
" 0.00005573842568:-0.00021945892217:0.799:120: 3.02", -- [130]
" 0.00005857281277:-0.00020161546520:0.800:113: 2.19", -- [131]
" 0.00005965774564:-0.00017930266647:0.800:101: 1.61", -- [132]
" 0.00005630801543:-0.00015907194349:0.800: 90: 1.16", -- [133]
" 0.00005073417287:-0.00013931596092:0.801: 78: 0.85", -- [134]
" 0.00004395334249:-0.00011872579163:0.799: 66: 0.60", -- [135]
" 0.00003696908720:-0.00009886129697:0.800: 54: 0.42", -- [136]
" 0.00002988990029:-0.00007866448402:0.800: 42: 0.28", -- [137]
" 0.00002266153511:-0.00005858296516:0.800: 31: 0.18", -- [138]
" 0.00001540604662:-0.00003902366075:0.800: 19: 0.10", -- [139]
" 0.00000820480475:-0.00001976954659:0.801:  7: 0.06", -- [140]
" 0.00000154602933:-0.00000233300996:0.785:  0: 0.00", -- [141]
},
["mh2thera"] = {
" 0.74464893122936: 0.51774278871174:60.00:  1:-29.27:plat1", -- [1]
"-0.00000368038418:-0.00000997477630:0.801: 11: 0.00", -- [2]
"-0.00001022328938:-0.00002790757083:0.800: 21:-0.02", -- [3]
"-0.00001679345668:-0.00004584036538:0.801: 32:-0.04", -- [4]
"-0.00002341814821:-0.00006377315992:0.800: 43:-0.09", -- [5]
"-0.00003017915025:-0.00008154243354:0.799: 53:-0.18", -- [6]
"-0.00003721277334:-0.00009952973505:0.800: 65:-0.30", -- [7]
"-0.00004465532800:-0.00011735351565:0.801: 75:-0.49", -- [8]
"-0.00005245229004:-0.00013452321255:0.799: 87:-0.72", -- [9]
"-0.00006120342575:-0.00015147488155:0.800: 97:-1.03", -- [10]
"-0.00007104504566:-0.00016744542502:0.800:108:-1.41", -- [11]
"-0.00008254965397:-0.00018248934992:0.801:122:-1.89", -- [12]
"-0.00009568998859:-0.00019508046099:0.799:131:-2.43", -- [13]
"-0.00011158379581:-0.00020570932097:0.800:145:-3.07", -- [14]
"-0.00013118524931:-0.00021393987409:0.801:157:-3.78", -- [15]
"-0.00015408541752:-0.00021721029254:0.799:172:-4.50", -- [16]
"-0.00018279241410:-0.00021688325070:0.800:193:-5.21", -- [17]
"-0.00021725171483:-0.00021001537194:0.801:215:-5.80", -- [18]
"-0.00021782421904:-0.00017115189927:0.800:168:-3.86", -- [19]
"-0.00020839153070:-0.00014962164443:0.800:191:-1.49", -- [20]
"-0.00023895235042:-0.00015932388585:0.799:216:-1.74", -- [21]
"-0.00027000388803:-0.00016412049959:0.800:239:-2.07", -- [22]
"-0.00029939243723:-0.00016144965784:0.801:256:-2.50", -- [23]
"-0.00032654549382:-0.00014956713746:0.799:276:-3.08", -- [24]
"-0.00035007269044:-0.00012612913850:0.800:289:-3.84", -- [25]
"-0.00036921068816:-0.00008890087507:0.801:298:-4.91", -- [26]
"-0.00038052446174:-0.00003461192868:0.799:303:-6.34", -- [27]
"-0.00038507723328: 0.00003913600754:0.801:302:-8.30", -- [28]
"-0.00035094507780: 0.00011479168786:0.800:263:-7.31", -- [29]
"-0.00032049330651: 0.00015621698832:0.800:266:-5.21", -- [30]
"-0.00032136569387: 0.00020778058599:0.800:283:-5.34", -- [31]
"-0.00032859015169: 0.00026768375074:0.800:302:-4.99", -- [32]
"-0.00034331168840: 0.00033641704532:0.799:332:-4.34", -- [33]
"-0.00036839282501: 0.00041637877660:0.800:380:-3.44:trig1", -- [34]
"-0.00040533297730: 0.00050882260500:0.801:437:-2.53", -- [35]
"-0.00045331428212: 0.00061140473061:0.800:517:-1.66", -- [36]
"-0.00038038815122: 0.00053400482712:0.600:575:-0.76", -- [37]
"-0.43317186355262: 0.11771111458249:1.499:201:68.56:zone1", -- [38]
"-0.00010687247471:-0.00007614582762:0.201:368: 0.07", -- [39]
"-0.00036238141425:-0.00026690442425:0.799:284: 1.78", -- [40]
"-0.00028530518249:-0.00024227770121:0.801:238: 4.76", -- [41]
"-0.00023388819465:-0.00025360599382:0.800:219: 7.29", -- [42]
"-0.00020394420174:-0.00029217144208:0.800:223: 7.75", -- [43]
"-0.00020034895259:-0.00037319336087:0.799:280: 7.74", -- [44]
"-0.00017941770755:-0.00045672720540:0.801:274: 8.37", -- [45]
"-0.00013553596793:-0.00047756141308:0.800:269: 6.78", -- [46]
"-0.00009687472707:-0.00047869424235:0.799:253: 5.73", -- [47]
"-0.00006363098494:-0.00046726744286:0.801:241: 5.08", -- [48]
"-0.00003432724188:-0.00044145863712:0.799:225: 4.73", -- [49]
"-0.00000935749779:-0.00040737525244:0.801:201: 4.65", -- [50]
" 0.00001177074722:-0.00036738145423:0.800:182: 4.80", -- [51]
" 0.00003447499184:-0.00034231145018:0.800:180: 7.00", -- [52]
" 0.00006175948539:-0.00032472796994:0.800:173: 6.81", -- [53]
" 0.00008047448095:-0.00030059378136:0.800:167: 5.32", -- [54]
" 0.00009190047826:-0.00027665660657:0.799:160: 4.11", -- [55]
" 0.00009746572693:-0.00025296569901:0.800:146: 3.14", -- [56]
" 0.00009899247658:-0.00023109716896:0.801:138: 2.38", -- [57]
" 0.00009633297720:-0.00020814506309:0.799:127: 1.79", -- [58]
" 0.00009150647835:-0.00018706458817:0.800:115: 1.32", -- [59]
" 0.00008461147998:-0.00016623038048:0.800:105: 0.94", -- [60]
" 0.00007682998182:-0.00014672601584:0.801: 92: 0.67", -- [61]
" 0.00006796498391:-0.00012741866498:0.801: 79: 0.43", -- [62]
" 0.00005860748614:-0.00010860384859:0.799: 67: 0.27", -- [63]
" 0.00004929923833:-0.00009072484766:0.800: 56: 0.15", -- [64]
" 0.00004004024052:-0.00007338763464:0.801: 44: 0.07", -- [65]
" 0.00003068274274:-0.00005614892852:0.799: 33: 0.01", -- [66]
" 0.00002157149490:-0.00003959977064:0.799: 22:-0.01", -- [67]
" 0.00001260799702:-0.00002319837310:0.801: 11:-0.01", -- [68]
" 0.00000369374912:-0.00000669846866:0.777:  1: 0.00", -- [69]
" 0.00000000000000:-0.00000004925345:60.00:  0: 0.00:plat2", -- [70]
" 0.00000492499884:-0.00000896412718:0.801: 11: 0.09", -- [71]
" 0.00001403624668:-0.00002531627128:0.802: 22: 0.24", -- [72]
" 0.00002319674451:-0.00004142214815:0.798: 33: 0.40", -- [73]
" 0.00003270199226:-0.00005752802501:0.802: 44: 0.55", -- [74]
" 0.00004235498998:-0.00007284584673:0.798: 55: 0.69", -- [75]
" 0.00005284523749:-0.00008855769604:0.802: 66: 0.83", -- [76]
" 0.00006343398499:-0.00010303820917:0.798: 78: 0.93", -- [77]
" 0.00007476148231:-0.00011732170854:0.800: 89: 1.04", -- [78]
" 0.00008663072950:-0.00013091565965:0.801:100: 1.14", -- [79]
" 0.00009899247657:-0.00014372155563:0.799:113: 1.20", -- [80]
" 0.00011194522352:-0.00015554238269:0.800:127: 1.27", -- [81]
" 0.00012524272036:-0.00016642739427:0.801:134: 1.32", -- [82]
" 0.00013893421712:-0.00017622883003:0.800:147: 1.35", -- [83]
" 0.00015292121382:-0.00018470042276:0.800:160: 1.37", -- [84]
" 0.00016695746049:-0.00019208843967:0.801:167: 1.39", -- [85]
" 0.00018000870740:-0.00019681677050:0.798:179: 1.38", -- [86]
" 0.00019379870414:-0.00020149584787:0.800:188: 1.39", -- [87]
" 0.00020645595115:-0.00020504209598:0.800:198: 0.96", -- [88]
" 0.00021404044935:-0.00020499284254:0.801:198: 1.17", -- [89]
" 0.00022433369692:-0.00020243166335:0.801:207: 1.83", -- [90]
" 0.00023999519321:-0.00019804810664:0.798:222: 2.48", -- [91]
" 0.00026555593716:-0.00019455111198:0.800:239: 3.01", -- [92]
" 0.00030057267887:-0.00019006904838:0.801:267: 3.28", -- [93]
" 0.00034903466741:-0.00018598101236:0.799:307: 3.28", -- [94]
" 0.00034519316832:-0.00015475432755:0.801:237: 2.70", -- [95]
" 0.00030825567705:-0.00011766648266:0.800:255: 1.99", -- [96]
" 0.00033849516990:-0.00011224860359:0.800:280: 1.69", -- [97]
" 0.00036932566261:-0.00010717549864:0.800:310: 1.39", -- [98]
" 0.00040133815503:-0.00010318596952:0.799:332: 1.10", -- [99]
" 0.00043620714678:-0.00010111732478:0.801:355: 0.83:trig2", -- [100]
" 0.00046959863888:-0.00010028001620:0.799:379: 0.56", -- [101]
" 0.00050742262993:-0.00010264418161:0.800:415: 0.30", -- [102]
" 0.00013322121847:-0.00002639984709:0.201:423: 0.04", -- [103]
" 0.43104645901731:-0.09569409238289:1.200:426:-4.55:zone2", -- [104]
" 0.00014146306291:-0.00004736656066:0.199:454:-0.81", -- [105]
" 0.00053594572240:-0.00020799861389:0.800:422:-3.03", -- [106]
" 0.00048848239759:-0.00022887478505:0.800:389:-2.66", -- [107]
" 0.00044235491590:-0.00023939463108:0.800:356:-2.33", -- [108]
" 0.00039761780158:-0.00024102984031:0.800:324:-2.01", -- [109]
" 0.00035451641356:-0.00023503407314:0.801:285:-1.69", -- [110]
" 0.00031345968342:-0.00022304253879:0.800:259:-1.39", -- [111]
" 0.00044625339692:-0.00036339799760:0.799:378:-5.18", -- [112]
" 0.00035626118828:-0.00037059291819:0.801:319:-7.02", -- [113]
" 0.00027392963115:-0.00037566206681:0.800:277:-7.97", -- [114]
" 0.00021381668960:-0.00038841669879:0.799:258:-7.73", -- [115]
" 0.00017371413313:-0.00040956540482:0.800:249:-6.34", -- [116]
" 0.00014331688604:-0.00043502016181:0.800:254:-7.25", -- [117]
" 0.00010016097381:-0.00045971182116:0.800:252:-7.66", -- [118]
" 0.00006436582993:-0.00047181236946:0.800:248:-5.71", -- [119]
" 0.00003639491019:-0.00046777885335:0.800:244:-4.33", -- [120]
" 0.00001534856512:-0.00045240788661:0.800:231:-3.32", -- [121]
" 0.00000000000000:-0.00042989650623:0.800:219:-2.60", -- [122]
"-0.00001060495885:-0.00039926358667:0.801:200:-2.05", -- [123]
"-0.00001799298931:-0.00036574179749:0.800:186:-2.03", -- [124]
"-0.00002633519344:-0.00034426604962:0.800:177:-2.37", -- [125]
"-0.00003372322389:-0.00032551565046:0.799:167:-2.24", -- [126]
"-0.00003974814911:-0.00030583863274:0.801:159:-2.12", -- [127]
"-0.00004381020275:-0.00028261866169:0.799:148:-2.02", -- [128]
"-0.00004683629641:-0.00026076136501:0.800:135:-1.94", -- [129]
"-0.00004828118798:-0.00023726885908:0.801:125:-1.85", -- [130]
"-0.00004841749849:-0.00021350381830:0.800:113:-1.74", -- [131]
"-0.00004727249009:-0.00018995680540:0.799:101:-1.63", -- [132]
"-0.00004520057011:-0.00016744542502:0.800: 90:-1.52", -- [133]
"-0.00004214721435:-0.00014515207253:0.800: 79:-1.38", -- [134]
"-0.00003811242280:-0.00012356731072:0.800: 66:-1.24", -- [135]
"-0.00003336881654:-0.00010269113956:0.800: 55:-1.07", -- [136]
"-0.00002802544395:-0.00008257806605:0.801: 43:-0.89", -- [137]
"-0.00002205504295:-0.00006279203438:0.799: 33:-0.69", -- [138]
"-0.00001570297249:-0.00004366008641:0.801: 21:-0.50", -- [139]
"-0.00000913280518:-0.00002485518027:0.799:  9:-0.29", -- [140]
"-0.00000253537576:-0.00000692238574:0.715:  2:-0.08", -- [141]
},
["grom2uc"] = {
" 0.72679328298082: 0.80385869701041:60.00:  7:87.95:plat1", -- [1]
" 0.00000765190367:-0.00000049536999:0.801: 11:-0.05", -- [2]
" 0.00002217856456:-0.00000160995245:0.801: 22:-0.17", -- [3]
" 0.00003668387526:-0.00000286118872:0.800: 34:-0.27", -- [4]
" 0.00005118064589:-0.00000430886479:0.799: 45:-0.37", -- [5]
" 0.00006562617610:-0.00000631596732:0.800: 56:-0.47", -- [6]
" 0.00008005462616:-0.00000881843983:0.800: 68:-0.57", -- [7]
" 0.00009441475566:-0.00001187179794:0.800: 79:-0.65", -- [8]
" 0.00010883466565:-0.00001565967016:0.801: 90:-0.73", -- [9]
" 0.00012271228114:-0.00002013081132:0.799:102:-0.81", -- [10]
" 0.00013670518757:-0.00002532792575:0.800:112:-0.87", -- [11]
" 0.00015089024561:-0.00003154140272:0.800:125:-0.92", -- [12]
" 0.00016431950736:-0.00003851928684:0.800:136:-0.96", -- [13]
" 0.00017736446592:-0.00004605232697:0.800:147:-1.00", -- [14]
" 0.00019049909521:-0.00005460172965:0.800:156:-1.01", -- [15]
" 0.00020295478886:-0.00006371482923:0.800:164:-1.02", -- [16]
" 0.00021514574030:-0.00007345141170:0.800:180:-1.02", -- [17]
" 0.00022611119156:-0.00008344849047:0.801:186:-1.00", -- [18]
" 0.00023655569846:-0.00009364627950:0.799:199:-0.97", -- [19]
" 0.00024640240040:-0.00010394228842:0.801:205:-0.92", -- [20]
" 0.00025420802536:-0.00011348243109:0.799:212:-0.86", -- [21]
" 0.00026173182796:-0.00012295424685:0.800:216:-0.79", -- [22]
" 0.00026750491601:-0.00013111504032:0.800:224:-0.68", -- [23]
" 0.00027131378770:-0.00013765734049:0.800:225:-0.56", -- [24]
" 0.00027396547976:-0.00014272207154:0.800:229:-0.41", -- [25]
" 0.00032520590616:-0.00017926841930:0.800:281:-1.62", -- [26]
" 0.00031942000801:-0.00019765689482:0.800:266:-2.38", -- [27]
" 0.00030057207116:-0.00020998989929:0.800:258:-2.58", -- [28]
" 0.00029121215329:-0.00022781894835:0.800:258:-2.51", -- [29]
" 0.00029568288048:-0.00025393690382:0.801:275:-2.08", -- [30]
" 0.00031452654729:-0.00028794661561:0.799:304:-1.36", -- [31]
" 0.00035185946795:-0.00033222244331:0.800:348:-0.52", -- [32]
" 0.00041017961325:-0.00038771669303:0.800:411: 0.23", -- [33]
" 0.00037020781063:-0.00034142949237:0.800:321: 0.82", -- [34]
" 0.00037322245572:-0.00033587366174:0.800:359: 0.39", -- [35]
" 0.00040523918214:-0.00036376811648:0.800:384:-0.11", -- [36]
" 0.00043240514820:-0.00039432304965:0.800:409:-0.59", -- [37]
" 0.00045293120900:-0.00042751283871:0.800:430:-1.07", -- [38]
" 0.00046365753826:-0.00046146276447:0.800:445:-1.61", -- [39]
" 0.00045602271473:-0.00048780705277:0.800:440:-2.15", -- [40]
" 0.00043772561247:-0.00051313497852:0.800:434:-2.78", -- [41]
" 0.00040964158878:-0.00053826432923:0.800:420:-3.50", -- [42]
" 0.00037602359902:-0.00053951556548:0.800:404:-0.92", -- [43]
" 0.00037196279524:-0.00053175405730:0.800:405:-0.16", -- [44]
" 0.00036928121292:-0.00054132409298:0.801:407:-1.08", -- [45]
" 0.00035856769377:-0.00055625778988:0.799:404:-1.96", -- [46]
" 0.00034439544584:-0.00058316577506:0.801:405:-2.85", -- [47]
" 0.00032240903288:-0.00061490788804:0.799:412:-3.67", -- [48]
" 0.00029501675494:-0.00065526559539:0.800:414:-4.44", -- [49]
" 0.00026194105971:-0.00070358765638:0.800:428:-5.11", -- [50]
" 0.00022334847856:-0.00076029470847:0.800:444:-5.58", -- [51]
" 0.00016642463488:-0.00075782853463:0.800:306:-5.56", -- [52]
" 0.00010438528863:-0.00066398368009:0.800:369:-4.19", -- [53]
" 0.00008171566998:-0.00071710784065:0.800:391:-3.28", -- [54]
" 0.00006132625032:-0.00076177441279:0.800:407:-2.58", -- [55]
" 0.00004346896172:-0.00079792574568:0.800:427:-2.02", -- [56]
" 0.00002829325544:-0.00082555543369:0.800:439:-1.57", -- [57]
" 0.00001590161232:-0.00084493037875:0.800:442:-1.18", -- [58]
" 0.00000636662298:-0.00085611250209:0.800:451:-0.85", -- [59]
"-0.00000026474220:-0.00085897582601:0.800:450:-0.55", -- [60]
"-0.00000397113305:-0.00085272391516:0.800:441:-0.25", -- [61]
"-0.00000471838926:-0.00084266064472:0.801:437: 0.03", -- [62]
"-0.00000245100040:-0.00081835335195:0.799:424: 0.35", -- [63]
" 0.00000283530360:-0.00079022829396:0.800:407: 0.72", -- [64]
" 0.00000718646980:-0.00082542305034:0.800:459:-0.19", -- [65]
"-0.00000093940782:-0.00088831582160:0.800:471:-0.85", -- [66]
"-0.00000877492302:-0.00090246055640:0.800:471:-0.68", -- [67]
"-0.00001506468536:-0.00090805161807:0.800:475:-0.54", -- [68]
"-0.00001967205369:-0.00089824991152:0.800:468:-0.40", -- [69]
"-0.00002266107858:-0.00087782230524:0.800:455:-0.29", -- [70]
"-0.00002400186972:-0.00084535742183:0.801:426:-0.17", -- [71]
"-0.00002367307700:-0.00080114885342:0.799:409:-0.05", -- [72]
"-0.00002168324043:-0.00074523076343:0.801:377: 0.10", -- [73]
"-0.00001798538966:-0.00067770030418:0.799:335: 0.30", -- [74]
"-0.00001254109436:-0.00059941369708:0.801:295: 0.60", -- [75]
"-0.00000204961706:-0.00013535557823:0.199:285: 0.22", -- [76]
" 0.01221827251178:-0.46262232448983:0.401:223:-87.80:zone1", -- [77]
"-0.00023403728352:-0.00000365301135:0.499:293:-0.36", -- [78]
"-0.00038636713194:-0.00000340504204:0.800:323:-0.21", -- [79]
"-0.00045238136933:-0.00000473560909:0.800:388: 0.19", -- [80]
"-0.00057654207909:-0.00001076549704:0.801:504: 0.36", -- [81]
"-0.00075903673296:-0.00002159752242:0.800:667: 0.38", -- [82]
"-0.00054242222500:-0.00002050282863:0.800:321: 0.42", -- [83]
"-0.00043218280274:-0.00002103505544:0.799:356: 0.30", -- [84]
"-0.00047282788239:-0.00002562551176:0.800:385: 0.17", -- [85]
"-0.00050710497085:-0.00002897007349:0.800:410: 0.08", -- [86]
"-0.00053546158124:-0.00003100221225:0.800:430: 0.00", -- [87]
"-0.00055789166611:-0.00003175821626:0.800:446:-0.06", -- [88]
"-0.00057437103556:-0.00003123203746:0.800:457:-0.12", -- [89]
"-0.00058488154715:-0.00002938738770:0.800:463:-0.18", -- [90]
"-0.00058868540895:-0.00002623636300:0.800:460:-0.25:trig1", -- [91]
"-0.00058871564632:-0.00002185758780:0.800:457:-0.31", -- [92]
"-0.00058052131766:-0.00001603938098:0.800:453:-0.40", -- [93]
"-0.00056705963825:-0.00000896318349:0.800:441:-0.49", -- [94]
"-0.00054754443634:-0.00000058061107:0.800:423:-0.61", -- [95]
"-0.00054033584611: 0.00000685242030:0.801:427:-0.36", -- [96]
"-0.00055489211850: 0.00001037842299:0.799:441:-0.23", -- [97]
"-0.00056370933709: 0.00001411005875:0.800:442:-0.25", -- [98]
"-0.00057050065154: 0.00001817433629:0.801:445:-0.27", -- [99]
"-0.00057100863944: 0.00002240795872:0.799:454:-0.30", -- [100]
"-0.00056807561406: 0.00002698027094:0.800:446:-0.32", -- [101]
"-0.00056097587838: 0.00003180055248:0.800:439:-0.37", -- [102]
"-0.00054969733745: 0.00003688089940:0.801:424:-0.42", -- [103]
"-0.00053424603876: 0.00004225759988:0.799:415:-0.48", -- [104]
"-0.00051459779240: 0.00004790041378:0.800:398:-0.57", -- [105]
"-0.00049073445594: 0.00005383353321:0.800:378:-0.67", -- [106]
"-0.00046260160213: 0.00006002671802:0.800:355:-0.82", -- [107]
"-0.00043017504103: 0.00006652835247:0.800:329:-1.01", -- [108]
"-0.00065185128560: 0.00012796426196:0.800:505:-2.07", -- [109]
"-0.00058884869077: 0.00015131571368:0.800:446:-2.36", -- [110]
"-0.00052208456648: 0.00016870380580:0.800:403:-2.40", -- [111]
"-0.00047268879047: 0.00018317069844:0.800:370:-2.19", -- [112]
"-0.00043474693215: 0.00019169842363:0.800:349:-1.64", -- [113]
"-0.00041519544540: 0.00019734728555:0.800:340:-0.91", -- [114]
"-0.00041171814725: 0.00020076442366:0.800:339:-0.15", -- [115]
"-0.00043602294939: 0.00021221939634:0.801:382:-0.27", -- [116]
"-0.00045380252596: 0.00023627241978:0.799:372:-1.39", -- [117]
"-0.00043359186443: 0.00024289501487:0.801:354:-1.30", -- [118]
"-0.00040998856939: 0.00024528398752:0.799:337:-1.23", -- [119]
"-0.00038754034210: 0.00024623957659:0.802:323:-1.20", -- [120]
"-0.00036079236006: 0.00024252608491:0.798:304:-1.16", -- [121]
"-0.00033626380136: 0.00023853438376:0.800:284:-1.16", -- [122]
"-0.00031053784259: 0.00023209927767:0.800:264:-1.17", -- [123]
"-0.00028485421616: 0.00022415821160:0.800:245:-1.19", -- [124]
"-0.00033755191353: 0.00028165685223:0.800:298:-1.57", -- [125]
"-0.00031380347911: 0.00027919530318:0.800:279:-1.58", -- [126]
"-0.00028781143144: 0.00027288115774:0.800:257:-1.62", -- [127]
"-0.00026117230396: 0.00026400264669:0.801:234:-1.69", -- [128]
"-0.00023441222696: 0.00025311618902:0.799:218:-1.77", -- [129]
"-0.00020821456515: 0.00024085078004:0.801:198:-1.90", -- [130]
"-0.00018199271344: 0.00022646251180:0.799:179:-2.03", -- [131]
"-0.00015754881938: 0.00021201981129:0.801:155:-2.21", -- [132]
"-0.00013401809405: 0.00019641588862:0.799:140:-2.40", -- [133]
"-0.00014798776137: 0.00024466104022:0.800:188:-4.05", -- [134]
"-0.00013461074661: 0.00026284747258:0.801:165:-4.77", -- [135]
"-0.00010433708662: 0.00024247770065:0.799:143:-4.42", -- [136]
"-0.00008135668153: 0.00022381347378:0.801:127:-3.98", -- [137]
"-0.00006328077867: 0.00020451420352:0.799:111:-3.46", -- [138]
"-0.00004963162754: 0.00018638825149:0.801: 99:-2.92", -- [139]
"-0.00003910902100: 0.00016848002861:0.800: 89:-2.40", -- [140]
"-0.00003085421758: 0.00015012425137:0.799: 78:-1.93", -- [141]
"-0.00002452251123: 0.00013240956551:0.800: 68:-1.51", -- [142]
"-0.00001946682211: 0.00011454367885:0.800: 58:-1.16", -- [143]
"-0.00001533639667: 0.00009664150401:0.800: 48:-0.85", -- [144]
"-0.00001185909852: 0.00007871513704:0.800: 38:-0.63", -- [145]
"-0.00000882326606: 0.00006079481809:0.800: 28:-0.42", -- [146]
"-0.00000605956998: 0.00004281401883:0.800: 19:-0.28", -- [147]
"-0.00000345915572: 0.00002487555579:0.801:  9:-0.15", -- [148]
"-0.00000094945357: 0.00000683427621:0.725:  1:-0.04", -- [149]
" 0.00000000000000: 0.00000001209607:60.00:  0: 0.00:plat2", -- [150]
"-0.00000149372634: 0.00001095903406:0.801: 11:-0.08", -- [151]
"-0.00000426346989: 0.00003180660051:0.800: 22:-0.23", -- [152]
"-0.00000683969425: 0.00005272674335:0.800: 33:-0.42", -- [153]
"-0.00000906516507: 0.00007384042321:0.801: 45:-0.63", -- [154]
"-0.00001066169847: 0.00009460936524:0.800: 55:-0.90", -- [155]
"-0.00001141763285: 0.00011543273957:0.799: 65:-1.22", -- [156]
"-0.00001092173990: 0.00013597185638:0.800: 76:-1.66", -- [157]
"-0.00000867812666: 0.00015549490382:0.800: 85:-2.20", -- [158]
"-0.00000408809312: 0.00017372367239:0.800: 95:-2.90", -- [159]
" 0.00000354986784: 0.00018906148166:0.801:102:-3.82", -- [160]
" 0.00001497354817: 0.00020135108276:0.800:109:-4.98", -- [161]
" 0.00003083607516: 0.00020817931094:0.799:115:-6.45", -- [162]
" 0.00005198409532: 0.00021021749774:0.800:122:-8.17", -- [163]
" 0.00007939125215: 0.00020690922422:0.801:130:-9.98", -- [164]
" 0.00009825332674: 0.00017314306132:0.800:119:-10.18", -- [165]
" 0.00013029889692: 0.00017458854097:0.799:153:-7.61", -- [166]
" 0.00017225627864: 0.00018935178719:0.800:181:-5.63", -- [167]
" 0.00021143786934: 0.00019770411945:0.801:207:-4.18", -- [168]
" 0.00024357415163: 0.00019953062512:0.800:224:-3.13", -- [169]
" 0.00026579862235: 0.00019576874919:0.800:234:-2.30", -- [170]
" 0.00027353334291: 0.00018574111206:0.799:235:-1.60", -- [171]
" 0.00027364219746: 0.00017129236351:0.800:239:-2.45", -- [172]
" 0.00027585557331: 0.00013411511055:0.800:225:-5.07", -- [173]
" 0.00028362657873: 0.00010048200436:0.800:237:-4.26", -- [174]
" 0.00032074598044: 0.00008885768677:0.800:274:-2.14", -- [175]
" 0.00039077574124: 0.00010289516914:0.801:342: 0.20", -- [176]
" 0.00037493135667: 0.00010900368151:0.799:250: 1.18", -- [177]
" 0.00032695673729: 0.00010123800836:0.801:271: 0.32", -- [178]
" 0.00035445460623: 0.00010759449004:0.800:297:-0.48", -- [179]
" 0.00039282583527: 0.00010897344134:0.799:330:-1.21", -- [180]
" 0.00044213089916: 0.00010383866214:0.800:372:-1.80", -- [181]
" 0.00050464969598: 0.00009094425783:0.800:424:-2.22", -- [182]
" 0.00050347043836: 0.00005841794150:0.800:291:-3.18", -- [183]
" 0.00039040684526: 0.00000267927819:0.800:317:-3.68", -- [184]
" 0.00042885669148:-0.00002594000943:0.800:352:-2.04", -- [185]
" 0.00046906635293:-0.00004131410688:0.801:384:-0.52", -- [186]
" 0.00051098140233:-0.00003994725164:0.799:422: 0.91", -- [187]
" 0.00055324115782:-0.00001822876858:0.801:447: 2.25", -- [188]
" 0.00058277702584: 0.00002576461650:0.800:466: 3.41", -- [189]
" 0.00061206494740: 0.00009128294762:0.799:501: 4.38", -- [190]
" 0.00062451669847: 0.00017278017940:0.801:424: 5.01", -- [191]
" 0.00046915706506: 0.00018077567775:0.799:400: 2.85", -- [192]
" 0.00051057017403: 0.00022877286005:0.800:430: 1.95", -- [193]
" 0.00054344424828: 0.00026828465338:0.800:460: 1.41", -- [194]
" 0.00056330415626: 0.00029720029458:0.801:472: 1.03", -- [195]
" 0.00057257493547: 0.00031666286169:0.799:477: 0.76", -- [196]
" 0.00056974471716: 0.00032583772630:0.800:468: 0.55", -- [197]
" 0.00055756510247: 0.00032630947280:0.800:463: 0.37", -- [198]
" 0.00053173633662: 0.00031553792773:0.800:438: 0.20", -- [199]
" 0.00049502211574: 0.00029513791565:0.800:403: 0.02", -- [200]
" 0.00044607385288: 0.00026421432782:0.800:354:-0.23", -- [201]
" 0.00038723192087: 0.00022407958718:0.801:300:-0.61", -- [202]
" 0.00016622089857: 0.00009273447531:0.399:265:-0.54", -- [203]
"-0.02903920718344: 0.47625876443408:0.300:676:-14.37:zone2", -- [204]
" 0.00030271135897: 0.00005052346813:0.500:388: 0.61", -- [205]
" 0.00050366990622: 0.00009325339985:0.801:400: 0.81", -- [206]
" 0.00052534460658: 0.00010723052023:0.800:420: 0.65", -- [207]
" 0.00054320403020: 0.00011907242515:0.799:434: 0.53", -- [208]
" 0.00055720334169: 0.00012914210124:0.800:448: 0.43", -- [209]
" 0.00056734681110: 0.00013723029739:0.800:451: 0.34", -- [210]
" 0.00057432831919: 0.00014341388136:0.801:459: 0.27:trig2", -- [211]
" 0.00057310068397: 0.00014660389325:0.799:454: 0.20", -- [212]
" 0.00055874055448: 0.00014532276397:0.800:440: 0.13", -- [213]
" 0.00053927986755: 0.00014173987244:0.801:419: 0.08", -- [214]
" 0.00051506022600: 0.00013594489768:0.799:400: 0.02", -- [215]
" 0.00049235644707: 0.00012979974761:0.804:379:-0.03", -- [216]
" 0.00046185558327: 0.00012094714432:0.796:361:-0.09", -- [217]
" 0.00043538990303: 0.00011265823792:0.800:338:-0.13", -- [218]
" 0.00040621702028: 0.00010322058560:0.800:314:-0.20", -- [219]
" 0.00037650184301: 0.00009331745631:0.800:290:-0.25", -- [220]
" 0.00034658597406: 0.00008308977428:0.801:263:-0.32", -- [221]
" 0.00031676831595: 0.00007279376534:0.799:242:-0.39", -- [222]
" 0.00037312851493: 0.00008265846076:0.801:399:-0.09", -- [223]
" 0.00046813680554: 0.00010845186346:0.799:355: 0.46", -- [224]
" 0.00041736608305: 0.00010108109972:0.800:320: 0.35", -- [225]
" 0.00037357686867: 0.00009324912942:0.801:281: 0.21", -- [226]
" 0.00033469392511: 0.00008447339389:0.800:253: 0.05", -- [227]
" 0.00030246796694: 0.00007594961379:0.800:226:-0.11", -- [228]
" 0.00027469992588: 0.00006723366429:0.800:208:-0.27", -- [229]
" 0.00025010879124: 0.00005871415463:0.800:192:-0.42", -- [230]
" 0.00022800708733: 0.00005009642504:0.799:172:-0.57", -- [231]
" 0.00021185354291: 0.00004285804464:0.801:161:-0.68", -- [232]
" 0.00019456843907: 0.00003539333141:0.800:149:-0.78", -- [233]
" 0.00017988805692: 0.00002858626453:0.799:138:-0.84", -- [234]
" 0.00016694984925: 0.00002262901341:0.800:128:-0.87", -- [235]
" 0.00015478451801: 0.00001726962262:0.800:118:-0.88", -- [236]
" 0.00014328958237: 0.00001266609808:0.800:109:-0.86", -- [237]
" 0.00013221738023: 0.00000871594950:0.800:100:-0.83", -- [238]
" 0.00012137576001: 0.00000539355424:0.800: 91:-0.79", -- [239]
" 0.00011062381054: 0.00000263058544:0.800: 83:-0.72", -- [240]
" 0.00009965408926: 0.00000065764636:0.800: 74:-0.65", -- [241]
" 0.00008890640982:-0.00000085408618:0.800: 66:-0.58", -- [242]
" 0.00007758654562:-0.00000184055572:0.800: 57:-0.50", -- [243]
" 0.00006614285040:-0.00000233592571:0.801: 48:-0.42", -- [244]
" 0.00005451981368:-0.00000256652898:0.800: 38:-0.35", -- [245]
" 0.00004248258351:-0.00000227186925:0.799: 29:-0.27", -- [246]
" 0.00003043681328:-0.00000187471917:0.800: 20:-0.19", -- [247]
" 0.00001819889144:-0.00000108468945:0.801: 10:-0.11", -- [248]
" 0.00000567914726:-0.00000039287964:0.798:  1:-0.04", -- [249]
},
["exo2aub"] = {
" 0.05550385776690: 0.29455993557295:60.00:  2:174.83:plat1", -- [1]
" 0.00000088649979: 0.00001408648558:0.802: 13: 0.03", -- [2]
" 0.00000236399944: 0.00003987066459:0.799: 26: 0.10", -- [3]
" 0.00000386612408: 0.00006511305570:0.801: 39: 0.18", -- [4]
" 0.00000490037384: 0.00008895172361:0.799: 53: 0.25", -- [5]
" 0.00000598387359: 0.00011158368207:0.800: 64: 0.32", -- [6]
" 0.00000635324849: 0.00013222087597:0.800: 74: 0.42", -- [7]
" 0.00000652562346: 0.00015130658632:0.800: 84: 0.51", -- [8]
" 0.00000623012353: 0.00016866842607:0.800: 93: 0.62", -- [9]
" 0.00000539287372: 0.00018487280982:0.801:101: 0.71", -- [10]
" 0.00000408774903: 0.00019957496347:0.799:108: 0.80", -- [11]
" 0.00000231474946: 0.00021545919983:0.801:117: 0.86", -- [12]
" 0.00000012312497: 0.00023136806291:0.800:124: 0.88", -- [13]
"-0.00000243787443: 0.00025057690688:0.799:134: 0.83", -- [14]
"-0.00000526974875: 0.00027498198941:0.800:151: 0.71", -- [15]
"-0.00000824937305: 0.00030761239742:0.800:170:-0.48", -- [16]
"-0.00000438324896: 0.00033445552553:0.801:179:-1.14", -- [17]
"-0.00000229012446: 0.00035083229636:0.799:187: 0.61", -- [18]
"-0.00000837249802: 0.00037129710319:0.800:200: 2.75", -- [19]
"-0.00002563461893: 0.00039227907122:0.800:211: 5.16", -- [20]
"-0.00005772098634: 0.00041663490030:0.800:231: 7.53", -- [21]
"-0.00009564347737: 0.00040577451544:0.801:211: 5.79", -- [22]
"-0.00011100947373: 0.00038370897160:0.799:226: 3.12", -- [23]
"-0.00013849096723: 0.00040675958437:0.800:249: 4.28", -- [24]
"-0.00017601945835: 0.00042530350681:0.800:272: 5.32", -- [25]
"-0.00022654994639: 0.00044175415779:0.801:305: 6.13", -- [26]
"-0.00029106743112: 0.00045207275475:0.800:346: 6.58", -- [27]
"-0.00023440531954: 0.00031224222136:0.799:251: 1.74", -- [28]
"-0.00025777443900: 0.00031911307708:0.800:272: 2.50", -- [29]
"-0.00029284043070: 0.00032795407065:0.800:301: 3.08", -- [30]
"-0.00034172104414: 0.00033898684257:0.800:341: 3.37", -- [31]
"-0.00040678027874: 0.00035280243420:0.800:391: 3.38", -- [32]
"-0.00049060375891: 0.00037023815410:0.800:464: 3.16", -- [33]
"-0.00043051877313: 0.00028946250255:0.800:293: 1.52", -- [34]
"-0.00037476778632: 0.00024077547111:0.801:335: 0.69", -- [35]
"-0.00041345365216: 0.00025604403939:0.799:366: 0.82", -- [36]
"-0.00045319839276: 0.00026848053452:0.800:397: 0.96", -- [37]
"-0.00049161338367: 0.00027596705833:0.800:426: 1.12", -- [38]
"-0.00052667937537: 0.00027695212725:0.801:443: 1.30", -- [39]
"-0.00054930974501: 0.00026690442425:0.800:459: 1.46:trig1", -- [40]
"-0.00056558686617: 0.00024978885174:0.800:463: 1.64", -- [41]
"-0.00057888436302: 0.00022740316050:0.800:474: 1.85", -- [42]
"-0.00029259418076: 0.00010328447641:0.399:475: 1.01", -- [43]
" 0.12401970875116:-0.02864538083811:1.401:159:159.22:zone1", -- [44]
" 0.00026334395802:-0.00026003130642:0.599:325: 0.10", -- [45]
" 0.00033844671124:-0.00033305730924:0.800:310: 0.07", -- [46]
" 0.00031604518385:-0.00031039557846:0.801:284: 0.03", -- [47]
" 0.00028748553752:-0.00028230292229:0.799:258:-0.03", -- [48]
" 0.00025475765552:-0.00025058088252:0.801:225:-0.08", -- [49]
" 0.00024557088162:-0.00024251996901:0.799:336: 0.83", -- [50]
" 0.00031526939236:-0.00027973430058:0.801:256: 4.36", -- [51]
" 0.00025591915126:-0.00019936624766:0.799:211: 0.82", -- [52]
" 0.00021629242283:-0.00017490735836:0.800:185:-4.13", -- [53]
" 0.00019097181557:-0.00019346192438:0.800:182:-8.06", -- [54]
" 0.00017631505417:-0.00024468970919:0.801:195:-8.88", -- [55]
" 0.00013983093875:-0.00025498611259:0.799:159:-5.52", -- [56]
" 0.00011612327654:-0.00024975243627:0.800:159:-3.50", -- [57]
" 0.00010423218990:-0.00025352208588:0.800:151:-2.79", -- [58]
" 0.00009325276785:-0.00025163287777:0.801:145:-2.28", -- [59]
" 0.00008241360190:-0.00024337471514:0.799:139:-1.92", -- [60]
" 0.00007228448239:-0.00023110582067:0.800:128:-1.63", -- [61]
" 0.00006290923938:-0.00021604037219:0.801:119:-1.41", -- [62]
" 0.00005405995670:-0.00019806440355:0.800:106:-1.23", -- [63]
" 0.00004600399753:-0.00017875590761:0.800: 95:-1.07", -- [64]
" 0.00003861425478:-0.00015816748413:0.799: 84:-0.93", -- [65]
" 0.00003196962252:-0.00013740811141:0.801: 70:-0.80", -- [66]
" 0.00002588163162:-0.00011600000832:0.800: 59:-0.68", -- [67]
" 0.00002037219707:-0.00009464888828:0.800: 47:-0.55", -- [68]
" 0.00001524846679:-0.00007298655299:0.800: 35:-0.43", -- [69]
" 0.00001057180278:-0.00005177569899:0.800: 23:-0.31", -- [70]
" 0.00000610552292:-0.00003037636252:0.800: 11:-0.18", -- [71]
" 0.00000181894617:-0.00000909537550:0.762:  0:-0.06", -- [72]
" 0.00000000000000:-0.00000001753325:60.00:  0: 0.00:plat2", -- [73]
" 0.00000195043625:-0.00001008162104:0.801: 10: 0.04", -- [74]
" 0.00000573735069:-0.00002948654988:0.800: 21: 0.11", -- [75]
" 0.00000961192516:-0.00004899229492:0.800: 32: 0.15", -- [76]
" 0.00001362675575:-0.00006853310648:0.800: 42: 0.17", -- [77]
" 0.00001783882145:-0.00008856484915:0.801: 53: 0.16", -- [78]
" 0.00002211224919:-0.00010867987478:0.799: 64: 0.07", -- [79]
" 0.00002638129394:-0.00012895708300:0.800: 75:-0.05", -- [80]
" 0.00003056706162:-0.00015026875321:0.801: 87:-0.25", -- [81]
" 0.00003419180494:-0.00017151905703:0.799: 99:-0.53", -- [82]
" 0.00003704952278:-0.00019351014083:0.800:112:-0.91", -- [83]
" 0.00003853536074:-0.00021623762130:0.800:121:-1.37", -- [84]
" 0.00003811020946:-0.00023965766530:0.801:133:-1.94", -- [85]
" 0.00003492814942:-0.00026405080489:0.799:147:-2.65", -- [86]
" 0.00002809066503:-0.00028940827346:0.801:158:-3.46", -- [87]
" 0.00001643187754:-0.00031601936968:0.799:171:-4.39", -- [88]
"-0.00000137187988:-0.00034441885781:0.801:188:-5.39", -- [89]
"-0.00002682397721:-0.00037249836406:0.799:203:-6.35", -- [90]
"-0.00005081653462:-0.00034739512767:0.800:178:-5.54", -- [91]
"-0.00007302959288:-0.00035177405785:0.800:205:-3.88", -- [92]
"-0.00009987548510:-0.00039132907883:0.801:231:-3.19", -- [93]
"-0.00012542400850:-0.00042320015124:0.799:251:-2.73", -- [94]
"-0.00015020112341:-0.00045013999598:0.800:271:-2.45", -- [95]
"-0.00017141485702:-0.00046405263301:0.800:280:-2.34", -- [96]
"-0.00018872771814:-0.00046482409618:0.801:286:-2.41", -- [97]
"-0.00019944854302:-0.00044634404649:0.799:275:-2.71", -- [98]
"-0.00020320915943:-0.00040798567011:0.800:257:-3.47", -- [99]
"-0.00024778429804:-0.00042959978894:0.800:344:-4.18", -- [100]
"-0.00030000777656:-0.00044443292181:0.800:326:-5.94", -- [101]
"-0.00032170364048:-0.00036826846653:0.800:311:-9.40", -- [102]
"-0.00035615842560:-0.00026452420275:0.800:312:-13.18", -- [103]
"-0.00040644023388:-0.00012724759074:0.800:342:-15.60", -- [104]
"-0.00011092941820:-0.00000567200766:0.201:348:-3.95", -- [105]
"-0.12537932216219: 0.01657845791404:1.199:268:-129.10:zone2", -- [106]
" 0.00027304193539: 0.00050497095583:0.600:451: 2.89", -- [107]
" 0.00033152629655: 0.00068127366603:0.800:434: 2.69", -- [108]
" 0.00030724605230: 0.00068102739880:0.800:426: 1.20", -- [109]
" 0.00029421943037: 0.00066509390900:0.800:418:-0.41", -- [110]
" 0.00029434255535: 0.00063706869818:0.800:398:-2.17", -- [111]
" 0.00030709830233: 0.00059613908450:0.800:391:-4.06", -- [112]
" 0.00033268367128: 0.00054247745501:0.800:385:-6.06", -- [113]
" 0.00038328803430: 0.00048930835997:0.800:435:-7.92", -- [114]
" 0.00046802263925: 0.00044840337302:0.801:434:-7.00:trig2", -- [115]
" 0.00049634138255: 0.00037228217211:0.799:432:-4.84", -- [116]
" 0.00050456613061: 0.00031327654373:0.800:420:-3.22", -- [117]
" 0.00049252450845: 0.00026683054408:0.801:398:-1.92", -- [118]
" 0.00046570788980: 0.00023294417318:0.799:377:-0.79", -- [119]
" 0.00042625864913: 0.00020913013201:0.800:337: 0.34", -- [120]
" 0.00037668853587: 0.00019400932407:0.800:298: 1.64", -- [121]
" 0.00031963242436: 0.00018583325202:0.800:248: 3.39", -- [122]
" 0.00035410741621: 0.00025959028751:0.800:525: 4.48", -- [123]
" 0.00044411176991: 0.00037018890065:0.801:312: 4.31", -- [124]
" 0.00025585368945: 0.00027978420040:0.799:218:12.65", -- [125]
" 0.00016870583508: 0.00030852358618:0.800:219:13.85", -- [126]
" 0.00015085271431: 0.00041084762039:0.801:230: 6.31", -- [127]
" 0.00010357272549: 0.00041279313150:0.799:234:10.11", -- [128]
" 0.00006491148464: 0.00044722129031:0.800:243: 5.86", -- [129]
" 0.00004127149023: 0.00046202195086:0.801:243: 2.95", -- [130]
" 0.00002977161796: 0.00045963315872:0.799:241: 0.89", -- [131]
" 0.00002762924346: 0.00044766457132:0.801:234:-0.69", -- [132]
" 0.00003218486738: 0.00042431843789:0.799:219:-2.03", -- [133]
" 0.00003617411644: 0.00036605161118:0.800:184:-0.83", -- [134]
" 0.00003543536662: 0.00034760619564:0.800:183: 0.01", -- [135]
" 0.00003430261688: 0.00033780475986:0.800:174: 0.09", -- [136]
" 0.00003228336736: 0.00032196977696:0.801:165: 0.15", -- [137]
" 0.00002972236797: 0.00030214526491:0.800:154: 0.19", -- [138]
" 0.00002661961870: 0.00027813420995:0.800:141: 0.24", -- [139]
" 0.00002363999440: 0.00025348286020:0.800:127: 0.27", -- [140]
" 0.00002034024519: 0.00022755092084:0.800:113: 0.29", -- [141]
" 0.00001750837086: 0.00020169286165:0.800:101: 0.31", -- [142]
" 0.00001450412157: 0.00017566241541:0.799: 86: 0.33", -- [143]
" 0.00001201699715: 0.00015103569237:0.800: 74: 0.33", -- [144]
" 0.00000957912274: 0.00012749254515:0.801: 62: 0.32", -- [145]
" 0.00000753524821: 0.00010458969273:0.799: 50: 0.30", -- [146]
" 0.00000578687363: 0.00008343533764:0.800: 39: 0.26", -- [147]
" 0.00000421087401: 0.00006301978425:0.800: 29: 0.22", -- [148]
" 0.00000275799934: 0.00004373706011:0.801: 18: 0.17", -- [149]
" 0.00000155137464: 0.00002499612388:0.800:  9: 0.10", -- [150]
" 0.00000041862490: 0.00000672309539:0.727:  2: 0.03", -- [151]
},
["org2gg"] = {
" 0.30050948367211: 0.44617041911853:60.00:  3:55.86:plat1", -- [1]
" 0.00000492515854:-0.00000534569502:0.801:  9:-0.16", -- [2]
" 0.00001440750402:-0.00001582920184:0.801: 18:-0.49", -- [3]
" 0.00002359971803:-0.00002651970727:0.799: 27:-0.79", -- [4]
" 0.00003272824464:-0.00003797539989:0.800: 36:-1.08", -- [5]
" 0.00004135434847:-0.00005004678071:0.800: 45:-1.34", -- [6]
" 0.00004969739722:-0.00006312130866:0.800: 55:-1.54", -- [7]
" 0.00005755925231:-0.00007717509929:0.800: 64:-1.70", -- [8]
" 0.00006535742000:-0.00009276634118:0.800: 75:-1.79", -- [9]
" 0.00007261778303:-0.00010929438450:0.800: 85:-1.80", -- [10]
" 0.00007998429172:-0.00012735368681:0.801: 97:-1.72", -- [11]
" 0.00008698282878:-0.00014586325534:0.799:107:-1.54", -- [12]
" 0.00009502159331:-0.00016638884884:0.801:119:-1.26", -- [13]
" 0.00010329387828:-0.00018676582796:0.799:133:-0.88", -- [14]
" 0.00011284698752:-0.00020742322829:0.800:146:-0.39", -- [15]
" 0.00012399228165:-0.00022727298015:0.800:159: 0.21", -- [16]
" 0.00013803889043:-0.00024662292768:0.801:174: 0.90", -- [17]
" 0.00015488066821:-0.00026272458924:0.800:191: 1.71", -- [18]
" 0.00017613102900:-0.00027548596543:0.800:204: 2.60", -- [19]
" 0.00020264621445:-0.00028306795319:0.799:229: 3.57", -- [20]
" 0.00023588395825:-0.00028407198494:0.801:245: 4.56", -- [21]
" 0.00027520738645:-0.00027472166285:0.799:270: 5.49", -- [22]
" 0.00032513122775:-0.00025647393873:0.800:303: 6.21", -- [23]
" 0.00038004391497:-0.00022260312677:0.801:315: 6.60", -- [24]
" 0.00026345352389:-0.00011788836549:0.799:223: 3.27", -- [25]
" 0.00029299739879:-0.00010754285775:0.800:249: 2.77", -- [26]
" 0.00032238559339:-0.00009687800599:0.800:266: 2.32", -- [27]
" 0.00035325275081:-0.00008674657375:0.801:286: 1.94", -- [28]
" 0.00038256310526:-0.00007668237182:0.799:314: 1.59", -- [29]
" 0.00041093230154:-0.00006738866473:0.800:332: 1.27", -- [30]
" 0.00043948548362:-0.00005944575632:0.800:356: 1.00", -- [31]
" 0.00046435187316:-0.00005279349310:0.800:375: 0.72", -- [32]
" 0.00048697505114:-0.00004825367732:0.801:387: 0.46", -- [33]
" 0.00050601050586:-0.00004623942155:0.800:401: 0.19", -- [34]
" 0.00052063030120:-0.00004731599127:0.799:415:-0.10", -- [35]
" 0.00052994281362:-0.00005216895883:0.800:420:-0.41", -- [36]
" 0.00053220017795:-0.00006130343620:0.800:416:-0.80", -- [37]
" 0.00052899457908:-0.00007581014688:0.800:415:-1.26", -- [38]
" 0.00019455791528:-0.00003314012453:0.300:407:-0.62", -- [39]
" 0.40741587443212: 0.36352480804689:1.501:189: 4.00:zone1", -- [40]
" 0.00006139457088:-0.00000516295097:0.099:387:-0.10", -- [41]
" 0.00050555726193:-0.00004785871925:0.800:404:-0.67", -- [42]
" 0.00051600390385:-0.00005552414273:0.801:408:-0.39", -- [43]
" 0.00051570500137:-0.00005907714125:0.800:406:-0.19:trig1", -- [44]
" 0.00050982089240:-0.00005933763754:0.799:399: 0.00", -- [45]
" 0.00049693819520:-0.00005664299563:0.800:387: 0.14", -- [46]
" 0.00047880762433:-0.00005171064793:0.800:371: 0.29", -- [47]
" 0.00045636004754:-0.00004473276381:0.800:348: 0.44", -- [48]
" 0.00043109424729:-0.00003628158104:0.801:330: 0.58", -- [49]
" 0.00040170786275:-0.00002651083511:0.799:307: 0.74", -- [50]
" 0.00037212078655:-0.00001615076971:0.800:282: 0.93", -- [51]
" 0.00034093244702:-0.00000516722141:0.800:258: 1.14", -- [52]
" 0.00030965016671: 0.00000608536405:0.801:233: 1.40", -- [53]
" 0.00030387280864: 0.00001901195843:0.799:343: 1.58", -- [54]
" 0.00041461191013: 0.00003776342056:0.800:312: 1.07", -- [55]
" 0.00037407219279: 0.00004559112043:0.801:282: 1.21", -- [56]
" 0.00033681613277: 0.00005279106695:0.799:256: 1.34", -- [57]
" 0.00030529900050: 0.00005953834779:0.801:232: 1.46", -- [58]
" 0.00027574181455: 0.00006512834186:0.799:211: 1.54", -- [59]
" 0.00025059984533: 0.00007016317990:0.801:191: 1.62", -- [60]
" 0.00022678158713: 0.00007387845480:0.799:174: 1.65", -- [61]
" 0.00020606764476: 0.00007673964350:0.800:161: 1.66", -- [62]
" 0.00018670730366: 0.00007831970295:0.800:145: 1.63", -- [63]
" 0.00016937095940: 0.00007897307888:0.800:131: 1.59", -- [64]
" 0.00015349923732: 0.00007864852612:0.801:122: 1.52", -- [65]
" 0.00013795203795: 0.00007673964351:0.800:110: 1.43", -- [66]
" 0.00012357909835: 0.00007384856178:0.799:100: 1.32", -- [67]
" 0.00011026085752: 0.00007019307292:0.800: 90: 1.20", -- [68]
" 0.00009749772131: 0.00006555538495:0.801: 80: 1.08", -- [69]
" 0.00008499932731: 0.00005986717097:0.800: 70: 0.95", -- [70]
" 0.00007299625743: 0.00005348287675:0.800: 60: 0.82", -- [71]
" 0.00006130490014: 0.00004638115015:0.800: 50: 0.68", -- [72]
" 0.00004978434427: 0.00003881394657:0.799: 40: 0.56", -- [73]
" 0.00003862674143: 0.00003068731654:0.801: 30: 0.44", -- [74]
" 0.00002737519780: 0.00002200553050:0.799: 20: 0.30", -- [75]
" 0.00001634569602: 0.00001335790789:0.801: 10: 0.19", -- [76]
" 0.00000508561232: 0.00000417648144:0.801:  1: 0.05", -- [77]
" 0.00000001281010: 0.00000000000000:60.00:  0: 0.00:plat2", -- [78]
" 0.00000718219977: 0.00000598714414:0.802: 12: 0.11", -- [79]
" 0.00002087193368: 0.00001743189898:0.800: 24: 0.32", -- [80]
" 0.00003444637664: 0.00002924391090:0.800: 36: 0.52", -- [81]
" 0.00004787990843: 0.00004173919174:0.799: 48: 0.72", -- [82]
" 0.00006120668932: 0.00005503304318:0.800: 61: 0.91", -- [83]
" 0.00007429007819: 0.00006946709966:0.800: 74: 1.09", -- [84]
" 0.00008678420217: 0.00008480221708:0.801: 86: 1.26", -- [85]
" 0.00009885559261: 0.00010157219926:0.799:100: 1.42", -- [86]
" 0.00011037187844: 0.00011983256186:0.801:114: 1.57", -- [87]
" 0.00012059434351: 0.00013897263320:0.799:125: 1.72", -- [88]
" 0.00013015922310: 0.00015979525434:0.800:138: 1.87", -- [89]
" 0.00013798619824: 0.00018150612510:0.800:149: 2.03", -- [90]
" 0.00014463891359: 0.00020489100478:0.800:161: 2.20", -- [91]
" 0.00014866555710: 0.00022841253825:0.800:171: 2.41", -- [92]
" 0.00015029671067: 0.00025248922773:0.800:182: 2.66", -- [93]
" 0.00014882781845: 0.00027656591723:0.800:190: 2.98", -- [94]
" 0.00014381906677: 0.00030067677016:0.801:197: 3.40", -- [95]
" 0.00013383145366: 0.00032268230066:0.799:198: 3.97", -- [96]
" 0.00011887351919: 0.00034373552505:0.800:203: 4.74", -- [97]
" 0.00009765144259: 0.00036383217294:0.801:202: 5.86", -- [98]
" 0.00006908063485: 0.00039027895158:0.799:236: 7.78", -- [99]
" 0.00003220887802: 0.00046428978973:0.801:255: 9.22", -- [100]
"-0.00001341645164: 0.00049925180762:0.799:269: 7.96", -- [101]
"-0.00005921258273: 0.00053027221778:0.800:290: 6.98", -- [102]
"-0.00010488915282: 0.00054928844663:0.801:307: 6.35", -- [103]
"-0.00014951956421: 0.00055306777798:0.799:322: 6.07", -- [104]
"-0.00019312943710: 0.00054066644662:0.800:321: 6.26", -- [105]
"-0.00023557359029: 0.00050731011075:0.801:320: 7.04", -- [106]
"-0.00026970825434: 0.00043866720426:0.800:296: 8.17", -- [107]
"-0.00031001311973: 0.00038448824726:0.799:328: 7.21", -- [108]
"-0.00036565168272: 0.00035511622344:0.800:355: 6.50", -- [109]
"-0.00041841651179: 0.00031669515652:0.800:380: 6.07", -- [110]
"-0.00046703086634: 0.00026729054128:0.800:404: 5.89", -- [111]
"-0.00050997461368: 0.00020479705530:0.800:425: 6.00", -- [112]
"-0.00054632969620: 0.00012722894819:0.801:443: 6.35", -- [113]
"-0.00006957168893: 0.00000950597922:0.100:436: 0.84", -- [114]
"-0.41865712993613:-0.36173189689491:1.699:382:-6.32:zone2", -- [115]
"-0.00031813976705: 0.00010803735444:0.500:406:-1.47", -- [116]
"-0.00048986928943: 0.00018481614870:0.800:383:-1.30", -- [117]
"-0.00048520595683: 0.00018873143020:0.800:388: 0.17", -- [118]
"-0.00049585590455: 0.00017767204262:0.801:403: 1.68", -- [119]
"-0.00052223663883: 0.00015174236987:0.800:426: 2.95", -- [120]
"-0.00056417125023: 0.00011122017931:0.799:461: 3.78", -- [121]
"-0.00052507426609: 0.00007478134607:0.801:417: 0.48", -- [122]
"-0.00055655706834: 0.00007792347890:0.799:458: 0.25", -- [123]
"-0.00058961790272: 0.00007540764958:0.800:473: 0.60", -- [124]
"-0.00060630400020: 0.00006474987469:0.801:480: 0.95:trig2", -- [125]
"-0.00060364328236: 0.00004562107953:0.799:468: 1.37", -- [126]
"-0.00058716239982: 0.00001845295352:0.801:449: 1.93", -- [127]
"-0.00054166483248:-0.00001644665925:0.799:408: 2.68", -- [128]
"-0.00048493705450:-0.00005706792606:0.801:362: 3.77", -- [129]
"-0.00041909490266:-0.00010332592441:0.800:313: 5.55", -- [130]
"-0.00040252556540:-0.00019109864514:0.799:489:10.20", -- [131]
"-0.00049108996449:-0.00046957901363:0.800:436:18.07", -- [132]
"-0.00034234451534:-0.00059627455099:0.801:395:15.13", -- [133]
"-0.00022626716160:-0.00064265462545:0.800:369:11.22", -- [134]
"-0.00014143908968:-0.00063054786026:0.799:334: 7.97", -- [135]
"-0.00008258839854:-0.00057764113713:0.800:291: 5.57", -- [136]
"-0.00004385584782:-0.00049202863273:0.801:233: 3.78", -- [137]
" 0.00001285070103:-0.00057302878337:0.799:300:13.74", -- [138]
" 0.00010473392105:-0.00053605564600:0.800:289:13.69", -- [139]
" 0.00017217179595:-0.00047893641259:0.801:284:10.88", -- [140]
" 0.00021811871323:-0.00042863574897:0.799:281: 8.06", -- [141]
" 0.00025063820475:-0.00039078507901:0.800:279: 5.81", -- [142]
" 0.00027138968095:-0.00035933013551:0.800:282: 4.13", -- [143]
" 0.00021984181109:-0.00023783256339:0.801:200: 6.49", -- [144]
" 0.00021841592108:-0.00018888712146:0.799:198: 4.88", -- [145]
" 0.00022355690913:-0.00016587842919:0.800:195: 3.21", -- [146]
" 0.00022272543481:-0.00014882492784:0.800:190: 1.98", -- [147]
" 0.00021813994237:-0.00013681016203:0.801:183: 1.09", -- [148]
" 0.00021021439988:-0.00012807552813:0.800:175: 0.41", -- [149]
" 0.00019972367065:-0.00012154003338:0.799:165:-0.10", -- [150]
" 0.00018725509399:-0.00011629253001:0.800:153:-0.49", -- [151]
" 0.00017359768596:-0.00011178632937:0.801:142:-0.79", -- [152]
" 0.00015824902377:-0.00010678828588:0.799:130:-1.01", -- [153]
" 0.00014378490873:-0.00010236170009:0.801:120:-1.16", -- [154]
" 0.00012787013636:-0.00009635166336:0.799:108:-1.24", -- [155]
" 0.00011279037651:-0.00008998601362:0.800: 94:-1.28", -- [156]
" 0.00009797244261:-0.00008261190909:0.801: 83:-1.26", -- [157]
" 0.00008333141814:-0.00007400112051:0.800: 71:-1.19", -- [158]
" 0.00006913620544:-0.00006434649278:0.799: 58:-1.08", -- [159]
" 0.00005589630366:-0.00005415756090:0.800: 47:-0.93", -- [160]
" 0.00004267763101:-0.00004277794470:0.800: 35:-0.76", -- [161]
" 0.00003010290870:-0.00003095160071:0.800: 24:-0.55", -- [162]
" 0.00001768386667:-0.00001851841463:0.801: 12:-0.34", -- [163]
" 0.00000551957423:-0.00000580569194:0.777:  0:-0.11", -- [164]
},
["mh2aub"] = {
" 0.74439847427062: 0.51118042154208:60.00:  7:-120.87:plat1", -- [1]
"-0.00000550694521: 0.00000490562769:0.801: 10: 0.02", -- [2]
"-0.00001641178721: 0.00001438984121:0.800: 20: 0.05", -- [3]
"-0.00002748020186: 0.00002398306869:0.800: 29: 0.10", -- [4]
"-0.00003901207227: 0.00003390333800:0.801: 40: 0.17", -- [5]
"-0.00005062572900: 0.00004360557944:0.800: 50: 0.26", -- [6]
"-0.00006311177310: 0.00005363486270:0.800: 61: 0.38", -- [7]
"-0.00007614305930: 0.00006339161110:0.799: 73: 0.54", -- [8]
"-0.00008988316022: 0.00007293033160:0.800: 86: 0.75", -- [9]
"-0.00010446838640: 0.00008154243354:0.800: 98: 1.01", -- [10]
"-0.00011998052415: 0.00008906439599:0.800:111: 1.30", -- [11]
"-0.00013625600085: 0.00009451509341:0.800:122: 1.68", -- [12]
"-0.00015411267962: 0.00009756748398:0.800:138: 2.13", -- [13]
"-0.00017210566893: 0.00009642283752:0.800:148: 2.65", -- [14]
"-0.00019181617086: 0.00009069960522:0.800:163: 3.28", -- [15]
"-0.00021256263277: 0.00007854454995:0.801:177: 3.99", -- [16]
"-0.00023404517152: 0.00005804992762:0.800:191: 4.81", -- [17]
"-0.00022733869368: 0.00003030587771:0.799:171: 3.06", -- [18]
"-0.00023137348523: 0.00002044011536:0.801:189: 1.52", -- [19]
"-0.00025672724289: 0.00001068336696:0.799:211: 2.02", -- [20]
"-0.00028123587529:-0.00000555971138:0.801:229: 2.62", -- [21]
"-0.00030105542563:-0.00002976080796:0.799:244: 3.39", -- [22]
"-0.00031749447496:-0.00006404569479:0.801:255: 4.36", -- [23]
"-0.00032600025172:-0.00010994056715:0.799:268: 5.61", -- [24]
"-0.00032741788118:-0.00017022528070:0.800:280: 7.21", -- [25]
"-0.00030530831401:-0.00023187266863:0.801:240: 7.04", -- [26]
"-0.00028671555840:-0.00025912615578:0.800:274: 2.80", -- [27]
"-0.00030694404032:-0.00031303355335:0.799:304: 3.48", -- [28]
"-0.00031618589391:-0.00037282770414:0.801:325: 4.44", -- [29]
"-0.00030776190347:-0.00043425706417:0.799:336: 5.72", -- [30]
"-0.00028276255317:-0.00050331740060:0.801:342: 7.52", -- [31]
"-0.00023360897784:-0.00057390393230:0.799:357: 9.84", -- [32]
"-0.00015667531750:-0.00063865821775:0.800:329:12.33", -- [33]
"-0.00005994936891:-0.00056082225847:0.800:309: 9.17", -- [34]
"-0.00000798779677:-0.00062018035348:0.800:336: 7.04", -- [35]
" 0.00003775801544:-0.00068177323442:0.800:371: 4.94", -- [36]
" 0.00007565234140:-0.00074543738039:0.800:416: 3.10", -- [37]
" 0.00010378683378:-0.00081171786113:0.801:449: 1.48", -- [38]
" 0.00011902635048:-0.00087298370023:0.799:480: 0.04", -- [39]
" 0.00011809943890:-0.00091920561443:0.800:495:-1.24", -- [40]
" 0.00004100220594:-0.00035631209093:0.301:507:-0.77", -- [41]
"-0.55843842893552:-0.21649509138406:1.499:180:15.28:zone1", -- [42]
" 0.00018618958094:-0.00067484609132:0.801:373:-4.11", -- [43]
" 0.00015028633944:-0.00066218795568:0.799:360:-3.32", -- [44]
" 0.00012162284622:-0.00064206792296:0.801:337:-2.63", -- [45]
" 0.00009771197688:-0.00060857557963:0.799:319:-2.04", -- [46]
" 0.00008773885424:-0.00063142917861:0.801:345:-1.64:trig1", -- [47]
" 0.00007259448282:-0.00063113365793:0.799:331:-2.39", -- [48]
" 0.00004937311331:-0.00060938826149:0.801:311:-3.28", -- [49]
" 0.00002095587005:-0.00057609293195:0.800:288:-4.29", -- [50]
"-0.00001122899735:-0.00053422750279:0.799:273:-5.48", -- [51]
"-0.00004570398918:-0.00048662404717:0.801:251:-6.84", -- [52]
"-0.00008387273016:-0.00044305937411:0.800:248:-8.86", -- [53]
"-0.00013706271756:-0.00043308555129:0.799:249:-9.12", -- [54]
"-0.00017294133408:-0.00039912530022:0.800:245:-6.52", -- [55]
"-0.00019170557963:-0.00036193894844:0.800:237:-4.66", -- [56]
"-0.00019852670303:-0.00032642721383:0.802:225:-3.36", -- [57]
"-0.00019374945415:-0.00028867444741:0.798:205:-2.40", -- [58]
"-0.00018207720691:-0.00025313808607:0.800:186:-1.66", -- [59]
"-0.00016550458584:-0.00021971962292:0.801:163:-1.04", -- [60]
"-0.00014477034074:-0.00018731085540:0.803:139:-0.47", -- [61]
"-0.00017747233301:-0.00021169131121:0.797:174:-4.15", -- [62]
"-0.00016956770987:-0.00017098333803:0.800:151:-4.50", -- [63]
"-0.00015503896332:-0.00013229475614:0.799:132:-4.00", -- [64]
"-0.00014255409126:-0.00010407253154:0.800:118:-3.35", -- [65]
"-0.00013009384422:-0.00008281966957:0.800:104:-2.63", -- [66]
"-0.00011852009695:-0.00006735408750:0.801: 94:-1.94", -- [67]
"-0.00010674934974:-0.00005565639406:0.799: 85:-1.35", -- [68]
"-0.00009492935254:-0.00004664301342:0.800: 74:-0.86", -- [69]
"-0.00008306010534:-0.00003927962324:0.801: 64:-0.50", -- [70]
"-0.00007062448329:-0.00003263040803:0.799: 53:-0.25", -- [71]
"-0.00005796723629:-0.00002671999449:0.800: 43:-0.08", -- [72]
"-0.00004498986435:-0.00002058794045:0.800: 32: 0.00", -- [73]
"-0.00003166774251:-0.00001460364676:0.800: 21: 0.03", -- [74]
"-0.00001809937071:-0.00000834845911:0.801: 10: 0.04", -- [75]
"-0.00000487574885:-0.00000224103180:0.720:  2: 0.01", -- [76]
"-0.00000004924999: 0.00000000000000:60.00:  0: 0.00:plat2", -- [77]
"-0.00000763374819:-0.00000354624812:0.801: 11: 0.04", -- [78]
"-0.00002073424510:-0.00000967830215:0.800: 22: 0.11", -- [79]
"-0.00003376086701:-0.00001585960963:0.801: 33: 0.14", -- [80]
"-0.00004654123898:-0.00002196703695:0.800: 43: 0.13", -- [81]
"-0.00005897686105:-0.00002802521081:0.799: 52: 0.06", -- [82]
"-0.00007153560807:-0.00003388637090:0.800: 63:-0.11", -- [83]
"-0.00008414360509:-0.00003913186290:0.800: 74:-0.38", -- [84]
"-0.00009670235212:-0.00004329377910:0.800: 83:-0.78", -- [85]
"-0.00011046772386:-0.00004590421173:0.800: 96:-1.32", -- [86]
"-0.00012521809536:-0.00004619973242:0.801:107:-1.98", -- [87]
"-0.00014151984152:-0.00004282587135:0.799:121:-2.72", -- [88]
"-0.00016124446184:-0.00003499457344:0.801:133:-3.51", -- [89]
"-0.00018476133128:-0.00002098196802:0.799:155:-4.21", -- [90]
"-0.00021352332447: 0.00000086193531:0.800:178:-4.72", -- [91]
"-0.00024066006806: 0.00003090653740:0.801:157:-4.45", -- [92]
"-0.00018594333100: 0.00003100504430:0.799:158: 0.34", -- [93]
"-0.00021569032396: 0.00003657068371:0.800:179:-0.41", -- [94]
"-0.00024376281732: 0.00004669226687:0.800:201:-1.16", -- [95]
"-0.00026888031137: 0.00006289665064:0.800:223:-1.95", -- [96]
"-0.00028968843145: 0.00008710471937:0.801:239:-2.93", -- [97]
"-0.00030251805341: 0.00012072019631:0.799:255:-4.14", -- [98]
"-0.00030731992728: 0.00016662440806:0.800:261:-5.77", -- [99]
"-0.00030000630401: 0.00022695987948:0.800:267:-7.91", -- [100]
"-0.00027708043444: 0.00030315496056:0.800:271:-10.59", -- [101]
"-0.00021470532419: 0.00032891451285:0.801:250:-7.74", -- [102]
"-0.00020729320095: 0.00040301632246:0.799:280:-6.04", -- [103]
"-0.00020111232741: 0.00047458157961:0.801:304:-4.65", -- [104]
"-0.00019335545424: 0.00053508943809:0.799:323:-3.49", -- [105]
"-0.00018690370578: 0.00058786450556:0.801:349:-2.55", -- [106]
"-0.00017936845755: 0.00062123371527:0.800:360:-1.71", -- [107]
"-0.00017348308395: 0.00063923584982:0.799:363:-0.89:trig2", -- [108]
"-0.00016577546077: 0.00063482766638:0.800:360:-1.56", -- [109]
"-0.00014590309048: 0.00065871558773:0.800:371:-3.33", -- [110]
"-0.00012876409453: 0.00069536015161:0.800:378:-2.46", -- [111]
"-0.00011733809723: 0.00073067487244:0.801:399:-1.55", -- [112]
"-0.00011157584860: 0.00075456279378:0.799:411:-0.59", -- [113]
"-0.00011411222300: 0.00077470745322:0.800:420: 0.45", -- [114]
"-0.00009249147811: 0.00058739659783:0.600:422: 1.08", -- [115]
" 0.57101444166656: 0.21230452297035:1.500:328:-53.94:zone2", -- [116]
" 0.00022417628950: 0.00040057175405:0.501:441: 0.16", -- [117]
" 0.00036757496187: 0.00066427649568:0.799:451: 0.51", -- [118]
" 0.00035945085456: 0.00066558466305:0.801:438: 0.85", -- [119]
" 0.00033306113692: 0.00064067497581:0.800:415: 1.27", -- [120]
" 0.00029012332152: 0.00059052855946:0.800:364: 1.89", -- [121]
" 0.00023559911151: 0.00052413906477:0.800:299: 2.96", -- [122]
" 0.00025757236814: 0.00067348817433:0.800:407: 4.92", -- [123]
" 0.00020326625496: 0.00065201242646:0.800:354: 4.61", -- [124]
" 0.00015201349754: 0.00059701488940:0.799:320: 3.65", -- [125]
" 0.00011834479785: 0.00054953931479:0.800:288: 2.35", -- [126]
" 0.00009937037277: 0.00050778697249:0.800:266: 0.81", -- [127]
" 0.00009307282650: 0.00047421067632:0.801:249:-0.77", -- [128]
" 0.00011564584946: 0.00058218899240:0.800:314: 0.96", -- [129]
" 0.00009519927070: 0.00054065467798:0.799:280: 2.28", -- [130]
" 0.00006924574672: 0.00049110783835:0.801:249: 3.33", -- [131]
" 0.00004239257330: 0.00044962803092:0.800:229: 4.29", -- [132]
" 0.00001603011774: 0.00041550666502:0.799:212: 5.06", -- [133]
"-0.00001098662832: 0.00042995101320:0.801:236: 5.58", -- [134]
"-0.00003835778175: 0.00042569946920:0.800:216: 5.61", -- [135]
"-0.00006109437733: 0.00038792613602:0.799:203: 5.52", -- [136]
"-0.00007946903610: 0.00035173350510:0.801:189: 5.31", -- [137]
"-0.00009348175808: 0.00031624946483:0.800:173: 5.05", -- [138]
"-0.00010405945483: 0.00028392682908:0.800:162: 4.74", -- [139]
"-0.00010828508110: 0.00024648053774:0.800:146: 4.43", -- [140]
"-0.00011155653371: 0.00021721029254:0.800:141: 3.99", -- [141]
"-0.00011311047369: 0.00019268215412:0.800:131: 3.53", -- [142]
"-0.00011251070738: 0.00017093387137:0.800:121: 3.10", -- [143]
"-0.00010981175898: 0.00015076629089:0.800:114: 2.69", -- [144]
"-0.00010468648324: 0.00013163434291:0.799:104: 2.33", -- [145]
"-0.00009819810225: 0.00011446464601:0.801: 93: 1.99", -- [146]
"-0.00008993768443: 0.00009811255372:0.799: 82: 1.68", -- [147]
"-0.00008055952031: 0.00008301412184:0.800: 71: 1.41", -- [148]
"-0.00007006360988: 0.00006884230853:0.800: 61: 1.15", -- [149]
"-0.00005847721524: 0.00005521556496:0.801: 49: 0.92", -- [150]
"-0.00004607295747: 0.00004218839810:0.800: 37: 0.69", -- [151]
"-0.00003325976812: 0.00002976080796:0.800: 25: 0.49", -- [152]
"-0.00001984681244: 0.00001755124572:0.799: 13: 0.28", -- [153]
"-0.00000616123574: 0.00000534168348:0.779:  1: 0.09", -- [154]
},
["fms2fer"] = {
" 0.12287269791921: 0.63374718844665:30.00:  4:90.26:plat1", -- [1]
" 0.00000665510595: 0.00000007906693:0.801: 10: 0.00", -- [2]
" 0.00001944909370: 0.00000033022071:0.801: 19: 0.03", -- [3]
" 0.00003241050550: 0.00000054416651:0.799: 30: 0.03", -- [4]
" 0.00004561840270: 0.00000078601830:0.800: 41: 0.05", -- [5]
" 0.00005917975067: 0.00000115344697:0.800: 51: 0.06", -- [6]
" 0.00007315965877: 0.00000153017764:0.801: 62: 0.06", -- [7]
" 0.00008766509236: 0.00000199062622:0.799: 74: 0.08", -- [8]
" 0.00010284022214: 0.00000254874572:0.801: 86: 0.08", -- [9]
" 0.00011798744790: 0.00000319058315:0.799: 98: 0.08", -- [10]
" 0.00013467869547: 0.00000393009150:0.800:113: 0.08", -- [11]
" 0.00015143505238: 0.00000475331775:0.801:124: 0.09", -- [12]
" 0.00016830302532: 0.00000565561095:0.799:139: 0.08", -- [13]
" 0.00018644528130: 0.00000666022606:0.801:153: 0.07", -- [14]
" 0.00020394574509: 0.00000771600211:0.800:164: 0.07", -- [15]
" 0.00022262282791: 0.00000879968414:0.800:180: 0.06", -- [16]
" 0.00024014654504: 0.00000983220523:0.799:196: 0.06", -- [17]
" 0.00025823299300: 0.00001093914223:0.800:209: 0.04", -- [18]
" 0.00027582181949: 0.00001193910634:0.801:221: 0.03", -- [19]
" 0.00029178291217: 0.00001281349356:0.800:238: 0.01", -- [20]
" 0.00030635345511: 0.00001350184095:0.799:249: 0.00", -- [21]
" 0.00031991945375: 0.00001404600746:0.800:259:-0.02", -- [22]
" 0.00033080201693: 0.00001420879231:0.800:264:-0.05", -- [23]
" 0.00033923367808: 0.00001405996045:0.802:269:-0.08", -- [24]
" 0.00034287050047: 0.00001333905609:0.798:274:-0.11", -- [25]
" 0.00034397270880: 0.00001217165614:0.801:270:-0.17", -- [26]
" 0.00033875000860: 0.00001024614385:0.800:264:-0.24", -- [27]
" 0.00032807207480: 0.00000752996228:0.800:251:-0.34", -- [28]
" 0.00031610125530: 0.00000401380941:0.799:274:-0.49", -- [29]
" 0.00056166117792:-0.00000406031937:0.800:407:-1.06", -- [30]
" 0.00047861419892:-0.00001736681850:0.800:353:-1.17", -- [31]
" 0.00041741605831:-0.00002761761334:0.800:308:-1.04", -- [32]
" 0.00038636354789:-0.00003407319558:0.801:295:-0.49", -- [33]
" 0.00038936787943:-0.00003559407123:0.799:314: 0.39", -- [34]
" 0.00043594431975:-0.00003095237736:0.800:366: 1.16", -- [35]
" 0.00047834911084:-0.00003356623704:0.800:370:-1.94", -- [36]
" 0.00046568999246:-0.00005604915096:0.800:369:-0.98", -- [37]
" 0.00047940946316:-0.00005731422183:0.800:390: 1.28", -- [38]
" 0.00052397216421:-0.00003152910086:0.800:428: 3.26", -- [39]
" 0.00059304853645: 0.00002416192343:0.800:493: 4.26", -- [40]
" 0.00055437358112: 0.00008029014133:0.801:362: 3.47", -- [41]
" 0.00049956080772: 0.00010838215624:0.800:416: 1.82", -- [42]
" 0.00054449556222: 0.00013987870012:0.799:448: 1.16", -- [43]
" 0.00057277627451: 0.00016207790331:0.801:456: 0.77:trig1", -- [44]
" 0.00058170555713: 0.00017451466620:0.799:466: 0.47", -- [45]
" 0.00057203216763: 0.00017725875375:0.800:448: 0.24", -- [46]
" 0.00054431883684: 0.00017068224563:0.801:423: 0.00", -- [47]
" 0.00049660298285: 0.00015403633148:0.800:378:-0.29", -- [48]
" 0.00045629564305: 0.00014410180435:0.799:394:-1.69", -- [49]
" 0.00045650492310: 0.00009876389683:0.800:338:-3.37", -- [50]
" 0.00039907382361: 0.00005843511183:0.800:297:-1.63", -- [51]
" 0.00034894892359: 0.00004396121276:0.801:259: 0.46", -- [52]
" 0.00030384674504: 0.00004961682370:0.800:225: 2.87", -- [53]
" 0.00026569731519: 0.00007086722374:0.799:204: 5.48", -- [54]
" 0.00023236132676: 0.00010341489267:0.800:184: 7.98", -- [55]
" 0.00020361089700: 0.00014390646253:0.800:174: 9.71", -- [56]
" 0.00018083657565: 0.00019120709030:0.801:175: 7.84", -- [57]
" 0.00015828548639: 0.00020156950905:0.799:156: 3.63", -- [58]
" 0.00013206036936: 0.00019467673320:0.801:138: 5.15", -- [59]
" 0.00010927209602: 0.00019522089972:0.800:129: 6.08", -- [60]
" 0.00009005553573: 0.00020127184531:0.799:124: 6.22", -- [61]
" 0.00007384795764: 0.00021042965614:0.801:124: 5.75", -- [62]
" 0.00005954715345: 0.00021783404153:0.799:125: 4.90", -- [63]
" 0.00004779026467: 0.00022446171061:0.800:124: 3.97", -- [64]
" 0.00003792154711: 0.00022751741489:0.800:122: 3.13", -- [65]
" 0.00002980148073: 0.00022645233683:0.800:120: 2.42", -- [66]
" 0.00002321613481: 0.00022084323585:0.801:115: 1.86", -- [67]
" 0.00001779345588: 0.00020946224900:0.799:107: 1.43", -- [68]
" 0.00001351949196: 0.00019383955395:0.800: 97: 1.08", -- [69]
" 0.00001009194962: 0.00017301704554:0.801: 85: 0.82", -- [70]
" 0.00000736200749: 0.00014785050701:0.799: 71: 0.60", -- [71]
" 0.00000515759085: 0.00011866550806:0.800: 54: 0.44", -- [72]
" 0.00000339963833: 0.00008673642156:0.800: 38: 0.29", -- [73]
" 0.00000190677389: 0.00005217022043:0.800: 19: 0.16", -- [74]
" 0.00000057203217: 0.00001638080738:0.766:  1: 0.05", -- [75]
" 0.00000000000000: 0.00000001395298:30.00:  0: 0.00:plat2", -- [76]
" 0.00000024183473: 0.00000738578141:0.801:  7: 0.00", -- [77]
" 0.00000073945622: 0.00002206897530:0.801: 15:-0.01", -- [78]
" 0.00000123707770: 0.00003710564487:0.800: 23:-0.02", -- [79]
" 0.00000178585652: 0.00005262601802:0.799: 31:-0.01", -- [80]
" 0.00000235788869: 0.00006923937519:0.800: 40:-0.02", -- [81]
" 0.00000296712620: 0.00008682013949:0.800: 49: 0.00", -- [82]
" 0.00000362752107: 0.00010567062566:0.800: 60: 0.01", -- [83]
" 0.00000428791592: 0.00012593036358:0.801: 70: 0.02", -- [84]
" 0.00000499016680: 0.00014764121219:0.799: 83: 0.06", -- [85]
" 0.00000562730831: 0.00017109153326:0.800: 96: 0.08", -- [86]
" 0.00000625049783: 0.00019581157619:0.800:107: 0.12", -- [87]
" 0.00000674346865: 0.00022288037202:0.800:123: 0.16", -- [88]
" 0.00000706436473: 0.00025077704512:0.800:137: 0.21", -- [89]
" 0.00000714342610: 0.00028056202253:0.801:153: 0.26", -- [90]
" 0.00000685043400: 0.00031040746288:0.800:169: 0.33", -- [91]
" 0.00000612492980: 0.00034215516055:0.799:187: 0.40", -- [92]
" 0.00000481809208: 0.00037394006616:0.800:204: 0.47", -- [93]
" 0.00000278109948: 0.00040575287777:0.800:220: 0.58", -- [94]
"-0.00000017207472: 0.00043691454994:0.800:236: 0.68", -- [95]
"-0.00000419025189: 0.00046617396483:0.800:247: 0.81", -- [96]
"-0.00000952456813: 0.00049520548090:0.800:266: 0.97", -- [97]
"-0.00001638430347: 0.00051946042426:0.800:278: 1.17", -- [98]
"-0.00002507175134: 0.00054108755494:0.801:289: 1.40", -- [99]
"-0.00003574038381: 0.00055556145402:0.800:297: 1.72", -- [100]
"-0.00004889712366: 0.00056580759788:0.799:301: 2.10", -- [101]
"-0.00006473729897: 0.00056768194920:0.800:303: 2.63", -- [102]
"-0.00008367481919: 0.00056034732875:0.800:300: 3.34", -- [103]
"-0.00010592826571: 0.00054153405055:0.800:293: 4.32", -- [104]
"-0.00013427873801: 0.00051794885060:0.801:307: 5.48", -- [105]
"-0.00017304205604: 0.00053184602620:0.800:303: 3.94", -- [106]
"-0.00018924033279: 0.00048610813303:0.800:288: 4.70", -- [107]
"-0.00021057759771: 0.00044721185475:0.799:281: 5.20", -- [108]
"-0.00023969543024: 0.00042102674813:0.801:297: 5.18", -- [109]
"-0.00027454753645: 0.00040507848337:0.799:313: 4.54", -- [110]
"-0.00031916604553: 0.00040760397411:0.800:345: 3.44", -- [111]
"-0.00037298357596: 0.00042964969443:0.800:392: 2.16", -- [112]
"-0.00043747438953: 0.00047547130552:0.800:454: 0.95", -- [113]
"-0.00051199669403: 0.00054697571569:0.801:521:-0.04", -- [114]
"-0.00058727705743: 0.00063655389572:0.800:600:-0.72", -- [115]
"-0.00055901029714: 0.00062497291606:0.800:313:-0.79", -- [116]
"-0.00033408073790: 0.00037826549230:0.800:342: 0.04", -- [117]
"-0.00036225448482: 0.00040939925851:0.799:365: 0.07", -- [118]
"-0.00038911674336: 0.00043844937858:0.801:389: 0.09", -- [119]
"-0.00041131903253: 0.00046162063988:0.799:414: 0.13", -- [120]
"-0.00043226099067: 0.00048275476503:0.801:428: 0.14", -- [121]
"-0.00045055671870: 0.00050029832136:0.800:447: 0.18", -- [122]
"-0.00046440640808: 0.00051222347471:0.799:460: 0.19", -- [123]
"-0.00047661441167: 0.00052173011023:0.800:464: 0.22", -- [124]
"-0.00048796669233: 0.00052951587727:0.801:476: 0.26", -- [125]
"-0.00049353354195: 0.00053036235852:0.800:484: 0.28", -- [126]
"-0.00049695643363: 0.00052812988052:0.799:480: 0.32", -- [127]
"-0.00049888181019: 0.00052355330059:0.801:469: 0.36", -- [128]
"-0.00049807259395: 0.00051526522600:0.800:469: 0.42", -- [129]
"-0.00049208718420: 0.00050076342095:0.799:461: 0.47", -- [130]
"-0.00048702260672: 0.00048630812585:0.800:460: 0.54", -- [131]
"-0.00047616794753: 0.00046518330270:0.800:438: 0.63", -- [132]
"-0.00046499704293: 0.00044264457683:0.800:426: 0.73", -- [133]
"-0.00044874760883: 0.00041425489818:0.800:399: 0.87", -- [134]
"-0.00043146107577: 0.00038376296940:0.800:381: 1.05", -- [135]
"-0.00041185385935: 0.00034995953157:0.801:361: 1.28", -- [136]
"-0.00038701464141: 0.00031039816089:0.799:331: 1.58", -- [137]
"-0.00052739040522: 0.00038974415006:0.800:543: 1.94", -- [138]
"-0.00059040695701: 0.00039846941827:0.800:480: 2.42", -- [139]
"-0.00052956226718: 0.00031374687790:0.800:430: 2.99", -- [140]
"-0.00048372993375: 0.00024064252517:0.800:382: 3.48", -- [141]
"-0.00045459349854: 0.00017952843972:0.800:360: 3.71", -- [142]
"-0.00043798131235: 0.00012847910930:0.800:344: 3.56", -- [143]
"-0.00043845568048: 0.00008920610036:0.800:347: 2.98", -- [144]
"-0.00045267277265: 0.00006070479781:0.801:365: 2.10", -- [145]
"-0.00048044191145: 0.00004333797931:0.800:389: 1.12", -- [146]
"-0.00052478138045: 0.00003766376438:0.799:428: 0.24", -- [147]
"-0.00058410530183: 0.00004333797931:0.801:484:-0.44", -- [148]
"-0.00065681384581: 0.00006043504004:0.800:547:-0.90", -- [149]
"-0.00049307312582: 0.00005690958520:0.799:355:-0.85", -- [150]
"-0.00046982908701: 0.00006316982560:0.801:379:-0.52", -- [151]
"-0.00050167221101: 0.00007280668900:0.799:412:-0.28", -- [152]
"-0.00053089700890: 0.00007982969274:0.801:421:-0.10", -- [153]
"-0.00055513629068: 0.00008379234119:0.799:442: 0.06", -- [154]
"-0.00057567364069: 0.00008501090211:0.801:456: 0.20", -- [155]
"-0.00058963029545: 0.00008295516194:0.799:466: 0.33", -- [156]
"-0.00060060587200: 0.00007823905215:0.800:478: 0.47", -- [157]
"-0.00060793997548: 0.00007074164685:0.800:472: 0.60", -- [158]
"-0.00061011648812: 0.00006022109424:0.800:471: 0.75", -- [159]
"-0.00060866547970: 0.00004691924611:0.800:482: 0.92", -- [160]
"-0.00060126161619: 0.00003052913674:0.800:470: 1.11", -- [161]
"-0.00059023023162: 0.00001139493983:0.801:451: 1.33", -- [162]
"-0.00057475280843:-0.00001066938447:0.799:446: 1.59", -- [163]
"-0.00055493166128:-0.00003550570231:0.800:430: 1.93", -- [164]
"-0.00053067842751:-0.00006324424153:0.800:415: 2.34", -- [165]
"-0.00050208612046:-0.00009377337829:0.800:389: 2.87", -- [166]
"-0.00046908498013:-0.00012714892449:0.800:365: 3.54", -- [167]
"-0.00043176569452:-0.00016327786023:0.800:340: 4.45", -- [168]
"-0.00038973295687:-0.00020194623971:0.800:311: 5.62", -- [169]
"-0.00044350630597:-0.00031804439807:0.800:424: 6.70", -- [170]
"-0.00044148094003:-0.00041588274672:0.800:401: 6.84", -- [171]
"-0.00039493937973:-0.00047870839864:0.801:397: 6.73", -- [172]
"-0.00035031621999:-0.00053534822607:0.800:386: 6.38", -- [173]
"-0.00031045534431:-0.00058961604562:0.799:396: 5.87", -- [174]
"-0.00027310117870:-0.00063802361040:0.800:397: 5.24", -- [175]
"-0.00024014654503:-0.00068442194499:0.800:413: 4.58", -- [176]
"-0.00020933586935:-0.00072298800255:0.800:414: 3.91", -- [177]
"-0.00018326654970:-0.00076166568402:0.801:428: 3.29", -- [178]
"-0.00015923422266:-0.00079020419455:0.800:434: 2.71", -- [179]
"-0.00013975257429:-0.00081916129470:0.800:452: 2.19", -- [180]
"-0.00012284739600:-0.00083855594738:0.799:451: 1.70", -- [181]
"-0.00011035802700:-0.00085989471633:0.800:457: 1.26", -- [182]
"-0.00010073346952:-0.00087248031109:0.801:462: 0.85", -- [183]
"-0.00008118438646:-0.00077099558170:0.799:361: 1.54", -- [184]
"-0.00005693347801:-0.00070992800621:0.800:386: 2.12", -- [185]
"-0.00004337213005:-0.00075745188179:0.800:409: 1.77", -- [186]
"-0.00003027119820:-0.00079938526035:0.801:428: 1.53", -- [187]
"-0.00001757254915:-0.00083260267269:0.800:444: 1.34", -- [188]
"-0.00000541802826:-0.00085797850605:0.799:452: 1.20", -- [189]
" 0.00000629467918:-0.00088211717449:0.800:466: 1.10", -- [190]
" 0.00001756324782:-0.00089529809672:0.800:468: 1.04", -- [191]
" 0.00002837372564:-0.00090291177693:0.801:471: 0.99", -- [192]
" 0.00003872378735:-0.00090383267410:0.799:475: 0.97", -- [193]
" 0.00003556598376:-0.00067456648479:0.600:468: 0.72:trig2", -- [194]
" 0.00005573825633:-0.00088955411685:0.800:466: 0.98", -- [195]
" 0.00006549535786:-0.00087978702557:0.807:452: 1.02", -- [196]
" 0.00007282016000:-0.00083975590431:0.793:443: 1.08", -- [197]
" 0.00008180990131:-0.00081877061104:0.800:422: 1.18", -- [198]
" 0.00008957186625:-0.00078143706738:0.801:407: 1.31", -- [199]
" 0.00009673156968:-0.00073657356142:0.800:384: 1.51", -- [200]
" 0.00010339597696:-0.00068524052026:0.799:358: 1.77", -- [201]
" 0.00010982320019:-0.00062906114140:0.801:325: 2.17", -- [202]
" 0.00013781092038:-0.00066409244214:0.799:546: 3.15", -- [203]
" 0.00024158127613:-0.00092129716351:0.800:497: 5.39", -- [204]
" 0.00027361740284:-0.00079990617189:0.800:458: 6.07", -- [205]
" 0.00030403974776:-0.00069014266987:0.800:421: 6.54", -- [206]
" 0.00033424583662:-0.00059565768923:0.801:400: 6.68", -- [207]
" 0.00036218007413:-0.00051248858148:0.799:385: 6.39", -- [208]
" 0.00039040032773:-0.00044467706201:0.800:385: 5.70", -- [209]
" 0.00041650452739:-0.00038907440666:0.800:385: 4.75", -- [210]
" 0.00044308076984:-0.00034823866311:0.800:394: 3.63", -- [211]
" 0.00046741771563:-0.00031995130636:0.801:406: 2.50", -- [212]
" 0.00048929213272:-0.00030451930214:0.799:420: 1.40", -- [213]
" 0.00044820115534:-0.00023132192949:0.800:383: 6.21", -- [214]
" 0.00048795274032:-0.00017358911803:0.800:402: 4.82", -- [215]
" 0.00050937604260:-0.00012251188163:0.800:406: 3.60", -- [216]
" 0.00052081436061:-0.00008147614526:0.800:409: 2.68", -- [217]
" 0.00052354895342:-0.00004935636794:0.800:415: 2.00", -- [218]
" 0.00051687524480:-0.00002509677359:0.800:400: 1.46", -- [219]
" 0.00050634148171:-0.00000787878697:0.800:393: 1.03", -- [220]
" 0.00048854802583: 0.00000337197199:0.800:382: 0.66", -- [221]
" 0.00046755025968: 0.00000950663551:0.801:356: 0.34", -- [222]
" 0.00044126933464: 0.00001138098684:0.799:339: 0.04", -- [223]
" 0.00041443498011: 0.00000975313830:0.801:316:-0.25", -- [224]
" 0.00038306157358: 0.00000526492730:0.799:289:-0.54", -- [225]
" 0.00035320428484:-0.00000139994975:0.800:267:-0.87", -- [226]
" 0.00032071471798:-0.00000972058132:0.801:242:-1.22", -- [227]
" 0.00038020606341:-0.00002233408207:0.800:290:-0.27", -- [228]
" 0.00038403821387:-0.00002019462397:0.800:287: 0.38", -- [229]
" 0.00034310768455:-0.00001459017397:0.799:258: 0.40", -- [230]
" 0.00031050650165:-0.00001003219805:0.800:235: 0.38", -- [231]
" 0.00028326753901:-0.00000639511929:0.801:211: 0.36", -- [232]
" 0.00026076760708:-0.00000352080385:0.799:196: 0.33", -- [233]
" 0.00024209517494:-0.00000129762785:0.800:185: 0.29", -- [234]
" 0.00022635266367: 0.00000035812669:0.800:173: 0.24", -- [235]
" 0.00021313081445: 0.00000161389555:0.801:165: 0.19", -- [236]
" 0.00020069957881: 0.00000238596087:0.799:156: 0.14", -- [237]
" 0.00019033789045: 0.00000287431544:0.801:146: 0.11", -- [238]
" 0.00017954834061: 0.00000320918713:0.799:138: 0.07", -- [239]
" 0.00016987030045: 0.00000327430108:0.801:129: 0.04", -- [240]
" 0.00015921096932: 0.00000320453614:0.799:122: 0.02", -- [241]
" 0.00014880742494: 0.00000306035527:0.800:113: 0.00", -- [242]
" 0.00013766907501: 0.00000278129551:0.800:104:-0.01", -- [243]
" 0.00012599589825: 0.00000253014175:0.803: 93:-0.02", -- [244]
" 0.00011314145182: 0.00000220457203:0.797: 85:-0.02", -- [245]
" 0.00009986844527: 0.00000189295531:0.800: 73:-0.03", -- [246]
" 0.00008604200921: 0.00000156273460:0.800: 62:-0.02", -- [247]
" 0.00007110871417: 0.00000126507087:0.800: 50:-0.02", -- [248]
" 0.00005592428306: 0.00000096740714:0.800: 39:-0.02", -- [249]
" 0.00004010271041: 0.00000066044141:0.801: 26:-0.01", -- [250]
" 0.00002381607098: 0.00000039533465:0.799: 13:-0.01", -- [251]
" 0.00000773871160: 0.00000014883186:0.778:  2: 0.00", -- [252]
},

}
