----------------------------------------------------------------------------------------------------
-- Credits to Tuller and also Tekkub
local NaturOptions = CreateFrame("Frame", "NaturOptionsFrame");
local media = LibStub:GetLibrary("LibSharedMedia-3.0");
local addon = LibStub:GetLibrary("NaturCombat");
----------------------------------------------------------------------------------------------------
function NaturOptions:OnLoad()
	self.name = "NaturCombat";
	
	local bar = self:CreateBarPanel();
	bar:SetPoint("TOPLEFT", 10, -60);
	
	local general = self:CreateGeneralPanel();
	general:SetPoint("BOTTOMLEFT", 10, 10);
	
	InterfaceOptions_AddCategory(self);
end
----------------------------------------------------------------------------------------------------
local function HideTooltip()
	GameTooltip:Hide()
end
local function ShowTooltip(self)
	if self.tiptext then
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:SetText(self.tiptext, nil, nil, nil, nil, true);
	end
end
----------------------------------------------------------------------------------------------------
-- Create options
function NaturOptions:CreateGeneralPanel()
	local p = self:CreatePanel("General Options");
	p:SetHeight(120);
	p:SetWidth(367);
	
	-- Locked (CHECKBOX)
	local lock = self:CreateCheckBox("Locked", p, "Unlock/Lock the bars.");
	lock:SetScript("OnShow", function(self)
		self:SetChecked(not NaturDB.Lock);
	end);
	lock:SetScript("OnClick", function(self)
		if (self:GetChecked()) then
			NaturDB.Lock = false;
		else
			NaturDB.Lock = true;
		end
		addon.group:SetAnchorVisible(NaturDB.Lock);
	end);
	lock:SetPoint("TOPLEFT", 10, -8);
	-- Cooldowns (CHECKBOX)
	local cd = self:CreateCheckBox("Cooldowns", p, "Turn on/off displaying cooldowns.");
	cd:SetScript("OnShow", function(self)
		self:SetChecked(NaturDB.Cooldowns);
	end);
	cd:SetScript("OnClick", function(self)
		if (self:GetChecked()) then
			NaturDB.Cooldowns = true;
		else
			NaturDB.Cooldowns = false;
		end
	end);
	cd:SetPoint("TOPLEFT", lock, "BOTTOMLEFT", 0, 0);
	-- Diminish Returns (CHECKBOX)
	local dr = self:CreateCheckBox("Diminishing Returns", p, "Turn on/off displaying diminishing returns.");
	dr:SetScript("OnShow", function(self)
		self:SetChecked(NaturDB.Diminishing);
	end);
	dr:SetScript("OnClick", function(self)
		if (self:GetChecked()) then
			NaturDB.Diminishing = true;
		else
			NaturDB.Diminishing = false;
		end
	end);
	dr:SetPoint("LEFT", lock, "RIGHT", 100, 0);
	-- Test Bars (BUTTON)
	local test = self:CreateButton(p, "Test Bars", "Create 3 bars to test settings.");
	test:SetPoint("TOPLEFT", lock, "BOTTOMLEFT", 0, -40);
	test:SetScript("OnClick", function(self)
		for i = 1, 3 do
			addon.group:RegisterBar("Testing"..i, "Testing NaturCombat Bar #"..i, 10, nil, "Interface\\Icons\\Spell_Holy_HolyProtection", 0, 1, 0);
		end
	end);
	local sound = self:CreateCheckBox("Killing Blow Sounds", p, "Turn on/off sounds when you get a killing blow.");
	sound:SetScript("OnShow", function(self)	
		self:SetChecked(NaturDB.Sounds);
	end);
	sound:SetScript("OnClick", function(self)
		if (self:GetChecked()) then
			NaturDB.Sounds = true;
		else
			NaturDB.Sounds = false;
		end
	end);
	sound:SetPoint("TOPLEFT", dr, "BOTTOMLEFT", 0, 0);
	return p;
end
----------------------------------------------------------------------------------------------------
function NaturOptions:CreateBarPanel()
	local p = self:CreatePanel("Bar Options");
	p:SetWidth(367);
	p:SetHeight(200);
	-- Header!
	local header = self:CreateHeader(self, "NaturCombat");
	header:SetPoint("TOPLEFT", 16, -16);
	
	-- Height (SLIDER)
	local height = self:CreateSlider("Height", p, 0, 30, 1, "Change the height of the bars");
	height:SetScript("OnShow", function(self)
		self.onShow = true;
		self:SetValue(addon.group:GetHeight());
		self.onShow = nil;
	end);
	height:SetScript("OnValueChanged", function(self, v)
		self.valText:SetText(format("%.1f", v));
		if not self.onShow then
			addon.group:SetHeight(v);
			NaturDB.Height = v;
		end
	end);
	height:SetPoint("TOPLEFT", 10, -20);
	
	-- Width (SLIDER)
	local width = self:CreateSlider("Width", p, 50, 300, 1, "Change the width of the bars");
	width:SetScript("OnShow", function(self)
		self.onShow = true;
		self:SetValue(addon.group:GetWidth());
		self.onShow = nil;
	end);
	width:SetScript("OnValueChanged", function(self, v)
		self.valText:SetText(format("%.1f", v));
		if not self.onShow then
			addon.group:SetWidth(v);
			NaturDB.Width = v;
		end
	end);
	width:SetPoint("TOPLEFT", height, "BOTTOMLEFT", 0, -20);
	
	-- Scale (SLIDER)
	local scale = self:CreateSlider("Scale", p, 1, 5, 1, "Change the scale of the bars");
	scale:SetScript("OnShow", function(self)
		self.onShow = true;
		self:SetValue(addon.group:GetScale());
		self.onShow = nil;
	end);
	scale:SetScript("OnValueChanged", function(self, v)
		self.valText:SetText(format("%.1f",v));
		if not self.onShow then
			addon.group:SetScale(v);
			NaturDB.Scale = v;
		end
	end);
	scale:SetPoint("LEFT", height, "RIGHT", 50, 0);
	
	--Font Size (SLIDER)
	local font = self:CreateSlider("Font Size", p, 1, 30, 1, "Change the font size on the bars");
	font:SetScript("OnShow", function(self)
		self.onShow = true;
		self:SetValue(addon.group:GetFontSize());
		self.onShow = nil;
	end);
	font:SetScript("OnValueChanged", function(self, v)
		self.valText:SetText(format("%.1f",v));
		if not self.onShow then
			addon.group:SetGroupFontSize(v);
			NaturDB.FontSize = v;
		end
	end);
	font:SetPoint("TOPLEFT", scale, "BOTTOMLEFT", 0, -20);
	
	-- Max Bars (SLIDER)
	local maxbars = self:CreateSlider("Max Bars", p, 1, 20, 1, "Change how many bars are shown at one time");
	maxbars:SetScript("OnShow", function(self)
		self.onShow = true;
		self:SetValue(addon.group:GetMaxBars());
		self.onShow = nil;
	end);
	maxbars:SetScript("OnValueChanged", function(self, v)
		self.valText:SetText(format("%.1f",v));
		if not self.onShow then
			addon.group:SetMaxBars(v);
			NaturDB.MaxBars = v;
		end
	end);
	maxbars:SetPoint("TOPLEFT", font, "BOTTOMLEFT", 0, -20);
	
	--Invert (CHECKBOX)
	local invert = self:CreateCheckBox("Invert", p, "Set the fill of the bar to be inverted");
	invert:SetScript("OnShow", function(self) self:SetChecked(addon.group:GetReversed()); end);
	invert:SetScript("OnClick", function(self)
		if (self:GetChecked()) then
			addon.group:SetInvert(true); 
			NaturDB.Invert = true;
		else
			addon.group:SetInvert(false); 
			NaturDB.Invert = false
		end
	end);
	invert:SetPoint("TOPLEFT", width, "BOTTOMLEFT", 0, -10);
	
	-- Growth (CHECKBOX)
	local growth = self:CreateCheckBox("Grow Up", p, "Set whether the bars grow up or down");
	growth:SetScript("OnShow", function(self) self:SetChecked(addon.group:GetGrowth()); end);
	growth:SetScript("OnClick", function(self) 
		local val = self:GetChecked();
		local value;
		if (val == 1) then
			value = "UP";
		else
			value = "DOWN";
		end
		addon.group:SetBarGrowth(value);
		NaturDB.Growth = value;
	end);
	growth:SetPoint("TOPLEFT", invert, "BOTTOMLEFT", 0, 0);
	
	-- Texture (DROPDOWN) --yuck
	local texture = self:CreateDropDown("Texture", p);
	texture:SetPoint("TOPLEFT", maxbars, "BOTTOMLEFT", 0, -40);
	
	return p;
end
----------------------------------------------------------------------------------------------------
function NaturOptions:CreateButton(panel, name, tiptext)
	local f = CreateFrame("Button", panel:GetName().."Buttons", panel, "UIPanelButtonTemplate");
	f:SetHeight(30);
	f:SetWidth(100);
	getglobal(panel:GetName().."Buttons".."Text"):SetText(name);
	f:SetScript("OnEnter", ShowTooltip);
	f:SetScript("OnLeave", HideTooltip);
	f.tiptext = tiptext;
	return f;
end
function NaturOptions:CreateHeader(panel, header)
	local h = panel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge");
	h:SetText(header);
	return h;
end
----------------------------------------------------------------------------------------------------
function NaturOptions:CreateSlider(text, panel, low, high, step, tiptext)
	local name = panel:GetName()..text;
	local slider = CreateFrame("Slider", name, panel, "OptionsSliderTemplate");
	slider:SetMinMaxValues(low, high);
	slider:SetValueStep(step);
	slider:SetScript("OnEnter", ShowTooltip);
	slider:SetScript("OnLeave", HideTooltip);
	slider.tiptext = tiptext;
	getglobal(name.."Text"):SetText(text);
	getglobal(name.."Low"):SetText("");
	getglobal(name.."High"):SetText("");
	local t = slider:CreateFontString(nil, "BACKGROUND");
	t:SetFontObject("GameFontHighlightSmall");
	t:SetPoint("LEFT", slider, "RIGHT", 7, 0);
	slider.valText = t;
	return slider;
end
----------------------------------------------------------------------------------------------------
function NaturOptions:CreateCheckBox(name, panel, tiptext)
	local b = CreateFrame("CheckButton", panel:GetName()..name, panel, "OptionsCheckButtonTemplate");
	b.tiptext = tiptext;
	b:SetWidth(40);
	b:SetScript("OnEnter", ShowTooltip);
	b:SetScript("OnLeave", HideTooltip);
	getglobal(b:GetName().."Text"):SetText(name);
	return b;
end
----------------------------------------------------------------------------------------------------
function NaturOptions:CreateDropDown(name, panel)
	local f = CreateFrame("Frame", panel:GetName()..name, panel, "UIDropDownMenuTemplate");
	local t = f:CreateFontString(nil, "BACKGROUND");
	t:SetPoint("BOTTOMLEFT", f, "TOPLEFT", 21, 0);
	t:SetFontObject("GameFontNormalSmall");
	t:SetText(name);
	f:SetScript("OnShow", function(self)
		UIDropDownMenu_SetWidth(132, self)
		getglobal(self:GetName().."Text"):SetText(NaturDB.Texture);
	end);
	local function ListButton_OnClick(self)
		addon.group:SetTexture(media:Fetch("statusbar", self.texture));
		NaturDB.Texture = self.texture;
		local p = self:GetParent();
		p:Hide();
		local t = getglobal(p:GetParent():GetName().."Text");
		t:SetText(NaturDB.Texture);
	end
	local function ListButton_Create(parent)
		local b = CreateFrame("Button", nil, parent);
		b:SetHeight(UIDROPDOWNMENU_BUTTON_HEIGHT);
		local t = b:CreateFontString();
		t:SetJustifyH("LEFT");
		t:SetPoint("LEFT", 27, 0);
		b.text = t;
		local c = b:CreateTexture(nil, "ARTWORK");
		c:SetWidth(24);
		c:SetHeight(24);
		c:SetTexture("Interface\\Buttons\\UI-CheckBox-Check");
		c:SetPoint("LEFT");
		b.check = c;
		local h = b:CreateTexture(nil, "BACKGROUND");
		h:SetAllPoints(b);
		h:SetTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight");
		h:SetAlpha(0.4);
		h:SetBlendMode("ADD");
		h:Hide();
		b:SetHighlightTexture(h);
		b:SetScript("OnClick", ListButton_OnClick);
		return b;
	end
	local function List_UpdateWidth(self)
		self.width = 0;
		for name, texture in pairs(media:HashTable("statusbar")) do
			self.text:SetFontObject("GameFontHighlight");
			self.text:SetText(name);
			self.width = max(self.text:GetWidth()+60, self.width);
		end
	end
	local function List_Update(self)
		local textures = media:List("statusbar");--64
		local numTextures = #textures;
		local scrollFrame = self.scrollFrame;
		local listSize = min(numTextures, 10);
		
		FauxScrollFrame_Update(scrollFrame, numTextures, listSize, UIDROPDOWNMENU_BUTTON_HEIGHT);
		
		for i = 1, listSize do
			local index = i + scrollFrame.offset;
			local button = self.buttons[i];
			local texture = textures[index];
			if (texture) then
				button.texture = texture;
				button.text:SetFontObject("GameFontHighlight");
				button.text:SetText(texture);
				if (texture == NaturDB.Texture) then
					button.check:Show();
				else
					button.check:Hide();
				end
				button:SetWidth(self.width);
				button:Show();
			else
				button:Hide();
			end
			for i = listSize+1, #self.buttons do
				self.buttons[i]:Hide();
			end
			if (self.scrollFrame:IsShown()) then
				self:SetWidth(self.width+50);
			else
				self:SetWidth(self.width+30);
			end
			self:SetHeight((listSize * UIDROPDOWNMENU_BUTTON_HEIGHT) + (UIDROPDOWNMENU_BORDER_HEIGHT * 2))
		end
	end
	local function List_Create(parent)
		local f = CreateFrame("Button", parent:GetName().."Texture", parent);
		f:SetToplevel(true);
		f:Raise();
		f.text = f:CreateFontString();
		f.buttons = setmetatable({},{__index=function(t,i)
			local b = ListButton_Create(f);
			if (i > 1) then
				b:SetPoint("TOPLEFT", t[i-1], "BOTTOMLEFT");
			else
				b:SetPoint("TOPLEFT", 15, -15);
			end
			t[i] = b;
			return b;
		end});
		local s = CreateFrame("ScrollFrame", f:GetName().."ScrollFrame", f, "FauxScrollFrameTemplate");
		s:SetPoint("TOPLEFT", 12, -14);
		s:SetPoint("BOTTOMRIGHT", -36, 13);
		s:SetScript("OnVerticalScroll", function()
			FauxScrollFrame_OnVerticalScroll(UIDROPDOWNMENU_BUTTON_HEIGHT, function() List_Update(f) end)
		end);
		f.scrollFrame = s;
		f:SetBackdrop{
			bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
			edgeFile = "Interface\\DialogFrame\\UI-DialogBox-Border",
			insets = {left = 11, right = 12, top = 12, bottom = 11},
			tile = true, tileSize = 32, edgeSize = 32,
		};
		f:SetScript("OnShow", function(self) List_UpdateWidth(self); List_Update(self); end);
		f:SetScript("OnHide", f.Hide);
		f:SetScript("OnClick", f.Hide);
		f:SetPoint("TOPLEFT", parent, "BOTTOMLEFT", 6, 8);
		f:Hide();
		return f;
	end
	getglobal(f:GetName().."Button"):SetScript("OnClick", function(self)
		local list = self.list;
		if (list) then
			if (list:IsShown()) then
				list:Hide();
			else
				list:Show();
			end
		else
			self.list = List_Create(self:GetParent());
			self.list:Show();
		end
	end);
	return f;
end
----------------------------------------------------------------------------------------------------
function NaturOptions:CreatePanel(name)
	local p = CreateFrame("Frame", self:GetName()..name, self, "OptionFrameBoxTemplate");
	p:SetBackdropBorderColor(.4, .4, .4);
	p:SetBackdropColor(.15, .15, .15, .75);
	getglobal(p:GetName().."Title"):SetText(name);
	return p;
end
----------------------------------------------------------------------------------------------------
-- Go!
NaturOptions:OnLoad();