local wombat = LibStub:NewLibrary("LibWombat",200800512);
	assert(wombat,"LibWombat failed to load in 'LibWombat.lua' on line 1");
----------------------------------------------------------------------------------------------------
local watcher = getglobal("LibWombatWatcherFrame") or CreateFrame("Frame","LibWombatWatcherFrame");
watcher:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
-- Added events for NaturCombat
watcher:RegisterEvent("PLAYER_ENTERING_WORLD");
watcher:RegisterEvent("VARIABLES_LOADED");
watcher:RegisterEvent("UNIT_SPELLCAST_START");
watcher:RegisterEvent("UNIT_SPELLCAST_STOP");
watcher:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START");
watcher:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP");
watcher:RegisterEvent("UNIT_AURA");
watcher:RegisterEvent("PLAYER_TARGET_CHANGED");
--
wombat.parser = wombat.parser or {};
local CleanParser = function()
	for event,list in pairs(wombat.parser) do
		local exists = false;
		for serial,callback in pairs(list) do exists = true; end
		if (not exists) then wombat.parser[event] = nil; end
	end
end;
----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
function wombat:NewParser(target)
	function target:StartParsing(event,method)
		if (type(event) ~= "string") or (type(method) ~= "function") then return; end
		wombat.parser[event] = wombat.parser[event] or {};
		wombat.parser[event][target] = method;
	end
	function target:StopParsing(event)
		if (not wombat.parser[event]) then return; end
		wombat.parser[event][target] = nil;
		CleanParser();
	end
	function target:StopAllParsing(event)
		for event,list in pairs(wombat.parser) do
			if (list[target]) then wombat.parser[event][target] = nil; end
		end
		CleanParser();
	end
end
----------------------------------------------------------------------------------------------------
watcher:SetScript("OnEvent",function(...)
	local event = select(2, ...);
	if (event == "COMBAT_LOG_EVENT_UNFILTERED") then
		local when,what = select(3,...);
		if (wombat.parser[what]) then
			local data = {select(5,...)};
			for k,callback in pairs(wombat.parser[what]) do
				callback(when,what,unpack(data));
			end
		end
	else
		if (wombat.parser[event]) then
			local data = {select(3, ...)};
			for k, callback in pairs(wombat.parser[event]) do
				callback(unpack(data));
			end
		end
	end
end);