local addon = LibStub:NewLibrary("NaturCombat",20080514);
assert(addon,"NaturCombatTimers failed to load in 'NaturCombatTimers\addon\spells.lua' on line 1");
----------------------------------------------------------------------------------------------------
addon.spelldata = {}; -- lookup table used for data storage, stored by spellid
addon.spellkeys = {}; -- lookup table used for spell names that default to a spellid
addon.spellmeta = {};
	addon.spellmeta.__newindex = function(tbl,key,value)
		local name = GetSpellInfo(key);
		if (not addon.spelldata[key]) then addon.spelldata[key] = value; end
		if (not addon.spellkeys[name]) then addon.spellkeys[name] = key; end
	end;
	addon.spellmeta.__index = function(tbl,key)
		local name,rank,icon,_,_,_,castTime = GetSpellInfo(key);
		if (not addon.spelldata[key]) then key = addon.spellkeys[name]; end
		local data = addon.spelldata[key] or {};
		data.id, data.name, data.rank, data.icon, data.castTime = key, name, rank, icon, castTime/1000;
		return data;
	end;
addon.spells = setmetatable({},addon.spellmeta);
function addon:GetSpellData(id)
	if (id) then return addon.spells[id]; end
end;
----------------------------------------------------------------------------------------------------
-- RACIALS
addon.spells[20600] = {duration=20,cooldown=180,type="BUFF"}; -- Perception
addon.spells[7744] = {duration=5,cooldown=120,type="BUFF"}; -- Will of the Forsaken
addon.spells[20594] = {duration=8,cooldown=180,type="BUFF"}; -- Stoneform
addon.spells[26297] = {duration=10,cooldown=180,type="BUFF"}; -- Berseking
addon.spells[28880] = {duration=15,cooldown=180,type="BUFF"}; -- Gift of the Naaru
addon.spells[20549] = {duration=2,type="DEBUFF"}; -- War Stomp
addon.spells[25467] = {duration=24,dot=true,type="DEBUFF"}; -- Devouring Plague
addon.spells[25446] = {duration=15,dot=true,type="DEBUFF"}; -- Starshards
-- Misc.
addon.spells[5530] = {duration=3,stun=true,type="DEBUFF"}; -- Mace Stun